@if($results->isNotEmpty())
@foreach($results as $result)
    <tr class="{{$result->taxid}} {{$result->name_slug}}" id="item_row_{{ $item_row }}">
        <td class="text-center">
            <button type="button"
                    onclick="$('#item_row_{{ $item_row }}').remove();"
                    class="btn btn-xs btn-danger"
                    style="margin-bottom: 0; margin-top: 4px;">
                <i class="fa fa-times"></i>
            </button>
            <input type="hidden" name="item[{{ $item_row }}][cfdi_download_id]" value="{{$result->cfdi_download_id}}">
        </td>
        <td class="text-center">
            <div class="form-group form-group-sm">
                {!! Form::select('item[' . $item_row . '][customer_type]', $diot_customer_types,$result->customer_type, ['class' => 'form-control input-sm col-customer-type', 'placeholder' => __('general.text_select'),'id' => 'item_customer_type_' . $item_row,'data-row' => $item_row,'required']) !!}
            </div>
        </td>
        <td class="text-center">
            <div class="form-group form-group-sm">
                {!! Form::select('item[' . $item_row . '][operation_type]', $diot_operation_types,$result->operation_type, ['class' => 'form-control input-sm col-operation-type', 'placeholder' => __('general.text_select'),'id' => 'item_operation_type_' . $item_row,'data-row' => $item_row,'required']) !!}
            </div>
        </td>
        <td class="text-center">
            <div class="form-group form-group-sm">
                {!! Form::text('item[' . $item_row . '][taxid]', $result->taxid, ['class' => 'form-control input-sm text-center col-taxid','id' => 'item_taxid_' . $item_row,'required']) !!}
            </div>
        </td>
        <td class="text-center">
            <div class="form-group form-group-sm">
                {!! Form::text('item[' . $item_row . '][numid]', $result->numid, ['class' => 'form-control input-sm text-center col-numid','id' => 'item_numid_' . $item_row]) !!}
            </div>
        </td>
        <td class="text-center">
            <div class="form-group form-group-sm">
                {!! Form::text('item[' . $item_row . '][name]', $result->name, ['class' => 'form-control input-sm col-name','id' => 'item_name_' . $item_row]) !!}
            </div>
        </td>
        <td style="padding-left: 0;">
            <button type="button"
                    onclick="$('#item_customer_type_{{ $item_row }}').val() != '05'? $('.{{ $result->taxid }}').remove() : $('.{{ $result->name_slug }}').remove();"
                    class="btn btn-xs btn-warning"
                    style="margin-bottom: 0; margin-top: 4px;" title="@lang('base/diot.help_line_name')">
                <i class="fa fa-times"></i>
            </button>
        </td>
        <td class="text-center">
            <div class="form-group form-group-sm">
                {!! Form::select('item[' . $item_row . '][foreign_country_code]',$diot_countries, $result->foreign_country_code, ['class' => 'form-control input-sm col-foreign-country-code', 'placeholder' => __('general.text_select'), 'id' => 'item_foreign_country_code_' . $item_row]) !!}
            </div>
        </td>
        <td class="text-center">
            <div class="form-group form-group-sm">
                {!! Form::text('item[' . $item_row . '][foreign_nationality]', $result->foreign_nationality, ['class' => 'form-control input-sm col-foreign-nationality','id' => 'item_foreign_nationality_' . $item_row]) !!}
            </div>
        </td>
        <td class="text-center">
            <div class="form-group form-group-sm">
                {!! Form::number('item[' . $item_row . '][iva_15_16]', $result->iva_15_16, ['class' => 'form-control input-sm text-right col-iva-15-16', 'id' => 'item_iva_15_16_' . $item_row, 'step' => 'any']) !!}
            </div>
        </td>
        <td class="text-center hidden">
            <div class="form-group form-group-sm">
                {!! Form::number('item[' . $item_row . '][iva_15]', $result->iva_15, ['class' => 'form-control input-sm text-right col-iva-15', 'id' => 'item_iva_15_' . $item_row, 'step' => 'any']) !!}
            </div>
        </td>
        <td class="text-center">
            <div class="form-group form-group-sm">
                {!! Form::number('item[' . $item_row . '][iva_15_16_not]', $result->iva_15_16_not, ['class' => 'form-control input-sm text-right col-iva-15-16-not', 'id' => 'item_iva_15_16_not_' . $item_row, 'step' => 'any']) !!}
            </div>
        </td>
        <td class="text-center">
            <div class="form-group form-group-sm">
                {!! Form::number('item[' . $item_row . '][iva_10_11]', $result->iva_10_11, ['class' => 'form-control input-sm text-right col-iva-10-11', 'id' => 'item_iva_10_11_' . $item_row, 'step' => 'any']) !!}
            </div>
        </td>
        <td class="text-center hidden">
            <div class="form-group form-group-sm">
                {!! Form::number('item[' . $item_row . '][iva_10]', $result->iva_10, ['class' => 'form-control input-sm text-right col-iva-10', 'id' => 'item_iva_10_' . $item_row, 'step' => 'any']) !!}
            </div>
        </td>
        <td class="text-center">
            <div class="form-group form-group-sm">
                {!! Form::number('item[' . $item_row . '][iva_10_11_not]', $result->iva_10_11_not, ['class' => 'form-control input-sm text-right col-iva-10-11-not', 'id' => 'item_iva_10_11_not_' . $item_row, 'step' => 'any']) !!}
            </div>
        </td>
        <td class="text-center">
            <div class="form-group form-group-sm">
                {!! Form::number('item[' . $item_row . '][border_stimulation]', $result->border_stimulation, ['class' => 'form-control input-sm text-right col-border-stimulation', 'id' => 'item_border_stimulation_' . $item_row, 'step' => 'any']) !!}
            </div>
        </td>
        <td class="text-center">
            <div class="form-group form-group-sm">
                {!! Form::number('item[' . $item_row . '][border_stimulation_not]', $result->border_stimulation_not, ['class' => 'form-control input-sm text-right col-border-stimulation-not', 'id' => 'item_border_stimulation_not_' . $item_row, 'step' => 'any']) !!}
            </div>
        </td>
        <td class="text-center">
            <div class="form-group form-group-sm">
                {!! Form::number('item[' . $item_row . '][iva_0]', $result->iva_0, ['class' => 'form-control input-sm text-right col-iva-0', 'id' => 'item_iva_0_' . $item_row, 'step' => 'any']) !!}
            </div>
        </td>
        <td class="text-center">
            <div class="form-group form-group-sm">
                {!! Form::number('item[' . $item_row . '][exempt]', $result->exempt, ['class' => 'form-control input-sm text-right col-exempt', 'id' => 'item_exempt_' . $item_row, 'step' => 'any']) !!}
            </div>
        </td>
        <td class="text-center">
            <div class="form-group form-group-sm">
                {!! Form::number('item[' . $item_row . '][iva_detained]', $result->iva_detained, ['class' => 'form-control input-sm text-right col-iva-detained', 'id' => 'item_iva_detained_' . $item_row, 'step' => 'any']) !!}
            </div>
        </td>
        <td class="text-center">
            <div class="form-group form-group-sm">
                {!! Form::number('item[' . $item_row . '][iva_dev_dis_bon]', $result->iva_dev_dis_bon, ['class' => 'form-control input-sm text-right col-iva-dev-dis-bon', 'id' => 'item_iva_dev_dis_bon_' . $item_row, 'step' => 'any']) !!}
            </div>
        </td>
    </tr>
@php
    $item_row++;
@endphp
@endforeach
<!-- Agregar nuevo item -->
<tr id="add_item">
    <td class="text-center">
        <button type="button" onclick="addItem();"
                class="btn btn-xs btn-primary"
                style="margin-bottom: 0;">
            <i class="fa fa-plus"></i>
        </button>
    </td>
    <td class="text-right" colspan="20"></td>
</tr>
@else
<tr>
    <td colspan="20" class="text-center">@lang('general.text_no_results')</td>
</tr>
@endforelse
