<!-- modal about -->
<div class="modal fade" id="modal_document_type_create_per_branch_office" role="dialog">
    <div class="modal-dialog modal-lg">
        {!! Form::open(['route' => 'document-types/create-per-branch-office','method' => 'POST','class' => '','role' => 'form','id'=>'form_modal_document_type_create_per_branch_office']) !!}
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-save"></i> {!! __('base/document_type.text_modal_create_per_branch_office') !!}</h4>
            </div>
            <div class="modal-body">
                <!-- Mensajes -->
                <div id="modal_general_messages">
                </div>
                <div class="row">
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('branch_office_id') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('branch_office_id', __('base/document_type.entry_branch_office_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                            {!! Form::select('branch_office_id', $branch_offices,null, ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                            @if ($errors->has('branch_office_id'))
                                <span class="help-block"><small>{{ $errors->first('branch_office_id') }}</small></span>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12col-xs-12">
                        <div class="table-responsive table-data">
                            <table class="table table-striped table-hover">
                                <thead>
                                <tr>
                                    <th class="text-left">
                                        {{__('base/document_type.column_name')}}
                                    </th>
                                    <th class="text-center">
                                        {{__('base/document_type.column_prefix')}}
                                    </th>
                                    <th class="text-center">
                                        {{__('base/document_type.column_next_number')}}
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                @php
                                    $item_row = 1;
                                    $items = old('item',$document_types);
                                @endphp
                                @foreach ($items as $item_row => $item)
                                    @php
                                        $item = !empty(old('item.' . $item_row . '')) ? (object) old('item.' . $item_row) : $item;
                                    @endphp
                                    <tr class="">
                                        <td class="text-left">
                                            <!-- input hidden -->
                                            <input type="hidden" id="item_id_{{ $item_row }}"
                                                   name="item[{{ $item_row }}][id]"
                                                   value="{{ old('item.' . $item_row . '.id',$item->id) }}">
                                            <!-- /.input hidden -->
                                            <div class="form-group form-group-sm{{ $errors->has('item.'.$item_row.'.name') ? ' has-error' : '' }}">
                                                {!! Form::text('item[' . $item_row . '][name]', old('item.' . $item_row . '.name',$item->name), ['class' => 'form-control input-sm', 'required','id' => 'item_name_' . $item_row]) !!}
                                                @if ($errors->has('item.'.$item_row.'.name'))
                                                    <span class="help-block"><small>{{ $errors->first('item.'.$item_row.'.name') }}</small></span>
                                                @endif
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <div class="form-group form-group-sm{{ $errors->has('item.'.$item_row.'.prefix') ? ' has-error' : '' }}">
                                                {!! Form::text('item[' . $item_row . '][prefix]', old('item.' . $item_row . '.prefix'), ['class' => 'form-control input-sm text-center', 'required','id' => 'item_prefix_' . $item_row, 'placeholder' => $item->prefix]) !!}
                                                @if ($errors->has('item.'.$item_row.'.prefix'))
                                                    <span class="help-block"><small>{{ $errors->first('item.'.$item_row.'.prefix') }}</small></span>
                                                @endif
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <div class="form-group form-group-sm{{ $errors->has('item.'.$item_row.'.current_number') ? ' has-error' : '' }}">
                                                {!! Form::number('item[' . $item_row . '][current_number]', old('item.' . $item_row . '.current_number',1), ['class' => 'form-control input-sm text-center', 'required','id' => 'item_current_number_' . $item_row, 'step' => 'any']) !!}
                                                @if ($errors->has('item.'.$item_row.'.current_number'))
                                                    <span class="help-block"><small>{{ $errors->first('item.'.$item_row.'.current_number') }}</small></span>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="pull-right">
                    {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                    &nbsp;&nbsp;&nbsp;
                    <button type="button" class="btn btn-sm btn-default" data-dismiss="modal">{{ __('general.button_close') }}</button>
                </div>
            </div>
        </div>
        {!! Form::close() !!}
    </div>
</div>
<!-- /modal about -->
