<!-- modal about -->
<div class="modal fade" id="modal_perception_search" role="dialog">
    <div class="modal-dialog modal-lg">
        {!! Form::open(['route' => 'perceptions/search','method' => 'POST','class' => '','role' => 'form','id'=>'form_modal_perception_search']) !!}
        @if(!empty($active_btn_select))
            {!! Form::hidden('active_btn_select', old('active_btn_select','1'), ['class' => 'form-control']) !!}
        @endif
        {!! Form::hidden('row_origin', old('row_origin',$row_origin), ['class' => 'form-control']) !!}
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-search"></i> {!! __('catalogs/perception.text_modal_search') !!}</h4>
            </div>
            <div class="modal-body">
                <!-- Mensajes -->
                <div id="modal_general_messages">
                </div>
                <div class="row">
                    <div class="col-sm-12 mb-3">
                        <div class="input-group input-group-sm">
                            {!! Form::text('filter_search', old('filter_search'), ['class' => 'form-control', 'placeholder' => __('catalogs/perception.text_modal_search_help1')]) !!}
                            <span class="input-group-btn">
                              <button type="submit" class="btn btn-info">@lang('general.button_search')</button>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="table-responsive table-data">
                    <table class="table table-striped table-hover table-condensed" id="perceptions">
                        <thead>
                        <tr>
                            <th class="text-center" width="15%">@lang('catalogs/perception.column_code')</th>
                            <th class="text-left">@lang('catalogs/perception.column_name')</th>
                            <th class="text-center" width="15%"></th>
                        </tr>
                        </thead>
                        <tbody>
                        {!! $html_perceptions !!}
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <div class="pull-right">
                    <button type="button" class="btn btn-sm btn-default"
                            data-dismiss="modal">{{ __('general.button_close') }}</button>
                </div>
            </div>
        </div>
        {!! Form::close() !!}
    </div>
</div>
<!-- /modal about -->
<script type="text/javascript">
    $(function () {
        $("#form_modal_perception_search").submit( function (e) {
            e.preventDefault();
            $.ajax({
                url: $(this).attr('action'),
                type: "POST",
                dataType: "JSON",
                data: $("#form_modal_perception_search").serialize(),
                success: function (data) {
                    if (data) {
                        $("#form_modal_perception_search #perceptions tbody").html(data.html);
                    }
                },
                error: function (error, textStatus, errorThrown) {
                    if (error.status == 422) {
                        var message = error.responseJSON.error;
                        $("#modal_general_messages").html(alertMessage("danger", message));
                    } else if (error.status == 403 || error.status == 401) {
                        location.href = "{{ route('login') }}";
                    } else {
                        alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                    }
                }
            });
        });
    });
</script>