@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('reports/account_payable_aging.document_title'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
    <link href="{{ asset('gentelella/plugins/google-code-prettify/bin/prettify.min.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('reports/income_expenses.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">

                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Filtros -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_content">
                            <div class="filter-data">
                                {!! Form::open(['route' => 'income-expenses.index','method' => 'GET','class' => '','role' => 'form','id'=>'form']) !!}
                                <div class="row">
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('filter_year', __('general.text_year') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('filter_year', $years,request()->input('filter_year'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('filter_customer_remission_include', __('general.text_customer_remission_include') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('filter_customer_remission_include', $customer_remission_includes,request()->input('filter_customer_remission_include'), ['class' => 'form-control', 'placeholder' => __('general.text_no_include')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('', '&nbsp;' . '', ['class' => 'control-label'])) !!}<br/>
                                            {!! Form::button(__('general.button_search'),['type' => 'submit', 'class' => 'btn btn-sm btn-default']) !!}
                                            &nbsp;
                                            <a href="{{route('income-expenses/export-to-excel',request()->except('page'))}}" class="btn btn-sm btn-excel">
                                                @lang('general.button_export_to_excel')
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Filtros -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_report') {{request()->input('filter_year')}}</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <!-- Filtros -->

                            <!-- /Filtros -->
                            <!-- Datos -->
                            <div class="table-responsive table-data table-dropdown">
                                <table class="table table-striped table-hover table-condensed">
                                    <thead>
                                    <tr class="mini">
                                        <th class="text-center">
                                            @lang('reports/income_expenses.column_month')
                                        </th>
                                        <th class="text-center" style="width: 10px;">
                                        </th>
                                        <th class="text-right">
                                            @lang('reports/income_expenses.column_amount_untaxed_income')
                                        </th>
                                        <th class="text-right">
                                            @lang('reports/income_expenses.column_amount_iva')
                                        </th>
                                        <th class="text-right">
                                            @lang('reports/income_expenses.column_amount_ieps')
                                        </th>
                                        <th class="text-right">
                                            @lang('reports/income_expenses.column_amount_ret_iva')
                                        </th>
                                        <th class="text-right">
                                            @lang('reports/income_expenses.column_amount_ret_isr')
                                        </th>
                                        <th class="text-right">
                                            @lang('reports/income_expenses.column_amount_total_income')
                                        </th>
                                        <th class="text-center" style="width: 10px;">
                                        </th>
                                        <th class="text-right">
                                            @lang('reports/income_expenses.column_amount_untaxed_expenses')
                                        </th>
                                        <th class="text-right">
                                            @lang('reports/income_expenses.column_amount_iva')
                                        </th>
                                        <th class="text-right">
                                            @lang('reports/income_expenses.column_amount_ieps')
                                        </th>
                                        <th class="text-right">
                                            @lang('reports/income_expenses.column_amount_ret_iva')
                                        </th>
                                        <th class="text-right">
                                            @lang('reports/income_expenses.column_amount_ret_isr')
                                        </th>
                                        <th class="text-right">
                                            @lang('reports/income_expenses.column_amount_total_expenses')
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($results as $key => $result)
                                    <tr class="mini" style="{{$result->style == 'total' ? 'font-weight: bold;' : ''}}" >
                                        <td class="text-center">{{$result->month}}</td>
                                        <td class="text-center"></td>
                                        <td class="text-right">{{$result->income_amount_untaxed}}</td>
                                        <td class="text-right">{{$result->income_amount_iva}}</td>
                                        <td class="text-right">{{$result->income_amount_ieps}}</td>
                                        <td class="text-right">{{$result->income_amount_ret_iva}}</td>
                                        <td class="text-right">{{$result->income_amount_ret_isr}}</td>
                                        <td class="text-right">{{$result->income_amount_total}}</td>
                                        <td class="text-center"></td>
                                        <td class="text-right">{{$result->expenses_amount_untaxed}}</td>
                                        <td class="text-right">{{$result->expenses_amount_iva}}</td>
                                        <td class="text-right">{{$result->expenses_amount_ieps}}</td>
                                        <td class="text-right">{{$result->expenses_amount_ret_iva}}</td>
                                        <td class="text-right">{{$result->expenses_amount_ret_isr}}</td>
                                        <td class="text-right">{{$result->expenses_amount_total}}</td>
                                    </tr>
                                    @empty
                                        <tr>
                                            <td colspan="15" class="text-center">@lang('general.text_no_results')</td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                            <!-- /Datos -->
                            <div class="ln_solid"></div>
                            <!-- Pie de pagina -->
                            <div class="row">
                                &nbsp;
                            </div>
                            <!-- /Pie de pagina -->
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/bootstrap-wysiwyg/js/bootstrap-wysiwyg.min.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/jquery.hotkeys/jquery.hotkeys.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/google-code-prettify/src/prettify.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            /*Configura datepicker*/
            moment.locale("{{ substr(app()->getLocale(),0,2) }}");
            $("#form input[name='filter_date_from']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false
            }, function (chosen_date) {
                $("#form input[name='filter_date_from']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });
            $("#form input[name='filter_date_to']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false,
            }, function (chosen_date) {
                $("#form input[name='filter_date_to']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });


        });

    </script>
@endsection
