<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_credit_note->documentType->name}}-{{$customer_credit_note->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 310px;
            margin-bottom: 225px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_credit_note->company_id) }}    !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_credit_note->company_id) }}    !important;
        }
    </style>
</head>
<body style="background-color: white;">
@php
    //Obtiene datos del Cfdi33
    $draft = (int) $customer_credit_note->status == \App\Models\Sales\CustomerInvoice::DRAFT ? true : false;
    $cfdi33 = empty($data['cfdi33']) ? null : $data['cfdi33'];
    $conceptos = null;
    if($cfdi33){
        $conceptos = $cfdi33->conceptos;
        $conceptos = $conceptos();
    }
@endphp
<section class="header" style="top: -287px;">
    @if($cfdi33 && $customer_credit_note->customerInvoiceCfdi->pac->test)
    <h2 style="position: absolute; left: 37%; top: -15px; color: red;">*** @lang('general.text_test_cfdi') ***</h2>
    @endif
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="55%" class="text-left">
                <span class="text-primary">{{ mb_strtoupper($customer_credit_note->company->comercial_name) }}</span>
            </td>
            <td width="45%" class="text-right">
                <h1>{{ mb_strtoupper($customer_credit_note->documentType->name) }}</h1>
            </td>
        </tr>
        <tr>
            <td width="55%" style="vertical-align: top; padding-top: 10px; position: relative;">
                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_credit_note->company_id,$customer_credit_note->project_id) }}"
                    class="invoice-logo" />
                @elseif(!empty(setting('branch_office_logo_docs')))
                <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_credit_note->company_id,$customer_credit_note->branch_office_id) }}"
                    class="invoice-logo" />
                @else
                <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_credit_note->company_id) }}"
                    class="invoice-logo" />
                @endif
            </td>
            <td width="45%" class="text-right text-company" style="vertical-align: top; padding-top: 10px; height: 118px;">
                <strong>{{ mb_strtoupper($customer_credit_note->company->name) }}</strong>
                <br/>
                {{ $data['tax_regimen'] ?? ($customer_credit_note->taxRegimen->name_sat ?? $customer_credit_note->company->taxRegimen->name_sat) }}
                @if(!empty($customer_credit_note->company->address_1) || !empty($customer_credit_note->company->address_2) || !empty($customer_credit_note->company->address_3) || !empty($customer_credit_note->company->address_4))
                    <br/>
                    {{ $customer_credit_note->company->address_1 ?? '' }} {{ $customer_credit_note->company->address_2 ?? '' }} {{ $customer_credit_note->company->address_3 ?? '' }} {{ $customer_credit_note->company->address_4 ?? '' }}
                @endif
                @if(!empty($customer_credit_note->company->city->name) || !empty($customer_credit_note->company->state->name))
                    <br/>
                    {{ !empty($customer_credit_note->company->city->name) ? $customer_credit_note->company->city->name . ', ' : '' }}{{ $customer_credit_note->company->state->name ?? '' }}
                @endif
                <br/>
                {{ $customer_credit_note->company->country->name ?? '' }}{!! ($customer_credit_note->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_credit_note->company->postcode : '') !!}
                <br/>
                {{ mb_strtoupper($customer_credit_note->company->taxid) }}
                <br/>
                ---
                <br/>
                {{ $customer_credit_note->company->phone ?? ' ' }}
                <br/>
                {{ $customer_credit_note->company->email ?? ' ' }}
            </td>
        </tr>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary"># {{ $customer_credit_note->name }}</span>
            </td>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary">{{ mb_strtoupper(__('general.text_customer')) }}</span>
            </td>
        </tr>
        <tr>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <strong>@lang('general.text_cfdi_uuid'): </strong>{{ $customer_credit_note->customerInvoiceCfdi->uuid ?? '' }}
                <br/>
                <strong>@lang('base/document_type.entry_cfdi_type_id'): </strong>{{ $customer_credit_note->documentType->cfdiType->name_sat ?? '' }}
                <br/>
                <strong>@lang('sales/customer_credit_note.entry_date'): </strong>{{ \App\Helpers\Helper::convertSqlToDateTime($customer_credit_note->date) }}
                <br/>
                <strong>@lang('sales/customer_credit_note.entry_payment_term_id'): </strong>{{ $customer_credit_note->paymentTerm->name }}
                <br/>
                <strong>@lang('sales/customer_credit_note.entry_cfdi_use_id'): </strong>{{ $customer_credit_note->cfdiUse->name_sat }}
                <br/>
                <strong>@lang('general.text_issued_in'): </strong>{{ $customer_credit_note->branchOffice->name ?? '' }} {!! ($customer_credit_note->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . ($cfdi33['LugarExpedicion'] ?? $customer_credit_note->branchOffice->postcode) : '') !!}
                <br/>
            </td>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <strong>{{ mb_strtoupper(!empty($cfdi33->Receptor['Nombre']) ? $cfdi33->Receptor['Nombre'] : $customer_credit_note->customer->name) }}</strong>
                @if(!empty($customer_credit_note->customer->address_1) || !empty($customer_credit_note->customer->address_2) || !empty($customer_credit_note->customer->address_3) || !empty($customer_credit_note->customer->address_4))
                    <br/>
                    {{ $customer_credit_note->customer->address_1 ?? '' }} {{ $customer_credit_note->customer->address_2 ?? '' }} {{ $customer_credit_note->customer->address_3 ?? '' }} {{ $customer_credit_note->customer->address_4 ?? '' }}
                @endif
                @if(!empty($customer_credit_note->customer->city->name) || !empty($customer_credit_note->customer->state->name))
                    <br/>
                    {{ !empty($customer_credit_note->customer->city->name) ? $customer_credit_note->customer->city->name . ', ' : '' }}{{ $customer_credit_note->customer->state->name ?? '' }}
                @endif
                <br/>
                {{ $customer_credit_note->customer->country->name ?? '' }}{!! ($customer_credit_note->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_credit_note->customer->postcode : '') !!}
                <br/>
                {{ mb_strtoupper($cfdi33->Receptor['Rfc'] ?? $customer_credit_note->customer->taxid) }}
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="footer">
    <div>
    <table cellpadding="0" cellspacing="0" class="table-footer" width="100%"
           style="margin-top: 5px; table-layout: fixed;">
        <tr>
            <td width="23%" class="text-center" style="vertical-align: middle; padding: 5px; word-wrap:break-word;">
                @if(!empty($cfdi33))
                <img src="{{ $data['qr'] }}" width="137px" style="margin: 9px 0;"/>
                @endif
            </td>
            <td width="77%" style="vertical-align: middle; padding: 5px; word-wrap:break-word; height: 180px;">
                @if(!empty($cfdi33))
                <strong>@lang('general.text_cfdi_tfd_cadena_origen') </strong><br/>
                <small>{{ $data['tfd_cadena_origen'] }}</small>
                <br/>
                <strong>@lang('general.text_cfdi_tfd_sello_cfdi') </strong><br/>
                <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloCFD'] }}</small>
                <br/>
                <strong>@lang('general.text_cfdi_tfd_sello_sat') </strong><br/>
                <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloSAT'] }}</small>
                <br/>
                @endif
            </td>
        </tr>
    </table>
    </div>
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_credit_note->status == \App\Models\Sales\CustomerInvoice::CANCEL)
    <section class="watermark" style="bottom: 450px !important;">
        @if(!empty($customer_credit_note->customerInvoiceCfdi->uuid))
            <span>@lang('general.text_canceled_cfdi')</span>
        @else
            <span>@lang('general.text_canceled')</span>
        @endif
    </section>
@endif
@if($draft)
    <section class="watermark" style="left: 170px; bottom: 450px !important;">
        <span>@lang('general.text_pre_customer_credit_note')</span>
    </section>
@endif
<section>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
        <thead>
        <tr>
            <th class="text-left">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_name')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_sat_product_id')) }}</th>
            <th width="14%">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_unit_measure_id')) }}</th>
            <th width="7%">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_quantity')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_price_unit')) }}</th>
            <th width="11%">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_amount_untaxed')) }}</th>
        </tr>
        </thead>
        <tbody>
        @foreach($customer_credit_note->customerActiveInvoiceLines as $result)
            <tr>
                <td>
                @if(!empty(setting('show_product_code_on_pdf')))
                    {{$result->product->code ?? 'N/A'}} -
                @endif
                {!! nl2br($result->name) !!}
                </td>
                <td class="text-center">{{ $result->satProduct->code }}</td>
                <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_credit_note->company_id)) }}</td>
                <td class="text-right">{{ money($result->amount_untaxed,$customer_credit_note->currency->code,true) }}</td>
            </tr>
        @endforeach
        </tbody>
        <tfoot>
        <tr>
            <td colspan="4" class="text-center" style="vertical-align: bottom;">
                <span style="line-height: 16px;">
                    ***({{\App\Helpers\Helper::numberToWordCurrency($customer_credit_note->amount_total,$customer_credit_note->currency->code,$customer_credit_note->currency->decimal_place)}})***
                </span>
            </td>
            <td colspan="1" class="text-right" style="vertical-align: top; padding-right: 4px;">
                <strong>@lang('general.text_amount_untaxed')</strong><br/>
                @if($customer_credit_note->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_credit_note->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
            </td>
            <td class="text-right">
                {{ money($customer_credit_note->amount_untaxed,$customer_credit_note->currency->code,true) }}<br/>
                @if($customer_credit_note->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_credit_note->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;">{{ money(abs($result->amount_tax),$customer_credit_note->currency->code,true) }}</span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ money($customer_credit_note->amount_total,$customer_credit_note->currency->code,true) }}</strong></span>
            </td>
        </tr>
        </tfoot>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="50%" style="vertical-align: top; padding: 5px;">
                <strong>@lang('sales/customer_credit_note.entry_payment_way_id'): </strong>{{ $customer_credit_note->paymentWay->name_sat }}
                <br/>
                <strong>@lang('sales/customer_credit_note.entry_payment_method_id'): </strong>{{ $customer_credit_note->paymentMethod->name_sat }}
                <br/>
                <strong>@lang('sales/customer_credit_note.entry_currency_id'): </strong>{{ $customer_credit_note->currency->code }}{!! ($customer_credit_note->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/customer_credit_note.entry_currency_value').':</strong> '.round($customer_credit_note->currency_value,4) :'') !!}
                <br/>
            </td>
            <td width="50%" style="vertical-align: top; padding: 5px;">
                @if(!empty($cfdi33))
                <strong>@lang('general.text_cfdi_certificado'): </strong>{{ $cfdi33['NoCertificado'] }}
                <br/>
                <strong>@lang('general.text_cfdi_tfd_no_certificado_sat'): </strong>{{ $cfdi33->complemento->timbreFiscalDigital['NoCertificadoSAT'] }}
                <br/>
                <strong>@lang('general.text_cfdi_tfd_fecha_timbrado'): </strong>{{ \App\Helpers\Helper::convertSqlToDateTime(str_replace('T',' ',$cfdi33->complemento->timbreFiscalDigital['FechaTimbrado'])) }}
                <br/>
                @endif
            </td>
        </tr>
    </table>
    </div>
    @if(!empty($customer_credit_note->cfdi_relation_id))
        <div>
        <p style="margin-bottom: 2px;">
            <strong>@lang('sales/customer_credit_note.tab_relations') - {{ $customer_credit_note->cfdiRelation->name_sat }} </strong>
        </p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                    @if($customer_credit_note->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_credit_note->customerInvoiceRelations as $result)
                            {{$result->relation->name ?? ''}}<br/>
                        @endforeach
                    @endif
                </td>
                <td width="85%" style="vertical-align: middle; padding: 5px;">
                    @if($customer_credit_note->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_credit_note->customerInvoiceRelations as $result)
                            {{$result->uuid_related}}<br/>
                        @endforeach
                    @endif
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_credit_note->comment))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_credit_note.entry_comment')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;">
                    {!! nl2br($customer_credit_note->comment) !!}
                </td>
            </tr>
        </table>
        </div>
    @endif
</section>
</body>
</html>
