<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_credit_note->documentType->name}}-{{$customer_credit_note->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 155px;
            margin-bottom: 27px;
            margin-left: 23px;
            margin-right: 23px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_credit_note->company_id) }}     !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_credit_note->company_id) }}     !important;
        }
        .cell-primary {
            border: 1px solid {{ \App\Helpers\Helper::companyColorPrimary($customer_credit_note->company_id) }}     !important;
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_credit_note->company_id) }}     !important;
            color: #ffffff;
            font-weight: bold;
            padding: 5px 2px;
            text-align: center !important;
            vertical-align: middle !important;
            text-transform: uppercase;
            font-size: 8pt;
        }
        .cell-primary-border-line {
            border: 1px solid #dddddd !important;
            border-radius: 0 0 3px 3px;
            padding: 5px 1px;
        }
    </style>
</head>
<body style="background-color: white;">
@php
//Obtiene datos del Cfdi33
$draft = (int) $customer_credit_note->status == \App\Models\Sales\CustomerInvoice::DRAFT ? true : false;
$cfdi33 = empty($data['cfdi33']) ? null : $data['cfdi33'];
$conceptos = null;
if($cfdi33){
    $conceptos = $cfdi33->conceptos;
    $conceptos = $conceptos();
}
@endphp
<section class="header" style="top: -127px;">
    @if($cfdi33 && $customer_credit_note->customerInvoiceCfdi->pac->test)
    <h2 style="position: absolute; left: 0; top: -25px; color: red;">*** @lang('general.text_test_cfdi') ***</h2>
    @endif
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
            <tr>
                <td width="27%" style="vertical-align: top; border-right: 1px solid #333333;">
                    <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
                        <tr>
                            <td width="100%" class="text-center" style="vertical-align: top; height: 140px;">
                                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_credit_note->company_id,$customer_credit_note->project_id) }}" class="invoice-logo" style="max-width: 160px !important;"/>
                                @elseif(!empty(setting('branch_office_logo_docs')))
                                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_credit_note->company_id,$customer_credit_note->branch_office_id) }}" class="invoice-logo" style="max-width: 160px !important;"/>
                                @else
                                    <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_credit_note->company_id) }}" class="invoice-logo" style="max-width: 160px !important;"/>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-center" style="vertical-align: top; ">
                                <h2>{{ mb_strtoupper($customer_credit_note->documentType->name) }}</h2>
                                <br/>
                                <span class="text-primary" style="font-size: 8pt;">{{ mb_strtoupper($customer_credit_note->company->comercial_name) }}</span>
                                <br/>
                                <br/>
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-center" style="vertical-align: top; height: 120px; ">
                                <strong>@lang('base/company.text_transmitter'):</strong><br/>
                                {{ mb_strtoupper($customer_credit_note->company->name) }}
                                @if(!empty($customer_credit_note->company->address_1) || !empty($customer_credit_note->company->address_2) || !empty($customer_credit_note->company->address_3) || !empty($customer_credit_note->company->address_4))
                                    <br/>
                                    {{ $customer_credit_note->company->address_1 ?? '' }} {{ $customer_credit_note->company->address_2 ?? '' }} {{ $customer_credit_note->company->address_3 ?? '' }} {{ $customer_credit_note->company->address_4 ?? '' }}
                                @endif
                                @if(!empty($customer_credit_note->company->city->name) || !empty($customer_credit_note->company->state->name))
                                    <br/>
                                    {{ !empty($customer_credit_note->company->city->name) ? $customer_credit_note->company->city->name . ', ' : '' }}{{ $customer_credit_note->company->state->name ?? '' }}
                                @endif
                                <br/>
                                {{ $customer_credit_note->company->country->name ?? '' }}{!! ($customer_credit_note->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_credit_note->company->postcode : '') !!}
                                <br/>
                                {{ mb_strtoupper($customer_credit_note->company->taxid) }}
                                <br/>
                                ---
                                <br/>
                                {{ $customer_credit_note->company->phone ?? ' ' }}
                                <br/>
                                <span style="text-transform: lowercase;">{{ $customer_credit_note->company->email ?? ' ' }}</span>
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-center" style="vertical-align: top; ">
                                <strong>@lang('base/company.column_tax_regimen'):</strong><br/>
                                {{ $data['tax_regimen'] ?? ($customer_credit_note->taxRegimen->name_sat ?? $customer_credit_note->company->taxRegimen->name_sat) }}
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-center" style="vertical-align: top; padding-top: 10px; height: 120px; ">
                                <strong>@lang('general.text_issued_in'):</strong>
                                @if(!empty($customer_credit_note->branchOffice->address_1) || !empty($customer_credit_note->branchOffice->address_2))
                                    <br/>
                                    {{ $customer_credit_note->branchOffice->address_1 ?? '' }} {{ $customer_credit_note->branchOffice->address_2 ?? '' }}
                                @endif
                                @if(!empty($customer_credit_note->branchOffice->address_3) || !empty($customer_credit_note->branchOffice->address_4))
                                    <br/>
                                    {{ $customer_credit_note->branchOffice->address_3 ?? '' }} {{ $customer_credit_note->branchOffice->address_4 ?? '' }}
                                @endif
                                @if(!empty($customer_credit_note->branchOffice->city->name) || !empty($customer_credit_note->branchOffice->state->name))
                                    <br/>
                                    {{ $customer_credit_note->branchOffice->city->name ?? '' }}, {{ $customer_credit_note->branchOffice->state->name ?? '' }}
                                @endif
                                <br/>
                                {{ $customer_credit_note->branchOffice->country->name ?? '' }}{!! ($customer_credit_note->branchOffice->postcode ? '&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ': ' . ($cfdi33['LugarExpedicion'] ?? $customer_credit_note->branchOffice->postcode) : '') !!}
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-left" style="vertical-align: top; padding-top: 3px; height: 160px;">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-left" style="vertical-align: top; padding-top: 3px; ">
                                <strong>@lang('general.text_cfdi_uuid'):</strong><br/>
                                {{ $customer_credit_note->customerInvoiceCfdi->uuid ?? '' }}
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-left" style="vertical-align: top; padding-top: 3px; ">
                                <strong>@lang('sales/customer_credit_note.entry_date'):</strong><br/>
                                {{ str_replace(' ',' ',\App\Helpers\Helper::convertSqlToDateTime($customer_credit_note->date)) }}
                            </td>
                        </tr>
                        @if(!empty($cfdi33))
                            <tr>
                                <td width="100%" class="text-left" style="vertical-align: top; padding-top: 3px; ">
                                    <strong>@lang('general.text_cfdi_tfd_fecha_timbrado'):</strong><br/>
                                    {{ \App\Helpers\Helper::convertSqlToDateTime(str_replace('T',' ',$cfdi33->complemento->timbreFiscalDigital['FechaTimbrado'])) }}<br>
                                </td>
                            </tr>
                            <tr>
                                <td width="100%" class="text-left" style="vertical-align: top; padding-top: 3px; ">
                                    <strong>@lang('general.text_cfdi_certificado'):</strong><br/>
                                    {{ $cfdi33['NoCertificado'] }}
                                </td>
                            </tr>
                            <tr>
                                <td width="100%" class="text-left" style="vertical-align: top; padding-top: 3px; ">
                                    <strong>@lang('general.text_cfdi_tfd_no_certificado_sat'):</strong><br/>
                                    {{ $cfdi33->complemento->timbreFiscalDigital['NoCertificadoSAT'] }}
                                </td>
                            </tr>
                            <tr>
                                <td width="100%" class="text-center" style="vertical-align: bottom; padding-top: 8px; height: 150px;">
                                    <img src="{{ $data['qr'] }}" width="120px" style="margin: 5px 0;"/>
                                </td>
                            </tr>
                        @else
                            <tr>
                                <td width="100%" class="text-left" style="vertical-align: top; padding-top: 3px; height: 230px;">
                                    &nbsp;
                                </td>
                            </tr>
                        @endif
                    </table>
                </td>
                <td width="73%" style="vertical-align: top; padding-left: 10px; padding-right: 10px;">
                    <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
                        <tr>
                            <td width="50%" class="text-left" style="vertical-align: top; padding-bottom: 7px; padding-top: 13px; border-bottom: 1px solid #333333;">
                                <strong>{{ mb_strtoupper(!empty($cfdi33->Receptor['Nombre']) ? $cfdi33->Receptor['Nombre'] : $customer_credit_note->customer->name) }}</strong>
                                <br>
                                {{ mb_strtoupper($cfdi33->Receptor['Rfc'] ?? $customer_credit_note->customer->taxid) }}
                                <br>
                                @if(!empty($customer_credit_note->customer->address_1) || !empty($customer_credit_note->customer->address_2) || !empty($customer_credit_note->customer->address_3) || !empty($customer_credit_note->customer->address_4))
                                    {{ $customer_credit_note->customer->address_1 ?? '' }} {{ $customer_credit_note->customer->address_2 ?? '' }} {{ $customer_credit_note->customer->address_3 ?? '' }} {{ $customer_credit_note->customer->address_4 ?? '' }}
                                    <br/>
                                @endif
                                @if(!empty($customer_credit_note->customer->city->name) || !empty($customer_credit_note->customer->state->name))
                                    {{ !empty($customer_credit_note->customer->city->name) ? $customer_credit_note->customer->city->name . ', ' : '' }}{{ $customer_credit_note->customer->state->name ?? '' }}
                                    <br/>
                                @endif
                                {{ $customer_credit_note->customer->country->name ?? '' }}{!! ($customer_credit_note->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_credit_note->customer->postcode : '') !!}
                                <br/>
                                @lang('sales/customer_credit_note.entry_cfdi_use_id'): {{ $customer_credit_note->cfdiUse->name_sat }}
                            </td>
                            <td width="50%" class="text-left" style="vertical-align: top; padding-left: 5px; padding-bottom: 7px; padding-top: 13px; border-bottom: 1px solid #333333;  border-left: 1px solid #333333;">
                                <table cellpadding="0" cellspacing="0" class="" width="100%">
                                    <tr>
                                        <td width="45%">@lang('sales/customer_credit_note.entry_name')</td>
                                        <td width="55%">{{ $customer_credit_note->name }}</td>
                                    </tr>
                                    <tr>
                                        <td>@lang('base/document_type.entry_cfdi_type_id')</td>
                                        <td>{{ $customer_credit_note->documentType->cfdiType->name_sat ?? ''}}</td>
                                    </tr>
                                    <tr>
                                        <td>@lang('sales/customer_credit_note.entry_payment_way_id')</td>
                                        <td>{{ $customer_credit_note->paymentWay->name_sat }}</td>
                                    </tr>
                                    <tr>
                                        <td>@lang('sales/customer_credit_note.entry_currency_id')</td>
                                        <td>
                                            {{ $customer_credit_note->currency->code }}
                                            @if($customer_credit_note->currency->code!='MXN')
                                                {{ '&nbsp;&nbsp;&nbsp;' . __('sales/customer_credit_note.entry_currency_value') . ': '. round($customer_credit_note->currency_value,4)}}
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>@lang('sales/customer_credit_note.entry_payment_method_id')</td>
                                        <td>{{ $customer_credit_note->paymentMethod->name_sat }}</td>
                                    </tr>
                                    <tr>
                                        <td>@lang('sales/customer_credit_note.entry_payment_term_id')</td>
                                        <td>{{ $customer_credit_note->paymentTerm->name }}</td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_credit_note->status == \App\Models\Sales\CustomerInvoice::CANCEL)
    <section class="watermark" style="bottom: 450px !important;">
        @if(!empty($customer_credit_note->customerInvoiceCfdi->uuid))
            <span>@lang('general.text_canceled_cfdi')</span>
        @else
            <span>@lang('general.text_canceled')</span>
        @endif
    </section>
@endif
@if($draft)
    <section class="watermark" style="left: 170px; bottom: 450px !important;">
        <span>@lang('general.text_pre_customer_credit_note')</span>
    </section>
@endif
<section>
    <div style="padding-left: 28%;">

                <div>
                    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
                        <thead>
                        <tr>
                            <th width="7%">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_quantity')) }}</th>
                            <th class="text-left">
                                @if(!empty(setting('show_product_code_on_pdf')))
                                    {{ mb_strtoupper(__('sales/customer_credit_note.column_line_product_id')) }} -
                                    {{ mb_strtoupper(__('sales/customer_credit_note.column_line_name')) . ' - ' . mb_strtoupper(__('sales/customer_credit_note.column_line_sat_product_id')) }}
                                @else
                                    {{ mb_strtoupper(__('sales/customer_credit_note.column_line_sat_product_id')) . ' - ' . mb_strtoupper(__('sales/customer_credit_note.column_line_name')) }}
                                @endif
                            </th>
                            <th width="14%">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_unit_measure_id')) }}</th>
                            <th width="9%">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_price_unit')) }}</th>
                            <th width="11%">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_amount_untaxed')) }}</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($customer_credit_note->customerActiveInvoiceLines as $result)
                            <tr>
                                <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                                <td>
                                    @if(!empty(setting('show_product_code_on_pdf')))
                                        {{$result->product->code ?? 'N/A'}} -
                                        {!! nl2br($result->name) !!} ({{ $result->satProduct->code }})
                                    @else
                                        {{ $result->satProduct->code }} - {!! nl2br($result->name) !!}
                                    @endif
                                </td>
                                <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_credit_note->company_id)) }}</td>
                                <td class="text-right">{{ money($result->amount_untaxed,$customer_credit_note->currency->code,true) }}</td>
                            </tr>
                        @endforeach
                        </tbody>
                        <tfoot>
                        <tr>
                            <td colspan="5" class="text-left" style="vertical-align: top; height: 50px;">
                                {!! nl2br($customer_credit_note->comment) !!}
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3" class="text-left" style="vertical-align: top;">
                            <span style="line-height: 16px;">
                                ***({{\App\Helpers\Helper::numberToWordCurrency($customer_credit_note->amount_total,$customer_credit_note->currency->code,$customer_credit_note->currency->decimal_place)}})***
                            </span>
                            </td>
                            <td colspan="1" class="text-right" style="vertical-align: top; padding-right: 4px;">
                                <strong>@lang('general.text_amount_untaxed')</strong><br/>
                                @if($customer_credit_note->customerInvoiceTaxes->isNotEmpty())
                                    @foreach($customer_credit_note->customerInvoiceTaxes as $result)
                                        <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                                    @endforeach
                                @endif
                                <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
                            </td>
                            <td class="text-right">
                                {{ money($customer_credit_note->amount_untaxed,$customer_credit_note->currency->code,true) }}<br/>
                                @if($customer_credit_note->customerInvoiceTaxes->isNotEmpty())
                                    @foreach($customer_credit_note->customerInvoiceTaxes as $result)
                                        <span style="line-height: 16px;">{{money(abs($result->amount_tax),$customer_credit_note->currency->code,true)}}</span><br/>
                                    @endforeach
                                @endif
                                <span style="line-height: 16px;"><strong>{{ money($customer_credit_note->amount_total,$customer_credit_note->currency->code,true) }}</strong></span>
                            </td>
                        </tr>
                        </tfoot>
                    </table>
                </div>
                @if(!empty($cfdi33))
                    <div>
                        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                            <tr>
                                <td width="" class="cell-primary" style=""><small>@lang('general.text_cfdi_tfd_cadena_origen')</small></td>
                            </tr>
                            <tr>
                                <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 45px; padding: 5px;  word-wrap:break-word;">
                                    <small>{{ $data['tfd_cadena_origen'] }}</small>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div>
                        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                            <tr>
                                <td width="" class="cell-primary" style=""><small>@lang('general.text_cfdi_tfd_sello_cfdi')</small></td>
                            </tr>
                            <tr>
                                <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 35px; padding: 5px;  word-wrap:break-word;">
                                    <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloCFD'] }}</small>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div>
                        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                            <tr>
                                <td width="" class="cell-primary" style=""><small>@lang('general.text_cfdi_tfd_sello_sat')</small></td>
                            </tr>
                            <tr>
                                <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 35px; padding: 5px;  word-wrap:break-word;">
                                    <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloSAT'] }}</small>
                                </td>
                            </tr>
                        </table>
                    </div>
                @endif
                @if(!empty($customer_credit_note->cfdi_relation_id))
                    <div>
                        <p style="margin-bottom: 2px;">
                            <strong>@lang('sales/customer_credit_note.tab_relations') - {{ $customer_credit_note->cfdiRelation->name_sat }}</strong>
                        </p>
                        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
                            <tr>
                                <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                                    @if($customer_credit_note->customerInvoiceRelations->isNotEmpty())
                                        @foreach($customer_credit_note->customerInvoiceRelations as $result)
                                            {{$result->relation->name ?? ''}}<br/>
                                        @endforeach
                                    @endif
                                </td>
                                <td width="85%" style="vertical-align: middle; padding: 5px;">
                                    @if($customer_credit_note->customerInvoiceRelations->isNotEmpty())
                                        @foreach($customer_credit_note->customerInvoiceRelations as $result)
                                            {{$result->uuid_related}}<br/>
                                        @endforeach
                                    @endif
                                </td>
                            </tr>
                        </table>
                    </div>
                @endif

    </div>
</section>
</body>
</html>
