<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_credit_note->documentType->name}}-{{$customer_credit_note->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 315px;
            margin-bottom: 27px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_credit_note->company_id) }}     !important;
            font-weight: bold;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_credit_note->company_id) }}     !important;
        }

        .cell-primary {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_credit_note->company_id) }}     !important;
            color: #ffffff;
        }

        .border-top-primary{
            border-top: 1px solid {{ \App\Helpers\Helper::companyColorPrimary($customer_credit_note->company_id) }}     !important;
        }
    </style>
</head>
<body style="background-color: white;">
@php
//Obtiene datos del Cfdi33
$draft = (int) $customer_credit_note->status == \App\Models\Sales\CustomerInvoice::DRAFT ? true : false;
$cfdi33 = empty($data['cfdi33']) ? null : $data['cfdi33'];
$conceptos = null;
if($cfdi33){
    $conceptos = $cfdi33->conceptos;
    $conceptos = $conceptos();
}
@endphp
<section class="header" style="top: -282px;">
    @if($cfdi33 && $customer_credit_note->customerInvoiceCfdi->pac->test)
    <h2 style="position: absolute; left: 0; top: -30px; color: red;">*** @lang('general.text_test_cfdi') ***</h2>
    @endif
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
            <tr>
                <td colspan="2" class="text-center cell-primary" style="height: 30px;">
                    <h1 style="margin: 0;">{{ mb_strtoupper($customer_credit_note->documentType->name) }}</h1>
                </td>
            </tr>
            <tr>
                <td width="50%" class="text-left" style="height: 30px; color: #333333;">
                    <h3 class="text-primary" style="margin: 0;"><strong>{{ mb_strtoupper($customer_credit_note->company->comercial_name) }}</strong></h1>
                </td>
                <td width="50%" class="text-right" style="height: 30px; color: #333333;">
                    <h3 style="margin: 0;"><strong>{{ mb_strtoupper($customer_credit_note->company->name) }}</strong></h1>
                </td>
            </tr>
        </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
        <tr>
            <td width="25%" class="text-left" style="vertical-align: top; height: 90px;">
                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_credit_note->company_id,$customer_credit_note->project_id) }}" class="invoice-logo" style="max-width:160px; max-height: 100px;"/>
                @elseif(!empty(setting('branch_office_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_credit_note->company_id,$customer_credit_note->branch_office_id) }}" class="invoice-logo" style="max-width:160px; max-height: 100px;"/>
                @else
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_credit_note->company_id) }}" class="invoice-logo" style="max-width:160px; max-height: 100px;"/>
                @endif
            </td>
            <td width="38%" class="text-left" style="vertical-align: top;">
                {{ mb_strtoupper($customer_credit_note->company->taxid) }}
                @if(!empty($customer_credit_note->company->address_1) || !empty($customer_credit_note->company->address_2) || !empty($customer_credit_note->company->address_3) || !empty($customer_credit_note->company->address_4))
                    <br/>
                    {{ $customer_credit_note->company->address_1 ?? '' }} {{ $customer_credit_note->company->address_2 ?? '' }} {{ $customer_credit_note->company->address_3 ?? '' }} {{ $customer_credit_note->company->address_4 ?? '' }}
                @endif
                @if(!empty($customer_credit_note->company->city->name) || !empty($customer_credit_note->company->state->name))
                    <br/>
                    {{ !empty($customer_credit_note->company->city->name) ? $customer_credit_note->company->city->name . ', ' : '' }}{{ $customer_credit_note->company->state->name ?? '' }}
                @endif
                <br/>
                {{ $customer_credit_note->company->country->name ?? '' }}{!! ($customer_credit_note->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_credit_note->company->postcode : '') !!}
                <br/>
                ---
                <br/>
                {{ $customer_credit_note->company->phone ?? ' ' }}
                <br/>
                {{ $customer_credit_note->company->email ?? ' ' }}
                <br/>
                ---
                <br/>
                @lang('base/company.entry_tax_regimen_id'): {{ $data['tax_regimen'] ?? ($customer_credit_note->taxRegimen->name_sat ?? $customer_credit_note->company->taxRegimen->name_sat) }}
                <br/>
                @lang('general.text_issued_in'): {{ $customer_credit_note->branchOffice->name ?? '' }} {!! ($customer_credit_note->branchOffice->postcode ? '&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ': ' . $customer_credit_note->branchOffice->postcode : '') !!}
                <br/>
            </td>
            <td width="37%" class="text-right" style="vertical-align: top; height: 120px;">
                <span class="text-primary">@lang('sales/customer_credit_note.entry_name'): </span><br>
                {{ $customer_credit_note->name }}<br/>
                <span class="text-primary">@lang('general.text_cfdi_uuid'): </span><br/>
                {{ $customer_credit_note->customerInvoiceCfdi->uuid ?? '' }}<br/>
                @if(!empty($cfdi33))
                    <span class="text-primary">@lang('general.text_cfdi_certificado'): </span><br/>
                    {{ $cfdi33['NoCertificado'] }}<br/>
                @endif
                <span class="text-primary">@lang('sales/customer_credit_note.entry_date'): </span><br/>
                {{ \App\Helpers\Helper::convertSqlToDateTime($customer_credit_note->date) }}<br/>

            </td>
        </tr>
    </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px;">
            <tr>
                <td width="50%" class="text-left border-top-primary" style="vertical-align:top; height: 75px; padding-left: 5px; padding-top: 10px;">
                    <strong>{{ mb_strtoupper(!empty($cfdi33->Receptor['Nombre']) ? $cfdi33->Receptor['Nombre'] : $customer_credit_note->customer->name) }}</strong>
                    @if(!empty($customer_credit_note->customer->address_1) || !empty($customer_credit_note->customer->address_2) || !empty($customer_credit_note->customer->address_3) || !empty($customer_credit_note->customer->address_4))
                        <br/>
                        {{ $customer_credit_note->customer->address_1 ?? '' }} {{ $customer_credit_note->customer->address_2 ?? '' }} {{ $customer_credit_note->customer->address_3 ?? '' }} {{ $customer_credit_note->customer->address_4 ?? '' }}
                    @endif
                    @if(!empty($customer_credit_note->customer->city->name) || !empty($customer_credit_note->customer->state->name))
                        <br/>
                        {{ !empty($customer_credit_note->customer->city->name) ? $customer_credit_note->customer->city->name . ', ' : '' }}{{ $customer_credit_note->customer->state->name ?? '' }}
                    @endif
                    <br/>
                    {{ $customer_credit_note->customer->country->name ?? '' }}{!! ($customer_credit_note->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_credit_note->customer->postcode : '') !!}
                    <br/>
                    @lang('sales/customer.entry_taxid'): {{ mb_strtoupper($cfdi33->Receptor['Rfc'] ?? $customer_credit_note->customer->taxid) }}
                    <br/>
                    @lang('sales/customer_credit_note.entry_cfdi_use_id'): {{ $customer_credit_note->cfdiUse->name_sat }}
                </td>
                <td width="50%" class="text-left border-top-primary" style="vertical-align:top; height: 75px; padding-left: 5px; padding-top: 10px;">
                    @lang('sales/customer_credit_note.entry_payment_term_id'): {{ $customer_credit_note->paymentTerm->name }}
                    <br>
                    @lang('sales/customer_credit_note.entry_currency_id'): {{ $customer_credit_note->currency->code }}
                    @if($customer_credit_note->currency->code!='MXN')
                        {{ '&nbsp;&nbsp;&nbsp;' . __('sales/customer_credit_note.entry_currency_value') . ': '. round($customer_credit_note->currency_value,4)}}
                    @endif
                </td>
            </tr>
        </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_credit_note->status == \App\Models\Sales\CustomerInvoice::CANCEL)
    <section class="watermark" style="bottom: 450px !important;">
        @if(!empty($customer_credit_note->customerInvoiceCfdi->uuid))
            <span>@lang('general.text_canceled_cfdi')</span>
        @else
            <span>@lang('general.text_canceled')</span>
        @endif
    </section>
@endif
@if($draft)
    <section class="watermark" style="left: 170px; bottom: 450px !important;">
        <span>@lang('general.text_pre_customer_credit_note')</span>
    </section>
@endif
<section>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
        <thead>
        <tr>
            <th width="7%">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_quantity')) }}</th>
            <th width="14%">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_unit_measure_id')) }}</th>
            <th class="text-left">
                @if(!empty(setting('show_product_code_on_pdf')))
                    {{ mb_strtoupper(__('sales/customer_credit_note.column_line_product_id')) }} -
                    {{ mb_strtoupper(__('sales/customer_credit_note.column_line_name')) . ' - ' . mb_strtoupper(__('sales/customer_credit_note.column_line_sat_product_id')) }}
                @else
                    {{ mb_strtoupper(__('sales/customer_credit_note.column_line_sat_product_id')) . ' - ' . mb_strtoupper(__('sales/customer_credit_note.column_line_name')) }}
                @endif
            </th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_price_unit')) }}</th>
            <th width="11%">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_amount_untaxed')) }}</th>
        </tr>
        </thead>
        <tbody>
            @foreach($customer_credit_note->customerActiveInvoiceLines as $result)
                <tr>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                    <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                    <td>
                        @if(!empty(setting('show_product_code_on_pdf')))
                            {{$result->product->code ?? 'N/A'}} -
                            {!! nl2br($result->name) !!} ({{ $result->satProduct->code }})
                        @else
                            {{ $result->satProduct->code }} - {!! nl2br($result->name) !!}
                        @endif
                    </td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_credit_note->company_id)) }}</td>
                    <td class="text-right">{{ money($result->amount_untaxed,$customer_credit_note->currency->code,true) }}</td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
        <tr>
            <td colspan="3" class="text-center" style="vertical-align: bottom;">
                <span style="line-height: 16px;">
                    ***({{\App\Helpers\Helper::numberToWordCurrency($customer_credit_note->amount_total,$customer_credit_note->currency->code,$customer_credit_note->currency->decimal_place)}})***
                </span>
            </td>
            <td colspan="1" class="text-right" style="vertical-align: top; padding-right: 4px;">
                <strong>@lang('general.text_amount_untaxed')</strong><br/>
                @if($customer_credit_note->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_credit_note->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
            </td>
            <td class="text-right">
                {{ money($customer_credit_note->amount_untaxed,$customer_credit_note->currency->code,true) }}<br/>
                @if($customer_credit_note->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_credit_note->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;">{{money(abs($result->amount_tax),$customer_credit_note->currency->code,true)}}</span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ money($customer_credit_note->amount_total,$customer_credit_note->currency->code,true) }}</strong></span>
            </td>
        </tr>
        </tfoot>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-footer" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="20%" class="text-center" style="vertical-align: top;">
                @if(!empty($cfdi33))
                    <img src="{{ $data['qr'] }}" width="100px" style="margin: 9px 0;"/>
                @endif
            </td>
            <td width="80%" style="vertical-align: middle; padding-left: 13px;">
                <strong>@lang('base/document_type.entry_cfdi_type_id'): </strong>{{ $customer_credit_note->documentType->cfdiType->name_sat ?? '' }}
                <br/>
                <strong>@lang('sales/customer_credit_note.entry_payment_method_id'): </strong>{{ $customer_credit_note->paymentMethod->name_sat }}
                <br/>
                <strong>@lang('sales/customer_credit_note.entry_payment_way_id'): </strong>{{ $customer_credit_note->paymentWay->name_sat }}
                <br/>
                @if(!empty($cfdi33))
                    <strong>@lang('general.text_cfdi_tfd_no_certificado_sat'): </strong>{{ $cfdi33->complemento->timbreFiscalDigital['NoCertificadoSAT'] }}
                    <br/>
                    <strong>@lang('general.text_cfdi_tfd_fecha_timbrado'): </strong>{{ \App\Helpers\Helper::convertSqlToDateTime(str_replace('T',' ',$cfdi33->complemento->timbreFiscalDigital['FechaTimbrado'])) }}
                    <br/>
                @endif
            </td>
        </tr>
    </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-footer" width="100%"
               style="margin-top: 5px; table-layout: fixed;">
            <tr>
                <td width="100%" style="vertical-align: middle; padding: 5px; word-wrap:break-word; height: 150px;">
                    @if(!empty($cfdi33))
                        <strong>@lang('general.text_cfdi_tfd_cadena_origen')</strong><br/>
                        <small>{{ $data['tfd_cadena_origen'] }}</small>
                        <br/>
                        <strong>@lang('general.text_cfdi_tfd_sello_cfdi')</strong><br/>
                        <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloCFD'] }}</small>
                        <br/>
                        <strong>@lang('general.text_cfdi_tfd_sello_sat')</strong><br/>
                        <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloSAT'] }}</small>
                        <br/>
                    @endif
                </td>
            </tr>
        </table>
    </div>
    @if(!empty($customer_credit_note->cfdi_relation_id))
        <div>
        <p style="margin-bottom: 2px;">
            <strong>@lang('sales/customer_credit_note.tab_relations') - {{ $customer_credit_note->cfdiRelation->name_sat }}</strong>
        </p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                    @if($customer_credit_note->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_credit_note->customerInvoiceRelations as $result)
                            {{$result->relation->name ?? ''}}<br/>
                        @endforeach
                    @endif
                </td>
                <td width="85%" style="vertical-align: middle; padding: 5px;">
                    @if($customer_credit_note->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_credit_note->customerInvoiceRelations as $result)
                            {{$result->uuid_related}}<br/>
                        @endforeach
                    @endif
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_credit_note->comment))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_credit_note.entry_comment')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;">
                    {!! nl2br($customer_credit_note->comment) !!}
                </td>
            </tr>
        </table>
        </div>
    @endif
</section>
</body>
</html>
