<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_credit_note->documentType->name}}-{{$customer_credit_note->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 310px;
            margin-bottom: 40px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 10px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_credit_note->company_id) }}   !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_credit_note->company_id) }}   !important;
        }
    </style>
</head>
<body style="background-color: white;">
<section class="header" style="top: -287px;">
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td colspan="2" class="text-right">
                <h1>{{ mb_strtoupper($customer_credit_note->documentType->name) }}</h1>
            </td>
        </tr>
        <tr>
            <td width="50%" style="vertical-align: top; padding-top: 10px;">
                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_credit_note->company_id,$customer_credit_note->project_id) }}" class="invoice-logo" width="170px"/>
                @elseif(!empty(setting('branch_office_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_credit_note->company_id,$customer_credit_note->branch_office_id) }}" class="invoice-logo" width="170px"/>
                @else
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_credit_note->company_id) }}" class="invoice-logo" width="170px"/>
                @endif
            </td>
            <td width="50%" class="text-right text-company" style="vertical-align: top; padding-top: 10px;">
                <span><strong>{{ mb_strtoupper($customer_credit_note->company->name) }}</strong></span>
                <br/>
                <span>{{ $customer_credit_note->company->taxRegimen->name_sat }}</span>
                <br/>
                <span>{{ $customer_credit_note->company->address_1 ?? '' }} {{ $customer_credit_note->company->address_2 ?? '' }} {{ $customer_credit_note->company->address_3 ?? '' }} {{ $customer_credit_note->company->address_4 ?? '' }}</span>
                <br/>
                <span>{{ $customer_credit_note->company->city->name ?? '' }}, {{ ($customer_credit_note->company->state->name ?? '') }}</span>
                <br/>
                <span>{{ $customer_credit_note->company->country->name ?? '' }}{!! ($customer_credit_note->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_credit_note->company->postcode : '') !!}</span>
                <br/>
                <span>{{ mb_strtoupper($customer_credit_note->company->taxid) }}</span>
                <br/>
                <span>---</span>
                <br/>
                <span>{{ $customer_credit_note->company->phone ?? ' ' }}</span>
                <br/>
                <span>{{ $customer_credit_note->company->email ?? ' ' }}</span>
            </td>
        </tr>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary"># {{ $customer_credit_note->name }}</span>

            </td>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary">{{ mb_strtoupper(__('general.text_customer')) }}</span>
            </td>
        </tr>
        <tr>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <span><strong>@lang('general.text_cfdi_uuid')
                        : </strong>{{ $customer_credit_note->customerInvoiceCfdi->uuid ?? '' }}</span>
                <br/>
                <span><strong>@lang('base/document_type.entry_cfdi_type_id')
                        : </strong>{{ $customer_credit_note->documentType->cfdiType->name_sat ?? '' }}</span>
                <br/>
                <span><strong>@lang('sales/customer_credit_note.entry_date')
                        : </strong>{{ \App\Helpers\Helper::convertSqlToDateTime($customer_credit_note->date) }}</span>
                <br/>
                <span><strong>@lang('sales/customer_credit_note.entry_payment_term_id')
                        : </strong>{{ $customer_credit_note->paymentTerm->name }}</span>
                <br/>
                <span><strong>@lang('sales/customer_credit_note.entry_cfdi_use_id')
                        : </strong>{{ $customer_credit_note->cfdiUse->name_sat }}</span>
                <br/>
                <span><strong>@lang('general.text_issued_in')
                        : </strong>{{ $customer_credit_note->branchOffice->name ?? '' }} {!! ($customer_credit_note->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $customer_credit_note->branchOffice->postcode : '') !!}</span>
                <br/>
            </td>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <span><strong>{{ mb_strtoupper($customer_credit_note->customer->name) }}</strong></span>
                <br/>
                <span>{{ $customer_credit_note->customer->address_1 ?? '' }} {{ $customer_credit_note->customer->address_2 ?? '' }} {{ $customer_credit_note->customer->address_3 ?? '' }} {{ $customer_credit_note->customer->address_4 ?? '' }}</span>
                <br/>
                <span>{{ $customer_credit_note->customer->city->name ?? '' }}
                    , {{ $customer_credit_note->customer->state->name ?? '' }}</span>
                <br/>
                <span>{{ $customer_credit_note->customer->country->name ?? '' }}{!! ($customer_credit_note->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_credit_note->customer->postcode : '') !!}</span>
                <br/>
                @lang('sales/customer_credit_note.entry_taxid'): {{ $customer_credit_note->customer->taxid }}
                <br />
                @lang('sales/customer_credit_note.entry_tax_regimen_customer_id2'): {{ $customer_credit_note->taxRegimenCustomer->name_sat ?? ($customer_credit_note->customer->taxRegimen->name_sat ?? '') }}
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="watermark" style="bottom: 540px !important;">
    <span>@lang('general.text_invalid_cfdi')</span>
</section>
<section>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
        <thead>
        <tr>
            <th class="text-left">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_name')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_sat_product_id')) }}</th>
            <th width="14%">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_unit_measure_id')) }}</th>
            <th width="8%">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_quantity')) }}</th>
            <th width="10%">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_price_unit')) }}</th>
            <th width="11%">{{ mb_strtoupper(__('sales/customer_credit_note.column_line_amount_untaxed')) }}</th>
        </tr>
        </thead>
        <tbody>
        @foreach($customer_credit_note->customerActiveInvoiceLines as $result)
            <tr>
                <td>{!! nl2br($result->name) !!}</td>
                <td class="text-center">{{ $result->satProduct->code }}</td>
                <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_credit_note->company_id)) }}</td>
                <td class="text-right">{{ money($result->amount_untaxed,$customer_credit_note->currency->code,true) }}</td>
            </tr>
        @endforeach
        </tbody>
        <tfoot>
        <tr>
            <td colspan="4" class="text-center" style="vertical-align: bottom;">
                <span style="line-height: 16px;">***({{\App\Helpers\Helper::numberToWordCurrency($customer_credit_note->amount_total,$customer_credit_note->currency->code,$customer_credit_note->currency->decimal_place)}}
                    )***</span>
            </td>
            <td colspan="1" class="text-right" style="vertical-align: top; padding-right: 4px;">
                <strong>@lang('general.text_amount_untaxed')</strong><br/>
                @if($customer_credit_note->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_credit_note->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
            </td>
            <td class="text-right">
                {{ money($customer_credit_note->amount_untaxed,$customer_credit_note->currency->code,true) }}<br/>
                @if($customer_credit_note->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_credit_note->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;">{{ money(abs($result->amount_tax),$customer_credit_note->currency->code,true) }}</span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ money($customer_credit_note->amount_total,$customer_credit_note->currency->code,true) }}</strong></span>
            </td>
        </tr>
        </tfoot>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="100%" style="vertical-align: top; padding: 5px;">
                <span><strong>@lang('sales/customer_credit_note.entry_payment_way_id')
                        : </strong>{{ $customer_credit_note->paymentWay->name_sat }}</span>
                <br/>
                <span><strong>@lang('sales/customer_credit_note.entry_payment_method_id')
                        : </strong>{{ $customer_credit_note->paymentMethod->name_sat }}</span>
                <br/>
                <span><strong>@lang('sales/customer_credit_note.entry_currency_id')
                        : </strong>{{ $customer_credit_note->currency->code }}{!! ($customer_credit_note->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/customer_credit_note.entry_currency_value').':</strong> '.round($customer_credit_note->currency_value,4) :'') !!}</span>
                <br/>
            </td>
        </tr>
    </table>
    </div>
    @if(!empty($customer_credit_note->cfdi_relation_id))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_credit_note.tab_relations')
                - {{ $customer_credit_note->cfdiRelation->name_sat }} </strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" >
            <tr>
                <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                    @if($customer_credit_note->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_credit_note->customerInvoiceRelations as $result)
                            {{$result->relation->name}}<br/>
                        @endforeach
                    @endif
                </td>
                <td width="85%" style="vertical-align: middle; padding: 5px;">
                    @if($customer_credit_note->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_credit_note->customerInvoiceRelations as $result)
                            {{$result->relation->customerInvoiceCfdi->uuid}}<br/>
                        @endforeach
                    @endif
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_credit_note->comment))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_credit_note.entry_comment')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;">
                    {!! nl2br($customer_credit_note->comment) !!}
                </td>
            </tr>
        </table>
        </div>
    @endif
</section>
</body>
</html>
