<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_fee->documentType->name}}-{{$customer_fee->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 355px;
            margin-bottom: 225px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_fee->company_id) }}     !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_fee->company_id) }}     !important;
        }
    </style>
</head>
<body style="background-color: white;">
@php
//Obtiene datos del Cfdi33
$draft = (int) $customer_fee->status == \App\Models\Sales\CustomerInvoice::DRAFT ? true : false;
$cfdi33 = empty($data['cfdi33']) ? null : $data['cfdi33'];
$conceptos = null;
if($cfdi33){
    $conceptos = $cfdi33->conceptos;
    $conceptos = $conceptos();
}
@endphp
<section class="header" style="top: -342px;">
    @if($cfdi33 && $customer_fee->customerInvoiceCfdi->pac->test)
    <h2 style="position: absolute; left: 0; top: -15px; color: red;">*** @lang('general.text_test_cfdi') ***</h2>
    @endif
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
        <tr>
            <td width="50%" class="text-left" style="height: 90px;">
                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_fee->company_id,$customer_fee->project_id) }}" class="invoice-logo" style="max-height: 60px;"/>
                @elseif(!empty(setting('branch_office_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_fee->company_id,$customer_fee->branch_office_id) }}" class="invoice-logo" style="max-height: 60px;"/>
                @else
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_fee->company_id) }}" class="invoice-logo" style="max-height: 60px;"/>
                @endif
            </td>
            <td width="50%" class="text-left" style="">
                <h1 style="margin: 0;">{{ mb_strtoupper($customer_fee->documentType->name) }}</h1><br>
                <h2 class="text-primary" style="margin: 0;">{{ $customer_fee->name }}</h2><br>
                <span class="text-primary" style="font-size: 8pt;">{{ mb_strtoupper($customer_fee->company->comercial_name) }}</span>
            </td>
        </tr>
    </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px;">
            <tr>
                <td width="50%" class="text-left" style="padding-right: 5px;">
                    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
                        <tbody>
                        <tr>
                            <td style="height: 40px;">
                                <strong>@lang('general.text_cfdi_uuid'): </strong>{{ $customer_fee->customerInvoiceCfdi->uuid ?? '' }}
                                <br/>
                                <strong>@lang('sales/customer_fee.entry_date'): </strong>{{ \App\Helpers\Helper::convertSqlToDateTime($customer_fee->date) }}
                                <br/>
                                <strong>@lang('sales/customer_fee.entry_date_due'): </strong>{{ \App\Helpers\Helper::convertSqlToDate($customer_fee->date_due) }}
                                <br/>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </td>
                <td width="50%" class="text-left" style="padding-left: 5px;">
                    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
                        <tbody>
                        <tr>
                            <td style="height: 40px;">
                                @if(!empty($cfdi33))
                                    <strong>@lang('general.text_cfdi_certificado'): </strong>{{ $cfdi33['NoCertificado'] }}
                                    <br/>
                                    <strong>@lang('general.text_cfdi_tfd_no_certificado_sat'): </strong>{{ $cfdi33->complemento->timbreFiscalDigital['NoCertificadoSAT'] }}
                                    <br/>
                                    <strong>@lang('general.text_cfdi_tfd_fecha_timbrado'): </strong>{{ \App\Helpers\Helper::convertSqlToDateTime(str_replace('T',' ',$cfdi33->complemento->timbreFiscalDigital['FechaTimbrado'])) }}
                                    <br/>
                                @endif
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px;">
            <tr>
                <td width="50%" class="text-left" style="padding-right: 5px;">
                    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
                        <thead>
                        <tr>
                            <th class="text-center"><strong>{{mb_strtoupper(__('base/company.text_transmitter'))}}</strong></th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td style="height: 100px;">
                                <strong>{{ mb_strtoupper($customer_fee->company->name) }}</strong>
                                <br/>
                                {{ $data['tax_regimen'] ?? ($customer_fee->taxRegimen->name_sat ?? $customer_fee->company->taxRegimen->name_sat) }}
                                @if(!empty($customer_fee->company->address_1) || !empty($customer_fee->company->address_2) || !empty($customer_fee->company->address_3) || !empty($customer_fee->company->address_4))
                                    <br/>
                                    {{ $customer_fee->company->address_1 ?? '' }} {{ $customer_fee->company->address_2 ?? '' }} {{ $customer_fee->company->address_3 ?? '' }} {{ $customer_fee->company->address_4 ?? '' }}
                                @endif
                                @if(!empty($customer_fee->company->city->name) || !empty($customer_fee->company->state->name))
                                    <br/>
                                    {{ !empty($customer_fee->company->city->name) ? $customer_fee->company->city->name . ', ' : '' }}{{ $customer_fee->company->state->name ?? '' }}
                                @endif
                                <br/>
                                {{ $customer_fee->company->country->name ?? '' }}{!! ($customer_fee->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_fee->company->postcode : '') !!}
                                <br/>
                                {{ mb_strtoupper($customer_fee->company->taxid) }}
                                <br/>
                                ---
                                <br/>
                                {{ $customer_fee->company->phone ?? ' ' }}
                                <br/>
                                {{ $customer_fee->company->email ?? ' ' }}
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </td>
                <td width="50%" class="text-left" style="padding-left: 5px;">
                    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
                        <thead>
                        <tr>
                            <th class="text-center"><strong>{{mb_strtoupper(__('sales/customer.text_receiver'))}}</strong></th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td style="height: 100px;">
                                <strong>{{ mb_strtoupper(!empty($cfdi33->Receptor['Nombre']) ? $cfdi33->Receptor['Nombre'] : $customer_fee->customer->name) }}</strong>
                                @if(!empty($customer_fee->customer->address_1) || !empty($customer_fee->customer->address_2) || !empty($customer_fee->customer->address_3) || !empty($customer_fee->customer->address_4))
                                    <br/>
                                    {{ $customer_fee->customer->address_1 ?? '' }} {{ $customer_fee->customer->address_2 ?? '' }} {{ $customer_fee->customer->address_3 ?? '' }} {{ $customer_fee->customer->address_4 ?? '' }}
                                @endif
                                @if(!empty($customer_fee->customer->city->name) || !empty($customer_fee->customer->state->name))
                                    <br/>
                                    {{ !empty($customer_fee->customer->city->name) ? $customer_fee->customer->city->name . ', ' : '' }}{{ $customer_fee->customer->state->name ?? '' }}
                                @endif
                                <br/>
                                {{ $customer_fee->customer->country->name ?? '' }}{!! ($customer_fee->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_fee->customer->postcode : '') !!}
                                <br/>
                                @lang('sales/customer_fee.entry_taxid'): {{ mb_strtoupper($cfdi33->Receptor['Rfc'] ?? $customer_fee->customer->taxid) }}
                                <br />
                                @lang('sales/customer_fee.entry_tax_regimen_customer_id2'): {{ $data['tax_regimen_customer'] ?? ($customer_fee->taxRegimenCustomer->name_sat ?? $customer_fee->customer->taxRegimen->name_sat) }}
                                <br/>
                                @lang('sales/customer_fee.entry_cfdi_use_id'): {{ $customer_fee->cfdiUse->name_sat }}
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px;">
            <tr>
                <td width="50%" class="text-left" style="">
                    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
                        <thead>
                        <tr>
                            <th class="text-center" width="20%"><strong>{{mb_strtoupper(__('base/document_type.entry_cfdi_type_id'))}}</strong></th>
                            <th class="text-center"><strong>{{mb_strtoupper(__('sales/customer_fee.entry_payment_way_id'))}}</strong></th>
                            <th class="text-center" width="20%"><strong>{{mb_strtoupper(__('sales/customer_fee.entry_currency_id'))}}</strong></th>
                            <th class="text-center" width="20%"><strong>{{mb_strtoupper(__('sales/customer_fee.entry_currency_value'))}}</strong></th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td class="text-center">{{ $customer_fee->documentType->cfdiType->name_sat ?? '' }}</td>
                            <td class="text-center">{{ $customer_fee->paymentWay->name_sat }}</td>
                            <td class="text-center">{{ $customer_fee->currency->code }}</td>
                            <td class="text-center">{{ $customer_fee->currency->code!='MXN' ? round($customer_fee->currency_value,4) :'' }}</td>
                        </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </table>
    </div>
</section>
<section class="footer">
    <div>
    <table cellpadding="0" cellspacing="0" class="table-footer" width="100%"
           style="margin-top: 5px; table-layout: fixed;">
        <tr>
            <td width="23%" class="text-center" style="vertical-align: middle; padding: 5px; word-wrap:break-word;">
                @if(!empty($cfdi33))
                <img src="{{ $data['qr'] }}" width="137px" style="margin: 9px 0;"/>
                @endif
            </td>
            <td width="77%" style="vertical-align: middle; padding: 5px; word-wrap:break-word; height: 180px;">
                @if(!empty($cfdi33))
                <strong>@lang('general.text_cfdi_tfd_cadena_origen')</strong><br/>
                <small>{{ $data['tfd_cadena_origen'] }}</small>
                <br/>
                <strong>@lang('general.text_cfdi_tfd_sello_cfdi')</strong><br/>
                <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloCFD'] }}</small>
                <br/>
                <strong>@lang('general.text_cfdi_tfd_sello_sat')</strong><br/>
                <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloSAT'] }}</small>
                <br/>
                @endif
            </td>
        </tr>
    </table>
    </div>
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi_40')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_fee->status == \App\Models\Sales\CustomerInvoice::CANCEL)
    <section class="watermark" style="bottom: 450px !important;">
        @if(!empty($customer_fee->customerInvoiceCfdi->uuid))
            <span>@lang('general.text_canceled_cfdi')</span>
        @else
            <span>@lang('general.text_canceled')</span>
        @endif
    </section>
@endif
@if($draft)
    <section class="watermark" style="bottom: 450px !important;">
        <span>@lang('general.text_pre_invoice')</span>
    </section>
@endif
<section>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
        <thead>
        <tr>
            <th width="7%">{{ mb_strtoupper(__('sales/customer_fee.column_line_quantity')) }}</th>
            <th width="14%">{{ mb_strtoupper(__('sales/customer_fee.column_line_unit_measure_id')) }}</th>
            <th class="text-left">
                @if(!empty(setting('show_product_code_on_pdf')))
                    {{ mb_strtoupper(__('sales/customer_fee.column_line_product_id')) }} -
                    {{ mb_strtoupper(__('sales/customer_fee.column_line_name')) . ' - ' . mb_strtoupper(__('sales/customer_fee.column_line_sat_product_id')) }}
                @else
                    {{ mb_strtoupper(__('sales/customer_fee.column_line_sat_product_id')) . ' - ' . mb_strtoupper(__('sales/customer_fee.column_line_name')) }}
                @endif
            </th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_fee.column_line_price_unit')) }}</th>
            <th width="6%">{{ mb_strtoupper(__('sales/customer_fee.column_line_discount')) }}</th>
            <th width="11%">{{ mb_strtoupper(__('sales/customer_fee.column_line_amount_untaxed')) }}</th>
        </tr>
        </thead>
        <tbody>
        @if($conceptos)
        @foreach($conceptos as $result)
            @php
                //Complemento concepto

            @endphp
            <tr>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatRealDecimalPlace($result['Cantidad']) }}</td>
                <td class="text-center">[{{ $result['ClaveUnidad'] }}] {{ $result['Unidad'] }}</td>
                <td>
                    @if(!empty(setting('show_product_code_on_pdf')))
                        {{$result['NoIdentificacion'] ?? 'N/A'}} -
                        {!! nl2br($result['Descripcion']) !!} ({{ $result['ClaveProdServ'] }})
                    @else
                        {{ $result['ClaveProdServ'] }} -
                        {!! nl2br($result['Descripcion']) !!}
                    @endif
                    @php
                    echo '<br />';
                    echo __('sales/customer_fee.column_line_tax_object') . ': '.$result['ObjetoImp'].'<br />';
                    @endphp
                </td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result['ValorUnitario'],\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_fee->company_id)) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormat(!empty($result['Descuento']) ? $result['Descuento']/$result['Importe'] : 0,2) }}</td>
                <td class="text-right">{{ money($result['Importe'],$customer_fee->currency->code,true) }}</td>
            </tr>
        @endforeach
        @else
            @foreach($customer_fee->customerActiveInvoiceLines as $result)
                <tr>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                    <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                    <td>
                        @if(!empty(setting('show_product_code_on_pdf')))
                            {{$result->product->code ?? 'N/A'}} -
                            {!! nl2br($result->name) !!} ({{ $result->satProduct->code }})
                        @else
                            {{ $result->satProduct->code }} - {!! nl2br($result->name) !!}
                        @endif
                    </td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_fee->company_id)) }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                    <td class="text-right">{{ money($result->amount_untaxed,$customer_fee->currency->code,true) }}</td>
                </tr>
            @endforeach
        @endif
        </tbody>
        <tfoot>
        <tr>
            <td colspan="3" class="text-center" style="vertical-align: bottom;">
                <span style="line-height: 16px;">
                    ***({{\App\Helpers\Helper::numberToWordCurrency($customer_fee->amount_total,$customer_fee->currency->code,$customer_fee->currency->decimal_place)}})***
                </span>
            </td>
            <td colspan="2" class="text-right" style="vertical-align: top; padding-right: 4px;">
                <strong>@lang('general.text_amount_untaxed')</strong><br/>
                @if($customer_fee->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_fee->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
            </td>
            <td class="text-right">
                {{ money($customer_fee->amount_untaxed,$customer_fee->currency->code,true) }}<br/>
                @if($customer_fee->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_fee->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;">{{money(abs($result->amount_tax),$customer_fee->currency->code,true)}}</span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ money($customer_fee->amount_total,$customer_fee->currency->code,true) }}</strong></span>
            </td>
        </tr>
        </tfoot>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="100%" style="vertical-align: top; padding: 5px;">
                <strong>@lang('sales/customer_fee.entry_payment_method_id'): </strong>{{ $customer_fee->paymentMethod->name_sat }}
                <br/>
                <strong>@lang('sales/customer_fee.entry_payment_term_id'): </strong>{{ $customer_fee->paymentTerm->name }}
                <br/>
                <strong>@lang('general.text_issued_in'): </strong>{{ $customer_fee->branchOffice->name ?? '' }} {!! ($customer_fee->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $customer_fee->branchOffice->postcode : '') !!}
                <br/>
            </td>
        </tr>
    </table>
    </div>
    @if(!empty($customer_fee->cfdi_relation_id))
        <div>
        <p style="margin-bottom: 2px;">
            <strong>@lang('sales/customer_fee.tab_relations') - {{ $customer_fee->cfdiRelation->name_sat }}</strong>
        </p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                    @if($customer_fee->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_fee->customerInvoiceRelations as $result)
                            {{$result->relation->name ?? ''}}<br/>
                        @endforeach
                    @endif
                </td>
                <td width="85%" style="vertical-align: middle; padding: 5px;">
                    @if($customer_fee->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_fee->customerInvoiceRelations as $result)
                            {{$result->uuid_related}}<br/>
                        @endforeach
                    @endif
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_fee->comment))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_fee.entry_comment')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;">
                    {!! nl2br($customer_fee->comment) !!}
                </td>
            </tr>
        </table>
        </div>
    @endif
</section>
</body>
</html>
