<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_foreign_trade->documentType->name}}-{{$customer_foreign_trade->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 310px;
            margin-bottom: 225px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_foreign_trade->company_id) }}     !important;
        }

        .table-items thead th {
            background-color: #FFFFFF!important;
            color: #333333;
            border-bottom: 1px solid #cccccc;
        }
        .table-items tbody td {
            padding: 8px 2px;
            border: none;
            border-bottom: 1px solid #cccccc;
        }
        .table-footer td {
            background-color: #FEFEFE;
            border: none;
        }
        .table-items tfoot td {
            padding: 4px 2px;
            border: none;
            border-bottom: 1px solid #cccccc;
        }
        .table-secundary td {
            background-color: #FAFAFA;
            border: none;
            border-bottom: 1px solid #cccccc;
        }
        .table-resume td {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_foreign_trade->company_id) }}     !important;
            color: #FFFFFF;
        }
    </style>
</head>
<body style="background-color: white;">
@php
//Obtiene datos del Cfdi33
$draft = (int) $customer_foreign_trade->status == \App\Models\Sales\CustomerInvoice::DRAFT ? true : false;
$cfdi33 = empty($data['cfdi33']) ? null : $data['cfdi33'];
$conceptos = null;
if($cfdi33){
    $conceptos = $cfdi33->conceptos;
    $conceptos = $conceptos();
}
@endphp
<section class="header" style="top: -287px;">
    @if($cfdi33 && $customer_foreign_trade->customerInvoiceCfdi->pac->test)
    <h2 style="position: absolute; left: 37%; top: -15px; color: red;">*** @lang('general.text_test_cfdi') ***</h2>
    @endif
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="40%" style="">
                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_foreign_trade->company_id,$customer_foreign_trade->project_id) }}" class="" style="max-height: 45px; max-width: 240px;"/>
                @elseif(!empty(setting('branch_office_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_foreign_trade->company_id,$customer_foreign_trade->branch_office_id) }}" class="" style="max-height: 45px; max-width: 240px;"/>
                @else
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_foreign_trade->company_id) }}" class="" style="max-height: 45px; max-width: 240px;"/>
                @endif
            </td>
            <td width="60%" class="text-right" style="vertical-align: middle;">
                <h2 style="margin: 0;">{{ mb_strtoupper($customer_foreign_trade->documentType->name) }}</h2>
                <span class="text-primary">{{ mb_strtoupper($customer_foreign_trade->company->comercial_name) }}</span>
            </td>
        </tr>
        <tr>
            <td colspan="2" class="text-right" style="border-bottom: 1px solid #cccccc; padding-top: 5px; padding-bottom: 5px;">
                <strong>{{ mb_strtoupper($customer_foreign_trade->company->name) }} | {{ mb_strtoupper($customer_foreign_trade->company->taxid) }}{{ !empty($customer_foreign_trade->company->curp) ? ' / ' . $customer_foreign_trade->company->curp : '' }} | {{ $data['tax_regimen'] ?? ($customer_foreign_trade->taxRegimen->name_sat ?? $customer_foreign_trade->company->taxRegimen->name_sat) }}</strong><br>
                <span>
                    @if(!empty($customer_foreign_trade->company->address_1) || !empty($customer_foreign_trade->company->address_2) || !empty($customer_foreign_trade->company->address_3) || !empty($customer_foreign_trade->company->address_4))
                        {{ $customer_foreign_trade->company->address_1 ?? '' }} {{ $customer_foreign_trade->company->address_2 ?? '' }} {{ $customer_foreign_trade->company->address_3 ?? '' }} {{ $customer_foreign_trade->company->address_4 ?? '' }}
                    @endif
                    @if(!empty($customer_foreign_trade->company->city->name) || !empty($customer_foreign_trade->company->state->name))
                        {{ !empty($customer_foreign_trade->company->city->name) ? $customer_foreign_trade->company->city->name . ', ' : '' }}{{ !empty($customer_foreign_trade->company->state->name) ? $customer_foreign_trade->company->state->name . ', ' : '' }}
                    @endif
                    {{ $customer_foreign_trade->company->country->name ?? '' }}{!! ($customer_foreign_trade->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_foreign_trade->company->postcode : '') !!} | {{ $customer_foreign_trade->company->phone ?? ' ' }} | {{ $customer_foreign_trade->company->email ?? ' ' }}
                </span>
            </td>
        </tr>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 15px; margin-bottom: 10px;">
        <tr>
            <td width="60%" style="vertical-align: middle; padding-left: 5px;">
                <table cellpadding="0" cellspacing="0" class="" style="min-width: 50%;">
                    <tr>
                        <td class="text-primary" style="padding-top: 5px; padding-bottom: 5px;">
                            <p style="margin: 0; border-bottom: 1px solid #cccccc;">{{ __('general.text_customer') }}</p>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-head" style="padding-top: 3px;">
                            <strong>{{ mb_strtoupper($customer_foreign_trade->customer->name) }} </strong>
                            @if(!empty($customer_foreign_trade->customer->address_1) || !empty($customer_foreign_trade->customer->address_2) || !empty($customer_foreign_trade->customer->address_3) || !empty($customer_foreign_trade->customer->address_4))
                                <br/>
                                {{ $customer_foreign_trade->customer->address_1 ?? '' }} {{ $customer_foreign_trade->customer->address_2 ?? '' }} {{ $customer_foreign_trade->customer->address_3 ?? '' }} {{ $customer_foreign_trade->customer->address_4 ?? '' }},
                            @endif
                            @if(!empty($customer_foreign_trade->customer->city->name) || !empty($customer_foreign_trade->customer->state->name))
                                <br/>
                                {{ $customer_foreign_trade->customer->city->name ?? '' }}, {{ $customer_foreign_trade->customer->state->name ?? '' }}
                            @endif
                            <br/>
                            {{ $customer_foreign_trade->customer->country->code ? '[' . $customer_foreign_trade->customer->country->code . '] ' : '' }}{{ $customer_foreign_trade->customer->country->name ?? '' }}{!! ($customer_foreign_trade->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_foreign_trade->customer->postcode : '') !!}
                            <br/>
                            {{ mb_strtoupper($customer_foreign_trade->customer->taxid) }}
                        </td>
                    </tr>
                </table>
            </td>
            <td width="40%" class="text-right" style="vertical-align: middle;">
                <table cellpadding="0" cellspacing="0" class="text-right" style="" width="100%">
                    <tr>
                        <td class="small" style=" color: #777777;"><strong>{{ __('sales/customer_foreign_trade.entry_name') }}</strong></td>
                    </tr>
                    <tr>
                        <td class="text-head" style="">
                            <h3 style="margin: 0; padding: 0;">{{ $customer_foreign_trade->name }}</h3>
                        </td>
                    </tr>
                    <tr>
                        <td class="small" style="padding-top: 7px; color: #777777;"><strong>@lang('sales/customer_foreign_trade.entry_date')</strong></td>
                    </tr>
                    <tr>
                        <td class="text-head" style="">
                            <h3 style="margin: 0; padding: 0;">{{ \App\Helpers\Helper::convertSqlToDateTime($customer_foreign_trade->date) }}</h3>
                        </td>
                    </tr>
                    <tr>
                        <td class="small" style="padding-top: 7px; color: #777777;"><strong>@lang('sales/customer_foreign_trade.entry_date_due')</strong></td>
                    </tr>
                    <tr>
                        <td class="text-head" style="">
                            <h3 style="margin: 0; padding: 0;">{{ \App\Helpers\Helper::convertSqlToDate($customer_foreign_trade->date_due) }}</h3>
                        </td>
                    </tr>
                    <tr>
                        <td class="small" style="padding-top: 7px; color: #777777;"><strong>@lang('general.text_amount_total')</strong></td>
                    </tr>
                    <tr>
                        <td class="text-head" style="">
                            <h3 style="margin: 0; padding: 0;">{{ money($customer_foreign_trade->amount_total,$customer_foreign_trade->currency->code,true) }}</h3>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    </div>
    <div>
    <table cellpadding="2" cellspacing="0" class="table-resume" width="100%" style="margin-top: 5px; font-size: 9px;">
        <tr>
            <td>
                <small style="font-weight: bold;">@lang('general.text_cfdi_uuid')</small><br>
                {{ $customer_foreign_trade->customerInvoiceCfdi->uuid ?? '' }}
            </td>
            <td>
                <small style="font-weight: bold;">@lang('base/document_type.entry_cfdi_type_id')</small><br>
                {{ $customer_foreign_trade->documentType->cfdiType->name_sat ?? '' }}
            </td>
            <td>
                <small style="font-weight: bold;">@lang('sales/customer_foreign_trade.entry_payment_term_id')</small><br>
                {{ $customer_foreign_trade->paymentTerm->name }}
            </td>
            <td>
                <small style="font-weight: bold;">@lang('sales/customer_foreign_trade.entry_cfdi_use_id')</small><br>
                {{ $customer_foreign_trade->cfdiUse->name_sat }}
            </td>
            <td>
                <small style="font-weight: bold;">@lang('general.text_issued_in')</small><br>
                {{ $customer_foreign_trade->branchOffice->name ?? '' }} {!! ($customer_foreign_trade->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $customer_foreign_trade->branchOffice->postcode : '') !!}
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="footer">
    <div>
    <table cellpadding="0" cellspacing="0" class="table-footer" width="100%"
           style="margin-top: 5px; table-layout: fixed;">
        <tr>
            <td width="23%" class="text-center" style="vertical-align: middle; padding: 5px; word-wrap:break-word; border-top: 1px solid #cccccc;">
                @if(!empty($cfdi33))
                <img src="{{ $data['qr'] }}" width="137px" style="margin: 9px 0;"/>
                @endif
            </td>
            <td width="77%" style="vertical-align: middle; padding: 5px; word-wrap:break-word; height: 180px; border-top: 1px solid #cccccc;">
                @if(!empty($cfdi33))
                <strong>@lang('general.text_cfdi_tfd_cadena_origen')</strong><br/>
                <small>{{ $data['tfd_cadena_origen'] }}</small>
                <br/>
                <strong>@lang('general.text_cfdi_tfd_sello_cfdi')</strong><br/>
                <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloCFD'] }}</small>
                <br/>
                <strong>@lang('general.text_cfdi_tfd_sello_sat')</strong><br/>
                <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloSAT'] }}</small>
                <br/>
                @endif
            </td>
        </tr>
    </table>
    </div>
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_foreign_trade->status == \App\Models\Sales\CustomerInvoice::CANCEL)
    <section class="watermark" style="bottom: 450px !important;">
        @if(!empty($customer_foreign_trade->customerInvoiceCfdi->uuid))
            <span>@lang('general.text_canceled_cfdi')</span>
        @else
            <span>@lang('general.text_canceled')</span>
        @endif
    </section>
@endif
@if($draft)
    <section class="watermark" style="bottom: 450px !important;">
        <span>@lang('general.text_pre_invoice')</span>
    </section>
@endif
<section>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
        <thead>
        <tr>
            <th class="text-left">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_name')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_sat_product_id')) }}</th>
            <th width="14%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_unit_measure_id')) }}</th>
            <th width="7%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_quantity')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_price_unit')) }}</th>
            <th width="6%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_discount')) }}</th>
            <th width="11%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_amount_untaxed')) }}</th>
        </tr>
        </thead>
        <tbody>
        @if($conceptos)
        @foreach($conceptos as $result)
            @php
                //Complemento concepto

            @endphp
            <tr>
                <td>
                    @if(!empty(setting('show_product_code_on_pdf')))
                        {{$result['NoIdentificacion'] ?? 'N/A'}} -
                    @endif
                    {!! nl2br($result['Descripcion']) !!}
                </td>
                <td class="text-center">{{ $result['ClaveProdServ'] }}</td>
                <td class="text-center">[{{ $result['ClaveUnidad'] }}] {{ $result['Unidad'] }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatRealDecimalPlace($result['Cantidad']) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result['ValorUnitario'],\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_foreign_trade->company_id)) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormat(!empty($result['Descuento']) ? $result['Descuento']/$result['Importe'] : 0,2) }}</td>
                <td class="text-right">{{ money($result['Importe'],$customer_foreign_trade->currency->code,true) }}</td>
            </tr>
        @endforeach
        @else
            @foreach($customer_foreign_trade->customerActiveInvoiceLines as $result)
                <tr>
                    <td>
                        @if(!empty(setting('show_product_code_on_pdf')))
                            {{$result->product->code ?? 'N/A'}} -
                        @endif
                        {!! nl2br($result->name) !!}
                    </td>
                    <td class="text-center">{{ $result->satProduct->code }}</td>
                    <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_foreign_trade->company_id)) }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                    <td class="text-right">{{ money($result->amount_untaxed,$customer_foreign_trade->currency->code,true) }}</td>
                </tr>
            @endforeach
        @endif
        </tbody>
        <tfoot>
        <tr>
            <td colspan="4" class="text-center" style="vertical-align: bottom;">
                <span style="line-height: 16px;">
                    ***({{\App\Helpers\Helper::numberToWordCurrency($customer_foreign_trade->amount_total,$customer_foreign_trade->currency->code,$customer_foreign_trade->currency->decimal_place)}})***
                </span>
            </td>
            <td colspan="2" class="text-right" style="vertical-align: top; padding-right: 4px;">
                <strong>@lang('general.text_amount_untaxed')</strong><br/>
                @if($customer_foreign_trade->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_foreign_trade->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
            </td>
            <td class="text-right">
                {{ money($customer_foreign_trade->amount_untaxed,$customer_foreign_trade->currency->code,true) }}<br/>
                @if($customer_foreign_trade->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_foreign_trade->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;">{{money(abs($result->amount_tax),$customer_foreign_trade->currency->code,true)}}</span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ money($customer_foreign_trade->amount_total,$customer_foreign_trade->currency->code,true) }}</strong></span>
            </td>
        </tr>
        </tfoot>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="50%" style="vertical-align: top; padding: 5px;">
                <strong>@lang('sales/customer_foreign_trade.entry_payment_way_id'): </strong>{{ $customer_foreign_trade->paymentWay->name_sat }}
                <br/>
                <strong>@lang('sales/customer_foreign_trade.entry_payment_method_id'): </strong>{{ $customer_foreign_trade->paymentMethod->name_sat }}
                <br/>
                <strong>@lang('sales/customer_foreign_trade.entry_currency_id'): </strong>{{ $customer_foreign_trade->currency->code }}{!! ($customer_foreign_trade->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/customer_foreign_trade.entry_currency_value').':</strong> '.round($customer_foreign_trade->currency_value,4) :'') !!}
                <br/>
            </td>
            <td width="50%" style="vertical-align: top; padding: 5px;">
                @if(!empty($cfdi33))
                <strong>@lang('general.text_cfdi_certificado'): </strong>{{ $cfdi33['NoCertificado'] }}
                <br/>
                <strong>@lang('general.text_cfdi_tfd_no_certificado_sat'): </strong>{{ $cfdi33->complemento->timbreFiscalDigital['NoCertificadoSAT'] }}
                <br/>
                <strong>@lang('general.text_cfdi_tfd_fecha_timbrado'): </strong>{{ \App\Helpers\Helper::convertSqlToDateTime(str_replace('T',' ',$cfdi33->complemento->timbreFiscalDigital['FechaTimbrado'])) }}
                <br/>
                @endif
            </td>
        </tr>
    </table>
    </div>
    <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_foreign_trade.tab_foreign_trades')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
            <tr>
                <td width="50%" style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_foreign_trade.entry_exchange_rate_usd'): </strong>{{ round($customer_foreign_trade->exchange_rate_usd,4) }}
                    <br/>
                    <strong>@lang('sales/customer_foreign_trade.entry_amount_total_usd'): </strong>{{ \App\Helpers\Helper::numberFormat($customer_foreign_trade->amount_total_usd, 2) }}
                    <br/>
                    <strong>@lang('sales/customer_foreign_trade.entry_operation_type_id'): </strong>{{ $customer_foreign_trade->operationType->name_sat }}
                    <br/>
                    <strong>@lang('sales/customer_foreign_trade.entry_pediment_id'): </strong>{{ $customer_foreign_trade->pediment->name_sat }}
                    <br/>
                    <strong>@lang('sales/customer_foreign_trade.entry_incoterm_id'): </strong>{{ $customer_foreign_trade->incoterm->name_sat }}
                    <br/>
                </td>
                <td width="50%" style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_foreign_trade.entry_origin_certificate'): </strong>{{ $customer_foreign_trade->origin_certificate == 1 ? __('sales/customer_foreign_trade.text_origin_certificate_1') : __('sales/customer_foreign_trade.text_origin_certificate_0') }}
                    <br/>
                    <strong>@lang('sales/customer_foreign_trade.entry_number_origin_certificate'): </strong>{{ $customer_foreign_trade->number_origin_certificate }}
                    <br/>
                    <strong>@lang('sales/customer_foreign_trade.entry_reliable_exporter_number'): </strong>{{ $customer_foreign_trade->reliable_exporter_number }}
                    <br/>
                </td>
            </tr>
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;" colspan="2">
                    <strong>@lang('sales/customer_foreign_trade.entry_comment_foreign_trade'): </strong>{{ $customer_foreign_trade->comment_foreign_trade }}
                    <br/>
                </td>
            </tr>
        </table>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_foreign_trade.text_foreign_trade_details')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
            <thead>
            <tr>
                <th width="7%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_product_id')) }}</th>
                <th class="text-left">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_name')) }}</th>
                <th width="7%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_tariff_fraction_id')) }}</th>
                <th width="9%">{!! mb_strtoupper(__('sales/customer_foreign_trade.column_line_customs_quantity')) !!}</th>
                <th width="14%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_uom_custom_id')) }}</th>
                <th width="12%">{!! mb_strtoupper(__('sales/customer_foreign_trade.column_line_price_unit_usd')) !!}</th>
                <th width="10%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_amount_usd')) }}</th>
            </tr>
            </thead>
            <tbody>
            @foreach($customer_foreign_trade->customerActiveInvoiceLines as $result)
                <tr>
                    <td class="text-center">{{ $result->product->code ?? '' }}</td>
                    <td>{!! nl2br($result->name) !!}</td>
                    <td class="text-center">{{ !empty($result->customerInvoiceLineComplement->tariffFraction->code) ? $result->customerInvoiceLineComplement->tariffFraction->code : '' }}</td>
                    <td class="text-center">{{ !empty($result->customerInvoiceLineComplement->customs_quantity) ? \App\Helpers\Helper::numberFormat($result->customerInvoiceLineComplement->customs_quantity,3) : '' }}</td>
                    <td class="text-center">{{ !empty($result->customerInvoiceLineComplement->uomCustom->code) ? $result->customerInvoiceLineComplement->uomCustom->name_sat : '' }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->customerInvoiceLineComplement->price_unit_usd,2) }}</td>
                    <td class="text-right">{{ \App\Helpers\Helper::numberFormatMoney($result->customerInvoiceLineComplement->amount_usd,2) }}</td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
    @if(!empty($customer_foreign_trade->cfdi_relation_id))
        <div>
        <p style="margin-bottom: 2px;">
            <strong>@lang('sales/customer_foreign_trade.tab_relations') - {{ $customer_foreign_trade->cfdiRelation->name_sat }}</strong>
        </p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                    @if($customer_foreign_trade->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_foreign_trade->customerInvoiceRelations as $result)
                            {{$result->relation->name ?? ''}}<br/>
                        @endforeach
                    @endif
                </td>
                <td width="85%" style="vertical-align: middle; padding: 5px;">
                    @if($customer_foreign_trade->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_foreign_trade->customerInvoiceRelations as $result)
                            {{$result->uuid_related}}<br/>
                        @endforeach
                    @endif
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_foreign_trade->comment))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_foreign_trade.entry_comment')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;">
                    {!! nl2br($customer_foreign_trade->comment) !!}
                </td>
            </tr>
        </table>
        </div>
    @endif
</section>
</body>
</html>
