<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_foreign_trade->documentType->name}}-{{$customer_foreign_trade->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 327px;
            margin-bottom: 27px;
            margin-left: 23px;
            margin-right: 23px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_foreign_trade->company_id) }}     !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_foreign_trade->company_id) }}     !important;
        }
        .cell-primary {
            border: 1px solid {{ \App\Helpers\Helper::companyColorPrimary($customer_foreign_trade->company_id) }}     !important;
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_foreign_trade->company_id) }}     !important;
            color: #ffffff;
            font-weight: bold;
            padding: 5px 2px;
            text-align: center !important;
            vertical-align: middle !important;
            text-transform: uppercase;
            font-size: 8pt;
        }
        .cell-primary-border-line {
            border: 1px solid #dddddd !important;
            border-radius: 0 0 3px 3px;
            padding: 5px 1px;
        }
    </style>
</head>
<body style="background-color: white;">
@php
//Obtiene datos del Cfdi33
$draft = (int) $customer_foreign_trade->status == \App\Models\Sales\CustomerInvoice::DRAFT ? true : false;
$cfdi33 = empty($data['cfdi33']) ? null : $data['cfdi33'];
$conceptos = null;
if($cfdi33){
    $conceptos = $cfdi33->conceptos;
    $conceptos = $conceptos();
}
@endphp
<section class="header" style="top: -289px;">
    @if($cfdi33 && $customer_foreign_trade->customerInvoiceCfdi->pac->test)
    <h2 style="position: absolute; left: 0; top: -35px; color: red;">*** @lang('general.text_test_cfdi') ***</h2>
    @endif
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
            <tr>
                <td width="22%" class="text-left" style="vertical-align: top; padding-bottom: 7px; height: 90px;">
                    @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                        <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_foreign_trade->company_id,$customer_foreign_trade->project_id) }}" class="invoice-logo" style="max-width: 160px !important; max-height: 60px !important;"/>
                    @elseif(!empty(setting('branch_office_logo_docs')))
                        <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_foreign_trade->company_id,$customer_foreign_trade->branch_office_id) }}" class="invoice-logo" style="max-width: 160px !important; max-height: 60px !important;"/>
                    @else
                        <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_foreign_trade->company_id) }}" class="invoice-logo" style="max-width: 160px !important; max-height: 60px !important;"/>
                    @endif
                </td>
                <td width="28%" class="text-left" style="vertical-align: top; padding-bottom: 7px; padding-left: 5px;">
                    @if(!empty($customer_foreign_trade->company->comercial_name))
                    <span class="text-primary" style="font-size: 8pt;">{{ mb_strtoupper($customer_foreign_trade->company->comercial_name) }}</span>
                    <br/>
                    @endif
                    {{ mb_strtoupper($customer_foreign_trade->company->name) }}
                    @if(!empty($customer_foreign_trade->company->address_1) || !empty($customer_foreign_trade->company->address_2) || !empty($customer_foreign_trade->company->address_3) || !empty($customer_foreign_trade->company->address_4))
                        <br/>
                        {{ $customer_foreign_trade->company->address_1 ?? '' }} {{ $customer_foreign_trade->company->address_2 ?? '' }} {{ $customer_foreign_trade->company->address_3 ?? '' }} {{ $customer_foreign_trade->company->address_4 ?? '' }}
                    @endif
                    @if(!empty($customer_foreign_trade->company->city->name) || !empty($customer_foreign_trade->company->state->name))
                        <br/>
                        {{ !empty($customer_foreign_trade->company->city->name) ? $customer_foreign_trade->company->city->name . ', ' : '' }}{{ $customer_foreign_trade->company->state->name ?? '' }}
                    @endif
                    <br/>
                    {{ $customer_foreign_trade->company->country->name ?? '' }}{!! ($customer_foreign_trade->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_foreign_trade->company->postcode : '') !!}
                    <br/>
                    {{ mb_strtoupper($customer_foreign_trade->company->taxid) }}{{ !empty($customer_foreign_trade->company->curp) ? ' / ' . $customer_foreign_trade->company->curp : '' }}
                    <br/>
                    ---
                    <br/>
                    {{ $customer_foreign_trade->company->phone ?? ' ' }}
                    <br/>
                    <span style="text-transform: lowercase;">{{ $customer_foreign_trade->company->email ?? ' ' }}</span>
                </td>
                <td width="29%" class="text-left" rowspan="2" style="vertical-align: top; padding-left: 5px; padding-bottom: 7px; border-left: 1px solid #333333;">
                    <h3 style="margin: 0;">{{ mb_strtoupper($customer_foreign_trade->documentType->name) }}</h3><br>
                    <strong>@lang('general.text_cfdi_uuid'):</strong><br/>
                    {{ $customer_foreign_trade->customerInvoiceCfdi->uuid ?? '' }}<br/>
                    <strong>@lang('sales/customer_foreign_trade.entry_date'):</strong><br/>
                    {{ str_replace(' ',' ',\App\Helpers\Helper::convertSqlToDateTime($customer_foreign_trade->date)) }}<br/>
                    <strong>@lang('sales/customer_foreign_trade.entry_date_due'):</strong><br/>
                    {{ \App\Helpers\Helper::convertSqlToDate($customer_foreign_trade->date_due) }}<br/>
                    @if(!empty($cfdi33))
                        <strong>@lang('general.text_cfdi_tfd_fecha_timbrado'):</strong><br/>
                        {{ \App\Helpers\Helper::convertSqlToDateTime(str_replace('T',' ',$cfdi33->complemento->timbreFiscalDigital['FechaTimbrado'])) }}<br>
                        <strong>@lang('general.text_cfdi_certificado'):</strong><br/>
                        {{ $cfdi33['NoCertificado'] }}<br/>
                        <strong>@lang('general.text_cfdi_tfd_no_certificado_sat'):</strong><br/>
                        {{ $cfdi33->complemento->timbreFiscalDigital['NoCertificadoSAT'] }}<br/>
                    @endif
                </td>
                <td width="21%" class="text-center" rowspan="2" style="vertical-align: top; padding-bottom: 7px;">
                    @if(!empty($cfdi33))
                        <img src="{{ $data['qr'] }}" width="120px" style="margin: 5px 0;"/>
                    @endif

                </td>
            </tr>
            <tr>
                <td width="50%" class="text-left" colspan="2" style="vertical-align: top; padding-top: 1px; padding-bottom: 7px;">
                    <table cellpadding="0" cellspacing="0" class="" width="100%">
                        <tr>
                            <td width="30%">@lang('sales/customer_foreign_trade.entry_name')</td>
                            <td width="70%">{{ $customer_foreign_trade->name }}</td>
                        </tr>
                        <tr>
                            <td>@lang('base/document_type.entry_cfdi_type_id')</td>
                            <td>{{ $customer_foreign_trade->documentType->cfdiType->name_sat ?? ''}}</td>
                        </tr>
                        <tr>
                            <td>@lang('sales/customer_foreign_trade.entry_payment_way_id')</td>
                            <td>{{ $customer_foreign_trade->paymentWay->name_sat }}</td>
                        </tr>
                        <tr>
                            <td>@lang('sales/customer_foreign_trade.entry_currency_id')</td>
                            <td>
                                {{ $customer_foreign_trade->currency->code }}
                                @if($customer_foreign_trade->currency->code!='MXN')
                                    {{ '&nbsp;&nbsp;&nbsp;' . __('sales/customer_foreign_trade.entry_currency_value') . ': '. round($customer_foreign_trade->currency_value,4)}}
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td>@lang('sales/customer_foreign_trade.entry_payment_method_id')</td>
                            <td>{{ $customer_foreign_trade->paymentMethod->name_sat }}</td>
                        </tr>
                        <tr>
                            <td>@lang('sales/customer_foreign_trade.entry_payment_term_id')</td>
                            <td>{{ $customer_foreign_trade->paymentTerm->name }}</td>
                        </tr>
                        <tr>
                            <td>@lang('base/company.column_tax_regimen')</td>
                            <td>{{ $data['tax_regimen'] ?? ($customer_foreign_trade->taxRegimen->name_sat ?? $customer_foreign_trade->company->taxRegimen->name_sat) }}</td>
                        </tr>
                        <tr>
                            <td>@lang('general.text_issued_in')</td>
                            <td>{{ $customer_foreign_trade->branchOffice->postcode }}</td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
            <tr>
                <td width="50%" class="text-left" style="vertical-align: top; padding-bottom: 7px; padding-top: 7px; border-top: 1px solid #333333; border-bottom: 1px solid #333333; height: 50px; ">
                    <strong>{{ mb_strtoupper($customer_foreign_trade->customer->name) }}</strong>
                    <br>
                    @if(!empty($customer_foreign_trade->customer->address_1) || !empty($customer_foreign_trade->customer->address_2) || !empty($customer_foreign_trade->customer->address_3) || !empty($customer_foreign_trade->customer->address_4))
                        {{ $customer_foreign_trade->customer->address_1 ?? '' }} {{ $customer_foreign_trade->customer->address_2 ?? '' }} {{ $customer_foreign_trade->customer->address_3 ?? '' }} {{ $customer_foreign_trade->customer->address_4 ?? '' }}
                        <br/>
                    @endif
                    @if(!empty($customer_foreign_trade->customer->city->name) || !empty($customer_foreign_trade->customer->state->name))
                        {{ !empty($customer_foreign_trade->customer->city->name) ? $customer_foreign_trade->customer->city->name . ', ' : '' }}{{ $customer_foreign_trade->customer->state->name ?? '' }}
                        <br/>
                    @endif
                    {{ $customer_foreign_trade->customer->country->code ? '[' . $customer_foreign_trade->customer->country->code . '] ' : '' }}{{ $customer_foreign_trade->customer->country->name ?? '' }}{!! ($customer_foreign_trade->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_foreign_trade->customer->postcode : '') !!}
                </td>
                <td width="50%" class="text-left" style="vertical-align: top; padding-bottom: 7px; padding-top: 7px; border-top: 1px solid #333333; border-bottom: 1px solid #333333; height: 50px;">
                    @lang('sales/customer.entry_taxid'): {{ mb_strtoupper($customer_foreign_trade->customer->taxid) }}
                    <br/>
                    @lang('sales/customer_foreign_trade.entry_cfdi_use_id'): {{ $customer_foreign_trade->cfdiUse->name_sat }}
                </td>
            </tr>
        </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_foreign_trade->status == \App\Models\Sales\CustomerInvoice::CANCEL)
    <section class="watermark" style="bottom: 450px !important;">
        @if(!empty($customer_foreign_trade->customerInvoiceCfdi->uuid))
            <span>@lang('general.text_canceled_cfdi')</span>
        @else
            <span>@lang('general.text_canceled')</span>
        @endif
    </section>
@endif
@if($draft)
    <section class="watermark" style="bottom: 700px !important;">
        <span>@lang('general.text_pre_invoice')</span>
    </section>
@endif
<section>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
            <thead>
            <tr>
                <th width="7%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_quantity')) }}</th>
                <th class="text-left">
                    @if(!empty(setting('show_product_code_on_pdf')))
                        {{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_product_id')) }} -
                        {{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_name')) . ' - ' . mb_strtoupper(__('sales/customer_foreign_trade.column_line_sat_product_id')) }}
                    @else
                        {{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_sat_product_id')) . ' - ' . mb_strtoupper(__('sales/customer_foreign_trade.column_line_name')) }}
                    @endif
                </th>
                <th width="14%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_unit_measure_id')) }}</th>
                <th width="9%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_price_unit')) }}</th>
                <th width="6%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_discount')) }}</th>
                <th width="11%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_amount_untaxed')) }}</th>
            </tr>
            </thead>
            <tbody>
            @if($conceptos)
                @foreach($conceptos as $result)
                    @php
                        //Complemento concepto

                    @endphp
                    <tr>
                        <td class="text-center">{{ \App\Helpers\Helper::numberFormatRealDecimalPlace($result['Cantidad']) }}</td>
                        <td>
                            @if(!empty(setting('show_product_code_on_pdf')))
                                {{$result['NoIdentificacion'] ?? 'N/A'}} -
                                {!! nl2br($result['Descripcion']) !!} ({{ $result['ClaveProdServ'] }})
                            @else
                                {{ $result['ClaveProdServ'] }} -
                                {!! nl2br($result['Descripcion']) !!}
                            @endif
                        </td>
                        <td class="text-center">[{{ $result['ClaveUnidad'] }}] {{ $result['Unidad'] }}</td>
                        <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result['ValorUnitario'],\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_foreign_trade->company_id)) }}</td>
                        <td class="text-center">{{ \App\Helpers\Helper::numberFormat(!empty($result['Descuento']) ? $result['Descuento']/$result['Importe'] : 0,2) }}</td>
                        <td class="text-right">{{ money($result['Importe'],$customer_foreign_trade->currency->code,true) }}</td>
                    </tr>
                @endforeach
            @else
                @foreach($customer_foreign_trade->customerActiveInvoiceLines as $result)
                    <tr>
                        <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                        <td>
                            @if(!empty(setting('show_product_code_on_pdf')))
                                {{$result->product->code ?? 'N/A'}} -
                                {!! nl2br($result->name) !!} ({{ $result->satProduct->code }})
                            @else
                                {{ $result->satProduct->code }} - {!! nl2br($result->name) !!}
                            @endif
                        </td>
                        <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                        <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_foreign_trade->company_id)) }}</td>
                        <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                        <td class="text-right">{{ money($result->amount_untaxed,$customer_foreign_trade->currency->code,true) }}</td>
                    </tr>
                @endforeach
            @endif
            </tbody>
            <tfoot>
            <tr>
                <td colspan="6" class="text-left" style="vertical-align: top; height: 50px;">
                    {!! nl2br($customer_foreign_trade->comment) !!}
                </td>
            </tr>
            <tr>
                <td colspan="3" class="text-left" style="vertical-align: top;">
                            <span style="line-height: 16px;">
                                ***({{\App\Helpers\Helper::numberToWordCurrency($customer_foreign_trade->amount_total,$customer_foreign_trade->currency->code,$customer_foreign_trade->currency->decimal_place)}})***
                            </span>
                </td>
                <td colspan="2" class="text-right" style="vertical-align: top; padding-right: 4px;">
                    <strong>@lang('general.text_amount_untaxed')</strong><br/>
                    @if($customer_foreign_trade->customerInvoiceTaxes->isNotEmpty())
                        @foreach($customer_foreign_trade->customerInvoiceTaxes as $result)
                            <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                        @endforeach
                    @endif
                    <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
                </td>
                <td class="text-right">
                    {{ money($customer_foreign_trade->amount_untaxed,$customer_foreign_trade->currency->code,true) }}<br/>
                    @if($customer_foreign_trade->customerInvoiceTaxes->isNotEmpty())
                        @foreach($customer_foreign_trade->customerInvoiceTaxes as $result)
                            <span style="line-height: 16px;">{{money(abs($result->amount_tax),$customer_foreign_trade->currency->code,true)}}</span><br/>
                        @endforeach
                    @endif
                    <span style="line-height: 16px;"><strong>{{ money($customer_foreign_trade->amount_total,$customer_foreign_trade->currency->code,true) }}</strong></span>
                </td>
            </tr>
            </tfoot>
        </table>
    </div>
    <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_foreign_trade.tab_foreign_trades')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
            <tr>
                <td width="50%" style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_foreign_trade.entry_exchange_rate_usd'): </strong>{{ round($customer_foreign_trade->exchange_rate_usd,4) }}
                    <br/>
                    <strong>@lang('sales/customer_foreign_trade.entry_amount_total_usd'): </strong>{{ \App\Helpers\Helper::numberFormat($customer_foreign_trade->amount_total_usd, 2) }}
                    <br/>
                    <strong>@lang('sales/customer_foreign_trade.entry_operation_type_id'): </strong>{{ $customer_foreign_trade->operationType->name_sat }}
                    <br/>
                    <strong>@lang('sales/customer_foreign_trade.entry_pediment_id'): </strong>{{ $customer_foreign_trade->pediment->name_sat }}
                    <br/>
                    <strong>@lang('sales/customer_foreign_trade.entry_incoterm_id'): </strong>{{ $customer_foreign_trade->incoterm->name_sat }}
                    <br/>
                </td>
                <td width="50%" style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_foreign_trade.entry_origin_certificate'): </strong>{{ $customer_foreign_trade->origin_certificate == 1 ? __('sales/customer_foreign_trade.text_origin_certificate_1') : __('sales/customer_foreign_trade.text_origin_certificate_0') }}
                    <br/>
                    <strong>@lang('sales/customer_foreign_trade.entry_number_origin_certificate'): </strong>{{ $customer_foreign_trade->number_origin_certificate }}
                    <br/>
                    <strong>@lang('sales/customer_foreign_trade.entry_reliable_exporter_number'): </strong>{{ $customer_foreign_trade->reliable_exporter_number }}
                    <br/>
                </td>
            </tr>
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;" colspan="2">
                    <strong>@lang('sales/customer_foreign_trade.entry_comment_foreign_trade'): </strong>{{ $customer_foreign_trade->comment_foreign_trade }}
                    <br/>
                </td>
            </tr>
        </table>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_foreign_trade.text_foreign_trade_details')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
            <thead>
            <tr>
                <th width="7%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_product_id')) }}</th>
                <th class="text-left">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_name')) }}</th>
                <th width="7%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_tariff_fraction_id')) }}</th>
                <th width="9%">{!! mb_strtoupper(__('sales/customer_foreign_trade.column_line_customs_quantity')) !!}</th>
                <th width="14%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_uom_custom_id')) }}</th>
                <th width="12%">{!! mb_strtoupper(__('sales/customer_foreign_trade.column_line_price_unit_usd')) !!}</th>
                <th width="10%">{{ mb_strtoupper(__('sales/customer_foreign_trade.column_line_amount_usd')) }}</th>
            </tr>
            </thead>
            <tbody>
            @foreach($customer_foreign_trade->customerActiveInvoiceLines as $result)
                <tr>
                    <td class="text-center">{{ $result->product->code ?? '' }}</td>
                    <td>{!! nl2br($result->name) !!}</td>
                    <td class="text-center">{{ !empty($result->customerInvoiceLineComplement->tariffFraction->code) ? $result->customerInvoiceLineComplement->tariffFraction->code : '' }}</td>
                    <td class="text-center">{{ !empty($result->customerInvoiceLineComplement->customs_quantity) ? \App\Helpers\Helper::numberFormat($result->customerInvoiceLineComplement->customs_quantity,3) : '' }}</td>
                    <td class="text-center">{{ !empty($result->customerInvoiceLineComplement->uomCustom->code) ? $result->customerInvoiceLineComplement->uomCustom->name_sat : '' }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->customerInvoiceLineComplement->price_unit_usd,2) }}</td>
                    <td class="text-right">{{ \App\Helpers\Helper::numberFormatMoney($result->customerInvoiceLineComplement->amount_usd,2) }}</td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
    @if(!empty($cfdi33))
        <div>
            <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                <tr>
                    <td width="" class="cell-primary" style=""><small>@lang('general.text_cfdi_tfd_cadena_origen')</small></td>
                </tr>
                <tr>
                    <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 45px; padding: 5px;  word-wrap:break-word;">
                        <small>{{ $data['tfd_cadena_origen'] }}</small>
                    </td>
                </tr>
            </table>
        </div>
        <div>
            <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                <tr>
                    <td width="" class="cell-primary" style=""><small>@lang('general.text_cfdi_tfd_sello_cfdi')</small></td>
                </tr>
                <tr>
                    <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 35px; padding: 5px;  word-wrap:break-word;">
                        <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloCFD'] }}</small>
                    </td>
                </tr>
            </table>
        </div>
        <div>
            <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                <tr>
                    <td width="" class="cell-primary" style=""><small>@lang('general.text_cfdi_tfd_sello_sat')</small></td>
                </tr>
                <tr>
                    <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 35px; padding: 5px;  word-wrap:break-word;">
                        <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloSAT'] }}</small>
                    </td>
                </tr>
            </table>
        </div>
    @endif
    @if(!empty($customer_foreign_trade->cfdi_relation_id))
        <div>
            <p style="margin-bottom: 2px;">
                <strong>@lang('sales/customer_foreign_trade.tab_relations') - {{ $customer_foreign_trade->cfdiRelation->name_sat }}</strong>
            </p>
            <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
                <tr>
                    <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                        @if($customer_foreign_trade->customerInvoiceRelations->isNotEmpty())
                            @foreach($customer_foreign_trade->customerInvoiceRelations as $result)
                                {{$result->relation->name ?? ''}}<br/>
                            @endforeach
                        @endif
                    </td>
                    <td width="85%" style="vertical-align: middle; padding: 5px;">
                        @if($customer_foreign_trade->customerInvoiceRelations->isNotEmpty())
                            @foreach($customer_foreign_trade->customerInvoiceRelations as $result)
                                {{$result->uuid_related}}<br/>
                            @endforeach
                        @endif
                    </td>
                </tr>
            </table>
        </div>
    @endif
</section>
</body>
</html>
