<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_lease->documentType->name}}-{{$customer_lease->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 335px;
            margin-bottom: 225px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_lease->company_id) }}     !important;
        }
        .text-secondary{
            color: #888888;
            font-weight: bold;
            font-size: 9pt;
        }
        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_lease->company_id) }}     !important;
        }
        .table-items tbody td {
            padding: 8px 2px;
            border: none;
            border-bottom: 1px solid #cccccc;
        }
        .table-footer td {
            background-color: #FEFEFE;
            border: none;
        }
        .table-items tfoot td {
            padding: 4px 2px;
            border: none;
            border-bottom: 1px solid #cccccc;
        }
        .table-secundary td {
            background-color: #FAFAFA;
            border: none;
            border-bottom: 1px solid #cccccc;
        }
        .table-resume td {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_lease->company_id) }}     !important;
            color: #FFFFFF;
        }
    </style>
</head>
<body style="background-color: white;">
@php
//Obtiene datos del Cfdi33
$draft = (int) $customer_lease->status == \App\Models\Sales\CustomerInvoice::DRAFT ? true : false;
$cfdi33 = empty($data['cfdi33']) ? null : $data['cfdi33'];
$conceptos = null;
if($cfdi33){
    $conceptos = $cfdi33->conceptos;
    $conceptos = $conceptos();
}
@endphp
<section class="header" style="top: -312px;">
    @if($cfdi33 && $customer_lease->customerInvoiceCfdi->pac->test)
    <h2 style="position: absolute; left: 0; top: -15px; color: red;">*** @lang('general.text_test_cfdi') ***</h2>
    @endif
    <div>
    <table cellpadding="2" cellspacing="0" class="" width="100%">
        <tr>
            <td width="55%" style="border-bottom: 1px solid #cccccc; border-right: 1px solid #cccccc; padding: 5px 15px 10px 8px;">
                <h1 class="text-primary text-center" style="font-size: 20px; margin-bottom: 15px;">{{ mb_strtoupper($customer_lease->documentType->name) }}</h1>
                <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px;">
                    <tr>
                        <td width="50%" class="text-center" style="">
                            <span class="text-secondary"># {{ $customer_lease->name }}</span>
                        </td>
                        <td width="50%" class="text-center" style="">
                            <span class="text-secondary">{{ \App\Helpers\Helper::convertSqlToDateTime($customer_lease->date) }}</span>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" style="padding-bottom: 8px;">
                            <hr style="border-bottom: 1px solid #cccccc;">
                        </td>
                    </tr>
                    <tr>
                        <td width="50%" class="text-center" style="padding-bottom: 5px;">
                            <span class="text-secondary" style="font-size: 9px; font-weight: normal;">@lang('general.text_amount_total')</span>
                        </td>
                        <td width="50%" class="text-center" class="text-right" style="padding-bottom: 5px;">
                            <span class="text-secondary" style="font-size: 9px; font-weight: normal;">@lang('sales/customer_lease.entry_date_due')</span>
                        </td>
                    </tr>
                    <tr>
                        <td width="50%" class="text-center" style="font-size: 11px; padding-bottom: 5px;">
                            <strong>{{ money($customer_lease->amount_total,$customer_lease->currency->code,true) }}</strong>
                        </td>
                        <td width="50%" class="text-center" class="text-right" style="font-size: 11px; padding-bottom: 5px;">
                            <strong>{{ \App\Helpers\Helper::convertSqlToDate($customer_lease->date_due) }}</strong>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" class="text-center" style="padding-top: 20px;">
                            <span class="text-primary">{{ mb_strtoupper($customer_lease->company->comercial_name) }}</span>
                        </td>
                    </tr>
                </table>
            </td>
            <td class="text-company" style="border-bottom: 1px solid #cccccc; padding: 5px 0 10px 13px; height: 160px;">
                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_lease->company_id,$customer_lease->project_id) }}" class="" style="max-height: 50px; max-width: 220px; margin-bottom: 5px;"/>
                @elseif(!empty(setting('branch_office_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_lease->company_id,$customer_lease->branch_office_id) }}" class="" style="max-height: 50px; max-width: 220px; margin-bottom: 5px;"/>
                @else
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_lease->company_id) }}" class="" style="max-height: 50px; max-width: 220px; margin-bottom: 5px;"/>
                @endif
                <br/>
                <strong class="">{{ mb_strtoupper($customer_lease->company->name) }}</strong>
                <br/>
                {{ $data['tax_regimen'] ?? ($customer_lease->taxRegimen->name_sat ?? $customer_lease->company->taxRegimen->name_sat) }}
                @if(!empty($customer_lease->company->address_1) || !empty($customer_lease->company->address_2) || !empty($customer_lease->company->address_3) || !empty($customer_lease->company->address_4))
                    <br/>
                    {{ $customer_lease->company->address_1 ?? '' }} {{ $customer_lease->company->address_2 ?? '' }} {{ $customer_lease->company->address_3 ?? '' }} {{ $customer_lease->company->address_4 ?? '' }}
                @endif
                @if(!empty($customer_lease->company->city->name) || !empty($customer_lease->company->state->name))
                    <br/>
                    {{ !empty($customer_lease->company->city->name) ? $customer_lease->company->city->name . ', ' : '' }}{{ $customer_lease->company->state->name ?? '' }}
                @endif
                <br/>
                {{ $customer_lease->company->country->name ?? '' }}{!! ($customer_lease->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_lease->company->postcode : '') !!}
                <br/>
                {{ mb_strtoupper($customer_lease->company->taxid) }}
                <br/>
                ---
                <br/>
                {{ $customer_lease->company->phone ?? ' ' }} | {{ $customer_lease->company->email ?? ' ' }}
            </td>
        </tr>
        <tr>
            <td style="padding: 10px 15px 10px 8px; border-right: 1px solid #cccccc;">
                <strong>@lang('general.text_cfdi_uuid'): </strong>{{ $customer_lease->customerInvoiceCfdi->uuid ?? '' }}
                <br/>
                <strong>@lang('base/document_type.entry_cfdi_type_id'): </strong>{{ $customer_lease->documentType->cfdiType->name_sat ?? '' }}
                <br/>
                <strong>@lang('sales/customer_lease.entry_payment_term_id'): </strong>{{ $customer_lease->paymentTerm->name }}
                <br/>
                <strong>@lang('sales/customer_lease.entry_cfdi_use_id'): </strong>{{ $customer_lease->cfdiUse->name_sat }}
                <br/>
                <strong>@lang('general.text_issued_in'): </strong>{{ $customer_lease->branchOffice->name ?? '' }} {!! ($customer_lease->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $customer_lease->branchOffice->postcode : '') !!}
                <br/>
            </td>
            <td class="text-company" style="padding: 10px 0px 10px 13px;">
                <strong class="" style="color: #999999; padding-bottom: 10px;"><small>{{ (__('general.text_customer')) }}</small></strong>
                <br/><br/>
                <strong style="margin-top: 10px;">{{ mb_strtoupper($customer_lease->customer->name) }}</strong>
                @if(!empty($customer_lease->customer->address_1) || !empty($customer_lease->customer->address_2) || !empty($customer_lease->customer->address_3) || !empty($customer_lease->customer->address_4))
                    <br/>
                    {{ $customer_lease->customer->address_1 ?? '' }} {{ $customer_lease->customer->address_2 ?? '' }} {{ $customer_lease->customer->address_3 ?? '' }} {{ $customer_lease->customer->address_4 ?? '' }},
                @endif
                @if(!empty($customer_lease->customer->city->name) || !empty($customer_lease->customer->state->name))
                    <br/>
                    {{ !empty($customer_lease->customer->city->name) ? $customer_lease->customer->city->name . ', ' : '' }}{{ $customer_lease->customer->state->name ?? '' }}
                @endif
                <br/>
                {{ $customer_lease->customer->country->name ?? '' }}{!! ($customer_lease->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_lease->customer->postcode : '') !!}
                <br/>
                {{ mb_strtoupper($customer_lease->customer->taxid) }}
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="footer">
    <div>
    <table cellpadding="0" cellspacing="0" class="table-footer" width="100%"
           style="margin-top: 5px; table-layout: fixed;">
        <tr>
            <td width="23%" class="text-center" style="vertical-align: middle; padding: 5px; word-wrap:break-word; border-top: 1px solid #cccccc;">
                @if(!empty($cfdi33))
                <img src="{{ $data['qr'] }}" width="137px" style="margin: 9px 0;"/>
                @endif
            </td>
            <td width="77%" style="vertical-align: middle; padding: 5px; word-wrap:break-word; height: 180px; border-top: 1px solid #cccccc;">
                @if(!empty($cfdi33))
                <strong>@lang('general.text_cfdi_tfd_cadena_origen')</strong><br/>
                <small>{{ $data['tfd_cadena_origen'] }}</small>
                <br/>
                <strong>@lang('general.text_cfdi_tfd_sello_cfdi')</strong><br/>
                <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloCFD'] }}</small>
                <br/>
                <strong>@lang('general.text_cfdi_tfd_sello_sat')</strong><br/>
                <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloSAT'] }}</small>
                <br/>
                @endif
            </td>
        </tr>
    </table>
    </div>
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_lease->status == \App\Models\Sales\CustomerInvoice::CANCEL)
    <section class="watermark" style="bottom: 450px !important;">
        @if(!empty($customer_lease->customerInvoiceCfdi->uuid))
            <span>@lang('general.text_canceled_cfdi')</span>
        @else
            <span>@lang('general.text_canceled')</span>
        @endif
    </section>
@endif
@if($draft)
    <section class="watermark" style="bottom: 450px !important;">
        <span>@lang('general.text_pre_lease')</span>
    </section>
@endif
<section>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
        <thead>
        <tr>
            <th class="text-left">{{ mb_strtoupper(__('sales/customer_lease.column_line_name')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_lease.column_line_sat_product_id')) }}</th>
            <th width="14%">{{ mb_strtoupper(__('sales/customer_lease.column_line_unit_measure_id')) }}</th>
            <th width="7%">{{ mb_strtoupper(__('sales/customer_lease.column_line_quantity')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_lease.column_line_price_unit')) }}</th>
            <th width="6%">{{ mb_strtoupper(__('sales/customer_lease.column_line_discount')) }}</th>
            <th width="11%">{{ mb_strtoupper(__('sales/customer_lease.column_line_amount_untaxed')) }}</th>
        </tr>
        </thead>
        <tbody>
        @if($conceptos)
        @foreach($conceptos as $result)
            @php
                //Complemento concepto

            @endphp
            <tr>
                <td>
                    @if(!empty(setting('show_product_code_on_pdf')))
                        {{$result['NoIdentificacion'] ?? 'N/A'}} -
                    @endif
                    {!! nl2br($result['Descripcion']) !!}
                    @php
                    //Numero predial
                    foreach(($result)() as $result2){
                        if((string)$result2 == 'CuentaPredial'){
                            echo '<br/><br/>';
                            echo __('sales/customer_lease.column_line_numero_predial') . ': '.$result2['Numero'].'<br/>';
                            break;
                        }
                    }
                    @endphp
                </td>
                <td class="text-center">{{ $result['ClaveProdServ'] }}</td>
                <td class="text-center">[{{ $result['ClaveUnidad'] }}] {{ $result['Unidad'] }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatRealDecimalPlace($result['Cantidad']) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result['ValorUnitario'],\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_lease->company_id)) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormat(!empty($result['Descuento']) ? $result['Descuento']/$result['Importe'] : 0,2) }}</td>
                <td class="text-right">{{ money($result['Importe'],$customer_lease->currency->code,true) }}</td>
            </tr>
        @endforeach
        @else
            @foreach($customer_lease->customerActiveInvoiceLines as $result)
                <tr>
                    <td>
                        @if(!empty(setting('show_product_code_on_pdf')))
                            {{$result->product->code ?? 'N/A'}} -
                        @endif
                        {!! nl2br($result->name) !!}
                    </td>
                    <td class="text-center">{{ $result->satProduct->code }}</td>
                    <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_lease->company_id)) }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                    <td class="text-right">{{ money($result->amount_untaxed,$customer_lease->currency->code,true) }}</td>
                </tr>
            @endforeach
        @endif
        </tbody>
        <tfoot>
        <tr>
            <td colspan="4" class="text-center" style="vertical-align: bottom;">
                <span style="line-height: 16px;">
                    ***({{\App\Helpers\Helper::numberToWordCurrency($customer_lease->amount_total,$customer_lease->currency->code,$customer_lease->currency->decimal_place)}})***
                </span>
            </td>
            <td colspan="2" class="text-right" style="vertical-align: top; padding-right: 4px;">
                <strong>@lang('general.text_amount_untaxed')</strong><br/>
                @if($customer_lease->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_lease->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
            </td>
            <td class="text-right">
                {{ money($customer_lease->amount_untaxed,$customer_lease->currency->code,true) }}<br/>
                @if($customer_lease->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_lease->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;">{{money(abs($result->amount_tax),$customer_lease->currency->code,true)}}</span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ money($customer_lease->amount_total,$customer_lease->currency->code,true) }}</strong></span>
            </td>
        </tr>
        </tfoot>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="50%" style="vertical-align: top; padding: 5px;">
                <strong>@lang('sales/customer_lease.entry_payment_way_id'): </strong>{{ $customer_lease->paymentWay->name_sat }}
                <br/>
                <strong>@lang('sales/customer_lease.entry_payment_method_id'): </strong>{{ $customer_lease->paymentMethod->name_sat }}
                <br/>
                <strong>@lang('sales/customer_lease.entry_currency_id'): </strong>{{ $customer_lease->currency->code }}{!! ($customer_lease->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/customer_lease.entry_currency_value').':</strong> '.round($customer_lease->currency_value,4) :'') !!}
                <br/>
            </td>
            <td width="50%" style="vertical-align: top; padding: 5px;">
                @if(!empty($cfdi33))
                    <strong>@lang('general.text_cfdi_certificado'): </strong>{{ $cfdi33['NoCertificado'] }}
                    <br/>
                    <strong>@lang('general.text_cfdi_tfd_no_certificado_sat'): </strong>{{ $cfdi33->complemento->timbreFiscalDigital['NoCertificadoSAT'] }}
                    <br/>
                    <strong>@lang('general.text_cfdi_tfd_fecha_timbrado'): </strong>{{ \App\Helpers\Helper::convertSqlToDateTime(str_replace('T',' ',$cfdi33->complemento->timbreFiscalDigital['FechaTimbrado'])) }}
                    <br/>
                @endif
            </td>
        </tr>
    </table>
    </div>
    @if(!empty($customer_lease->cfdi_relation_id))
        <div>
        <p style="margin-bottom: 2px;">
            <strong>@lang('sales/customer_lease.tab_relations') - {{ $customer_lease->cfdiRelation->name_sat }}</strong>
        </p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                    @if($customer_lease->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_lease->customerInvoiceRelations as $result)
                            {{$result->relation->name ?? ''}}<br/>
                        @endforeach
                    @endif
                </td>
                <td width="85%" style="vertical-align: middle; padding: 5px;">
                    @if($customer_lease->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_lease->customerInvoiceRelations as $result)
                            {{$result->uuid_related}}<br/>
                        @endforeach
                    @endif
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_lease->comment))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_lease.entry_comment')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;">
                    {!! nl2br($customer_lease->comment) !!}
                </td>
            </tr>
        </table>
        </div>
    @endif
</section>
</body>
</html>
