<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_lease->documentType->name}}-{{$customer_lease->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 300px;
            margin-bottom: 27px;
            margin-left: 23px;
            margin-right: 23px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_lease->company_id) }}     !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_lease->company_id) }}     !important;
        }
        .cell-primary {
            border: 1px solid {{ \App\Helpers\Helper::companyColorPrimary($customer_lease->company_id) }}     !important;
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_lease->company_id) }}     !important;
            color: #ffffff;
            font-weight: bold;
            padding: 5px 2px;
            text-align: center !important;
            vertical-align: middle !important;
            text-transform: uppercase;
            font-size: 8pt;
        }
        .cell-primary-border-line {
            border: 1px solid {{ \App\Helpers\Helper::companyColorPrimary($customer_lease->company_id) }}     !important;
            border-radius: 0 0 3px 3px;
            padding: 5px 1px;
        }
    </style>
</head>
<body style="background-color: white;">
@php
//Obtiene datos del Cfdi33
$draft = (int) $customer_lease->status == \App\Models\Sales\CustomerInvoice::DRAFT ? true : false;
$cfdi33 = empty($data['cfdi33']) ? null : $data['cfdi33'];
$conceptos = null;
if($cfdi33){
    $conceptos = $cfdi33->conceptos;
    $conceptos = $conceptos();
}
@endphp
<section class="header" style="top: -272px;">
    @if($cfdi33 && $customer_lease->customerInvoiceCfdi->pac->test)
    <h2 style="position: absolute; left: 0; top: -25px; color: red;">*** @lang('general.text_test_cfdi') ***</h2>
    @endif
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
            <tr>
                <td width="25%" class="" style="vertical-align: top; ">
                    @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                        <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_lease->company_id,$customer_lease->project_id) }}" class="invoice-logo" style="max-width: 160px !important;"/>
                    @elseif(!empty(setting('branch_office_logo_docs')))
                        <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_lease->company_id,$customer_lease->branch_office_id) }}" class="invoice-logo" style="max-width: 160px !important;"/>
                    @else
                        <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_lease->company_id) }}" class="invoice-logo" style="max-width: 160px !important;"/>
                    @endif
                </td>
                <td width="25%" style="vertical-align: top; text-transform: uppercase;">
                    @if(!empty($customer_lease->company->comercial_name))
                    <span class="text-primary" style="font-size: 8pt;">{{ mb_strtoupper($customer_lease->company->comercial_name) }}</span>
                    <br/>
                    <br/>
                    @endif
                    <strong>{{ mb_strtoupper($customer_lease->company->name) }}</strong>
                    @if(!empty($customer_lease->company->address_1) || !empty($customer_lease->company->address_2) || !empty($customer_lease->company->address_3) || !empty($customer_lease->company->address_4))
                        <br/>
                        {{ $customer_lease->company->address_1 ?? '' }} {{ $customer_lease->company->address_2 ?? '' }} {{ $customer_lease->company->address_3 ?? '' }} {{ $customer_lease->company->address_4 ?? '' }}
                    @endif
                    @if(!empty($customer_lease->company->city->name) || !empty($customer_lease->company->state->name))
                        <br/>
                        {{ !empty($customer_lease->company->city->name) ? $customer_lease->company->city->name . ', ' : '' }}{{ $customer_lease->company->state->name ?? '' }}
                    @endif
                    <br/>
                    {{ $customer_lease->company->country->name ?? '' }}{!! ($customer_lease->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_lease->company->postcode : '') !!}
                    <br/>
                    {{ mb_strtoupper($customer_lease->company->taxid) }}
                    <br/>
                    ---
                    <br/>
                    {{ $customer_lease->company->phone ?? ' ' }}
                    <br/>
                    <span style="text-transform: lowercase;">{{ $customer_lease->company->email ?? ' ' }}</span>
                </td>
                <td width="22%" style="vertical-align: top; text-transform: uppercase;">
                    <strong>@lang('general.text_issued_in')</strong>
                    <br/>
                    @if(!empty($customer_lease->branchOffice->address_1) || !empty($customer_lease->branchOffice->address_2))
                        <br/>
                        {{ $customer_lease->branchOffice->address_1 ?? '' }} {{ $customer_lease->branchOffice->address_2 ?? '' }}
                    @endif
                    @if(!empty($customer_lease->branchOffice->address_3) || !empty($customer_lease->branchOffice->address_4))
                        <br/>
                        {{ $customer_lease->branchOffice->address_3 ?? '' }} {{ $customer_lease->branchOffice->address_4 ?? '' }}
                    @endif
                    @if(!empty($customer_lease->branchOffice->city->name) || !empty($customer_lease->branchOffice->state->name))
                        <br/>
                        {{ $customer_lease->branchOffice->city->name ?? '' }}, {{ $customer_lease->branchOffice->state->name ?? '' }}
                    @endif
                    <br/>
                    {{ $customer_lease->branchOffice->country->name ?? '' }}{!! ($customer_lease->branchOffice->postcode ? '&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ': ' . $customer_lease->branchOffice->postcode : '') !!}
                </td>
                <td width="28%" class="text-right" style="vertical-align: top;">
                    <div>
                        <table cellpadding="0" cellspacing="1" class="" width="100%">
                            <tr>
                                <td width="40%" class="cell-primary" style="">@lang('sales/customer_lease.entry_date')</td>
                                <td class="cell-primary" style="">{{ mb_strtoupper($customer_lease->documentType->name) }}</td>
                            </tr>
                            <tr>
                                <td class="cell-primary-border-line text-center" style="">{!! str_replace(' ','<br>',\App\Helpers\Helper::convertSqlToDateTime($customer_lease->date)) !!}</td>
                                <td class="cell-primary-border-line text-center" style="">{{ $customer_lease->name }}</td>
                            </tr>
                            <tr>
                                <td width="" class="" colspan="2" style="">&nbsp;</td>
                            </tr>
                            <tr>
                                <td width="" class="cell-primary" colspan="2" style="">@lang('general.text_cfdi_uuid')</td>
                            </tr>
                            <tr>
                                <td class="cell-primary-border-line text-center" colspan="2" style="">{{ $customer_lease->customerInvoiceCfdi->uuid ?? '' }}</td>
                            </tr>
                        </table>
                    </div>
                </td>
            </tr>
            <tr>
                <td colspan="2"></td>
                <td colspan="2" style="padding-top: 13px;">
                    {{mb_strtoupper(__('base/company.column_tax_regimen'))}}: {{ $data['tax_regimen'] ?? ($customer_lease->taxRegimen->name_sat ?? $customer_lease->company->taxRegimen->name_sat) }}
                </td>
            </tr>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 10px;">
            <tr>
                <td width="" class="cell-primary" colspan="2" style="">@lang('general.text_customer')</td>
            </tr>
            <tr>
                <td width="50%" class="cell-primary-border-line text-left" style="vertical-align: top; height: 50px; padding: 5px;">
                    <strong>{{ mb_strtoupper(!empty($cfdi33->Receptor['Nombre']) ? $cfdi33->Receptor['Nombre'] : $customer_lease->customer->name) }}</strong>
                    <br>
                    @lang('sales/customer_lease.entry_taxid'): {{ mb_strtoupper($cfdi33->Receptor['Rfc'] ?? $customer_lease->customer->taxid) }}
                    <br />
                    @lang('sales/customer_lease.entry_tax_regimen_customer_id2'): {{ $data['tax_regimen_customer'] ?? ($customer_lease->taxRegimenCustomer->name_sat ?? $customer_lease->customer->taxRegimen->name_sat) }}
                </td>
                <td class="cell-primary-border-line text-left" style="vertical-align: top; height: 50px; padding: 5px;">
                    @if(!empty($customer_lease->customer->address_1) || !empty($customer_lease->customer->address_2) || !empty($customer_lease->customer->address_3) || !empty($customer_lease->customer->address_4))
                        {{ $customer_lease->customer->address_1 ?? '' }} {{ $customer_lease->customer->address_2 ?? '' }} {{ $customer_lease->customer->address_3 ?? '' }} {{ $customer_lease->customer->address_4 ?? '' }}
                        <br/>
                    @endif
                    @if(!empty($customer_lease->customer->city->name) || !empty($customer_lease->customer->state->name))
                            {{ !empty($customer_lease->customer->city->name) ? $customer_lease->customer->city->name . ', ' : '' }}{{ $customer_lease->customer->state->name ?? '' }}
                        <br/>
                    @endif
                    {{ $customer_lease->customer->country->name ?? '' }}{!! ($customer_lease->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_lease->customer->postcode : '') !!}

                </td>
            </tr>
        </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi_40')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_lease->status == \App\Models\Sales\CustomerInvoice::CANCEL)
    <section class="watermark" style="bottom: 450px !important;">
        @if(!empty($customer_lease->customerInvoiceCfdi->uuid))
            <span>@lang('general.text_canceled_cfdi')</span>
        @else
            <span>@lang('general.text_canceled')</span>
        @endif
    </section>
@endif
@if($draft)
    <section class="watermark" style="left: 170px; bottom: 450px !important;">
        <span>@lang('general.text_pre_lease')</span>
    </section>
@endif
<section>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
        <thead>
        <tr>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_lease.column_line_sat_product_id')) }}</th>
            <th width="7%">{{ mb_strtoupper(__('sales/customer_lease.column_line_quantity')) }}</th>
            <th class="text-left">{{ mb_strtoupper(__('sales/customer_lease.column_line_name')) }}</th>
            <th width="14%">{{ mb_strtoupper(__('sales/customer_lease.column_line_unit_measure_id')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_lease.column_line_price_unit')) }}</th>
            <th width="6%">{{ mb_strtoupper(__('sales/customer_lease.column_line_discount')) }}</th>
            <th width="11%">{{ mb_strtoupper(__('sales/customer_lease.column_line_amount_untaxed')) }}</th>
        </tr>
        </thead>
        <tbody>
        @if($conceptos)
        @foreach($conceptos as $result)
            @php
                //Complemento concepto

            @endphp
            <tr>
                <td class="text-center">{{ $result['ClaveProdServ'] }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatRealDecimalPlace($result['Cantidad']) }}</td>
                <td>
                    @if(!empty(setting('show_product_code_on_pdf')))
                        {{$result['NoIdentificacion'] ?? 'N/A'}} -
                    @endif
                    {!! nl2br($result['Descripcion']) !!}
                    @php
                    echo '<br />';
                    echo __('sales/customer_lease.column_line_tax_object') . ': '.$result['ObjetoImp'].'<br />';
                    @endphp
                    @php
                        //Numero predial
                        foreach(($result)() as $result2){
                            if((string)$result2 == 'CuentaPredial'){
                                echo '<br/><br/>';
                                echo __('sales/customer_lease.column_line_numero_predial') . ': '.$result2['Numero'].'<br/>';
                                break;
                            }
                        }
                    @endphp
                </td>
                <td class="text-center">[{{ $result['ClaveUnidad'] }}] {{ $result['Unidad'] }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result['ValorUnitario'],\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_lease->company_id)) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormat(!empty($result['Descuento']) ? $result['Descuento']/$result['Importe'] : 0,2) }}</td>
                <td class="text-right">{{ money($result['Importe'],$customer_lease->currency->code,true) }}</td>
            </tr>
        @endforeach
        @else
            @foreach($customer_lease->customerActiveInvoiceLines as $result)
                <tr>
                    <td class="text-center">{{ $result->satProduct->code }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                    <td>
                        @if(!empty(setting('show_product_code_on_pdf')))
                            {{$result->product->code ?? 'N/A'}} -
                        @endif
                        {!! nl2br($result->name) !!}
                    </td>
                    <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_lease->company_id)) }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                    <td class="text-right">{{ money($result->amount_untaxed,$customer_lease->currency->code,true) }}</td>
                </tr>
            @endforeach
        @endif
        </tbody>
        <tfoot>
        <tr>
            <td colspan="7" class="text-left" style="vertical-align: top; height: 50px;">
                {!! nl2br($customer_lease->comment) !!}
            </td>
        </tr>
        <tr>
            <td colspan="4" class="text-left" style="vertical-align: top;">
                <span style="line-height: 16px;">
                    ***({{\App\Helpers\Helper::numberToWordCurrency($customer_lease->amount_total,$customer_lease->currency->code,$customer_lease->currency->decimal_place)}})***
                </span>
            </td>
            <td colspan="2" class="text-right" style="vertical-align: top; padding-right: 4px;">
                <strong>@lang('general.text_amount_untaxed')</strong><br/>
                @if($customer_lease->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_lease->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
            </td>
            <td class="text-right">
                {{ money($customer_lease->amount_untaxed,$customer_lease->currency->code,true) }}<br/>
                @if($customer_lease->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_lease->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;">{{money(abs($result->amount_tax),$customer_lease->currency->code,true)}}</span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ money($customer_lease->amount_total,$customer_lease->currency->code,true) }}</strong></span>
            </td>
        </tr>
        </tfoot>
    </table>
    </div>
    @if(!empty($cfdi33))
        <div>
            <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                <tr>
                    <td width="" class="cell-primary" style="">@lang('general.text_cfdi_tfd_cadena_origen')</td>
                </tr>
                <tr>
                    <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 45px; padding: 5px;  word-wrap:break-word;">
                        {{ $data['tfd_cadena_origen'] }}
                    </td>
                </tr>
            </table>
        </div>
        <div>
            <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                <tr>
                    <td width="" class="cell-primary" style="">@lang('general.text_cfdi_tfd_sello_cfdi')</td>
                </tr>
                <tr>
                    <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 35px; padding: 5px;  word-wrap:break-word;">
                        {{ $cfdi33->complemento->timbreFiscalDigital['SelloCFD'] }}
                    </td>
                </tr>
            </table>
        </div>
        <div>
            <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                <tr>
                    <td width="" class="cell-primary" style="">@lang('general.text_cfdi_tfd_sello_sat')</td>
                </tr>
                <tr>
                    <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 35px; padding: 5px;  word-wrap:break-word;">
                        {{ $cfdi33->complemento->timbreFiscalDigital['SelloSAT'] }}
                    </td>
                </tr>
            </table>
        </div>
    @endif
    @if(!empty($customer_lease->cfdi_relation_id))
        <div>
        <p style="margin-bottom: 2px;">
            <strong>@lang('sales/customer_lease.tab_relations') - {{ $customer_lease->cfdiRelation->name_sat }}</strong>
        </p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                    @if($customer_lease->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_lease->customerInvoiceRelations as $result)
                            {{$result->relation->name ?? ''}}<br/>
                        @endforeach
                    @endif
                </td>
                <td width="85%" style="vertical-align: middle; padding: 5px;">
                    @if($customer_lease->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_lease->customerInvoiceRelations as $result)
                            {{$result->uuid_related}}<br/>
                        @endforeach
                    @endif
                </td>
            </tr>
        </table>
        </div>
    @endif
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
            <tr>
                <td width="100%" class="cell-primary" style=""></td>
            </tr>
            <tr>
                <td width="100%" class="cell-primary-border-line text-left" style="vertical-align: top; padding: 5px;  word-wrap:break-word;">
                    <table cellpadding="0" cellspacing="0" class="" width="100%" style="table-layout: fixed;">
                        <tr>
                            <td width="20%" class="text-center" style="vertical-align: top;">
                                @if(!empty($cfdi33))
                                    <img src="{{ $data['qr'] }}" width="120px" style="margin: 5px 0;"/>
                                @endif
                            </td>
                            <td width="18%" class="" style="vertical-align: top; padding-top: 12px;">
                                @lang('base/document_type.entry_cfdi_type_id'):<br>
                                @lang('sales/customer_lease.entry_date'):<br>
                                @lang('sales/customer_lease.entry_date_due'):<br>
                                @if(!empty($cfdi33))
                                    @lang('general.text_cfdi_tfd_fecha_timbrado'):<br>
                                    @lang('general.text_cfdi_certificado'):<br>
                                    @lang('general.text_cfdi_tfd_no_certificado_sat'):<br>
                                @endif
                                @lang('sales/customer_lease.entry_payment_way_id'):<br>
                                @lang('sales/customer_lease.entry_payment_method_id'):<br>
                                @lang('sales/customer_lease.entry_payment_term_id'):<br>
                                @lang('sales/customer_lease.entry_cfdi_use_id'):<br>
                            </td>
                            <td width="" class="" style="vertical-align: top; padding-top: 12px;">
                                {{ $customer_lease->documentType->cfdiType->name_sat ?? '' }}<br>
                                {{\App\Helpers\Helper::convertSqlToDateTime($customer_lease->date)}}<br>
                                {{ \App\Helpers\Helper::convertSqlToDate($customer_lease->date_due) }}<br>
                                @if(!empty($cfdi33))
                                    {{ \App\Helpers\Helper::convertSqlToDateTime(str_replace('T',' ',$cfdi33->complemento->timbreFiscalDigital['FechaTimbrado'])) }}<br>
                                    {{ $cfdi33['NoCertificado'] }}<br>
                                    {{ $cfdi33->complemento->timbreFiscalDigital['NoCertificadoSAT'] }}<br>
                                @endif
                                {{ $customer_lease->paymentWay->name_sat }}<br>
                                {{ $customer_lease->paymentMethod->name_sat }}<br>
                                {{ $customer_lease->paymentTerm->name }}<br>
                                {{ $customer_lease->cfdiUse->name_sat }}<br>
                            </td>
                            <td width="7%" class="" style="vertical-align: top; padding-top: 12px;">
                                @lang('sales/customer_lease.entry_currency_id'):<br>
                                @lang('sales/customer_lease.entry_currency_value'):<br>
                            </td>
                            <td width="10%" class="text-left" style="vertical-align: top; padding-top: 12px;">
                                {{ $customer_lease->currency->code }}<br>
                                {!! ($customer_lease->currency->code!='MXN' ? round($customer_lease->currency_value,4) :'') !!}<br>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>
</section>
</body>
</html>
