<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_lease->documentType->name}}-{{$customer_lease->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 310px;
            margin-bottom: 40px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 10px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_lease->company_id) }}   !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_lease->company_id) }}   !important;
        }
    </style>
</head>
<body style="background-color: white;">
<section class="header" style="top: -287px;">
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td colspan="2" class="text-right">
                <h1>{{ mb_strtoupper($customer_lease->documentType->name) }}</h1>
            </td>
        </tr>
        <tr>
            <td width="50%" style="vertical-align: top; padding-top: 10px;">
                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_lease->company_id,$customer_lease->project_id) }}" class="invoice-logo" width="170px"/>
                @elseif(!empty(setting('branch_office_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_lease->company_id,$customer_lease->branch_office_id) }}" class="invoice-logo" width="170px"/>
                @else
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_lease->company_id) }}" class="invoice-logo" width="170px"/>
                @endif
            </td>
            <td width="50%" class="text-right text-company" style="vertical-align: top; padding-top: 10px;">
                <span><strong>{{ mb_strtoupper($customer_lease->company->name) }}</strong></span>
                <br/>
                <span>{{ $data['tax_regimen'] ?? ($customer_lease->taxRegimen->name_sat ?? $customer_lease->company->taxRegimen->name_sat) }}</span>
                <br/>
                <span>{{ $customer_lease->company->address_1 ?? '' }} {{ $customer_lease->company->address_2 ?? '' }} {{ $customer_lease->company->address_3 ?? '' }} {{ $customer_lease->company->address_4 ?? '' }}</span>
                <br/>
                <span>{{ $customer_lease->company->city->name ?? '' }}, {{ ($customer_lease->company->state->name ?? '') }}</span>
                <br/>
                <span>{{ $customer_lease->company->country->name ?? '' }}{!! ($customer_lease->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_lease->company->postcode : '') !!}</span>
                <br/>
                <span>{{ mb_strtoupper($customer_lease->company->taxid) }}</span>
                <br/>
                <span>---</span>
                <br/>
                <span>{{ $customer_lease->company->phone ?? ' ' }}</span>
                <br/>
                <span>{{ $customer_lease->company->email ?? ' ' }}</span>
            </td>
        </tr>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary"># {{ $customer_lease->name }}</span>

            </td>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary">{{ mb_strtoupper(__('general.text_customer')) }}</span>
            </td>
        </tr>
        <tr>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <span><strong>@lang('general.text_cfdi_uuid')
                        : </strong>{{ $customer_lease->customerInvoiceCfdi->uuid ?? '' }}</span>
                <br/>
                <span><strong>@lang('base/document_type.entry_cfdi_type_id')
                        : </strong>{{ $customer_lease->documentType->cfdiType->name_sat ?? '' }}</span>
                <br/>
                <span><strong>@lang('sales/customer_lease.entry_date')
                        : </strong>{{ \App\Helpers\Helper::convertSqlToDateTime($customer_lease->date) }}</span>
                <br/>
                <span><strong>@lang('sales/customer_lease.entry_date_due')
                        : </strong>{{ \App\Helpers\Helper::convertSqlToDate($customer_lease->date_due) }}</span>
                <br/>
                <span><strong>@lang('sales/customer_lease.entry_payment_term_id')
                        : </strong>{{ $customer_lease->paymentTerm->name }}</span>
                <br/>
                <span><strong>@lang('sales/customer_lease.entry_cfdi_use_id')
                        : </strong>{{ $customer_lease->cfdiUse->name_sat }}</span>
                <br/>
                <span><strong>@lang('general.text_issued_in')
                        : </strong>{{ $customer_lease->branchOffice->name ?? '' }} {!! ($customer_lease->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $customer_lease->branchOffice->postcode : '') !!}</span>
                <br/>
            </td>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <span><strong>{{ mb_strtoupper($customer_lease->customer->name) }}</strong></span>
                <br/>
                <span>{{ $customer_lease->customer->address_1 ?? '' }} {{ $customer_lease->customer->address_2 ?? '' }} {{ $customer_lease->customer->address_3 ?? '' }} {{ $customer_lease->customer->address_4 ?? '' }}</span>
                <br/>
                <span>{{ $customer_lease->customer->city->name ?? '' }}
                    , {{ $customer_lease->customer->state->name ?? '' }}</span>
                <br/>
                <span>{{ $customer_lease->customer->country->name ?? '' }}{!! ($customer_lease->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_lease->customer->postcode : '') !!}</span>
                <br/>
                @lang('sales/customer_lease.entry_taxid'): {{ $customer_lease->customer->taxid }}
                <br />
                @lang('sales/customer_lease.entry_tax_regimen_customer_id2'): {{ $customer_lease->taxRegimenCustomer->name_sat ?? ($customer_lease->customer->taxRegimen->name_sat ?? '') }}
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="watermark" style="bottom: 540px !important;">
    <span>@lang('general.text_invalid_cfdi')</span>
</section>
<section>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
        <thead>
        <tr>
            <th class="text-left">{{ mb_strtoupper(__('sales/customer_lease.column_line_name')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_lease.column_line_sat_product_id')) }}</th>
            <th width="14%">{{ mb_strtoupper(__('sales/customer_lease.column_line_unit_measure_id')) }}</th>
            <th width="8%">{{ mb_strtoupper(__('sales/customer_lease.column_line_quantity')) }}</th>
            <th width="10%">{{ mb_strtoupper(__('sales/customer_lease.column_line_price_unit')) }}</th>
            <th width="7%">{{ mb_strtoupper(__('sales/customer_lease.column_line_discount')) }}</th>
            <th width="11%">{{ mb_strtoupper(__('sales/customer_lease.column_line_amount_untaxed')) }}</th>
        </tr>
        </thead>
        <tbody>
        @foreach($customer_lease->customerActiveInvoiceLines as $result)
            <tr>
                <td>{!! nl2br($result->name) !!}</td>
                <td class="text-center">{{ $result->satProduct->code }}</td>
                <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_lease->company_id)) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                <td class="text-right">{{ money($result->amount_untaxed,$customer_lease->currency->code,true) }}</td>
            </tr>
        @endforeach
        </tbody>
        <tfoot>
        <tr>
            <td colspan="4" class="text-center" style="vertical-align: bottom;">
                <span style="line-height: 16px;">***({{\App\Helpers\Helper::numberToWordCurrency($customer_lease->amount_total,$customer_lease->currency->code,$customer_lease->currency->decimal_place)}}
                    )***</span>
            </td>
            <td colspan="2" class="text-right" style="vertical-align: top; padding-right: 4px;">
                <strong>@lang('general.text_amount_untaxed')</strong><br/>
                @if($customer_lease->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_lease->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
            </td>
            <td class="text-right">
                {{ money($customer_lease->amount_untaxed,$customer_lease->currency->code,true) }}<br/>
                @if($customer_lease->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_lease->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;">{{ money(abs($result->amount_tax),$customer_lease->currency->code,true) }}</span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ money($customer_lease->amount_total,$customer_lease->currency->code,true) }}</strong></span>
            </td>
        </tr>
        </tfoot>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="100%" style="vertical-align: top; padding: 5px;">
                <span><strong>@lang('sales/customer_lease.entry_payment_way_id')
                        : </strong>{{ $customer_lease->paymentWay->name_sat }}</span>
                <br/>
                <span><strong>@lang('sales/customer_lease.entry_payment_method_id')
                        : </strong>{{ $customer_lease->paymentMethod->name_sat }}</span>
                <br/>
                <span><strong>@lang('sales/customer_lease.entry_currency_id')
                        : </strong>{{ $customer_lease->currency->code }}{!! ($customer_lease->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/customer_lease.entry_currency_value').':</strong> '.round($customer_lease->currency_value,4) :'') !!}</span>
                <br/>
            </td>
        </tr>
    </table>
    </div>
    @if(!empty($customer_lease->cfdi_relation_id))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_lease.tab_relations')
                - {{ $customer_lease->cfdiRelation->name_sat }} </strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" >
            <tr>
                <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                    @if($customer_lease->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_lease->customerInvoiceRelations as $result)
                            {{$result->relation->name}}<br/>
                        @endforeach
                    @endif
                </td>
                <td width="85%" style="vertical-align: middle; padding: 5px;">
                    @if($customer_lease->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_lease->customerInvoiceRelations as $result)
                            {{$result->relation->customerInvoiceCfdi->uuid}}<br/>
                        @endforeach
                    @endif
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_lease->comment))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_lease.entry_comment')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;">
                    {!! nl2br($customer_lease->comment) !!}
                </td>
            </tr>
        </table>
        </div>
    @endif
</section>
</body>
</html>
