@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('sales/customer_lease.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('sales/customer_lease.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('customer-leases.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            @php
                //Obtiene datos del Cfdi33
                $cfdi33 = !empty($data['cfdi33']) ? $data['cfdi33'] : [];
            @endphp

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>{{ $customer_lease->documentType->name }}</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">


                            <section class="content invoice">
                                <!-- title row -->
                                <div class="row">
                                    <div class="col-xs-12 invoice-header">
                                        <h1></h1>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 20px;">
                                    <div class="col-md-6 col-xs-12 invoice-col">
                                        <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_lease->company_id) }}" class="invoice-logo" width="170px"/>
                                    </div>
                                    <div class="col-md-6 col-xs-12 invoice-col text-right">
                                        <span><strong>{{ mb_strtoupper($customer_lease->company->name) }}</strong></span>
                                        <br/>
                                        <span>{{ $data['tax_regimen'] ?? ($customer_lease->taxRegimen->name_sat ?? $customer_lease->company->taxRegimen->name_sat) }}</span>
                                        <br/>
                                        <span>{{ $customer_lease->company->address_1 ?? '' }} {{ $customer_lease->company->address_2 ?? '' }} {{ $customer_lease->company->address_3 ?? '' }} {{ $customer_lease->company->address_4 ?? '' }}</span>
                                        <br/>
                                        <span>{{ $customer_lease->company->city->name ?? '' }}
                                            , {{ ($customer_lease->company->state->name ?? '') }}</span>
                                        <br/>
                                        <span>{{ $customer_lease->company->country->name ?? '' }}{!! ($customer_lease->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_lease->company->postcode : '') !!}</span>
                                        <br/>
                                        <span>{{ mb_strtoupper($customer_lease->company->taxid) }}</span>
                                        <br/>
                                        <span>---</span>
                                        <br/>
                                        <span>{{ $customer_lease->company->phone ?? ' ' }}</span>
                                        <br/>
                                        <span>{{ $customer_lease->company->email ?? ' ' }}</span>
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 20px;">
                                    <div class="col-md-6 col-xs-12 invoice-col">
                                        <h4 class=""
                                            style="color: {{ \App\Helpers\Helper::companyColorPrimary($customer_lease->company_id) }}; font-weight: bold; padding-bottom: 5px; border-bottom: 1px solid #cccccc;">
                                            # {{ $customer_lease->name }}
                                            <span class="pull-right">{!! \App\Helpers\SalesHelper::statusCustomerLeaseHtml($customer_lease->status) !!}</span>
                                        </h4>
                                        <span><strong>@lang('general.text_cfdi_uuid')
                                                : </strong>{{ $customer_lease->customerInvoiceCfdi->uuid ?? '' }}
                                                        </span>
                                        <br/>
                                        <span><strong>@lang('base/document_type.entry_cfdi_type_id')
                                                : </strong>{{ $customer_lease->documentType->cfdiType->name_sat ?? '' }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_lease.entry_date')
                                                : </strong>{{ \App\Helpers\Helper::convertSqlToDateTime($customer_lease->date) }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_lease.entry_date_due')
                                                : </strong>{{ \App\Helpers\Helper::convertSqlToDate($customer_lease->date_due) }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_lease.entry_payment_term_id')
                                                : </strong>{{ $customer_lease->paymentTerm->name }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_lease.entry_cfdi_use_id')
                                                : </strong>{{ $customer_lease->cfdiUse->name_sat }}</span>
                                        <br/>
                                        <span><strong>@lang('general.text_issued_in')
                                                : </strong>{{ $customer_lease->branchOffice->name ?? '' }} {!! ($customer_lease->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $customer_lease->branchOffice->postcode : '') !!}</span>
                                        <br/>
                                    </div>
                                    <div class="col-md-6 col-xs-12 invoice-col">
                                        <h4 class=""
                                            style="color: {{ \App\Helpers\Helper::companyColorPrimary($customer_lease->company_id) }}; font-weight: bold; padding-bottom: 5px; border-bottom: 1px solid #cccccc;">{{ mb_strtoupper(__('general.text_customer')) }}</h4>
                                        <span><strong>{{ mb_strtoupper($customer_lease->customer->name) }}</strong></span>
                                        <br/>
                                        <span>{{ $customer_lease->customer->address_1 ?? '' }} {{ $customer_lease->customer->address_2 ?? '' }} {{ $customer_lease->customer->address_3 ?? '' }} {{ $customer_lease->customer->address_4 ?? '' }}</span>
                                        <br/>
                                        <span>{{ $customer_lease->customer->city->name ?? '' }}
                                            , {{ $customer_lease->customer->state->name ?? '' }}</span>
                                        <br/>
                                        <span>{{ $customer_lease->customer->country->name ?? '' }}{!! ($customer_lease->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_lease->customer->postcode : '') !!}</span>
                                        <br/>
                                        <span>{{ mb_strtoupper($cfdi33->Receptor['Rfc'] ?? $customer_lease->customer->taxid) }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_lease.entry_tax_regimen_customer_id2')
                                            : </strong>{{ $data['tax_regimen_customer'] ?? ($customer_lease->taxRegimenCustomer->name_sat ?? ($customer_lease->customer->taxRegimen->name_sat ?? '')) }}</span>
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- Table row -->
                                <div class="row">
                                    <div class="col-md-12 col-xs-12 table">
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                <tr>
                                                    <th class="text-left">{{ mb_strtoupper(__('sales/customer_lease.column_line_name')) }}</th>
                                                    <th class="text-center"
                                                        width="9%">{{ mb_strtoupper(__('sales/customer_lease.column_line_sat_product_id')) }}</th>
                                                    <th class="text-center"
                                                        width="14%">{{ mb_strtoupper(__('sales/customer_lease.column_line_unit_measure_id')) }}</th>
                                                    <th class="text-center"
                                                        width="7%">{{ mb_strtoupper(__('sales/customer_lease.column_line_quantity')) }}</th>
                                                    <th class="text-center"
                                                        width="9%">{{ mb_strtoupper(__('sales/customer_lease.column_line_price_unit')) }}</th>
                                                    <th class="text-center"
                                                        width="6%">{{ mb_strtoupper(__('sales/customer_lease.column_line_discount')) }}</th>
                                                    <th class="text-right"
                                                        width="11%">{{ mb_strtoupper(__('sales/customer_lease.column_line_amount_untaxed')) }}</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @foreach($customer_lease->customerActiveInvoiceLines as $result)
                                                    <tr>
                                                        <td>{{ $result->name }}</td>
                                                        <td class="text-center">{{ $result->satProduct->code }}</td>
                                                        <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                                                        <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                                                        <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_lease->company_id)) }}</td>
                                                        <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                                                        <td class="text-right">{{ money($result->amount_untaxed,$customer_lease->currency->code,true) }}</td>
                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- /.row -->
                                <!-- Table row -->
                                <div class="row" style="margin-bottom: 30px;">
                                    <div class="col-md-6 col-xs-12">
                                        <span><strong>@lang('sales/customer_lease.entry_payment_way_id')
                                                : </strong>{{ $customer_lease->paymentWay->name_sat }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_lease.entry_payment_method_id')
                                                : </strong>{{ $customer_lease->paymentMethod->name_sat }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_lease.entry_currency_id')
                                                : </strong>{{ $customer_lease->currency->code }}{!! ($customer_lease->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/customer_lease.entry_currency_value').':</strong> '.round($customer_lease->currency_value,4) :'') !!}</span>
                                        <br/>
                                        @if(!empty($cfdi33))
                                            <span><strong>@lang('general.text_cfdi_certificado'): </strong>
                                                {{ $cfdi33['NoCertificado'] }}</span>
                                            <br/>
                                            <span><strong>@lang('general.text_cfdi_tfd_no_certificado_sat'): </strong>
                                                {{ $cfdi33->complemento->timbreFiscalDigital['NoCertificadoSAT'] }}</span>
                                            <br/>
                                            <span><strong>@lang('general.text_cfdi_tfd_fecha_timbrado'): </strong>
                                                {{ \App\Helpers\Helper::convertSqlToDateTime(str_replace('T',' ',$cfdi33->complemento->timbreFiscalDigital['FechaTimbrado'])) }}</span>
                                            <br/>
                                        @endif
                                    </div>
                                    <div class="col-md-6 col-xs-12">
                                        <div class="table-responsive">
                                            <table class="table">
                                                <tbody>
                                                <tr>
                                                    <th style="width:50%">@lang('general.text_amount_untaxed')</th>
                                                    <td>{{ money($customer_lease->amount_untaxed,$customer_lease->currency->code,true) }}</td>
                                                </tr>
                                                @if($customer_lease->customerInvoiceTaxes->isNotEmpty())
                                                    @foreach($customer_lease->customerInvoiceTaxes as $result)
                                                        <tr>
                                                            <th>{{$result->name}}</th>
                                                            <td>{{ money(abs($result->amount_tax),$customer_lease->currency->code,true) }}</td>
                                                        </tr>
                                                    @endforeach
                                                @endif
                                                <tr>
                                                    <th>{{ mb_strtoupper(__('general.text_amount_total')) }}</th>
                                                    <td>{{ money($customer_lease->amount_total,$customer_lease->currency->code,true) }}</td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 15px;">
                                    <div class="col-md-12 col-xs-12 invoice-col">
                                        @if(!empty($customer_lease->cfdi_relation_id))
                                            <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_lease.tab_relations')
                                                    - {{ $customer_lease->cfdiRelation->name_sat }} </strong></p>
                                            <table cellpadding="0" cellspacing="0" class="table table-secundary" width="100%">
                                                <tr>
                                                    <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                                                        @if($customer_lease->customerInvoiceRelations->isNotEmpty())
                                                            @foreach($customer_lease->customerInvoiceRelations as $result)
                                                                {{$result->relation->name}}<br/>
                                                            @endforeach
                                                        @endif
                                                    </td>
                                                    <td width="85%" style="vertical-align: middle; padding: 5px;">
                                                        @if($customer_lease->customerInvoiceRelations->isNotEmpty())
                                                            @foreach($customer_lease->customerInvoiceRelations as $result)
                                                                {{$result->relation->customerInvoiceCfdi->uuid}}<br/>
                                                            @endforeach
                                                        @endif
                                                    </td>
                                                </tr>
                                            </table>
                                        @endif
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 15px;">
                                    <div class="col-md-12 col-xs-12 invoice-col">
                                        @if(!empty($customer_lease->comment))
                                            <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_lease.entry_comment')</strong></p>
                                            <table cellpadding="0" cellspacing="0" class="table table-secundary" width="100%">
                                                <tr>
                                                    <td width="100%" style="vertical-align: top; padding: 5px;">
                                                        {{ $customer_lease->comment }}
                                                    </td>
                                                </tr>
                                            </table>
                                        @endif
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 20px;">
                                    <div class="col-md-12 col-xs-12 invoice-col">
                                        @if(!empty($cfdi33))
                                            <table cellpadding="0" cellspacing="0" class="table" width="100%"
                                                   style="margin-top: 5px; table-layout: fixed;">
                                                <tr>
                                                    <td width="23%" class="text-center" style="vertical-align: middle; padding: 5px; word-wrap:break-word;">
                                                        <img src="{{ $data['qr'] }}" width="137px" style="margin: 9px 0;"/>
                                                    </td>
                                                    <td width="77%" style="vertical-align: middle; padding: 5px; word-wrap:break-word;">
                                                        <strong>@lang('general.text_cfdi_tfd_cadena_origen') </strong><br/>
                                                        <small>{{ $data['tfd_cadena_origen'] }}</small>
                                                        <br/>
                                                        <strong>@lang('general.text_cfdi_tfd_sello_cfdi') </strong><br/>
                                                        <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloCFD'] }}</small>
                                                        <br/>
                                                        <strong>@lang('general.text_cfdi_tfd_sello_sat') </strong><br/>
                                                        <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloSAT'] }}</small>
                                                        <br/>
                                                    </td>
                                                </tr>
                                            </table>
                                        @endif
                                    </div>
                                </div>
                                <!-- /.row -->
                            </section>


                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

    </script>
@endsection
