@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('sales/customer_payment.document_title'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
    <link href="{{ asset('vendor/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('sales/customer_payment.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('customer-payments.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        @lang('general.error_upload_file')
                        <ul>
                            @foreach ($errors->all() as $key => $error)
                                <li>{!! $error  !!}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('sales/customer_payment.document_title_import')</h2>
                            <div class="clearfix"></div>
                            <p>@lang('sales/customer_payment.text_import_subtitle')</p>
                        </div>
                        <div class="x_content">
                            {!! Form::open(['route' => 'customer-payments/download-template-import','method' => 'POST','class' => '','role' => 'form','id'=>'form1']) !!}
                            <!-- input hidden -->
                            <!-- /.input hidden -->
                                <div class="table-responsive table-data">
                                    <table class="table table-striped table-hover table-condensed">
                                        <thead>
                                        <tr class="mini">
                                            <th class="text-center">@lang('sales/customer.entry_taxid2')</th>
                                            <th class="text-left">@lang('sales/customer.text_customer')</th>
                                            <th class="text-center">@lang('sales/customer_payment.entry_branch_office_id')</th>
                                            <th class="text-center">@lang('sales/customer_payment.entry_currency_id')</th>
                                            <th class="text-center">@lang('sales/customer_payment.entry_currency_value')</th>
                                            <th class="text-center">@lang('sales/customer_payment.entry_date_payment')</th>
                                            <th class="text-left">@lang('sales/customer_payment.entry_payment_way_id')</th>
                                            <th class="text-left">@lang('sales/customer_payment.entry_amount')</th>
                                            <th class="text-left">@lang('sales/customer_payment.entry_customer_bank_account_id')</th>
                                            <th class="text-left">@lang('sales/customer_payment.entry_reference')</th>
                                            <th class="text-left">@lang('sales/customer_payment.entry_company_bank_account_id')</th>
                                            <th class="text-center">@lang('sales/customer_payment.entry_cfdi_relation_id')</th>
                                            <th class="text-center">@lang('sales/customer_payment.entry_uuids')</th>
                                            <th class="text-center">@lang('sales/customer_payment.column_reconciled_name')</th>
                                            <th class="text-center">@lang('sales/customer_payment.column_reconciled_currency_value')</th>
                                            <th class="text-center">@lang('sales/customer_payment.column_reconciled_amount_reconciled2')</th>
                                            <th class="text-center">@lang('sales/customer_payment.column_line_send_mail')</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($import_results as $result)
                                            <tr class="">
                                                <td class="text-center">{{$result->customer_taxid}}</td>
                                                <td class="text-left">{{$result->customer}}</td>
                                                <td class="text-center">{{$result->branch_office}}</td>
                                                <td class="text-center">{{$result->currency}}</td>
                                                <td class="text-center">{{$result->currency_value}}</td>
                                                <td class="text-center">{{$result->date_payment}}</td>
                                                <td class="text-left">{{$result->payment_way}}</td>
                                                <td class="text-right">{{$result->amount}}</td>
                                                <td class="text-left">{{$result->customer_bank_account}}</td>
                                                <td class="text-left">{{$result->reference}}</td>
                                                <td class="text-left">{{$result->company_bank_account}}</td>
                                                <td class="text-center">{{$result->cfdi_relation}}</td>
                                                <td class="text-center">{{$result->uuids}}</td>
                                                <td class="text-center">{{$result->reconciled_name}}</td>
                                                <td class="text-right">{{$result->reconciled_currency_value}}</td>
                                                <td class="text-right">{{$result->reconciled_amount_reconciled2}}</td>
                                                <td class="text-center">{{$result->send_mail}}</td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <div class="ln_solid"></div>
                                <div class="row">
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('branch_office_id', __('sales/customer_payment.entry_branch_office_id') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('branch_office_id', $branch_offices,old('branch_office_id',\App\Models\Base\BranchOffice::where('company_id','=',\App\Helpers\Helper::defaultCompany()->id)->get()->first()->id), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('date_payment', __('sales/customer_payment.entry_date_payment') . '', ['class' => 'control-label'])) !!}
                                            <div class="input-group input-group-sm">
                                                {!! Form::text('date_payment', old('date_payment'), ['class' => 'form-control', 'placeholder' => __('sales/customer_payment.entry_date_payment'),'autocomplete'=>'off']) !!}
                                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('payment_way_id', __('sales/customer_payment.entry_payment_way_id') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('payment_way_id', $payment_ways,old('payment_way_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('cfdi_relation_id', __('sales/customer_payment.entry_cfdi_relation_id') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('cfdi_relation_id', $cfdi_relations,old('cfdi_relation_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm{{ $errors->has('company_bank_account_id') ? ' has-error' : '' }}">
                                            {!! html_entity_decode(Form::label('company_bank_account_id', __('sales/customer_payment.entry_company_bank_account_id') . ' ', ['class' => 'control-label'])) !!}
                                            {!! Form::select('company_bank_account_id', $company_bank_accounts,old('company_bank_account_id',($duplicate_ci->company_bank_account_id ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        </div>
                                    </div>
                                </div>
                                <div class="ln_solid"></div>
                                <div class="row">
                                    <div class="col-md-12 col-xs-12 text-right footer-form">
                                        {!! Form::button(__('general.button_download_template_import'),['type' => 'submit', 'class' => 'btn btn-sm btn-success']) !!}
                                    </div>
                                </div>
                            {!! Form::close() !!}
                            {!! Form::open(['route' => 'customer-payments/import','method' => 'POST','class' => '','role' => 'form','id'=>'form','files' => true]) !!}
                                <input name="file_customer_payments_import" type="file" class="hidden"/>
                                <div class="dropzone mt-3" style="cursor: pointer; position: relative; min-height: 150px; padding-top: 15px;">
                                    <div class="fallback text-center">
                                        <label id="file_customer_payments_import_upload" style="font-size: 12px;"></label>
                                    </div>
                                    <div class="dz-message needsclick text-center" style="padding-top: 10px;">
                                        <i class="fa fa-cloud-upload" style="font-size: 50px;"></i>
                                        <h4 style="">@lang('general.help_upload_file')</h4>
                                    </div>
                                </div>
                            <!-- Footer form -->
                            <div class="ln_solid"></div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12 text-right footer-form">
                                    {!! Form::button(__('general.button_importar'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary ladda-button']) !!}
                                    &nbsp;&nbsp;
                                    <a href="{{route('customer-payments.index',request()->except('page'))}}"
                                       class="btn btn-sm btn-default">@lang('general.button_discard')</a>
                                </div>
                            </div>
                            <!-- /Footer form -->
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
    <script src="{{ asset('vendor/sweetalert2/sweetalert2.min.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">
        moment.locale("{{ substr(app()->getLocale(),0,2) }}");
        $("#form1 input[name='date_payment']").daterangepicker({
            singleDatePicker: true,
            showDropdowns: true,
            locale: {
                format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
            },
            autoUpdateInput: false,
        }, function (chosen_date) {
            $("#form1 input[name='date_payment']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
        });
        $(".dropzone").on("click", function (e) {
            e.preventDefault();
            $("#form input[name='file_customer_payments_import']").trigger("click");
        });
        $("#form input[name='file_customer_payments_import']").change(function(e){
            let fileName = e.target.files[0].name;
            $("#form #file_customer_payments_import_upload").text(fileName).addClass('label label-success font-14');
        });
        $("#form button[type='submit']").on('click',function(e){
            e.preventDefault();
            Pace.track(function () {
                $.ajax({
                    url: "{{ route('customer-payments/before-import') }}",
                    type: "POST",
                    dataType: "JSON",
                    data: new FormData($("#form").get(0)),
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function (data) {
                        if (data.success) {
                            Swal.fire({
                                title: "{{__('general.text_are_you_sure')}}",
                                html: data.total_import_customer_payments,
                                type: 'warning',
                                showCancelButton: true,
                                confirmButtonText: "{{__('general.button_yes_import')}}",
                                cancelButtonText: "{{__('general.button_no_cancel')}}",
                                confirmButtonClass: 'btn btn-primary mt-2',
                                cancelButtonClass: 'btn btn-secondary ml-2 mt-2',
                                buttonsStyling: false,
                                onClose: () => {
                                    Ladda.stopAll();
                                }
                            }).then(function (result) {
                                if (result.value) {
                                    $("#form").submit();
                                } else if (
                                    // Read more about handling dismissals
                                    result.dismiss === Swal.DismissReason.cancel
                                ) {
                                    //Cancelar
                                }
                            });
                        }
                    },
                    error: function (error, textStatus, errorThrown) {
                        Ladda.stopAll();
                        if (error.status == 422) {
                            let message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
        });
        /* Configura select2 */
        $("#form1 .my-select2").select2({
            placeholder: "@lang('general.text_select')",
            theme: "bootstrap",
            width: "100%",
            dropdownAutoWidth: true,
            allowClear: true,
            language: "{{ str_replace('_', '-', app()->getLocale()) }}"
        });
    </script>
@endsection
