<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_payment->documentType->name}}-{{$customer_payment->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 310px;
            margin-bottom: 225px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_payment->company_id) }}    !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_payment->company_id) }}    !important;
        }
    </style>
</head>
<body style="background-color: white;">
@php
    //Obtiene datos del Cfdi33
    $draft = (int) $customer_payment->status == \App\Models\Sales\CustomerPayment::DRAFT ? true : false;
    $cfdi33 = empty($data['cfdi33']) ? null : $data['cfdi33'];
@endphp
<section class="header" style="top: -287px;">
    @if($cfdi33 && $customer_payment->customerPaymentCfdi->pac->test)
    <h2 style="position: absolute; left: 37%; top: -15px; color: red;">*** @lang('general.text_test_cfdi') ***</h2>
    @endif
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="55%" class="text-left">
                <span class="text-primary">{{ mb_strtoupper($customer_payment->company->comercial_name) }}</span>
            </td>
            <td width="45%" class="text-right">
                <h1>{{ mb_strtoupper($customer_payment->documentType->name) }}</h1>
            </td>
        </tr>
        <tr>
            <td width="55%" style="vertical-align: top; padding-top: 10px; position: relative;">
                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_payment->company_id,$customer_payment->project_id) }}"
                    class="invoice-logo" />
                @elseif(!empty(setting('branch_office_logo_docs')))
                <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_payment->company_id,$customer_payment->branch_office_id) }}"
                    class="invoice-logo" />
                @else
                <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_payment->company_id) }}"
                    class="invoice-logo" />
                @endif
            </td>
            <td width="45%" class="text-right text-company" style="vertical-align: top; padding-top: 10px; height: 118px;">
                <strong>{{ mb_strtoupper($customer_payment->company->name) }}</strong>
                <br/>
                {{ $data['tax_regimen'] ?? ($customer_payment->taxRegimen->name_sat ?? $customer_payment->company->taxRegimen->name_sat) }}
                @if(!empty($customer_payment->company->address_1) || !empty($customer_payment->company->address_2) || !empty($customer_payment->company->address_3) || !empty($customer_payment->company->address_4))
                    <br/>
                    {{ $customer_payment->company->address_1 ?? '' }} {{ $customer_payment->company->address_2 ?? '' }} {{ $customer_payment->company->address_3 ?? '' }} {{ $customer_payment->company->address_4 ?? '' }}
                @endif
                @if(!empty($customer_payment->company->city->name) || !empty($customer_payment->company->state->name))
                    <br/>
                    {{ !empty($customer_payment->company->city->name) ? $customer_payment->company->city->name . ', ' : '' }}{{ $customer_payment->company->state->name ?? '' }}
                @endif
                <br/>
                {{ $customer_payment->company->country->name ?? '' }}{!! ($customer_payment->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_payment->company->postcode : '') !!}
                <br/>
                {{ mb_strtoupper($customer_payment->company->taxid) }}
                <br/>
                ---
                <br/>
                {{ $customer_payment->company->phone ?? ' ' }}
                <br/>
                {{ $customer_payment->company->email ?? ' ' }}
            </td>
        </tr>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary"># {{ $customer_payment->name }}</span>
            </td>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary">{{ mb_strtoupper(__('general.text_customer')) }}</span>
            </td>
        </tr>
        <tr>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <strong>@lang('general.text_cfdi_uuid'): </strong>{{ $customer_payment->customerPaymentCfdi->uuid ?? '' }}
                <br/>
                <strong>@lang('base/document_type.entry_cfdi_type_id'): </strong>{{ $customer_payment->documentType->cfdiType->name_sat ?? '' }}
                <br/>
                <strong>@lang('sales/customer_payment.entry_date'): </strong>{{ \App\Helpers\Helper::convertSqlToDateTime($customer_payment->date) }}
                <br/>
                <strong>@lang('sales/customer_payment.entry_date_payment'): </strong>{{ $customer_payment->date_payment ? \App\Helpers\Helper::convertSqlToDateTime($customer_payment->date_payment) : '' }}
                <br/>
                <strong>@lang('sales/customer_payment.entry_amount'): </strong>{{ money($customer_payment->amount,$customer_payment->currency->code,true) }}
                <br/>
                <strong>@lang('sales/customer_payment.entry_currency_id'): </strong>{{ $customer_payment->currency->code }}{!! ($customer_payment->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/customer_payment.entry_currency_value').':</strong> '.round($customer_payment->currency_value,4) :'') !!}
                <br/>
                <strong>@lang('general.text_issued_in'): </strong>{{ $customer_payment->branchOffice->name ?? '' }} {!! ($customer_payment->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . ($cfdi33['LugarExpedicion'] ?? $customer_payment->branchOffice->postcode) : '') !!}
                <br/>
            </td>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <strong>{{ mb_strtoupper(!empty($cfdi33->Receptor['Nombre']) ? $cfdi33->Receptor['Nombre'] : $customer_payment->customer->name) }}</strong>
                @if(!empty($customer_payment->customer->address_1) || !empty($customer_payment->customer->address_2) || !empty($customer_payment->customer->address_3) || !empty($customer_payment->customer->address_4))
                    <br/>
                    {{ $customer_payment->customer->address_1 ?? '' }} {{ $customer_payment->customer->address_2 ?? '' }} {{ $customer_payment->customer->address_3 ?? '' }} {{ $customer_payment->customer->address_4 ?? '' }}
                @endif
                @if(!empty($customer_payment->customer->city->name) || !empty($customer_payment->customer->state->name))
                    <br/>
                    {{ !empty($customer_payment->customer->city->name) ? $customer_payment->customer->city->name . ', ' : '' }}{{ $customer_payment->customer->state->name ?? '' }}
                @endif
                <br/>
                {{ $customer_payment->customer->country->name ?? '' }}{!! ($customer_payment->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_payment->customer->postcode : '') !!}
                <br/>
                {{ mb_strtoupper($cfdi33->Receptor['Rfc'] ?? $customer_payment->customer->taxid) }}
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="footer">
    <div>
    <table cellpadding="0" cellspacing="0" class="table-footer" width="100%"
           style="margin-top: 5px; table-layout: fixed;">
        <tr>
            <td width="23%" class="text-center" style="vertical-align: middle; padding: 5px; word-wrap:break-word;">
                @if(!empty($cfdi33))
                <img src="{{ $data['qr'] }}" width="137px" style="margin: 9px 0;"/>
                @endif
            </td>
            <td width="77%" style="vertical-align: middle; padding: 5px; word-wrap:break-word; height: 180px;">
                @if(!empty($cfdi33))
                <strong>@lang('general.text_cfdi_tfd_cadena_origen') </strong><br/>
                <small>{{ $data['tfd_cadena_origen'] }}</small>
                <br/>
                <strong>@lang('general.text_cfdi_tfd_sello_cfdi') </strong><br/>
                <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloCFD'] }}</small>
                <br/>
                <strong>@lang('general.text_cfdi_tfd_sello_sat') </strong><br/>
                <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloSAT'] }}</small>
                <br/>
                @endif
            </td>
        </tr>
    </table>
    </div>
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_payment->status == \App\Models\Sales\CustomerPayment::CANCEL)
    <section class="watermark" style="bottom: 450px !important;">
        @if(!empty($customer_payment->customerPaymentCfdi->uuid))
            <span>@lang('general.text_canceled_cfdi')</span>
        @else
            <span>@lang('general.text_canceled')</span>
        @endif
    </section>
@endif
@if($draft)
    <section class="watermark" style="left: 170px; bottom: 450px !important;">
        <span>@lang('general.text_pre_payment')</span>
    </section>
@endif
<section>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
        <thead>
        <tr>
            <th class="text-left">{{ mb_strtoupper(__('sales/customer_invoice.column_line_name')) }}</th>
            <th width="15%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_sat_product_id')) }}</th>
            <th width="14%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_unit_measure_id')) }}</th>
            <th width="7%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_quantity')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_price_unit')) }}</th>
            <th width="11%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_amount_untaxed')) }}</th>
        </tr>
        </thead>
        <tbody>
            <tr>
                <td>Pago</td>
                <td class="text-center">84111506</td>
                <td class="text-center">ACT</td>
                <td class="text-center">1</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney(0,0) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney(0,0) }}</td>
            </tr>
        </tbody>
    </table>
    </div>
    <p style="margin-bottom: 2px; margin-top: 15px;"><strong>@lang('sales/customer_payment.text_payment_complement')</strong></p>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%" style="margin-bottom: 15px;">
        <thead>
        <tr>
            <th class="text-center">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_uuid')) }}</th>
            <th width="6%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_serie')) }}</th>
            <th width="6%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_folio')) }}</th>
            <th width="6%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_currency')) }}</th>
            <th width="7%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_currency_value2')) }}</th>
            <th width="7%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_payment_method')) }}</th>
            <th width="8%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_number_of_payment')) }}</th>
            <th width="10%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_last_balance')) }}</th>
            <th width="10%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_amount_reconciled2')) }}</th>
            <th width="10%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_currenct_balance')) }}</th>
        </tr>
        </thead>
        <tbody>
        @if($customer_payment->customerPaymentReconcileds->isNotEmpty())
        @foreach($customer_payment->customerPaymentReconcileds as $result)
            <tr>
                <td class="text-center">{{ $result->uuid_related }}</td>
                <td class="text-center">{{ $result->serie_related }}</td>
                <td class="text-center">{{ $result->folio_related }}</td>
                <td class="text-center">{{ $result->currency_code_related }}</td>
                <td class="text-center">
                    @if($customer_payment->currency->code != $result->currency_code_related)
                    {{ \App\Helpers\Helper::numberFormat($customer_payment->currency_value/$result->currency_value,6) }}
                    @endif
                </td>
                <td class="text-center">{{ $result->payment_method_code_related }}</td>
                <td class="text-center">{{ $result->number_of_payment }}</td>
                <td class="text-right">{{ money($result->last_balance,$customer_payment->currency->code,true) }}</td>
                <td class="text-right">{{ money($result->amount_reconciled,$customer_payment->currency->code,true) }}</td>
                <td class="text-right">{{ money($result->current_balance,$customer_payment->currency->code,true) }}</td>
            </tr>
        @endforeach
        @endif
        </tbody>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="40%" style="vertical-align: top; padding: 5px;">
                <strong>@lang('sales/customer_payment.entry_payment_way_id'): </strong>{{ $customer_payment->paymentWay->name_sat }}
                <br/>
                <strong>@lang('sales/customer_payment.entry_reference'): </strong>{{ $customer_payment->reference }}
                <br/>
                @if(!empty($cfdi33))
                <strong>@lang('general.text_cfdi_certificado'): </strong>{{ $cfdi33['NoCertificado'] }}
                <br/>
                <strong>@lang('general.text_cfdi_tfd_no_certificado_sat'): </strong>{{ $cfdi33->complemento->timbreFiscalDigital['NoCertificadoSAT'] }}
                <br/>
                <strong>@lang('general.text_cfdi_tfd_fecha_timbrado'): </strong>{{ \App\Helpers\Helper::convertSqlToDateTime(str_replace('T',' ',$cfdi33->complemento->timbreFiscalDigital['FechaTimbrado'])) }}
                <br/>
                @endif
            </td>
            <td width="30%" style="vertical-align: top; padding: 5px;">
                <strong>@lang('sales/customer_payment.text_ordenante')</strong>
                <br/>
                <strong>@lang('sales/customer_payment.text_RfcEmisorCtaOrd'): </strong>{{ $customer_payment->customerBankAccount->bank->taxid ?? '' }}
                <br/>
                <strong>@lang('sales/customer_payment.text_NomBancoOrdExt'): </strong>{{ $customer_payment->customerBankAccount->bank->name ?? '' }}
                <br/>
                <strong>@lang('sales/customer_payment.text_CtaOrdenante'): </strong>{{ $customer_payment->customerBankAccount->account_number ?? '' }}
                <br/>
            </td>
            <td width="30%" style="vertical-align: top; padding: 5px;">
                @lang('sales/customer_payment.text_beneficiario')
                <br/>
                <strong>@lang('sales/customer_payment.text_RfcEmisorCtaOrd'): </strong>{{ $customer_payment->companyBankAccount->bank->taxid ?? '' }}
                <br/>
                <strong>@lang('sales/customer_payment.text_CtaOrdenante'): </strong>{{ $customer_payment->companyBankAccount->account_number ?? '' }}
                <br/>
            </td>
        </tr>
    </table>
    </div>
    @if(!empty($data['cfdi33']->complemento->pagos->pago['TipoCadPago']))
        <div>
        <p style="margin-bottom: 2px;">&nbsp;</p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px; word-wrap:break-word;">
                    <strong>@lang('sales/customer_payment.entry_tipo_cadena_pago')</strong><br/>
                    {!! nl2br($data['cfdi33']->complemento->pagos->pago['TipoCadPago']) !!} - {{isset($tipo_cadena_pagos[$data['cfdi33']->complemento->pagos->pago['TipoCadPago']]) ? $tipo_cadena_pagos[$data['cfdi33']->complemento->pagos->pago['TipoCadPago']] : '' }}<br/>
                    <strong>@lang('sales/customer_payment.entry_certificado_pago')</strong><br/>
                    {!! nl2br($data['cfdi33']->complemento->pagos->pago['CertPago']) !!}<br/>
                    <strong>@lang('sales/customer_payment.entry_cadena_pago')</strong><br/>
                    {!! nl2br($data['cfdi33']->complemento->pagos->pago['CadPago']) !!}<br/>
                    <strong>@lang('sales/customer_payment.entry_sello_pago')</strong><br/>
                    {!! nl2br($data['cfdi33']->complemento->pagos->pago['SelloPago']) !!}<br/>
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_payment->cfdi_relation_id))
        <div>
        <p style="margin-bottom: 2px;">
            <strong>@lang('sales/customer_payment.tab_relations') - {{ $customer_payment->cfdiRelation->name_sat }} </strong>
        </p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                    @if($customer_payment->customerPaymentRelations->isNotEmpty())
                        @foreach($customer_payment->customerPaymentRelations as $result)
                            {{$result->relation->name ?? ''}}<br/>
                        @endforeach
                    @endif
                </td>
                <td width="85%" style="vertical-align: middle; padding: 5px;">
                    @if($customer_payment->customerPaymentRelations->isNotEmpty())
                        @foreach($customer_payment->customerPaymentRelations as $result)
                            {{$result->uuid_related}}<br/>
                        @endforeach
                    @endif
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_payment->comment))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_payment.entry_comment')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;">
                    {!! nl2br($customer_payment->comment) !!}
                </td>
            </tr>
        </table>
        </div>
    @endif
</section>
</body>
</html>
