<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_payment->documentType->name}}-{{$customer_payment->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 155px;
            margin-bottom: 27px;
            margin-left: 23px;
            margin-right: 23px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_payment->company_id) }}     !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_payment->company_id) }}     !important;
        }
        .cell-primary {
            border: 1px solid {{ \App\Helpers\Helper::companyColorPrimary($customer_payment->company_id) }}     !important;
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_payment->company_id) }}     !important;
            color: #ffffff;
            font-weight: bold;
            padding: 5px 2px;
            text-align: center !important;
            vertical-align: middle !important;
            text-transform: uppercase;
            font-size: 8pt;
        }
        .cell-primary-border-line {
            border: 1px solid #dddddd !important;
            border-radius: 0 0 3px 3px;
            padding: 5px 1px;
        }
    </style>
</head>
<body style="background-color: white;">
@php
//Obtiene datos del Cfdi33
$draft = (int) $customer_payment->status == \App\Models\Sales\CustomerPayment::DRAFT ? true : false;
$cfdi33 = empty($data['cfdi33']) ? null : $data['cfdi33'];
@endphp
<section class="header" style="top: -127px;">
    @if($cfdi33 && $customer_payment->customerPaymentCfdi->pac->test)
    <h2 style="position: absolute; left: 0; top: -25px; color: red;">*** @lang('general.text_test_cfdi') ***</h2>
    @endif
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
            <tr>
                <td width="27%" style="vertical-align: top; border-right: 1px solid #333333;">
                    <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
                        <tr>
                            <td width="100%" class="text-center" style="vertical-align: top; height: 140px;">
                                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_payment->company_id,$customer_payment->project_id) }}" class="invoice-logo" style="max-width: 160px !important;"/>
                                @elseif(!empty(setting('branch_office_logo_docs')))
                                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_payment->company_id,$customer_payment->branch_office_id) }}" class="invoice-logo" style="max-width: 160px !important;"/>
                                @else
                                    <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_payment->company_id) }}" class="invoice-logo" style="max-width: 160px !important;"/>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-center" style="vertical-align: top; ">
                                <h2>{{ mb_strtoupper($customer_payment->documentType->name) }}</h2>
                                <br/>
                                <span class="text-primary" style="font-size: 8pt;">{{ mb_strtoupper($customer_payment->company->comercial_name) }}</span>
                                <br/>
                                <br/>
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-center" style="vertical-align: top; height: 120px; ">
                                <strong>@lang('base/company.text_transmitter'):</strong><br/>
                                {{ mb_strtoupper($customer_payment->company->name) }}
                                @if(!empty($customer_payment->company->address_1) || !empty($customer_payment->company->address_2) || !empty($customer_payment->company->address_3) || !empty($customer_payment->company->address_4))
                                    <br/>
                                    {{ $customer_payment->company->address_1 ?? '' }} {{ $customer_payment->company->address_2 ?? '' }} {{ $customer_payment->company->address_3 ?? '' }} {{ $customer_payment->company->address_4 ?? '' }}
                                @endif
                                @if(!empty($customer_payment->company->city->name) || !empty($customer_payment->company->state->name))
                                    <br/>
                                    {{ !empty($customer_payment->company->city->name) ? $customer_payment->company->city->name . ', ' : '' }}{{ $customer_payment->company->state->name ?? '' }}
                                @endif
                                <br/>
                                {{ $customer_payment->company->country->name ?? '' }}{!! ($customer_payment->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_payment->company->postcode : '') !!}
                                <br/>
                                {{ mb_strtoupper($customer_payment->company->taxid) }}
                                <br/>
                                ---
                                <br/>
                                {{ $customer_payment->company->phone ?? ' ' }}
                                <br/>
                                <span style="text-transform: lowercase;">{{ $customer_payment->company->email ?? ' ' }}</span>
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-center" style="vertical-align: top; ">
                                <strong>@lang('base/company.column_tax_regimen'):</strong><br/>
                                {{ $data['tax_regimen'] ?? ($customer_payment->taxRegimen->name_sat ?? $customer_payment->company->taxRegimen->name_sat) }}
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-center" style="vertical-align: top; padding-top: 10px; height: 120px; ">
                                <strong>@lang('general.text_issued_in'):</strong>
                                @if(!empty($customer_payment->branchOffice->address_1) || !empty($customer_payment->branchOffice->address_2))
                                    <br/>
                                    {{ $customer_payment->branchOffice->address_1 ?? '' }} {{ $customer_payment->branchOffice->address_2 ?? '' }}
                                @endif
                                @if(!empty($customer_payment->branchOffice->address_3) || !empty($customer_payment->branchOffice->address_4))
                                    <br/>
                                    {{ $customer_payment->branchOffice->address_3 ?? '' }} {{ $customer_payment->branchOffice->address_4 ?? '' }}
                                @endif
                                @if(!empty($customer_payment->branchOffice->city->name) || !empty($customer_payment->branchOffice->state->name))
                                    <br/>
                                    {{ $customer_payment->branchOffice->city->name ?? '' }}, {{ $customer_payment->branchOffice->state->name ?? '' }}
                                @endif
                                <br/>
                                {{ $customer_payment->branchOffice->country->name ?? '' }}{!! ($customer_payment->branchOffice->postcode ? '&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ': ' . ($cfdi33['LugarExpedicion'] ?? $customer_payment->branchOffice->postcode) : '') !!}
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-left" style="vertical-align: top; padding-top: 3px; height: 160px;">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-left" style="vertical-align: top; padding-top: 3px; ">
                                <strong>@lang('general.text_cfdi_uuid'):</strong><br/>
                                {{ $customer_payment->customerPaymentCfdi->uuid ?? '' }}
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-left" style="vertical-align: top; padding-top: 3px; ">
                                <strong>@lang('sales/customer_payment.entry_date'):</strong><br/>
                                {{ str_replace(' ',' ',\App\Helpers\Helper::convertSqlToDateTime($customer_payment->date)) }}
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-left" style="vertical-align: top; padding-top: 3px; ">
                                <strong>@lang('sales/customer_payment.entry_date_payment'):</strong><br/>
                                {{ str_replace(' ',' ',\App\Helpers\Helper::convertSqlToDateTime($customer_payment->date_payment)) }}
                            </td>
                        </tr>
                        @if(!empty($cfdi33))
                            <tr>
                                <td width="100%" class="text-left" style="vertical-align: top; padding-top: 3px; ">
                                    <strong>@lang('general.text_cfdi_tfd_fecha_timbrado'):</strong><br/>
                                    {{ \App\Helpers\Helper::convertSqlToDateTime(str_replace('T',' ',$cfdi33->complemento->timbreFiscalDigital['FechaTimbrado'])) }}<br>
                                </td>
                            </tr>
                            <tr>
                                <td width="100%" class="text-left" style="vertical-align: top; padding-top: 3px; ">
                                    <strong>@lang('general.text_cfdi_certificado'):</strong><br/>
                                    {{ $cfdi33['NoCertificado'] }}
                                </td>
                            </tr>
                            <tr>
                                <td width="100%" class="text-left" style="vertical-align: top; padding-top: 3px; ">
                                    <strong>@lang('general.text_cfdi_tfd_no_certificado_sat'):</strong><br/>
                                    {{ $cfdi33->complemento->timbreFiscalDigital['NoCertificadoSAT'] }}
                                </td>
                            </tr>
                            <tr>
                                <td width="100%" class="text-center" style="vertical-align: bottom; padding-top: 8px; height: 150px;">
                                    <img src="{{ $data['qr'] }}" width="120px" style="margin: 5px 0;"/>
                                </td>
                            </tr>
                        @else
                            <tr>
                                <td width="100%" class="text-left" style="vertical-align: top; padding-top: 3px; height: 230px;">
                                    &nbsp;
                                </td>
                            </tr>
                        @endif
                    </table>
                </td>
                <td width="73%" style="vertical-align: top; padding-left: 10px; padding-right: 10px;">
                    <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
                        <tr>
                            <td width="50%" class="text-left" style="vertical-align: top; padding-bottom: 7px; padding-top: 13px; border-bottom: 1px solid #333333;">
                                <strong>{{ mb_strtoupper(!empty($cfdi33->Receptor['Nombre']) ? $cfdi33->Receptor['Nombre'] : $customer_payment->customer->name) }}</strong>
                                <br>
                                {{ mb_strtoupper($cfdi33->Receptor['Rfc'] ?? $customer_payment->customer->taxid) }}
                                <br>
                                @if(!empty($customer_payment->customer->address_1) || !empty($customer_payment->customer->address_2) || !empty($customer_payment->customer->address_3) || !empty($customer_payment->customer->address_4))
                                    {{ $customer_payment->customer->address_1 ?? '' }} {{ $customer_payment->customer->address_2 ?? '' }} {{ $customer_payment->customer->address_3 ?? '' }} {{ $customer_payment->customer->address_4 ?? '' }}
                                    <br/>
                                @endif
                                @if(!empty($customer_payment->customer->city->name) || !empty($customer_payment->customer->state->name))
                                    {{ !empty($customer_payment->customer->city->name) ? $customer_payment->customer->city->name . ', ' : '' }}{{ $customer_payment->customer->state->name ?? '' }}
                                    <br/>
                                @endif
                                {{ $customer_payment->customer->country->name ?? '' }}{!! ($customer_payment->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_payment->customer->postcode : '') !!}
                            </td>
                            <td width="50%" class="text-left" style="vertical-align: top; padding-left: 5px; padding-bottom: 7px; padding-top: 13px; border-bottom: 1px solid #333333;  border-left: 1px solid #333333;">
                                <table cellpadding="0" cellspacing="0" class="" width="100%">
                                    <tr>
                                        <td width="45%">@lang('sales/customer_payment.entry_name')</td>
                                        <td width="55%">{{ $customer_payment->name }}</td>
                                    </tr>
                                    <tr>
                                        <td>@lang('base/document_type.entry_cfdi_type_id')</td>
                                        <td>{{ $customer_payment->documentType->cfdiType->name_sat ?? ''}}</td>
                                    </tr>
                                    <tr>
                                        <td>@lang('sales/customer_payment.entry_payment_way_id')</td>
                                        <td>{{ $customer_payment->paymentWay->name_sat }}</td>
                                    </tr>
                                    <tr>
                                        <td>@lang('sales/customer_payment.entry_currency_id')</td>
                                        <td>
                                            {{ $customer_payment->currency->code }}
                                            @if($customer_payment->currency->code!='MXN')
                                                {{ '&nbsp;&nbsp;&nbsp;' . __('sales/customer_payment.entry_currency_value') . ': '. round($customer_payment->currency_value,4)}}
                                            @endif
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_payment->status == \App\Models\Sales\CustomerPayment::CANCEL)
    <section class="watermark" style="bottom: 450px !important;">
        @if(!empty($customer_payment->customerPaymentCfdi->uuid))
            <span>@lang('general.text_canceled_cfdi')</span>
        @else
            <span>@lang('general.text_canceled')</span>
        @endif
    </section>
@endif
@if($draft)
    <section class="watermark" style="bottom: 700px !important;">
        <span>@lang('general.text_pre_payment')</span>
    </section>
@endif
<section>
    <div style="padding-left: 28%;">

                <div>
                    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
                        <thead>
                        <tr>
                            <th width="7%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_quantity')) }}</th>
                            <th class="text-left">{{ mb_strtoupper(__('sales/customer_invoice.column_line_sat_product_id')) . ' - ' . mb_strtoupper(__('sales/customer_invoice.column_line_name')) }}</th>
                            <th width="14%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_unit_measure_id')) }}</th>
                            <th width="9%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_price_unit')) }}</th>
                            <th width="11%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_amount_untaxed')) }}</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td class="text-center">1</td>
                            <td>84111506 - Pago</td>
                            <td class="text-center">ACT</td>
                            <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney(0,0) }}</td>
                            <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney(0,0) }}</td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <p style="margin-bottom: 2px; margin-top: 15px;"><strong>@lang('sales/customer_payment.text_payment_complement')</strong></p>
                <div>
                    <table cellpadding="0" cellspacing="0" class="table-items" width="100%" style="margin-bottom: 15px;">
                        <thead>
                        <tr>
                            <th class="text-center">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_uuid')) }}</th>
                            <th width="6%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_serie')) }}</th>
                            <th width="6%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_folio')) }}</th>
                            <th width="6%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_currency')) }}</th>
                            <th width="7%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_currency_value2')) }}</th>
                            <th width="7%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_payment_method')) }}</th>
                            <th width="8%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_number_of_payment')) }}</th>
                            <th width="10%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_last_balance')) }}</th>
                            <th width="10%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_amount_reconciled2')) }}</th>
                            <th width="10%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_currenct_balance')) }}</th>
                        </tr>
                        </thead>
                        <tbody>
                        @if($customer_payment->customerPaymentReconcileds->isNotEmpty())
                            @foreach($customer_payment->customerPaymentReconcileds as $result)
                                <tr>
                                    <td class="text-center">{{ $result->uuid_related }}</td>
                                    <td class="text-center">{{ $result->serie_related }}</td>
                                    <td class="text-center">{{ $result->folio_related }}</td>
                                    <td class="text-center">{{ $result->currency_code_related }}</td>
                                    <td class="text-center">
                                        @if($customer_payment->currency->code != $result->currency_code_related)
                                            {{ \App\Helpers\Helper::numberFormat($customer_payment->currency_value/$result->currency_value,6) }}
                                        @endif
                                    </td>
                                    <td class="text-center">{{ $result->payment_method_code_related }}</td>
                                    <td class="text-center">{{ $result->number_of_payment }}</td>
                                    <td class="text-right">{{ money($result->last_balance,$customer_payment->currency->code,true) }}</td>
                                    <td class="text-right">{{ money($result->amount_reconciled,$customer_payment->currency->code,true) }}</td>
                                    <td class="text-right">{{ money($result->current_balance,$customer_payment->currency->code,true) }}</td>
                                </tr>
                            @endforeach
                        @endif
                        </tbody>
                    </table>
                </div>
                <div>
                    <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
                        <tr>
                            <td width="40%" style="vertical-align: top; padding: 5px;">
                                <strong>@lang('sales/customer_payment.entry_amount'): </strong>{{ money($customer_payment->amount,$customer_payment->currency->code,true) }}
                                <br/>
                                <strong>@lang('sales/customer_payment.entry_reference'): </strong>{{ $customer_payment->reference }}
                                <br/>
                            </td>
                            <td width="30%" style="vertical-align: top; padding: 5px;">
                                <strong>@lang('sales/customer_payment.text_ordenante')</strong>
                                <br/>
                                <strong>@lang('sales/customer_payment.text_RfcEmisorCtaOrd'): </strong>{{ $customer_payment->customerBankAccount->bank->taxid ?? '' }}
                                <br/>
                                <strong>@lang('sales/customer_payment.text_NomBancoOrdExt'): </strong>{{ $customer_payment->customerBankAccount->bank->name ?? '' }}
                                <br/>
                                <strong>@lang('sales/customer_payment.text_CtaOrdenante'): </strong>{{ $customer_payment->customerBankAccount->account_number ?? '' }}
                                <br/>
                            </td>
                            <td width="30%" style="vertical-align: top; padding: 5px;">
                                <strong>@lang('sales/customer_payment.text_beneficiario')</strong>
                                <br/>
                                <strong>@lang('sales/customer_payment.text_RfcEmisorCtaOrd'): </strong>{{ $customer_payment->companyBankAccount->bank->taxid ?? '' }}
                                <br/>
                                <strong>@lang('sales/customer_payment.text_CtaOrdenante'): </strong>{{ $customer_payment->companyBankAccount->account_number ?? '' }}
                                <br/>
                            </td>
                        </tr>
                    </table>
                </div>
                @if(!empty($data['cfdi33']->complemento->pagos->pago['TipoCadPago']))
                    <div>
                        <p style="margin-bottom: 2px;">&nbsp;</p>
                        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
                            <tr>
                                <td width="100%" style="vertical-align: top; padding: 5px; word-wrap:break-word;">
                                    <strong>@lang('sales/customer_payment.entry_tipo_cadena_pago')</strong><br/>
                                    {!! nl2br($data['cfdi33']->complemento->pagos->pago['TipoCadPago']) !!} - {{isset($tipo_cadena_pagos[$data['cfdi33']->complemento->pagos->pago['TipoCadPago']]) ? $tipo_cadena_pagos[$data['cfdi33']->complemento->pagos->pago['TipoCadPago']] : '' }}<br/>
                                    <strong>@lang('sales/customer_payment.entry_certificado_pago')</strong><br/>
                                    {!! nl2br($data['cfdi33']->complemento->pagos->pago['CertPago']) !!}<br/>
                                    <strong>@lang('sales/customer_payment.entry_cadena_pago')</strong><br/>
                                    {!! nl2br($data['cfdi33']->complemento->pagos->pago['CadPago']) !!}<br/>
                                    <strong>@lang('sales/customer_payment.entry_sello_pago')</strong><br/>
                                    {!! nl2br($data['cfdi33']->complemento->pagos->pago['SelloPago']) !!}<br/>
                                </td>
                            </tr>
                        </table>
                    </div>
                @endif
                @if(!empty($cfdi33))
                    <div>
                        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                            <tr>
                                <td width="" class="cell-primary" style=""><small>@lang('general.text_cfdi_tfd_cadena_origen')</small></td>
                            </tr>
                            <tr>
                                <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 45px; padding: 5px;  word-wrap:break-word;">
                                    <small>{{ $data['tfd_cadena_origen'] }}</small>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div>
                        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                            <tr>
                                <td width="" class="cell-primary" style=""><small>@lang('general.text_cfdi_tfd_sello_cfdi')</small></td>
                            </tr>
                            <tr>
                                <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 35px; padding: 5px;  word-wrap:break-word;">
                                    <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloCFD'] }}</small>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div>
                        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                            <tr>
                                <td width="" class="cell-primary" style=""><small>@lang('general.text_cfdi_tfd_sello_sat')</small></td>
                            </tr>
                            <tr>
                                <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 35px; padding: 5px;  word-wrap:break-word;">
                                    <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloSAT'] }}</small>
                                </td>
                            </tr>
                        </table>
                    </div>
                @endif
                @if(!empty($customer_payment->cfdi_relation_id))
                    <div>
                        <p style="margin-bottom: 2px;">
                            <strong>@lang('sales/customer_payment.tab_relations') - {{ $customer_payment->cfdiRelation->name_sat }}</strong>
                        </p>
                        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
                            <tr>
                                <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                                    @if($customer_payment->customerPaymentRelations->isNotEmpty())
                                        @foreach($customer_payment->customerPaymentRelations as $result)
                                            {{$result->relation->name ?? ''}}<br/>
                                        @endforeach
                                    @endif
                                </td>
                                <td width="85%" style="vertical-align: middle; padding: 5px;">
                                    @if($customer_payment->customerPaymentRelations->isNotEmpty())
                                        @foreach($customer_payment->customerPaymentRelations as $result)
                                            {{$result->uuid_related}}<br/>
                                        @endforeach
                                    @endif
                                </td>
                            </tr>
                        </table>
                    </div>
                @endif
                @if(!empty($customer_payment->comment))
                    <div>
                        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_payment.entry_comment')</strong></p>
                        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
                            <tr>
                                <td width="100%" style="vertical-align: top; padding: 5px;">
                                    {!! nl2br($customer_payment->comment) !!}
                                </td>
                            </tr>
                        </table>
                    </div>
                @endif
    </div>
</section>
</body>
</html>
