<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_payment->documentType->name}}-{{$customer_payment->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 327px;
            margin-bottom: 27px;
            margin-left: 23px;
            margin-right: 23px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_payment->company_id) }}     !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_payment->company_id) }}     !important;
        }
        .cell-primary {
            border: 1px solid {{ \App\Helpers\Helper::companyColorPrimary($customer_payment->company_id) }}     !important;
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_payment->company_id) }}     !important;
            color: #ffffff;
            font-weight: bold;
            padding: 5px 2px;
            text-align: center !important;
            vertical-align: middle !important;
            text-transform: uppercase;
            font-size: 8pt;
        }
        .cell-primary-border-line {
            border: 1px solid #dddddd !important;
            border-radius: 0 0 3px 3px;
            padding: 5px 1px;
        }
    </style>
</head>
<body style="background-color: white;">
@php
//Obtiene datos del Cfdi33
$draft = (int) $customer_payment->status == \App\Models\Sales\CustomerPayment::DRAFT ? true : false;
$cfdi33 = empty($data['cfdi33']) ? null : $data['cfdi33'];
@endphp
<section class="header" style="top: -289px;">
    @if($cfdi33 && $customer_payment->customerPaymentCfdi->pac->test)
    <h2 style="position: absolute; left: 0; top: -35px; color: red;">*** @lang('general.text_test_cfdi') ***</h2>
    @endif
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
            <tr>
                <td width="22%" class="text-left" style="vertical-align: top; padding-bottom: 7px; height: 90px;">
                    @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                        <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_payment->company_id,$customer_payment->project_id) }}" class="invoice-logo" style="max-width: 160px !important; max-height: 60px !important;"/>
                    @elseif(!empty(setting('branch_office_logo_docs')))
                        <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_payment->company_id,$customer_payment->branch_office_id) }}" class="invoice-logo" style="max-width: 160px !important; max-height: 60px !important;"/>
                    @else
                        <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_payment->company_id) }}" class="invoice-logo" style="max-width: 160px !important; max-height: 60px !important;"/>
                    @endif
                </td>
                <td width="28%" class="text-left" style="vertical-align: top; padding-bottom: 7px; padding-left: 5px;">
                    @if(!empty($customer_payment->company->comercial_name))
                    <span class="text-primary" style="font-size: 8pt;">{{ mb_strtoupper($customer_payment->company->comercial_name) }}</span>
                    <br/>
                    @endif
                    {{ mb_strtoupper($customer_payment->company->name) }}
                    @if(!empty($customer_payment->company->address_1) || !empty($customer_payment->company->address_2) || !empty($customer_payment->company->address_3) || !empty($customer_payment->company->address_4))
                        <br/>
                        {{ $customer_payment->company->address_1 ?? '' }} {{ $customer_payment->company->address_2 ?? '' }} {{ $customer_payment->company->address_3 ?? '' }} {{ $customer_payment->company->address_4 ?? '' }}
                    @endif
                    @if(!empty($customer_payment->company->city->name) || !empty($customer_payment->company->state->name))
                        <br/>
                        {{ !empty($customer_payment->company->city->name) ? $customer_payment->company->city->name . ', ' : '' }}{{ $customer_payment->company->state->name ?? '' }}
                    @endif
                    <br/>
                    {{ $customer_payment->company->country->name ?? '' }}{!! ($customer_payment->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_payment->company->postcode : '') !!}
                    <br/>
                    {{ mb_strtoupper($customer_payment->company->taxid) }}
                    <br/>
                    ---
                    <br/>
                    {{ $customer_payment->company->phone ?? ' ' }}
                    <br/>
                    <span style="text-transform: lowercase;">{{ $customer_payment->company->email ?? ' ' }}</span>
                </td>
                <td width="29%" class="text-left" rowspan="2" style="vertical-align: top; padding-left: 5px; padding-bottom: 7px; border-left: 1px solid #333333;">
                    <h3 style="margin: 0;">{{ mb_strtoupper($customer_payment->documentType->name) }}</h3><br>
                    <strong>@lang('general.text_cfdi_uuid'):</strong><br/>
                    {{ $customer_payment->CustomerPaymentCfdi->uuid ?? '' }}<br/>
                    <strong>@lang('sales/customer_payment.entry_date'):</strong><br/>
                    {{ str_replace(' ',' ',\App\Helpers\Helper::convertSqlToDateTime($customer_payment->date)) }}<br/>
                    <strong>@lang('sales/customer_payment.entry_date_payment'):</strong><br/>
                    {{ \App\Helpers\Helper::convertSqlToDateTime($customer_payment->date_payment) }}<br/>
                    @if(!empty($cfdi33))
                        <strong>@lang('general.text_cfdi_tfd_fecha_timbrado'):</strong><br/>
                        {{ \App\Helpers\Helper::convertSqlToDateTime(str_replace('T',' ',$cfdi33->complemento->timbreFiscalDigital['FechaTimbrado'])) }}<br>
                        <strong>@lang('general.text_cfdi_certificado'):</strong><br/>
                        {{ $cfdi33['NoCertificado'] }}<br/>
                        <strong>@lang('general.text_cfdi_tfd_no_certificado_sat'):</strong><br/>
                        {{ $cfdi33->complemento->timbreFiscalDigital['NoCertificadoSAT'] }}<br/>
                    @endif
                </td>
                <td width="21%" class="text-center" rowspan="2" style="vertical-align: top; padding-bottom: 7px;">
                    @if(!empty($cfdi33))
                        <img src="{{ $data['qr'] }}" width="120px" style="margin: 5px 0;"/>
                    @endif
                </td>
            </tr>
            <tr>
                <td width="50%" class="text-left" colspan="2" style="vertical-align: top; padding-top: 1px; padding-bottom: 7px;">
                    <table cellpadding="0" cellspacing="0" class="" width="100%">
                        <tr>
                            <td width="30%">@lang('sales/customer_payment.entry_name')</td>
                            <td width="70%">{{ $customer_payment->name }}</td>
                        </tr>
                        <tr>
                            <td>@lang('base/document_type.entry_cfdi_type_id')</td>
                            <td>{{ $customer_payment->documentType->cfdiType->name_sat ?? ''}}</td>
                        </tr>
                        <tr>
                            <td>@lang('sales/customer_payment.entry_payment_way_id')</td>
                            <td>{{ $customer_payment->paymentWay->name_sat }}</td>
                        </tr>
                        <tr>
                            <td>@lang('sales/customer_payment.entry_currency_id')</td>
                            <td>
                                {{ $customer_payment->currency->code }}
                                @if($customer_payment->currency->code!='MXN')
                                    {{ '&nbsp;&nbsp;&nbsp;' . __('sales/customer_payment.entry_currency_value') . ': '. round($customer_payment->currency_value,4)}}
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td>@lang('base/company.column_tax_regimen')</td>
                            <td>{{ $data['tax_regimen'] ?? ($customer_payment->taxRegimen->name_sat ?? $customer_payment->company->taxRegimen->name_sat) }}</td>
                        </tr>
                        <tr>
                            <td>@lang('general.text_issued_in')</td>
                            <td>{{ ($cfdi33['LugarExpedicion'] ?? $customer_payment->branchOffice->postcode) }}</td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
            <tr>
                <td width="50%" class="text-left" style="vertical-align: top; padding-bottom: 7px; padding-top: 7px; border-top: 1px solid #333333; border-bottom: 1px solid #333333; height: 50px; ">
                    <strong>{{ mb_strtoupper(!empty($cfdi33->Receptor['Nombre']) ? $cfdi33->Receptor['Nombre'] : $customer_payment->customer->name) }}</strong>
                    <br>
                    @if(!empty($customer_payment->customer->address_1) || !empty($customer_payment->customer->address_2) || !empty($customer_payment->customer->address_3) || !empty($customer_payment->customer->address_4))
                        {{ $customer_payment->customer->address_1 ?? '' }} {{ $customer_payment->customer->address_2 ?? '' }} {{ $customer_payment->customer->address_3 ?? '' }} {{ $customer_payment->customer->address_4 ?? '' }}
                        <br/>
                    @endif
                    @if(!empty($customer_payment->customer->city->name) || !empty($customer_payment->customer->state->name))
                        {{ !empty($customer_payment->customer->city->name) ? $customer_payment->customer->city->name . ', ' : '' }}{{ $customer_payment->customer->state->name ?? '' }}
                        <br/>
                    @endif
                    {{ $customer_payment->customer->country->name ?? '' }}{!! ($customer_payment->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_payment->customer->postcode : '') !!}
                </td>
                <td width="50%" class="text-left" style="vertical-align: top; padding-bottom: 7px; padding-top: 7px; border-top: 1px solid #333333; border-bottom: 1px solid #333333; height: 50px;">
                    @lang('sales/customer_payment.entry_taxid'): {{ mb_strtoupper($cfdi33->Receptor['Rfc'] ?? $customer_payment->customer->taxid) }}
                    <br />
                    @lang('sales/customer_payment.entry_tax_regimen_customer_id2'): {{ $data['tax_regimen_customer'] ?? ($customer_payment->taxRegimenCustomer->name_sat ?? $customer_payment->customer->taxRegimen->name_sat) }}
                </td>
            </tr>
        </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi_40')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_payment->status == \App\Models\Sales\CustomerPayment::CANCEL)
    <section class="watermark" style="bottom: 450px !important;">
        @if(!empty($customer_payment->customerPaymentCfdi->uuid))
            <span>@lang('general.text_canceled_cfdi')</span>
        @else
            <span>@lang('general.text_canceled')</span>
        @endif
    </section>
@endif
@if($draft)
    <section class="watermark" style="bottom: 700px !important;">
        <span>@lang('general.text_pre_payment')</span>
    </section>
@endif
<section>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
            <thead>
            <tr>
                <th width="7%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_quantity')) }}</th>
                <th class="text-left">{{ mb_strtoupper(__('sales/customer_invoice.column_line_sat_product_id')) . ' - ' . mb_strtoupper(__('sales/customer_invoice.column_line_name')) }}</th>
                <th width="14%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_unit_measure_id')) }}</th>
                <th width="9%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_price_unit')) }}</th>
                <th width="11%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_amount_untaxed')) }}</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td class="text-center">1</td>
                <td>84111506 - Pago<br/>{{  __('sales/customer_invoice.column_line_tax_object') . ': 01' }}</td>
                <td class="text-center">ACT</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney(0,0) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney(0,0) }}</td>
            </tr>
            </tbody>
        </table>
    </div>
    <p style="margin-bottom: 2px; margin-top: 15px;"><strong>@lang('sales/customer_payment.text_payment_complement')</strong></p>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-items" width="100%" style="margin-bottom: 15px;">
            <thead>
            <tr>
                <th class="text-center">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_uuid')) }}</th>
                <th width="6%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_serie')) }}</th>
                <th width="6%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_folio')) }}</th>
                <th width="6%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_currency')) }}</th>
                <th width="7%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_currency_value2')) }}</th>
                <th width="7%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_payment_method')) }}</th>
                <th width="8%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_number_of_payment')) }}</th>
                <th width="10%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_last_balance')) }}</th>
                <th width="10%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_amount_reconciled2')) }}</th>
                <th width="10%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_currenct_balance')) }}</th>
            </tr>
            </thead>
            <tbody>
            @if($customer_payment->customerPaymentReconcileds->isNotEmpty())
                @foreach($customer_payment->customerPaymentReconcileds as $result)
                    @php
                    $key = $result->uuid_related . '_' . $result->number_of_payment;
                    @endphp
                    <tr>
                        <td class="text-center">{{ $result->uuid_related }}<br/>{{  __('sales/customer_invoice.column_line_tax_object') . ': ' . (empty($taxesDoctoRelacionado[$key]['TrasladosDR']) && empty($taxesDoctoRelacionado[$key]['RetencionesDR']) ? '01' : '02')  }}</td>
                        <td class="text-center">{{ $result->serie_related }}</td>
                        <td class="text-center">{{ $result->folio_related }}</td>
                        <td class="text-center">{{ $result->currency_code_related }}</td>
                        <td class="text-center">
                            @if($customer_payment->currency->code != $result->currency_code_related)
                                {{ \App\Helpers\Helper::numberFormat($customer_payment->currency_value/$result->currency_value,6) }}
                            @endif
                        </td>
                        <td class="text-center">{{ $result->payment_method_code_related }}</td>
                        <td class="text-center">{{ $result->number_of_payment }}</td>
                        <td class="text-right">{{ money($result->last_balance,$customer_payment->currency->code,true) }}</td>
                        <td class="text-right">{{ money($result->amount_reconciled,$customer_payment->currency->code,true) }}</td>
                        <td class="text-right">{{ money($result->current_balance,$customer_payment->currency->code,true) }}</td>
                    </tr>
                    @if(!empty($taxesDoctoRelacionado[$key]))
                        <tr>
                            <td class="" colspan="10">
                                <table class="table-subitems" width="100%" cellpadding="0" cellspacing="0">
                                    <tr>
                                        <th width="40%" style="border: none;"></th>
                                        <th></th>
                                        <th class="text-center">@lang('sales/customer_payment.text_BaseDR')</th>
                                        <th class="text-center">@lang('sales/customer_payment.text_ImpuestoDR')</th>
                                        <th class="text-center">@lang('sales/customer_payment.text_TipoFactorDR')</th>
                                        <th class="text-center">@lang('sales/customer_payment.text_TasaOCuotaDR')</th>
                                        <th class="text-center">@lang('sales/customer_payment.text_ImporteDR')</th>
                                    </tr>
                                    @foreach($taxesDoctoRelacionado[$key]['TrasladosDR'] as $keyt => $element))
                                    <tr>
                                        <td style="border: none;"></td>
                                        <td>{{ $keyt == 0 ? __('sales/customer_payment.text_Traslados') : ''}}</td>
                                        <td class="text-right">{{$element['BaseDR']}}</td>
                                        <td class="text-center">{{$element['ImpuestoDR']}}</td>
                                        <td class="text-center">{{$element['TipoFactorDR']}}</td>
                                        <td class="text-right">{{$element['TasaOCuotaDR']}}</td>
                                        <td class="text-right">{{$element['ImporteDR']}}</td>
                                    </tr>
                                    @endforeach
                                    @foreach($taxesDoctoRelacionado[$key]['RetencionesDR'] as $keyr => $element))
                                    <tr>
                                        <td style="border: none;"></td>
                                        <td>{{ $keyr == 0 ? __('sales/customer_payment.text_Retenciones') : ''}}</td>
                                        <td class="text-right">{{$element['BaseDR']}}</td>
                                        <td class="text-center">{{$element['ImpuestoDR']}}</td>
                                        <td class="text-center">{{$element['TipoFactorDR']}}</td>
                                        <td class="text-right">{{$element['TasaOCuotaDR']}}</td>
                                        <td class="text-right">{{$element['ImporteDR']}}</td>
                                    </tr>
                                    @endforeach
                                </table>
                            </td>
                        </tr>
                    @endif
                @endforeach
            @endif
            </tbody>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
            <tr>
                <td width="40%" style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_payment.entry_amount'): </strong>{{ money($customer_payment->amount,$customer_payment->currency->code,true) }}
                    <br/>
                    <strong>@lang('sales/customer_payment.entry_reference'): </strong>{{ $customer_payment->reference }}
                    <br/>
                </td>
                <td width="30%" style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_payment.text_ordenante')</strong>
                    <br/>
                    <strong>@lang('sales/customer_payment.text_RfcEmisorCtaOrd'): </strong>{{ $customer_payment->customerBankAccount->bank->taxid ?? '' }}
                    <br/>
                    <strong>@lang('sales/customer_payment.text_NomBancoOrdExt'): </strong>{{ $customer_payment->customerBankAccount->bank->name ?? '' }}
                    <br/>
                    <strong>@lang('sales/customer_payment.text_CtaOrdenante'): </strong>{{ $customer_payment->customerBankAccount->account_number ?? '' }}
                    <br/>
                </td>
                <td width="30%" style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_payment.text_beneficiario')</strong>
                    <br/>
                    <strong>@lang('sales/customer_payment.text_RfcEmisorCtaOrd'): </strong>{{ $customer_payment->companyBankAccount->bank->taxid ?? '' }}
                    <br/>
                    <strong>@lang('sales/customer_payment.text_CtaOrdenante'): </strong>{{ $customer_payment->companyBankAccount->account_number ?? '' }}
                    <br/>
                </td>
            </tr>
        </table>
    </div>
    @if(!empty($data['cfdi33']->complemento->pagos->pago['TipoCadPago']))
        <div>
            <p style="margin-bottom: 2px;">&nbsp;</p>
            <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
                <tr>
                    <td width="100%" style="vertical-align: top; padding: 5px; word-wrap:break-word;">
                        <strong>@lang('sales/customer_payment.entry_tipo_cadena_pago')</strong><br/>
                        {!! nl2br($data['cfdi33']->complemento->pagos->pago['TipoCadPago']) !!} - {{isset($tipo_cadena_pagos[$data['cfdi33']->complemento->pagos->pago['TipoCadPago']]) ? $tipo_cadena_pagos[$data['cfdi33']->complemento->pagos->pago['TipoCadPago']] : '' }}<br/>
                        <strong>@lang('sales/customer_payment.entry_certificado_pago')</strong><br/>
                        {!! nl2br($data['cfdi33']->complemento->pagos->pago['CertPago']) !!}<br/>
                        <strong>@lang('sales/customer_payment.entry_cadena_pago')</strong><br/>
                        {!! nl2br($data['cfdi33']->complemento->pagos->pago['CadPago']) !!}<br/>
                        <strong>@lang('sales/customer_payment.entry_sello_pago')</strong><br/>
                        {!! nl2br($data['cfdi33']->complemento->pagos->pago['SelloPago']) !!}<br/>
                    </td>
                </tr>
            </table>
        </div>
    @endif
    @if(!empty($data['cfdi33']->complemento->pagos->Totales))
        @php
            $totales = $data['cfdi33']->complemento->pagos->Totales;
        @endphp
        <div>
        <p style="margin-bottom: 2px;">@lang('sales/customer_payment.text_total_taxes')</p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="50%" style="vertical-align: top; padding: 5px; word-wrap:break-word;">
                    @if(!empty($totales['TotalTrasladosBaseIVA16']))
                        <strong>@lang('sales/customer_payment.text_TotalTrasladosBaseIVA16')</strong>: {!! money($totales['TotalTrasladosBaseIVA16'],$customer_payment->currency->code,true) !!}<br/>
                    @endif
                    @if(!empty($totales['TotalTrasladosImpuestoIVA16']))
                        <strong>@lang('sales/customer_payment.text_TotalTrasladosImpuestoIVA16')</strong>: {!! money($totales['TotalTrasladosImpuestoIVA16'],$customer_payment->currency->code,true) !!}<br/>
                    @endif
                    @if(!empty($totales['TotalTrasladosBaseIVA8']))
                        <strong>@lang('sales/customer_payment.text_TotalTrasladosBaseIVA8')</strong>: {!! money($totales['TotalTrasladosBaseIVA8'],$customer_payment->currency->code,true) !!}<br/>
                    @endif
                    @if(!empty($totales['TotalTrasladosImpuestoIVA8']))
                        <strong>@lang('sales/customer_payment.text_TotalTrasladosImpuestoIVA8')</strong>: {!! money($totales['TotalTrasladosImpuestoIVA8'],$customer_payment->currency->code,true) !!}<br/>
                    @endif
                    @if(!empty($totales['TotalTrasladosBaseIVA0']))
                        <strong>@lang('sales/customer_payment.text_TotalTrasladosBaseIVA0')</strong>: {!! money($totales['TotalTrasladosBaseIVA0'],$customer_payment->currency->code,true) !!}<br/>
                    @endif
                    @if(!empty($totales['TotalTrasladosImpuestoIVA0']))
                        <strong>@lang('sales/customer_payment.text_TotalTrasladosImpuestoIVA0')</strong>: {!! money($totales['TotalTrasladosImpuestoIVA0'],$customer_payment->currency->code,true) !!}<br/>
                    @endif
                    @if(!empty($totales['TotalTrasladosBaseIVAExento']))
                        <strong>@lang('sales/customer_payment.text_TotalTrasladosBaseIVAExento')</strong>: {!! money($totales['TotalTrasladosBaseIVAExento'],$customer_payment->currency->code,true) !!}<br/>
                    @endif
                </td>
                <td width="50%" style="vertical-align: top; padding: 5px; word-wrap:break-word;">
                    @if(!empty($totales['TotalRetencionesIVA']))
                        <strong>@lang('sales/customer_payment.text_TotalRetencionesIVA')</strong>: {!! money($totales['TotalRetencionesIVA'],$customer_payment->currency->code,true) !!}<br/>
                    @endif
                    @if(!empty($totales['TotalRetencionesISR']))
                        <strong>@lang('sales/customer_payment.text_TotalRetencionesISR')</strong>: {!! money($totales['TotalRetencionesISR'],$customer_payment->currency->code,true) !!}<br/>
                    @endif
                    @if(!empty($totales['TotalRetencionesIEPS']))
                        <strong>@lang('sales/customer_payment.text_TotalRetencionesIEPS')</strong>: {!! money($totales['TotalRetencionesIEPS'],$customer_payment->currency->code,true) !!}<br/>
                    @endif
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($cfdi33))
        <div>
            <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                <tr>
                    <td width="" class="cell-primary" style=""><small>@lang('general.text_cfdi_tfd_cadena_origen')</small></td>
                </tr>
                <tr>
                    <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 45px; padding: 5px;  word-wrap:break-word;">
                        <small>{{ $data['tfd_cadena_origen'] }}</small>
                    </td>
                </tr>
            </table>
        </div>
        <div>
            <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                <tr>
                    <td width="" class="cell-primary" style=""><small>@lang('general.text_cfdi_tfd_sello_cfdi')</small></td>
                </tr>
                <tr>
                    <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 35px; padding: 5px;  word-wrap:break-word;">
                        <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloCFD'] }}</small>
                    </td>
                </tr>
            </table>
        </div>
        <div>
            <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                <tr>
                    <td width="" class="cell-primary" style=""><small>@lang('general.text_cfdi_tfd_sello_sat')</small></td>
                </tr>
                <tr>
                    <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 35px; padding: 5px;  word-wrap:break-word;">
                        <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloSAT'] }}</small>
                    </td>
                </tr>
            </table>
        </div>
    @endif
    @if(!empty($customer_payment->cfdi_relation_id))
        <div>
            <p style="margin-bottom: 2px;">
                <strong>@lang('sales/customer_payment.tab_relations') - {{ $customer_payment->cfdiRelation->name_sat }}</strong>
            </p>
            <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
                <tr>
                    <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                        @if($customer_payment->CustomerPaymentRelations->isNotEmpty())
                            @foreach($customer_payment->CustomerPaymentRelations as $result)
                                {{$result->relation->name ?? ''}}<br/>
                            @endforeach
                        @endif
                    </td>
                    <td width="85%" style="vertical-align: middle; padding: 5px;">
                        @if($customer_payment->CustomerPaymentRelations->isNotEmpty())
                            @foreach($customer_payment->CustomerPaymentRelations as $result)
                                {{$result->uuid_related}}<br/>
                            @endforeach
                        @endif
                    </td>
                </tr>
            </table>
        </div>
    @endif
    @if(!empty($customer_payment->comment))
        <div>
            <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_payment.entry_comment')</strong></p>
            <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
                <tr>
                    <td width="100%" style="vertical-align: top; padding: 5px;">
                        {!! nl2br($customer_payment->comment) !!}
                    </td>
                </tr>
            </table>
        </div>
    @endif
</section>
</body>
</html>
