<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_payment->documentType->name}}-{{$customer_payment->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 310px;
            margin-bottom: 40px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 10px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_payment->company_id) }}   !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_payment->company_id) }}   !important;
        }
    </style>
</head>
<body style="background-color: white;">
<section class="header" style="top: -287px;">
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td colspan="2" class="text-right">
                <h1>{{ mb_strtoupper($customer_payment->documentType->name) }}</h1>
            </td>
        </tr>
        <tr>
            <td width="50%" style="vertical-align: top; padding-top: 10px;">
                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_payment->company_id,$customer_payment->project_id) }}" class="invoice-logo" width="170px"/>
                @elseif(!empty(setting('branch_office_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_payment->company_id,$customer_payment->branch_office_id) }}" class="invoice-logo" width="170px"/>
                @else
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_payment->company_id) }}" class="invoice-logo" width="170px"/>
                @endif
            </td>
            <td width="50%" class="text-right text-company" style="vertical-align: top; padding-top: 10px;">
                <span><strong>{{ mb_strtoupper($customer_payment->company->name) }}</strong></span>
                <br/>
                <span>{{ $customer_payment->company->address_1 ?? '' }} {{ $customer_payment->company->address_2 ?? '' }} {{ $customer_payment->company->address_3 ?? '' }} {{ $customer_payment->company->address_4 ?? '' }}</span>
                <br/>
                <span>{{ $customer_payment->company->city->name ?? '' }}, {{ ($customer_payment->company->state->name ?? '') }}</span>
                <br/>
                <span>{{ $customer_payment->company->country->name ?? '' }}{!! ($customer_payment->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_payment->company->postcode : '') !!}</span>
                <br/>
                <span>{{ mb_strtoupper($customer_payment->company->taxid) }}</span>
                <br/>
                <span>---</span>
                <br/>
                <span>{{ $customer_payment->company->phone ?? ' ' }}</span>
                <br/>
                <span>{{ $customer_payment->company->email ?? ' ' }}</span>
            </td>
        </tr>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary"># {{ $customer_payment->name }}</span>

            </td>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary">{{ mb_strtoupper(__('general.text_customer')) }}</span>
            </td>
        </tr>
        <tr>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <span><strong>@lang('sales/customer_payment.entry_date')
                        : </strong>{{ \App\Helpers\Helper::convertSqlToDateTime($customer_payment->date) }}</span>
                <br/>
                <span><strong>@lang('sales/customer_payment.entry_date_payment')
                        : </strong>{{ $customer_payment->date_payment ? \App\Helpers\Helper::convertSqlToDateTime($customer_payment->date_payment) : '' }}</span>
                <br/>
                <span><strong>@lang('sales/customer_payment.entry_amount')
                        : </strong>{{ money($customer_payment->amount,$customer_payment->currency->code,true) }}</span>
                <br/>
                <span><strong>@lang('sales/customer_payment.entry_reference')
                        : </strong>{{ $customer_payment->reference }}</span>
                <br/>
                <span><strong>@lang('sales/customer_payment.entry_payment_way_id')
                        : </strong>{{ $customer_payment->paymentWay->name }}</span>
                <br/>
                <span><strong>@lang('sales/customer_payment.entry_currency_id')
                        : </strong>{{ $customer_payment->currency->code }}{!! ($customer_payment->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/customer_payment.entry_currency_value').':</strong> '.round($customer_payment->currency_value,4) :'') !!}</span>
                <br/>
                <span><strong>@lang('general.text_issued_in')
                        : </strong>{{ $customer_payment->branchOffice->name ?? '' }} {!! ($customer_payment->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $customer_payment->branchOffice->postcode : '') !!}</span>
                <br/>
            </td>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <span><strong>{{ mb_strtoupper($customer_payment->customer->name) }}</strong></span>
                <br/>
                <span>{{ $customer_payment->customer->address_1 ?? '' }} {{ $customer_payment->customer->address_2 ?? '' }} {{ $customer_payment->customer->address_3 ?? '' }} {{ $customer_payment->customer->address_4 ?? '' }}</span>
                <br/>
                <span>{{ $customer_payment->customer->city->name ?? '' }}
                    , {{ $customer_payment->customer->state->name ?? '' }}</span>
                <br/>
                <span>{{ $customer_payment->customer->country->name ?? '' }}{!! ($customer_payment->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_payment->customer->postcode : '') !!}</span>
                <br/>
                @lang('sales/customer_payment.entry_taxid'): {{ $customer_payment->customer->taxid }}
                <br />
                @lang('sales/customer_payment.entry_tax_regimen_customer_id2'): {{ $customer_payment->taxRegimenCustomer->name_sat ?? ($customer_payment->customer->taxRegimen->name_sat ?? '') }}
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">

            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_payment->status == \App\Models\Sales\CustomerPayment::CANCEL)
    <section class="watermark" style="bottom: 490px !important;">
        <span>@lang('general.text_canceled')</span>
    </section>
@endif
<section>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
        <thead>
        <tr>
            <th class="text-center">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_name')) }}</th>
            <th class="text-center">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_serie')) }}</th>
            <th class="text-center">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_folio')) }}</th>
            <th class="text-center">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_uuid')) }}</th>
            <th class="text-center">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_amount_reconciled')) }}</th>
        </tr>
        </thead>
        <tbody>
        @if($customer_payment->customerPaymentReconcileds->isNotEmpty())
        @foreach($customer_payment->customerPaymentReconcileds as $result)
            <tr>
                <td class="text-center">{{ $result->name }}</td>
                <td class="text-center">{{ $result->serie_related }}</td>
                <td class="text-center">{{ $result->folio_related }}</td>
                <td class="text-center">{{ $result->uuid_related }}</td>
                <td class="text-right">{{ money($result->amount_reconciled,$customer_payment->currency->code,true) }}</td>
            </tr>
        @endforeach
        @endif
        </tbody>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="50%" style="vertical-align: top; padding: 5px;">


            </td>
            <td width="50%" style="vertical-align: top; padding: 5px;">


            </td>
        </tr>
    </table>
    </div>
    @if(!empty($customer_payment->cfdi_relation_id))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_payment.tab_relations')
                - {{ $customer_payment->cfdiRelation->name_sat }} </strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" >
            <tr>
                <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                    @if($customer_payment->customerPaymentRelations->isNotEmpty())
                        @foreach($customer_payment->customerPaymentRelations as $result)
                            {{$result->relation->name}}<br/>
                        @endforeach
                    @endif
                </td>
                <td width="85%" style="vertical-align: middle; padding: 5px;">
                    @if($customer_payment->customerPaymentRelations->isNotEmpty())
                        @foreach($customer_payment->customerPaymentRelations as $result)
                            {{$result->relation->customerPaymentCfdi->uuid}}<br/>
                        @endforeach
                    @endif
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_payment->comment))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_payment.entry_comment')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;">
                    {!! nl2br($customer_payment->comment) !!}
                </td>
            </tr>
        </table>
        </div>
    @endif
</section>
</body>
</html>
