@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('sales/customer_payment.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('sales/customer_payment.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('customer-payments.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            @php
                //Obtiene datos del Cfdi33
                $cfdi33 = !empty($data['cfdi33']) ? $data['cfdi33'] : [];
            @endphp

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>{{ $customer_payment->documentType->name }}</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">


                            <section class="content invoice">
                                <!-- title row -->
                                <div class="row">
                                    <div class="col-xs-12 invoice-header">
                                        <h1></h1>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 20px;">
                                    <div class="col-md-6 col-xs-12 invoice-col">
                                        <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_payment->company_id) }}" class="invoice-logo" width="170px"/>
                                    </div>
                                    <div class="col-md-6 col-xs-12 invoice-col text-right">
                                        <span><strong>{{ mb_strtoupper($customer_payment->company->name) }}</strong></span>
                                        <br/>
                                        <span>{{ $data['tax_regimen'] ?? ($customer_payment->taxRegimen->name_sat ?? $customer_payment->company->taxRegimen->name_sat) }}</span>
                                        <br/>
                                        <span>{{ $customer_payment->company->address_1 ?? '' }} {{ $customer_payment->company->address_2 ?? '' }} {{ $customer_payment->company->address_3 ?? '' }} {{ $customer_payment->company->address_4 ?? '' }}</span>
                                        <br/>
                                        <span>{{ $customer_payment->company->city->name ?? '' }}
                                            , {{ ($customer_payment->company->state->name ?? '') }}</span>
                                        <br/>
                                        <span>{{ $customer_payment->company->country->name ?? '' }}{!! ($customer_payment->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_payment->company->postcode : '') !!}</span>
                                        <br/>
                                        <span>{{ mb_strtoupper($customer_payment->company->taxid) }}</span>
                                        <br/>
                                        <span>---</span>
                                        <br/>
                                        <span>{{ $customer_payment->company->phone ?? ' ' }}</span>
                                        <br/>
                                        <span>{{ $customer_payment->company->email ?? ' ' }}</span>
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 20px;">
                                    <div class="col-md-6 col-xs-12 invoice-col">
                                        <h4 class=""
                                            style="color: {{ \App\Helpers\Helper::companyColorPrimary($customer_payment->company_id) }}; font-weight: bold; padding-bottom: 5px; border-bottom: 1px solid #cccccc;">
                                            # {{ $customer_payment->name }}
                                            <span class="pull-right">{!! \App\Helpers\SalesHelper::statusCustomerPaymentHtml($customer_payment->status) !!}</span>
                                        </h4>
                                        <span><strong>@lang('general.text_cfdi_uuid')
                                                : </strong>{{ $customer_payment->customerPaymentCfdi->uuid ?? '' }}
                                                        </span>
                                        <br/>
                                        <span><strong>@lang('base/document_type.entry_cfdi_type_id')
                                                : </strong>{{ $customer_payment->documentType->cfdiType->name_sat ?? '' }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_payment.entry_date')
                                                : </strong>{{ \App\Helpers\Helper::convertSqlToDateTime($customer_payment->date) }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_payment.entry_date_payment')
                                                : </strong>{{ $customer_payment->date_payment ? \App\Helpers\Helper::convertSqlToDateTime($customer_payment->date_payment) : '' }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_payment.entry_amount')
                                                : </strong>{{ money($customer_payment->amount,$customer_payment->currency->code,true) }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_payment.entry_currency_id')
                                                : </strong>{{ $customer_payment->currency->code }}{!! ($customer_payment->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/customer_payment.entry_currency_value').':</strong> '.round($customer_payment->currency_value,4) :'') !!}</span>
                                        <br/>
                                        <span><strong>@lang('general.text_issued_in')
                                                : </strong>{{ $customer_payment->branchOffice->name ?? '' }} {!! ($customer_payment->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . ($cfdi33['LugarExpedicion'] ?? $customer_payment->branchOffice->postcode) : '') !!}</span>
                                        <br/>
                                    </div>
                                    <div class="col-md-6 col-xs-12 invoice-col">
                                        <h4 class=""
                                            style="color: {{ \App\Helpers\Helper::companyColorPrimary($customer_payment->company_id) }}; font-weight: bold; padding-bottom: 5px; border-bottom: 1px solid #cccccc;">{{ mb_strtoupper(__('general.text_customer')) }}</h4>
                                        <span><strong>{{ mb_strtoupper(!empty($cfdi33->Receptor['Nombre']) ? $cfdi33->Receptor['Nombre'] : $customer_payment->customer->name) }}</strong></span>
                                        <br/>
                                        <span>{{ $customer_payment->customer->address_1 ?? '' }} {{ $customer_payment->customer->address_2 ?? '' }} {{ $customer_payment->customer->address_3 ?? '' }} {{ $customer_payment->customer->address_4 ?? '' }}</span>
                                        <br/>
                                        <span>{{ $customer_payment->customer->city->name ?? '' }}
                                            , {{ $customer_payment->customer->state->name ?? '' }}</span>
                                        <br/>
                                        <span>{{ $customer_payment->customer->country->name ?? '' }}{!! ($customer_payment->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_payment->customer->postcode : '') !!}</span>
                                        <br/>
                                        <span>{{ mb_strtoupper($cfdi33->Receptor['Rfc'] ?? $customer_payment->customer->taxid) }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_payment.entry_tax_regimen_customer_id2')
                                            : </strong>{{ $data['tax_regimen_customer'] ?? ($customer_payment->taxRegimenCustomer->name_sat ?? ($customer_payment->customer->taxRegimen->name_sat ?? '')) }}</span>
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- Table row -->
                                <div class="row">
                                    <div class="col-md-12 col-xs-12 table">
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                <tr>
                                                    <th class="text-left">{{ mb_strtoupper(__('sales/customer_invoice.column_line_name')) }}</th>
                                                    <th class="text-center" width="15%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_sat_product_id')) }}</th>
                                                    <th class="text-center" width="14%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_unit_measure_id')) }}</th>
                                                    <th class="text-center" width="7%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_quantity')) }}</th>
                                                    <th class="text-center" width="9%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_price_unit')) }}</th>
                                                    <th class="text-center" width="11%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_amount_untaxed')) }}</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <tr>
                                                    <td>Pago</td>
                                                    <td class="text-center">84111506</td>
                                                    <td class="text-center">ACT</td>
                                                    <td class="text-center">1</td>
                                                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney(0,0) }}</td>
                                                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney(0,0) }}</td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="col-md-12 col-xs-12 table">
                                        <p style="margin-bottom: 2px; margin-top: 15px;"><strong>@lang('sales/customer_payment.text_payment_complement')</strong></p>
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                <tr>
                                                    <th class="text-center">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_uuid')) }}</th>
                                                    <th class="text-center" width="6%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_serie')) }}</th>
                                                    <th class="text-center" width="6%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_folio')) }}</th>
                                                    <th class="text-center" width="6%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_currency')) }}</th>
                                                    <th class="text-center" width="7%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_currency_value2')) }}</th>
                                                    <th class="text-center" width="7%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_payment_method')) }}</th>
                                                    <th class="text-center" width="8%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_number_of_payment')) }}</th>
                                                    <th class="text-right" width="11%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_last_balance')) }}</th>
                                                    <th class="text-right" width="11%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_amount_reconciled2')) }}</th>
                                                    <th class="text-right" width="11%">{{ mb_strtoupper(__('sales/customer_payment.column_reconciled_currenct_balance')) }}</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @if($customer_payment->customerPaymentReconcileds->isNotEmpty())
                                                    @foreach($customer_payment->customerPaymentReconcileds as $result)
                                                        <tr>
                                                            <td class="text-center">{{ $result->uuid_related }}</td>
                                                            <td class="text-center">{{ $result->serie_related }}</td>
                                                            <td class="text-center">{{ $result->folio_related }}</td>
                                                            <td class="text-center">{{ $result->currency_code_related }}</td>
                                                            <td class="text-center">
                                                                @if($customer_payment->currency->code != $result->currency_code_related)
                                                                    {{ \App\Helpers\Helper::numberFormat($customer_payment->currency_value/$result->currency_value,6) }}
                                                                @endif
                                                            </td>
                                                            <td class="text-center">{{ $result->payment_method_code_related }}</td>
                                                            <td class="text-center">{{ $result->number_of_payment }}</td>
                                                            <td class="text-right">{{ money($result->last_balance,$customer_payment->currency->code,true) }}</td>
                                                            <td class="text-right">{{ money($result->amount_reconciled,$customer_payment->currency->code,true) }}</td>
                                                            <td class="text-right">{{ money($result->current_balance,$customer_payment->currency->code,true) }}</td>
                                                        </tr>
                                                    @endforeach
                                                @endif
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- /.row -->
                                <!-- Table row -->
                                <div class="row" style="margin-bottom: 30px;">
                                    <div class="col-md-6 col-xs-12">
                                        <span><strong>@lang('sales/customer_payment.entry_payment_way_id')
                                                : </strong>{{ $customer_payment->paymentWay->name_sat }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_payment.entry_reference')
                                                : </strong>{{ $customer_payment->reference }}</span>
                                        <br/>
                                        @if(!empty($cfdi33))
                                            <span><strong>@lang('general.text_cfdi_certificado'): </strong>
                                                {{ $cfdi33['NoCertificado'] }}</span>
                                            <br/>
                                            <span><strong>@lang('general.text_cfdi_tfd_no_certificado_sat'): </strong>
                                                {{ $cfdi33->complemento->timbreFiscalDigital['NoCertificadoSAT'] }}</span>
                                            <br/>
                                            <span><strong>@lang('general.text_cfdi_tfd_fecha_timbrado'): </strong>
                                                {{ \App\Helpers\Helper::convertSqlToDateTime(str_replace('T',' ',$cfdi33->complemento->timbreFiscalDigital['FechaTimbrado'])) }}</span>
                                            <br/>
                                        @endif
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <strong>@lang('sales/customer_payment.text_ordenante')</strong>
                                        <br/>
                                        <span><strong>@lang('sales/customer_payment.text_RfcEmisorCtaOrd')
                                                : </strong>{{ $customer_payment->customerBankAccount->bank->taxid ?? '' }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_payment.text_NomBancoOrdExt'): </strong>
                                            @if(!empty($customer_payment->customerBankAccount->bank->taxid) && $customer_payment->customerBankAccount->bank->taxid == 'XEXX010101000')
                                                {{ $customer_payment->customerBankAccount->bank->name ?? '' }}
                                            @endif
                                        </span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_payment.text_CtaOrdenante')
                                                : </strong>{{ $customer_payment->customerBankAccount->account_number ?? '' }}</span>
                                        <br/>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <strong>@lang('sales/customer_payment.text_beneficiario')</strong>
                                        <br/>
                                        <span><strong>@lang('sales/customer_payment.text_RfcEmisorCtaOrd')
                                                : </strong>{{ $customer_payment->companyBankAccount->bank->taxid ?? '' }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_payment.text_CtaOrdenante')
                                                : </strong>{{ $customer_payment->companyBankAccount->account_number ?? '' }}</span>
                                        <br/>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 15px;">
                                    <div class="col-md-12 col-xs-12 invoice-col">
                                        @if(!empty($customer_payment->cfdi_relation_id))
                                            <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_payment.tab_relations')
                                                    - {{ $customer_payment->cfdiRelation->name_sat }} </strong></p>
                                            <table cellpadding="0" cellspacing="0" class="table table-secundary" width="100%">
                                                <tr>
                                                    <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                                                        @if($customer_payment->customerPaymentRelations->isNotEmpty())
                                                            @foreach($customer_payment->customerPaymentRelations as $result)
                                                                {{$result->relation->name}}<br/>
                                                            @endforeach
                                                        @endif
                                                    </td>
                                                    <td width="85%" style="vertical-align: middle; padding: 5px;">
                                                        @if($customer_payment->customerPaymentRelations->isNotEmpty())
                                                            @foreach($customer_payment->customerPaymentRelations as $result)
                                                                {{$result->relation->customerPaymentCfdi->uuid}}<br/>
                                                            @endforeach
                                                        @endif
                                                    </td>
                                                </tr>
                                            </table>
                                        @endif
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 15px;">
                                    <div class="col-md-12 col-xs-12 invoice-col">
                                        @if(!empty($customer_payment->comment))
                                            <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_payment.entry_comment')</strong></p>
                                            <table cellpadding="0" cellspacing="0" class="table table-secundary" width="100%">
                                                <tr>
                                                    <td width="100%" style="vertical-align: top; padding: 5px;">
                                                        {{ $customer_payment->comment }}
                                                    </td>
                                                </tr>
                                            </table>
                                        @endif
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 20px;">
                                    <div class="col-md-12 col-xs-12 invoice-col">
                                        @if(!empty($cfdi33))
                                            <table cellpadding="0" cellspacing="0" class="table" width="100%"
                                                   style="margin-top: 5px; table-layout: fixed;">
                                                <tr>
                                                    <td width="23%" class="text-center" style="vertical-align: middle; padding: 5px; word-wrap:break-word;">
                                                        <img src="{{ $data['qr'] }}" width="137px" style="margin: 9px 0;"/>
                                                    </td>
                                                    <td width="77%" style="vertical-align: middle; padding: 5px; word-wrap:break-word;">
                                                        <strong>@lang('general.text_cfdi_tfd_cadena_origen') </strong><br/>
                                                        <small>{{ $data['tfd_cadena_origen'] }}</small>
                                                        <br/>
                                                        <strong>@lang('general.text_cfdi_tfd_sello_cfdi') </strong><br/>
                                                        <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloCFD'] }}</small>
                                                        <br/>
                                                        <strong>@lang('general.text_cfdi_tfd_sello_sat') </strong><br/>
                                                        <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloSAT'] }}</small>
                                                        <br/>
                                                    </td>
                                                </tr>
                                            </table>
                                        @endif
                                    </div>
                                </div>
                                <!-- /.row -->
                            </section>


                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

    </script>
@endsection
