<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_quotation->documentType->name}}-{{$customer_quotation->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 310px;
            margin-bottom: 30px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_quotation->company_id) }}     !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_quotation->company_id) }}     !important;
        }
    </style>
</head>
<body style="background-color: white;">
<section class="header" style="top: -287px;">
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="55%" class="text-left">
                <span class="text-primary">{{ mb_strtoupper($customer_quotation->company->comercial_name) }}</span>
            </td>
            <td width="45%" class="text-right">
                <h1>{{ mb_strtoupper($customer_quotation->documentType->name) }}</h1>
            </td>
        </tr>
        <tr>
            <td width="50%" style="vertical-align: top; padding-top: 10px; position: relative;">
                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_quotation->company_id,$customer_quotation->project_id) }}"
                    class="invoice-logo" />
                @elseif(!empty(setting('branch_office_logo_docs')))
                <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_quotation->company_id,$customer_quotation->branch_office_id) }}"
                    class="invoice-logo" />
                @else
                <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_quotation->company_id) }}"
                    class="invoice-logo" />
                @endif
            </td>
            <td width="50%" class="text-right text-company" style="vertical-align: top; padding-top: 10px; height: 118px;">
                <strong>{{ mb_strtoupper($customer_quotation->company->name) }}</strong>
                @if(!empty($customer_quotation->company->address_1) || !empty($customer_quotation->company->address_2) || !empty($customer_quotation->company->address_3) || !empty($customer_quotation->company->address_4))
                    <br/>
                    {{ $customer_quotation->company->address_1 ?? '' }} {{ $customer_quotation->company->address_2 ?? '' }} {{ $customer_quotation->company->address_3 ?? '' }} {{ $customer_quotation->company->address_4 ?? '' }}
                @endif
                @if(!empty($customer_quotation->company->city->name) || !empty($customer_quotation->company->state->name))
                    <br/>
                    {{ !empty($customer_quotation->company->city->name) ? $customer_quotation->company->city->name . ', ' : '' }}{{ $customer_quotation->company->state->name ?? '' }}
                @endif
                <br/>
                {{ $customer_quotation->company->country->name ?? '' }}{!! ($customer_quotation->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_quotation->company->postcode : '') !!}
                <br/>
                {{ mb_strtoupper($customer_quotation->company->taxid) }}
                <br/>
                ---
                <br/>
                {{ $customer_quotation->company->phone ?? ' ' }}
                <br/>
                {{ $customer_quotation->company->email ?? ' ' }}
            </td>
        </tr>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary"># {{ $customer_quotation->name }}</span>
            </td>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary">{{ mb_strtoupper(__('general.text_customer')) }}</span>
            </td>
        </tr>
        <tr>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <strong>@lang('sales/customer_quotation.entry_date'): </strong>{{ \App\Helpers\Helper::convertSqlToDateTime($customer_quotation->date) }}
                <br/>
                @if(!empty($customer_quotation->expiration_date))
                <strong>@lang('sales/customer_quotation.entry_expiration_date'): </strong>{{ \App\Helpers\Helper::convertSqlToDate($customer_quotation->expiration_date) }}
                <br/>
                @endif
                @if(!empty($customer_quotation->paymentTerm->name))
                <strong>@lang('sales/customer_quotation.entry_payment_term_id'): </strong>{{ $customer_quotation->paymentTerm->name }}
                <br/>
                @endif
                @if(!empty($customer_quotation->cfdiUse->name_sat))
                <strong>@lang('sales/customer_quotation.entry_cfdi_use_id'): </strong>{{ $customer_quotation->cfdiUse->name_sat }}
                <br/>
                @endif
                <strong>@lang('general.text_issued_in'): </strong>{{ $customer_quotation->branchOffice->name ?? '' }} {!! ($customer_quotation->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $customer_quotation->branchOffice->postcode : '') !!}
                <br/>
            </td>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <strong>{{ mb_strtoupper($customer_quotation->customer->name) }}</strong>
                @if(!empty($customer_quotation->customer->address_1) || !empty($customer_quotation->customer->address_2) || !empty($customer_quotation->customer->address_3) || !empty($customer_quotation->customer->address_4))
                    <br/>
                    {{ $customer_quotation->customer->address_1 ?? '' }} {{ $customer_quotation->customer->address_2 ?? '' }} {{ $customer_quotation->customer->address_3 ?? '' }} {{ $customer_quotation->customer->address_4 ?? '' }}
                @endif
                @if(!empty($customer_quotation->customer->city->name) || !empty($customer_quotation->customer->state->name))
                    <br/>
                    {{ !empty($customer_quotation->customer->city->name) ? $customer_quotation->customer->city->name . ', ' : '' }}{{ $customer_quotation->customer->state->name ?? '' }}
                @endif
                <br/>
                {{ $customer_quotation->customer->country->name ?? '' }}{!! ($customer_quotation->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_quotation->customer->postcode : '') !!}
                <br/>
                {{ mb_strtoupper($customer_quotation->customer->taxid) }}
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">

            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_quotation->status == \App\Models\Sales\CustomerQuotation::CANCEL)
    <section class="watermark" style="bottom: 450px !important;">
        <span>@lang('general.text_canceled')</span>
    </section>
@endif
<section>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
        <thead>
        <tr>
            <th class="text-left">{{ mb_strtoupper(__('sales/customer_quotation.column_line_name')) }}</th>
            <th width="15%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_unit_measure_id')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_quantity')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_price_unit')) }}</th>
            <th width="7%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_discount')) }}</th>
            <th width="11%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_amount_untaxed')) }}</th>
        </tr>
        </thead>
        <tbody>
            @foreach($customer_quotation->customerActiveQuotationLines as $result)
                <tr>
                    <td>{!! nl2br($result->name) !!}</td>
                    <td class="text-center">{{ $result->unitMeasure->name_sat ?? '' }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place ?? 1) }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_quotation->company_id)) }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                    <td class="text-right">{{ money($result->amount_untaxed,$customer_quotation->currency->code,true) }}</td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
        <tr>
            <td colspan="3" class="text-center" style="vertical-align: bottom;">
                <span style="line-height: 16px;">
                    ***({{\App\Helpers\Helper::numberToWordCurrency($customer_quotation->amount_total,$customer_quotation->currency->code,$customer_quotation->currency->decimal_place)}})***
                </span>
            </td>
            <td colspan="2" class="text-right" style="vertical-align: top; padding-right: 4px;">
                <strong>@lang('general.text_amount_untaxed')</strong><br/>
                @if($customer_quotation->customerQuotationTaxes->isNotEmpty())
                    @foreach($customer_quotation->customerQuotationTaxes as $result)
                        <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
            </td>
            <td class="text-right">
                {{ money($customer_quotation->amount_untaxed,$customer_quotation->currency->code,true) }}<br/>
                @if($customer_quotation->customerQuotationTaxes->isNotEmpty())
                    @foreach($customer_quotation->customerQuotationTaxes as $result)
                        <span style="line-height: 16px;">{{money(abs($result->amount_tax),$customer_quotation->currency->code,true)}}</span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ money($customer_quotation->amount_total,$customer_quotation->currency->code,true) }}</strong></span>
            </td>
        </tr>
        </tfoot>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="100%" style="vertical-align: top; padding: 5px;">
                @if(!empty($customer_quotation->paymentWay->name_sat))
                <strong>@lang('sales/customer_quotation.entry_payment_way_id'): </strong>{{ $customer_quotation->paymentWay->name_sat }}
                <br/>
                @endif
                @if(!empty($customer_quotation->paymentMethod->name_sat))
                <strong>@lang('sales/customer_quotation.entry_payment_method_id'): </strong>{{ $customer_quotation->paymentMethod->name_sat }}
                <br/>
                @endif
                <strong>@lang('sales/customer_quotation.entry_currency_id'): </strong>{{ $customer_quotation->currency->code }}{!! ($customer_quotation->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/customer_quotation.entry_currency_value').':</strong> '.round($customer_quotation->currency_value,4) :'') !!}
                <br/>
            </td>
        </tr>
    </table>
    </div>
    @if(!empty($customer_quotation->comment))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_quotation.entry_comment')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;">
                    {!! nl2br($customer_quotation->comment) !!}
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_quotation->terms_of_sale))
        <div>
            <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_quotation.entry_terms_of_sale')</strong></p>
            <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
                <tr>
                    <td width="100%" style="vertical-align: top; padding: 5px;">
                        {!! $customer_quotation->terms_of_sale !!}
                    </td>
                </tr>
            </table>
        </div>
    @endif
</section>
</body>
</html>
