<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_quotation->documentType->name}}-{{$customer_quotation->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 285px;
            margin-bottom: 27px;
            margin-left: 23px;
            margin-right: 23px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_quotation->company_id) }}     !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_quotation->company_id) }}     !important;
        }
        .cell-primary {
            border: 1px solid {{ \App\Helpers\Helper::companyColorPrimary($customer_quotation->company_id) }}     !important;
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_quotation->company_id) }}     !important;
            color: #ffffff;
            font-weight: bold;
            padding: 5px 2px;
            text-align: center !important;
            vertical-align: middle !important;
            text-transform: uppercase;
            font-size: 8pt;
        }
        .cell-primary-border-line {
            border: 1px solid {{ \App\Helpers\Helper::companyColorPrimary($customer_quotation->company_id) }}     !important;
            border-radius: 0 0 3px 3px;
            padding: 5px 1px;
        }
    </style>
</head>
<body style="background-color: white;">
<section class="header" style="top: -257px;">
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
        <tr>
            <td width="25%" class="" style="vertical-align: top; ">
                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_quotation->company_id,$customer_quotation->project_id) }}" class="invoice-logo" style="max-width: 160px !important;"/>
                @elseif(!empty(setting('branch_office_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_quotation->company_id,$customer_quotation->branch_office_id) }}" class="invoice-logo" style="max-width: 160px !important;"/>
                @else
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_quotation->company_id) }}" class="invoice-logo" style="max-width: 160px !important;"/>
                @endif
            </td>
            <td width="25%" style="vertical-align: top; text-transform: uppercase;">
                @if(!empty($customer_quotation->company->comercial_name))
                <span class="text-primary" style="font-size: 8pt;">{{ mb_strtoupper($customer_quotation->company->comercial_name) }}</span>
                <br/>
                <br/>
                @endif
                <strong>{{ mb_strtoupper($customer_quotation->company->name) }}</strong>
                @if(!empty($customer_quotation->company->address_1) || !empty($customer_quotation->company->address_2) || !empty($customer_quotation->company->address_3) || !empty($customer_quotation->company->address_4))
                    <br/>
                    {{ $customer_quotation->company->address_1 ?? '' }} {{ $customer_quotation->company->address_2 ?? '' }} {{ $customer_quotation->company->address_3 ?? '' }} {{ $customer_quotation->company->address_4 ?? '' }}
                @endif
                @if(!empty($customer_quotation->company->city->name) || !empty($customer_quotation->company->state->name))
                    <br/>
                    {{ !empty($customer_quotation->company->city->name) ? $customer_quotation->company->city->name . ', ' : '' }}{{ $customer_quotation->company->state->name ?? '' }}
                @endif
                <br/>
                {{ $customer_quotation->company->country->name ?? '' }}{!! ($customer_quotation->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_quotation->company->postcode : '') !!}
                <br/>
                {{ mb_strtoupper($customer_quotation->company->taxid) }}
                <br/>
                ---
                <br/>
                {{ $customer_quotation->company->phone ?? ' ' }}
                <br/>
                <span style="text-transform: lowercase;">{{ $customer_quotation->company->email ?? ' ' }}</span>
            </td>
            <td width="22%" style="vertical-align: top; text-transform: uppercase;">
                <strong>@lang('general.text_issued_in')</strong>
                <br/>
                @if(!empty($customer_quotation->branchOffice->address_1) || !empty($customer_quotation->branchOffice->address_2))
                    <br/>
                    {{ $customer_quotation->branchOffice->address_1 ?? '' }} {{ $customer_quotation->branchOffice->address_2 ?? '' }}
                @endif
                @if(!empty($customer_quotation->branchOffice->address_3) || !empty($customer_quotation->branchOffice->address_4))
                    <br/>
                    {{ $customer_quotation->branchOffice->address_3 ?? '' }} {{ $customer_quotation->branchOffice->address_4 ?? '' }}
                @endif
                @if(!empty($customer_quotation->branchOffice->city->name) || !empty($customer_quotation->branchOffice->state->name))
                    <br/>
                    {{ $customer_quotation->branchOffice->city->name ?? '' }}, {{ $customer_quotation->branchOffice->state->name ?? '' }}
                @endif
                <br/>
                {{ $customer_quotation->branchOffice->country->name ?? '' }}{!! ($customer_quotation->branchOffice->postcode ? '&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ': ' . $customer_quotation->branchOffice->postcode : '') !!}
            </td>
            <td width="28%" class="text-right" style="vertical-align: top; height: 140px;">
                <div>
                <table cellpadding="0" cellspacing="1" class="" width="100%">
                    <tr>
                        <td width="40%" class="cell-primary" style="">@lang('sales/customer_quotation.entry_date')</td>
                        <td class="cell-primary" style="">{{ mb_strtoupper($customer_quotation->documentType->name) }}</td>
                    </tr>
                    <tr>
                        <td class="cell-primary-border-line text-center" style="">{!! str_replace(' ','<br>',\App\Helpers\Helper::convertSqlToDateTime($customer_quotation->date)) !!}</td>
                        <td class="cell-primary-border-line text-center" style="">{{ $customer_quotation->name }}</td>
                    </tr>
                    <tr>
                        <td width="" class="" colspan="2" style="">&nbsp;</td>
                    </tr>
                </table>
                </div>
            </td>
        </tr>
    </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 10px;">
            <tr>
                <td width="" class="cell-primary" colspan="2" style="">@lang('general.text_customer')</td>
            </tr>
            <tr>
                <td width="50%" class="cell-primary-border-line text-left" style="vertical-align: top; height: 50px; padding: 5px;">
                    <strong>{{ mb_strtoupper($customer_quotation->customer->name) }}</strong>
                    <br>
                    {{ mb_strtoupper($customer_quotation->customer->taxid) }}
                </td>
                <td class="cell-primary-border-line text-left" style="vertical-align: top; height: 50px; padding: 5px;">
                    @if(!empty($customer_quotation->customer->address_1) || !empty($customer_quotation->customer->address_2) || !empty($customer_quotation->customer->address_3) || !empty($customer_quotation->customer->address_4))
                        {{ $customer_quotation->customer->address_1 ?? '' }} {{ $customer_quotation->customer->address_2 ?? '' }} {{ $customer_quotation->customer->address_3 ?? '' }} {{ $customer_quotation->customer->address_4 ?? '' }}
                        <br/>
                    @endif
                    @if(!empty($customer_quotation->customer->city->name) || !empty($customer_quotation->customer->state->name))
                        {{ !empty($customer_quotation->customer->city->name) ? $customer_quotation->customer->city->name . ', ' : '' }}{{ $customer_quotation->customer->state->name ?? '' }}
                        <br/>
                    @endif
                    {{ $customer_quotation->customer->country->name ?? '' }}{!! ($customer_quotation->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_quotation->customer->postcode : '') !!}

                </td>
            </tr>
        </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_quotation->status == \App\Models\Sales\CustomerQuotation::CANCEL)
    <section class="watermark" style="bottom: 450px !important;">
        <span>@lang('general.text_canceled')</span>
    </section>
@endif
<section>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
        <thead>
        <tr>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_quantity')) }}</th>
            <th class="text-left">{{ mb_strtoupper(__('sales/customer_quotation.column_line_name')) }}</th>
            <th width="15%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_unit_measure_id')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_price_unit')) }}</th>
            <th width="6%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_discount')) }}</th>
            <th width="11%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_amount_untaxed')) }}</th>
        </tr>
        </thead>
        <tbody>
            @foreach($customer_quotation->customerActiveQuotationLines as $result)
                <tr>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place ?? 1) }}</td>
                    <td>{!! nl2br($result->name) !!}</td>
                    <td class="text-center">{{ $result->unitMeasure->name_sat ?? '' }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_quotation->company_id)) }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                    <td class="text-right">{{ money($result->amount_untaxed,$customer_quotation->currency->code,true) }}</td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
        <tr>
            <td colspan="6" class="text-left" style="vertical-align: top; height: 50px;">
                {!! nl2br($customer_quotation->comment) !!}
            </td>
        </tr>
        <tr>
            <td colspan="3" class="text-left" style="vertical-align: top;">
                <span style="line-height: 16px;">
                    ***({{\App\Helpers\Helper::numberToWordCurrency($customer_quotation->amount_total,$customer_quotation->currency->code,$customer_quotation->currency->decimal_place)}})***
                </span>
            </td>
            <td colspan="2" class="text-right" style="vertical-align: top; padding-right: 4px;">
                <strong>@lang('general.text_amount_untaxed')</strong><br/>
                @if($customer_quotation->customerQuotationTaxes->isNotEmpty())
                    @foreach($customer_quotation->customerQuotationTaxes as $result)
                        <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
            </td>
            <td class="text-right">
                {{ money($customer_quotation->amount_untaxed,$customer_quotation->currency->code,true) }}<br/>
                @if($customer_quotation->customerQuotationTaxes->isNotEmpty())
                    @foreach($customer_quotation->customerQuotationTaxes as $result)
                        <span style="line-height: 16px;">{{money(abs($result->amount_tax),$customer_quotation->currency->code,true)}}</span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ money($customer_quotation->amount_total,$customer_quotation->currency->code,true) }}</strong></span>
            </td>
        </tr>
        </tfoot>
    </table>
    </div>
    @if(!empty($customer_quotation->terms_of_sale))
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
            <tr>
                <td width="" class="cell-primary" style="">{{ strtoupper(__('sales/customer_quotation.entry_terms_of_sale')) }}</td>
            </tr>
            <tr>
                <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 45px; padding: 5px;  word-wrap:break-word;">
                    {!! $customer_quotation->terms_of_sale !!}
                </td>
            </tr>
        </table>
    </div>
    @endif
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
            <tr>
                <td width="100%" class="cell-primary" style=""></td>
            </tr>
            <tr>
                <td width="100%" class="cell-primary-border-line text-left" style="vertical-align: top; padding: 5px;  word-wrap:break-word;">
                    <table cellpadding="0" cellspacing="0" class="" width="100%" style="table-layout: fixed;">
                        <tr>
                            <td width="20%" class="" style="vertical-align: top; padding-top: 12px;">
                                @if(!empty($customer_quotation->expiration_date))
                                @lang('sales/customer_quotation.entry_expiration_date'):<br>
                                @endif
                                @if(!empty($customer_quotation->paymentWay->name_sat))
                                @lang('sales/customer_quotation.entry_payment_way_id'):<br>
                                @endif
                                @if(!empty($customer_quotation->paymentMethod->name_sat))
                                @lang('sales/customer_quotation.entry_payment_method_id'):<br>
                                @endif
                                @if(!empty($customer_quotation->paymentTerm->name))
                                @lang('sales/customer_quotation.entry_payment_term_id'):<br>
                                @endif
                                @if(!empty($customer_quotation->cfdiUse->name_sat))
                                @lang('sales/customer_quotation.entry_cfdi_use_id'):<br>
                                @endif
                            </td>
                            <td width="" class="" style="vertical-align: top; padding-top: 12px;">
                                @if(!empty($customer_quotation->expiration_date))
                                {{ \App\Helpers\Helper::convertSqlToDate($customer_quotation->expiration_date) }}<br>
                                @endif
                                @if(!empty($customer_quotation->paymentWay->name_sat))
                                {{ $customer_quotation->paymentWay->name_sat }}<br>
                                @endif
                                @if(!empty($customer_quotation->paymentMethod->name_sat))
                                {{ $customer_quotation->paymentMethod->name_sat }}<br>
                                @endif
                                @if(!empty($customer_quotation->paymentTerm->name))
                                {{ $customer_quotation->paymentTerm->name }}<br>
                                @endif
                                @if(!empty($customer_quotation->cfdiUse->name_sat))
                                {{ $customer_quotation->cfdiUse->name_sat }}<br>
                                @endif
                            </td>
                            <td width="7%" class="" style="vertical-align: top; padding-top: 12px;">
                                @lang('sales/customer_quotation.entry_currency_id'):<br>
                                @lang('sales/customer_quotation.entry_currency_value'):<br>
                            </td>
                            <td width="10%" class="text-left" style="vertical-align: top; padding-top: 12px;">
                                {{ $customer_quotation->currency->code }}<br>
                                {!! ($customer_quotation->currency->code!='MXN' ? round($customer_quotation->currency_value,4) :'') !!}<br>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>
</section>
</body>
</html>
