<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_quotation->documentType->name}}-{{$customer_quotation->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 155px;
            margin-bottom: 27px;
            margin-left: 23px;
            margin-right: 23px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_quotation->company_id) }}     !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_quotation->company_id) }}     !important;
        }
        .cell-primary {
            border: 1px solid {{ \App\Helpers\Helper::companyColorPrimary($customer_quotation->company_id) }}     !important;
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_quotation->company_id) }}     !important;
            color: #ffffff;
            font-weight: bold;
            padding: 5px 2px;
            text-align: center !important;
            vertical-align: middle !important;
            text-transform: uppercase;
            font-size: 8pt;
        }
        .cell-primary-border-line {
            border: 1px solid #dddddd !important;
            border-radius: 0 0 3px 3px;
            padding: 5px 1px;
        }
    </style>
</head>
<body style="background-color: white; margin-bottom: 15px;" >
<section class="header" style="top: -127px;">
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
            <tr>
                <td width="27%" style="vertical-align: top; border-right: 1px solid #333333;">
                    <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
                        <tr>
                            <td width="100%" class="text-center" style="vertical-align: top; height: 140px;">
                                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_quotation->company_id,$customer_quotation->project_id) }}" class="invoice-logo" style="max-width: 160px !important;"/>
                                @elseif(!empty(setting('branch_office_logo_docs')))
                                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_quotation->company_id,$customer_quotation->branch_office_id) }}" class="invoice-logo" style="max-width: 160px !important;"/>
                                @else
                                    <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_quotation->company_id) }}" class="invoice-logo" style="max-width: 160px !important;"/>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-center" style="vertical-align: top; ">
                                <h2>{{ mb_strtoupper($customer_quotation->documentType->name) }}</h2>
                                <br/>
                                <span class="text-primary" style="font-size: 8pt;">{{ mb_strtoupper($customer_quotation->company->comercial_name) }}</span>
                                <br/>
                                <br/>
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-center" style="vertical-align: top; height: 120px; ">
                                <strong>@lang('base/company.text_transmitter'):</strong><br/>
                                {{ mb_strtoupper($customer_quotation->company->name) }}
                                @if(!empty($customer_quotation->company->address_1) || !empty($customer_quotation->company->address_2) || !empty($customer_quotation->company->address_3) || !empty($customer_quotation->company->address_4))
                                    <br/>
                                    {{ $customer_quotation->company->address_1 ?? '' }} {{ $customer_quotation->company->address_2 ?? '' }} {{ $customer_quotation->company->address_3 ?? '' }} {{ $customer_quotation->company->address_4 ?? '' }}
                                @endif
                                @if(!empty($customer_quotation->company->city->name) || !empty($customer_quotation->company->state->name))
                                    <br/>
                                    {{ !empty($customer_quotation->company->city->name) ? $customer_quotation->company->city->name . ', ' : '' }}{{ $customer_quotation->company->state->name ?? '' }}
                                @endif
                                <br/>
                                {{ $customer_quotation->company->country->name ?? '' }}{!! ($customer_quotation->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_quotation->company->postcode : '') !!}
                                <br/>
                                {{ mb_strtoupper($customer_quotation->company->taxid) }}
                                <br/>
                                ---
                                <br/>
                                {{ $customer_quotation->company->phone ?? ' ' }}
                                <br/>
                                <span style="text-transform: lowercase;">{{ $customer_quotation->company->email ?? ' ' }}</span>
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-center" style="vertical-align: top; ">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-center" style="vertical-align: top; padding-top: 10px; height: 120px; ">
                                <strong>@lang('general.text_issued_in'):</strong>
                                @if(!empty($customer_quotation->branchOffice->address_1) || !empty($customer_quotation->branchOffice->address_2))
                                    <br/>
                                    {{ $customer_quotation->branchOffice->address_1 ?? '' }} {{ $customer_quotation->branchOffice->address_2 ?? '' }}
                                @endif
                                @if(!empty($customer_quotation->branchOffice->address_3) || !empty($customer_quotation->branchOffice->address_4))
                                    <br/>
                                    {{ $customer_quotation->branchOffice->address_3 ?? '' }} {{ $customer_quotation->branchOffice->address_4 ?? '' }}
                                @endif
                                @if(!empty($customer_quotation->branchOffice->city->name) || !empty($customer_quotation->branchOffice->state->name))
                                    <br/>
                                    {{ $customer_quotation->branchOffice->city->name ?? '' }}, {{ $customer_quotation->branchOffice->state->name ?? '' }}
                                @endif
                                <br/>
                                {{ $customer_quotation->branchOffice->country->name ?? '' }}{!! ($customer_quotation->branchOffice->postcode ? '&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ': ' . $customer_quotation->branchOffice->postcode : '') !!}
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-left" style="vertical-align: top; padding-top: 3px; height: 30px;">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td width="100%" class="text-center" style="vertical-align: top; padding-top: 3px; ">
                                <strong>@lang('sales/customer_quotation.entry_date'):</strong><br/>
                                {{ str_replace(' ',' ',\App\Helpers\Helper::convertSqlToDateTime($customer_quotation->date)) }}
                            </td>
                        </tr>
                        @if(!empty($customer_quotation->expiration_date))
                        <tr>
                            <td width="100%" class="text-center" style="vertical-align: top; padding-top: 3px; ">
                                <strong>@lang('sales/customer_quotation.entry_expiration_date'):</strong><br/>
                                {{ \App\Helpers\Helper::convertSqlToDate($customer_quotation->expiration_date) }}
                            </td>
                        </tr>
                        @endif
                        <tr>
                            <td width="100%" class="text-left" style="vertical-align: top; padding-top: 3px; height: 400px;">
                                &nbsp;
                            </td>
                        </tr>
                    </table>
                </td>
                <td width="73%" style="vertical-align: top; padding-left: 10px; padding-right: 10px;">
                    <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
                        <tr>
                            <td width="50%" class="text-left" style="vertical-align: top; padding-bottom: 7px; padding-top: 13px; border-bottom: 1px solid #333333;">
                                <strong>{{ mb_strtoupper($customer_quotation->customer->name) }}</strong>
                                <br>
                                {{ mb_strtoupper($customer_quotation->customer->taxid) }}
                                <br>
                                @if(!empty($customer_quotation->customer->address_1) || !empty($customer_quotation->customer->address_2) || !empty($customer_quotation->customer->address_3) || !empty($customer_quotation->customer->address_4))
                                    {{ $customer_quotation->customer->address_1 ?? '' }} {{ $customer_quotation->customer->address_2 ?? '' }} {{ $customer_quotation->customer->address_3 ?? '' }} {{ $customer_quotation->customer->address_4 ?? '' }}
                                    <br/>
                                @endif
                                @if(!empty($customer_quotation->customer->city->name) || !empty($customer_quotation->customer->state->name))
                                    {{ !empty($customer_quotation->customer->city->name) ? $customer_quotation->customer->city->name . ', ' : '' }}{{ $customer_quotation->customer->state->name ?? '' }}
                                    <br/>
                                @endif
                                {{ $customer_quotation->customer->country->name ?? '' }}{!! ($customer_quotation->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_quotation->customer->postcode : '') !!}
                                <br/>
                                @if(!empty($customer_quotation->cfdiUse->name_sat))
                                @lang('sales/customer_quotation.entry_cfdi_use_id'): {{ $customer_quotation->cfdiUse->name_sat }}
                                @endif
                            </td>
                            <td width="50%" class="text-left" style="vertical-align: top; padding-left: 5px; padding-bottom: 7px; padding-top: 13px; border-bottom: 1px solid #333333;  border-left: 1px solid #333333; height: 85px;">
                                <table cellpadding="0" cellspacing="0" class="" width="100%">
                                    <tr>
                                        <td width="45%">@lang('sales/customer_quotation.entry_name')</td>
                                        <td width="55%">{{ $customer_quotation->name }}</td>
                                    </tr>
                                    @if(!empty($customer_quotation->paymentWay->name_sat))
                                    <tr>
                                        <td>@lang('sales/customer_quotation.entry_payment_way_id')</td>
                                        <td>{{ $customer_quotation->paymentWay->name_sat }}</td>
                                    </tr>
                                    @endif
                                    <tr>
                                        <td>@lang('sales/customer_quotation.entry_currency_id')</td>
                                        <td>
                                            {{ $customer_quotation->currency->code }}
                                            @if($customer_quotation->currency->code!='MXN')
                                                {{ '&nbsp;&nbsp;&nbsp;' . __('sales/customer_quotation.entry_currency_value') . ': '. round($customer_quotation->currency_value,4)}}
                                            @endif
                                        </td>
                                    </tr>
                                    @if(!empty($customer_quotation->paymentMethod->name_sat))
                                    <tr>
                                        <td>@lang('sales/customer_quotation.entry_payment_method_id')</td>
                                        <td>{{ $customer_quotation->paymentMethod->name_sat }}</td>
                                    </tr>
                                    @endif
                                    @if(!empty($customer_quotation->paymentTerm->name))
                                    <tr>
                                        <td>@lang('sales/customer_quotation.entry_payment_term_id')</td>
                                        <td>{{ $customer_quotation->paymentTerm->name }}</td>
                                    </tr>
                                    @endif
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_quotation->status == \App\Models\Sales\CustomerQuotation::CANCEL)
    <section class="watermark" style="bottom: 450px !important;">
        <span>@lang('general.text_canceled')</span>
    </section>
@endif
<section>
    <div style="padding-left: 28%;">
        <div>
            <table cellpadding="0" cellspacing="0" class="table-items" style="width: 98%;">
                <thead>
                <tr>
                    <th width="7%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_quantity')) }}</th>
                    <th class="text-left">{{ mb_strtoupper(__('sales/customer_quotation.column_line_name')) }}</th>
                    <th width="14%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_unit_measure_id')) }}</th>
                    <th width="10%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_price_unit')) }}</th>
                    <th width="7%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_discount')) }}</th>
                    <th width="11%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_amount_untaxed')) }}</th>
                </tr>
                </thead>
                <tbody>
                    @foreach($customer_quotation->customerActiveQuotationLines as $result)
                        <tr>
                            <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place ?? 1) }}</td>
                            <td>{!! nl2br($result->name) !!}</td>
                            <td class="text-center">{{ $result->unitMeasure->name_sat ?? '' }}</td>
                            <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_quotation->company_id)) }}</td>
                            <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                            <td class="text-right">{{ money($result->amount_untaxed,$customer_quotation->currency->code,true) }}</td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                <tr>
                    <td colspan="3" class="text-left" style="vertical-align: top;">
                    <span style="line-height: 16px;">
                        ***({{\App\Helpers\Helper::numberToWordCurrency($customer_quotation->amount_total,$customer_quotation->currency->code,$customer_quotation->currency->decimal_place)}})***
                    </span>
                    </td>
                    <td colspan="2" class="text-right" style="vertical-align: top; padding-right: 4px;">
                        <strong>@lang('general.text_amount_untaxed')</strong><br/>
                        @if($customer_quotation->customerQuotationTaxes->isNotEmpty())
                            @foreach($customer_quotation->customerQuotationTaxes as $result)
                                <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                            @endforeach
                        @endif
                        <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
                    </td>
                    <td class="text-right">
                        {{ money($customer_quotation->amount_untaxed,$customer_quotation->currency->code,true) }}<br/>
                        @if($customer_quotation->customerQuotationTaxes->isNotEmpty())
                            @foreach($customer_quotation->customerQuotationTaxes as $result)
                                <span style="line-height: 16px;">{{money(abs($result->amount_tax),$customer_quotation->currency->code,true)}}</span><br/>
                            @endforeach
                        @endif
                        <span style="line-height: 16px;"><strong>{{ money($customer_quotation->amount_total,$customer_quotation->currency->code,true) }}</strong></span>
                    </td>
                </tr>
                </tfoot>
            </table>
        </div>
        @if(!empty($customer_quotation->comment))
            <div>
                <table cellpadding="0" cellspacing="0" class="" style="margin-top: 5px; table-layout: fixed; width: 98%;">
                    <tr>
                        <td width="" class="cell-primary" style=""><small>@lang('sales/customer_quotation.entry_comment')</small></td>
                    </tr>
                    <tr>
                        <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 45px; padding: 5px;  word-wrap:break-word;">
                            <small>{!! $customer_quotation->comment !!}</small>
                        </td>
                    </tr>
                </table>
            </div>
        @endif
        @if(!empty($customer_quotation->terms_of_sale))
            <div>
                <table cellpadding="0" cellspacing="0" class="" style="margin-top: 5px; table-layout: fixed; width: 98%;">
                    <tr>
                        <td width="" class="cell-primary" style=""><small>@lang('sales/customer_quotation.entry_terms_of_sale')</small></td>
                    </tr>
                    <tr>
                        <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 45px; padding: 5px;  word-wrap:break-word;">
                            <small>{!! $customer_quotation->terms_of_sale !!}</small>
                        </td>
                    </tr>
                </table>
            </div>
        @endif
    </div>
</section>
</body>
</html>
