@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('sales/customer_quotation.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('sales/customer_quotation.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('customer-quotations.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>{{ $customer_quotation->documentType->name }}</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">


                            <section class="content invoice">
                                <!-- title row -->
                                <div class="row">
                                    <div class="col-xs-12 invoice-header">
                                        <h1></h1>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 20px;">
                                    <div class="col-md-6 col-xs-12 invoice-col">
                                            <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_quotation->company_id) }}" class="invoice-logo" width="170px"/>
                                    </div>
                                    <div class="col-md-6 col-xs-12 invoice-col text-right">
                                        <span><strong>{{ mb_strtoupper($customer_quotation->company->name) }}</strong></span>
                                        <br/>
                                        <span>{{ $customer_quotation->company->taxRegimen->name_sat }}</span>
                                        <br/>
                                        <span>{{ $customer_quotation->company->address_1 ?? '' }} {{ $customer_quotation->company->address_2 ?? '' }} {{ $customer_quotation->company->address_3 ?? '' }} {{ $customer_quotation->company->address_4 ?? '' }}</span>
                                        <br/>
                                        <span>{{ $customer_quotation->company->city->name ?? '' }}
                                            , {{ ($customer_quotation->company->state->name ?? '') }}</span>
                                        <br/>
                                        <span>{{ $customer_quotation->company->country->name ?? '' }}{!! ($customer_quotation->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_quotation->company->postcode : '') !!}</span>
                                        <br/>
                                        <span>{{ mb_strtoupper($customer_quotation->company->taxid) }}</span>
                                        <br/>
                                        <span>---</span>
                                        <br/>
                                        <span>{{ $customer_quotation->company->phone ?? ' ' }}</span>
                                        <br/>
                                        <span>{{ $customer_quotation->company->email ?? ' ' }}</span>
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 20px;">
                                    <div class="col-md-6 col-xs-12 invoice-col">
                                        <h4 class=""
                                            style="color: {{ \App\Helpers\Helper::companyColorPrimary($customer_quotation->company_id) }}; font-weight: bold; padding-bottom: 5px; border-bottom: 1px solid #cccccc;">
                                            # {{ $customer_quotation->name }}
                                            <span class="pull-right">{!! \App\Helpers\SalesHelper::statusCustomerQuotationHtml($customer_quotation->status) !!}</span>
                                        </h4>
                                        <span><strong>@lang('base/document_type.entry_cfdi_type_id')
                                                : </strong>{{ $customer_quotation->documentType->cfdiType->name_sat ?? '' }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_quotation.entry_date')
                                                : </strong>{{ \App\Helpers\Helper::convertSqlToDateTime($customer_quotation->date) }}</span>
                                        <br/>
                                        @if(!empty($customer_quotation->expiration_date))
                                        <span><strong>@lang('sales/customer_quotation.entry_expiration_date')
                                                : </strong>{{ \App\Helpers\Helper::convertSqlToDate($customer_quotation->expiration_date) }}</span>
                                        <br/>
                                        @endif
                                        @if(!empty($customer_quotation->paymentTerm->name))
                                        <span><strong>@lang('sales/customer_quotation.entry_payment_term_id')
                                                : </strong>{{ $customer_quotation->paymentTerm->name }}</span>
                                        <br/>
                                        @endif
                                        @if(!empty($customer_quotation->cfdiUse->name_sat))
                                        <span><strong>@lang('sales/customer_quotation.entry_cfdi_use_id')
                                                : </strong>{{ $customer_quotation->cfdiUse->name_sat }}</span>
                                        <br/>
                                        @endif
                                        <span><strong>@lang('general.text_issued_in')
                                                : </strong>{{ $customer_quotation->branchOffice->name ?? '' }} {!! ($customer_quotation->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $customer_quotation->branchOffice->postcode : '') !!}</span>
                                        <br/>
                                    </div>
                                    <div class="col-md-6 col-xs-12 invoice-col">
                                        <h4 class=""
                                            style="color: {{ \App\Helpers\Helper::companyColorPrimary($customer_quotation->company_id) }}; font-weight: bold; padding-bottom: 5px; border-bottom: 1px solid #cccccc;">{{ mb_strtoupper(__('general.text_customer')) }}</h4>
                                        <span><strong>{{ mb_strtoupper($customer_quotation->customer->name) }}</strong></span>
                                        <br/>
                                        <span>{{ $customer_quotation->customer->address_1 ?? '' }} {{ $customer_quotation->customer->address_2 ?? '' }} {{ $customer_quotation->customer->address_3 ?? '' }} {{ $customer_quotation->customer->address_4 ?? '' }}</span>
                                        <br/>
                                        <span>{{ $customer_quotation->customer->city->name ?? '' }}
                                            , {{ $customer_quotation->customer->state->name ?? '' }}</span>
                                        <br/>
                                        <span>{{ $customer_quotation->customer->country->name ?? '' }}{!! ($customer_quotation->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_quotation->customer->postcode : '') !!}</span>
                                        <br/>
                                        <span>{{ mb_strtoupper($customer_quotation->customer->taxid) }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_quotation.entry_tax_regimen_customer_id2')
                                            : </strong>{{ $customer_quotation->taxRegimenCustomer->name_sat ?? ($customer_quotation->customer->taxRegimen->name_sat ?? '') }}</span>
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- Table row -->
                                <div class="row">
                                    <div class="col-md-12 col-xs-12 table">
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                <tr>
                                                    <th class="text-left">{{ mb_strtoupper(__('sales/customer_quotation.column_line_name')) }}</th>
                                                    <th class="text-center"
                                                        width="9%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_sat_product_id')) }}</th>
                                                    <th class="text-center"
                                                        width="14%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_unit_measure_id')) }}</th>
                                                    <th class="text-center"
                                                        width="7%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_quantity')) }}</th>
                                                    <th class="text-center"
                                                        width="9%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_price_unit')) }}</th>
                                                    <th class="text-center"
                                                        width="6%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_discount')) }}</th>
                                                    <th class="text-right"
                                                        width="11%">{{ mb_strtoupper(__('sales/customer_quotation.column_line_amount_untaxed')) }}</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @foreach($customer_quotation->customerActiveQuotationLines as $result)
                                                    <tr>
                                                        <td>{{ $result->name }}</td>
                                                        <td class="text-center">{{ $result->satProduct->code ?? '' }}</td>
                                                        <td class="text-center">{{ $result->unitMeasure->name_sat ?? '' }}</td>
                                                        <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place ?? 1) }}</td>
                                                        <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_quotation->company_id)) }}</td>
                                                        <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                                                        <td class="text-right">{{ money($result->amount_untaxed,$customer_quotation->currency->code,true) }}</td>
                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- /.row -->
                                <!-- Table row -->
                                <div class="row" style="margin-bottom: 30px;">
                                    <div class="col-md-6 col-xs-12">
                                        @if(!empty($customer_quotation->paymentWay->name_sat))
                                        <span><strong>@lang('sales/customer_quotation.entry_payment_way_id')
                                                : </strong>{{ $customer_quotation->paymentWay->name_sat }}</span>
                                        <br/>
                                        @endif
                                        @if(!empty($customer_quotation->paymentMethod->name_sat))
                                        <span><strong>@lang('sales/customer_quotation.entry_payment_method_id')
                                                : </strong>{{ $customer_quotation->paymentMethod->name_sat }}</span>
                                        <br/>
                                        @endif
                                        <span><strong>@lang('sales/customer_quotation.entry_currency_id')
                                                : </strong>{{ $customer_quotation->currency->code }}{!! ($customer_quotation->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/customer_quotation.entry_currency_value').':</strong> '.round($customer_quotation->currency_value,4) :'') !!}</span>
                                    </div>
                                    <div class="col-md-6 col-xs-12">
                                        <div class="table-responsive">
                                            <table class="table">
                                                <tbody>
                                                <tr>
                                                    <th style="width:50%">@lang('general.text_amount_untaxed')</th>
                                                    <td>{{ money($customer_quotation->amount_untaxed,$customer_quotation->currency->code,true) }}</td>
                                                </tr>
                                                @if($customer_quotation->customerQuotationTaxes->isNotEmpty())
                                                    @foreach($customer_quotation->customerQuotationTaxes as $result)
                                                        <tr>
                                                            <th>{{$result->name}}</th>
                                                            <td>{{ money(abs($result->amount_tax),$customer_quotation->currency->code,true) }}</td>
                                                        </tr>
                                                    @endforeach
                                                @endif
                                                <tr>
                                                    <th>{{ mb_strtoupper(__('general.text_amount_total')) }}</th>
                                                    <td>{{ money($customer_quotation->amount_total,$customer_quotation->currency->code,true) }}</td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 15px;">
                                    <div class="col-md-12 col-xs-12 invoice-col">
                                        @if(!empty($customer_quotation->comment))
                                            <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_quotation.entry_comment')</strong></p>
                                            <table cellpadding="0" cellspacing="0" class="table table-secundary" width="100%">
                                                <tr>
                                                    <td width="100%" style="vertical-align: top; padding: 5px;">
                                                        {{ $customer_quotation->comment }}
                                                    </td>
                                                </tr>
                                            </table>
                                        @endif
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 15px;">
                                    <div class="col-md-12 col-xs-12 invoice-col">
                                        @if(!empty($customer_quotation->terms_of_sale))
                                            <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_quotation.entry_terms_of_sale')</strong></p>
                                            <table cellpadding="0" cellspacing="0" class="table table-secundary" width="100%">
                                                <tr>
                                                    <td width="100%" style="vertical-align: top; padding: 5px;">
                                                        {!! $customer_quotation->terms_of_sale !!}
                                                    </td>
                                                </tr>
                                            </table>
                                        @endif
                                    </div>
                                </div>
                                <!-- /.row -->
                            </section>


                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

    </script>
@endsection
