<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_remission->documentType->name}}-{{$customer_remission->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 335px;
            margin-bottom: 30px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_remission->company_id) }}     !important;
        }
        .text-secondary{
            color: #888888;
            font-weight: bold;
            font-size: 9pt;
        }
        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_remission->company_id) }}     !important;
        }
        .table-items tbody td {
            padding: 8px 2px;
            border: none;
            border-bottom: 1px solid #cccccc;
        }
        .table-footer td {
            background-color: #FEFEFE;
            border: none;
        }
        .table-items tfoot td {
            padding: 4px 2px;
            border: none;
            border-bottom: 1px solid #cccccc;
        }
        .table-secundary td {
            background-color: #FAFAFA;
            border: none;
            border-bottom: 1px solid #cccccc;
        }
        .table-resume td {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_remission->company_id) }}     !important;
            color: #FFFFFF;
        }
    </style>
</head>
<body style="background-color: white;">
<section class="header" style="top: -312px;">
    <div>
    <table cellpadding="2" cellspacing="0" class="" width="100%">
        <tr>
            <td width="55%" style="border-bottom: 1px solid #cccccc; border-right: 1px solid #cccccc; padding: 5px 15px 10px 8px;">
                <h1 class="text-primary text-center" style="font-size: 20px; margin-bottom: 15px;">{{ mb_strtoupper($customer_remission->documentType->name) }}</h1>
                <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px;">
                    <tr>
                        <td width="50%" class="text-center" style="">
                            <span class="text-secondary"># {{ $customer_remission->name }}</span>
                        </td>
                        <td width="50%" class="text-center" style="">
                            <span class="text-secondary">{{ \App\Helpers\Helper::convertSqlToDateTime($customer_remission->date) }}</span>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" style="padding-bottom: 8px;">
                            <hr style="border-bottom: 1px solid #cccccc;">
                        </td>
                    </tr>
                    <tr>
                        <td width="50%" class="text-center" style="padding-bottom: 5px;">
                            <span class="text-secondary" style="font-size: 9px; font-weight: normal;">@lang('general.text_amount_total')</span>
                        </td>
                        <td width="50%" class="text-center" class="text-right" style="padding-bottom: 5px;">
                            <span class="text-secondary" style="font-size: 9px; font-weight: normal;">@lang('sales/customer_remission.entry_expiration_date')</span>
                        </td>
                    </tr>
                    <tr>
                        <td width="50%" class="text-center" style="font-size: 11px; padding-bottom: 5px;">
                            <strong>{{ money($customer_remission->amount_total,$customer_remission->currency->code,true) }}</strong>
                        </td>
                        <td width="50%" class="text-center" class="text-right" style="font-size: 11px; padding-bottom: 5px;">
                            @if(!empty($customer_remission->expiration_date))
                            <strong>{{ \App\Helpers\Helper::convertSqlToDate($customer_remission->expiration_date) }}</strong>
                            @else
                                ---
                            @endif
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" class="text-center" style="padding-top: 20px;">
                            <span class="text-primary">{{ mb_strtoupper($customer_remission->company->comercial_name) }}</span>
                        </td>
                    </tr>
                </table>
            </td>
            <td class="text-company" style="border-bottom: 1px solid #cccccc; padding: 5px 0 10px 13px; height: 160px;">
                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_remission->company_id,$customer_payment->project_id) }}" class="" style="max-height: 50px; max-width: 220px; margin-bottom: 5px;"/>
                @elseif(!empty(setting('branch_office_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_remission->company_id,$customer_remission->branch_office_id) }}" class="" style="max-height: 50px; max-width: 220px; margin-bottom: 5px;"/>
                @else
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_remission->company_id) }}" class="" style="max-height: 50px; max-width: 220px; margin-bottom: 5px;"/>
                @endif
                <br/>
                <strong class="">{{ mb_strtoupper($customer_remission->company->name) }}</strong>
                <br/>
                @if(!empty($customer_remission->company->address_1) || !empty($customer_remission->company->address_2) || !empty($customer_remission->company->address_3) || !empty($customer_remission->company->address_4))
                    <br/>
                    {{ $customer_remission->company->address_1 ?? '' }} {{ $customer_remission->company->address_2 ?? '' }} {{ $customer_remission->company->address_3 ?? '' }} {{ $customer_remission->company->address_4 ?? '' }}
                @endif
                @if(!empty($customer_remission->company->city->name) || !empty($customer_remission->company->state->name))
                    <br/>
                    {{ !empty($customer_remission->company->city->name) ? $customer_remission->company->city->name . ', ' : '' }}{{ $customer_remission->company->state->name ?? '' }}
                @endif
                <br/>
                {{ $customer_remission->company->country->name ?? '' }}{!! ($customer_remission->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_remission->company->postcode : '') !!}
                <br/>
                {{ mb_strtoupper($customer_remission->company->taxid) }}
                <br/>
                ---
                <br/>
                {{ $customer_remission->company->phone ?? ' ' }} | {{ $customer_remission->company->email ?? ' ' }}
            </td>
        </tr>
        <tr>
            <td style="padding: 10px 15px 10px 8px; border-right: 1px solid #cccccc;">
                @if(!empty($customer_remission->paymentTerm->name))
                <strong>@lang('sales/customer_remission.entry_payment_term_id'): </strong>{{ $customer_remission->paymentTerm->name }}
                <br/>
                @endif
                @if(!empty($customer_remission->cfdiUse->name_sat))
                <strong>@lang('sales/customer_remission.entry_cfdi_use_id'): </strong>{{ $customer_remission->cfdiUse->name_sat }}
                <br/>
                @endif
                <strong>@lang('general.text_issued_in'): </strong>{{ $customer_remission->branchOffice->name ?? '' }} {!! ($customer_remission->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $customer_remission->branchOffice->postcode : '') !!}
                <br/>
            </td>
            <td class="text-company" style="padding: 10px 0px 10px 13px;">
                <strong class="" style="color: #999999; padding-bottom: 10px;"><small>{{ (__('general.text_customer')) }}</small></strong>
                <br/><br/>
                <strong style="margin-top: 10px;">{{ mb_strtoupper($customer_remission->customer->name) }}</strong>
                @if(!empty($customer_remission->customer->address_1) || !empty($customer_remission->customer->address_2) || !empty($customer_remission->customer->address_3) || !empty($customer_remission->customer->address_4))
                <br/>
                    {{ $customer_remission->customer->address_1 ?? '' }} {{ $customer_remission->customer->address_2 ?? '' }} {{ $customer_remission->customer->address_3 ?? '' }} {{ $customer_remission->customer->address_4 ?? '' }},
                @endif
                @if(!empty($customer_remission->customer->city->name) || !empty($customer_remission->customer->state->name))
                    <br/>
                    {{ !empty($customer_remission->customer->city->name) ? $customer_remission->customer->city->name . ', ' : '' }}{{ $customer_remission->customer->state->name ?? '' }}
                @endif
                <br/>
                {{ $customer_remission->customer->country->name ?? '' }}{!! ($customer_remission->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_remission->customer->postcode : '') !!}
                <br/>
                {{ mb_strtoupper($customer_remission->customer->taxid) }}
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_remission->status == \App\Models\Sales\CustomerRemission::CANCEL)
    <section class="watermark" style="bottom: 450px !important;">
        <span>@lang('general.text_canceled')</span>
    </section>
@endif
<section>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
        <thead>
        <tr>
            <th class="text-left">{{ mb_strtoupper(__('sales/customer_remission.column_line_name')) }}</th>
            <th width="15%">{{ mb_strtoupper(__('sales/customer_remission.column_line_unit_measure_id')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_remission.column_line_quantity')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_remission.column_line_price_unit')) }}</th>
            <th width="6%">{{ mb_strtoupper(__('sales/customer_remission.column_line_discount')) }}</th>
            <th width="11%">{{ mb_strtoupper(__('sales/customer_remission.column_line_amount_untaxed')) }}</th>
        </tr>
        </thead>
        <tbody>
            @foreach($customer_remission->customerActiveRemissionLines as $result)
                <tr>
                    <td>{!! nl2br($result->name) !!}</td>
                    <td class="text-center">{{ $result->unitMeasure->name_sat ?? '' }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place ?? 1) }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_remission->company_id)) }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                    <td class="text-right">{{ money($result->amount_untaxed,$customer_remission->currency->code,true) }}</td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
        <tr>
            <td colspan="3" class="text-center" style="vertical-align: bottom;">
                <span style="line-height: 16px;">
                    ***({{\App\Helpers\Helper::numberToWordCurrency($customer_remission->amount_total,$customer_remission->currency->code,$customer_remission->currency->decimal_place)}})***
                </span>
            </td>
            <td colspan="2" class="text-right" style="vertical-align: top; padding-right: 4px;">
                <strong>@lang('general.text_amount_untaxed')</strong><br/>
                @if($customer_remission->customerRemissionTaxes->isNotEmpty())
                    @foreach($customer_remission->customerRemissionTaxes as $result)
                        <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
            </td>
            <td class="text-right">
                {{ money($customer_remission->amount_untaxed,$customer_remission->currency->code,true) }}<br/>
                @if($customer_remission->customerRemissionTaxes->isNotEmpty())
                    @foreach($customer_remission->customerRemissionTaxes as $result)
                        <span style="line-height: 16px;">{{money(abs($result->amount_tax),$customer_remission->currency->code,true)}}</span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ money($customer_remission->amount_total,$customer_remission->currency->code,true) }}</strong></span>
            </td>
        </tr>
        </tfoot>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="100%" style="vertical-align: top; padding: 5px;">
                @if(!empty($customer_remission->paymentWay->name_sat))
                    <strong>@lang('sales/customer_remission.entry_payment_way_id'): </strong>{{ $customer_remission->paymentWay->name_sat }}
                    <br/>
                @endif
                @if(!empty($customer_remission->paymentMethod->name_sat))
                    <strong>@lang('sales/customer_remission.entry_payment_method_id'): </strong>{{ $customer_remission->paymentMethod->name_sat }}
                    <br/>
                @endif
                <strong>@lang('sales/customer_remission.entry_currency_id'): </strong>{{ $customer_remission->currency->code }}{!! ($customer_remission->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/customer_remission.entry_currency_value').':</strong> '.round($customer_remission->currency_value,4) :'') !!}
                <br/>
            </td>
        </tr>
    </table>
    </div>
    @if(!empty($customer_remission->comment))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_remission.entry_comment')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;">
                    {!! nl2br($customer_remission->comment) !!}
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_remission->terms_of_sale))
        <div>
            <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_remission.entry_terms_of_sale')</strong></p>
            <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
                <tr>
                    <td width="100%" style="vertical-align: top; padding: 5px;">
                        {!! nl2br($customer_remission->terms_of_sale) !!}
                    </td>
                </tr>
            </table>
        </div>
    @endif
</section>
</body>
</html>
