<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_remission->documentType->name}}-{{$customer_remission->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 327px;
            margin-bottom: 27px;
            margin-left: 23px;
            margin-right: 23px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_remission->company_id) }}     !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_remission->company_id) }}     !important;
        }
        .cell-primary {
            border: 1px solid {{ \App\Helpers\Helper::companyColorPrimary($customer_remission->company_id) }}     !important;
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_remission->company_id) }}     !important;
            color: #ffffff;
            font-weight: bold;
            padding: 5px 2px;
            text-align: center !important;
            vertical-align: middle !important;
            text-transform: uppercase;
            font-size: 8pt;
        }
        .cell-primary-border-line {
            border: 1px solid #dddddd !important;
            border-radius: 0 0 3px 3px;
            padding: 5px 1px;
        }
    </style>
</head>
<body style="background-color: white;">
<section class="header" style="top: -289px;">
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
            <tr>
                <td width="22%" class="text-left" style="vertical-align: top; padding-bottom: 7px; height: 90px;">
                    @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                        <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_remission->company_id,$customer_remission->project_id) }}" class="invoice-logo" style="max-width: 160px !important; max-height: 60px !important;"/>
                    @elseif(!empty(setting('branch_office_logo_docs')))
                        <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_remission->company_id,$customer_remission->branch_office_id) }}" class="invoice-logo" style="max-width: 160px !important; max-height: 60px !important;"/>
                    @else
                        <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_remission->company_id) }}" class="invoice-logo" style="max-width: 160px !important; max-height: 60px !important;"/>
                    @endif
                </td>
                <td width="28%" class="text-left" style="vertical-align: top; padding-bottom: 7px; padding-left: 5px;">
                    @if(!empty($customer_remission->company->comercial_name))
                    <span class="text-primary" style="font-size: 8pt;">{{ mb_strtoupper($customer_remission->company->comercial_name) }}</span>
                    <br/>
                    @endif
                    {{ mb_strtoupper($customer_remission->company->name) }}
                    @if(!empty($customer_remission->company->address_1) || !empty($customer_remission->company->address_2) || !empty($customer_remission->company->address_3) || !empty($customer_remission->company->address_4))
                        <br/>
                        {{ $customer_remission->company->address_1 ?? '' }} {{ $customer_remission->company->address_2 ?? '' }} {{ $customer_remission->company->address_3 ?? '' }} {{ $customer_remission->company->address_4 ?? '' }}
                    @endif
                    @if(!empty($customer_remission->company->city->name) || !empty($customer_remission->company->state->name))
                        <br/>
                        {{ !empty($customer_remission->company->city->name) ? $customer_remission->company->city->name . ', ' : '' }}{{ $customer_remission->company->state->name ?? '' }}
                    @endif
                    <br/>
                    {{ $customer_remission->company->country->name ?? '' }}{!! ($customer_remission->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_remission->company->postcode : '') !!}
                    <br/>
                    {{ mb_strtoupper($customer_remission->company->taxid) }}
                    <br/>
                    ---
                    <br/>
                    {{ $customer_remission->company->phone ?? ' ' }}
                    <br/>
                    <span style="text-transform: lowercase;">{{ $customer_remission->company->email ?? ' ' }}</span>
                </td>
                <td width="33%" class="text-left" rowspan="2" style="vertical-align: top; padding-left: 5px; padding-bottom: 7px; border-left: 1px solid #333333;">
                    <h3 style="margin: 0;">{{ mb_strtoupper($customer_remission->documentType->name) }}</h3><br>
                    <strong>@lang('sales/customer_remission.entry_date'):</strong><br/>
                    {{ str_replace(' ',' ',\App\Helpers\Helper::convertSqlToDateTime($customer_remission->date)) }}<br/>
                    @if(!empty($customer_remission->expiration_date))
                    <strong>@lang('sales/customer_remission.entry_expiration_date'):</strong><br/>
                    {{ \App\Helpers\Helper::convertSqlToDate($customer_remission->expiration_date) }}<br/>
                    @endif
                </td>
            </tr>
            <tr>
                <td width="50%" class="text-left" colspan="2" style="vertical-align: top; padding-top: 1px; padding-bottom: 7px;">
                    <table cellpadding="0" cellspacing="0" class="" width="100%">
                        <tr>
                            <td width="30%">@lang('sales/customer_remission.entry_name')</td>
                            <td width="70%">{{ $customer_remission->name }}</td>
                        </tr>
                        @if(!empty($customer_remission->paymentWay->name_sat))
                        <tr>
                            <td>@lang('sales/customer_remission.entry_payment_way_id')</td>
                            <td>{{ $customer_remission->paymentWay->name_sat }}</td>
                        </tr>
                        @endif
                        <tr>
                            <td>@lang('sales/customer_remission.entry_currency_id')</td>
                            <td>
                                {{ $customer_remission->currency->code }}
                                @if($customer_remission->currency->code!='MXN')
                                    {{ '&nbsp;&nbsp;&nbsp;' . __('sales/customer_remission.entry_currency_value') . ': '. round($customer_remission->currency_value,4)}}
                                @endif
                            </td>
                        </tr>
                        @if(!empty($customer_remission->paymentMethod->name_sat))
                        <tr>
                            <td>@lang('sales/customer_remission.entry_payment_method_id')</td>
                            <td>{{ $customer_remission->paymentMethod->name_sat }}</td>
                        </tr>
                        @endif
                        @if(!empty($customer_remission->paymentTerm->name))
                        <tr>
                            <td>@lang('sales/customer_remission.entry_payment_term_id')</td>
                            <td>{{ $customer_remission->paymentTerm->name }}</td>
                        </tr>
                        @endif
                        <tr>
                            <td>@lang('general.text_issued_in')</td>
                            <td>{{ $customer_remission->branchOffice->postcode }}</td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
            <tr>
                <td width="50%" class="text-left" style="vertical-align: top; padding-bottom: 7px; padding-top: 7px; border-top: 1px solid #333333; border-bottom: 1px solid #333333; height: 50px; ">
                    <strong>{{ mb_strtoupper($customer_remission->customer->name) }}</strong>
                    <br>
                    @if(!empty($customer_remission->customer->address_1) || !empty($customer_remission->customer->address_2) || !empty($customer_remission->customer->address_3) || !empty($customer_remission->customer->address_4))
                        {{ $customer_remission->customer->address_1 ?? '' }} {{ $customer_remission->customer->address_2 ?? '' }} {{ $customer_remission->customer->address_3 ?? '' }} {{ $customer_remission->customer->address_4 ?? '' }}
                        <br/>
                    @endif
                    @if(!empty($customer_remission->customer->city->name) || !empty($customer_remission->customer->state->name))
                        {{ !empty($customer_remission->customer->city->name) ? $customer_remission->customer->city->name . ', ' : '' }}{{ $customer_remission->customer->state->name ?? '' }}
                        <br/>
                    @endif
                    {{ $customer_remission->customer->country->name ?? '' }}{!! ($customer_remission->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_remission->customer->postcode : '') !!}
                </td>
                <td width="50%" class="text-left" style="vertical-align: top; padding-bottom: 7px; padding-top: 7px; border-top: 1px solid #333333; border-bottom: 1px solid #333333; height: 50px;">
                    @lang('sales/customer.entry_taxid'): {{ mb_strtoupper($customer_remission->customer->taxid) }}
                    <br/>
                    @if(!empty($customer_remission->cfdiUse->name_sat))
                    @lang('sales/customer_remission.entry_cfdi_use_id'): {{ $customer_remission->cfdiUse->name_sat }}
                    @endif
                </td>
            </tr>
        </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_remission->status == \App\Models\Sales\CustomerRemission::CANCEL)
    <section class="watermark" style="bottom: 450px !important;">
        <span>@lang('general.text_canceled')</span>
    </section>
@endif
<section>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
            <thead>
            <tr>
                <th width="7%">{{ mb_strtoupper(__('sales/customer_remission.column_line_quantity')) }}</th>
                <th class="text-left">{{ mb_strtoupper(__('sales/customer_remission.column_line_sat_product_id')) . ' - ' . mb_strtoupper(__('sales/customer_remission.column_line_name')) }}</th>
                <th width="14%">{{ mb_strtoupper(__('sales/customer_remission.column_line_unit_measure_id')) }}</th>
                <th width="9%">{{ mb_strtoupper(__('sales/customer_remission.column_line_price_unit')) }}</th>
                <th width="6%">{{ mb_strtoupper(__('sales/customer_remission.column_line_discount')) }}</th>
                <th width="11%">{{ mb_strtoupper(__('sales/customer_remission.column_line_amount_untaxed')) }}</th>
            </tr>
            </thead>
            <tbody>
                @foreach($customer_remission->customerActiveRemissionLines as $result)
                    <tr>
                        <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place ?? 1) }}</td>
                        <td>{!! nl2br($result->name) !!}</td>
                        <td class="text-center">{{ $result->unitMeasure->name_sat ?? '' }}</td>
                        <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_remission->company_id)) }}</td>
                        <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                        <td class="text-right">{{ money($result->amount_untaxed,$customer_remission->currency->code,true) }}</td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
            <tr>
                <td colspan="6" class="text-left" style="vertical-align: top; height: 50px;">
                    {!! nl2br($customer_remission->comment) !!}
                </td>
            </tr>
            <tr>
                <td colspan="3" class="text-left" style="vertical-align: top;">
                            <span style="line-height: 16px;">
                                ***({{\App\Helpers\Helper::numberToWordCurrency($customer_remission->amount_total,$customer_remission->currency->code,$customer_remission->currency->decimal_place)}})***
                            </span>
                </td>
                <td colspan="2" class="text-right" style="vertical-align: top; padding-right: 4px;">
                    <strong>@lang('general.text_amount_untaxed')</strong><br/>
                    @if($customer_remission->customerRemissionTaxes->isNotEmpty())
                        @foreach($customer_remission->customerRemissionTaxes as $result)
                            <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                        @endforeach
                    @endif
                    <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
                </td>
                <td class="text-right">
                    {{ money($customer_remission->amount_untaxed,$customer_remission->currency->code,true) }}<br/>
                    @if($customer_remission->customerRemissionTaxes->isNotEmpty())
                        @foreach($customer_remission->customerRemissionTaxes as $result)
                            <span style="line-height: 16px;">{{money(abs($result->amount_tax),$customer_remission->currency->code,true)}}</span><br/>
                        @endforeach
                    @endif
                    <span style="line-height: 16px;"><strong>{{ money($customer_remission->amount_total,$customer_remission->currency->code,true) }}</strong></span>
                </td>
            </tr>
            </tfoot>
        </table>
    </div>
    @if(!empty($customer_remission->terms_of_sale))
        <div>
            <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                <tr>
                    <td width="" class="cell-primary" style=""><small>@lang('sales/customer_remission.entry_terms_of_sale')</small></td>
                </tr>
                <tr>
                    <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 45px; padding: 5px;  word-wrap:break-word;">
                        <small>{!! $customer_remission->terms_of_sale !!}</small>
                    </td>
                </tr>
            </table>
        </div>
    @endif
</section>
</body>
</html>
