@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('sales/customer_transfer.document_title'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('sales/customer_transfer.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('customer-transfers.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if (!$errors->isEmpty())
                    <div class="alert alert-danger alert-dismissable alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        {{ __('general.error_form') }}
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>{{ $customer_transfer->name }}</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            {!! Form::model($customer_transfer,['route' => ['customer-transfers.update',$customer_transfer->id],'method' => 'PUT','class' => '','role' => 'form','id' => 'form']) !!}
                            <!-- input hidden -->
                            {!! Form::hidden('amount_total_tmp', old('amount_total_tmp',0)) !!}
                            <!-- /.input hidden -->
                            <div class="row">
                                @if($tax_regimens->isNotEmpty())
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm{{ $errors->has('tax_regimen_id') ? ' has-error' : '' }}">
                                            {!! html_entity_decode(Form::label('tax_regimen_id', __('sales/customer_transfer.entry_tax_regimen_id') . ' ', ['class' => 'control-label'])) !!}
                                            {!! Form::select('tax_regimen_id', $tax_regimens,old('tax_regimen_id', !empty($customer_transfer->tax_regimen_id) ? $customer_transfer->tax_regimen_id : \App\Helpers\Helper::defaultCompany()->tax_regimen_id), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                            @if ($errors->has('tax_regimen_id'))
                                                <span class="help-block"><small>{{ $errors->first('tax_regimen_id') }}</small></span>
                                            @endif
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <div class="row">
                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('customer_id') ? ' has-error' : '' }}">
                                        @php
                                            $tmp_customers = [];
                                            if(!empty(old('customer_id',$customer_transfer->customer_id))){
                                                $tmp_customers = \App\Models\Sales\Customer::where('id','=',old('customer_id',$customer_transfer->customer_id))->get()->pluck('text_select2','id');
                                            }
                                        @endphp
                                        {!! html_entity_decode(Form::label('customer_id', __('sales/customer_transfer.entry_customer_id')  . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        <div class="input-group input-group-sm">
                                            {!! Form::select('customer_id', $tmp_customers,old('customer_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required','autofocus']) !!}
                                            <span class="input-group-btn">
                                                <button type="button" class="btn btn-info btn-customer-search"><i class="fa fa-search"></i></button>
                                                <button type="button" class="btn btn-info btn-customer-add"><i class="fa fa-plus"></i></button>
                                            </span>
                                        </div>
                                        @if ($errors->has('customer_id'))
                                            <span class="help-block"><small>{{ $errors->first('customer_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('tax_regimen_customer_id') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('tax_regimen_customer_id', __('sales/customer_transfer.entry_tax_regimen_customer_id') . '', ['class' => 'control-label'])) !!}
                                        {!! Form::select('tax_regimen_customer_id', $tax_regimen_customers,old('tax_regimen_customer_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        @if ($errors->has('tax_regimen_customer_id'))
                                            <span class="help-block"><small>{{ $errors->first('tax_regimen_customer_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('branch_office_id') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('branch_office_id', __('sales/customer_transfer.entry_branch_office_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        {!! Form::select('branch_office_id', $branch_offices,old('branch_office_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                        @if ($errors->has('branch_office_id'))
                                            <span class="help-block"><small>{{ $errors->first('branch_office_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-2 col-xs-7">
                                    <div class="form-group form-group-sm{{ $errors->has('currency_id') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('currency_id', __('sales/customer_transfer.entry_currency_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        {!! Form::select('currency_id', $currencies,old('currency_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                        @if ($errors->has('currency_id'))
                                            <span class="help-block"><small>{{ $errors->first('currency_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-1 col-xs-5">
                                    <div class="form-group form-group-sm{{ $errors->has('currency_value') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('currency_value', __('sales/customer_transfer.entry_currency_value') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        {!! Form::number('currency_value', old('currency_value',round($customer_transfer->currency_value,4)), ['class' => 'form-control text-center', 'placeholder' => __('sales/customer_transfer.entry_currency_value'),'required','step' => 'any']) !!}
                                        @if ($errors->has('currency_value'))
                                            <span class="help-block"><small>{{ $errors->first('currency_value') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('date') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('date', __('sales/customer_transfer.entry_date') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        <div class="input-group input-group-sm">
                                            {!! Form::text('date', old('date',\App\Helpers\Helper::dateTime(Date::parse($customer_transfer->date))), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_date'),'required','autocomplete'=>'off']) !!}
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                        </div>
                                        @if ($errors->has('date'))
                                            <span class="help-block"><small>{{ $errors->first('date') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('cfdi_use_id') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('cfdi_use_id', __('sales/customer_transfer.entry_cfdi_use_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        {!! Form::select('cfdi_use_id', $cfdi_uses,old('cfdi_use_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                        @if ($errors->has('cfdi_use_id'))
                                            <span class="help-block"><small>{{ $errors->first('cfdi_use_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('payment_term_id') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('payment_term_id', __('sales/customer_transfer.entry_payment_term_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        {!! Form::select('payment_term_id', $payment_terms,old('payment_term_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                        @if ($errors->has('payment_term_id'))
                                            <span class="help-block"><small>{{ $errors->first('payment_term_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="row {{old('document_type2', $customer_transfer->document_type2) != 'invoice' ? 'hidden' : ''}}" id="invoice">
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('date_due') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('date_due', __('sales/customer_transfer.entry_date_due') . '', ['class' => 'control-label'])) !!}
                                        <div class="input-group input-group-sm">
                                            {!! Form::text('date_due', old('date_due',\App\Helpers\Helper::date(Date::parse($customer_transfer->date_due))), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_date_due'),'autocomplete'=>'off']) !!}
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                        </div>
                                        @if ($errors->has('date_due'))
                                            <span class="help-block"><small>{{ $errors->first('date_due') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('payment_way_id') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('payment_way_id', __('sales/customer_transfer.entry_payment_way_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        {!! Form::select('payment_way_id', $payment_ways,old('payment_way_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        @if ($errors->has('payment_way_id'))
                                            <span class="help-block"><small>{{ $errors->first('payment_way_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('payment_method_id') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('payment_method_id', __('sales/customer_transfer.entry_payment_method_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        {!! Form::select('payment_method_id', $payment_methods,old('payment_method_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        @if ($errors->has('payment_method_id'))
                                            <span class="help-block"><small>{{ $errors->first('payment_method_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm">
                                        {!! html_entity_decode(Form::label('salesperson_id', __('sales/customer_transfer.entry_salesperson_id') . '', ['class' => 'control-label'])) !!}
                                        {!! Form::select('salesperson_id', $salespersons,old('salesperson_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12 hidden">
                                    <div class="form-group form-group-sm">
                                        {!! html_entity_decode(Form::label('reference', __('sales/customer_transfer.entry_reference') . '', ['class' => 'control-label'])) !!}
                                        {!! Form::text('reference', old('reference'), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_reference')]) !!}
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('document_type2') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('document_type2', __('sales/customer_transfer.entry_document_type2') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        {!! Form::select('document_type2', $list_document_type2,old('document_type2'), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                        @if ($errors->has('document_type2'))
                                            <span class="help-block"><small>{{ $errors->first('document_type2') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('trans_transport_type_id') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('trans_transport_type_id', __('sales/customer_transfer.entry_trans_transport_type_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        {!! Form::select('trans_transport_type_id', $transport_types,old('transport_type_id',($customer_transfer_transfer->trans_transport_type_id ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select'), 'required']) !!}
                                        @if ($errors->has('trans_transport_type_id'))
                                            <span class="help-block"><small>{{ $errors->first('trans_transport_type_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="row">
                                        <div class="col-md-6 col-xs-12">
                                            <div class="form-group form-group-sm{{ $errors->has('transport_int') ? ' has-error' : '' }}">
                                                {!! html_entity_decode(Form::label('transport_int', __('sales/customer_transfer.entry_transport_int') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                {!! Form::select('transport_int', $yes_nos,old('transport_int',($customer_transfer_transfer->transport_int ?? 'No')), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                                @if ($errors->has('transport_int'))
                                                    <span class="help-block"><small>{{ $errors->first('transport_int') }}</small></span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xs-12">
                                            <div class="form-group form-group-sm{{ $errors->has('in_out_product') ? ' has-error' : '' }}">
                                                {!! html_entity_decode(Form::label('in_out_product', __('sales/customer_transfer.entry_in_out_product') . '', ['class' => 'control-label'])) !!}
                                                {!! Form::select('in_out_product', $in_out_products,old('in_out_product',($customer_transfer_transfer->in_out_product ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                @if ($errors->has('in_out_product'))
                                                    <span class="help-block"><small>{{ $errors->first('in_out_product') }}</small></span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="row">
                                        <div class="col-md-6 col-xs-12">
                                            <div class="form-group form-group-sm{{ $errors->has('in_out_country_id') ? ' has-error' : '' }}">
                                                {!! html_entity_decode(Form::label('in_out_country_id', __('sales/customer_transfer.entry_in_out_country_id') . '', ['class' => 'control-label'])) !!}
                                                {!! Form::select('in_out_country_id', $countries2,old('in_out_country_id',($customer_transfer_transfer->in_out_country_id ?? 'No')), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                @if ($errors->has('in_out_country_id'))
                                                    <span class="help-block"><small>{{ $errors->first('in_out_country_id') }}</small></span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xs-12">
                                            <div class="form-group form-group-sm{{ $errors->has('transport_type_id') ? ' has-error' : '' }}">
                                                {!! html_entity_decode(Form::label('transport_type_id', __('sales/customer_transfer.entry_transport_type_id') . '', ['class' => 'control-label'])) !!}
                                                {!! Form::select('transport_type_id', $transport_types,old('transport_type_id',($customer_transfer_transfer->transport_type_id ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                @if ($errors->has('transport_type_id'))
                                                    <span class="help-block"><small>{{ $errors->first('transport_type_id') }}</small></span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12 hidden">
                                    <div class="form-group form-group-sm{{ $errors->has('distance_traveled') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('distance_traveled', __('sales/customer_transfer.entry_distance_traveled') . '', ['class' => 'control-label'])) !!}
                                        {!! Form::number('distance_traveled', old('distance_traveled',($customer_transfer_transfer->transport_type_id ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_distance_traveled'), 'step' => 'any', 'autocomplete' => 'off']) !!}
                                        @if ($errors->has('distance_traveled'))
                                            <span class="help-block"><small>{{ $errors->first('distance_traveled') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                @if(!empty(setting('enabled_projects')))
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm{{ $errors->has('project_id') ? ' has-error' : '' }}">
                                            {!! html_entity_decode(Form::label('project_id', __('sales/customer_transfer.entry_project_id') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('project_id', $projects,old('project_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                            @if ($errors->has('project_id'))
                                                <span class="help-block"><small>{{ $errors->first('project_id') }}</small></span>
                                            @endif
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('item') ? ' has-error' : '' }}"
                                         style="margin-top: 20px;">
                                        @if ($errors->has('item'))
                                            <span class="help-block"><small>{{ $errors->first('item') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-12 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('item_transfer') ? ' has-error' : '' }}">
                                        @if ($errors->has('item_transfer'))
                                            <span class="help-block"><small>{{ $errors->first('item_transfer') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="" role="tabpanel" data-example-id="togglable-tabs">
                                <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
                                    <li role="presentation" class="active">
                                        <a href="#tab_source_ubication" id="source-ubication-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('sales/customer_transfer.tab_source_ubication')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_destination_ubication" id="destination-ubication-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('sales/customer_transfer.tab_destination_ubication')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_transfers" id="transfers-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('sales/customer_transfer.tab_transfers')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_transport" id="transport-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('sales/customer_transfer.tab_transport')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_products" id="products-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('sales/customer_transfer.tab_products')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_transport_figure" id="transport-figure-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('sales/customer_transfer.tab_transport_figure')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_relations" id="relations-tab" role="tab"
                                           data-toggle="tab"
                                           aria-expanded="false">@lang('sales/customer_transfer.tab_relations')</a>
                                    </li>
                                </ul>
                                <div id="myTabContent" class="tab-content">
                                    <div role="tabpanel" class="tab-pane fade in" id="tab_general"
                                         aria-labelledby="general-tab">
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12">
                                                <hr class="divider">
                                            </div>
                                            <div class="col-md-6 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('compensation') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('compensation', __('sales/customer_transfer.entry_compensation') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::textarea('compensation', old('compensation'), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_compensation'),'rows' => '2']) !!}
                                                    @if ($errors->has('compensation'))
                                                        <span class="help-block"><small>{{ $errors->first('compensation') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('comment') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('comment', __('sales/customer_transfer.entry_comment') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::textarea('comment', old('comment'), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_comment'),'rows' => '2']) !!}
                                                    @if ($errors->has('comment'))
                                                        <span class="help-block"><small>{{ $errors->first('comment') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('vehicle_counter') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('vehicle_counter', __('sales/customer_transfer.entry_vehicle_counter') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('vehicle_counter', old('vehicle_counter'), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_vehicle_counter')]) !!}
                                                    @if ($errors->has('vehicle_counter'))
                                                        <span class="help-block"><small>{{ $errors->first('vehicle_counter') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade in active" id="tab_source_ubication"
                                            aria-labelledby="source-ubication-tab">
                                            <div class="row">
                                            <div class="col-md-3 col-xs-12 hidden">
                                                <div class="form-group form-group-sm{{ $errors->has('source_distance_traveled') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('source_distance_traveled', __('sales/customer_transfer.entry_source_distance_traveled') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('source_distance_traveled', old('source_distance_traveled', ($customer_transfer_transfer->source_distance_traveled ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_source_distance_traveled'), 'step' => 'any', 'autocomplete' => 'off']) !!}
                                                    @if ($errors->has('source_distance_traveled'))
                                                        <span class="help-block"><small>{{ $errors->first('source_distance_traveled') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12 hidden">
                                                <div class="form-group form-group-sm{{ $errors->has('source_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('source_id', __('sales/customer_transfer.entry_source_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('source_id', old('source_id',($customer_transfer_transfer->source_id ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_source_id')]) !!}
                                                    @if ($errors->has('source_id'))
                                                        <span class="help-block"><small>{{ $errors->first('source_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('source_date') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('source_date', __('sales/customer_transfer.entry_source_date') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    <div class="input-group input-group-sm">
                                                        {!! Form::text('source_date', old('source_date', \App\Helpers\Helper::dateTime(Date::parse($customer_transfer_transfer->source_date))), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_source_date'),'required','autocomplete'=>'off']) !!}
                                                        <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    </div>
                                                    @if ($errors->has('source_date'))
                                                        <span class="help-block"><small>{{ $errors->first('source_date') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('source_taxid') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('source_taxid', __('sales/customer_transfer.entry_source_taxid') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('source_taxid', old('source_taxid',($customer_transfer_transfer->source_taxid ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_source_taxid'), 'required']) !!}
                                                    @if ($errors->has('source_taxid'))
                                                        <span class="help-block"><small>{{ $errors->first('source_taxid') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('source_name') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('source_name', __('sales/customer_transfer.entry_source_name') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('source_name', old('source_name',($customer_transfer_transfer->source_name ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_source_name')]) !!}
                                                    @if ($errors->has('source_name'))
                                                        <span class="help-block"><small>{{ $errors->first('source_name') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12 hidden">
                                                <div class="form-group form-group-sm{{ $errors->has('source_station_type_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('source_station_type_id', __('sales/customer_transfer.entry_source_station_type_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('source_station_type_id', $station_types,old('source_station_type_id',($customer_transfer_transfer->source_station_type_id ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('source_vstation_type_id'))
                                                        <span class="help-block"><small>{{ $errors->first('source_station_type_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12 hidden">
                                                <div class="form-group form-group-sm{{ $errors->has('source_station_id') ? ' has-error' : '' }}">
                                                    @php
                                                        $tmp_source_stations = [];
                                                        if(!empty(old('source_station_id',($customer_transfer_transfer->source_station_id ?? '')))){
                                                            $tmp_source_stations = \App\Models\Catalogs\Station::where('id','=',old('source_station_id',($customer_transfer_transfer->source_station_id ?? '')))->get()->pluck('text_select2','id');
                                                        }
                                                    @endphp
                                                    {!! html_entity_decode(Form::label('source_station_id', __('sales/customer_transfer.entry_source_station_id')  . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('source_station_id', $tmp_source_stations,old('source_station_id',($customer_transfer_transfer->source_station_id ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('source_station_id'))
                                                        <span class="help-block"><small>{{ $errors->first('source_station_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12 hidden">
                                                <div class="form-group form-group-sm{{ $errors->has('source_traffic_navigation') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('source_traffic_navigation', __('sales/customer_transfer.entry_source_traffic_navigation') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('source_traffic_navigation', $traffic_navigations,old('source_station_type_id',($customer_transfer_transfer->source_traffic_navigation ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('source_traffic_navigation'))
                                                        <span class="help-block"><small>{{ $errors->first('source_traffic_navigation') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('source_tr_country_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('source_tr_country_id', __('sales/customer_transfer.entry_source_tr_country_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('source_tr_country_id', $countries2,old('source_tr_country_id',($customer_transfer_transfer->source_tr_country_id ?? '')), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('source_tr_country_id'))
                                                        <span class="help-block"><small>{{ $errors->first('source_tr_country_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('source_numid') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('source_numid', __('sales/customer_transfer.entry_source_numid') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('source_numid', old('source_numid',($customer_transfer_transfer->source_numid ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_source_numid')]) !!}
                                                    @if ($errors->has('source_numid'))
                                                        <span class="help-block"><small>{{ $errors->first('source_numid') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            </div>
                                            <div class="row">
                                            <div class="col-md-12 col-xs-12">
                                                <hr class="divider">
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('source_address_1', __('sales/customer_transfer.entry_source_address_1') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('source_address_1', old('source_address_1',($customer_transfer_transfer->source_address_1 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_source_address_1')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('source_address_2', __('sales/customer_transfer.entry_source_address_2') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('source_address_2', old('source_address_2',($customer_transfer_transfer->source_address_2 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_source_address_2')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('source_address_3', __('sales/customer_transfer.entry_source_address_3') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('source_address_3', old('source_address_3',($customer_transfer_transfer->source_address_3 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_source_address_3')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('source_address_4', __('sales/customer_transfer.entry_source_address_4') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('source_address_4', old('source_address_4',($customer_transfer_transfer->source_address_4 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_source_address_4')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('source_address_5', __('sales/customer_transfer.entry_source_address_5') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('source_address_5', old('source_address_5',($customer_transfer_transfer->source_address_5 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_source_address_5')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-9 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('source_address_6', __('sales/customer_transfer.entry_source_address_6') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('source_address_6', old('source_address_6',($customer_transfer_transfer->source_address_6 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_source_address_6')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('source_country_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('source_country_id', __('sales/customer_transfer.entry_source_country_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('source_country_id', $countries,old('source_country_id',($customer_transfer_transfer->source_country_id ?? \App\Models\Catalogs\Country::whereCode('MEX')->first()->id)), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select'),'required']) !!}
                                                    @if ($errors->has('source_country_id'))
                                                        <span class="help-block"><small>{{ $errors->first('source_country_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('source_state_id', __('sales/customer_transfer.entry_source_state_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('source_state_id', [],null, ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select'),'required']) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('source_city_id', __('sales/customer_transfer.entry_source_city_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('source_city_id', [],null, ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('source_postcode', __('sales/customer_transfer.entry_source_postcode') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('source_postcode', old('source_postcode', ($customer_transfer_transfer->source_postcode ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_source_postcode'),'required']) !!}
                                                </div>
                                            </div>
                                            </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade in" id="tab_destination_ubication"
                                            aria-labelledby="destination-ubication-tab">
                                            <div class="row">
                                            <div class="col-md-3 col-xs-12 hidden">
                                                <div class="form-group form-group-sm{{ $errors->has('destination_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('destination_id', __('sales/customer_transfer.entry_destination_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('destination_id', old('destination_id',($customer_transfer_transfer->destination_id ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_destination_id')]) !!}
                                                    @if ($errors->has('destination_id'))
                                                        <span class="help-block"><small>{{ $errors->first('destination_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('destination_date') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('destination_date', __('sales/customer_transfer.entry_destination_date') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    <div class="input-group input-group-sm">
                                                        {!! Form::text('destination_date', old('destination_date',\App\Helpers\Helper::dateTime(Date::parse($customer_transfer_transfer->destination_date))), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_destination_date'),'required','autocomplete'=>'off']) !!}
                                                        <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    </div>
                                                    @if ($errors->has('destination_date'))
                                                        <span class="help-block"><small>{{ $errors->first('destination_date') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('destination_distance_traveled') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('destination_distance_traveled', __('sales/customer_transfer.entry_destination_distance_traveled') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('destination_distance_traveled', old('destination_distance_traveled',($customer_transfer_transfer->destination_distance_traveled ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_destination_distance_traveled'), 'step' => 'any', 'required', 'autocomplete' => 'off']) !!}
                                                    @if ($errors->has('destination_distance_traveled'))
                                                        <span class="help-block"><small>{{ $errors->first('destination_distance_traveled') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('destination_taxid') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('destination_taxid', __('sales/customer_transfer.entry_destination_taxid') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('destination_taxid', old('destination_taxid',($customer_transfer_transfer->destination_taxid ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_destination_taxid'), 'required']) !!}
                                                    @if ($errors->has('destination_taxid'))
                                                        <span class="help-block"><small>{{ $errors->first('destination_taxid') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('destination_name') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('destination_name', __('sales/customer_transfer.entry_destination_name') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('destination_name', old('destination_name',($customer_transfer_transfer->destination_name ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_destination_name')]) !!}
                                                    @if ($errors->has('destination_name'))
                                                        <span class="help-block"><small>{{ $errors->first('destination_name') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12 hidden">
                                                <div class="form-group form-group-sm{{ $errors->has('destination_station_type_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('destination_station_type_id', __('sales/customer_transfer.entry_destination_station_type_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('destination_station_type_id', $station_types,old('destination_station_type_id',($customer_transfer_transfer->destination_station_type_id ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('destination_vstation_type_id'))
                                                        <span class="help-block"><small>{{ $errors->first('destination_station_type_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12 hidden">
                                                <div class="form-group form-group-sm{{ $errors->has('destination_station_id') ? ' has-error' : '' }}">
                                                    @php
                                                        $tmp_destination_stations = [];
                                                        if(!empty(old('destination_station_id',($customer_transfer_transfer->destination_station_id ?? '')))){
                                                            $tmp_destination_stations = \App\Models\Catalogs\Station::where('id','=',old('destination_station_id',($customer_transfer_transfer->destination_station_id ?? '')))->get()->pluck('text_select2','id');
                                                        }
                                                    @endphp
                                                    {!! html_entity_decode(Form::label('destination_station_id', __('sales/customer_transfer.entry_destination_station_id')  . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('destination_station_id', $tmp_destination_stations,old('destination_station_id',($customer_transfer_transfer->destination_station_id ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('destination_station_id'))
                                                        <span class="help-block"><small>{{ $errors->first('destination_station_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12 hidden">
                                                <div class="form-group form-group-sm{{ $errors->has('destination_traffic_navigation') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('destination_traffic_navigation', __('sales/customer_transfer.entry_destination_traffic_navigation') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('destination_traffic_navigation', $traffic_navigations,old('destination_station_type_id',($customer_transfer_transfer->destination_traffic_navigation ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('destination_traffic_navigation'))
                                                        <span class="help-block"><small>{{ $errors->first('destination_traffic_navigation') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('destination_tr_country_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('destination_tr_country_id', __('sales/customer_transfer.entry_destination_tr_country_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('destination_tr_country_id', $countries2,old('destination_tr_country_id',($customer_transfer_transfer->destination_tr_country_id ?? '')), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('destination_tr_country_id'))
                                                        <span class="help-block"><small>{{ $errors->first('destination_tr_country_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('destination_numid') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('destination_numid', __('sales/customer_transfer.entry_destination_numid') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('destination_numid', old('destination_numid',($customer_transfer_transfer->destination_numid ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_destination_numid')]) !!}
                                                    @if ($errors->has('destination_numid'))
                                                        <span class="help-block"><small>{{ $errors->first('destination_numid') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            </div>
                                            <div class="row">
                                            <div class="col-md-12 col-xs-12">
                                                <hr class="divider">
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('destination_address_1', __('sales/customer_transfer.entry_destination_address_1') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('destination_address_1', old('destination_address_1',($customer_transfer_transfer->destination_address_1 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_destination_address_1')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('destination_address_2', __('sales/customer_transfer.entry_destination_address_2') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('destination_address_2', old('destination_address_2',($customer_transfer_transfer->destination_address_2 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_destination_address_2')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('destination_address_3', __('sales/customer_transfer.entry_destination_address_3') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('destination_address_3', old('destination_address_3',($customer_transfer_transfer->destination_address_3 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_destination_address_3')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('destination_address_4', __('sales/customer_transfer.entry_destination_address_4') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('destination_address_4', old('destination_address_4',($customer_transfer_transfer->destination_address_4 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_destination_address_4')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('destination_address_5', __('sales/customer_transfer.entry_destination_address_5') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('destination_address_5', old('destination_address_5',($customer_transfer_transfer->destination_address_5 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_destination_address_5')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-9 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('destination_address_6', __('sales/customer_transfer.entry_destination_address_6') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('destination_address_6', old('destination_address_6',($customer_transfer_transfer->destination_address_6 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_destination_address_6')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('destination_country_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('destination_country_id', __('sales/customer_transfer.entry_destination_country_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('destination_country_id', $countries,old('destination_country_id',($customer_transfer_transfer->destination_country_id ?? \App\Models\Catalogs\Country::whereCode('MEX')->first()->id)), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select'),'required']) !!}
                                                    @if ($errors->has('destination_country_id'))
                                                        <span class="help-block"><small>{{ $errors->first('destination_country_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('destination_state_id', __('sales/customer_transfer.entry_destination_state_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('destination_state_id', [],null, ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select'),'required']) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('destination_city_id', __('sales/customer_transfer.entry_destination_city_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('destination_city_id', [],null, ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('destination_postcode', __('sales/customer_transfer.entry_destination_postcode') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('destination_postcode', old('destination_postcode', ($customer_transfer_transfer->destination_postcode ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_destination_postcode'),'required']) !!}
                                                </div>
                                            </div>
                                            </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade in" id="tab_transfers"
                                         aria-labelledby="transfers-tab">
                                        <div class="row hidden" style="margin-bottom: 10px;">
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('date_delivery') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('date_delivery', __('sales/customer_transfer.entry_date_delivery') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    <div class="input-group input-group-sm">
                                                        {!! Form::text('date_delivery', old('date_delivery'), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_date_delivery'),'autocomplete'=>'off']) !!}
                                                        <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    </div>
                                                    @if ($errors->has('date_delivery'))
                                                        <span class="help-block"><small>{{ $errors->first('date_delivery') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('valid_amount') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('valid_amount', __('sales/customer_transfer.entry_valid_amount') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('valid_amount', old('valid_amount'), ['class' => 'form-control text-right', 'placeholder' => __('sales/customer_transfer.entry_valid_amount'),'required', 'step' => 'any', 'autocomplete' => 'off']) !!}
                                                    @if ($errors->has('valid_amount'))
                                                        <span class="help-block"><small>{{ $errors->first('valid_amount') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('dangerous_material', __('sales/customer_transfer.entry_dangerous_material') , ['class' => 'control-label'])) !!}
                                                    <br/>
                                                    <label>
                                                        {!! Form::checkbox('dangerous_material', '1',(!empty(old('dangerous_material',$customer_transfer->status)) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row" style="margin-bottom: 10px;">
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('measure_packaging_id') ? ' has-error' : '' }}">
                                                    @php
                                                        $tmp_measure_packagings = [];
                                                        if(!empty(old('measure_packaging_id',($customer_transfer_transfer->measure_packaging_id ?? '')))){
                                                            $tmp_measure_packagings = \App\Models\Catalogs\MeasurePackaging::where('id','=',old('measure_packaging_id',($customer_transfer_transfer->measure_packaging_id ?? '')))->get()->pluck('text_select2','id');
                                                        }
                                                    @endphp
                                                    {!! html_entity_decode(Form::label('measure_packaging_id', __('sales/customer_transfer.entry_measure_packaging_id')  . '  <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('measure_packaging_id', $tmp_measure_packagings,old('measure_packaging_id',($customer_transfer_transfer->measure_packaging_id ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select'), 'required']) !!}
                                                    @if ($errors->has('measure_packaging_id'))
                                                        <span class="help-block"><small>{{ $errors->first('measure_packaging_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('gross_weight') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('gross_weight', __('sales/customer_transfer.entry_gross_weight') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('gross_weight', old('gross_weight',($customer_transfer_transfer->gross_weight ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_gross_weight'), 'step' => 'any', 'autocomplete' => 'off', 'required']) !!}
                                                    @if ($errors->has('gross_weight'))
                                                        <span class="help-block"><small>{{ $errors->first('gross_weight') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('net_weight') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('net_weight', __('sales/customer_transfer.entry_net_weight') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('net_weight', old('net_weight',($customer_transfer_transfer->net_weight ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_net_weight'), 'step' => 'any', 'autocomplete' => 'off']) !!}
                                                    @if ($errors->has('net_weight'))
                                                        <span class="help-block"><small>{{ $errors->first('net_weight') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('appraisal_fee') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('appraisal_fee', __('sales/customer_transfer.entry_appraisal_fee') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('appraisal_fee', old('appraisal_fee',($customer_transfer_transfer->appraisal_fee ? round($customer_transfer_transfer->appraisal_fee,2) : '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_appraisal_fee'), 'step' => 'any', 'autocomplete' => 'off']) !!}
                                                    @if ($errors->has('appraisal_fee'))
                                                        <span class="help-block"><small>{{ $errors->first('appraisal_fee') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12">
                                                <div class="hidden" id="delete_items_transfer">
                                                    @foreach(old('delete_item_transfer',[]) as $tmp)
                                                        <input type="hidden" name="delete_item_transfer[]" value="{{ $tmp }}"/>
                                                    @endforeach
                                                </div>
                                                <div class="table-responsive">
                                                    <table class="table table-items table-condensed table-hover table-bordered table-striped jambo_table"
                                                           id="items_transfer" style="min-width: 2300px;">
                                                        <thead>
                                                        <tr>
                                                            <th width="3%"
                                                                class="text-center">@lang('general.column_actions')</th>
                                                            <th width="7%"
                                                                class="text-center">
                                                                @lang('sales/customer_transfer.column_line_transfer_sat_product_id')
                                                                <span class="required text-danger">*</span>
                                                            </th>
                                                            <th class="text-left">
                                                                @lang('sales/customer_transfer.column_line_transfer_name')
                                                                <span class="required text-danger">*</span>
                                                            </th>
                                                            <th width="4%"
                                                                class="text-center">
                                                                @lang('sales/customer_transfer.column_line_transfer_quantity')
                                                                <span class="required text-danger">*</span>
                                                            </th>
                                                            <th width="7%"
                                                                class="text-center">
                                                                @lang('sales/customer_transfer.column_line_transfer_unit_measure_id')
                                                                <span class="required text-danger">*</span>
                                                            </th>
                                                            <th width="5%"
                                                                class="text-center">
                                                                @lang('sales/customer_transfer.column_line_transfer_weight')
                                                                <span class="required text-danger">*</span>
                                                            </th>
                                                            <th width="5%"
                                                                class="text-center">
                                                                @lang('sales/customer_transfer.column_line_transfer_dangerous_product')
                                                            </th>
                                                            <th width="7%"
                                                                class="text-center">
                                                                @lang('sales/customer_transfer.column_line_transfer_packaging_type_id')
                                                            </th>
                                                            <th width="7%"
                                                                class="text-center">
                                                                @lang('sales/customer_transfer.column_line_transfer_dangerous_product_id')
                                                            </th>
                                                            <th width="6%"
                                                                class="text-center">
                                                                @lang('sales/customer_transfer.column_line_transfer_dimensions')
                                                            </th>
                                                            <th width="5%"
                                                                class="text-center">
                                                                @lang('sales/customer_transfer.column_line_transfer_amount_total')
                                                                <span class="required text-danger">*</span>
                                                            </th>
                                                            <th width="5%"
                                                                class="text-center">
                                                                @lang('sales/customer_transfer.column_line_transfer_currency_id')
                                                                <span class="required text-danger">*</span>
                                                            </th>
                                                            <th width="7%"
                                                                class="text-center">
                                                                @lang('sales/customer_transfer.column_line_transfer_tariff_fraction_id')
                                                            </th>
                                                            <th width="6%"
                                                                class="text-center">
                                                                @lang('sales/customer_transfer.column_line_transfer_uuid_ext')
                                                            </th>
                                                            <th width="6%"
                                                                class="text-center">
                                                                @lang('sales/customer_transfer.column_line_transfer_petition')
                                                            </th>
                                                        </tr>
                                                        </thead>
                                                        <tbody><!-- Items -->
                                                        @php
                                                            $item_transfer_row = 1;
                                                            $items_transfer = old('item_transfer',$customer_transfer->customerActiveInvoiceLineTransfers);
                                                        @endphp
                                                        @foreach ($items_transfer as $item_transfer_row => $item)
                                                            @php
                                                                $item = !empty(old('item_transfer.' . $item_transfer_row . '')) ? (object) old('item_transfer.' . $item_transfer_row) : $item;

                                                                $tmp_transfer_sat_products = [];
                                                                if(!empty(old('item_transfer.' . $item_transfer_row . '.sat_product_id',$item->sat_product_id))){
                                                                    $tmp_transfer_sat_products = \App\Models\Catalogs\SatProduct::where('id','=',old('item_transfer.' . $item_transfer_row . '.sat_product_id',$item->sat_product_id))->get()->pluck('description_select2','id');
                                                                }
                                                                $tmp_transfer_unit_measures = [];
                                                                if(!empty(old('item_transfer.' . $item_transfer_row . '.unit_measure_id',$item->unit_measure_id))){
                                                                    $tmp_transfer_unit_measures = \App\Models\Catalogs\UnitMeasure::where('id','=',old('item_transfer.' . $item_transfer_row . '.unit_measure_id',$item->unit_measure_id))->get()->pluck('description_select2','id');
                                                                }
                                                                $tmp_transfer_dangerous_products = [];
                                                                if(!empty(old('item_transfer.' . $item_transfer_row . '.dangerous_product_id',$item->dangerous_product_id))){
                                                                    $tmp_transfer_dangerous_products = \App\Models\Catalogs\DangerousProduct::where('id','=',old('item_transfer.' . $item_transfer_row . '.dangerous_product_id',$item->dangerous_product_id))->get()->pluck('description_select2','id');
                                                                }
                                                                $tmp_transfer_tariff_fractions = [];
                                                                if(!empty(old('item_transfer.' . $item_transfer_row . '.tariff_fraction_id',$item->tariff_fraction_id))){
                                                                    $tmp_transfer_tariff_fractions = \App\Models\Catalogs\TariffFraction::where('id','=',old('item_transfer.' . $item_transfer_row . '.tariff_fraction_id',$item->tariff_fraction_id))->get()->pluck('description_select2','id');
                                                                }
                                                            @endphp
                                                            <tr id="item_transfer_row_{{ $item_transfer_row }}">
                                                                <td class="text-center" style="vertical-align: middle;">
                                                                    <button type="button"
                                                                            onclick="deleteItemTransfer('{{$item->id}}');$('#item_transfer_row_{{ $item_transfer_row }}').remove();"
                                                                            class="btn btn-xs btn-danger"
                                                                            style="margin-bottom: 0;">
                                                                        <i class="fa fa-trash-o"></i>
                                                                    </button>
                                                                    <!-- input hidden -->
                                                                    <input type="hidden" id="item_transfer_id_{{ $item_transfer_row }}"
                                                                           name="item_transfer[{{ $item_transfer_row }}][id]"
                                                                           value="{{ old('item_transfer.' . $item_transfer_row . '.id',$item->id) }}">
                                                                    <!-- /.input hidden -->
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_transfer.'.$item_transfer_row.'.sat_product_id') ? ' has-error' : '' }}">
                                                                        {!! Form::select('item_transfer[' . $item_transfer_row . '][sat_product_id]', $tmp_transfer_sat_products,old('item_transfer.' . $item_transfer_row . '.sat_product_id',$item->sat_product_id), ['class' => 'form-control input-sm col-transfer-sat-product-id', 'placeholder' => __('general.text_select'),'id' => 'item_transfer_sat_product_id_' . $item_transfer_row, 'required']) !!}
                                                                        @if ($errors->has('item_transfer.'.$item_transfer_row.'.sat_product_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_transfer.'.$item_transfer_row.'.sat_product_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_transfer.'.$item_transfer_row.'.name') ? ' has-error' : '' }}">
                                                                        {!! Form::textarea('item_transfer[' . $item_transfer_row . '][name]', old('item_transfer.' . $item_transfer_row . '.name',$item->name), ['class' => 'form-control input-sm ym-auto-resize col-transfer-name-id', 'required','autocomplete'=>'off','id' => 'item_transfer_name_' . $item_transfer_row, 'placeholder' => __('sales/customer_transfer.column_line_transfer_name'),'rows' => 2, 'maxlength' => 1000]) !!}
                                                                        @if ($errors->has('item_transfer.'.$item_transfer_row.'.name'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_transfer.'.$item_transfer_row.'.name') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_transfer.'.$item_transfer_row.'.quantity') ? ' has-error' : '' }}">
                                                                        {!! Form::number('item_transfer[' . $item_transfer_row . '][quantity]', old('item_transfer.' . $item_transfer_row . '.quantity',round($item->quantity,5)), ['class' => 'form-control input-sm text-right col-transfer-quantity','id' => 'item_transfer_quantity_' . $item_transfer_row, 'step' => 'any', 'required']) !!}
                                                                        @if ($errors->has('item_transfer.'.$item_transfer_row.'.quantity'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_transfer.'.$item_transfer_row.'.quantity') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_transfer.'.$item_transfer_row.'.unit_measure_id') ? ' has-error' : '' }}">
                                                                        {!! Form::select('item_transfer[' . $item_transfer_row . '][unit_measure_id]', $tmp_transfer_unit_measures,old('item_transfer.' . $item_transfer_row . '.unit_measure_id',$item->unit_measure_id), ['class' => 'form-control input-sm col-transfer-unit-measure-id', 'placeholder' => __('general.text_select'),'id' => 'item_transfer_unit_measure_id_' . $item_transfer_row, 'required']) !!}
                                                                        @if ($errors->has('item_transfer.'.$item_transfer_row.'.unit_measure_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_transfer.'.$item_transfer_row.'.unit_measure_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_transfer.'.$item_transfer_row.'.weight') ? ' has-error' : '' }}">
                                                                        {!! Form::number('item_transfer[' . $item_transfer_row . '][weight]', old('item_transfer.' . $item_transfer_row . '.weight',$item->weight), ['class' => 'form-control input-sm text-center col-transfer-weight','id' => 'item_transfer_weight_' . $item_transfer_row]) !!}
                                                                        @if ($errors->has('item_transfer.'.$item_transfer_row.'.weight'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_transfer.'.$item_transfer_row.'.weight') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm">
                                                                        {!! Form::select('item_transfer[' . $item_transfer_row . '][dangerous_product]', $yes_nos,old('item_transfer.' . $item_transfer_row . '.dangerous_product',$item->dangerous_product), ['class' => 'form-control input-sm col-transfer-dangerous-product', 'placeholder' => __('general.text_select'),'id' => 'item_transfer_dangerous_product_' . $item_transfer_row]) !!}
                                                                        @if ($errors->has('item_transfer.'.$item_transfer_row.'.dangerous_product'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_transfer.'.$item_transfer_row.'.dangerous_product') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_transfer.'.$item_transfer_row.'.dangerous_product_id') ? ' has-error' : '' }}">
                                                                        {!! Form::select('item_transfer[' . $item_transfer_row . '][packaging_type_id]', $packaging_types,old('item_transfer.' . $item_transfer_row . '.packaging_type_id',$item->packaging_type_id), ['class' => 'form-control input-sm my-select2 col-transfer-packaging-type-id', 'placeholder' => __('general.text_select'),'id' => 'item_transfer_packaging_type_id_' . $item_transfer_row]) !!}
                                                                        @if ($errors->has('item_transfer.'.$item_transfer_row.'.packaging_type_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_transfer.'.$item_transfer_row.'.packaging_type_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_transfer.'.$item_transfer_row.'.dangerous_product_id') ? ' has-error' : '' }}">
                                                                        {!! Form::select('item_transfer[' . $item_transfer_row . '][dangerous_product_id]', $tmp_transfer_dangerous_products,old('item_transfer.' . $item_transfer_row . '.dangerous_product_id',$item->dangerous_product_id), ['class' => 'form-control input-sm col-transfer-dangerous-product-id', 'placeholder' => __('general.text_select'),'id' => 'item_transfer_dangerous_product_id_' . $item_transfer_row]) !!}
                                                                        @if ($errors->has('item_transfer.'.$item_transfer_row.'.dangerous_product_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_transfer.'.$item_transfer_row.'.dangerous_product_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_transfer.'.$item_transfer_row.'.dimensions') ? ' has-error' : '' }}">
                                                                        {!! Form::text('item_transfer[' . $item_transfer_row . '][dimensions]', old('item_transfer.' . $item_transfer_row . '.dimensions',$item->dimensions), ['class' => 'form-control input-sm col-transfer-dimensions','id' => 'item_transfer_dimensions_' . $item_transfer_row]) !!}
                                                                        @if ($errors->has('item_transfer.'.$item_transfer_row.'.dimensions'))
                                                                            <span class="help-block"><small>{{ $errors->first('item.'.$item_transfer_row.'.dimensions') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_transfer.'.$item_transfer_row.'.amount_total') ? ' has-error' : '' }}">
                                                                        {!! Form::number('item_transfer[' . $item_transfer_row . '][amount_total]', old('item_transfer.' . $item_transfer_row . '.amount_total',round($item->amount_total,2)), ['class' => 'form-control input-sm text-right col-transfer-amount_total','id' => 'item_transfer_amount_total_' . $item_transfer_row, 'step' => 'any']) !!}
                                                                        @if ($errors->has('item_transfer.'.$item_transfer_row.'.amount_total'))
                                                                            <span class="help-block"><small>{{ $errors->first('item.'.$item_transfer_row.'.amount_total') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm">
                                                                        {!! Form::select('item_transfer[' . $item_transfer_row . '][currency_id]', $currencies,old('item_transfer.' . $item_transfer_row . '.currency_id',$item->currency_id), ['class' => 'form-control input-sm col-transfer-currency-id', 'placeholder' => __('general.text_select'),'id' => 'item_transfer_currency_id_' . $item_transfer_row]) !!}
                                                                        @if ($errors->has('item_transfer.'.$item_transfer_row.'.currency_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_transfer.'.$item_transfer_row.'.currency_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_transfer.'.$item_transfer_row.'.tariff_fraction_id') ? ' has-error' : '' }}">
                                                                        {!! Form::select('item_transfer[' . $item_transfer_row . '][tariff_fraction_id]', $tmp_transfer_tariff_fractions,old('item_transfer.' . $item_transfer_row . '.tariff_fraction_id',$item->tariff_fraction_id), ['class' => 'form-control input-sm col-transfer-tariff-fraction-id', 'placeholder' => __('general.text_select'),'id' => 'item_transfer_tariff_fraction_id_' . $item_transfer_row]) !!}
                                                                        @if ($errors->has('item_transfer.'.$item_transfer_row.'.tariff_fraction_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_transfer.'.$item_transfer_row.'.tariff_fraction_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_transfer.'.$item_transfer_row.'.uuid_ext') ? ' has-error' : '' }}">
                                                                        {!! Form::text('item_transfer[' . $item_transfer_row . '][uuid_ext]', old('item_transfer.' . $item_transfer_row . '.uuid_ext',$item->uuid_ext), ['class' => 'form-control input-sm col-transfer-uuid-ext','id' => 'item_transfer_uuid_ext_' . $item_transfer_row]) !!}
                                                                        @if ($errors->has('item_transfer.'.$item_transfer_row.'.uuid_ext'))
                                                                            <span class="help-block"><small>{{ $errors->first('item.'.$item_transfer_row.'.uuid_ext') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_transfer.'.$item_transfer_row.'.petition') ? ' has-error' : '' }}">
                                                                        {!! Form::text('item_transfer[' . $item_transfer_row . '][petition]', old('item_transfer.' . $item_transfer_row . '.petition',$item->petition), ['class' => 'form-control input-sm col-transfer-uuid-ext','id' => 'item_transfer_petition_' . $item_transfer_row, 'maxlength' => 21]) !!}
                                                                        @if ($errors->has('item_transfer.'.$item_transfer_row.'.petition'))
                                                                            <span class="help-block"><small>{{ $errors->first('item.'.$item_transfer_row.'.petition') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                        @php
                                                            $item_transfer_row++;
                                                        @endphp
                                                        <!-- /Items -->
                                                        <!-- Agregar nuevo item -->
                                                        <tr id="add_item_transfer">
                                                            <td class="text-center">
                                                                <button type="button" onclick="addItemTransfer();"
                                                                        class="btn btn-xs btn-primary"
                                                                        style="margin-bottom: 0;">
                                                                    <i class="fa fa-plus"></i>
                                                                </button>
                                                            </td>
                                                            <td class="text-right" colspan="15"></td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade in" id="tab_transport"
                                    aria-labelledby="transport-tab">
                                        <div class="row transport_type_01">
                                            <div class="col-md-12 col-xs-12">
                                                <div class="row">
                                                    <div class="col-md-12 col-xs-12 pb-2">
                                                        <h3>{{__('sales/customer_transfer.text_transport_type_01')}}</h3>
                                                    </div>
                                                    <div class="col-md-3 col-xs-12">
                                                        <div class="form-group form-group-sm{{ $errors->has('permit_type_id') ? ' has-error' : '' }}">
                                                            {!! html_entity_decode(Form::label('permit_type_id', __('sales/customer_transfer.entry_permit_type_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                            {!! Form::select('permit_type_id', $permit_types,old('permit_type_id',($customer_transfer_transfer->permit_type_id ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select'), 'required']) !!}
                                                            @if ($errors->has('permit_type_id'))
                                                                <span class="help-block"><small>{{ $errors->first('permit_type_id') }}</small></span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3 col-xs-12">
                                                        <div class="form-group form-group-sm{{ $errors->has('permit_number') ? ' has-error' : '' }}">
                                                            {!! html_entity_decode(Form::label('permit_number', __('sales/customer_transfer.entry_permit_number') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                            {!! Form::text('permit_number', old('permit_number',($customer_transfer_transfer->permit_number ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_permit_number'), 'required', 'maxlength' => 50]) !!}
                                                            @if ($errors->has('permit_number'))
                                                                <span class="help-block"><small>{{ $errors->first('permit_number') }}</small></span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3 col-xs-12">
                                                        <div class="form-group form-group-sm{{ $errors->has('setting_transport_id') ? ' has-error' : '' }}">
                                                            {!! html_entity_decode(Form::label('setting_transport_id', __('sales/customer_transfer.entry_setting_transport_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                            {!! Form::select('setting_transport_id', $setting_transports,old('setting_transport_id',($customer_transfer_transfer->setting_transport_id ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select'), 'required']) !!}
                                                            @if ($errors->has('setting_transport_id'))
                                                                <span class="help-block"><small>{{ $errors->first('setting_transport_id') }}</small></span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3 col-xs-12">
                                                        <div class="row">
                                                            <div class="col-md-6 col-xs-12">
                                                                <div class="form-group form-group-sm{{ $errors->has('vehicle') ? ' has-error' : '' }}">
                                                                    {!! html_entity_decode(Form::label('vehicle', __('sales/customer_transfer.entry_vehicle') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                                    {!! Form::number('vehicle', old('vehicle',($customer_transfer_transfer->vehicle ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_vehicle'), 'required', 'maxlength' => 4]) !!}
                                                                    @if ($errors->has('vehicle'))
                                                                        <span class="help-block"><small>{{ $errors->first('vehicle') }}</small></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                            <div class="col-md-6 col-xs-12">
                                                                <div class="form-group form-group-sm{{ $errors->has('vehicle_number') ? ' has-error' : '' }}">
                                                                    {!! html_entity_decode(Form::label('vehicle_number', __('sales/customer_transfer.entry_vehicle_number') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('vehicle_number', old('vehicle_number',($customer_transfer_transfer->vehicle_number ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_vehicle_number'), 'required', 'maxlength' => 7]) !!}
                                                                    @if ($errors->has('vehicle_number'))
                                                                        <span class="help-block"><small>{{ $errors->first('vehicle_number') }}</small></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 col-xs-12">
                                                        <div class="form-group form-group-sm{{ $errors->has('name_insurer') ? ' has-error' : '' }}">
                                                            {!! html_entity_decode(Form::label('name_insurer', __('sales/customer_transfer.entry_name_insurer') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                            {!! Form::text('name_insurer', old('name_insurer',($customer_transfer_transfer->name_insurer ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_name_insurer'), 'required', 'maxlength' => 50]) !!}
                                                            @if ($errors->has('name_insurer'))
                                                                <span class="help-block"><small>{{ $errors->first('name_insurer') }}</small></span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 col-xs-12">
                                                        <div class="form-group form-group-sm{{ $errors->has('policy_number') ? ' has-error' : '' }}">
                                                            {!! html_entity_decode(Form::label('policy_number', __('sales/customer_transfer.entry_policy_number') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                            {!! Form::text('policy_number', old('policy_number',($customer_transfer_transfer->policy_number ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_policy_number'), 'required', 'maxlength' => 30]) !!}
                                                            @if ($errors->has('policy_number'))
                                                                <span class="help-block"><small>{{ $errors->first('policy_number') }}</small></span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 col-xs-12">
                                                        <div class="form-group form-group-sm{{ $errors->has('name_insurer2') ? ' has-error' : '' }}">
                                                            {!! html_entity_decode(Form::label('name_insurer2', __('sales/customer_transfer.entry_name_insurer2') . '', ['class' => 'control-label'])) !!}
                                                            {!! Form::text('name_insurer2', old('name_insurer2',($customer_transfer_transfer->name_insurer2 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_name_insurer2'), 'maxlength' => 50]) !!}
                                                            @if ($errors->has('name_insurer2'))
                                                                <span class="help-block"><small>{{ $errors->first('name_insurer2') }}</small></span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 col-xs-12">
                                                        <div class="form-group form-group-sm{{ $errors->has('policy_number2') ? ' has-error' : '' }}">
                                                            {!! html_entity_decode(Form::label('policy_number2', __('sales/customer_transfer.entry_policy_number2') . '', ['class' => 'control-label'])) !!}
                                                            {!! Form::text('policy_number2', old('policy_number2',($customer_transfer_transfer->policy_number2 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_policy_number2'), 'maxlength' => 30]) !!}
                                                            @if ($errors->has('policy_number2'))
                                                                <span class="help-block"><small>{{ $errors->first('policy_number2') }}</small></span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 col-xs-12">
                                                        <div class="form-group form-group-sm{{ $errors->has('name_insurer3') ? ' has-error' : '' }}">
                                                            {!! html_entity_decode(Form::label('name_insurer3', __('sales/customer_transfer.entry_name_insurer3') . '', ['class' => 'control-label'])) !!}
                                                            {!! Form::text('name_insurer3', old('name_insurer3',($customer_transfer_transfer->name_insurer3 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_name_insurer3'), 'maxlength' => 50]) !!}
                                                            @if ($errors->has('name_insurer3'))
                                                                <span class="help-block"><small>{{ $errors->first('name_insurer3') }}</small></span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 col-xs-12">
                                                        <div class="form-group form-group-sm{{ $errors->has('policy_number3') ? ' has-error' : '' }}">
                                                            {!! html_entity_decode(Form::label('policy_number3', __('sales/customer_transfer.entry_policy_number3') . '', ['class' => 'control-label'])) !!}
                                                            {!! Form::text('policy_number3', old('policy_number3',($customer_transfer_transfer->policy_number3 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_policy_number3'), 'maxlength' => 30]) !!}
                                                            @if ($errors->has('policy_number3'))
                                                                <span class="help-block"><small>{{ $errors->first('policy_number3') }}</small></span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3 col-xs-12">
                                                        <div class="form-group form-group-sm{{ $errors->has('insurance_value') ? ' has-error' : '' }}">
                                                            {!! html_entity_decode(Form::label('insurance_value', __('sales/customer_transfer.entry_insurance_value') . '', ['class' => 'control-label'])) !!}
                                                            {!! Form::number('insurance_value', old('insurance_value',($customer_transfer_transfer->insurance_value ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_insurance_value'), 'step' => 'any']) !!}
                                                            @if ($errors->has('insurance_value'))
                                                                <span class="help-block"><small>{{ $errors->first('insurance_value') }}</small></span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-12 col-xs-12">
                                                        <h4>{{__('sales/customer_transfer.entry_trailers')}}</h4>
                                                    </div>
                                                    <div class="col-md-6 col-xs-12">
                                                        <div class="table-responsive">
                                                            <table class="table table-items table-condensed table-hover table-bordered table-striped"
                                                                id="items_trailer">
                                                                <thead>
                                                                <tr>
                                                                    <th width="50%" class="text-center">
                                                                        @lang('sales/customer_transfer.entry_trailer_type_id')
                                                                    </th>
                                                                    <th width="50%" class="text-center">
                                                                        @lang('sales/customer_transfer.entry_trailer_number')
                                                                    </th>
                                                                </tr>
                                                                </thead>
                                                                <tbody><!-- Items -->
                                                                    <tr id="">
                                                                        <td>
                                                                            <div class="form-group form-group-sm{{ $errors->has('trailer_type_id_1') ? ' has-error' : '' }}">
                                                                                {!! Form::select('trailer_type_id_1', $trailer_types,old('trailer_type_id_1',($customer_transfer_transfer->trailer_type_id_1 ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                                                @if ($errors->has('trailer_type_id_1'))
                                                                                    <span class="help-block"><small>{{ $errors->first('trailer_type_id_1') }}</small></span>
                                                                                @endif
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="form-group form-group-sm{{ $errors->has('trailer_number_1') ? ' has-error' : '' }}">
                                                                                {!! Form::text('trailer_number_1', old('trailer_number_1',($customer_transfer_transfer->trailer_number_1 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_trailer_number'), 'maxlength' => 7]) !!}
                                                                                @if ($errors->has('trailer_number_1'))
                                                                                    <span class="help-block"><small>{{ $errors->first('trailer_number_1') }}</small></span>
                                                                                @endif
                                                                            </div>
                                                                        </td>
                                                                    </tr>
                                                                    <tr id="">
                                                                        <td>
                                                                            <div class="form-group form-group-sm{{ $errors->has('trailer_type_id_2') ? ' has-error' : '' }}">
                                                                                {!! Form::select('trailer_type_id_2', $trailer_types,old('trailer_type_id_2',($customer_transfer_transfer->trailer_type_id_2 ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                                                @if ($errors->has('trailer_type_id_2'))
                                                                                    <span class="help-block"><small>{{ $errors->first('trailer_type_id_2') }}</small></span>
                                                                                @endif
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="form-group form-group-sm{{ $errors->has('trailer_number_2') ? ' has-error' : '' }}">
                                                                                {!! Form::text('trailer_number_2', old('trailer_number_2',($customer_transfer_transfer->trailer_number_2 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_trailer_number'), 'maxlength' => 7]) !!}
                                                                                @if ($errors->has('trailer_number_2'))
                                                                                    <span class="help-block"><small>{{ $errors->first('trailer_number_2') }}</small></span>
                                                                                @endif
                                                                            </div>
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>
                                                                            <div class="form-group form-group-sm{{ $errors->has('trailer_type_id_3') ? ' has-error' : '' }}">
                                                                                {!! Form::select('trailer_type_id_3', $trailer_types,old('trailer_type_id_3',($customer_transfer_transfer->trailer_type_id_3 ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                                                @if ($errors->has('trailer_type_id_3'))
                                                                                    <span class="help-block"><small>{{ $errors->first('trailer_type_id_3') }}</small></span>
                                                                                @endif
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="form-group form-group-sm{{ $errors->has('trailer_number_3') ? ' has-error' : '' }}">
                                                                                {!! Form::text('trailer_number_3', old('trailer_number_3',($customer_transfer_transfer->trailer_number_3 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_trailer_number'), 'maxlength' => 7]) !!}
                                                                                @if ($errors->has('trailer_number_3'))
                                                                                    <span class="help-block"><small>{{ $errors->first('trailer_number_3') }}</small></span>
                                                                                @endif
                                                                            </div>
                                                                        </td>
                                                                    </tr>
                                                                    <tr class="hidden">
                                                                        <td>
                                                                            <div class="form-group form-group-sm{{ $errors->has('trailer_type_id_4') ? ' has-error' : '' }}">
                                                                                {!! Form::select('trailer_type_id_4', $trailer_types,old('trailer_type_id_4',($customer_transfer_transfer->trailer_type_id_4 ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                                                @if ($errors->has('trailer_type_id_4'))
                                                                                    <span class="help-block"><small>{{ $errors->first('trailer_type_id_4') }}</small></span>
                                                                                @endif
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="form-group form-group-sm{{ $errors->has('trailer_number_4') ? ' has-error' : '' }}">
                                                                                {!! Form::text('trailer_number_4', old('trailer_number_4',($customer_transfer_transfer->trailer_number_4 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_trailer_number'), 'maxlength' => 7]) !!}
                                                                                @if ($errors->has('trailer_number_4'))
                                                                                    <span class="help-block"><small>{{ $errors->first('trailer_number_4') }}</small></span>
                                                                                @endif
                                                                            </div>
                                                                        </td>
                                                                    </tr>
                                                                    <tr class="hidden">
                                                                        <td>
                                                                            <div class="form-group form-group-sm{{ $errors->has('trailer_type_id_5') ? ' has-error' : '' }}">
                                                                                {!! Form::select('trailer_type_id_5', $trailer_types,old('trailer_type_id_5',($customer_transfer_transfer->trailer_type_id_5 ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                                                @if ($errors->has('trailer_type_id_5'))
                                                                                    <span class="help-block"><small>{{ $errors->first('trailer_type_id_5') }}</small></span>
                                                                                @endif
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="form-group form-group-sm{{ $errors->has('trailer_number_5') ? ' has-error' : '' }}">
                                                                                {!! Form::text('trailer_number_5', old('trailer_number_5',($customer_transfer_transfer->trailer_number_5 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_trailer_number'), 'maxlength' => 7]) !!}
                                                                                @if ($errors->has('trailer_number_5'))
                                                                                    <span class="help-block"><small>{{ $errors->first('trailer_number_5') }}</small></span>
                                                                                @endif
                                                                            </div>
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade in" id="tab_products"
                                         aria-labelledby="products-tab">
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12">
                                                <div class="hidden" id="delete_items">
                                                    @foreach(old('delete_item',[]) as $tmp)
                                                        <input type="hidden" name="delete_item[]" value="{{ $tmp }}"/>
                                                    @endforeach
                                                </div>
                                                <div class="table-responsive">
                                                    <table class="table table-items table-condensed table-hover table-bordered table-striped jambo_table"
                                                           id="items" style="min-width: 1400px;">
                                                        <thead>
                                                        <tr>
                                                            <th width="5%"
                                                                class="text-center">@lang('general.column_actions')</th>
                                                            <th width="11%"
                                                                class="text-center">@lang('sales/customer_transfer.column_line_product_id')</th>
                                                            <th class="text-left">
                                                                @lang('sales/customer_transfer.column_line_name')
                                                                <span class="required text-danger">*</span>
                                                            </th>
                                                            <th width="10%"
                                                                class="text-center">
                                                                @lang('sales/customer_transfer.column_line_unit_measure_id')
                                                                <span class="required text-danger">*</span>
                                                            </th>
                                                            <th width="12%"
                                                                class="text-center">
                                                                @lang('sales/customer_transfer.column_line_sat_product_id')
                                                                <span class="required text-danger">*</span>
                                                            </th>
                                                            <th width="5%"
                                                                class="text-center">
                                                                @lang('sales/customer_transfer.column_line_quantity')
                                                                <span class="required text-danger">*</span>
                                                            </th>
                                                            <th width="7%"
                                                                class="text-center">
                                                                @lang('sales/customer_transfer.column_line_price_unit')
                                                                <span class="required text-danger">*</span>
                                                            </th>
                                                            <th width="5%"
                                                                class="text-center text-nowrap">@lang('sales/customer_transfer.column_line_discount')</th>
                                                            <th width="10%"
                                                                class="text-center">@lang('sales/customer_transfer.column_line_taxes')</th>
                                                            <th width="6%" class="text-center">@lang('sales/customer_transfer.column_line_tax_object')</th>
                                                            <th width="6%"
                                                                class="text-right">@lang('sales/customer_transfer.column_line_amount_untaxed')</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <!-- Items -->
                                                        @php
                                                            $item_row = 1;
                                                            $items = old('item',$customer_transfer->customerActiveInvoiceLines);
                                                        @endphp
                                                        @foreach ($items as $item_row => $item)
                                                            @php
                                                                $item = !empty(old('item.' . $item_row . '')) ? (object) old('item.' . $item_row) : $item;

                                                                $tmp_products = [];
                                                                if(!empty(old('item.' . $item_row . '.product_id',$item->product_id))){
                                                                    $tmp_products = \App\Models\Catalogs\Product::where('id','=',old('item.' . $item_row . '.product_id',$item->product_id))->get()->pluck('text_select2','id');
                                                                }
                                                                $tmp_unit_measures = [];
                                                                if(!empty(old('item.' . $item_row . '.unit_measure_id',$item->unit_measure_id))){
                                                                    $tmp_unit_measures = \App\Models\Catalogs\UnitMeasure::where('id','=',old('item.' . $item_row . '.unit_measure_id',$item->unit_measure_id))->get()->pluck('description_select2','id');
                                                                }
                                                                $tmp_sat_products = [];
                                                                if(!empty(old('item.' . $item_row . '.sat_product_id',$item->sat_product_id))){
                                                                    $tmp_sat_products = \App\Models\Catalogs\SatProduct::where('id','=',old('item.' . $item_row . '.sat_product_id',$item->sat_product_id))->get()->pluck('description_select2','id');
                                                                }
                                                            @endphp
                                                            <tr id="item_row_{{ $item_row }}">
                                                                <td class="text-center" style="vertical-align: middle;">
                                                                    <button type="button"
                                                                            onclick="deleteItem('{{$item->id}}');$('#item_row_{{ $item_row }}').remove(); totalItem();"
                                                                            class="btn btn-xs btn-danger"
                                                                            style="margin-bottom: 0;">
                                                                        <i class="fa fa-trash-o"></i>
                                                                    </button>
                                                                    <!-- input hidden -->
                                                                    <input type="hidden" id="item_id_{{ $item_row }}"
                                                                           name="item[{{ $item_row }}][id]"
                                                                           value="{{ old('item.' . $item_row . '.id',$item->id) }}">
                                                                    <!-- /.input hidden -->
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm">
                                                                        <div class="input-group input-group-sm">
                                                                        {!! Form::select('item[' . $item_row . '][product_id]', $tmp_products,old('item.' . $item_row . '.product_id',$item->product_id), ['class' => 'form-control input-sm col-product-id', 'placeholder' => __('general.text_select'),'id' => 'item_product_id_' . $item_row,'data-row' => $item_row]) !!}
                                                                            <span class="input-group-btn">
                                                                                <button type="button" class="btn btn-info btn-product-search" data-row="{{ $item_row }}"><i class="fa fa-search"></i></button>
                                                                            </span>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item.'.$item_row.'.name') ? ' has-error' : '' }}">
                                                                        {!! Form::textarea('item[' . $item_row . '][name]', old('item.' . $item_row . '.name',$item->name), ['class' => 'form-control input-sm ym-auto-resize col-name-id', 'required','autocomplete'=>'off','id' => 'item_name_' . $item_row, 'placeholder' => __('sales/customer_transfer.column_line_name'),'rows' => 2, 'maxlength' => 1000]) !!}
                                                                        @if ($errors->has('item.'.$item_row.'.name'))
                                                                            <span class="help-block"><small>{{ $errors->first('item.'.$item_row.'.name') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item.'.$item_row.'.unit_measure_id') ? ' has-error' : '' }}">
                                                                        <div class="input-group input-group-sm">
                                                                            {!! Form::select('item[' . $item_row . '][unit_measure_id]', $tmp_unit_measures,old('item.' . $item_row . '.unit_measure_id',$item->unit_measure_id), ['class' => 'form-control input-sm col-unit-measure-id', 'placeholder' => __('general.text_select'),'required','id' => 'item_unit_measure_id_' . $item_row]) !!}
                                                                            <span class="input-group-btn">
                                                                                <button type="button" class="btn btn-info btn-unit-measure-search" data-row="{{ $item_row }}"><i class="fa fa-search"></i></button>
                                                                            </span>
                                                                        </div>
                                                                        @if ($errors->has('item.'.$item_row.'.unit_measure_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item.'.$item_row.'.unit_measure_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item.'.$item_row.'.sat_product_id') ? ' has-error' : '' }}">
                                                                        <div class="input-group input-group-sm">
                                                                            {!! Form::select('item[' . $item_row . '][sat_product_id]', $tmp_sat_products,old('item.' . $item_row . '.sat_product_id',$item->sat_product_id), ['class' => 'form-control input-sm col-sat-product-id', 'placeholder' => __('general.text_select'),'required','id' => 'item_sat_product_id_' . $item_row]) !!}
                                                                            <span class="input-group-btn">
                                                                                <button type="button" class="btn btn-info btn-sat-product-search" data-row="{{ $item_row }}"><i class="fa fa-search"></i></button>
                                                                            </span>
                                                                        </div>
                                                                        @if ($errors->has('item.'.$item_row.'.sat_product_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item.'.$item_row.'.sat_product_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item.'.$item_row.'.quantity') ? ' has-error' : '' }}">
                                                                        {!! Form::number('item[' . $item_row . '][quantity]', old('item.' . $item_row . '.quantity',round($item->quantity,2)), ['class' => 'form-control input-sm text-right col-quantity', 'required','id' => 'item_quantity_' . $item_row, 'step' => 'any']) !!}
                                                                        @if ($errors->has('item.'.$item_row.'.quantity'))
                                                                            <span class="help-block"><small>{{ $errors->first('item.'.$item_row.'.quantity') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item.'.$item_row.'.price_unit') ? ' has-error' : '' }}">
                                                                        {!! Form::number('item[' . $item_row . '][price_unit]', old('item.' . $item_row . '.price_unit',round($item->price_unit,2)), ['class' => 'form-control input-sm text-right col-price-unit', 'required','id' => 'item_price_unit_' . $item_row, 'step' => 'any']) !!}
                                                                        @if ($errors->has('item.'.$item_row.'.price_unit'))
                                                                            <span class="help-block"><small>{{ $errors->first('item.'.$item_row.'.price_unit') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item.'.$item_row.'.discount') ? ' has-error' : '' }}">
                                                                        {!! Form::number('item[' . $item_row . '][discount]', old('item.' . $item_row . '.discount',round($item->discount,2)), ['class' => 'form-control input-sm text-center col-discount', 'id' => 'item_discount_' . $item_row, 'step' => 'any']) !!}
                                                                        @if ($errors->has('item.'.$item_row.'.discount'))
                                                                            <span class="help-block"><small>{{ $errors->first('item.'.$item_row.'.discount') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm">
                                                                        {!! Form::select('item[' . $item_row . '][taxes][]', $taxes,old('item.' . $item_row . '.taxes',$item->taxes ?? []), ['class' => 'form-control input-sm my-select2 col-taxes','multiple','id' => 'item_taxes_' . $item_row]) !!}
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm">
                                                                        {!! Form::select('item[' . $item_row . '][tax_object]', $tax_objects,old('item.' . $item_row . '.tax_object',$item->tax_object ?? ''), ['class' => 'form-control input-sm col-tax-object','id' => 'item_tax_object_' . $item_row]) !!}
                                                                    </div>
                                                                </td>
                                                                <td class="text-right" style="padding-top: 11px;">
                                                                    <span id="item_txt_amount_untaxed_{{ $item_row }}">0</span>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                        @php
                                                            $item_row++;
                                                        @endphp
                                                        <!-- /Items -->
                                                        <!-- Agregar nuevo item -->
                                                        <tr id="add_item">
                                                            <td class="text-center">
                                                                <button type="button" onclick="addItem();"
                                                                        class="btn btn-xs btn-primary"
                                                                        style="margin-bottom: 0;">
                                                                    <i class="fa fa-plus"></i>
                                                                </button>
                                                            </td>
                                                            <td class="text-right" colspan="10"></td>
                                                        </tr>
                                                        <!-- Totales -->
                                                        <tr>
                                                            <td></td>
                                                            <td class="text-right" colspan="8" rowspan="3"
                                                                style="vertical-align: middle">

                                                            </td>
                                                            <td class="text-right">
                                                                <strong>@lang('general.text_amount_untaxed')</strong>
                                                            </td>
                                                            <td class="text-right"><span id="txt_amount_untaxed">0</span>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td></td>
                                                            <td class="text-right">
                                                                <strong id="txt_amount_tax_label"></strong>
                                                            </td>
                                                            <td class="text-right">
                                                                <span id="txt_amount_tax"></span>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td></td>
                                                            <td class="text-right">
                                                                <strong>@lang('general.text_amount_total')</strong></td>
                                                            <td class="text-right"><span id="txt_amount_total">0</span></td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade in" id="tab_transport_figure"
                                    aria-labelledby="transport-figure-tab">
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12 pb-2">
                                                <div class="x_panel" style="height: auto;">
                                                    <div class="x_title">
                                                        <h4 class="">
                                                            <b>{{__('sales/customer_transfer.text_operator')}}</b>
                                                        </h4>
                                                        <div class="clearfix"></div>
                                                    </div>
                                                    <div class="x_content" style="">
                                                        <div class="row">
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="row">
                                                                    <div class="col-md-6 col-xs-12">
                                                                        <div class="form-group form-group-sm{{ $errors->has('operator_taxid') ? ' has-error' : '' }}">
                                                                            {!! html_entity_decode(Form::label('operator_taxid', __('sales/customer_transfer.entry_operator_taxid') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                                            {!! Form::text('operator_taxid', old('operator_taxid',($customer_transfer_transfer->operator_taxid ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_operator_taxid')]) !!}
                                                                            @if ($errors->has('operator_taxid'))
                                                                                <span class="help-block"><small>{{ $errors->first('operator_taxid') }}</small></span>
                                                                            @endif
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-6 col-xs-12">
                                                                        <div class="form-group form-group-sm{{ $errors->has('operator_license') ? ' has-error' : '' }}">
                                                                            {!! html_entity_decode(Form::label('operator_license', __('sales/customer_transfer.entry_operator_license') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                                            {!! Form::text('operator_license', old('operator_license',($customer_transfer_transfer->operator_license ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_operator_license')]) !!}
                                                                            @if ($errors->has('operator_license'))
                                                                                <span class="help-block"><small>{{ $errors->first('operator_license') }}</small></span>
                                                                            @endif
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm{{ $errors->has('operator_name') ? ' has-error' : '' }}">
                                                                    {!! html_entity_decode(Form::label('operator_name', __('sales/customer_transfer.entry_operator_name') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('operator_name', old('operator_name',($customer_transfer_transfer->operator_name ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_operator_name')]) !!}
                                                                    @if ($errors->has('operator_name'))
                                                                        <span class="help-block"><small>{{ $errors->first('operator_name') }}</small></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm{{ $errors->has('operator_tr_country_id') ? ' has-error' : '' }}">
                                                                    {!! html_entity_decode(Form::label('operator_tr_country_id', __('sales/customer_transfer.entry_operator_tr_country_id') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::select('operator_tr_country_id', $countries2,old('operator_tr_country_id',($customer_transfer_transfer->operator_tr_country_id ?? '')), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                                    @if ($errors->has('operator_tr_country_id'))
                                                                        <span class="help-block"><small>{{ $errors->first('operator_tr_country_id') }}</small></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm{{ $errors->has('operator_numid') ? ' has-error' : '' }}">
                                                                    {!! html_entity_decode(Form::label('operator_numid', __('sales/customer_transfer.entry_operator_numid') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('operator_numid', old('operator_numid',($customer_transfer_transfer->operator_numid ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_operator_numid')]) !!}
                                                                    @if ($errors->has('operator_numid'))
                                                                        <span class="help-block"><small>{{ $errors->first('operator_numid') }}</small></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-12 col-xs-12 pb-2">
                                                @php
                                                    $owner_taxid = old('owner_taxid',($customer_transfer_transfer->owner_taxid ?? ''));
                                                @endphp
                                                <div class="x_panel" style="height: auto;">
                                                    <div class="x_title">
                                                        <h4 class="">
                                                            <input type="checkbox" name="owner" class="collapse-link mt-1" {{!empty($owner_taxid) ? 'checked' : ''}}/>&nbsp;
                                                            <b>{{__('sales/customer_transfer.text_owner')}}</b>
                                                        </h4>
                                                        <div class="clearfix"></div>
                                                    </div>
                                                    <div class="x_content" style="display: {{!empty($owner_taxid) ? 'block' : 'none'}};" id="content_owner">
                                                        <div class="row">
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm{{ $errors->has('owner_taxid') ? ' has-error' : '' }}">
                                                                    {!! html_entity_decode(Form::label('owner_taxid', __('sales/customer_transfer.entry_owner_taxid') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('owner_taxid', old('owner_taxid',($customer_transfer_transfer->owner_taxid ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_owner_taxid')]) !!}
                                                                    @if ($errors->has('owner_taxid'))
                                                                        <span class="help-block"><small>{{ $errors->first('owner_taxid') }}</small></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm{{ $errors->has('owner_name') ? ' has-error' : '' }}">
                                                                    {!! html_entity_decode(Form::label('owner_name', __('sales/customer_transfer.entry_owner_name') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('owner_name', old('owner_name',($customer_transfer_transfer->owner_name ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_owner_name')]) !!}
                                                                    @if ($errors->has('owner_name'))
                                                                        <span class="help-block"><small>{{ $errors->first('owner_name') }}</small></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm{{ $errors->has('owner_tr_country_id') ? ' has-error' : '' }}">
                                                                    {!! html_entity_decode(Form::label('owner_tr_country_id', __('sales/customer_transfer.entry_owner_tr_country_id') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::select('owner_tr_country_id', $countries2,old('owner_tr_country_id',($customer_transfer_transfer->owner_tr_country_id ?? '')), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                                    @if ($errors->has('owner_tr_country_id'))
                                                                        <span class="help-block"><small>{{ $errors->first('owner_tr_country_id') }}</small></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm{{ $errors->has('owner_numid') ? ' has-error' : '' }}">
                                                                    {!! html_entity_decode(Form::label('owner_numid', __('sales/customer_transfer.entry_owner_numid') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('owner_numid', old('owner_numid',($customer_transfer_transfer->owner_numid ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_owner_numid')]) !!}
                                                                    @if ($errors->has('owner_numid'))
                                                                        <span class="help-block"><small>{{ $errors->first('owner_numid') }}</small></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm{{ $errors->has('owner_transport_part_id') ? ' has-error' : '' }}">
                                                                    {!! html_entity_decode(Form::label('owner_transport_part_id', __('sales/customer_transfer.entry_owner_transport_part_id') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::select('owner_transport_part_id', $transport_parts,old('owner_transport_part_id',($customer_transfer_transfer->owner_transport_part_id ?? '')), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                                    @if ($errors->has('owner_transport_part_id'))
                                                                        <span class="help-block"><small>{{ $errors->first('owner_transport_part_id') }}</small></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-12 col-xs-12">
                                                                <hr class="divider">
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm">
                                                                    {!! html_entity_decode(Form::label('owner_address_1', __('sales/customer_transfer.entry_owner_address_1') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('owner_address_1', old('owner_address_1',($customer_transfer_transfer->owner_address_1 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_owner_address_1')]) !!}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm">
                                                                    {!! html_entity_decode(Form::label('owner_address_2', __('sales/customer_transfer.entry_owner_address_2') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('owner_address_2', old('owner_address_2',($customer_transfer_transfer->owner_address_2 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_owner_address_2')]) !!}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm">
                                                                    {!! html_entity_decode(Form::label('owner_address_3', __('sales/customer_transfer.entry_owner_address_3') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('owner_address_3', old('owner_address_3',($customer_transfer_transfer->owner_address_3 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_owner_address_3')]) !!}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm">
                                                                    {!! html_entity_decode(Form::label('owner_address_4', __('sales/customer_transfer.entry_owner_address_4') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('owner_address_4', old('owner_address_4',($customer_transfer_transfer->owner_address_4 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_owner_address_4')]) !!}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm">
                                                                    {!! html_entity_decode(Form::label('owner_address_5', __('sales/customer_transfer.entry_owner_address_5') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('owner_address_5', old('owner_address_5',($customer_transfer_transfer->owner_address_5 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_owner_address_5')]) !!}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-9 col-xs-12">
                                                                <div class="form-group form-group-sm">
                                                                    {!! html_entity_decode(Form::label('owner_address_6', __('sales/customer_transfer.entry_owner_address_6') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('owner_address_6', old('owner_address_6',($customer_transfer_transfer->owner_address_6 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_owner_address_6')]) !!}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm{{ $errors->has('owner_country_id') ? ' has-error' : '' }}">
                                                                    {!! html_entity_decode(Form::label('owner_country_id', __('sales/customer_transfer.entry_owner_country_id') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::select('owner_country_id', $countries,old('owner_country_id',($customer_transfer_transfer->owner_country_id ?? '')), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                                    @if ($errors->has('owner_country_id'))
                                                                        <span class="help-block"><small>{{ $errors->first('owner_country_id') }}</small></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm">
                                                                    {!! html_entity_decode(Form::label('owner_state_id', __('sales/customer_transfer.entry_owner_state_id') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::select('owner_state_id', [],null, ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm">
                                                                    {!! html_entity_decode(Form::label('owner_city_id', __('sales/customer_transfer.entry_owner_city_id') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::select('owner_city_id', [],null, ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm">
                                                                    {!! html_entity_decode(Form::label('owner_postcode', __('sales/customer_transfer.entry_owner_postcode') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('owner_postcode', old('owner_postcode', ($customer_transfer_transfer->owner_postcode ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_owner_postcode')]) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-12 col-xs-12 pb-2">
                                                @php
                                                    $lessee_taxid = old('lessee_taxid',($customer_transfer_transfer->lessee_taxid ?? ''));
                                                @endphp
                                                <div class="x_panel" style="height: auto;">
                                                    <div class="x_title">
                                                        <h4 class="">
                                                            <input type="checkbox" name="lessee" class="collapse-link mt-1" {{!empty($lessee_taxid) ? 'checked' : ''}}/>&nbsp;
                                                            <b>{{__('sales/customer_transfer.text_lessee')}}</b>
                                                        </h4>
                                                        <div class="clearfix"></div>
                                                    </div>
                                                    <div class="x_content" style="display: {{!empty($lessee_taxid) ? 'block' : 'none'}};" id="content_lessee">
                                                        <div class="row">
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm{{ $errors->has('lessee_taxid') ? ' has-error' : '' }}">
                                                                    {!! html_entity_decode(Form::label('lessee_taxid', __('sales/customer_transfer.entry_lessee_taxid') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('lessee_taxid', old('lessee_taxid',($customer_transfer_transfer->lessee_taxid ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_lessee_taxid')]) !!}
                                                                    @if ($errors->has('lessee_taxid'))
                                                                        <span class="help-block"><small>{{ $errors->first('lessee_taxid') }}</small></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm{{ $errors->has('lessee_name') ? ' has-error' : '' }}">
                                                                    {!! html_entity_decode(Form::label('lessee_name', __('sales/customer_transfer.entry_lessee_name') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('lessee_name', old('lessee_name',($customer_transfer_transfer->lessee_name ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_lessee_name')]) !!}
                                                                    @if ($errors->has('lessee_name'))
                                                                        <span class="help-block"><small>{{ $errors->first('lessee_name') }}</small></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm{{ $errors->has('lessee_tr_country_id') ? ' has-error' : '' }}">
                                                                    {!! html_entity_decode(Form::label('lessee_tr_country_id', __('sales/customer_transfer.entry_lessee_tr_country_id') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::select('lessee_tr_country_id', $countries2,old('lessee_tr_country_id',($customer_transfer_transfer->lessee_tr_country_id ?? '')), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                                    @if ($errors->has('lessee_tr_country_id'))
                                                                        <span class="help-block"><small>{{ $errors->first('lessee_tr_country_id') }}</small></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm{{ $errors->has('lessee_numid') ? ' has-error' : '' }}">
                                                                    {!! html_entity_decode(Form::label('lessee_numid', __('sales/customer_transfer.entry_lessee_numid') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('lessee_numid', old('lessee_numid',($customer_transfer_transfer->lessee_numid ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_lessee_numid')]) !!}
                                                                    @if ($errors->has('lessee_numid'))
                                                                        <span class="help-block"><small>{{ $errors->first('lessee_numid') }}</small></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm{{ $errors->has('lessee_transport_part_id') ? ' has-error' : '' }}">
                                                                    {!! html_entity_decode(Form::label('lessee_transport_part_id', __('sales/customer_transfer.entry_lessee_transport_part_id') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::select('lessee_transport_part_id', $transport_parts,old('lessee_transport_part_id',($customer_transfer_transfer->lessee_transport_part_id ?? '')), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                                    @if ($errors->has('lessee_transport_part_id'))
                                                                        <span class="help-block"><small>{{ $errors->first('lessee_transport_part_id') }}</small></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-12 col-xs-12">
                                                                <hr class="divider">
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm">
                                                                    {!! html_entity_decode(Form::label('lessee_address_1', __('sales/customer_transfer.entry_lessee_address_1') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('lessee_address_1', old('lessee_address_1',($customer_transfer_transfer->lessee_address_1 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_lessee_address_1')]) !!}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm">
                                                                    {!! html_entity_decode(Form::label('lessee_address_2', __('sales/customer_transfer.entry_lessee_address_2') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('lessee_address_2', old('lessee_address_2',($customer_transfer_transfer->lessee_address_2 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_lessee_address_2')]) !!}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm">
                                                                    {!! html_entity_decode(Form::label('lessee_address_3', __('sales/customer_transfer.entry_lessee_address_3') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('lessee_address_3', old('lessee_address_3',($customer_transfer_transfer->lessee_address_3 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_lessee_address_3')]) !!}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm">
                                                                    {!! html_entity_decode(Form::label('lessee_address_4', __('sales/customer_transfer.entry_lessee_address_4') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('lessee_address_4', old('lessee_address_4',($customer_transfer_transfer->lessee_address_4 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_lessee_address_4')]) !!}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm">
                                                                    {!! html_entity_decode(Form::label('lessee_address_5', __('sales/customer_transfer.entry_lessee_address_5') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('lessee_address_5', old('lessee_address_5',($customer_transfer_transfer->lessee_address_5 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_lessee_address_5')]) !!}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-9 col-xs-12">
                                                                <div class="form-group form-group-sm">
                                                                    {!! html_entity_decode(Form::label('lessee_address_6', __('sales/customer_transfer.entry_lessee_address_6') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('lessee_address_6', old('lessee_address_6',($customer_transfer_transfer->lessee_address_6 ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_lessee_address_6')]) !!}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm{{ $errors->has('lessee_country_id') ? ' has-error' : '' }}">
                                                                    {!! html_entity_decode(Form::label('lessee_country_id', __('sales/customer_transfer.entry_lessee_country_id') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::select('lessee_country_id', $countries,old('lessee_country_id',($customer_transfer_transfer->lessee_country_id ?? '')), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                                    @if ($errors->has('lessee_country_id'))
                                                                        <span class="help-block"><small>{{ $errors->first('lessee_country_id') }}</small></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm">
                                                                    {!! html_entity_decode(Form::label('lessee_state_id', __('sales/customer_transfer.entry_lessee_state_id') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::select('lessee_state_id', [],null, ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm">
                                                                    {!! html_entity_decode(Form::label('lessee_city_id', __('sales/customer_transfer.entry_lessee_city_id') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::select('lessee_city_id', [],null, ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-xs-12">
                                                                <div class="form-group form-group-sm">
                                                                    {!! html_entity_decode(Form::label('lessee_postcode', __('sales/customer_transfer.entry_lessee_postcode') . '', ['class' => 'control-label'])) !!}
                                                                    {!! Form::text('lessee_postcode', old('lessee_postcode', ($customer_transfer_transfer->lessee_postcode ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_lessee_postcode')]) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row hidden">
                                            <div class="col-md-12 col-xs-12 pb-2">
                                                <h4>{{__('sales/customer_transfer.text_notified')}}</h4>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('notified_taxid') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('notified_taxid', __('sales/customer_transfer.entry_notified_taxid') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('notified_taxid', old('notified_taxid',($customer_transfer_transfer->notified_taxid ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_notified_taxid')]) !!}
                                                    @if ($errors->has('notified_taxid'))
                                                        <span class="help-block"><small>{{ $errors->first('notified_taxid') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('notified_name') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('notified_name', __('sales/customer_transfer.entry_notified_name') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('notified_name', old('notified_name',($customer_transfer_transfer->notified_name ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_notified_name')]) !!}
                                                    @if ($errors->has('notified_name'))
                                                        <span class="help-block"><small>{{ $errors->first('notified_name') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('notified_tr_country_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('notified_tr_country_id', __('sales/customer_transfer.entry_notified_tr_country_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('notified_tr_country_id', $countries2,old('notified_tr_country_id',($customer_transfer_transfer->notified_tr_country_id ?? '')), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('notified_tr_country_id'))
                                                        <span class="help-block"><small>{{ $errors->first('notified_tr_country_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('notified_numid') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('notified_numid', __('sales/customer_transfer.entry_notified_numid') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('notified_numid', old('notified_numid',($customer_transfer_transfer->notified_numid ?? '')), ['class' => 'form-control', 'placeholder' => __('sales/customer_transfer.entry_notified_numid')]) !!}
                                                    @if ($errors->has('notified_numid'))
                                                        <span class="help-block"><small>{{ $errors->first('notified_numid') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade" id="tab_relations"
                                         aria-labelledby="relations-tab">
                                        <div class="row">
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('cfdi_relation_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('cfdi_relation_id', __('sales/customer_transfer.entry_cfdi_relation_id') . ' ', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('cfdi_relation_id', $cfdi_relations,old('cfdi_relation_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('cfdi_relation_id'))
                                                        <span class="help-block"><small>{{ $errors->first('cfdi_relation_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-12 col-xs-12">
                                                <div class="hidden" id="delete_items_relation">
                                                    @foreach(old('delete_item_relation',[]) as $tmp)
                                                        <input type="hidden" name="delete_item_relation[]" value="{{ $tmp }}"/>
                                                    @endforeach
                                                </div>
                                                <div class="table-responsive">
                                                    <table class="table table-items table-condensed table-hover table-bordered table-striped"
                                                           id="items_relation">
                                                        <thead>
                                                        <tr>
                                                            <th width="5%"
                                                                class="text-center">@lang('general.column_actions')</th>
                                                            <th width="25%"
                                                                class="text-center">
                                                                @lang('sales/customer_transfer.column_relation_relation_id')
                                                            </th>
                                                            <th width="65%"
                                                                class="text-center">@lang('sales/customer_transfer.column_relation_uuid')</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <!-- Items -->
                                                        @php
                                                            $item_relation_row = 1;
                                                            $items_relation = old('item_relation',$customer_transfer->customerInvoiceRelations);
                                                        @endphp
                                                        @foreach ($items_relation as $item_relation_row => $item)
                                                            @php
                                                                $item = !empty(old('item_relation.' . $item_relation_row . '')) ? (object) old('item_relation.' . $item_relation_row) : $item;
                                                                $tmp_customer_transfer_relations = [];
                                                                if(!empty(old('item_relation.' . $item_relation_row . '.relation_id',$item->relation_id))){
                                                                    $tmp = \App\Models\Sales\CustomerInvoice::find(old('item_relation.' . $item_relation_row . '.relation_id',$item->relation_id));
                                                                    $tmp_customer_transfer_relations = $tmp->get()->pluck('text_select2','id');
                                                                }
                                                            @endphp
                                                            <tr id="item_relation_row_{{ $item_relation_row }}">
                                                                <td class="text-center"
                                                                    style="vertical-align: middle;">
                                                                    <button type="button"
                                                                            onclick="deleteItemRelation('{{old('item_relation.' . $item_relation_row . '.id',$item->id)}}');$('#item_relation_row_{{ $item_relation_row }}').remove();"
                                                                            class="btn btn-xs btn-danger"
                                                                            style="margin-bottom: 0;">
                                                                        <i class="fa fa-trash-o"></i>
                                                                    </button>
                                                                    <!-- input hidden -->
                                                                    <input type="hidden"
                                                                           id="item_relation_id_{{ $item_relation_row }}"
                                                                           name="item_relation[{{ $item_relation_row }}][id]"
                                                                           value="{{ old('item_relation.' . $item_relation_row . '.id',$item->id) }}">
                                                                    <!-- /.input hidden -->
                                                                </td>
                                                                <td class="text-center align-middle">
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_relation.'.$item_relation_row.'.relation_id') ? ' has-error' : '' }}">
                                                                        {!! Form::select('item_relation[' . $item_relation_row . '][relation_id]', $tmp_customer_transfer_relations,old('item_relation.' . $item_relation_row . '.relation_id',$item->relation_id), ['class' => 'form-control input-sm col-relation-id', 'placeholder' => __('general.text_select'),'id' => 'item_relation_relation_id_' . $item_relation_row,'data-row' => $item_relation_row]) !!}
                                                                        @if ($errors->has('item_relation.'.$item_relation_row.'.relation_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_relation.'.$item_relation_row.'.relation_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td class="text-center align-middle">
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_relation.'.$item_relation_row.'.uuid_related') ? ' has-error' : '' }}">
                                                                        {!! Form::text('item_relation[' . $item_relation_row . '][uuid_related]',old('item_relation.' . $item_relation_row . '.uuid_related',$item->uuid_related), ['class' => 'form-control text-center input-sm col-uuid-related','required','id' => 'item_relation_uuid_related_' . $item_relation_row,'data-row' => $item_relation_row]) !!}
                                                                        @if ($errors->has('item_relation.'.$item_relation_row.'.uuid_related'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_relation.'.$item_relation_row.'.uuid_related') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                        @php
                                                            $item_relation_row++;
                                                        @endphp
                                                        <!-- /Items -->
                                                        <!-- Agregar nuevo item -->
                                                        <tr id="add_item_relation">
                                                            <td class="text-center">
                                                                <button type="button"
                                                                        onclick="addItemCfdiRelation();"
                                                                        class="btn btn-xs btn-primary"
                                                                        style="margin-bottom: 0;">
                                                                    <i class="fa fa-plus"></i>
                                                                </button>
                                                            </td>
                                                            <td class="text-right" colspan="2"></td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Footer form -->
                            <div class="ln_solid"></div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12 text-right footer-form">
                                    {!! Form::button(__('general.button_pre_transfer'),['type' => 'submit', 'class' => 'btn btn-sm btn-info ladda-button','name' => 'pre_transfer', 'value' => '1']) !!}
                                    &nbsp;&nbsp;
                                    {!! Form::button(__('general.button_stamp'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary ladda-button']) !!}
                                    &nbsp;&nbsp;
                                    <a href="{{route('customer-transfers.index',request()->except('page'))}}"
                                       class="btn btn-sm btn-default">@lang('general.button_discard')</a>
                                </div>
                            </div>
                            <!-- /Footer form -->
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">
        var item_transfer_row = "{{ $item_transfer_row }}";
        var item_row = "{{ $item_row }}";
        var item_relation_row = "{{ $item_relation_row }}";

        function addItemTransfer() {
            var html = '';

            html += '<tr id="item_transfer_row_' + item_transfer_row + '">';
            html += '<td class="text-center" style="vertical-align: middle;">';
            html += '<button type="button" onclick="$(\'#item_transfer_row_' + item_transfer_row + '\').remove(); " class="btn btn-xs btn-danger" style="margin-bottom: 0;">';
            html += '<i class="fa fa-trash"></i>';
            html += '</button>';
            html += '<input type="hidden" name="item_transfer[' + item_transfer_row + '][id]" id="item_transfer_id_' + item_transfer_row + '" /> ';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<select class="form-control input-sm col-transfer-sat-product-id" name="item_transfer[' + item_transfer_row + '][sat_product_id]" id="item_transfer_sat_product_id_' + item_transfer_row + '" required>';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            html += '</select>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<textarea class="form-control input-sm col-transfer-name-id ym-auto-resize" name="item_transfer[' + item_transfer_row + '][name]" id="item_transfer_name_' + item_transfer_row + '" placeholder="{{__('sales/customer_transfer.column_line_transfer_name')}}" required rows="2" autocomplete="off" maxlength="1000" />';
            html += '</textarea>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="number" class="form-control input-sm text-center col-transfer-quantity" name="item_transfer[' + item_transfer_row + '][quantity]" id="item_transfer_quantity_' + item_transfer_row + '" step="any" required />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<select class="form-control input-sm col-transfer-unit-measure-id" name="item_transfer[' + item_transfer_row + '][unit_measure_id]" id="item_transfer_unit_measure_id_' + item_transfer_row + '" required>';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            html += '</select>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="number" class="form-control input-sm text-center col-transfer-weight" name="item_transfer[' + item_transfer_row + '][weight]" id="item_transfer_weight_' + item_transfer_row + '" step="any" required />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<select class="form-control input-sm col-transfer-dangerous-product" name="item_transfer[' + item_transfer_row + '][dangerous_product]" id="item_transfer_dangerous_product_' + item_transfer_row + '">';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            @foreach($yes_nos as $key => $value)
                html += '<option value="{{ $key }}">{{ $value }}</option>';
            @endforeach
            html += '</select>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<select class="form-control input-sm my-select2 col-transfer-packaging-type-id" name="item_transfer[' + item_transfer_row + '][packaging_type_id]" id="item_transfer_packaging_type_id_' + item_transfer_row + '">';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            @foreach($packaging_types as $key => $value)
                html += '<option value="{{ $key }}">{{ $value }}</option>';
            @endforeach
            html += '</select>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<select class="form-control input-sm col-transfer-dangerous-product-id" name="item_transfer[' + item_transfer_row + '][dangerous_product_id]" id="item_transfer_dangerous_product_id_' + item_transfer_row + '">';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            html += '</select>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="text" class="form-control input-sm col-transfer-dimensions" name="item_transfer[' + item_transfer_row + '][dimensions]" id="item_transfer_dimensions_' + item_transfer_row + '" />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="number" class="form-control input-sm text-right col-transfer-amount_total" name="item_transfer[' + item_transfer_row + '][amount_total]" id="item_transfer_amount_total_' + item_transfer_row + '" step="any"  />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<select class="form-control input-sm col-transfer-currency-id" name="item_transfer[' + item_transfer_row + '][currency_id]" id="item_transfer_currency_id_' + item_transfer_row + '">';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            @foreach($currencies as $key => $value)
                html += '<option value="{{ $key }}">{{ $value }}</option>';
            @endforeach
            html += '</select>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<select class="form-control input-sm col-transfer-tariff-fraction-id" name="item_transfer[' + item_transfer_row + '][tariff_fraction_id]" id="item_transfer_tariff_fraction_id_' + item_transfer_row + '">';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            html += '</select>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="text" class="form-control input-sm col-transfer-uuid-ext" name="item_transfer[' + item_transfer_row + '][uuid_ext]" id="item_transfer_uuid_ext_' + item_transfer_row + '" />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="text" class="form-control input-sm col-transfer-uuid-ext" name="item_transfer[' + item_transfer_row + '][petition]" id="item_transfer_petition_' + item_transfer_row + '" "maxlength"="21" />';
            html += '</div>';
            html += '</td>';
            html += '</tr>';

            $("#form #items_transfer tbody #add_item_transfer").before(html);

            /* Configura lineas*/
            initItemTransfer();

            item_transfer_row++;
        }

        function deleteItemTransfer(id) {
            if(id) {
                let html = '<input type="hidden" name="delete_item_transfer[]" value="'+id+'"/>';
                $('#form #delete_items_transfer').append(html);
            }
        }

        function initItemTransfer() {
            /*Para impuestos*/
            $("#form #items_transfer tbody .my-select2").select2({
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                dropdownAutoWidth: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                allowClear: true,
            });
            /*Autoresize*/
            /*Para unidades de medida*/
            $("#form #items_transfer tbody .col-transfer-unit-measure-id").select2({
                ajax: {
                    url: "{{route('unit-measures/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                templateResult: formatRepoCode,
                templateSelection: formatRepoCodeSelection,
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                dropdownAutoWidth: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 2
            });
            /*Para productos sat*/
            $("#form #items_transfer tbody .col-transfer-sat-product-id").select2({
                ajax: {
                    url: "{{route('sat-products/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                templateResult: formatRepoCode,
                templateSelection: formatRepoCodeSelection,
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                dropdownAutoWidth: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 3
            });
            $("#form #items_transfer tbody .col-transfer-dangerous-product-id").select2({
                ajax: {
                    url: "{{route('dangerous-products/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                templateResult: formatRepoCode,
                templateSelection: formatRepoCodeSelection,
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                allowClear: true,
                dropdownAutoWidth: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 3
            });
            $("#form #items_transfer tbody .col-transfer-tariff-fraction-id").select2({
                ajax: {
                    url: "{{route('tariff-fractions/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                templateResult: formatRepoCode,
                templateSelection: formatRepoCodeSelection,
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                allowClear: true,
                dropdownAutoWidth: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 3
            });
        }

        function addItem() {
            var html = '';

            html += '<tr id="item_row_' + item_row + '">';
            html += '<td class="text-center" style="vertical-align: middle;">';
            html += '<button type="button" onclick="$(\'#item_row_' + item_row + '\').remove(); totalItem();" class="btn btn-xs btn-danger" style="margin-bottom: 0;">';
            html += '<i class="fa fa-trash"></i>';
            html += '</button>';
            html += '<input type="hidden" name="item[' + item_row + '][id]" id="item_id_' + item_row + '" /> ';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<div class="input-group input-group-sm">';
            html += '<select class="form-control input-sm col-product-id" name="item[' + item_row + '][product_id]" id="item_product_id_' + item_row + '" data-row="' + item_row + '">';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            html += '</select>';
            html += '<span class="input-group-btn">';
            html += '<button type="button" class="btn btn-info btn-product-search" data-row="' + item_row + '"><i class="fa fa-search"></i></button>';
            html += '</span>';
            html += '</div>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<textarea class="form-control input-sm col-name-id ym-auto-resize" name="item[' + item_row + '][name]" id="item_name_' + item_row + '" placeholder="{{__('sales/customer_transfer.column_line_name')}}" required rows="2" autocomplete="off" maxlength="1000" />';
            html += '</textarea>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<div class="input-group input-group-sm">';
            html += '<select class="form-control input-sm col-unit-measure-id" name="item[' + item_row + '][unit_measure_id]" id="item_unit_measure_id_' + item_row + '" required>';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            html += '</select>';
            html += '<span class="input-group-btn">';
            html += '<button type="button" class="btn btn-info btn-unit-measure-search" data-row="' + item_row + '"><i class="fa fa-search"></i></button>';
            html += '</span>';
            html += '</div>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<div class="input-group input-group-sm">';
            html += '<select class="form-control input-sm col-sat-product-id" name="item[' + item_row + '][sat_product_id]" id="item_sat_product_id_' + item_row + '" required>';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            html += '</select>';
            html += '<span class="input-group-btn">';
            html += '<button type="button" class="btn btn-info btn-sat-product-search" data-row="' + item_row + '"><i class="fa fa-search"></i></button>';
            html += '</span>';
            html += '</div>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="number" class="form-control input-sm text-right col-quantity" name="item[' + item_row + '][quantity]" id="item_quantity_' + item_row + '" required step="any" />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="number" class="form-control input-sm text-right col-price-unit" name="item[' + item_row + '][price_unit]" id="item_price_unit_' + item_row + '" required step="any" />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="number" class="form-control input-sm text-center col-discount" name="item[' + item_row + '][discount]" id="item_discount_' + item_row + '" step="any" />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<select class="form-control input-sm my-select2 col-taxes" name="item[' + item_row + '][taxes][]" id="item_taxes_' + item_row + '" multiple>';
            @foreach($taxes as $key => $value)
                html += '<option value="{{ $key }}">{{ $value }}</option>';
            @endforeach
                html += '</select>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<select class="form-control input-sm col-tax-object" name="item[' + item_row + '][tax_object]" id="item_tax_object_' + item_row + '">';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            @foreach($tax_objects as $key => $value)
                html += '<option value="{{ $key }}">{{ $value }}</option>';
            @endforeach
                html += '</select>';
            html += '</div>';
            html += '</td>';
            html += '<td class="text-right" style="padding-top: 11px;">';
            html += '<span id="item_txt_amount_untaxed_' + item_row + '">0</span>';
            html += '</td>';
            html += '</tr>';

            $("#form #items tbody #add_item").before(html);

            /* Configura lineas*/
            initItem();

            totalItem();
            item_row++;
        }

        function deleteItem(id) {
            if(id) {
                let html = '<input type="hidden" name="delete_item[]" value="'+id+'"/>';
                $('#form #delete_items').append(html);
            }
        }

        function initItem() {
            /*Para impuestos*/
            $("#form #items tbody .my-select2").select2({
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                dropdownAutoWidth: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
            });
            /*Busqueda de productos*/
            $("#form #items tbody .col-product-id").select2({
                ajax: {
                    url: "{{route('products/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                templateResult: formatRepoCode,
                templateSelection: formatRepoCodeSelection,
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                dropdownAutoWidth: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 3
            });
            /*Autoresize*/
            ymAutoResizeTextArea();
            /*Para unidades de medida*/
            $("#form #items tbody .col-unit-measure-id").select2({
                ajax: {
                    url: "{{route('unit-measures/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                templateResult: formatRepoCode,
                templateSelection: formatRepoCodeSelection,
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                dropdownAutoWidth: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 2
            });
            /*Para productos sat*/
            $("#form #items tbody .col-sat-product-id").select2({
                ajax: {
                    url: "{{route('sat-products/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                templateResult: formatRepoCode,
                templateSelection: formatRepoCodeSelection,
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                dropdownAutoWidth: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 3
            });
        }

        function totalItem() {
            $.ajax({
                url: "{{ route('customer-transfers/total-lines') }}",
                type: "POST",
                dataType: "JSON",
                data: $("#form").serialize(),
                success: function (data) {
                    if (data) {
                        $.each(data.items, function (key, value) {
                            $("#item_txt_amount_untaxed_" + key).html(value);
                        });
                        var html_taxes_label = ''
                        var html_taxes = ''
                        $.each(data.taxes, function (key, value) {
                            html_taxes_label += value.name + '<br/>';
                            html_taxes += value.amount_tax + '<br/>';
                        });
                        $("#form #txt_amount_untaxed").html(data.amount_untaxed);
                        $("#form #txt_amount_tax_label").html(html_taxes_label);
                        $("#form #txt_amount_tax").html(html_taxes);
                        $("#form #txt_amount_total").html(data.amount_total);
                        $("#form input[name='amount_total_tmp']").val(data.amount_total_tmp);
                    }
                },
                error: function (error, textStatus, errorThrown) {
                    if (error.status == 422) {
                        var message = error.responseJSON.error;
                        $("#general_messages").html(alertMessage("danger", message));
                    } else if (error.status == 403 || error.status == 401) {
                        location.href = "{{ route('login') }}";
                    } else {
                        alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                    }
                }
            });
        }

        function addItemCfdiRelation() {
            var html = '';

            html += '<tr id="item_relation_row_' + item_relation_row + '">';
            html += '<td class="text-center" style="vertical-align: middle;">';
            html += '<button type="button" onclick="$(\'#item_relation_row_' + item_relation_row + '\').remove();" class="btn btn-xs btn-danger" style="margin-bottom: 0;">';
            html += '<i class="fa fa-trash"></i>';
            html += '</button>';
            html += '<input type="hidden" name="item_relation[' + item_relation_row + '][id]" id="item_relation_id_' + item_relation_row + '" /> ';
            html += '</td>';
            html += '<td class="text-center align-middle">';
            html += '<div class="form-group form-group-sm">';
            html += '<select class="form-control input-sm col-relation-id" name="item_relation[' + item_relation_row + '][relation_id]" id="item_relation_relation_id_' + item_relation_row + '" data-row="' + item_relation_row + '">';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            html += '</select>';
            html += '</div>';
            html += '</td>';
            html += '<td class="text-center align-middle">';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="text" class="form-control input-sm text-center col-uuid-related" name="item_relation[' + item_relation_row + '][uuid_related]" id="item_relation_uuid_related_' + item_relation_row + '" required />';
            html += '</div>';
            html += '</td>';
            html += '</tr>';

            $("#form #items_relation tbody #add_item_relation").before(html);

            /* Configura select2 */
            initItemCfdiRelation();

            item_relation_row++;
        }

        function deleteItemRelation(id) {
            if(id) {
                let html = '<input type="hidden" name="delete_item_relation[]" value="'+id+'"/>';
                $('#form #delete_items_relation').append(html);
            }
        }


        function initItemCfdiRelation() {
            /*Busqueda de facturas*/
            $("#form #items_relation tbody .col-relation-id").select2({
                ajax: {
                    url: "{{route('customer-transfers/autocomplete-cfdi')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                            customer_id: $("#form select[name='customer_id']").val(),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "auto",
                dropdownAutoWidth: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 2
            });
        }

        $(function () {
            $("#form .my-select2").select2({
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "auto",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
            });

            /*Configura datepicker*/
            moment.locale("{{ substr(app()->getLocale(),0,2) }}");
            $("#form input[name='date']").daterangepicker({
                singleDatePicker: true,
                timePicker: true,
                timePicker24Hour: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('datetime_picker_format','DD-MM-YYYY HH:mm:ss') }}"
                },
                autoUpdateInput: false
            }, function (chosen_date) {
                $("#form input[name='date']").val(chosen_date.format("{{ setting('datetime_picker_format','DD-MM-YYYY HH:mm:ss') }}"));
            });
            $("#form input[name='date_due']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false,
            }, function (chosen_date) {
                $("#form input[name='date_due']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });
            $("#form input[name='date_delivery']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false,
            }, function (chosen_date) {
                $("#form input[name='date_delivery']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });

            /* Configura select2 para buscar cliente*/
            $("#form select[name='customer_id']").select2({
                ajax: {
                    url: "{{route('customers/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "100%",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 3
            }).on("change", function () { //Selecciona cliente
                let id = $(this).val();
                if (id) {
                    $.ajax({
                        url: "{{ route('customers/get-customer') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id,
                        success: function (data) {
                            $("#form select[name='salesperson_id']").val(data.salesperson_id);
                            $("#form select[name='payment_term_id']").val(data.payment_term_id);
                            $("#form select[name='payment_way_id']").val(data.payment_way_id);
                            $("#form select[name='payment_method_id']").val(data.payment_method_id);
                            $("#form select[name='cfdi_use_id']").val(data.cfdi_use_id);
                            $("#form select[name='tax_regimen_customer_id']").val(data.tax_regimen_id);
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });
            /* Selecciona moneda */
            $("#form select[name='currency_id']").on("change", function () {
                let id = $(this).val();
                if (id) {
                    $.ajax({
                        url: "{{ route('currencies/get-currency') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id,
                        success: function (data) {
                            $("#form input[name='currency_value']").val(data.rate);
                            totalItem();
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });

            /* Selecciona pais */
            $("#form select[name='source_country_id']").on("change", function () {
                var id = $(this).val();
                let state_id = $("#form select[name='source_state_id']");
                state_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('countries/get-states') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&state_id=" + "{{ old('source_state_id', $customer_transfer_transfer->source_state_id ?? '') }}",
                        success: function (data) {
                            if (data.html) {
                                state_id.html(data.html);
                            }
                            state_id.trigger("change");
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            }).trigger("change");
            /* Selecciona estado */
            $("#form select[name='source_state_id']").on("change", function () {
                var id = $(this).val();
                let city_id = $("#form select[name='source_city_id']");
                city_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('states/get-cities') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&city_id=" + "{{ old('source_city_id', $customer_transfer_transfer->source_city_id ?? '') }}",
                        success: function (data) {
                            if (data.html) {
                                city_id.html(data.html);
                            }
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });
            /* Selecciona pais */
            $("#form select[name='destination_country_id']").on("change", function () {
                var id = $(this).val();
                let state_id = $("#form select[name='destination_state_id']");
                state_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('countries/get-states') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&state_id=" + "{{ old('destination_state_id', $customer_transfer_transfer->destination_state_id ?? '') }}",
                        success: function (data) {
                            if (data.html) {
                                state_id.html(data.html);
                            }
                            state_id.trigger("change");
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            }).trigger("change");
            /* Selecciona estado */
            $("#form select[name='destination_state_id']").on("change", function () {
                var id = $(this).val();
                let city_id = $("#form select[name='destination_city_id']");
                city_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('states/get-cities') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&city_id=" + "{{ old('destination_city_id', $customer_transfer_transfer->destination_city_id ?? '') }}",
                        success: function (data) {
                            if (data.html) {
                                city_id.html(data.html);
                            }
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });
            $("#form select[name='measure_packaging_id']").select2({
                ajax: {
                    url: "{{route('measure-packagings/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "100%",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 3
            });
            /* Selecciona pais */
            $("#form select[name='owner_country_id']").on("change", function () {
                var id = $(this).val();
                let state_id = $("#form select[name='owner_state_id']");
                state_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('countries/get-states') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&state_id=" + "{{ old('owner_state_id', $customer_transfer_transfer->owner_state_id ?? '') }}",
                        success: function (data) {
                            if (data.html) {
                                state_id.html(data.html);
                            }
                            state_id.trigger("change");
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            }).trigger("change");
            /* Selecciona estado */
            $("#form select[name='owner_state_id']").on("change", function () {
                var id = $(this).val();
                let city_id = $("#form select[name='owner_city_id']");
                city_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('states/get-cities') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&city_id=" + "{{ old('owner_city_id', $customer_transfer_transfer->owner_city_id ?? '') }}",
                        success: function (data) {
                            if (data.html) {
                                city_id.html(data.html);
                            }
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });
            /* Selecciona pais */
            $("#form select[name='lessee_country_id']").on("change", function () {
                var id = $(this).val();
                let state_id = $("#form select[name='lessee_state_id']");
                state_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('countries/get-states') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&state_id=" + "{{ old('lessee_state_id', $customer_transfer_transfer->lessee_state_id ?? '') }}",
                        success: function (data) {
                            if (data.html) {
                                state_id.html(data.html);
                            }
                            state_id.trigger("change");
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            }).trigger("change");
            /* Selecciona estado */
            $("#form select[name='lessee_state_id']").on("change", function () {
                var id = $(this).val();
                let city_id = $("#form select[name='lessee_city_id']");
                city_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('states/get-cities') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&city_id=" + "{{ old('lessee_city_id', $customer_transfer_transfer->lessee_city_id ?? '') }}",
                        success: function (data) {
                            if (data.html) {
                                city_id.html(data.html);
                            }
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });

            /* init de Funciones */
            initItemTransfer();
            initItem();
            initItemCfdiRelation();
            totalItem();

            /*Modal para buscar clientes*/
            $(".btn-customer-search").on("click", function (e) {
                e.preventDefault();
                $.ajax({
                    url: "{{route('customers/modal-search')}}",
                    type: "GET",
                    dataType: "JSON",
                    data: "active_btn_select=1",
                    success: function (data) {
                        $("#modals").html(data.html);
                        $("#modal_customer_search").modal("show");
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            var message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
            /*Seleccionar cliente*/
            $(document).on("click", '#form_modal_customer_search #customers .btn-select-customer', function (e) {
                e.preventDefault();
                let option = new Option($(this).attr('data-name'), $(this).attr('data-id'), false, true);
                $("#form select[name='customer_id']").append(option).trigger('change');
                $("#modal_customer_search").modal("hide");
            });
            /*Modal para buscar alta de clientes*/
            $(".btn-customer-add").on("click", function (e) {
                e.preventDefault();
                $.ajax({
                    url: "{{route('customers/modal-create')}}",
                    type: "GET",
                    dataType: "JSON",
                    data: "",
                    success: function (data) {
                        $("#modals").html(data.html);
                        $("#modal_customer_create").modal("show");
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            var message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
            /*Alta de cliente*/
            $(document).on("submit", '#form_modal_customer_create', function (e) {
                e.preventDefault();
                var form = $(this);
                form.find(".help-block").remove();
                form.find(".form-control").parent().removeClass("has-error");
                $.ajax({
                    url: "{{ route('customers.store') }}",
                    type: "POST",
                    dataType: "JSON",
                    data: $("#form_modal_customer_create").serialize(),
                    success: function (data) {
                        if (data) {
                            let option = new Option(data.name, data.id, false, true);
                            $("#form select[name='customer_id']").append(option).trigger('change');
                            $("#modal_customer_create").modal("hide");
                        }
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            let message = error.responseJSON.error;
                            //Si trae objecto con errores
                            if(typeof(message) === "object"){
                                $.each( message, function( key, value ) {
                                    form.find("[name='"+key+"']").after(messageSmallHelpBlock(value)).parent().addClass("has-error");
                                });
                            }else{
                                $("#form_modal_customer_create #modal_general_messages").html(alertMessage("danger", message));
                            }
                            setTimeout(function () {
                                $("#form_modal_customer_create #modal_general_messages").html("");
                            }, 12000);
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });

            /* Selecciona moneda */
            $("#form select[name='document_type2']").on("change", function () {
                let document_type2 = $(this).val();
                if(document_type2 == 'invoice'){
                    $("#form #invoice").removeClass('hidden');
                }else{
                    $("#form #invoice").addClass('hidden');
                }
            });

            /* Eventos en items */
            /*Modal para buscar productos*/
            $(document).on('click', '#form #items tbody .btn-product-search', function (e) {
                e.preventDefault();
                let row = $(this).attr('data-row');
                $.ajax({
                    url: "{{route('products/modal-search')}}",
                    type: "GET",
                    dataType: "JSON",
                    data: "active_btn_select=1&row_origin="+ row,
                    success: function (data) {
                        $("#modals").html(data.html);
                        $("#modal_product_search").modal("show");
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            var message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
            /*Seleccionar producto*/
            $(document).on("click", '#form_modal_product_search #products .btn-select-product', function (e) {
                e.preventDefault();
                let option = new Option($(this).attr('data-code'), $(this).attr('data-id'), false, true);
                $("#form #items tbody #item_product_id_" + $(this).attr('data-row-origin') + "").append(option).trigger('select2:select');
                $("#modal_product_search").modal("hide");
            });
            /*Selecciona producto*/
            $(document).on('select2:select', '#form #items tbody .col-product-id', function (e) {
                let id = $(this).val();
                let row = $(this).attr('data-row');
                if (id) {
                    $.ajax({
                        url: "{{ route('products/get-product') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id,
                        success: function (data) {
                            $("#form #item_name_" + row).val(data.description);
                            if(data.unit_measure_id) {
                                let option = new Option(data.unit_measure_description_select2, data.unit_measure_id, false, true);
                                $("#form #item_unit_measure_id_" + row).append(option).trigger('change');
                            }
                            if(data.sat_product_id) {
                                let option = new Option(data.sat_product_description_select2, data.sat_product_id, false, true);
                                $("#form #item_sat_product_id_" + row).append(option).trigger('change');
                            }
                            $("#form #item_price_unit_" + row).val(data.price);
                            let tmp = $.map(data.taxes_1, function (value, index) {
                                return [value];
                            });
                            $("#form #item_taxes_" + row).val(tmp);
                            initItem();
                            totalItem();
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });
            /*Modal para buscar unidades de medida*/
            $(document).on('click', '#form #items tbody .btn-unit-measure-search', function (e) {
                e.preventDefault();
                let row = $(this).attr('data-row');
                $.ajax({
                    url: "{{route('unit-measures/modal-search')}}",
                    type: "GET",
                    dataType: "JSON",
                    data: "active_btn_select=1&row_origin="+ row,
                    success: function (data) {
                        $("#modals").html(data.html);
                        $("#modal_unit_measure_search").modal("show");
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            var message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
            /*Seleccionar unidad de medida*/
            $(document).on("click", '#form_modal_unit_measure_search #unit_measures .btn-select-unit-measure', function (e) {
                e.preventDefault();
                let option = new Option($(this).attr('data-description-select2'), $(this).attr('data-id'), false, true);
                $("#form #items tbody #item_unit_measure_id_" + $(this).attr('data-row-origin') + "").append(option).trigger('select2:select');
                $("#modal_unit_measure_search").modal("hide");
            });
            /*Modal para buscar productos del sat*/
            $(document).on('click', '#form #items tbody .btn-sat-product-search', function (e) {
                e.preventDefault();
                let row = $(this).attr('data-row');
                $.ajax({
                    url: "{{route('sat-products/modal-search')}}",
                    type: "GET",
                    dataType: "JSON",
                    data: "active_btn_select=1&row_origin="+ row,
                    success: function (data) {
                        $("#modals").html(data.html);
                        $("#modal_sat_product_search").modal("show");
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            var message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
            /*Seleccionar producto del sat*/
            $(document).on("click", '#form_modal_sat_product_search #sat_products .btn-select-sat-product', function (e) {
                e.preventDefault();
                let option = new Option($(this).attr('data-description-select2'), $(this).attr('data-id'), false, true);
                $("#form #items tbody #item_sat_product_id_" + $(this).attr('data-row-origin') + "").append(option).trigger('select2:select');
                $("#modal_sat_product_search").modal("hide");
            });
            $(document).on("change", "#form #items tbody .col-taxes", function () {
                totalItem();
            });
            $(document).on("keyup", "#form #items tbody .col-quantity,#form #items tbody .col-price-unit,#form #items tbody .col-discount", function () {
                totalItem();
            });

            /* Eventos en items cfdi relation */
            /*Selecciona factura*/
            $(document).on('select2:select', '#form #items_relation tbody .col-relation-id', function (e) {
                let id = $(this).val();
                let row = $(this).attr('data-row');
                if (id) {
                    $.ajax({
                        url: "{{ route('customer-transfers/get-customer-transfer') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id,
                        success: function (data) {
                            $("#form #item_relation_uuid_related_" + row).val(data.uuid);
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });

        });

    </script>
@endsection
