<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_transfer->documentType->name}}-{{$customer_transfer->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 410px;
            margin-bottom: 225px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_transfer->company_id) }}     !important;
        }

        .table-items thead th {
            background-color: #FFFFFF!important;
            color: #333333;
            border-bottom: 1px solid #cccccc;
        }
        .table-items tbody td {
            padding: 8px 2px;
            border: none;
            border-bottom: 1px solid #cccccc;
        }
        .table-footer td {
            background-color: #FEFEFE;
            border: none;
        }
        .table-items tfoot td {
            padding: 4px 2px;
            border: none;
            border-bottom: 1px solid #cccccc;
        }
        .table-secundary td {
            background-color: #FAFAFA;
            border: none;
            border-bottom: 1px solid #cccccc;
        }
        .table-resume td {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_transfer->company_id) }}     !important;
            color: #FFFFFF;
        }
    </style>
</head>
<body style="background-color: white;">
@php
//Obtiene datos del Cfdi33
$draft = (int) $customer_transfer->status == \App\Models\Sales\CustomerInvoice::DRAFT ? true : false;
$cfdi33 = empty($data['cfdi33']) ? null : $data['cfdi33'];
$conceptos = null;
if($cfdi33){
    $conceptos = $cfdi33->conceptos;
    $conceptos = $conceptos();
}
@endphp
<section class="header" style="top: -387px;">
    @if($cfdi33 && $customer_transfer->customerInvoiceCfdi->pac->test)
    <h2 style="position: absolute; left: 37%; top: -15px; color: red;">*** @lang('general.text_test_cfdi') ***</h2>
    @endif
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="40%" style="">
                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_transfer->company_id,$customer_transfer->project_id) }}" class="" style="max-height: 45px; max-width: 240px;"/>
                @elseif(!empty(setting('branch_office_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_transfer->company_id,$customer_transfer->branch_office_id) }}" class="" style="max-height: 45px; max-width: 240px;"/>
                @else
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_transfer->company_id) }}" class="" style="max-height: 45px; max-width: 240px;"/>
                @endif
            </td>
            <td width="60%" class="text-right" style="vertical-align: middle;">
                <h2 style="margin: 0;">{{ mb_strtoupper($list_document_type2[$customer_transfer->document_type2])  }}</h2>
                <span class="text-primary">{{ mb_strtoupper($customer_transfer->company->comercial_name) }}</span>
            </td>
        </tr>
        <tr>
            <td colspan="2" class="text-right" style="border-bottom: 1px solid #cccccc; padding-top: 5px; padding-bottom: 5px;">
                <strong>{{ mb_strtoupper($customer_transfer->company->name) }} | {{ mb_strtoupper($customer_transfer->company->taxid) }} | {{ $data['tax_regimen'] ?? ($customer_transfer->taxRegimen->name_sat ?? $customer_transfer->company->taxRegimen->name_sat) }}</strong><br>
                <span>
                    @if(!empty($customer_transfer->company->address_1) || !empty($customer_transfer->company->address_2) || !empty($customer_transfer->company->address_3) || !empty($customer_transfer->company->address_4))
                        {{ $customer_transfer->company->address_1 ?? '' }} {{ $customer_transfer->company->address_2 ?? '' }} {{ $customer_transfer->company->address_3 ?? '' }} {{ $customer_transfer->company->address_4 ?? '' }}
                    @endif
                    @if(!empty($customer_transfer->company->city->name) || !empty($customer_transfer->company->state->name))
                        {{ !empty($customer_transfer->company->city->name) ? $customer_transfer->company->city->name . ', ' : '' }}{{ !empty($customer_transfer->company->state->name) ? $customer_transfer->company->state->name . ', ' : '' }}
                    @endif
                    {{ $customer_transfer->company->country->name ?? '' }}{!! ($customer_transfer->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_transfer->company->postcode : '') !!} | {{ $customer_transfer->company->phone ?? ' ' }} | {{ $customer_transfer->company->email ?? ' ' }}
                </span>
            </td>
        </tr>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 15px; margin-bottom: 10px;">
        <tr>
            <td width="60%" style="vertical-align: middle; padding-left: 5px;">
                <table cellpadding="0" cellspacing="0" class="" style="min-width: 50%;">
                    <tr>
                        <td class="text-primary" style="padding-top: 5px; padding-bottom: 5px;">
                            <p style="margin: 0; border-bottom: 1px solid #cccccc;">{{ __('general.text_customer') }}</p>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-head" style="padding-top: 3px;">
                            <strong>{{ mb_strtoupper($customer_transfer->customer->name) }} </strong>
                            @if(!empty($customer_transfer->customer->address_1) || !empty($customer_transfer->customer->address_2) || !empty($customer_transfer->customer->address_3) || !empty($customer_transfer->customer->address_4))
                                <br/>
                                {{ $customer_transfer->customer->address_1 ?? '' }} {{ $customer_transfer->customer->address_2 ?? '' }} {{ $customer_transfer->customer->address_3 ?? '' }} {{ $customer_transfer->customer->address_4 ?? '' }},
                            @endif
                            @if(!empty($customer_transfer->customer->city->name) || !empty($customer_transfer->customer->state->name))
                                <br/>
                                {{ !empty($customer_transfer->customer->city->name) ? $customer_transfer->customer->city->name . ', ' : '' }}{{ $customer_transfer->customer->state->name ?? '' }}
                            @endif
                            <br/>
                            {{ $customer_transfer->customer->country->name ?? '' }}{!! ($customer_transfer->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_transfer->customer->postcode : '') !!}
                            <br/>
                            {{ mb_strtoupper($customer_transfer->customer->taxid) }}
                        </td>
                    </tr>
                </table>
            </td>
            <td width="40%" class="text-right" style="vertical-align: middle;">
                <table cellpadding="0" cellspacing="0" class="text-right" style="" width="100%">
                    <tr>
                        <td class="small" style=" color: #777777;"><strong>{{ __('sales/customer_transfer.entry_name') }}</strong></td>
                    </tr>
                    <tr>
                        <td class="text-head" style="">
                            <h3 style="margin: 0; padding: 0;">{{ $customer_transfer->name }}</h3>
                        </td>
                    </tr>
                    <tr>
                        <td class="small" style="padding-top: 7px; color: #777777;"><strong>@lang('sales/customer_transfer.entry_date')</strong></td>
                    </tr>
                    <tr>
                        <td class="text-head" style="">
                            <h3 style="margin: 0; padding: 0;">{{ \App\Helpers\Helper::convertSqlToDateTime($customer_transfer->date) }}</h3>
                        </td>
                    </tr>
                    <tr>
                        <td class="small" style="padding-top: 7px; color: #777777;"><strong>@lang('sales/customer_transfer.entry_date_due')</strong></td>
                    </tr>
                    @if($customer_transfer->document_type2 == 'invoice')
                    <tr>
                        <td class="text-head" style="">
                            <h3 style="margin: 0; padding: 0;">{{ $customer_transfer->date_due ? \App\Helpers\Helper::convertSqlToDate($customer_transfer->date_due) : '' }}</h3>
                        </td>
                    </tr>
                    @endif
                    <tr>
                        <td class="small" style="padding-top: 7px; color: #777777;"><strong>@lang('general.text_amount_total')</strong></td>
                    </tr>
                    <tr>
                        <td class="text-head" style="">
                            <h3 style="margin: 0; padding: 0;">{{ money($customer_transfer->amount_total,$customer_transfer->currency->code,true) }}</h3>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    </div>
    <div>
    <table cellpadding="2" cellspacing="0" class="table-resume" width="100%" style="margin-top: 5px; font-size: 9px;">
        <tr>
            <td>
                <small style="font-weight: bold;">@lang('general.text_cfdi_uuid')</small><br>
                {{ $customer_transfer->customerInvoiceCfdi->uuid ?? '' }}
            </td>
            <td>
                <small style="font-weight: bold;">@lang('base/document_type.entry_cfdi_type_id')</small><br>
                {{ $customer_transfer->documentType->cfdiType->name_sat ?? '' }}
            </td>
            <td>
                <small style="font-weight: bold;">@lang('sales/customer_transfer.entry_payment_term_id')</small><br>
                {{ $customer_transfer->paymentTerm->name ?? '' }}
            </td>
            <td>
                <small style="font-weight: bold;">@lang('sales/customer_transfer.entry_cfdi_use_id')</small><br>
                {{ $customer_transfer->cfdiUse->name_sat ?? '' }}
            </td>
            <td>
                <small style="font-weight: bold;">@lang('general.text_issued_in')</small><br>
                {{ $customer_transfer->branchOffice->name ?? '' }} {!! ($customer_transfer->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $customer_transfer->branchOffice->postcode : '') !!}
            </td>
        </tr>
    </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 15px;">
            <tr>
                <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                    <span class="text-primary">{{ mb_strtoupper(__('sales/customer_transfer.entry_source_name')) }}</span>

                </td>
                <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                    <span class="text-primary">{{ mb_strtoupper(__('sales/customer_transfer.entry_destination_name')) }}</span>
                </td>
            </tr>
            <tr>
                <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                    <strong>{{ mb_strtoupper($customer_transfer->source_name) ?? '' }}</strong>
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_source_address'): </strong>{!! nl2br($customer_transfer->source_address) ?? '' !!}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_source_delivery_on'): </strong>{{ $customer_transfer->source_delivery_on ?? '' }}
                    <br/>
                </td>
                <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                    <strong>{{ mb_strtoupper($customer_transfer->destination_name) ?? '' }}</strong>
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_destination_address'): </strong>{!! nl2br($customer_transfer->destination_address) ?? '' !!}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_destination_delivery_on'): </strong>{{ $customer_transfer->destination_delivery_on ?? '' }}
                    <br/>
                </td>
            </tr>
        </table>
    </div>
</section>
<section class="footer">
    <div>
    <table cellpadding="0" cellspacing="0" class="table-footer" width="100%"
           style="margin-top: 5px; table-layout: fixed;">
        <tr>
            <td width="23%" class="text-center" style="vertical-align: middle; padding: 5px; word-wrap:break-word; border-top: 1px solid #cccccc;">
                @if(!empty($cfdi33))
                <img src="{{ $data['qr'] }}" width="137px" style="margin: 9px 0;"/>
                @endif
            </td>
            <td width="77%" style="vertical-align: middle; padding: 5px; word-wrap:break-word; height: 180px; border-top: 1px solid #cccccc;">
                @if(!empty($cfdi33))
                <strong>@lang('general.text_cfdi_tfd_cadena_origen')</strong><br/>
                <small>{{ $data['tfd_cadena_origen'] }}</small>
                <br/>
                <strong>@lang('general.text_cfdi_tfd_sello_cfdi')</strong><br/>
                <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloCFD'] }}</small>
                <br/>
                <strong>@lang('general.text_cfdi_tfd_sello_sat')</strong><br/>
                <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloSAT'] }}</small>
                <br/>
                @endif
            </td>
        </tr>
    </table>
    </div>
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_transfer->status == \App\Models\Sales\CustomerInvoice::CANCEL)
    <section class="watermark" style="bottom: 350px !important;">
        @if(!empty($customer_transfer->customerInvoiceCfdi->uuid))
            <span>@lang('general.text_canceled_cfdi')</span>
        @else
            <span>@lang('general.text_canceled')</span>
        @endif
    </section>
@endif
@if($draft)
    <section class="watermark" style="left: 200px; bottom: 350px !important;">
        <span>
            @if($customer_transfer->document_type2 == 'invoice')
                @lang('general.text_pre_invoice')
            @else
                @lang('general.text_pre_transfer')
            @endif
        </span>
    </section>
@endif
<section>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
            <thead>
            <tr>
                <th class="text-left">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_name')) }}</th>
                <th width="10%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_weight')) }}</th>
                <th width="10%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_m3')) }}</th>
                <th width="10%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_liters')) }}</th>
            </tr>
            </thead>
            <tbody>
            @foreach($customer_transfer->customerActiveInvoiceLineTransfers as $result)
                <tr>
                    <td>{!! nl2br($result->name) !!}</td>
                    <td class="text-center">{{ $result->weight ?? '-' }}</td>
                    <td class="text-center">{{ $result->m3>0 ? \App\Helpers\Helper::numberFormat($result->m3,0) : '-' }}</td>
                    <td class="text-center">{{ $result->liters>0 ? \App\Helpers\Helper::numberFormat($result->liters,0) : '-' }}</td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
            <tr>
                <td style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_transfer.entry_date_delivery'): </strong>{{ $customer_transfer->date_delivery ? \App\Helpers\Helper::convertSqlToDate($customer_transfer->date_delivery) : '' }}
                </td>
                <td style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_transfer.entry_valid_amount'): </strong>{{ money($customer_transfer->valid_amount,$customer_transfer->currency->code,true) }}
                </td>
                <td style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_transfer.entry_dangerous_material'): </strong>{{ $customer_transfer->dangerous_material ? __('general.text_yes') : __('general.text_no') }}
                </td>
            </tr>
        </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%" style="margin-top: 15px;">
        <thead>
        <tr>
            <th class="text-left">{{ mb_strtoupper(__('sales/customer_transfer.column_line_name')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_sat_product_id')) }}</th>
            <th width="14%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_unit_measure_id')) }}</th>
            <th width="7%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_quantity')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_price_unit')) }}</th>
            <th width="6%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_discount')) }}</th>
            <th width="11%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_amount_untaxed')) }}</th>
        </tr>
        </thead>
        <tbody>
        @if($conceptos)
        @foreach($conceptos as $result)
            @php
                //Complemento concepto

            @endphp
            <tr>
                <td>
                    {!! nl2br($result['Descripcion']) !!}
                </td>
                <td class="text-center">{{ $result['ClaveProdServ'] }}</td>
                <td class="text-center">[{{ $result['ClaveUnidad'] }}] {{ $result['Unidad'] }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatRealDecimalPlace($result['Cantidad']) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result['ValorUnitario'],\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_transfer->company_id)) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormat(!empty($result['Descuento']) ? $result['Descuento']/$result['Importe'] : 0,2) }}</td>
                <td class="text-right">{{ money($result['Importe'],$customer_transfer->currency->code,true) }}</td>
            </tr>
        @endforeach
        @else
            @foreach($customer_transfer->customerActiveInvoiceLines as $result)
                <tr>
                    <td>{!! nl2br($result->name) !!}</td>
                    <td class="text-center">{{ $result->satProduct->code }}</td>
                    <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_transfer->company_id)) }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                    <td class="text-right">{{ money($result->amount_untaxed,$customer_transfer->currency->code,true) }}</td>
                </tr>
            @endforeach
        @endif
        </tbody>
        @if($customer_transfer->document_type2 == 'invoice')
        <tfoot>
        <tr>
            <td colspan="4" class="text-center" style="vertical-align: bottom;">
                <span style="line-height: 16px;">
                    ***({{\App\Helpers\Helper::numberToWordCurrency($customer_transfer->amount_total,$customer_transfer->currency->code,$customer_transfer->currency->decimal_place)}})***
                </span>
            </td>
            <td colspan="2" class="text-right" style="vertical-align: top; padding-right: 4px;">
                <strong>@lang('general.text_amount_untaxed')</strong><br/>
                @if($customer_transfer->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_transfer->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
            </td>
            <td class="text-right">
                {{ money($customer_transfer->amount_untaxed,$customer_transfer->currency->code,true) }}<br/>
                @if($customer_transfer->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_transfer->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;">{{money(abs($result->amount_tax),$customer_transfer->currency->code,true)}}</span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ money($customer_transfer->amount_total,$customer_transfer->currency->code,true) }}</strong></span>
            </td>
        </tr>
        </tfoot>
        @endif
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="50%" style="vertical-align: middle; padding: 5px;">
                @if($customer_transfer->document_type2 == 'invoice')
                    <strong>@lang('sales/customer_transfer.entry_payment_way_id'): </strong>{{ $customer_transfer->paymentWay->name_sat ?? '' }}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_payment_method_id'): </strong>{{ $customer_transfer->paymentMethod->name_sat ?? '' }}
                    <br/>
                @endif
                <strong>@lang('sales/customer_transfer.entry_currency_id'): </strong>{{ $customer_transfer->currency->code }}{!! ($customer_transfer->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/customer_transfer.entry_currency_value').':</strong> '.round($customer_transfer->currency_value,4) :'') !!}
                <br/>
            </td>
            <td width="50%" style="vertical-align: middle; padding: 5px;">
                @if(!empty($cfdi33))
                    <strong>@lang('general.text_cfdi_certificado'): </strong>{{ $cfdi33['NoCertificado'] }}
                    <br/>
                    <strong>@lang('general.text_cfdi_tfd_no_certificado_sat'): </strong>{{ $cfdi33->complemento->timbreFiscalDigital['NoCertificadoSAT'] }}
                    <br/>
                    <strong>@lang('general.text_cfdi_tfd_fecha_timbrado'): </strong>{{ \App\Helpers\Helper::convertSqlToDateTime(str_replace('T',' ',$cfdi33->complemento->timbreFiscalDigital['FechaTimbrado'])) }}
                    <br/>
                @endif
            </td>
        </tr>
    </table>
    </div>
    @if(!empty($customer_transfer->cfdi_relation_id))
        <div>
        <p style="margin-bottom: 2px;">
            <strong>@lang('sales/customer_transfer.tab_relations') - {{ $customer_transfer->cfdiRelation->name_sat }}</strong>
        </p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                    @if($customer_transfer->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_transfer->customerInvoiceRelations as $result)
                            {{$result->relation->name ?? ''}}<br/>
                        @endforeach
                    @endif
                </td>
                <td width="85%" style="vertical-align: middle; padding: 5px;">
                    @if($customer_transfer->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_transfer->customerInvoiceRelations as $result)
                            {{$result->uuid_related}}<br/>
                        @endforeach
                    @endif
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_transfer->comment))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_transfer.entry_comment')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;">
                    {!! nl2br($customer_transfer->comment) !!}
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_transfer->compensation))
        <div>
            <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
                <tr>
                    <td width="100%" style="vertical-align: top; padding: 5px;">
                        <strong>@lang('sales/customer_transfer.entry_compensation')</strong><br/>
                        {!! nl2br($customer_transfer->compensation) !!}
                    </td>
                </tr>
            </table>
        </div>
    @endif
    <div>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
            <tr>
                <td style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_transfer.entry_driver'): </strong>{{ $customer_transfer->driver }}
                </td>
                <td style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_transfer.entry_vehicle'): </strong>{{ $customer_transfer->vehicle }}
                </td>
                <td style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_transfer.entry_vehicle_number'): </strong>{{ $customer_transfer->vehicle_number }}
                </td>
                <td style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_transfer.entry_vehicle_counter'): </strong>{{ $customer_transfer->vehicle_counter }}
                </td>
            </tr>
        </table>
    </div>
</section>
</body>
</html>
