<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_transfer->documentType->name}}-{{$customer_transfer->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 370px;
            margin-bottom: 27px;
            margin-left: 23px;
            margin-right: 23px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_transfer->company_id) }}     !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_transfer->company_id) }}     !important;
        }
        .cell-primary {
            border: 1px solid {{ \App\Helpers\Helper::companyColorPrimary($customer_transfer->company_id) }}     !important;
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_transfer->company_id) }}     !important;
            color: #ffffff;
            font-weight: bold;
            padding: 5px 2px;
            text-align: center !important;
            vertical-align: middle !important;
            text-transform: uppercase;
            font-size: 8pt;
        }
        .cell-primary-border-line {
            border: 1px solid {{ \App\Helpers\Helper::companyColorPrimary($customer_transfer->company_id) }}     !important;
            border-radius: 0 0 3px 3px;
            padding: 5px 1px;
        }
    </style>
</head>
<body style="background-color: white;">
@php
//Obtiene datos del Cfdi33
$draft = (int) $customer_transfer->status == \App\Models\Sales\CustomerInvoice::DRAFT ? true : false;
$cfdi33 = empty($data['cfdi33']) ? null : $data['cfdi33'];
$conceptos = null;
if($cfdi33){
    $conceptos = $cfdi33->conceptos;
    $conceptos = $conceptos();
}
@endphp
<section class="header" style="top: -342px;">
    @if($cfdi33 && $customer_transfer->customerInvoiceCfdi->pac->test)
    <h2 style="position: absolute; left: 0; top: -25px; color: red;">*** @lang('general.text_test_cfdi') ***</h2>
    @endif
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
            <tr>
                <td width="25%" class="" style="vertical-align: top; ">
                    @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                        <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_transfer->company_id,$customer_transfer->project_id) }}" class="invoice-logo" style="max-width: 160px !important;"/>
                    @elseif(!empty(setting('branch_office_logo_docs')))
                        <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_transfer->company_id,$customer_transfer->branch_office_id) }}" class="invoice-logo" style="max-width: 160px !important;"/>
                    @else
                        <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_transfer->company_id) }}" class="invoice-logo" style="max-width: 160px !important;"/>
                    @endif
                </td>
                <td width="25%" style="vertical-align: top; text-transform: uppercase;">
                    @if(!empty($customer_transfer->company->comercial_name))
                    <span class="text-primary" style="font-size: 8pt;">{{ mb_strtoupper($customer_transfer->company->comercial_name) }}</span>
                    <br/>
                    <br/>
                    @endif
                    <strong>{{ mb_strtoupper($customer_transfer->company->name) }}</strong>
                    @if(!empty($customer_transfer->company->address_1) || !empty($customer_transfer->company->address_2) || !empty($customer_transfer->company->address_3) || !empty($customer_transfer->company->address_4))
                        <br/>
                        {{ $customer_transfer->company->address_1 ?? '' }} {{ $customer_transfer->company->address_2 ?? '' }} {{ $customer_transfer->company->address_3 ?? '' }} {{ $customer_transfer->company->address_4 ?? '' }}
                    @endif
                    @if(!empty($customer_transfer->company->city->name) || !empty($customer_transfer->company->state->name))
                        <br/>
                        {{ !empty($customer_transfer->company->city->name) ? $customer_transfer->company->city->name . ', ' : '' }}{{ $customer_transfer->company->state->name ?? '' }}
                    @endif
                    <br/>
                    {{ $customer_transfer->company->country->name ?? '' }}{!! ($customer_transfer->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_transfer->company->postcode : '') !!}
                    <br/>
                    {{ mb_strtoupper($customer_transfer->company->taxid) }}
                    <br/>
                    ---
                    <br/>
                    {{ $customer_transfer->company->phone ?? ' ' }}
                    <br/>
                    <span style="text-transform: lowercase;">{{ $customer_transfer->company->email ?? ' ' }}</span>
                </td>
                <td width="22%" style="vertical-align: top; text-transform: uppercase;">
                    <strong>@lang('general.text_issued_in')</strong>
                    <br/>
                    @if(!empty($customer_transfer->branchOffice->address_1) || !empty($customer_transfer->branchOffice->address_2))
                        <br/>
                        {{ $customer_transfer->branchOffice->address_1 ?? '' }} {{ $customer_transfer->branchOffice->address_2 ?? '' }}
                    @endif
                    @if(!empty($customer_transfer->branchOffice->address_3) || !empty($customer_transfer->branchOffice->address_4))
                        <br/>
                        {{ $customer_transfer->branchOffice->address_3 ?? '' }} {{ $customer_transfer->branchOffice->address_4 ?? '' }}
                    @endif
                    @if(!empty($customer_transfer->branchOffice->city->name) || !empty($customer_transfer->branchOffice->state->name))
                        <br/>
                        {{ $customer_transfer->branchOffice->city->name ?? '' }}, {{ $customer_transfer->branchOffice->state->name ?? '' }}
                    @endif
                    <br/>
                    {{ $customer_transfer->branchOffice->country->name ?? '' }}{!! ($customer_transfer->branchOffice->postcode ? '&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ': ' . $customer_transfer->branchOffice->postcode : '') !!}
                </td>
                <td width="28%" class="text-right" style="vertical-align: top;">
                    <div>
                        <table cellpadding="0" cellspacing="1" class="" width="100%">
                            <tr>
                                <td width="40%" class="cell-primary" style="">@lang('sales/customer_transfer.entry_date')</td>
                                <td class="cell-primary" style="">{{ str_replace('- ','',mb_strtoupper($list_document_type2[$customer_transfer->document_type2])) }}</td>
                            </tr>
                            <tr>
                                <td class="cell-primary-border-line text-center" style="">{!! str_replace(' ','<br>',\App\Helpers\Helper::convertSqlToDateTime($customer_transfer->date)) !!}</td>
                                <td class="cell-primary-border-line text-center" style="">{{ $customer_transfer->name }}</td>
                            </tr>
                            <tr>
                                <td width="" class="" colspan="2" style="">&nbsp;</td>
                            </tr>
                            <tr>
                                <td width="" class="cell-primary" colspan="2" style="">@lang('general.text_cfdi_uuid')</td>
                            </tr>
                            <tr>
                                <td class="cell-primary-border-line text-center" colspan="2" style="">{{ $customer_transfer->customerInvoiceCfdi->uuid ?? '' }}</td>
                            </tr>
                        </table>
                    </div>
                </td>
            </tr>
            <tr>
                <td colspan="2"></td>
                <td colspan="2" style="padding-top: 13px;">
                    {{mb_strtoupper(__('base/company.column_tax_regimen'))}}: {{ $data['tax_regimen'] ?? ($customer_transfer->taxRegimen->name_sat ?? $customer_transfer->company->taxRegimen->name_sat) }}
                </td>
            </tr>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 10px;">
            <tr>
                <td width="" class="cell-primary" colspan="2" style="">@lang('general.text_customer')</td>
            </tr>
            <tr>
                <td width="50%" class="cell-primary-border-line text-left" style="vertical-align: top; height: 50px; padding: 5px;">
                    <strong>{{ mb_strtoupper($customer_transfer->customer->name) }}</strong>
                    <br>
                    {{ mb_strtoupper($customer_transfer->customer->taxid) }}
                </td>
                <td class="cell-primary-border-line text-left" style="vertical-align: top; height: 50px; padding: 5px;">
                    @if(!empty($customer_transfer->customer->address_1) || !empty($customer_transfer->customer->address_2) || !empty($customer_transfer->customer->address_3) || !empty($customer_transfer->customer->address_4))
                        {{ $customer_transfer->customer->address_1 ?? '' }} {{ $customer_transfer->customer->address_2 ?? '' }} {{ $customer_transfer->customer->address_3 ?? '' }} {{ $customer_transfer->customer->address_4 ?? '' }}
                        <br/>
                    @endif
                    @if(!empty($customer_transfer->customer->city->name) || !empty($customer_transfer->customer->state->name))
                        {{ !empty($customer_transfer->customer->city->name) ? $customer_transfer->customer->city->name . ', ' : '' }}{{ $customer_transfer->customer->state->name ?? '' }}
                        <br/>
                    @endif
                    {{ $customer_transfer->customer->country->name ?? '' }}{!! ($customer_transfer->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_transfer->customer->postcode : '') !!}

                </td>
            </tr>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px;">
            <tr>
                <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                    <span class="text-primary">{{ mb_strtoupper(__('sales/customer_transfer.entry_source_name')) }}</span>

                </td>
                <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                    <span class="text-primary">{{ mb_strtoupper(__('sales/customer_transfer.entry_destination_name')) }}</span>
                </td>
            </tr>
            <tr>
                <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                    <span><strong>{{ mb_strtoupper($customer_transfer->source_name) ?? '' }}</strong></span>
                    <br/>
                    <span><strong>@lang('sales/customer_transfer.entry_source_address')
                            : </strong>{!! nl2br($customer_transfer->source_address) ?? '' !!}</span>
                    <br/>
                    <span><strong>@lang('sales/customer_transfer.entry_source_delivery_on')
                            : </strong>{{ $customer_transfer->source_delivery_on ?? '' }}</span>
                    <br/>
                </td>
                <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                    <span><strong>{{ mb_strtoupper($customer_transfer->destination_name) ?? '' }}</strong></span>
                    <br/>
                    <span><strong>@lang('sales/customer_transfer.entry_destination_address')
                            : </strong>{!! nl2br($customer_transfer->destination_address) ?? '' !!}</span>
                    <br/>
                    <span><strong>@lang('sales/customer_transfer.entry_destination_delivery_on')
                            : </strong>{{ $customer_transfer->destination_delivery_on ?? '' }}</span>
                    <br/>
                </td>
            </tr>
        </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_transfer->status == \App\Models\Sales\CustomerInvoice::CANCEL)
    <section class="watermark" style="bottom: 450px !important;">
        @if(!empty($customer_transfer->customerInvoiceCfdi->uuid))
            <span>@lang('general.text_canceled_cfdi')</span>
        @else
            <span>@lang('general.text_canceled')</span>
        @endif
    </section>
@endif
@if($draft)
    <section class="watermark" style="left: 200px; bottom: 350px !important;">
        <span>
            @if($customer_transfer->document_type2 == 'invoice')
                @lang('general.text_pre_invoice')
            @else
                @lang('general.text_pre_transfer')
            @endif
        </span>
    </section>
@endif
<section>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
            <thead>
            <tr>
                <th class="text-left">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_name')) }}</th>
                <th width="10%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_weight')) }}</th>
                <th width="10%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_m3')) }}</th>
                <th width="10%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_liters')) }}</th>
            </tr>
            </thead>
            <tbody>
            @foreach($customer_transfer->customerActiveInvoiceLineTransfers as $result)
                <tr>
                    <td>{!! nl2br($result->name) !!}</td>
                    <td class="text-center">{{ $result->weight ?? '-' }}</td>
                    <td class="text-center">{{ $result->m3>0 ? \App\Helpers\Helper::numberFormat($result->m3,0) : '-' }}</td>
                    <td class="text-center">{{ $result->liters>0 ? \App\Helpers\Helper::numberFormat($result->liters,0) : '-' }}</td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
            <tr>
                <td style="vertical-align: top; padding: 5px;">
                <span><strong>@lang('sales/customer_transfer.entry_date_delivery')
                        : </strong>{{ $customer_transfer->date_delivery ? \App\Helpers\Helper::convertSqlToDate($customer_transfer->date_delivery) : '' }}</span>
                </td>
                <td style="vertical-align: top; padding: 5px;">
                    <span><strong>@lang('sales/customer_transfer.entry_valid_amount')
                            : </strong>{{ money($customer_transfer->valid_amount,$customer_transfer->currency->code,true) }}</span>
                </td>
                <td style="vertical-align: top; padding: 5px;">
                    <span><strong>@lang('sales/customer_transfer.entry_dangerous_material')
                            : </strong>{{ $customer_transfer->dangerous_material ? __('general.text_yes') : __('general.text_no') }}</span>
                </td>
            </tr>
        </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%" style="margin-top: 15px;">
        <thead>
        <tr>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_sat_product_id')) }}</th>
            <th width="7%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_quantity')) }}</th>
            <th class="text-left">{{ mb_strtoupper(__('sales/customer_transfer.column_line_name')) }}</th>
            <th width="14%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_unit_measure_id')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_price_unit')) }}</th>
            <th width="6%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_discount')) }}</th>
            <th width="11%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_amount_untaxed')) }}</th>
        </tr>
        </thead>
        <tbody>
        @if($conceptos)
        @foreach($conceptos as $result)
            @php
                //Complemento concepto

            @endphp
            <tr>
                <td class="text-center">{{ $result['ClaveProdServ'] }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatRealDecimalPlace($result['Cantidad']) }}</td>
                <td>
                    {!! nl2br($result['Descripcion']) !!}
                </td>
                <td class="text-center">[{{ $result['ClaveUnidad'] }}] {{ $result['Unidad'] }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result['ValorUnitario'],\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_transfer->company_id)) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormat(!empty($result['Descuento']) ? $result['Descuento']/$result['Importe'] : 0,2) }}</td>
                <td class="text-right">{{ money($result['Importe'],$customer_transfer->currency->code,true) }}</td>
            </tr>
        @endforeach
        @else
            @foreach($customer_transfer->customerActiveInvoiceLines as $result)
                <tr>
                    <td class="text-center">{{ $result->satProduct->code }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                    <td>{!! nl2br($result->name) !!}</td>
                    <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_transfer->company_id)) }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                    <td class="text-right">{{ money($result->amount_untaxed,$customer_transfer->currency->code,true) }}</td>
                </tr>
            @endforeach
        @endif
        </tbody>
        @if($customer_transfer->document_type2 == 'invoice')
        <tfoot>
        <tr>
            <td colspan="4" class="text-left" style="vertical-align: top;">
                <span style="line-height: 16px;">
                    ***({{\App\Helpers\Helper::numberToWordCurrency($customer_transfer->amount_total,$customer_transfer->currency->code,$customer_transfer->currency->decimal_place)}})***
                </span>
            </td>
            <td colspan="2" class="text-right" style="vertical-align: top; padding-right: 4px;">
                <strong>@lang('general.text_amount_untaxed')</strong><br/>
                @if($customer_transfer->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_transfer->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
            </td>
            <td class="text-right">
                {{ money($customer_transfer->amount_untaxed,$customer_transfer->currency->code,true) }}<br/>
                @if($customer_transfer->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_transfer->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;">{{money(abs($result->amount_tax),$customer_transfer->currency->code,true)}}</span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ money($customer_transfer->amount_total,$customer_transfer->currency->code,true) }}</strong></span>
            </td>
        </tr>
        </tfoot>
        @endif
    </table>
    </div>
    @if(!empty($customer_transfer->cfdi_relation_id))
        <div>
        <p style="margin-bottom: 2px;">
            <strong>@lang('sales/customer_transfer.tab_relations') - {{ $customer_transfer->cfdiRelation->name_sat }}</strong>
        </p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                    @if($customer_transfer->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_transfer->customerInvoiceRelations as $result)
                            {{$result->relation->name ?? ''}}<br/>
                        @endforeach
                    @endif
                </td>
                <td width="85%" style="vertical-align: middle; padding: 5px;">
                    @if($customer_transfer->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_transfer->customerInvoiceRelations as $result)
                            {{$result->uuid_related}}<br/>
                        @endforeach
                    @endif
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_transfer->comment))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_transfer.entry_comment')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;">
                    {!! nl2br($customer_transfer->comment) !!}
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_transfer->compensation))
        <div>
            <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
                <tr>
                    <td width="100%" style="vertical-align: top; padding: 5px;">
                        <strong>@lang('sales/customer_transfer.entry_compensation')</strong><br/>
                        {!! nl2br($customer_transfer->compensation) !!}
                    </td>
                </tr>
            </table>
        </div>
    @endif
    <div>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
            <tr>
                <td style="vertical-align: top; padding: 5px;">
                <span><strong>@lang('sales/customer_transfer.entry_driver')
                        : </strong>{{ $customer_transfer->driver }}</span>
                </td>
                <td style="vertical-align: top; padding: 5px;">
                    <span><strong>@lang('sales/customer_transfer.entry_vehicle')
                            : </strong>{{ $customer_transfer->vehicle }}</span>
                </td>
                <td style="vertical-align: top; padding: 5px;">
                    <span><strong>@lang('sales/customer_transfer.entry_vehicle_number')
                            : </strong>{{ $customer_transfer->vehicle_number }}</span>
                </td>
                <td style="vertical-align: top; padding: 5px;">
                    <span><strong>@lang('sales/customer_transfer.entry_vehicle_counter')
                            : </strong>{{ $customer_transfer->vehicle_counter }}</span>
                </td>
            </tr>
        </table>
    </div>
    @if(!empty($cfdi33))
        <div>
            <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                <tr>
                    <td width="" class="cell-primary" style="">@lang('general.text_cfdi_tfd_cadena_origen')</td>
                </tr>
                <tr>
                    <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 45px; padding: 5px;  word-wrap:break-word;">
                        {{ $data['tfd_cadena_origen'] }}
                    </td>
                </tr>
            </table>
        </div>
        <div>
            <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                <tr>
                    <td width="" class="cell-primary" style="">@lang('general.text_cfdi_tfd_sello_cfdi')</td>
                </tr>
                <tr>
                    <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 35px; padding: 5px;  word-wrap:break-word;">
                        {{ $cfdi33->complemento->timbreFiscalDigital['SelloCFD'] }}
                    </td>
                </tr>
            </table>
        </div>
        <div>
            <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
                <tr>
                    <td width="" class="cell-primary" style="">@lang('general.text_cfdi_tfd_sello_sat')</td>
                </tr>
                <tr>
                    <td width="" class="cell-primary-border-line text-left" style="vertical-align: top; height: 35px; padding: 5px;  word-wrap:break-word;">
                        {{ $cfdi33->complemento->timbreFiscalDigital['SelloSAT'] }}
                    </td>
                </tr>
            </table>
        </div>
    @endif
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px; table-layout: fixed;">
            <tr>
                <td width="100%" class="cell-primary" style=""></td>
            </tr>
            <tr>
                <td width="100%" class="cell-primary-border-line text-left" style="vertical-align: top; padding: 3px;  word-wrap:break-word;">
                    <table cellpadding="0" cellspacing="0" class="" width="100%" style="table-layout: fixed;">
                        <tr>
                            <td width="20%" class="text-center" style="vertical-align: top;">
                                @if(!empty($cfdi33))
                                    <img src="{{ $data['qr'] }}" width="120px" style="margin: 5px 0;"/>
                                @endif
                            </td>
                            <td width="18%" class="" style="vertical-align: top; padding-top: 6px;">
                                @lang('base/document_type.entry_cfdi_type_id'):<br>
                                @lang('sales/customer_transfer.entry_date'):<br>
                                @if($customer_transfer->document_type2 == 'invoice')
                                @lang('sales/customer_transfer.entry_date_due'):<br>
                                @endif
                                @if(!empty($cfdi33))
                                    @lang('general.text_cfdi_tfd_fecha_timbrado'):<br>
                                    @lang('general.text_cfdi_certificado'):<br>
                                    @lang('general.text_cfdi_tfd_no_certificado_sat'):<br>
                                @endif
                                @if($customer_transfer->document_type2 == 'invoice')
                                @lang('sales/customer_transfer.entry_payment_way_id'):<br>
                                @lang('sales/customer_transfer.entry_payment_method_id'):<br>
                                @endif
                                @lang('sales/customer_transfer.entry_payment_term_id'):<br>
                                @lang('sales/customer_transfer.entry_cfdi_use_id'):<br>
                            </td>
                            <td width="" class="" style="vertical-align: top; padding-top: 6px;">
                                {{ $customer_transfer->documentType->cfdiType->name_sat ?? '' }}<br>
                                {{\App\Helpers\Helper::convertSqlToDateTime($customer_transfer->date)}}<br>
                                @if($customer_transfer->document_type2 == 'invoice')
                                {{ \App\Helpers\Helper::convertSqlToDate($customer_transfer->date_due) }}<br>
                                @endif
                                @if(!empty($cfdi33))
                                    {{ \App\Helpers\Helper::convertSqlToDateTime(str_replace('T',' ',$cfdi33->complemento->timbreFiscalDigital['FechaTimbrado'])) }}<br>
                                    {{ $cfdi33['NoCertificado'] }}<br>
                                    {{ $cfdi33->complemento->timbreFiscalDigital['NoCertificadoSAT'] }}<br>
                                @endif
                                @if($customer_transfer->document_type2 == 'invoice')
                                {{ $customer_transfer->paymentWay->name_sat }}<br>
                                {{ $customer_transfer->paymentMethod->name_sat }}<br>
                                @endif
                                {{ $customer_transfer->paymentTerm->name }}<br>
                                {{ $customer_transfer->cfdiUse->name_sat }}<br>
                            </td>
                            <td width="7%" class="" style="vertical-align: top; padding-top: 6px;">
                                @lang('sales/customer_transfer.entry_currency_id'):<br>
                                @lang('sales/customer_transfer.entry_currency_value'):<br>
                            </td>
                            <td width="10%" class="text-left" style="vertical-align: top; padding-top: 12px;">
                                {{ $customer_transfer->currency->code }}<br>
                                {!! ($customer_transfer->currency->code!='MXN' ? round($customer_transfer->currency_value,4) :'') !!}<br>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>
</section>
</body>
</html>
