<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_transfer->documentType->name}}-{{$customer_transfer->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 315px;
            margin-bottom: 225px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_transfer->company_id) }} !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_transfer->company_id) }} !important;
        }
    </style>
</head>
<body style="background-color: white;">
@php
//Obtiene datos del Cfdi33
$draft = (int) $customer_transfer->status == \App\Models\Sales\CustomerInvoice::DRAFT ? true : false;
$cfdi33 = empty($data['cfdi33']) ? null : $data['cfdi33'];
$conceptos = null;
if($cfdi33){
    $conceptos = $cfdi33->conceptos;
    $conceptos = $conceptos();
}
@endphp
<section class="header" style="top: -292px;">
    @if($cfdi33 && $customer_transfer->customerInvoiceCfdi->pac->test)
    <h2 style="position: absolute; left: 37%; top: -15px; color: red;">*** @lang('general.text_test_cfdi') ***</h2>
    @endif
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="55%" class="text-left">
                <span class="text-primary">{{ mb_strtoupper($list_document_type2[$customer_transfer->document_type2]) }}</span>
            </td>
            <td width="45%" class="text-right">
                <h1>{{ mb_strtoupper($customer_transfer->documentType->name) }}</h1>
            </td>
        </tr>
        <tr>
            <td width="55%" style="vertical-align: top; padding-top: 10px; position: relative;">
                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_transfer->company_id,$customer_transfer->project_id) }}"
                    class="invoice-logo" />
                @elseif(!empty(setting('branch_office_logo_docs')))
                <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_transfer->company_id,$customer_transfer->branch_office_id) }}"
                    class="invoice-logo" />
                @else
                <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_transfer->company_id) }}"
                    class="invoice-logo" />
                @endif
            </td>
            <td width="45%" class="text-right text-company" style="vertical-align: top; padding-top: 10px; height: 118px;">
                <strong>{{ mb_strtoupper($customer_transfer->company->name) }}</strong>
                <br/>
                {{ $data['tax_regimen'] ?? ($customer_transfer->taxRegimen->name_sat ?? $customer_transfer->company->taxRegimen->name_sat) }}
                @if(!empty($customer_transfer->company->address_1) || !empty($customer_transfer->company->address_2) || !empty($customer_transfer->company->address_3) || !empty($customer_transfer->company->address_4))
                    <br/>
                    {{ $customer_transfer->company->address_1 ?? '' }} {{ $customer_transfer->company->address_2 ?? '' }} {{ $customer_transfer->company->address_3 ?? '' }} {{ $customer_transfer->company->address_4 ?? '' }}
                @endif
                @if(!empty($customer_transfer->company->city->name) || !empty($customer_transfer->company->state->name))
                    <br/>
                    {{ !empty($customer_transfer->company->city->name) ? $customer_transfer->company->city->name . ', ' : '' }}{{ $customer_transfer->company->state->name ?? '' }}
                @endif
                <br/>
                {{ $customer_transfer->company->country->name ?? '' }}{!! ($customer_transfer->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_transfer->company->postcode : '') !!}
                <br/>
                {{ mb_strtoupper($customer_transfer->company->taxid) }}
                <br/>
                ---
                <br/>
                {{ $customer_transfer->company->phone ?? ' ' }}
                <br/>
                {{ $customer_transfer->company->email ?? ' ' }}
            </td>
        </tr>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary"># {{ $customer_transfer->name }}</span>
            </td>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                @if($customer_transfer->document_type2 == 'invoice')
                <span class="text-primary">{{ mb_strtoupper(__('general.text_customer')) }}</span>
                @endif
            </td>
        </tr>
        <tr>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <strong>@lang('general.text_cfdi_uuid'): </strong>{{ $customer_transfer->customerInvoiceCfdi->uuid ?? '' }}
                <br/>
                <strong>@lang('base/document_type.entry_cfdi_type_id'): </strong>{{ $customer_transfer->documentType->cfdiType->name_sat ?? '' }}
                <br/>
                <strong>@lang('sales/customer_transfer.entry_date'): </strong>{{ \App\Helpers\Helper::convertSqlToDateTime($customer_transfer->date) }}
                <br/>
                @if($customer_transfer->document_type2 == 'invoice')
                <strong>@lang('sales/customer_transfer.entry_date_due'): </strong>{{ $customer_transfer->date_due ? \App\Helpers\Helper::convertSqlToDate($customer_transfer->date_due) : '' }}
                <br/>
                @endif
                <strong>@lang('sales/customer_transfer.entry_payment_term_id'): </strong>{{ $customer_transfer->paymentTerm->name ?? '' }}
                <br/>
                <strong>@lang('sales/customer_transfer.entry_cfdi_use_id'): </strong>{{ $customer_transfer->cfdiUse->name_sat ?? '' }}
                <br/>
                <strong>@lang('general.text_issued_in'): </strong>{{ $customer_transfer->branchOffice->name ?? '' }} {!! ($customer_transfer->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $customer_transfer->branchOffice->postcode : '') !!}
                <br/>
            </td>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                @if($customer_transfer->document_type2 == 'invoice')
                <strong>{{ mb_strtoupper(!empty($cfdi33->Receptor['Nombre']) ? $cfdi33->Receptor['Nombre'] : $customer_transfer->customer->name) }}</strong>
                @if(!empty($customer_transfer->customer->address_1) || !empty($customer_transfer->customer->address_2) || !empty($customer_transfer->customer->address_3) || !empty($customer_transfer->customer->address_4))
                    <br/>
                    {{ $customer_transfer->customer->address_1 ?? '' }} {{ $customer_transfer->customer->address_2 ?? '' }} {{ $customer_transfer->customer->address_3 ?? '' }} {{ $customer_transfer->customer->address_4 ?? '' }}
                @endif
                @if(!empty($customer_transfer->customer->city->name) || !empty($customer_transfer->customer->state->name))
                    <br/>
                    {{ !empty($customer_transfer->customer->city->name) ? $customer_transfer->customer->city->name . ', ' : '' }}{{ $customer_transfer->customer->state->name ?? '' }}
                @endif
                <br/>
                {{ $customer_transfer->customer->country->name ?? '' }}{!! ($customer_transfer->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_transfer->customer->postcode : '') !!}
                <br/>
                @lang('sales/customer_transfer.entry_taxid'): {{ mb_strtoupper($cfdi33->Receptor['Rfc'] ?? $customer_transfer->customer->taxid) }}
                <br />
                @lang('sales/customer_transfer.entry_tax_regimen_customer_id2'): {{ $data['tax_regimen_customer'] ?? ($customer_transfer->taxRegimenCustomer->name_sat ?? $customer_transfer->customer->taxRegimen->name_sat) }}
                @endif
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="footer">
    <div>
    <table cellpadding="0" cellspacing="0" class="table-footer" width="100%"
           style="margin-top: 5px; table-layout: fixed;">
        <tr>
            <td width="23%" class="text-center" style="vertical-align: middle; padding: 5px; word-wrap:break-word;">
                @if(!empty($cfdi33))
                <img src="{{ $data['qr'] }}" width="137px" style="margin: 9px 0;"/>
                @endif
            </td>
            <td width="77%" style="vertical-align: middle; padding: 5px; word-wrap:break-word; height: 180px;">
                @if(!empty($cfdi33))
                <strong>@lang('general.text_cfdi_tfd_cadena_origen')</strong><br/>
                <small>{{ $data['tfd_cadena_origen'] }}</small>
                <br/>
                <strong>@lang('general.text_cfdi_tfd_sello_cfdi')</strong><br/>
                <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloCFD'] }}</small>
                <br/>
                <strong>@lang('general.text_cfdi_tfd_sello_sat')</strong><br/>
                <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloSAT'] }}</small>
                <br/>
                @endif
            </td>
        </tr>
    </table>
    </div>
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi_40')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($customer_transfer->status == \App\Models\Sales\CustomerInvoice::CANCEL)
    <section class="watermark" style="bottom: 350px !important;">
        @if(!empty($customer_transfer->customerInvoiceCfdi->uuid))
            <span>@lang('general.text_canceled_cfdi')</span>
        @else
            <span>@lang('general.text_canceled')</span>
        @endif
    </section>
@endif
@if($draft)
    <section class="watermark" style="left: 200px; bottom: 350px !important;">
        <span>
            @if($customer_transfer->document_type2 == 'invoice')
                @lang('general.text_pre_invoice')
            @else
                @lang('general.text_pre_transfer')
            @endif
        </span>
    </section>
@endif
<section>
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="">
            <tr>
                <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                    <span class="text-primary">{{ mb_strtoupper(__('sales/customer_transfer.tab_source_ubication')) }}</span>

                </td>
                <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                    <span class="text-primary">{{ mb_strtoupper(__('sales/customer_transfer.tab_destination_ubication')) }}</span>
                </td>
            </tr>
            <tr>
                <td width="50%" class="" style="vertical-align: top; padding-top: 7px;">
                    @if(!empty($customer_transfer_transfer->source_name))
                        <strong>{{ mb_strtoupper($customer_transfer_transfer->source_name) }}</strong>
                        <br/>
                    @endif
                    @if(!empty($customer_transfer_transfer->source_taxid))
                        <span>{{ mb_strtoupper($customer_transfer_transfer->source_taxid) }}</span>
                        <br/>
                    @endif
                    @if(!empty($customer_transfer_transfer->source_address_1) || !empty($customer_transfer_transfer->source_address_2) || !empty($customer_transfer_transfer->source_address_3) || !empty($customer_transfer_transfer->source_address_4))
                        {{ $customer_transfer_transfer->source_address_1 ?? '' }} {{ $customer_transfer_transfer->source_address_2 ?? '' }} {{ $customer_transfer_transfer->source_address_3 ?? '' }} {{ $customer_transfer_transfer->source_address_4 ?? '' }}
                        <br/>
                    @endif
                    @if(!empty($customer_transfer_transfer->sourceCity->name) || !empty($customer_transfer_transfer->sourceState->name))
                        {{ !empty($customer_transfer_transfer->sourceCity->name) ? $customer_transfer_transfer->sourceCity->name . ', ' : '' }}{{ $customer_transfer_transfer->sourceState->name ?? '' }}
                    @endif
                    {{ $customer_transfer_transfer->sourceCountry->name ?? '' }}{!! ($customer_transfer_transfer->source_postcode ? '&nbsp;&nbsp;' . __('sales/customer_transfer.entry_source_postcode') . ': ' . $customer_transfer_transfer->source_postcode : '') !!}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_source_date'): </strong>{{ \App\Helpers\Helper::convertSqlToDateTime($customer_transfer_transfer->source_date) }}
                </td>
                <td width="50%" class="" style="vertical-align: top; padding-top: 7px;">
                    @if(!empty($customer_transfer_transfer->destination_name))
                        <strong>{{ mb_strtoupper($customer_transfer_transfer->destination_name) }}</strong>
                        <br/>
                    @endif
                    @if(!empty($customer_transfer_transfer->destination_taxid))
                        <span>{{ mb_strtoupper($customer_transfer_transfer->destination_taxid) }}</span>
                        <br/>
                    @endif
                    @if(!empty($customer_transfer_transfer->destination_address_1) || !empty($customer_transfer_transfer->destination_address_2) || !empty($customer_transfer_transfer->destination_address_3) || !empty($customer_transfer_transfer->destination_address_4))
                        {{ $customer_transfer_transfer->destination_address_1 ?? '' }} {{ $customer_transfer_transfer->destination_address_2 ?? '' }} {{ $customer_transfer_transfer->destination_address_3 ?? '' }} {{ $customer_transfer_transfer->destination_address_4 ?? '' }}
                        <br/>
                    @endif
                    @if(!empty($customer_transfer_transfer->destinationCity->name) || !empty($customer_transfer_transfer->destinationState->name))
                        {{ !empty($customer_transfer_transfer->destinationCity->name) ? $customer_transfer_transfer->destinationCity->name . ', ' : '' }}{{ $customer_transfer_transfer->destinationState->name ?? '' }}
                    @endif
                    {{ $customer_transfer_transfer->destinationCountry->name ?? '' }}{!! ($customer_transfer_transfer->destination_postcode ? '&nbsp;&nbsp;' . __('sales/customer_transfer.entry_destination_postcode') . ': ' . $customer_transfer_transfer->destination_postcode : '') !!}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_destination_date'): </strong>{{ \App\Helpers\Helper::convertSqlToDateTime($customer_transfer_transfer->destination_date) }}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_destination_distance_traveled'): </strong>{{ $customer_transfer_transfer->destination_distance_traveled }}
                    <br/>
                </td>
            </tr>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 10px;">
            <tr>
                <td width="49%" style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_transfer.entry_trans_transport_type_id'): </strong>{{ $customer_transfer_transfer->transTransportType->name_sat ?? '' }}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_transport_int'): </strong>{{ $customer_transfer_transfer->transport_int }}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_in_out_product'): </strong>{{ $customer_transfer_transfer->in_out_product ?? '' }}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_in_out_country_id'): </strong>{{ $customer_transfer_transfer->inOutCountry->name ?? '' }}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_transport_type_id'): </strong>{{ $customer_transfer_transfer->transportType->name ?? '' }}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_distance_traveled'): </strong>{{ $customer_transfer_transfer->distance_traveled ?? '' }}
                </td>
                <td style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_transfer.entry_permit_type_id'): </strong>{{ $customer_transfer_transfer->permitType->code ?? '' }}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_permit_number'): </strong>{{ $customer_transfer_transfer->permit_number }}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_setting_transport_id'): </strong>{{ $customer_transfer_transfer->settingTransport->code ?? '' }}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_vehicle'): </strong>{{ $customer_transfer_transfer->vehicle }}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_vehicle_number'): </strong>{{ $customer_transfer_transfer->vehicle_number }}
                </td>
            </tr>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 10px;">
            <tr>
                <td width="49%" style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_transfer.entry_measure_packaging_id'): </strong>{{ $customer_transfer_transfer->measurePackaging->name_sat ?? '' }}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_gross_weight'): </strong>{{ $customer_transfer_transfer->transport_int ?? '' }}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_merchandise'): </strong>{{ $customer_transfer->customerActiveInvoiceLineTransfers->count() }}
                </td>
                <td style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_transfer.entry_net_weight'): </strong>{{ $customer_transfer_transfer->net_weight ?? '' }}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_appraisal_fee'): </strong>{{ $customer_transfer_transfer->appraisal_fee ?? '' }}
                </td>
            </tr>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-items" width="100%" style="margin-top: 10px;">
            <thead>
            <tr>
                <th>{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_quantity')) }}</th>
                <th >{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_unit_measure_id')) }}</th>
                <th class="text-left">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_name')) }}</th>
                <th class="text-left">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_packaging_type_id')) }}</th>
                <th class="text-left">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_dangerous_product_id')) }}</th>
                <th >{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_weight')) }}</th>
                <th >{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_dimensions')) }}</th>
            </tr>
            </thead>
            <tbody>
            @foreach($customer_transfer->customerActiveInvoiceLineTransfers as $result)
                <tr>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place ?? 0) }}</td>
                    <td class="text-center">{{ $result->unitMeasure->code ?? '' }}</td>
                    <td>{{ !empty($result->satProduct->code) ? $result->satProduct->code . ' - ' : '' }}{!! nl2br($result->name) !!}</td>
                    <td class="text-left">{{ $result->packagingType->name_sat ?? '' }}</td>
                    <td class="text-left">{{ $result->dangerousProduct->name_sat ?? '' }}</td>
                    <td class="text-center">{{ $result->weight ?? '' }}</td>
                    <td class="text-center">{{ $result->dimensions ?? '' }}</td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-items" width="100%" style="margin-top: 10px;">
            <thead>
            <tr>
                <th class="text-center" style="width: 25%">{{ mb_strtoupper(__('sales/customer_transfer.entry_name_insurer_type_table')) }}</th>
                <th class="text-left">{{ mb_strtoupper(__('sales/customer_transfer.entry_name_insurer_table')) }}</th>
                <th class="text-center" style="width: 25%">{{ mb_strtoupper(__('sales/customer_transfer.entry_policy_number_table')) }}</th>
            </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="text-center">{{__('sales/customer_transfer.entry_name_insurer_1')}}</td>
                    <td class="text-left">{{ $customer_transfer_transfer->name_insurer }}</td>
                    <td class="text-center">{{ $customer_transfer_transfer->policy_number }}</td>
                </tr>
                <tr>
                    <td class="text-center">{{__('sales/customer_transfer.entry_name_insurer_2')}}</td>
                    <td class="text-left">{{ $customer_transfer_transfer->name_insurer2 }}</td>
                    <td class="text-center">{{ $customer_transfer_transfer->policy_number2 }}</td>
                </tr>
                <tr>
                    <td class="text-center">{{__('sales/customer_transfer.entry_name_insurer_3')}}</td>
                    <td class="text-left">{{ $customer_transfer_transfer->name_insurer3 }}</td>
                    <td class="text-center">{{ $customer_transfer_transfer->policy_number3 }}</td>
                </tr>
                <tr>
                    <td class="text-center">{{__('sales/customer_transfer.entry_insurance_value')}}</td>
                    <td class="text-left">{{ $customer_transfer_transfer->insurance_value ?? '--' }}</td>
                    <td class="text-center"></td>
                </tr>
            </tbody>
        </table>
    </div>
    @if (!empty($customer_transfer_transfer->trailer_type_id_1) || !empty($customer_transfer_transfer->trailer_type_id_2) || !empty($customer_transfer_transfer->trailer_type_id_3) || !empty($customer_transfer_transfer->trailer_type_id_4))
    <div>
        <table cellpadding="0" cellspacing="0" class="table-items" width="100%" style="margin-top: 10px;">
            <thead>
            <tr>
                <th class="text-center" style="width: 25%">{{ mb_strtoupper(__('sales/customer_transfer.entry_trailer_type_id')) }}</th>
                <th class="text-left">{{ mb_strtoupper(__('sales/customer_transfer.entry_trailer_number')) }}</th>
            </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="text-left">{{ $customer_transfer_transfer->trailerType1->name ?? '' }}</td>
                    <td class="text-center">{{ $customer_transfer_transfer->trailer_number_1 ?? '' }}</td>
                </tr>
                @if (!empty($customer_transfer_transfer->trailer_type_id_2))
                <tr>
                    <td class="text-left">{{ $customer_transfer_transfer->trailerType2->name ?? '' }}</td>
                    <td class="text-center">{{ $customer_transfer_transfer->trailer_number_2 ?? '' }}</td>
                </tr>
                @endif
                @if (!empty($customer_transfer_transfer->trailer_type_id_3))
                <tr>
                    <td class="text-left">{{ $customer_transfer_transfer->trailerType3->name ?? '' }}</td>
                    <td class="text-center">{{ $customer_transfer_transfer->trailer_number_3 ?? '' }}</td>
                </tr>
                @endif
                @if (!empty($customer_transfer_transfer->trailer_type_id_4))
                <tr>
                    <td class="text-left">{{ $customer_transfer_transfer->trailerType4->name ?? '' }}</td>
                    <td class="text-center">{{ $customer_transfer_transfer->trailer_number_4 ?? '' }}</td>
                </tr>
                @endif
            </tbody>
        </table>
    </div>
    @endif
    <div>
        <table cellpadding="0" cellspacing="0" class="table-items" width="100%" style="margin-top: 15px;">
            <thead>
                <tr>
                    <th class="text-center" colspan="6">{{ mb_strtoupper(__('sales/customer_transfer.tab_transport_figure')) }}</th>
                </tr>
                <tr>
                    <th class="text-center">{{ mb_strtoupper(__('sales/customer_transfer.entry_tf_type')) }}</th>
                    <th class="text-center">{{ mb_strtoupper(__('sales/customer_transfer.entry_tf_taxid')) }}</th>
                    <th class="text-left">{{ mb_strtoupper(__('sales/customer_transfer.entry_tf_name')) }}</th>
                    <th class="text-left">{{ mb_strtoupper(__('sales/customer_transfer.entry_tf_address')) }}</th>
                    <th class="text-center">{{ mb_strtoupper(__('sales/customer_transfer.entry_tf_tr_country')) }}</th>
                    <th class="text-center">{{ mb_strtoupper(__('sales/customer_transfer.entry_tf_numid')) }}</th>
                </tr>
            </thead>
            <tbody>
                @if(!empty($customer_transfer_transfer->operator_name) || !empty($customer_transfer_transfer->operator_taxid))
                <tr>
                    <td class="text-center">{{__('sales/customer_transfer.text_operator')}}</td>
                    <td class="text-center">{{ $customer_transfer_transfer->operator_taxid }}</td>
                    <td class="text-left">
                        {{ $customer_transfer_transfer->operator_name }}
                        @if (!empty($customer_transfer_transfer->operator_license))
                            <br/>{{__('sales/customer_transfer.entry_operator_license')}}: {{$customer_transfer_transfer->operator_license}}
                        @endif
                    </td>
                    <td class="text-left">{{ $customer_transfer_transfer->operatorCountry->name ?? '' }}</td>
                    <td class="text-center">{{ $customer_transfer_transfer->operatorTrCountry->name ?? '' }}</td>
                    <td class="text-center">{{ $customer_transfer_transfer->operator_numid }}</td>
                </tr>
                @endif
                @if(!empty($customer_transfer_transfer->owner_name) || !empty($customer_transfer_transfer->owner_taxid))
                <tr>
                    <td class="text-center">{{__('sales/customer_transfer.text_owner')}}</td>
                    <td class="text-center">{{ $customer_transfer_transfer->owner_taxid }}</td>
                    <td class="text-left">{{ $customer_transfer_transfer->owner_name }}</td>
                    <td class="text-left">{{ $customer_transfer_transfer->ownerCountry->name ?? '' }}</td>
                    <td class="text-center">{{ $customer_transfer_transfer->ownerTrCountry->name ?? '' }}</td>
                    <td class="text-center">{{ $customer_transfer_transfer->owner_numid }}</td>
                </tr>
                @endif
                @if(!empty($customer_transfer_transfer->lessee_name) || !empty($customer_transfer_transfer->lessee_taxid))
                <tr>
                    <td class="text-center">{{__('sales/customer_transfer.text_lessee')}}</td>
                    <td class="text-center">{{ $customer_transfer_transfer->lessee_taxid }}</td>
                    <td class="text-left">{{ $customer_transfer_transfer->lessee_name }}</td>
                    <td class="text-left">{{ $customer_transfer_transfer->lesseeCountry->name ?? '' }}</td>
                    <td class="text-center">{{ $customer_transfer_transfer->lesseeTrCountry->name ?? '' }}</td>
                    <td class="text-center">{{ $customer_transfer_transfer->lessee_numid }}</td>
                </tr>
                @endif
            </tbody>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-items" width="100%" style="margin-top: 15px;">
            <thead>
            <tr>
                <th class="text-left">{{ mb_strtoupper(__('sales/customer_transfer.column_line_name')) }}</th>
                <th width="9%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_sat_product_id')) }}</th>
                <th width="14%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_unit_measure_id')) }}</th>
                <th width="7%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_quantity')) }}</th>
                <th width="9%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_price_unit')) }}</th>
                <th width="6%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_discount')) }}</th>
                <th width="11%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_amount_untaxed')) }}</th>
            </tr>
            </thead>
            <tbody>
            @if($conceptos)
            @foreach($conceptos as $result)
                @php
                    //Complemento concepto

                @endphp
                <tr>
                    <td>
                        {!! nl2br($result['Descripcion']) !!}
                        @php
                        echo '<br />';
                        echo __('sales/customer_transfer.column_line_tax_object') . ': '.$result['ObjetoImp'].'<br />';
                        @endphp
                    </td>
                    <td class="text-center">{{ $result['ClaveProdServ'] }}</td>
                    <td class="text-center">[{{ $result['ClaveUnidad'] }}] {{ $result['Unidad'] }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatRealDecimalPlace($result['Cantidad']) }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result['ValorUnitario'],\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_transfer->company_id)) }}</td>
                    <td class="text-center">{{ \App\Helpers\Helper::numberFormat(!empty($result['Descuento']) ? $result['Descuento']/$result['Importe'] : 0,2) }}</td>
                    <td class="text-right">{{ money($result['Importe'],$customer_transfer->currency->code,true) }}</td>
                </tr>
            @endforeach
            @else
                @foreach($customer_transfer->customerActiveInvoiceLines as $result)
                    <tr>
                        <td>{!! nl2br($result->name) !!}</td>
                        <td class="text-center">{{ $result->satProduct->code }}</td>
                        <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                        <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                        <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_transfer->company_id)) }}</td>
                        <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                        <td class="text-right">{{ money($result->amount_untaxed,$customer_transfer->currency->code,true) }}</td>
                    </tr>
                @endforeach
            @endif
            </tbody>
            @if($customer_transfer->document_type2 == 'invoice')
            <tfoot>
            <tr>
                <td colspan="4" class="text-center" style="vertical-align: bottom;">
                    <span style="line-height: 16px;">
                        ***({{\App\Helpers\Helper::numberToWordCurrency($customer_transfer->amount_total,$customer_transfer->currency->code,$customer_transfer->currency->decimal_place)}})***
                    </span>
                </td>
                <td colspan="2" class="text-right" style="vertical-align: top; padding-right: 4px;">
                    <strong>@lang('general.text_amount_untaxed')</strong><br/>
                    @if($customer_transfer->customerInvoiceTaxes->isNotEmpty())
                        @foreach($customer_transfer->customerInvoiceTaxes as $result)
                            <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                        @endforeach
                    @endif
                    <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
                </td>
                <td class="text-right">
                    {{ money($customer_transfer->amount_untaxed,$customer_transfer->currency->code,true) }}<br/>
                    @if($customer_transfer->customerInvoiceTaxes->isNotEmpty())
                        @foreach($customer_transfer->customerInvoiceTaxes as $result)
                            <span style="line-height: 16px;">{{money(abs($result->amount_tax),$customer_transfer->currency->code,true)}}</span><br/>
                        @endforeach
                    @endif
                    <span style="line-height: 16px;"><strong>{{ money($customer_transfer->amount_total,$customer_transfer->currency->code,true) }}</strong></span>
                </td>
            </tr>
            </tfoot>
            @endif
        </table>
        </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 15px;">
        <tr>
            <td width="50%" style="vertical-align: middle; padding: 5px;">
                @if(!empty($cfdi33))
                    <strong>@lang('general.text_cfdi_certificado'): </strong>{{ $cfdi33['NoCertificado'] }}
                    <br/>
                    <strong>@lang('general.text_cfdi_tfd_no_certificado_sat'): </strong>{{ $cfdi33->complemento->timbreFiscalDigital['NoCertificadoSAT'] }}
                    <br/>
                    <strong>@lang('general.text_cfdi_tfd_fecha_timbrado'): </strong>{{ \App\Helpers\Helper::convertSqlToDateTime(str_replace('T',' ',$cfdi33->complemento->timbreFiscalDigital['FechaTimbrado'])) }}
                    <br/>
                @endif
            </td>
            <td width="50%" style="vertical-align: middle; padding: 5px;">
                @if($customer_transfer->document_type2 == 'invoice')
                    <strong>@lang('sales/customer_transfer.entry_payment_way_id'): </strong>{{ $customer_transfer->paymentWay->name_sat ?? '' }}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_payment_method_id'): </strong>{{ $customer_transfer->paymentMethod->name_sat ?? '' }}
                    <br/>
                    <strong>@lang('sales/customer_transfer.entry_currency_id'): </strong>{{ $customer_transfer->currency->code }}{!! ($customer_transfer->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/customer_transfer.entry_currency_value').':</strong> '.round($customer_transfer->currency_value,4) :'') !!}
                @endif
            </td>
        </tr>
    </table>
    </div>
    @if(!empty($customer_transfer->cfdi_relation_id))
        <div>
        <p style="margin-bottom: 2px;">
            <strong>@lang('sales/customer_transfer.tab_relations') - {{ $customer_transfer->cfdiRelation->name_sat }}</strong>
        </p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                    @if($customer_transfer->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_transfer->customerInvoiceRelations as $result)
                            {{$result->relation->name ?? ''}}<br/>
                        @endforeach
                    @endif
                </td>
                <td width="85%" style="vertical-align: middle; padding: 5px;">
                    @if($customer_transfer->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_transfer->customerInvoiceRelations as $result)
                            {{$result->uuid_related}}<br/>
                        @endforeach
                    @endif
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_transfer->comment))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_transfer.entry_comment')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;">
                    {!! nl2br($customer_transfer->comment) !!}
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_transfer->compensation))
        <div>
            <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
                <tr>
                    <td width="100%" style="vertical-align: top; padding: 5px;">
                        <strong>@lang('sales/customer_transfer.entry_compensation')</strong><br/>
                        {!! nl2br($customer_transfer->compensation) !!}
                    </td>
                </tr>
            </table>
        </div>
    @endif
</section>
</body>
</html>
