<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$list_document_type2[$customer_transfer->document_type2]}}-{{$customer_transfer->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 410px;
            margin-bottom: 40px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 10px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_transfer->company_id) }}   !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_transfer->company_id) }}   !important;
        }
    </style>
</head>
<body style="background-color: white;">
<section class="header" style="top: -387px;">
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td colspan="2" class="text-right">
                <h1>{{ mb_strtoupper($list_document_type2[$customer_transfer->document_type2]) }}</h1>
            </td>
        </tr>
        <tr>
            <td width="50%" style="vertical-align: top; padding-top: 10px;">
                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($customer_transfer->company_id,$customer_transfer->project_id) }}" class="invoice-logo" width="170px"/>
                @elseif(!empty(setting('branch_office_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($customer_transfer->company_id,$customer_transfer->branch_office_id) }}" class="invoice-logo" width="170px"/>
                @else
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_transfer->company_id) }}" class="invoice-logo" width="170px"/>
                @endif
            </td>
            <td width="50%" class="text-right text-company" style="vertical-align: top; padding-top: 10px;">
                <span><strong>{{ mb_strtoupper($customer_transfer->company->name) }}</strong></span>
                <br/>
                <span>{{ $data['tax_regimen'] ?? ($customer_transfer->taxRegimen->name_sat ?? $customer_transfer->company->taxRegimen->name_sat) }}</span>
                <br/>
                <span>{{ $customer_transfer->company->address_1 ?? '' }} {{ $customer_transfer->company->address_2 ?? '' }} {{ $customer_transfer->company->address_3 ?? '' }} {{ $customer_transfer->company->address_4 ?? '' }}</span>
                <br/>
                <span>{{ $customer_transfer->company->city->name ?? '' }}, {{ ($customer_transfer->company->state->name ?? '') }}</span>
                <br/>
                <span>{{ $customer_transfer->company->country->name ?? '' }}{!! ($customer_transfer->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_transfer->company->postcode : '') !!}</span>
                <br/>
                <span>{{ mb_strtoupper($customer_transfer->company->taxid) }}</span>
                <br/>
                <span>---</span>
                <br/>
                <span>{{ $customer_transfer->company->phone ?? ' ' }}</span>
                <br/>
                <span>{{ $customer_transfer->company->email ?? ' ' }}</span>
            </td>
        </tr>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary"># {{ $customer_transfer->name }}</span>

            </td>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary">{{ mb_strtoupper(__('general.text_customer')) }}</span>
            </td>
        </tr>
        <tr>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <span><strong>@lang('general.text_cfdi_uuid')
                        : </strong>{{ $customer_transfer->customerInvoiceCfdi->uuid ?? '' }}</span>
                <br/>
                <span><strong>@lang('base/document_type.entry_cfdi_type_id')
                        : </strong>{{ $customer_transfer->documentType->cfdiType->name_sat ?? '' }}</span>
                <br/>
                <span><strong>@lang('sales/customer_transfer.entry_date')
                        : </strong>{{ \App\Helpers\Helper::convertSqlToDateTime($customer_transfer->date) }}</span>
                <br/>
                <span><strong>@lang('sales/customer_transfer.entry_date_due')
                        : </strong>{{ $customer_transfer->date_due ? \App\Helpers\Helper::convertSqlToDate($customer_transfer->date_due) : '' }}</span>
                <br/>
                <span><strong>@lang('sales/customer_transfer.entry_payment_term_id')
                        : </strong>{{ $customer_transfer->paymentTerm->name ?? '' }}</span>
                <br/>
                <span><strong>@lang('sales/customer_transfer.entry_cfdi_use_id')
                        : </strong>{{ $customer_transfer->cfdiUse->name_sat ?? '' }}</span>
                <br/>
                <span><strong>@lang('general.text_issued_in')
                        : </strong>{{ $customer_transfer->branchOffice->name ?? '' }} {!! ($customer_transfer->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $customer_transfer->branchOffice->postcode : '') !!}</span>
                <br/>
            </td>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <span><strong>{{ mb_strtoupper($customer_transfer->customer->name) }}</strong></span>
                <br/>
                <span>{{ $customer_transfer->customer->address_1 ?? '' }} {{ $customer_transfer->customer->address_2 ?? '' }} {{ $customer_transfer->customer->address_3 ?? '' }} {{ $customer_transfer->customer->address_4 ?? '' }}</span>
                <br/>
                <span>{{ $customer_transfer->customer->city->name ?? '' }}
                    , {{ $customer_transfer->customer->state->name ?? '' }}</span>
                <br/>
                <span>{{ $customer_transfer->customer->country->name ?? '' }}{!! ($customer_transfer->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_transfer->customer->postcode : '') !!}</span>
                <br/>
                <span>{{ mb_strtoupper($customer_transfer->customer->taxid) }}</span>
            </td>
        </tr>
    </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 15px;">
            <tr>
                <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                    <span class="text-primary">{{ mb_strtoupper(__('sales/customer_transfer.entry_source_name')) }}</span>

                </td>
                <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                    <span class="text-primary">{{ mb_strtoupper(__('sales/customer_transfer.entry_destination_name')) }}</span>
                </td>
            </tr>
            <tr>
                <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                    <span><strong>{{ mb_strtoupper($customer_transfer->source_name) ?? '' }}</strong></span>
                    <br/>
                    <span><strong>@lang('sales/customer_transfer.entry_source_address')
                            : </strong>{!! nl2br($customer_transfer->source_address) ?? '' !!}</span>
                    <br/>
                    <span><strong>@lang('sales/customer_transfer.entry_source_delivery_on')
                            : </strong>{{ $customer_transfer->source_delivery_on ?? '' }}</span>
                    <br/>
                </td>
                <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                    <span><strong>{{ mb_strtoupper($customer_transfer->destination_name) ?? '' }}</strong></span>
                    <br/>
                    <span><strong>@lang('sales/customer_transfer.entry_destination_address')
                            : </strong>{!! nl2br($customer_transfer->destination_address) ?? '' !!}</span>
                    <br/>
                    <span><strong>@lang('sales/customer_transfer.entry_destination_delivery_on')
                            : </strong>{{ $customer_transfer->destination_delivery_on ?? '' }}</span>
                    <br/>
                </td>
            </tr>
        </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="watermark" style="bottom: 540px !important;">
    <span>@lang('general.text_invalid_cfdi')</span>
</section>
<section>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
            <thead>
            <tr>
                <th class="text-left">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_name')) }}</th>
                <th width="10%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_weight')) }}</th>
                <th width="10%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_m3')) }}</th>
                <th width="10%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_liters')) }}</th>
            </tr>
            </thead>
            <tbody>
            @foreach($customer_transfer->customerActiveInvoiceLineTransfers as $result)
                <tr>
                    <td>{!! nl2br($result->name) !!}</td>
                    <td class="text-center">{{ $result->weight ?? '-' }}</td>
                    <td class="text-center">{{ $result->m3>0 ? \App\Helpers\Helper::numberFormat($result->m3,0) : '-' }}</td>
                    <td class="text-center">{{ $result->liters>0 ? \App\Helpers\Helper::numberFormat($result->liters,0) : '-' }}</td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
            <tr>
                <td style="vertical-align: top; padding: 5px;">
                <span><strong>@lang('sales/customer_transfer.entry_date_delivery')
                        : </strong>{{ $customer_transfer->date_delivery ? \App\Helpers\Helper::convertSqlToDate($customer_transfer->date_delivery) : '' }}</span>
                </td>
                <td style="vertical-align: top; padding: 5px;">
                    <span><strong>@lang('sales/customer_transfer.entry_valid_amount')
                            : </strong>{{ money($customer_transfer->valid_amount,$customer_transfer->currency->code,true) }}</span>
                </td>
                <td style="vertical-align: top; padding: 5px;">
                    <span><strong>@lang('sales/customer_transfer.entry_dangerous_material')
                            : </strong>{{ $customer_transfer->dangerous_material ? __('general.text_yes') : __('general.text_no') }}</span>
                </td>
            </tr>
        </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%" style="margin-top: 15px;">
        <thead>
        <tr>
            <th class="text-left">{{ mb_strtoupper(__('sales/customer_transfer.column_line_name')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_sat_product_id')) }}</th>
            <th width="14%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_unit_measure_id')) }}</th>
            <th width="8%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_quantity')) }}</th>
            <th width="10%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_price_unit')) }}</th>
            <th width="7%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_discount')) }}</th>
            <th width="11%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_amount_untaxed')) }}</th>
        </tr>
        </thead>
        <tbody>
        @foreach($customer_transfer->customerActiveInvoiceLines as $result)
            <tr>
                <td>{!! nl2br($result->name) !!}</td>
                <td class="text-center">{{ $result->satProduct->code }}</td>
                <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_transfer->company_id)) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                <td class="text-right">{{ money($result->amount_untaxed,$customer_transfer->currency->code,true) }}</td>
            </tr>
        @endforeach
        </tbody>
        <tfoot>
        <tr>
            <td colspan="4" class="text-center" style="vertical-align: bottom;">
                <span style="line-height: 16px;">***({{\App\Helpers\Helper::numberToWordCurrency($customer_transfer->amount_total,$customer_transfer->currency->code,$customer_transfer->currency->decimal_place)}}
                    )***</span>
            </td>
            <td colspan="2" class="text-right" style="vertical-align: top; padding-right: 4px;">
                <strong>@lang('general.text_amount_untaxed')</strong><br/>
                @if($customer_transfer->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_transfer->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
            </td>
            <td class="text-right">
                {{ money($customer_transfer->amount_untaxed,$customer_transfer->currency->code,true) }}<br/>
                @if($customer_transfer->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_transfer->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;">{{ money(abs($result->amount_tax),$customer_transfer->currency->code,true) }}</span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ money($customer_transfer->amount_total,$customer_transfer->currency->code,true) }}</strong></span>
            </td>
        </tr>
        </tfoot>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="100%" style="vertical-align: top; padding: 5px;">
                <span><strong>@lang('sales/customer_transfer.entry_payment_way_id')
                        : </strong>{{ $customer_transfer->paymentWay->name_sat ?? '' }}</span>
                <br/>
                <span><strong>@lang('sales/customer_transfer.entry_payment_method_id')
                        : </strong>{{ $customer_transfer->paymentMethod->name_sat ?? '' }}</span>
                <br/>
                <span><strong>@lang('sales/customer_transfer.entry_currency_id')
                        : </strong>{{ $customer_transfer->currency->code }}{!! ($customer_transfer->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/customer_transfer.entry_currency_value').':</strong> '.round($customer_transfer->currency_value,4) :'') !!}</span>
                <br/>
            </td>
        </tr>
    </table>
    </div>
    @if(!empty($customer_transfer->cfdi_relation_id))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_transfer.tab_relations')
                - {{ $customer_transfer->cfdiRelation->name_sat }} </strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" >
            <tr>
                <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                    @if($customer_transfer->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_transfer->customerInvoiceRelations as $result)
                            {{$result->relation->name}}<br/>
                        @endforeach
                    @endif
                </td>
                <td width="85%" style="vertical-align: middle; padding: 5px;">
                    @if($customer_transfer->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_transfer->customerInvoiceRelations as $result)
                            {{$result->relation->customerInvoiceCfdi->uuid}}<br/>
                        @endforeach
                    @endif
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_transfer->comment))
        <div>
            <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_transfer.entry_comment')</strong></p>
            <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
                <tr>
                    <td width="100%" style="vertical-align: top; padding: 5px;">
                        {!! nl2br($customer_transfer->comment) !!}
                    </td>
                </tr>
            </table>
        </div>
    @endif
    @if(!empty($customer_transfer->compensation))
        <div>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;">
                    <strong>@lang('sales/customer_transfer.entry_compensation')</strong><br/>
                    {!! nl2br($customer_transfer->compensation) !!}
                </td>
            </tr>
        </table>
        </div>
    @endif
    <div>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
            <tr>
                <td style="vertical-align: top; padding: 5px;">
                <span><strong>@lang('sales/customer_transfer.entry_driver')
                        : </strong>{{ $customer_transfer->driver }}</span>
                </td>
                <td style="vertical-align: top; padding: 5px;">
                    <span><strong>@lang('sales/customer_transfer.entry_vehicle')
                            : </strong>{{ $customer_transfer->vehicle }}</span>
                </td>
                <td style="vertical-align: top; padding: 5px;">
                    <span><strong>@lang('sales/customer_transfer.entry_vehicle_number')
                            : </strong>{{ $customer_transfer->vehicle_number }}</span>
                </td>
                <td style="vertical-align: top; padding: 5px;">
                    <span><strong>@lang('sales/customer_transfer.entry_vehicle_counter')
                            : </strong>{{ $customer_transfer->vehicle_counter }}</span>
                </td>
            </tr>
        </table>
    </div>
</section>
</body>
</html>
