@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('sales/customer_transfer.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('sales/customer_transfer.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('customer-transfers.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            @php
                //Obtiene datos del Cfdi33
                $cfdi33 = !empty($data['cfdi33']) ? $data['cfdi33'] : [];
            @endphp

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>{{ $list_document_type2[$customer_transfer->document_type2] }}</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">


                            <section class="content invoice">
                                <!-- title row -->
                                <div class="row">
                                    <div class="col-xs-12 invoice-header">
                                        <h1></h1>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 20px;">
                                    <div class="col-md-6 col-xs-12 invoice-col">
                                        <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_transfer->company_id) }}" class="invoice-logo" width="170px"/>
                                    </div>
                                    <div class="col-md-6 col-xs-12 invoice-col text-right">
                                        <span><strong>{{ mb_strtoupper($customer_transfer->company->name) }}</strong></span>
                                        <br/>
                                        <span>{{ $data['tax_regimen'] ?? ($customer_transfer->taxRegimen->name_sat ?? $customer_transfer->company->taxRegimen->name_sat) }}</span>
                                        <br/>
                                        <span>{{ $customer_transfer->company->address_1 ?? '' }} {{ $customer_transfer->company->address_2 ?? '' }} {{ $customer_transfer->company->address_3 ?? '' }} {{ $customer_transfer->company->address_4 ?? '' }}</span>
                                        <br/>
                                        <span>{{ $customer_transfer->company->city->name ?? '' }}
                                            , {{ ($customer_transfer->company->state->name ?? '') }}</span>
                                        <br/>
                                        <span>{{ $customer_transfer->company->country->name ?? '' }}{!! ($customer_transfer->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_transfer->company->postcode : '') !!}</span>
                                        <br/>
                                        <span>{{ mb_strtoupper($customer_transfer->company->taxid) }}</span>
                                        <br/>
                                        <span>---</span>
                                        <br/>
                                        <span>{{ $customer_transfer->company->phone ?? ' ' }}</span>
                                        <br/>
                                        <span>{{ $customer_transfer->company->email ?? ' ' }}</span>
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 20px;">
                                    <div class="col-md-6 col-xs-12 invoice-col">
                                        <h4 class=""
                                            style="color: {{ \App\Helpers\Helper::companyColorPrimary($customer_transfer->company_id) }}; font-weight: bold; padding-bottom: 5px; border-bottom: 1px solid #cccccc;">
                                            # {{ $customer_transfer->name }}
                                            <span class="pull-right">
                                                @if($customer_transfer->document_type2 == 'invoice')
                                                    {!! \App\Helpers\SalesHelper::statusCustomerInvoiceHtml($customer_transfer->status) !!}
                                                @else
                                                    {!! \App\Helpers\SalesHelper::statusCustomerTransferHtml($customer_transfer->status) !!}
                                                @endif
                                            </span>
                                        </h4>
                                        <span><strong>@lang('general.text_cfdi_uuid')
                                                : </strong>{{ $customer_transfer->customerInvoiceCfdi->uuid ?? '' }}
                                                        </span>
                                        <br/>
                                        <span><strong>@lang('base/document_type.entry_cfdi_type_id')
                                                : </strong>{{ $customer_transfer->documentType->cfdiType->name_sat ?? '' }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_transfer.entry_date')
                                                : </strong>{{ \App\Helpers\Helper::convertSqlToDateTime($customer_transfer->date) }}</span>
                                        <br/>
                                        @if($customer_transfer->document_type2 == 'invoice')
                                        <span><strong>@lang('sales/customer_transfer.entry_date_due')
                                                : </strong>{{ $customer_transfer->date_due ? \App\Helpers\Helper::convertSqlToDate($customer_transfer->date_due) : '' }}</span>
                                        <br/>
                                        @endif
                                        <span><strong>@lang('sales/customer_transfer.entry_payment_term_id')
                                                : </strong>{{ $customer_transfer->paymentTerm->name ?? '' }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_transfer.entry_cfdi_use_id')
                                                : </strong>{{ $customer_transfer->cfdiUse->name_sat ?? '' }}</span>
                                        <br/>
                                        <span><strong>@lang('general.text_issued_in')
                                                : </strong>{{ $customer_transfer->branchOffice->name ?? '' }} {!! ($customer_transfer->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $customer_transfer->branchOffice->postcode : '') !!}</span>
                                        <br/>
                                    </div>
                                    <div class="col-md-6 col-xs-12 invoice-col">
                                        <h4 class=""
                                            style="color: {{ \App\Helpers\Helper::companyColorPrimary($customer_transfer->company_id) }}; font-weight: bold; padding-bottom: 5px; border-bottom: 1px solid #cccccc;">{{ mb_strtoupper(__('general.text_customer')) }}</h4>
                                        <span><strong>{{ mb_strtoupper($customer_transfer->customer->name) }}</strong></span>
                                        <br/>
                                        <span>{{ $customer_transfer->customer->address_1 ?? '' }} {{ $customer_transfer->customer->address_2 ?? '' }} {{ $customer_transfer->customer->address_3 ?? '' }} {{ $customer_transfer->customer->address_4 ?? '' }}</span>
                                        <br/>
                                        <span>{{ $customer_transfer->customer->city->name ?? '' }}
                                            , {{ $customer_transfer->customer->state->name ?? '' }}</span>
                                        <br/>
                                        <span>{{ $customer_transfer->customer->country->name ?? '' }}{!! ($customer_transfer->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_transfer->customer->postcode : '') !!}</span>
                                        <br/>
                                        <span>{{ mb_strtoupper($cfdi33->Receptor['Rfc'] ?? $customer_transfer->customer->taxid) }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_transfer.entry_tax_regimen_customer_id2')
                                            : </strong>{{ $data['tax_regimen_customer'] ?? ($customer_transfer->taxRegimenCustomer->name_sat ?? ($customer_transfer->customer->taxRegimen->name_sat ?? '')) }}</span>
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- Table row -->
                                <div class="row">
                                    <div class="col-md-12 col-xs-12 table">
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                <tr>
                                                    <th class="text-left">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_name')) }}</th>
                                                    <th class="text-center" width="10%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_weight')) }}</th>
                                                    <th class="text-center" width="10%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_m3')) }}</th>
                                                    <th class="text-center" width="10%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_transfer_liters')) }}</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @foreach($customer_transfer->customerActiveInvoiceLineTransfers as $result)
                                                    <tr>
                                                        <td>{!! nl2br($result->name) !!}</td>
                                                        <td class="text-center">{{ $result->weight ?? '-' }}</td>
                                                        <td class="text-center">{{ $result->m3>0 ? \App\Helpers\Helper::numberFormat($result->m3,0) : '-' }}</td>
                                                        <td class="text-center">{{ $result->liters>0 ? \App\Helpers\Helper::numberFormat($result->liters,0) : '-' }}</td>
                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- /.row -->
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 15px;">
                                    <div class="col-md-12 col-xs-12 invoice-col">
                                        <table cellpadding="0" cellspacing="0" class="table table-secundary" width="100%">
                                            <tr>
                                                <td style="vertical-align: top; padding: 5px;">
                                                    <span><strong>@lang('sales/customer_transfer.entry_date_delivery')
                                                            : </strong>{{ $customer_transfer->date_delivery ? \App\Helpers\Helper::convertSqlToDate($customer_transfer->date_delivery) : '' }}</span>
                                                </td>
                                                <td style="vertical-align: top; padding: 5px;">
                                                    <span><strong>@lang('sales/customer_transfer.entry_valid_amount')
                                                            : </strong>{{ money($customer_transfer->valid_amount,$customer_transfer->currency->code,true) }}</span>
                                                </td>
                                                <td style="vertical-align: top; padding: 5px;">
                                                    <span><strong>@lang('sales/customer_transfer.entry_dangerous_material')
                                                            : </strong>{{ $customer_transfer->dangerous_material ? __('general.text_yes') : __('general.text_no') }}</span>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- Table row -->
                                <div class="row" style="margin-top: 15px;">
                                    <div class="col-md-12 col-xs-12 table">
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                <tr>
                                                    <th class="text-left">{{ mb_strtoupper(__('sales/customer_transfer.column_line_name')) }}</th>
                                                    <th class="text-center"
                                                        width="9%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_sat_product_id')) }}</th>
                                                    <th class="text-center"
                                                        width="14%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_unit_measure_id')) }}</th>
                                                    <th class="text-center"
                                                        width="7%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_quantity')) }}</th>
                                                    <th class="text-center"
                                                        width="9%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_price_unit')) }}</th>
                                                    <th class="text-center"
                                                        width="6%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_discount')) }}</th>
                                                    <th class="text-right"
                                                        width="11%">{{ mb_strtoupper(__('sales/customer_transfer.column_line_amount_untaxed')) }}</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @foreach($customer_transfer->customerActiveInvoiceLines as $result)
                                                    <tr>
                                                        <td>{{ $result->name }}</td>
                                                        <td class="text-center">{{ $result->satProduct->code }}</td>
                                                        <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                                                        <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                                                        <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_transfer->company_id)) }}</td>
                                                        <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                                                        <td class="text-right">{{ money($result->amount_untaxed,$customer_transfer->currency->code,true) }}</td>
                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- /.row -->
                                <!-- Table row -->
                                <div class="row" style="margin-bottom: 30px;">
                                    <div class="col-md-6 col-xs-12">
                                        @if($customer_transfer->document_type2 == 'invoice')
                                        <span><strong>@lang('sales/customer_transfer.entry_payment_way_id')
                                                : </strong>{{ $customer_transfer->paymentWay->name_sat ?? '' }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/customer_transfer.entry_payment_method_id')
                                                : </strong>{{ $customer_transfer->paymentMethod->name_sat ?? '' }}</span>
                                        <br/>
                                        @endif
                                        <span><strong>@lang('sales/customer_transfer.entry_currency_id')
                                                : </strong>{{ $customer_transfer->currency->code }}{!! ($customer_transfer->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/customer_transfer.entry_currency_value').':</strong> '.round($customer_transfer->currency_value,4) :'') !!}</span>
                                        <br/>
                                        @if(!empty($cfdi33))
                                            <span><strong>@lang('general.text_cfdi_certificado'): </strong>
                                                {{ $cfdi33['NoCertificado'] }}</span>
                                            <br/>
                                            <span><strong>@lang('general.text_cfdi_tfd_no_certificado_sat'): </strong>
                                                {{ $cfdi33->complemento->timbreFiscalDigital['NoCertificadoSAT'] }}</span>
                                            <br/>
                                            <span><strong>@lang('general.text_cfdi_tfd_fecha_timbrado'): </strong>
                                                {{ \App\Helpers\Helper::convertSqlToDateTime(str_replace('T',' ',$cfdi33->complemento->timbreFiscalDigital['FechaTimbrado'])) }}</span>
                                            <br/>
                                        @endif
                                    </div>
                                    <div class="col-md-6 col-xs-12">
                                        <div class="table-responsive">
                                            @if($customer_transfer->document_type2 == 'invoice')
                                            <table class="table">
                                                <tbody>
                                                <tr>
                                                    <th style="width:50%">@lang('general.text_amount_untaxed')</th>
                                                    <td>{{ money($customer_transfer->amount_untaxed,$customer_transfer->currency->code,true) }}</td>
                                                </tr>
                                                @if($customer_transfer->customerInvoiceTaxes->isNotEmpty())
                                                    @foreach($customer_transfer->customerInvoiceTaxes as $result)
                                                        <tr>
                                                            <th>{{$result->name}}</th>
                                                            <td>{{ money(abs($result->amount_tax),$customer_transfer->currency->code,true) }}</td>
                                                        </tr>
                                                    @endforeach
                                                @endif
                                                <tr>
                                                    <th>{{ mb_strtoupper(__('general.text_amount_total')) }}</th>
                                                    <td>{{ money($customer_transfer->amount_total,$customer_transfer->currency->code,true) }}</td>
                                                </tr>
                                                </tbody>
                                            </table>
                                            @endif
                                        </div>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 15px;">
                                    <div class="col-md-12 col-xs-12 invoice-col">
                                        @if(!empty($customer_transfer->cfdi_relation_id))
                                            <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_transfer.tab_relations')
                                                    - {{ $customer_transfer->cfdiRelation->name_sat }} </strong></p>
                                            <table cellpadding="0" cellspacing="0" class="table table-secundary" width="100%">
                                                <tr>
                                                    <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                                                        @if($customer_transfer->customerInvoiceRelations->isNotEmpty())
                                                            @foreach($customer_transfer->customerInvoiceRelations as $result)
                                                                {{$result->relation->name}}<br/>
                                                            @endforeach
                                                        @endif
                                                    </td>
                                                    <td width="85%" style="vertical-align: middle; padding: 5px;">
                                                        @if($customer_transfer->customerInvoiceRelations->isNotEmpty())
                                                            @foreach($customer_transfer->customerInvoiceRelations as $result)
                                                                {{$result->relation->customerInvoiceCfdi->uuid}}<br/>
                                                            @endforeach
                                                        @endif
                                                    </td>
                                                </tr>
                                            </table>
                                        @endif
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 15px;">
                                    <div class="col-md-12 col-xs-12 invoice-col">
                                        @if(!empty($customer_transfer->comment))
                                            <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_transfer.entry_comment')</strong></p>
                                            <table cellpadding="0" cellspacing="0" class="table table-secundary" width="100%">
                                                <tr>
                                                    <td width="100%" style="vertical-align: top; padding: 5px;">
                                                        {{ $customer_transfer->comment }}
                                                    </td>
                                                </tr>
                                            </table>
                                        @endif
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 15px;">
                                    <div class="col-md-12 col-xs-12 invoice-col">
                                        @if(!empty($customer_transfer->compensation))
                                            <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_transfer.entry_compensation')</strong></p>
                                            <table cellpadding="0" cellspacing="0" class="table table-secundary" width="100%">
                                                <tr>
                                                    <td width="100%" style="vertical-align: top; padding: 5px;">
                                                        {{ $customer_transfer->compensation }}
                                                    </td>
                                                </tr>
                                            </table>
                                        @endif
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 15px;">
                                    <div class="col-md-12 col-xs-12 invoice-col">
                                        <table cellpadding="0" cellspacing="0" class="table table-secundary" width="100%">
                                            <tr>
                                                <td style="vertical-align: top; padding: 5px;">
                                                    <span><strong>@lang('sales/customer_transfer.entry_driver')
                                                            : </strong>{{ $customer_transfer->driver }}</span>
                                                </td>
                                                <td style="vertical-align: top; padding: 5px;">
                                                    <span><strong>@lang('sales/customer_transfer.entry_vehicle')
                                                            : </strong>{{ $customer_transfer->vehicle }}</span>
                                                </td>
                                                <td style="vertical-align: top; padding: 5px;">
                                                    <span><strong>@lang('sales/customer_transfer.entry_vehicle_number')
                                                            : </strong>{{ $customer_transfer->vehicle_number }}</span>
                                                </td>
                                                <td style="vertical-align: top; padding: 5px;">
                                                    <span><strong>@lang('sales/customer_transfer.entry_vehicle_counter')
                                                            : </strong>{{ $customer_transfer->vehicle_counter }}</span>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 20px;">
                                    <div class="col-md-12 col-xs-12 invoice-col">
                                        @if(!empty($cfdi33))
                                            <table cellpadding="0" cellspacing="0" class="table" width="100%"
                                                   style="margin-top: 5px; table-layout: fixed;">
                                                <tr>
                                                    <td width="23%" class="text-center" style="vertical-align: middle; padding: 5px; word-wrap:break-word;">
                                                        <img src="{{ $data['qr'] }}" width="137px" style="margin: 9px 0;"/>
                                                    </td>
                                                    <td width="77%" style="vertical-align: middle; padding: 5px; word-wrap:break-word;">
                                                        <strong>@lang('general.text_cfdi_tfd_cadena_origen') </strong><br/>
                                                        <small>{{ $data['tfd_cadena_origen'] }}</small>
                                                        <br/>
                                                        <strong>@lang('general.text_cfdi_tfd_sello_cfdi') </strong><br/>
                                                        <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloCFD'] }}</small>
                                                        <br/>
                                                        <strong>@lang('general.text_cfdi_tfd_sello_sat') </strong><br/>
                                                        <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloSAT'] }}</small>
                                                        <br/>
                                                    </td>
                                                </tr>
                                            </table>
                                        @endif
                                    </div>
                                </div>
                                <!-- /.row -->
                            </section>


                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

    </script>
@endsection
