@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('sales/customer.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('sales/customer.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                    <div class="col-md-5 col-xs-12 pull-right">
                        <a href="{{route('customers.index',request()->except('page'))}}"
                           class="btn btn-sm btn-default">@lang('general.button_discard')
                        </a>
                    </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if (!$errors->isEmpty())
                    <div class="alert alert-danger alert-dismissable alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        {{ __('general.error_form') }}
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>{{ $customer->name }}</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            {!! Form::model($customer,['route' => ['customers.update',$customer->id],'method' => 'PUT','class' => '','role' => 'form','id' => 'form']) !!}
                            <div class="" role="tabpanel" data-example-id="togglable-tabs">
                                <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
                                    <li role="presentation" class="active">
                                        <a href="#tab_general" id="general-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('general.tab_general')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_address" id="address-tab" role="tab" data-toggle="tab"
                                           aria-expanded="false">@lang('general.tab_address')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_bank_accounts" id="bank-accounts-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('general.tab_bank_accounts')</a>
                                    </li>
                                    @if(\App\Helpers\Helper::companyComplementoCfdiIedu())
                                        <li role="presentation" class="">
                                            <a href="#tab_iedus" id="iedus-tab" role="tab" data-toggle="tab"
                                               aria-expanded="true">@lang('general.tab_iedus')</a>
                                        </li>
                                    @endif
                                </ul>
                                <div id="myTabContent" class="tab-content">
                                    <div role="tabpanel" class="tab-pane fade active in" id="tab_general"
                                         aria-labelledby="general-tab">
                                        <div class="row">
                                            <div class="col-md-6 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('name', __('sales/customer.entry_name') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('sales/customer.entry_name'),'required','autofocus']) !!}
                                                    @if ($errors->has('name'))
                                                        <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('taxid') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('taxid', __('sales/customer.entry_taxid') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('taxid', old('taxid'), ['class' => 'form-control text-uppercase', 'placeholder' => __('sales/customer.entry_taxid'),'required']) !!}
                                                    @if ($errors->has('taxid'))
                                                        <span class="help-block"><small>{{ $errors->first('taxid') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('tax_regimen_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('tax_regimen_id', __('sales/customer.entry_tax_regimen_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('tax_regimen_id', $tax_regimens,old('tax_regimen_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('tax_regimen_id'))
                                                        <span class="help-block"><small>{{ $errors->first('tax_regimen_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('numid') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('numid', __('sales/customer.entry_numid') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('numid', old('numid'), ['class' => 'form-control', 'placeholder' => __('sales/customer.entry_numid')]) !!}
                                                    @if ($errors->has('numid'))
                                                        <span class="help-block"><small>{{ $errors->first('numid') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('payment_term_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('payment_term_id', __('sales/customer.entry_payment_term_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('payment_term_id', $payment_terms,null, ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                                    @if ($errors->has('payment_term_id'))
                                                        <span class="help-block"><small>{{ $errors->first('payment_term_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('payment_way_id', __('sales/customer.entry_payment_way_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('payment_way_id', $payment_ways,null, ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('payment_method_id', __('sales/customer.entry_payment_method_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('payment_method_id', $payment_methods,null, ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('cfdi_use_id', __('sales/customer.entry_cfdi_use_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('cfdi_use_id', $cfdi_uses,null, ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('salesperson_id', __('sales/customer.entry_salesperson_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('salesperson_id', $salespersons,null, ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('email') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('email', __('sales/customer.entry_email') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('email', old('email'), ['class' => 'form-control', 'placeholder' => __('sales/customer.help_email')]) !!}
                                                    @if ($errors->has('email'))
                                                        <span class="help-block"><small>{{ $errors->first('email') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="row">
                                                    <div class="col-md-6 col-xs-12">
                                                        <div class="form-group form-group-sm">
                                                            {!! html_entity_decode(Form::label('phone', __('sales/customer.entry_phone') . '', ['class' => 'control-label'])) !!}
                                                            {!! Form::text('phone', old('phone'), ['class' => 'form-control', 'placeholder' => __('sales/customer.entry_phone')]) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 col-xs-12">
                                                        <div class="form-group form-group-sm">
                                                            {!! html_entity_decode(Form::label('phone_mobile', __('sales/customer.entry_phone_mobile') . '', ['class' => 'control-label'])) !!}
                                                            {!! Form::text('phone_mobile', old('phone_mobile'), ['class' => 'form-control', 'placeholder' => __('sales/customer.entry_phone_mobile')]) !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-12 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('comment', __('sales/customer.entry_comment') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::textarea('comment', old('comment'), ['class' => 'form-control', 'placeholder' => __('sales/customer.entry_comment'),'rows' => '2']) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-12 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('status', __('sales/customer.entry_status') , ['class' => 'control-label'])) !!}
                                                    <br/>
                                                    <label>
                                                        {!! Form::checkbox('status', '1',(!empty(old('status',$customer->status)) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade" id="tab_address"
                                         aria-labelledby="address-tab">
                                        <div class="row">
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('address_1', __('sales/customer.entry_address_1') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('address_1', old('address_1'), ['class' => 'form-control', 'placeholder' => __('sales/customer.entry_address_1')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('address_2', __('sales/customer.entry_address_2') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('address_2', old('address_2'), ['class' => 'form-control', 'placeholder' => __('sales/customer.entry_address_2')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('address_3', __('sales/customer.entry_address_3') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('address_3', old('address_3'), ['class' => 'form-control', 'placeholder' => __('sales/customer.entry_address_3')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('address_4', __('sales/customer.entry_address_4') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('address_4', old('address_4'), ['class' => 'form-control', 'placeholder' => __('sales/customer.entry_address_4')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('address_5', __('sales/customer.entry_address_5') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('address_5', old('address_5'), ['class' => 'form-control', 'placeholder' => __('sales/customer.entry_address_5')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-8 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('address_6', __('sales/customer.entry_address_6') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('address_6', old('address_6'), ['class' => 'form-control', 'placeholder' => __('sales/customer.entry_address_6')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('country_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('country_id', __('sales/customer.entry_country_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('country_id', $countries,old('country_id'), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select'),'required']) !!}
                                                    @if ($errors->has('country_id'))
                                                        <span class="help-block"><small>{{ $errors->first('country_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('state_id', __('sales/customer.entry_state_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('state_id', [],null, ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('city_id', __('sales/customer.entry_city_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('city_id', [],null, ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('postcode') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('postcode', __('sales/customer.entry_postcode') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('postcode', old('postcode'), ['class' => 'form-control', 'placeholder' => __('sales/customer.entry_postcode')]) !!}
                                                    @if ($errors->has('postcode'))
                                                        <span class="help-block"><small>{{ $errors->first('postcode') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade" id="tab_bank_accounts"
                                         aria-labelledby="bank-accounts-tab">
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12">
                                                <div class="hidden" id="delete_items_bank_account">
                                                    @foreach(old('delete_item_bank_account',[]) as $tmp)
                                                        <input type="hidden" name="delete_item_bank_account[]" value="{{ $tmp }}"/>
                                                    @endforeach
                                                </div>
                                                <div class="table-responsive">
                                                    <table class="table table-items table-condensed table-hover table-bordered table-striped"
                                                           id="items_bank_account">
                                                        <thead>
                                                        <tr>
                                                            <th width="5%"
                                                                class="text-center">@lang('general.column_actions')</th>
                                                            <th width="40%"
                                                                class="text-left">@lang('sales/customer.column_bank_account_name')</th>
                                                            <th width="15%"
                                                                class="text-center">@lang('sales/customer.column_bank_account_bank_id')</th>
                                                            <th width="15%"
                                                                class="text-center">@lang('sales/customer.column_bank_account_currency_id')</th>
                                                            <th width="25%"
                                                                class="text-center">@lang('sales/customer.column_bank_account_account_number')</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <!-- Items -->
                                                        @php
                                                            $item_bank_account_row = 1;
                                                            $items_bank_account = old('item_bank_account',$customer->customerActiveBankAccounts);
                                                        @endphp
                                                        @foreach ($items_bank_account as $item_bank_account_row => $item)
                                                            @php
                                                            $item = !empty(old('item_bank_account.' . $item_bank_account_row . '')) ? (object) old('item_bank_account.' . $item_bank_account_row) : $item;
                                                            @endphp
                                                            <tr id="item_bank_account_row_{{ $item_bank_account_row }}">
                                                                <td class="text-center"
                                                                    style="vertical-align: middle;">
                                                                    <button type="button"
                                                                            onclick="deleteItemBankAccount('{{old('item_bank_account.' . $item_bank_account_row . '.id',$item->id)}}');$('#item_bank_account_row_{{ $item_bank_account_row }}').remove();"
                                                                            class="btn btn-xs btn-danger"
                                                                            style="margin-bottom: 0;">
                                                                        <i class="fa fa-trash-o"></i>
                                                                    </button>
                                                                    <!-- input hidden -->
                                                                    <input type="hidden"
                                                                           id="item_bank_account_id_{{ $item_bank_account_row }}"
                                                                           name="item_bank_account[{{ $item_bank_account_row }}][id]"
                                                                           value="{{ old('item_bank_account.' . $item_bank_account_row . '.id',$item->id) }}">
                                                                    <!-- /.input hidden -->
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_bank_account.'.$item_bank_account_row.'.name') ? ' has-error' : '' }}">
                                                                        {!! Form::text('item_bank_account[' . $item_bank_account_row . '][name]', old('item_bank_account.' . $item_bank_account_row . '.name',$item->name), ['class' => 'form-control input-sm', 'required','id' => 'item_bank_account_name_' . $item_bank_account_row]) !!}
                                                                        @if ($errors->has('item_bank_account.'.$item_bank_account_row.'.name'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_bank_account.'.$item_bank_account_row.'.name') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_bank_account.'.$item_bank_account_row.'.bank_id') ? ' has-error' : '' }}">
                                                                        {!! Form::select('item_bank_account[' . $item_bank_account_row . '][bank_id]', $banks,old('item_bank_account.' . $item_bank_account_row . '.bank_id',$item->bank_id), ['class' => 'form-control input-sm', 'placeholder' => __('general.text_select'),'required','id' => 'item_bank_account_bank_id_' . $item_bank_account_row]) !!}
                                                                        @if ($errors->has('item_bank_account.'.$item_bank_account_row.'.bank_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_bank_account.'.$item_bank_account_row.'.bank_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_bank_account.'.$item_bank_account_row.'.currency_id') ? ' has-error' : '' }}">
                                                                        {!! Form::select('item_bank_account[' . $item_bank_account_row . '][currency_id]', $currencies,old('item_bank_account.' . $item_bank_account_row . '.currency_id',$item->currency_id), ['class' => 'form-control input-sm', 'placeholder' => __('general.text_select'),'required','id' => 'item_bank_account_currency_id_' . $item_bank_account_row]) !!}
                                                                        @if ($errors->has('item_bank_account.'.$item_bank_account_row.'.currency_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_bank_account.'.$item_bank_account_row.'.currency_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_bank_account.'.$item_bank_account_row.'.account_number') ? ' has-error' : '' }}">
                                                                        {!! Form::text('item_bank_account[' . $item_bank_account_row . '][account_number]', old('item_bank_account.' . $item_bank_account_row . '.account_number',$item->account_number), ['class' => 'form-control input-sm text-center', 'required','id' => 'item_bank_account_account_number_' . $item_bank_account_row]) !!}
                                                                        @if ($errors->has('item_bank_account.'.$item_bank_account_row.'.account_number'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_bank_account.'.$item_bank_account_row.'.account_number') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                        @php
                                                            $item_bank_account_row++;
                                                        @endphp
                                                        <!-- /Items -->
                                                        <!-- Agregar nuevo item -->
                                                        <tr id="add_item_bank_account">
                                                            <td class="text-center">
                                                                <button type="button"
                                                                        onclick="addItemBankAccount();"
                                                                        class="btn btn-xs btn-primary"
                                                                        style="margin-bottom: 0;">
                                                                    <i class="fa fa-plus"></i>
                                                                </button>
                                                            </td>
                                                            <td class="text-right" colspan="4"></td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade" id="tab_iedus"
                                         aria-labelledby="iedus-tab">
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12">
                                                <div class="hidden" id="delete_items_iedu">
                                                    @foreach(old('delete_item_iedu',[]) as $tmp)
                                                        <input type="hidden" name="delete_item_iedu[]" value="{{ $tmp }}"/>
                                                    @endforeach
                                                </div>
                                                <div class="table-responsive">
                                                    <table class="table table-items table-condensed table-hover table-bordered table-striped"
                                                           id="items_iedu">
                                                        <thead>
                                                        <tr>
                                                            <th width="5%"
                                                                class="text-center">@lang('general.column_actions')</th>
                                                            <th
                                                                    class="text-left">@lang('sales/customer.column_iedu_nombre_alumno')</th>
                                                            <th width="25%"
                                                                class="text-center">@lang('sales/customer.column_iedu_curp')</th>
                                                            <th width="20%"
                                                                class="text-center">@lang('sales/customer.column_iedu_iedu_nivel_educativo_id')
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <!-- Items -->
                                                        @php
                                                            $item_iedu_row = 1;
                                                            $items_iedu = old('item_iedu',$customer->customerActiveIedus);
                                                        @endphp
                                                        @foreach ($items_iedu as $item_iedu_row => $item)
                                                            @php
                                                                $item = !empty(old('item_iedu.' . $item_iedu_row . '')) ? (object) old('item_iedu.' . $item_iedu_row) : $item;
                                                            @endphp
                                                            <tr id="item_iedu_row_{{ $item_iedu_row }}">
                                                                <td class="text-center"
                                                                    style="vertical-align: middle;">
                                                                    <button type="button"
                                                                            onclick="deleteItemIedu('{{$item->id}}');$('#item_iedu_row_{{ $item_iedu_row }}').remove();"
                                                                            class="btn btn-xs btn-danger"
                                                                            style="margin-bottom: 0;">
                                                                        <i class="fa fa-trash-o"></i>
                                                                    </button>
                                                                    <!-- input hidden -->
                                                                    <input type="hidden"
                                                                           id="item_iedu_id_{{ $item_iedu_row }}"
                                                                           name="item_iedu[{{ $item_iedu_row }}][id]"
                                                                           value="{{ old('item_iedu.' . $item_iedu_row . '.id',$item->id) }}">
                                                                    <!-- /.input hidden -->
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_iedu.'.$item_iedu_row.'.nombre_alumno') ? ' has-error' : '' }}">
                                                                        {!! Form::text('item_iedu[' . $item_iedu_row . '][nombre_alumno]', old('item_iedu.' . $item_iedu_row . '.nombre_alumno',$item->nombre_alumno), ['class' => 'form-control input-sm', 'required','id' => 'item_iedu_nombre_alumno_' . $item_iedu_row]) !!}
                                                                        @if ($errors->has('item_iedu.'.$item_iedu_row.'.nombre_alumno'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_iedu.'.$item_iedu_row.'.nombre_alumno') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_iedu.'.$item_iedu_row.'.curp') ? ' has-error' : '' }}">
                                                                        {!! Form::text('item_iedu[' . $item_iedu_row . '][curp]', old('item_iedu.' . $item_iedu_row . '.curp',$item->curp), ['class' => 'form-control input-sm', 'required','id' => 'item_iedu_curp_' . $item_iedu_row]) !!}
                                                                        @if ($errors->has('item_iedu.'.$item_iedu_row.'.curp'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_iedu.'.$item_iedu_row.'.curp') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_iedu.'.$item_iedu_row.'.iedu_nivel_educativo_id') ? ' has-error' : '' }}">
                                                                        {!! Form::select('item_iedu[' . $item_iedu_row . '][iedu_nivel_educativo_id]', $iedu_nivel_educativos,old('item_iedu.' . $item_iedu_row . '.iedu_nivel_educativo_id',$item->iedu_nivel_educativo_id), ['class' => 'form-control input-sm', 'placeholder' => __('general.text_select'),'required','id' => 'item_iedu_iedu_nivel_educativo_id_' . $item_iedu_row]) !!}
                                                                        @if ($errors->has('item_iedu.'.$item_iedu_row.'.iedu_nivel_educativo_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_iedu.'.$item_iedu_row.'.iedu_nivel_educativo_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                        @php
                                                            $item_iedu_row++;
                                                        @endphp
                                                        <!-- /Items -->
                                                        <!-- Agregar nuevo item -->
                                                        <tr id="add_item_iedu">
                                                            <td class="text-center">
                                                                <button type="button"
                                                                        onclick="addItemIedu();"
                                                                        class="btn btn-xs btn-primary"
                                                                        style="margin-bottom: 0;">
                                                                    <i class="fa fa-plus"></i>
                                                                </button>
                                                            </td>
                                                            <td class="text-right" colspan="4"></td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="ln_solid"></div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12 text-right footer-form">
                                    {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary ladda-button']) !!}
                                    &nbsp;&nbsp;&nbsp;
                                    <a href="{{route('customers.index',request()->except('page'))}}"
                                       class="btn btn-sm btn-default">@lang('general.button_discard')</a>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        var item_bank_account_row = "{{ $item_bank_account_row }}";
        var item_iedu_row = "{{ $item_iedu_row }}";

        function addItemBankAccount() {
            var html = '';

            html += '<tr id="item_bank_account_row_' + item_bank_account_row + '">';
            html += '<td class="text-center" style="vertical-align: middle;">';
            html += '<button type="button" onclick="$(\'#item_bank_account_row_' + item_bank_account_row + '\').remove();" class="btn btn-xs btn-danger" style="margin-bottom: 0;">';
            html += '<i class="fa fa-trash"></i>';
            html += '</button>';
            html += '<input type="hidden" name="item_bank_account[' + item_bank_account_row + '][id]" id="item_bank_account_id_' + item_bank_account_row + '" /> ';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="text" class="form-control input-sm" name="item_bank_account[' + item_bank_account_row + '][name]" id="item_bank_account_name_' + item_bank_account_row + '" required />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<select class="form-control input-sm" name="item_bank_account[' + item_bank_account_row + '][bank_id]" id="item_bank_account_bank_id_' + item_bank_account_row + '" required>';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            @foreach($banks as $key => $value)
                html += '<option value="{{ $key }}">{{ $value }}</option>';
            @endforeach
                html += '</select>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<select class="form-control input-sm" name="item_bank_account[' + item_bank_account_row + '][currency_id]" id="item_bank_account_currency_id_' + item_bank_account_row + '" required>';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            @foreach($currencies as $key => $value)
                html += '<option value="{{ $key }}">{{ $value }}</option>';
            @endforeach
                html += '</select>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="text" class="form-control input-sm text-center" name="item_bank_account[' + item_bank_account_row + '][account_number]" id="item_bank_account_account_number_' + item_bank_account_row + '" required />';
            html += '</div>';
            html += '</td>';
            html += '</tr>';

            $("#form #items_bank_account tbody #add_item_bank_account").before(html);

            item_bank_account_row++;
        }

        function deleteItemBankAccount(id) {
            if(id) {
                let html = '<input type="hidden" name="delete_item_bank_account[]" value="'+id+'"/>';
                $('#form #delete_items_bank_account').append(html);
            }
        }

        function addItemIedu() {
            var html = '';

            html += '<tr id="item_iedu_row_' + item_iedu_row + '">';
            html += '<td class="text-center" style="vertical-align: middle;">';
            html += '<button type="button" onclick="$(\'#item_iedu_row_' + item_iedu_row + '\').remove();" class="btn btn-xs btn-danger" style="margin-bottom: 0;">';
            html += '<i class="fa fa-trash"></i>';
            html += '</button>';
            html += '<input type="hidden" name="item_iedu[' + item_iedu_row + '][id]" id="item_iedu_id_' + item_iedu_row + '" /> ';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="text" class="form-control input-sm" name="item_iedu[' + item_iedu_row + '][nombre_alumno]" id="item_iedu_nombre_alumno_' + item_iedu_row + '" required />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="text" class="form-control input-sm" name="item_iedu[' + item_iedu_row + '][curp]" id="item_iedu_curp_' + item_iedu_row + '" required />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<select class="form-control input-sm" name="item_iedu[' + item_iedu_row + '][iedu_nivel_educativo_id]" id="item_iedu_iedu_nivel_educativo_id_' + item_iedu_row + '" required>';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            @foreach($iedu_nivel_educativos as $key => $value)
                html += '<option value="{{ $key }}">{{ $value }}</option>';
            @endforeach
                html += '</select>';
            html += '</div>';
            html += '</td>';
            html += '</tr>';

            $("#form #items_iedu tbody #add_item_iedu").before(html);

            item_iedu_row++;
        }

        function deleteItemIedu(id) {
            if(id) {
                let html = '<input type="hidden" name="delete_item_iedu[]" value="'+id+'"/>';
                $('#form #delete_items_iedu').append(html);
            }
        }

        $(function () {
            /* Configura select2 */
            $("#form .my-select2").select2({
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "auto",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
            });
            /* Selecciona pais */
            $("#form select[name='country_id']").on("change", function () {
                var id = $(this).val();
                let state_id = $("#form select[name='state_id']");
                state_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('countries/get-states') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&state_id=" + "{{old('state_id',$customer->state_id)}}",
                        success: function (data) {
                            if (data.html) {
                                state_id.html(data.html);
                            }
                            state_id.trigger("change");
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            }).trigger("change");
            /* Selecciona estado */
            $("#form select[name='state_id']").on("change", function () {
                var id = $(this).val();
                let city_id = $("#form select[name='city_id']");
                city_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('states/get-cities') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&city_id=" + "{{old('city_id',$customer->city_id)}}",
                        success: function (data) {
                            if (data.html) {
                                city_id.html(data.html);
                            }
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });
        });

    </script>
@endsection
