@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('sales/recurring_customer_invoice.document_title'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
    <link href="{{ asset('gentelella/plugins/google-code-prettify/bin/prettify.min.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('sales/recurring_customer_invoice.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('recurring-customer-invoices.create',request()->except('page'))}}"
                               class="btn btn-sm btn-success">@lang('general.button_add')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Filtros -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_content">
                            <div class="filter-data">
                                {!! Form::open(['route' => 'recurring-customer-invoices.index','method' => 'GET','class' => '','role' => 'form','id'=>'form']) !!}
                                <div class="row">
                                    <div class="col-md-2 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('filter_name', __('sales/recurring_customer_invoice.entry_name') , ['class' => 'control-label'])) !!}
                                            {!! Form::text('filter_name', request()->input('filter_name'), ['class' => 'form-control', 'placeholder' => __('sales/recurring_customer_invoice.entry_name'),'autofocus']) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            @php
                                                $tmp_customers = [];
                                                if(!empty(request()->input('filter_customer_id'))){
                                                    $tmp_customers = \App\Models\Sales\Customer::where('id',request()->input('filter_customer_id'))->get()->pluck('text_select2','id');
                                                }
                                            @endphp
                                            {!! html_entity_decode(Form::label('filter_customer_id', __('sales/recurring_customer_invoice.entry_customer_id') , ['class' => 'control-label'])) !!}
                                            {!! Form::select('filter_customer_id', $tmp_customers,request()->input('filter_customer_id'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-2 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('filter_branch_office_id', __('sales/recurring_customer_invoice.entry_branch_office_id') , ['class' => 'control-label'])) !!}
                                            {!! Form::select('filter_branch_office_id', $branch_offices,request()->input('filter_branch_office_id'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-2 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('filter_status', __('sales/recurring_customer_invoice.entry_status') , ['class' => 'control-label'])) !!}
                                            {!! Form::select('filter_status', ['1' => __('general.text_enabled'),'0' => __('general.text_disabled')],request()->input('filter_status'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                        </div>
                                    </div>
                                </div>
                                <div class="row" style="margin-top: 10px;">
                                    <div class="col-md-8 col-xs-5 text-left">
                                        <div class="form-inline">
                                        <span>
                                            <span class="hidden-xs">@lang('general.text_item_per_page')</span>
                                            {!! Form::select('limit', $limits,request()->input('limit',setting('list_limit','100')), ['class' => 'form-control input-sm', 'placeholder' => __('general.text_select'),'onchange' => 'this.form.submit()']) !!}
                                        </span>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-xs-7 text-right footer-form">
                                        {!! Form::button(__('general.button_search'),['type' => 'submit', 'class' => 'btn btn-sm btn-default']) !!}
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Filtros -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_list')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <!-- Filtros -->

                            <!-- /Filtros -->
                            <!-- Datos -->
                            <div class="table-responsive table-data table-dropdown">
                                <table class="table table-striped table-hover table-condensed">
                                    <thead>
                                    <tr class="mini">
                                        <th class="text-center">@sortablelink('name',
                                            __('sales/recurring_customer_invoice.column_name'))
                                        </th>
                                        <th class="text-left">@sortablelink('customer.name',
                                            __('sales/recurring_customer_invoice.column_customer'))
                                        </th>
                                        <th class="text-center">@sortablelink('date_start',
                                            __('sales/recurring_customer_invoice.column_date_start'))
                                        </th>
                                        <th class="text-center">@sortablelink('date_end',
                                            __('sales/recurring_customer_invoice.column_date_end'))
                                        </th>
                                        <th class="text-center">@sortablelink('date_last',
                                            __('sales/recurring_customer_invoice.column_date_last'))
                                        </th>
                                        <th class="text-center">@sortablelink('date_next',
                                            __('sales/recurring_customer_invoice.column_date_next'))
                                        </th>
                                        <th class="text-center">@sortablelink('frequency',
                                            __('sales/recurring_customer_invoice.column_frequency'))
                                        </th>
                                        @if(!empty(setting('enabled_projects')))
                                            <th class="text-center">@sortablelink('project.name',
                                                __('sales/customer_invoice.column_project'))
                                            </th>
                                        @endif
                                        <th class="text-center">@sortablelink('currency.name',
                                            __('sales/recurring_customer_invoice.column_currency'))
                                        </th>
                                        <th class="text-center">@sortablelink('amount_total',
                                            __('sales/recurring_customer_invoice.column_amount_total'))
                                        </th>
                                        <th class="text-center">@sortablelink('status',
                                            __('sales/recurring_customer_invoice.column_status'))
                                        </th>
                                        <th class="text-center" width="5%">@lang('general.column_actions')</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($results as $result)
                                        <tr class="mini {{ (!$result->status ? 'text-muted' : '') }}">
                                            <td class="text-center">
                                                <a href="{{ route('recurring-customer-invoices.show',array_merge(['id' => $result->id])) }}">{{$result->name}}</a>
                                            </td>
                                            <td class="text-left">
                                                {{ $result->customer->name }}
                                                @if(!empty($result->date_process))
                                                    <br>
                                                    <small class="text-muted">{{__('sales/recurring_customer_invoice.text_last_process')}}: {{\App\Helpers\Helper::convertSqlToDateTime($result->date_process)}}</small>
                                                    <br>
                                                    <small class="text-muted" title="{!! $result->status_process !!}">{!!str_limit($result->status_process,70) !!}</small>
                                                @else
                                                    <br />
                                                    <small class="text-muted">{{__('sales/recurring_customer_invoice.text_last_process_empty')}}</small>
                                                @endif
                                            </td>
                                            <td class="text-center">{{ \App\Helpers\Helper::convertSqlToDate($result->date_start) }}</td>
                                            <td class="text-center">{{ !empty($result->date_end) ? \App\Helpers\Helper::convertSqlToDate($result->date_end) : '' }}</td>
                                            <td class="text-center">{{ !empty($result->date_last) ? \App\Helpers\Helper::convertSqlToDate($result->date_last) : '' }}</td>
                                            <td class="text-center">{{ \App\Helpers\Helper::convertSqlToDate($result->date_next)}}</td>
                                            <td class="text-center">{{ $result->frequency_name }}</td>
                                            @if(!empty(setting('enabled_projects')))
                                                <td class="text-center">
                                                    {{ $result->project->name ?? '' }}
                                                </td>
                                            @endif
                                            <td class="text-center">{{ $result->currency->code }}</td>
                                            <td class="text-right">{{ money($result->amount_total,$result->currency->code,true) }}</td>
                                            <td class="text-center">
                                                @if($result->status)
                                                    <label class="label label-success">{{ \App\Helpers\Helper::statusHuman($result->status) }}</label>
                                                @else
                                                    <label class="label label-default">{{ \App\Helpers\Helper::statusHuman($result->status) }}</label>
                                                @endif
                                            </td>
                                            <!-- Acciones -->
                                            <td class="text-center nowrap">
                                                <!-- form -->
                                                <!-- form -->
                                            {!! Form::open(['route' => ['recurring-customer-invoices.destroy', $result->id],'method' => 'DELETE','class' => 'hidden','role' => 'form','id' => 'form' . $result->id ]) !!}
                                            {!! Form::close() !!}
                                            <!-- /form -->
                                            <!-- /form -->
                                                <div class="btn-group btn-group-xs">
                                                    <button type="button" class="btn btn-default dropdown-toggle"
                                                            data-toggle="dropdown" data-toggle-position="left"
                                                            aria-expanded="false">
                                                        <i class="fa fa-ellipsis-h"></i>
                                                    </button>
                                                    <ul class="dropdown-menu dropdown-menu-right pull-right"
                                                        style="padding-top: 10px; padding-bottom: 10px;">
                                                        <li>
                                                            <a href="{{ route('recurring-customer-invoices.show',array_merge(['id' => $result->id],request()->except('page'))) }}">
                                                                <i class="fa fa-eye"></i> @lang('general.button_show')
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="{{ route('recurring-customer-invoices.create',['duplicate_id' => $result->id]) }}">
                                                                <i class="fa fa-copy"></i> @lang('general.button_duplicate')
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="{{ route('recurring-customer-invoices.edit',array_merge(['id' => $result->id],request()->except('page'))) }}">
                                                                <i class="fa fa-pencil"></i> @lang('general.button_edit')
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="{{route('recurring-customer-invoices/print',['id' => $result->id])}}"
                                                               target="_blank">
                                                                <i class="fa fa-print"></i> @lang('general.button_print')
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="javascript:;" class=""
                                                               onclick="$('#form{{$result->id}}').submit();">
                                                                <i class="fa fa-trash-o"></i> @lang('general.button_cancel')
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="14" class="text-center">@lang('general.text_no_results')</td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                            <!-- /Datos -->
                            <div class="ln_solid"></div>
                            <!-- Pie de pagina -->
                            <div class="row">
                                @if($results->total() > 0)
                                    <div class="col-md-5 col-xs-12 text-left hidden-xs">
                                    <span class="btn btn-sm btn-default">{{ $results->firstItem() }}
                                        - {{ $results->lastItem() }} @lang('general.text_of') {{ $results->total() }}</span>
                                    </div>
                                    <div class="col-md-7 col-xs-12 text-right">
                                        {{ $results->appends(request()->except('page'))->links() }}
                                    </div>
                                @endif
                            </div>
                            <!-- /Pie de pagina -->
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/bootstrap-wysiwyg/js/bootstrap-wysiwyg.min.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/jquery.hotkeys/jquery.hotkeys.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/google-code-prettify/src/prettify.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            /*Configura datepicker*/

            /* Configura select2 para buscar cliente*/
            $("#form select[name='filter_customer_id']").select2({
                ajax: {
                    url: "{{route('customers/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                placeholder: "@lang('general.text_all')",
                theme: "bootstrap",
                width: "auto",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 3
            });
        });

    </script>
@endsection
