<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{__('sales/recurring_customer_invoice.document_title')}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 310px;
            margin-bottom: 40px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 10px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($recurring_customer_invoice->company_id) }}   !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($recurring_customer_invoice->company_id) }}   !important;
        }
    </style>
</head>
<body style="background-color: white;">
<section class="header" style="top: -287px;">
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td colspan="2" class="text-right">
                <h1>{{ __('sales/recurring_customer_invoice.document_title') }}</h1>
            </td>
        </tr>
        <tr>
            <td width="50%" style="vertical-align: top; padding-top: 10px;">
                @if(!empty(setting('enabled_projects')) && !empty(setting('projects_logo_docs')))
                <img src="{{ \App\Helpers\Helper::logoCompanyDocsProjects($recurring_customer_invoice->company_id,$recurring_customer_invoice->project_id) }}"
                    class="invoice-logo" width="170px" />
                @elseif(!empty(setting('branch_office_logo_docs')))
                <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($recurring_customer_invoice->company_id,$recurring_customer_invoice->branch_office_id) }}"
                    class="invoice-logo" width="170px" />
                @else
                <img src="{{ \App\Helpers\Helper::logoCompanyDocs($recurring_customer_invoice->company_id) }}"
                    class="invoice-logo" width="170px" />
                @endif
            </td>
            <td width="50%" class="text-right text-company" style="vertical-align: top; padding-top: 10px;">
                <span><strong>{{ mb_strtoupper($recurring_customer_invoice->company->name) }}</strong></span>
                <br/>
                <span>{{ $recurring_customer_invoice->company->taxRegimen->name_sat }}</span>
                <br/>
                <span>{{ $recurring_customer_invoice->company->address_1 ?? '' }} {{ $recurring_customer_invoice->company->address_2 ?? '' }} {{ $recurring_customer_invoice->company->address_3 ?? '' }} {{ $recurring_customer_invoice->company->address_4 ?? '' }}</span>
                <br/>
                <span>{{ $recurring_customer_invoice->company->city->name ?? '' }}, {{ ($recurring_customer_invoice->company->state->name ?? '') }}</span>
                <br/>
                <span>{{ $recurring_customer_invoice->company->country->name ?? '' }}{!! ($recurring_customer_invoice->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $recurring_customer_invoice->company->postcode : '') !!}</span>
                <br/>
                <span>{{ mb_strtoupper($recurring_customer_invoice->company->taxid) }}</span>
                <br/>
                <span>---</span>
                <br/>
                <span>{{ $recurring_customer_invoice->company->phone ?? ' ' }}</span>
                <br/>
                <span>{{ $recurring_customer_invoice->company->email ?? ' ' }}</span>
            </td>
        </tr>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary"># {{ $recurring_customer_invoice->name }}</span>

            </td>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary">{{ mb_strtoupper(__('general.text_customer')) }}</span>
            </td>
        </tr>
        <tr>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <span><strong>@lang('sales/recurring_customer_invoice.entry_date_start')
                        : </strong>{{ \App\Helpers\Helper::convertSqlToDate($recurring_customer_invoice->date_start) }}</span>
                <br/>
                <span><strong>@lang('sales/recurring_customer_invoice.entry_date_end')
                                                : </strong>{{ !empty($recurring_customer_invoice->date_end) ? \App\Helpers\Helper::convertSqlToDate($recurring_customer_invoice->date_end): '' }}</span>
                <br/>
                <span><strong>@lang('sales/recurring_customer_invoice.entry_date_last')
                                                : </strong>{{ !empty($recurring_customer_invoice->date_last) ? \App\Helpers\Helper::convertSqlToDate($recurring_customer_invoice->date_last): '' }}</span>
                <br/>
                <span><strong>@lang('sales/recurring_customer_invoice.entry_date_next')
                                                : </strong>{{ \App\Helpers\Helper::convertSqlToDate($recurring_customer_invoice->date_next) }}</span>
                <br/>
                <span><strong>@lang('sales/recurring_customer_invoice.entry_payment_term_id')
                        : </strong>{{ $recurring_customer_invoice->paymentTerm->name }}</span>
                <br/>
                <span><strong>@lang('sales/recurring_customer_invoice.entry_cfdi_use_id')
                        : </strong>{{ $recurring_customer_invoice->cfdiUse->name_sat }}</span>
                <br/>
                <span><strong>@lang('general.text_issued_in')
                        : </strong>{{ $recurring_customer_invoice->branchOffice->name ?? '' }} {!! ($recurring_customer_invoice->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $recurring_customer_invoice->branchOffice->postcode : '') !!}</span>
                <br/>
            </td>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <span><strong>{{ mb_strtoupper($recurring_customer_invoice->customer->name) }}</strong></span>
                <br/>
                <span>{{ $recurring_customer_invoice->customer->address_1 ?? '' }} {{ $recurring_customer_invoice->customer->address_2 ?? '' }} {{ $recurring_customer_invoice->customer->address_3 ?? '' }} {{ $recurring_customer_invoice->customer->address_4 ?? '' }}</span>
                <br/>
                <span>{{ $recurring_customer_invoice->customer->city->name ?? '' }}
                    , {{ $recurring_customer_invoice->customer->state->name ?? '' }}</span>
                <br/>
                <span>{{ $recurring_customer_invoice->customer->country->name ?? '' }}{!! ($recurring_customer_invoice->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $recurring_customer_invoice->customer->postcode : '') !!}</span>
                <br/>
                @lang('sales/recurring_customer_invoice.entry_taxid'): {{ $recurring_customer_invoice->customer->taxid }}
                <br />
                @lang('sales/recurring_customer_invoice.entry_tax_regimen_customer_id2'): {{ $recurring_customer_invoice->taxRegimenCustomer->name_sat ?? ($recurring_customer_invoice->customer->taxRegimen->name_sat ?? '') }}
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="watermark" style="bottom: 540px !important;">
    <span>@lang('general.text_invalid_cfdi')</span>
</section>
<section>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
        <thead>
        <tr>
            <th class="text-left">{{ mb_strtoupper(__('sales/recurring_customer_invoice.column_line_name')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/recurring_customer_invoice.column_line_sat_product_id')) }}</th>
            <th width="14%">{{ mb_strtoupper(__('sales/recurring_customer_invoice.column_line_unit_measure_id')) }}</th>
            <th width="8%">{{ mb_strtoupper(__('sales/recurring_customer_invoice.column_line_quantity')) }}</th>
            <th width="10%">{{ mb_strtoupper(__('sales/recurring_customer_invoice.column_line_price_unit')) }}</th>
            <th width="7%">{{ mb_strtoupper(__('sales/recurring_customer_invoice.column_line_discount')) }}</th>
            <th width="11%">{{ mb_strtoupper(__('sales/recurring_customer_invoice.column_line_amount_untaxed')) }}</th>
        </tr>
        </thead>
        <tbody>
        @foreach($recurring_customer_invoice->recurringCustomerActiveInvoiceLines as $result)
            <tr>
                <td>
                    @if(!empty(setting('show_product_code_on_pdf')))
                        {{$result->product->code ?? 'N/A'}} -
                    @endif
                    {!! nl2br($result->name) !!}
                </td>
                <td class="text-center">{{ $result->satProduct->code }}</td>
                <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,!empty($result->product_id) ? $result->product->price_decimal_place : \App\Helpers\Helper::companyProductPriceDecimalPlace($recurring_customer_invoice->company_id)) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                <td class="text-right">{{ money($result->amount_untaxed,$recurring_customer_invoice->currency->code,true) }}</td>
            </tr>
        @endforeach
        </tbody>
        <tfoot>
        <tr>
            <td colspan="4" class="text-center" style="vertical-align: bottom;">
                <span style="line-height: 16px;">***({{\App\Helpers\Helper::numberToWordCurrency($recurring_customer_invoice->amount_total,$recurring_customer_invoice->currency->code,$recurring_customer_invoice->currency->decimal_place)}}
                    )***</span>
            </td>
            <td colspan="2" class="text-right" style="vertical-align: top; padding-right: 4px;">
                <strong>@lang('general.text_amount_untaxed')</strong><br/>
                @if($recurring_customer_invoice->recurringCustomerInvoiceTaxes->isNotEmpty())
                    @foreach($recurring_customer_invoice->recurringCustomerInvoiceTaxes as $result)
                        <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
            </td>
            <td class="text-right">
                {{ money($recurring_customer_invoice->amount_untaxed,$recurring_customer_invoice->currency->code,true) }}<br/>
                @if($recurring_customer_invoice->recurringCustomerInvoiceTaxes->isNotEmpty())
                    @foreach($recurring_customer_invoice->recurringCustomerInvoiceTaxes as $result)
                        <span style="line-height: 16px;">{{ money(abs($result->amount_tax),$recurring_customer_invoice->currency->code,true) }}</span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ money($recurring_customer_invoice->amount_total,$recurring_customer_invoice->currency->code,true) }}</strong></span>
            </td>
        </tr>
        </tfoot>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="100%" style="vertical-align: top; padding: 5px;">
                <span><strong>@lang('sales/recurring_customer_invoice.entry_payment_way_id')
                        : </strong>{{ $recurring_customer_invoice->paymentWay->name_sat }}</span>
                <br/>
                <span><strong>@lang('sales/recurring_customer_invoice.entry_payment_method_id')
                        : </strong>{{ $recurring_customer_invoice->paymentMethod->name_sat }}</span>
                <br/>
                <span><strong>@lang('sales/recurring_customer_invoice.entry_currency_id')
                        : </strong>{{ $recurring_customer_invoice->currency->code }}{!! ($recurring_customer_invoice->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/recurring_customer_invoice.entry_currency_value').':</strong> '.round($recurring_customer_invoice->currency_value,4) :'') !!}</span>
                <br/>
            </td>
        </tr>
    </table>
    </div>
    @if(!empty($recurring_customer_invoice->comment))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/recurring_customer_invoice.entry_comment')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;">
                    {!! nl2br($recurring_customer_invoice->comment) !!}
                </td>
            </tr>
        </table>
        </div>
    @endif
</section>
</body>
</html>
