@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('sales/recurring_customer_invoice.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('sales/recurring_customer_invoice.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('recurring-customer-invoices.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            @php
                //Obtiene datos del Cfdi33
                $cfdi33 = !empty($data['cfdi33']) ? $data['cfdi33'] : [];
            @endphp

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_content">


                            <section class="content invoice">
                                <!-- title row -->
                                <div class="row">
                                    <div class="col-xs-12 invoice-header">
                                        <h1></h1>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 20px;">
                                    <div class="col-md-6 col-xs-12 invoice-col">
                                            <img src="{{ \App\Helpers\Helper::logoCompanyDocs($recurring_customer_invoice->company_id) }}" class="invoice-logo" width="170px"/>
                                    </div>
                                    <div class="col-md-6 col-xs-12 invoice-col text-right">
                                        <span><strong>{{ mb_strtoupper($recurring_customer_invoice->company->name) }}</strong></span>
                                        <br/>
                                        <span>{{ $recurring_customer_invoice->company->taxRegimen->name_sat }}</span>
                                        <br/>
                                        <span>{{ $recurring_customer_invoice->company->address_1 ?? '' }} {{ $recurring_customer_invoice->company->address_2 ?? '' }} {{ $recurring_customer_invoice->company->address_3 ?? '' }} {{ $recurring_customer_invoice->company->address_4 ?? '' }}</span>
                                        <br/>
                                        <span>{{ $recurring_customer_invoice->company->city->name ?? '' }}
                                            , {{ ($recurring_customer_invoice->company->state->name ?? '') }}</span>
                                        <br/>
                                        <span>{{ $recurring_customer_invoice->company->country->name ?? '' }}{!! ($recurring_customer_invoice->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $recurring_customer_invoice->company->postcode : '') !!}</span>
                                        <br/>
                                        <span>{{ mb_strtoupper($recurring_customer_invoice->company->taxid) }}</span>
                                        <br/>
                                        <span>---</span>
                                        <br/>
                                        <span>{{ $recurring_customer_invoice->company->phone ?? ' ' }}</span>
                                        <br/>
                                        <span>{{ $recurring_customer_invoice->company->email ?? ' ' }}</span>
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 20px;">
                                    <div class="col-md-6 col-xs-12 invoice-col">
                                        <h4 class=""
                                            style="color: {{ \App\Helpers\Helper::companyColorPrimary($recurring_customer_invoice->company_id) }}; font-weight: bold; padding-bottom: 5px; border-bottom: 1px solid #cccccc;">
                                            # {{ $recurring_customer_invoice->name }}
                                            <span class="pull-right">{!! \App\Helpers\Helper::statusHumanRich($recurring_customer_invoice->status) !!}</span>
                                        </h4>
                                        <span><strong>@lang('sales/recurring_customer_invoice.entry_date_start')
                                                : </strong>{{ \App\Helpers\Helper::convertSqlToDate($recurring_customer_invoice->date_start) }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/recurring_customer_invoice.entry_date_end')
                                                : </strong>{{ !empty($recurring_customer_invoice->date_end) ? \App\Helpers\Helper::convertSqlToDate($recurring_customer_invoice->date_end): '' }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/recurring_customer_invoice.entry_date_last')
                                                : </strong>{{ !empty($recurring_customer_invoice->date_last) ? \App\Helpers\Helper::convertSqlToDate($recurring_customer_invoice->date_last): '' }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/recurring_customer_invoice.entry_date_next')
                                                : </strong>{{ \App\Helpers\Helper::convertSqlToDate($recurring_customer_invoice->date_next) }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/recurring_customer_invoice.entry_payment_term_id')
                                                : </strong>{{ $recurring_customer_invoice->paymentTerm->name }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/recurring_customer_invoice.entry_cfdi_use_id')
                                                : </strong>{{ $recurring_customer_invoice->cfdiUse->name_sat }}</span>
                                        <br/>
                                        <span><strong>@lang('general.text_issued_in')
                                                : </strong>{{ $recurring_customer_invoice->branchOffice->name ?? '' }} {!! ($recurring_customer_invoice->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $recurring_customer_invoice->branchOffice->postcode : '') !!}</span>
                                        <br/>
                                    </div>
                                    <div class="col-md-6 col-xs-12 invoice-col">
                                        <h4 class=""
                                            style="color: {{ \App\Helpers\Helper::companyColorPrimary($recurring_customer_invoice->company_id) }}; font-weight: bold; padding-bottom: 5px; border-bottom: 1px solid #cccccc;">{{ mb_strtoupper(__('general.text_customer')) }}</h4>
                                        <span><strong>{{ mb_strtoupper($recurring_customer_invoice->customer->name) }}</strong></span>
                                        <br/>
                                        <span>{{ $recurring_customer_invoice->customer->address_1 ?? '' }} {{ $recurring_customer_invoice->customer->address_2 ?? '' }} {{ $recurring_customer_invoice->customer->address_3 ?? '' }} {{ $recurring_customer_invoice->customer->address_4 ?? '' }}</span>
                                        <br/>
                                        <span>{{ $recurring_customer_invoice->customer->city->name ?? '' }}
                                            , {{ $recurring_customer_invoice->customer->state->name ?? '' }}</span>
                                        <br/>
                                        <span>{{ $recurring_customer_invoice->customer->country->name ?? '' }}{!! ($recurring_customer_invoice->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $recurring_customer_invoice->customer->postcode : '') !!}</span>
                                        <br/>
                                        <span>{{ mb_strtoupper($recurring_customer_invoice->customer->taxid) }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/recurring_customer_invoice.entry_tax_regimen_customer_id2')
                                            : </strong>{{ $recurring_customer_invoice->taxRegimenCustomer->name_sat ?? ($recurring_customer_invoice->customer->taxRegimen->name_sat ?? '') }}</span>
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- Table row -->
                                <div class="row">
                                    <div class="col-md-12 col-xs-12 table">
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                <tr>
                                                    <th class="text-left">{{ mb_strtoupper(__('sales/recurring_customer_invoice.column_line_name')) }}</th>
                                                    <th class="text-center"
                                                        width="9%">{{ mb_strtoupper(__('sales/recurring_customer_invoice.column_line_sat_product_id')) }}</th>
                                                    <th class="text-center"
                                                        width="14%">{{ mb_strtoupper(__('sales/recurring_customer_invoice.column_line_unit_measure_id')) }}</th>
                                                    <th class="text-center"
                                                        width="7%">{{ mb_strtoupper(__('sales/recurring_customer_invoice.column_line_quantity')) }}</th>
                                                    <th class="text-center"
                                                        width="9%">{{ mb_strtoupper(__('sales/recurring_customer_invoice.column_line_price_unit')) }}</th>
                                                    <th class="text-center"
                                                        width="6%">{{ mb_strtoupper(__('sales/recurring_customer_invoice.column_line_discount')) }}</th>
                                                    <th class="text-right"
                                                        width="11%">{{ mb_strtoupper(__('sales/recurring_customer_invoice.column_line_amount_untaxed')) }}</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @foreach($recurring_customer_invoice->recurringCustomerActiveInvoiceLines as $result)
                                                    <tr>
                                                        <td>{{ $result->name }}</td>
                                                        <td class="text-center">{{ $result->satProduct->code }}</td>
                                                        <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                                                        <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                                                        <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,!empty($result->product_id) ? $result->product->price_decimal_place : \App\Helpers\Helper::companyProductPriceDecimalPlace($recurring_customer_invoice->company_id)) }}</td>
                                                        <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                                                        <td class="text-right">{{ money($result->amount_untaxed,$recurring_customer_invoice->currency->code,true) }}</td>
                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- /.row -->
                                <!-- Table row -->
                                <div class="row" style="margin-bottom: 30px;">
                                    <div class="col-md-6 col-xs-12">
                                        <span><strong>@lang('sales/recurring_customer_invoice.entry_payment_way_id')
                                                : </strong>{{ $recurring_customer_invoice->paymentWay->name_sat }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/recurring_customer_invoice.entry_payment_method_id')
                                                : </strong>{{ $recurring_customer_invoice->paymentMethod->name_sat }}</span>
                                        <br/>
                                        <span><strong>@lang('sales/recurring_customer_invoice.entry_currency_id')
                                                : </strong>{{ $recurring_customer_invoice->currency->code }}{!! ($recurring_customer_invoice->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/recurring_customer_invoice.entry_currency_value').':</strong> '.round($recurring_customer_invoice->currency_value,4) :'') !!}</span>
                                        <br/>
                                    </div>
                                    <div class="col-md-6 col-xs-12">
                                        <div class="table-responsive">
                                            <table class="table">
                                                <tbody>
                                                <tr>
                                                    <th style="width:50%">@lang('general.text_amount_untaxed')</th>
                                                    <td>{{ money($recurring_customer_invoice->amount_untaxed,$recurring_customer_invoice->currency->code,true) }}</td>
                                                </tr>
                                                @if($recurring_customer_invoice->recurringCustomerInvoiceTaxes->isNotEmpty())
                                                    @foreach($recurring_customer_invoice->recurringCustomerInvoiceTaxes as $result)
                                                        <tr>
                                                            <th>{{$result->name}}</th>
                                                            <td>{{ money(abs($result->amount_tax),$recurring_customer_invoice->currency->code,true) }}</td>
                                                        </tr>
                                                    @endforeach
                                                @endif
                                                <tr>
                                                    <th>{{ mb_strtoupper(__('general.text_amount_total')) }}</th>
                                                    <td>{{ money($recurring_customer_invoice->amount_total,$recurring_customer_invoice->currency->code,true) }}</td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 15px;">
                                    <div class="col-md-12 col-xs-12 invoice-col">
                                        @if(!empty($recurring_customer_invoice->comment))
                                            <p style="margin-bottom: 2px;"><strong>@lang('sales/recurring_customer_invoice.entry_comment')</strong></p>
                                            <table cellpadding="0" cellspacing="0" class="table table-secundary" width="100%">
                                                <tr>
                                                    <td width="100%" style="vertical-align: top; padding: 5px;">
                                                        {{ $recurring_customer_invoice->comment }}
                                                    </td>
                                                </tr>
                                            </table>
                                        @endif
                                    </div>
                                </div>
                                <!-- /.row -->
                            </section>


                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

    </script>
@endsection
