@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('shop/cart.document_title'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/pnotify/dist/pnotify.css') }}" rel="stylesheet"/>
    <link href="{{ asset('gentelella/plugins/pnotify/dist/pnotify.brighttheme.css') }}" rel="stylesheet"/>
    <link href="{{ asset('gentelella/plugins/iCheck/skins/flat/green.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('shop/cart.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <p>&nbsp;</p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_content">
                            @php
                                $cart = Cart::session(Auth::user()->id)->getContent()->first();
                                $subtotal = Cart::session(Auth::user()->id)->getSubTotalWithoutConditions(false);
                                $total = Cart::session(Auth::user()->id)->getTotal(false);
                                $taxes = $total-$subtotal;
                            @endphp
                            {!! Form::open(['route' => 'cart/process','method' => 'POST','class' => '','role' => 'form','id'=>'form_process']) !!}
                            <input name="payment_platform" type="hidden" value="">
                            <input name="stripe_payment_method" type="hidden" value="">
                            <!-- Datos -->
                            <div class="row">
                                <div class="col-xs-12">
                                    <h4 class="text-center"
                                        style="margin: 15px 0 25px 0;">@lang('shop/cart.document_subtitle')</h4>
                                    <div class="ln_solid"></div>
                                </div>
                            </div>
                            <!-- /Datos -->
                            <div class="row">
                                <div class="col-sm-8 col-xs-12">
                                    <div class="col-xs-12">
                                        <h4 class="" style="margin-bottom: 15px;"><strong>@lang('shop/cart.text_payment_method')</strong></h4>
                                        <div id="toggler">
                                            <div class="panel">
                                                <p>
                                                    @foreach ($payment_platforms as $payment_platform)
                                                        @if($payment_platform['active'])
                                                            <button type="button" id="b" class="btn btn-default btn-payment-platform" data-payment-platform="{{$payment_platform['code']}}" data-toggle="collapse" data-target="#{{ $payment_platform['code'] }}Collapse" data-parent="#toggler" style="border: 0; min-width: 175px;">
                                                                <img class="img-thumbnail mb-3" src="{{ asset($payment_platform['image']) }}" style="width: 90px;">
                                                                <br/>
                                                                <b>{{$payment_platform['name']}}</b>
                                                            </button>
                                                        @endif
                                                    @endforeach
                                                </p>
                                                <div class="ln_solid"></div>
                                                @foreach ($payment_platforms as $payment_platform)
                                                    @if($payment_platform['active'])
                                                        <div
                                                                id="{{ $payment_platform['code'] }}Collapse"
                                                                class="collapse mt-1 pl-2"
                                                        >
                                                            <div class="card card-block">
                                                                @includeIf('layouts.partials.cart.collapse_' . $payment_platform['code'] . '')
                                                            </div>
                                                        </div>
                                                    @endif
                                                @endforeach
                                                <div class="card card-block pl-2">
                                                    <h5 class="" style="margin-top:20px; margin-bottom: 15px;"><strong>@lang('shop/cart.text_notices')</strong></h5>
                                                    <div class="" style="padding-left: 5px;">
                                                        <ul>
                                                            <li>{!! config('app.payment_notice_1') !!}</li>
                                                            <li>{!! config('app.payment_notice_2') !!}</li>
                                                            <li>{!! sprintf(config('app.payment_notice_3'),config('app.account_days_request_customer_invoice')) !!}</li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4 col-xs-12">
                                    <div class="col-xs-12 ymwidget widget_tally_box" style="">
                                        <div class="x_panel ui-ribbon-container">
                                            <div class="x_title">
                                                <h4 class="text-center"><strong>@lang('shop/cart.text_resume')</strong></h4>
                                                <div class="clearfix"></div>
                                            </div>
                                            <div class="x_content">
                                                <div class="text-center" style="margin-top: 45px; margin-bottom: 60px">
                                                    <h1 class="green" style="font-size: 3.0rem">{{$cart->name}}</h1>
                                                </div>
                                                <h3 class="name_title">{{__('shop/cart.text_subtotal')}}: <span class="pull-right">{{ \App\Helpers\Helper::numberFormatMoney($subtotal) }}</span></h3>
                                                <h3 class="name_title" style="margin-top: 15px;">{{__('shop/cart.text_taxes')}}: <span class="pull-right">{{ \App\Helpers\Helper::numberFormatMoney($taxes) }}</span></h3>
                                                <div class="ln_solid"></div>
                                                <h2 class="name_title">{{mb_strtoupper(__('shop/cart.text_total'))}}: <span class="pull-right">{{ \App\Helpers\Helper::numberFormatMoney($total) }}</span></h2>
                                            </div>
                                        </div>
                                        <div class="x_panel ui-ribbon-container text-center pt-4" id="footer_resume">
                                            {!! Form::button(__('general.button_buy_confirm'),['type' => 'submit', 'class' => 'btn btn-success']) !!}
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Pie de pagina -->
                            <div class="row">
                                <div class="col-md-12 col-xs-12 text-center footer-form">
                                    <div class="ln_solid"></div>
                                </div>
                                <div class="col-md-6 col-xs-6 text-left footer-form">
                                    <a href="{{route('shop')}}" class="btn btn-default">
                                        @lang('general.button_previous')
                                    </a>
                                </div>
                                <div class="col-md-6 col-xs-6 text-right footer-form">

                                </div>
                            </div>
                            <!-- /Pie de pagina -->
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/pnotify/dist/pnotify.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/iCheck/icheck.min.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            $("#form_process .btn-payment-platform").on("click", function (e) {
                $("#form_process input[name='payment_platform']").val($(this).attr('data-payment-platform'));
                if($(this).attr('data-payment-platform') == 'stripe')
                    $('#footer_resume').addClass('hidden')
                else
                    $('#footer_resume').removeClass('hidden')
            });
        });

    </script>
@endsection
