<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$folio->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 180px;
            margin-bottom: 40px;
        }
        body {
            font-size: 8pt;
        }
        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 10px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }
    </style>
</head>
<body style="background-color: white;">
<section class="header" style="top: -160px;">
    <p>
        <img src="{{ asset('img/logo/factura-16-logo-horizontal.png') }}" class="invoice-logo"/>
    </p>
    <h1 class="text-left green">@lang('shop/cart.text_success_help0')</h1>
    <p class="dark" style="margin: 8px 0 0 0;">@lang('shop/cart.entry_name'): {{$folio->name}}</p>
    <p class="dark" style="margin: 0;">@lang('shop/cart.entry_created_at'): {{\App\Helpers\Helper::convertSqlToDateTime($folio->created_at)}}</p>
    <div class="ln_solid"></div>
</section>
<section class="footer">
    <hr>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">

            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
</section>

<section>
    <div class="row">
        <div class="col-xs-7">
            @if($folio->payment_platform == 'oxxo')
                @php
                    $payment_platform = collect(config('app.payment_platforms'))->where('code','=',$folio->payment_platform)->first();
                @endphp
                <h3 class="" style="margin-bottom: 10px;">
                    <strong>{{$folio->payment_platform_name}}</strong>
                </h3>
                <div class="" style="padding-left: 20px; font-size: 12px;">
                    <img src="{{asset('img/payment_platforms/'.$folio->payment_platform.'_pdf.png')}}" width="100px" style="margin-top: 7px; margin-bottom: 15px;"><br/>
                    {!! sprintf(__('shop/cart.text_platform_payment_bank'),config('services.'.$folio->payment_platform.'.bank')) !!}<br/>
                    {!! sprintf(__('shop/cart.text_platform_payment_debit_card'),config('services.'.$folio->payment_platform.'.debit_card')) !!}<br/>
                    <strong>{!! sprintf(__('shop/cart.text_platform_payment_amount'),\App\Helpers\Helper::numberFormatMoney($folio->amount_total,2)) !!}</strong><br/>
                </div>
                <div class="">
                    <h4 class="" style="margin-top: 15px; margin-bottom: 2px;">
                        <strong>@lang('shop/cart.text_confirm_payment')</strong>
                    </h4>
                    <div class="" style="padding-left: 20px;">
                        <p>{!! config('services.'.$folio->payment_platform.'.text_confirm_payment') !!}</p>
                    </div>
                </div>
            @endif
            @if($folio->payment_platform == 'deposit_transfer')
                @php
                    $payment_platform = collect(config('app.payment_platforms'))->where('code','=',$folio->payment_platform)->first();
                @endphp
                <h3 class="" style="margin-bottom: 10px;">
                    <strong>{{__('shop/cart.text_platform_payment_deposit_transfer')}}</strong>
                </h3>
                <div class="" style="padding-left: 20px; font-size: 12px;">
                    <img src="{{asset('img/payment_platforms/bank_'.strtolower(config('services.'.$folio->payment_platform.'.bank')).'.png')}}" width="70px" style="margin-bottom: 7px;"><br/>
                    {!! sprintf(__('shop/cart.text_platform_payment_bank'),config('services.'.$folio->payment_platform.'.bank')) !!}<br/>
                    {!! sprintf(__('shop/cart.text_platform_payment_name'),config('services.'.$folio->payment_platform.'.name')) !!}<br/>
                    {!! sprintf(__('shop/cart.text_platform_payment_number'),config('services.'.$folio->payment_platform.'.number')) !!}<br/>
                    {!! sprintf(__('shop/cart.text_platform_payment_clabe_number'),config('services.'.$folio->payment_platform.'.clabe_number')) !!}<br/>
                    @if(!empty(config('services.'.$folio->payment_platform.'.debit_card')))
                    {!! sprintf(__('shop/cart.text_platform_payment_debit_card'),config('services.'.$folio->payment_platform.'.debit_card')) !!}<br/>
                    @endif
                    <strong>{!! sprintf(__('shop/cart.text_platform_payment_amount'),\App\Helpers\Helper::numberFormatMoney($folio->amount_total,2)) !!}</strong><br/>
                </div>
                <div class="">
                    <h4 class="" style="margin-top: 15px; margin-bottom: 2px;">
                        <strong>@lang('shop/cart.text_confirm_payment')</strong>
                    </h4>
                    <div class="" style="padding-left: 20px;">
                        <p>{!! config('services.'.$folio->payment_platform.'.text_confirm_payment') !!}</p>
                    </div>
                </div>
            @endif
            @if($folio->payment_platform == 'sinvacrem')
                @php
                    $payment_platform = collect(config('app.payment_platforms'))->where('code','=',$folio->payment_platform)->first();
                @endphp
                <h3 class="" style="margin-bottom: 10px;">
                    <strong>{{$folio->payment_platform_name}}</strong>
                </h3>
                <div class="" style="padding-left: 20px; font-size: 12px;">
                    <img src="{{asset('img/payment_platforms/'.$folio->payment_platform.'_pdf.png')}}" width="130px" style="margin-top: 7px; margin-bottom: 15px;"><br/>
                    {!! sprintf(__('shop/cart.text_platform_payment_name'),config('services.'.$folio->payment_platform.'.name')) !!}<br/>
                    {!! sprintf(__('shop/cart.text_platform_payment_partner'),config('services.'.$folio->payment_platform.'.partner')) !!}<br/>
                    {!! sprintf(__('shop/cart.text_platform_payment_number'),config('services.'.$folio->payment_platform.'.number')) !!}<br/>
                    <strong>{!! sprintf(__('shop/cart.text_platform_payment_amount'),\App\Helpers\Helper::numberFormatMoney($folio->amount_total,2)) !!}</strong><br/>
                </div>
                <div class="">
                    <h4 class="" style="margin-top: 15px; margin-bottom: 2px;">
                        <strong>@lang('shop/cart.text_confirm_payment')</strong>
                    </h4>
                    <div class="" style="padding-left: 20px;">
                        <p>{!! config('services.'.$folio->payment_platform.'.text_confirm_payment') !!}</p>
                    </div>
                </div>
            @endif
            @if($folio->payment_platform == 'bancoppel')
                @php
                    $payment_platform = collect(config('app.payment_platforms'))->where('code','=',$folio->payment_platform)->first();
                @endphp
                <h3 class="" style="margin-bottom: 10px;">
                    <strong>{{$folio->payment_platform_name}}</strong>
                </h3>
                <div class="" style="padding-left: 20px; font-size: 12px;">
                    <img src="{{asset('img/payment_platforms/'.$folio->payment_platform.'_pdf.png')}}" width="130px" style="margin-top: 7px; margin-bottom: 15px;"><br/>
                    {!! sprintf(__('shop/cart.text_platform_payment_name'),config('services.'.$folio->payment_platform.'.name')) !!}<br/>
                    {!! sprintf(__('shop/cart.text_platform_payment_number'),config('services.'.$folio->payment_platform.'.number')) !!}<br/>
                    {!! sprintf(__('shop/cart.text_platform_payment_debit_card'),config('services.'.$folio->payment_platform.'.debit_card')) !!}<br/>
                    <strong>{!! sprintf(__('shop/cart.text_platform_payment_amount'),\App\Helpers\Helper::numberFormatMoney($folio->amount_total,2)) !!}</strong><br/>
                </div>
                <div class="">
                    <h4 class="" style="margin-top: 15px; margin-bottom: 2px;">
                        <strong>@lang('shop/cart.text_confirm_payment')</strong>
                    </h4>
                    <div class="" style="padding-left: 20px;">
                        <p>{!! config('services.'.$folio->payment_platform.'.text_confirm_payment') !!}</p>
                    </div>
                </div>
            @endif
            @if($folio->payment_platform == 'paypal')
                @php
                    $payment_platform = collect(config('app.payment_platforms'))->where('code','=',$folio->payment_platform)->first();
                @endphp
                <h3 class="" style="margin-bottom: 10px;">
                    <strong>{{$folio->payment_platform_name}}</strong>
                </h3>
                <div class="" style="padding-left: 20px; font-size: 12px;">
                    <img src="{{asset('img/payment_platforms/'.$folio->payment_platform.'_pdf.png')}}" width="100px" style="margin-top: 7px; margin-bottom: 15px;"><br/>
                    <strong>{!! sprintf(__('shop/cart.text_platform_payment_amount'),\App\Helpers\Helper::numberFormatMoney($folio->amount_total,2)) !!}</strong><br/>
                </div>
                <div class="">
                    <h4 class="" style="margin-top: 15px; margin-bottom: 2px;">
                        <strong>@lang('shop/cart.text_confirm_payment_activate_folios')</strong>
                    </h4>
                    <div class="" style="padding-left: 20px;">
                        <p>{!! config('services.'.$folio->payment_platform.'.text_confirm_payment') !!}</p>
                    </div>
                </div>
            @endif
            @if($folio->payment_platform == 'stripe')
                @php
                    $payment_platform = collect(config('app.payment_platforms'))->where('code','=',$folio->payment_platform)->first();
                @endphp
                <h3 class="" style="margin-bottom: 10px;">
                    <strong>{{$folio->payment_platform_name}}</strong>
                </h3>
                <div class="" style="padding-left: 20px; font-size: 12px;">
                    <img src="{{asset('img/payment_platforms/'.$folio->payment_platform.'_pdf.png')}}" width="100px" style="margin-top: 7px; margin-bottom: 15px;"><br/>
                    <strong>{!! sprintf(__('shop/cart.text_platform_payment_amount'),\App\Helpers\Helper::numberFormatMoney($folio->amount_total,2)) !!}</strong><br/>
                </div>
                <div class="">
                    <h4 class="" style="margin-top: 15px; margin-bottom: 2px;">
                        <strong>@lang('shop/cart.text_confirm_payment_activate_folios')</strong>
                    </h4>
                    <div class="" style="padding-left: 20px;">
                        <p>{!! config('services.'.$folio->payment_platform.'.text_confirm_payment') !!}</p>
                    </div>
                </div>
            @endif

            <div class="">
                <h4 class="" style="margin-top: 5px; margin-bottom: 2px;">
                    <strong>@lang('shop/cart.text_notices')</strong>
                </h4>
                <div class="" style="padding-left: 0;">
                    <ul>
                        <li>{!! config('app.payment_notice_1') !!}</li>
                        <li>{!! config('app.payment_notice_2') !!}</li>
                        <li>{!! sprintf(config('app.payment_notice_3'),config('app.account_days_request_customer_invoice')) !!}</li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-xs-4">
            <div class="x_panel">
                <h3 class="text-center" style="font-weight: bold;" >@lang('shop/cart.text_resume')</h3>
                <div class="x_content">
                    <div class="text-center" style="margin-top: 30px; margin-bottom: 50px">
                        <h1 class="green" style="font-size: 1.7rem">{{$folio->product}}</h1>
                    </div>
                    <h3 class="name_title">{{__('shop/cart.text_subtotal')}}: <span class="pull-right">{{ \App\Helpers\Helper::numberFormatMoney($folio->amount_untaxed) }}</span></h3>
                    <h3 class="name_title" style="margin-top: 15px;">{{__('shop/cart.text_taxes')}}: <span class="pull-right">{{ \App\Helpers\Helper::numberFormatMoney($folio->amount_tax) }}</span></h3>
                    <div class="ln_solid"></div>
                    <h3 class="name_title">{{mb_strtoupper(__('shop/cart.text_total'))}} <small>(MXN)</small>: <span class="pull-right">{{ \App\Helpers\Helper::numberFormatMoney($folio->amount_total) }}</span></h3>
                </div>
            </div>
        </div>
    </div>
</section>
</body>
</html>
