@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('shop/cart.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">
    
    </div>
    
    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">
            
            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('shop/cart.document_subtitle_success')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <p>&nbsp;</p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->
            
            <div class="clearfix"></div>
            
            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->
            
            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_content">
                            <h1 class="text-center green" style="font-size: 100px; font-weight: normal; margin: 65px 0;">
                                <i class="fa fa-check-circle-o"></i>
                            </h1>
                            <h1 class="text-center green">@lang('shop/cart.text_success_help1')</h1>
                            <h4 class="text-center" style="margin-bottom: 1px;"><strong>@lang('shop/cart.text_success_help2')</strong></h4>
                            @if($folio->status == \App\Models\Base\Folio::PER_ACTIVE)
                                <h4 class="text-center" style="margin-bottom: 50px;"><strong>@lang('shop/cart.text_success_help3')</strong></h4>
                            @else
                                @if($folio->status == \App\Models\Base\Folio::ACTIVE && $folio->payment_platform == 'paypal')
                                    <h4 class="text-center" style="margin-bottom: 50px;"><strong>@lang('shop/cart.text_success_help5')</strong></h4>
                                @else
                                    <h4 class="text-center" style="margin-bottom: 30px;"><strong>&nbsp;</strong></h4>
                                @endif
                            @endif
                            
                            <p class="text-center">
                                <a href="{{route('cart/print',['id' => $folio->id])}}" class="btn btn-success" target="_blank">
                                    @lang('general.button_print')
                                </a>
                                <a href="{{route('home')}}" class="btn btn-default">
                                    @lang('general.button_home')
                                </a>
                            </p>
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->
        
        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
        
        });
    
    </script>
@endsection