@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('shop/shop.document_title'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/pnotify/dist/pnotify.css') }}" rel="stylesheet"/>
    <link href="{{ asset('gentelella/plugins/pnotify/dist/pnotify.brighttheme.css') }}" rel="stylesheet"/>
    <link href="{{ asset('gentelella/plugins/iCheck/skins/flat/green.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('shop/shop.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('cart/checkout')}}"
                               class="btn btn-sm btn-success">@lang('general.button_continue')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_content">
                            <!-- Filtros -->

                            <!-- /Filtros -->
                            <!-- Datos -->
                            <div class="row">
                                <div class="col-xs-12">
                                    <h4 class="text-left" style="margin: 15px 0 25px 0;"><strong>@lang('shop/shop.document_subtitle')</strong></h4>
                                    <div class="ln_solid"></div>
                                </div>
                            </div>
                            <div class="row">
                                @foreach($results as $result)
                                    <div class="col-sm-4 col-md-3 col-xs-12 ymwidget widget_tally_box" style="margin-top: 15px; margin-bottom: 10px;">
                                        <div class="x_panel ui-ribbon-container fixed_height_360">
                                            <a href="#" class="add-to-cart {{ Cart::session(Auth::user()->id)->has($result->id) ? 'active' : '' }}" data-id="{{$result->id}}">
                                                @if($result->top)
                                                <div class="ui-ribbon-wrapper">
                                                    <div class="ui-ribbon">
                                                        Top
                                                    </div>
                                                </div>
                                                @endif
                                                <div class="x_content">
                                                    <div class="text-center" style="margin-top: 50px; margin-bottom: 50px">
                                                        <h1 class="green" style="font-size: 5.2rem">{{\App\Helpers\Helper::numberFormat($result->quantity_folio,0)}}</h1>
                                                    </div>
                                                    @php
                                                    $price = $result->price;
                                                    if(!empty(Auth::user()->sysCustomer->distributor_id)){
                                                        $sys_list_price_distributor = \App\Models\System\SysListPriceDistributor::active()
                                                            ->where('distributor_id','=',Auth::user()->sysCustomer->distributor_id)
                                                            ->where('shop_product_id','=',$result->id)
                                                            ->get()
                                                            ->first();
                                                        if(!empty($sys_list_price_distributor)){
                                                            if($sys_list_price_distributor->price > 0){
                                                                $price = $sys_list_price_distributor->price;
                                                            }
                                                        }
                                                    }
                                                    @endphp
                                                    <h3 class="name_title" style="margin-bottom: 20px;">{{ \App\Helpers\Helper::numberFormatMoney($price,2) }}</h3>
                                                    <div class="divider"></div>
                                                    <div class="text-center" style="margin-top: 15px; height: 95px; overflow: hidden; text-overflow: ellipsis; line-clamp: 2; -webkit-box-orient: vertical; -webkit-line-clamp: 5; display: -webkit-box;">{{$result->description}}</div>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <div class="row">
                                <div class="col-xs-12">
                                    <h4 class="text-left" style="margin: 15px 0 25px 0;">
                                        <small>* @lang('shop/shop.help_taxes')</small><br>
                                        <small>* @lang('shop/shop.help_comments')</small>
                                    </h4>
                                </div>
                            </div>
                            <!-- /Datos -->
                            <!-- Pie de pagina -->
                            <div class="row">
                                <div class="col-md-12 col-xs-12 footer-form">
                                    <div class="ln_solid"></div>
                                </div>
                                <div class="col-md-6 col-xs-6 text-left footer-form">
                                    <a href="{{route('home')}}" class="btn btn-default">
                                        @lang('general.button_cancel')
                                    </a>
                                </div>
                                <div class="col-md-6 col-xs-6 text-right footer-form">
                                    <a href="{{route('cart/checkout')}}" class="btn btn-success btn-shopping-cart-next">
                                        @lang('general.button_continue')
                                    </a>
                                </div>
                            </div>
                            <!-- /Pie de pagina -->
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/pnotify/dist/pnotify.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/iCheck/icheck.min.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            $(".add-to-cart").on("click", function (e) {
                e.preventDefault();
                let id = $(this).attr("data-id");
                $(".add-to-cart").removeClass("active");
                let item = $(this);
                if(id){
                    let form_data = {
                        "id": id,
                    };
                    $.ajax({
                        url: "{{ route('cart.store') }}",
                        type: "POST",
                        dataType: "JSON",
                        data: form_data,
                        success: function (data) {
                            if (data) {
                                item.addClass("active");
                                $("#shopping_cart").html(data.icon_shopping_cart_html);
                                new PNotify({
                                    title: "{{__('general.text_done')}}!",
                                    text: data.success,
                                    type: "info",
                                    addclass: "translucent pnotify-center stack-bottomright",
                                    stack: {"dir1": "down", "dir2": "right"},
                                });
                            }
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });
        });

    </script>
@endsection
