@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('shop/shop_product.document_title'))
@section('css_specific')
    <link href="{{ asset('vendor/fancybox-master/dist/jquery.fancybox.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">
    
    </div>
    
    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">
            
            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('shop/shop_product.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('shop-products.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->
            
            <div class="clearfix"></div>
            
            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->
            
            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>{{ $shop_product->description }}</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                        {!! Form::model($shop_product,['route' => ['shop-products.update',$shop_product->id],'method' => 'PUT','class' => 'form-horizontal','role' => 'form','id' => 'form','files'=>true]) !!}
                        <!-- input hidden -->
                        <!-- /.input hidden -->
                            <div class="row">
                                <div class="form-group form-group-sm{{ $errors->has('code') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('code', __('shop/shop_product.entry_code') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('code', old('code'), ['class' => 'form-control', 'placeholder' => __('shop/shop_product.entry_code'),'','autofocus']) !!}
                                        @if ($errors->has('code'))
                                            <span class="help-block"><small>{{ $errors->first('code') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }} hidden">
                                    {!! html_entity_decode(Form::label('name', __('shop/shop_product.entry_name') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('shop/shop_product.entry_name'),'','']) !!}
                                        @if ($errors->has('name'))
                                            <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('description') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('description', __('shop/shop_product.entry_description') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::textarea('description', old('description'), ['class' => 'form-control', 'placeholder' => __('shop/shop_product.entry_description'),'rows' => '3']) !!}
                                        @if ($errors->has('description'))
                                            <span class="help-block"><small>{{ $errors->first('description') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('quantity_folio', __('shop/shop_product.entry_quantity_folio') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('quantity_folio', old('quantity_folio'), ['class' => 'form-control', 'placeholder' => __('shop/shop_product.entry_quantity_folio'),'','step' => 'any']) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('price', __('shop/shop_product.entry_price') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('price', old('price',\App\Helpers\Helper::numberFormat($shop_product->price,2,false)), ['class' => 'form-control', 'placeholder' => __('shop/shop_product.entry_price'),'','step' => 'any']) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('taxes[]', __('shop/shop_product.entry_taxes') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::select('taxes[]', $taxes,old('taxes'), ['class' => 'form-control my-select2','multiple' => 'multiple']) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('top', __('shop/shop_product.entry_top') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('top', '1',(!empty(old('top',$shop_product->top)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! Form::label('sort_order', __('shop/shop_product.entry_sort_order'), ['class' => 'col-md-3 col-xs-12 control-label']) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('sort_order', old('sort_order'), ['class' => 'form-control', 'placeholder' => __('shop/shop_product.entry_sort_order')]) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('status', __('shop/shop_product.entry_status') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('status', '1',(!empty(old('status',$shop_product->status)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="ln_solid"></div>
                                <div class="">
                                    <div class="col-md-6 col-xs-12 col-md-offset-3 footer-form">
                                        {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                        &nbsp;&nbsp;&nbsp;
                                        <a href="{{route('shop-products.index',request()->except('page'))}}"
                                           class="btn btn-sm btn-default">@lang('general.button_discard')
                                        </a>
                                    </div>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->
        
        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('vendor/fancybox-master/dist/jquery.fancybox.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            /* Configura select2 */
            $("#form .my-select2").select2({
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "auto",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
            });
        });
    
    </script>
@endsection