@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('system/sys_customer.document_title'))
@section('css_specific')

@endsection
@section('css')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('system/sys_customer.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('sys-customers.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_add')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <div id="ym_loading" class="text-center hidden">
                                <div class="mt-5 mb-5"><img src="/img/loading.gif" style="width: 200px;"></div>
                                <h2>{{__('system/sys_customer.text_loading')}}</h2>
                            </div>
                            {!! Form::open(['route' => 'sys-customers.store','method' => 'POST','class' => 'form-horizontal','role' => 'form','id'=>'form']) !!}
                            {!! Form::hidden('domain', old('domain',config('app.tenant_base_url'))) !!}
                            <div class="row">
                                <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('name', __('system/sys_customer.entry_name') . ' <span class="required">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_name'),'required','autofocus','maxlength' => '200']) !!}
                                        @if ($errors->has('name'))
                                            <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ ($errors->has('record') || $errors->has('fqdn')) ? ' has-error' : '' }} hidden">
                                    {!! html_entity_decode(Form::label('record', __('system/sys_customer.entry_record') . ' <span class="required">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <div class="input-group input-group-sm">
                                            {!! Form::text('record', old('record'), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_record')]) !!}
                                            <span class="input-group-addon">.{{config('app.tenant_base_url')}}</span>
                                        </div>
                                        @if ($errors->has('record'))
                                            <span class="help-block"><small>{{ $errors->first('record') }}</small></span>
                                        @endif
                                        @if ($errors->has('fqdn'))
                                            <span class="help-block"><small>{{ $errors->first('fqdn') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('taxid') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('taxid', __('system/sys_customer.entry_taxid') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('taxid', old('taxid'), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_taxid'),'required','maxlength' => '13', 'style' => 'text-transform:uppercase;']) !!}
                                        @if ($errors->has('taxid'))
                                            <span class="help-block"><small>{{ $errors->first('taxid') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('name_user') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('name_user', __('system/sys_customer.entry_name_user') . ' <span class="required">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('name_user', old('name_user'), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_name_user'),'required','maxlength' => '200']) !!}
                                        @if ($errors->has('name_user'))
                                            <span class="help-block"><small>{{ $errors->first('name_user') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('email') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('email', __('system/sys_customer.entry_email') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::email('email', old('email'), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_email'),'required','maxlength' => '100']) !!}
                                        @if ($errors->has('email'))
                                            <span class="help-block"><small>{{ $errors->first('email') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('phone') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('phone', __('system/sys_customer.entry_phone') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('phone', old('phone'), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_phone'),'maxlength' => '100']) !!}
                                        @if ($errors->has('phone'))
                                            <span class="help-block"><small>{{ $errors->first('phone') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                @if(Auth::user()->superadmin)
                                <div class="form-group form-group-sm{{ $errors->has('distributor_id') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('distributor_id', __('sales/customer_invoice.entry_distributor_id') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::select('distributor_id', $distributors,old('distributor_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        @if ($errors->has('distributor_id'))
                                            <span class="help-block"><small>{{ $errors->first('distributor_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                @endif
                                <div class="form-group form-group-sm">
                                    {!! Form::label('sort_order', __('system/sys_customer.entry_sort_order'), ['class' => 'col-md-3 col-xs-12 control-label']) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('sort_order', old('sort_order'), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_sort_order')]) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm hidden">
                                    {!! html_entity_decode(Form::label('status', __('system/sys_customer.entry_status') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('status', '1',(!empty(old('status',1)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="divider-dashed"></div>
                                <h4>@lang('system/sys_customer.text_help_1')</h4>
                                <p class="font-gray-dark">
                                    @lang('system/sys_customer.text_help_2')
                                </p>
                                <div class="form-group form-group-sm{{ $errors->has('product') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('product', __('system/sys_customer.entry_product') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('product', old('product'), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_product')]) !!}
                                        @if ($errors->has('product'))
                                            <span class="help-block"><small>{{ $errors->first('product') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('amount_total') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('amount_total', __('system/sys_customer.entry_amount_total') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('amount_total', old('amount_total'), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_amount_total')]) !!}
                                        @if ($errors->has('amount_total'))
                                            <span class="help-block"><small>{{ $errors->first('amount_total') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('quantity_folio') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('quantity_folio', __('system/sys_customer.entry_quantity_folio') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('quantity_folio', old('quantity_folio'), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_quantity_folio')]) !!}
                                        @if ($errors->has('quantity_folio'))
                                            <span class="help-block"><small>{!! $errors->first('quantity_folio') !!}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('expiry_date') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('expiry_date', __('system/sys_customer.entry_expiry_date') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <div class="input-group input-group-sm">
                                            {!! Form::text('expiry_date', old('expiry_date',\App\Helpers\Helper::date(\Date::now()->addDays(30))), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_expiry_date')]) !!}
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                        </div>
                                        @if ($errors->has('expiry_date'))
                                            <span class="help-block"><small>{{ $errors->first('expiry_date') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="divider-dashed"></div>
                                <h4>@lang('system/sys_customer.text_help_3')</h4>
                                <p class="font-gray-dark">
                                    @lang('system/sys_customer.text_help_4')
                                </p>
                                <div class="form-group form-group-sm{{ $errors->has('shop_product_id') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('shop_product_id', __('system/sys_customer.entry_shop_product_id') . ' ', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::select('shop_product_id', $shop_products,old('shop_product_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        @if ($errors->has('shop_product_id'))
                                            <span class="help-block"><small>{!! $errors->first('shop_product_id')  !!}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="hidden">
                                    <div class="divider-dashed"></div>
                                    <h4>@lang('system/sys_customer.text_help_5')</h4>
                                    <p class="font-gray-dark">
                                        @lang('system/sys_customer.text_help_6')
                                    </p>
                                    <div class="form-group form-group-sm{{ $errors->has('db_shared_hosting') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('db_shared_hosting', __('system/sys_customer.entry_db_shared_hosting') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                        <div class="col-md-6 col-xs-12">
                                            {!! Form::text('db_shared_hosting', old('db_shared_hosting'), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_db_shared_hosting')]) !!}
                                            @if ($errors->has('db_shared_hosting'))
                                                <span class="help-block"><small>{{ $errors->first('db_shared_hosting') }}</small></span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="ln_solid"></div>
                                <div class="">
                                    <div class="col-md-6 col-xs-12 col-md-offset-3 footer-form">
                                        {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                        &nbsp;&nbsp;&nbsp;
                                        <a href="{{route('sys-customers.index',request()->except('page'))}}"
                                           class="btn btn-sm btn-default">@lang('general.button_discard')
                                        </a>
                                    </div>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            $("#form input[name='expiry_date']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false
            }, function (chosen_date) {
                $("#form input[name='expiry_date']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });

            $(document).on("submit", '#form', function (e) {
                e.preventDefault();
                var form = $(this);
                form.find(".help-block").remove();
                form.find(".form-control").parent().removeClass("has-error");
                form.addClass('hidden')
                $("#ym_loading").removeClass('hidden')
                window.scrollTo(0, 0);

                Pace.ignore(function(){
                    $.ajax({
                        url: form.attr('action'),
                        type: "POST",
                        dataType: "JSON",
                        data: form.serialize(),
                        success: function (data) {
                            if (data.success) {
                                setTimeout(function () {
                                    location.href = "{{ route('sys-customers.index') }}";
                                }, 2000);
                            }
                        },
                        error: function (error, textStatus, errorThrown) {
                            form.removeClass('hidden')
                            $("#ym_loading").addClass('hidden')
                            if (error.status == 422) {
                                let message = error.responseJSON.error;
                                //Si trae objecto con errores
                                if(typeof(message) === "object"){
                                    $.each( message, function( key, value ) {
                                        form.find("[name='"+key+"']").after(messageSmallHelpBlock(value)).parent().addClass("has-error");
                                    });
                                }else{
                                    $("#general_messages").html(alertMessage("danger", message));
                                }
                                setTimeout(function () {
                                    $("#general_messages").html("");
                                }, 12000);
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    })
                })
            });
        });

    </script>
@endsection
