@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('system/sys_customer.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('system/sys_customer.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('sys-customers.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>{{ $sys_customer->name }}</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            {!! Form::model($sys_customer,['route' => ['sys-customers.update',$sys_customer->id],'method' => 'PUT','class' => 'form-horizontal','role' => 'form','id' => 'form']) !!}
                            {!! Form::hidden('domain', old('domain')) !!}
                            <div class="row">
                                <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('name', __('system/sys_customer.entry_name') . ' <span class="required">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_name'),'required','autofocus']) !!}
                                        @if ($errors->has('name'))
                                            <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ ($errors->has('record') || $errors->has('fqdn')) ? ' has-error' : '' }} hidden">
                                    {!! html_entity_decode(Form::label('record', __('system/sys_customer.entry_record') . ' <span class="required">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <div class="input-group input-group-sm">
                                            {!! Form::text('record', old('record'), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_record')]) !!}
                                            <span class="input-group-addon">.{{config('app.tenant_base_url')}}</span>
                                        </div>
                                        @if ($errors->has('record'))
                                            <span class="help-block"><small>{{ $errors->first('record') }}</small></span>
                                        @endif
                                        @if ($errors->has('fqdn'))
                                            <span class="help-block"><small>{{ $errors->first('fqdn') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('taxid') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('taxid', __('system/sys_customer.entry_taxid') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('taxid', old('taxid'), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_taxid'),'required']) !!}
                                        @if ($errors->has('taxid'))
                                            <span class="help-block"><small>{{ $errors->first('taxid') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('name_user') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('name_user', __('system/sys_customer.entry_name_user') . ' <span class="required">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('name_user', old('name_user'), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_name_user'),'required','autofocus']) !!}
                                        @if ($errors->has('name_user'))
                                            <span class="help-block"><small>{{ $errors->first('name_user') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('email') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('email', __('system/sys_customer.entry_email') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::email('email', old('email'), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_email'),'required']) !!}
                                        @if ($errors->has('email'))
                                            <span class="help-block"><small>{{ $errors->first('email') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('phone') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('phone', __('system/sys_customer.entry_phone') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('phone', old('phone'), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_phone')]) !!}
                                        @if ($errors->has('phone'))
                                            <span class="help-block"><small>{{ $errors->first('phone') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                @if(Auth::user()->superadmin)
                                <div class="form-group form-group-sm{{ $errors->has('distributor_id') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('distributor_id', __('sales/customer_invoice.entry_distributor_id') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::select('distributor_id', $distributors,old('distributor_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        @if ($errors->has('distributor_id'))
                                            <span class="help-block"><small>{{ $errors->first('distributor_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                @endif
                                <div class="form-group form-group-sm">
                                    {!! Form::label('sort_order', __('system/sys_customer.entry_sort_order'), ['class' => 'col-md-3 col-xs-12 control-label']) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('sort_order', old('sort_order'), ['class' => 'form-control', 'placeholder' => __('system/sys_customer.entry_sort_order')]) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('status', __('system/sys_customer.entry_status') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('status', '1',(!empty(old('status',$sys_customer->status)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="ln_solid"></div>
                                <div class="">
                                    <div class="col-md-6 col-xs-12 col-md-offset-3 footer-form">
                                        {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                        &nbsp;&nbsp;&nbsp;
                                        <a href="{{route('sys-customers.index',request()->except('page'))}}"
                                           class="btn btn-sm btn-default">@lang('general.button_discard')
                                        </a>
                                    </div>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {

        });

    </script>
@endsection