@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('system/sys_list_price_distributor.document_title'))
@section('css_specific')
    <link href="{{ asset('vendor/fancybox-master/dist/jquery.fancybox.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('system/sys_list_price_distributor.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('sys-list-price-distributors.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>{{ $sys_list_price_distributor->name }}</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                        {!! Form::model($sys_list_price_distributor,['route' => ['sys-list-price-distributors.update',$sys_list_price_distributor->id],'method' => 'PUT','class' => 'form-horizontal','role' => 'form','id' => 'form','files'=>true]) !!}
                        <!-- input hidden -->
                        <!-- /.input hidden -->
                            <div class="row">
                                <div class="form-group form-group-sm{{ $errors->has('shop_product_id') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('shop_product_id', __('system/sys_list_price_distributor.entry_shop_product_id') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::select('shop_product_id', $shop_products,old('shop_product_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required','disabled' => 'disabled']) !!}
                                        @if ($errors->has('shop_product_id'))
                                            <span class="help-block"><small>{{ $errors->first('shop_product_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                @if(Auth::user()->superadmin)
                                    <div class="form-group form-group-sm{{ $errors->has('distributor_id') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('distributor_id', __('system/sys_list_price_distributor.entry_distributor_id') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                        <div class="col-md-6 col-xs-12">
                                            {!! Form::select('distributor_id', $distributors,old('distributor_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                            @if ($errors->has('distributor_id'))
                                                <span class="help-block"><small>{{ $errors->first('distributor_id') }}</small></span>
                                            @endif
                                        </div>
                                    </div>
                                @endif
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('base_price', __('system/sys_list_price_distributor.entry_base_price') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('base_price', old('base_price',$sys_list_price_distributor->shopProduct->price), ['class' => 'form-control', 'placeholder' => __('system/sys_list_price_distributor.entry_base_price'),'','step' => 'any','readonly']) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('price') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('price', __('system/sys_list_price_distributor.entry_price') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('price', old('price'), ['class' => 'form-control', 'placeholder' => __('system/sys_list_price_distributor.entry_price'),'','step' => 'any']) !!}
                                        @if ($errors->has('price'))
                                            <span class="help-block"><small>{{ $errors->first('price') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! Form::label('sort_order', __('system/sys_list_price_distributor.entry_sort_order'), ['class' => 'col-md-3 col-xs-12 control-label']) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('sort_order', old('sort_order'), ['class' => 'form-control', 'placeholder' => __('system/sys_list_price_distributor.entry_sort_order')]) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('status', __('system/sys_list_price_distributor.entry_status') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('status', '1',(!empty(old('status',$sys_list_price_distributor->status)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="ln_solid"></div>
                                <div class="">
                                    <div class="col-md-6 col-xs-12 col-md-offset-3 footer-form">
                                        {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                        &nbsp;&nbsp;&nbsp;
                                        <a href="{{route('sys-list-price-distributors.index',request()->except('page'))}}"
                                           class="btn btn-sm btn-default">@lang('general.button_discard')
                                        </a>
                                    </div>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('vendor/fancybox-master/dist/jquery.fancybox.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            /* Configura select2 */
            $("#form .my-select2").select2({
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "auto",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
            });
        });

    </script>
@endsection
