@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('system/sys_sales_order.document_title'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('system/sys_sales_order.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            &nbsp;
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Filtros -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_content">
                            <div class="filter-data">
                                {!! Form::open(['route' => 'sys-sales-orders.index','method' => 'GET','class' => '','role' => 'form','id'=>'form']) !!}
                                <div class="row">
                                    <div class="col-md-2 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('filter_name', __('system/sys_sales_order.entry_name') , ['class' => 'control-label'])) !!}
                                            {!! Form::text('filter_name', request()->input('filter_name'), ['class' => 'form-control', 'placeholder' => __('system/sys_sales_order.entry_name'),'autofocus']) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-2 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('filter_date_from', __('general.text_date_from') . '', ['class' => 'control-label'])) !!}
                                            <div class="input-group input-group-sm">
                                                {!! Form::text('filter_date_from', request()->input('filter_date_from',\App\Helpers\Helper::date(Date::parse('first day of this month'))), ['class' => 'form-control', 'placeholder' => __('general.text_date_from'),'autocomplete'=>'off']) !!}
                                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('filter_date_to', __('general.text_date_to') . '', ['class' => 'control-label'])) !!}
                                            <div class="input-group input-group-sm">
                                                {!! Form::text('filter_date_to', request()->input('filter_date_to',\App\Helpers\Helper::date(Date::parse('last day of this month'))), ['class' => 'form-control', 'placeholder' => __('general.text_date_to'),'autocomplete'=>'off']) !!}
                                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            @php
                                                $tmp_sys_customers = [];
                                                if(!empty(request()->input('filter_sys_customer_id'))){
                                                    $tmp_sys_customers = \App\Models\System\SysCustomer::where('id',request()->input('filter_sys_customer_id'))->get()->pluck('text_select2','id');
                                                }
                                            @endphp
                                            {!! html_entity_decode(Form::label('filter_sys_customer_id', __('system/sys_sales_order.entry_sys_customer') , ['class' => 'control-label'])) !!}
                                            {!! Form::select('filter_sys_customer_id', $tmp_sys_customers,request()->input('filter_sys_customer_id'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-2 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('filter_status', __('system/sys_sales_order.entry_status') , ['class' => 'control-label'])) !!}
                                            {!! Form::select('filter_status', $list_status,request()->input('filter_status'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                        </div>
                                    </div>
                                </div>
                                <div class="row" style="margin-top: 10px;">
                                    <div class="col-md-8 col-xs-5 text-left">
                                        <div class="form-inline">
                                            <span>
                                                <span class="hidden-xs">@lang('general.text_item_per_page')</span>
                                                {!! Form::select('limit', $limits,request()->input('limit',setting('list_limit','100')), ['class' => 'form-control input-sm', 'placeholder' => __('general.text_select'),'onchange' => 'this.form.submit()']) !!}
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-xs-7 text-right footer-form">
                                        {!! Form::button(__('general.button_search'),['type' => 'submit', 'class' => 'btn btn-sm btn-default']) !!}
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Filtros -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_list')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <!-- Filtros -->

                            <!-- /Filtros -->
                            <!-- Datos -->
                            <div class="table-responsive table-data">
                                <table class="table table-striped table-hover table-condensed">
                                    <thead>
                                    <tr>
                                        <th class="text-center">@sortablelink('name',
                                            __('system/sys_sales_order.column_name'))
                                        </th>
                                        <th class="text-center">@sortablelink('created_at',
                                            __('system/sys_sales_order.column_created_at'))
                                        </th>
                                        <th class="text-center">@sortablelink('payment_platform',
                                            __('system/sys_sales_order.column_payment_platform'))
                                        </th>
                                        <th class="text-left">@sortablelink('sysCustomer.name',
                                            __('system/sys_sales_order.column_sys_customer'))
                                        </th>
                                        <th class="text-center">@sortablelink('taxid',
                                            __('system/sys_sales_order.column_taxid'))
                                        </th>
                                        <th class="text-center">@sortablelink('sys_customer_folio',
                                            __('system/sys_sales_order.column_sys_customer_folio'))
                                        </th>
                                        <th class="text-left">@sortablelink('product',
                                            __('system/sys_sales_order.column_product'))
                                        </th>
                                        <th class="text-center">@sortablelink('quantity_folio',
                                            __('system/sys_sales_order.column_quantity_folio'))
                                        </th>
                                        <th class="text-center">@sortablelink('currency.name',
                                            __('system/sys_sales_order.column_currency'))
                                        </th>
                                        <th class="text-center">@sortablelink('amount_total',
                                            __('system/sys_sales_order.column_amount_total'))
                                        </th>
                                        <th class="text-center">@sortablelink('activation_date',
                                            __('system/sys_sales_order.column_activation_date'))
                                        </th>
                                        <th class="text-center">@sortablelink('status',
                                            __('system/sys_sales_order.column_status'))
                                        </th>
                                        <th class="text-center" width="8%">@lang('general.column_actions')</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($results as $result)
                                        <tr class="{{ (!$result->status == \App\Models\System\SysSalesOrder::CANCELED ? 'text-muted' : '') }}">
                                            <td class="text-center">
                                                {{$result->name}}
                                            </td>
                                            <td class="text-center">{{ \App\Helpers\Helper::convertSqlToDateTime($result->created_at) }}</td>
                                            <td class="text-center">
                                                {{$result->payment_platform_name}}
                                            </td>
                                            <td class="text-left">
                                                {{$result->sysCustomer->name ?? ''}}
                                                @if (!empty($result->sysCustomer->distributor))
                                                    <small><br/><b>@lang('system/sys_sales_order.text_distributor'):</b> {{$result->sysCustomer->distributor->name ?? ''}}</small>
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                {{$result->sysCustomer->taxid ?? ''}}
                                            </td>
                                            <td class="text-center">
                                                {{$result->sys_customer_folio}}
                                            </td>
                                            <td class="text-left">
                                                {{$result->product}}
                                            </td>
                                            <td class="text-center">{{$result->quantity_folio}}</td>
                                            <td class="text-center">{{$result->currency->code ?? ''}}</td>
                                            <td class="text-right">{{ money($result->amount_total,$result->currency->code,true) }}</td>
                                            <td class="text-center">{{ $result->activation_date ? \App\Helpers\Helper::convertSqlToDateTime($result->activation_date) : '' }}</td>
                                            <td class="text-center">
                                                {!! \App\Helpers\SystemHelper::statusSalesOrderHtml($result->status) !!}
                                            </td>
                                            <!-- Acciones -->
                                            <td class="text-center nowrap">
                                                <div class="btn-group btn-group-xs text-center text-nowrap" role="group">
                                                    @if((int) $result->status == \App\Models\System\SysSalesOrder::PER_ACTIVE && (Auth::user()->superadmin || (Auth::user()->distributor && Auth::user()->id == $result->created_uid && $result->payment_platform_name == __('base/folio.text_folio_assignments'))))
                                                        <a href="{{route('sys-sales-orders/active-folios',['id' => $result->id])}}" class="btn btn-xs btn-primary">
                                                            @lang('general.button_active_folios')
                                                        </a>
                                                    @endif
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="13" class="text-center">@lang('general.text_no_results')</td>
                                        </tr>
                                    @endif
                                    </tbody>
                                </table>
                            </div>
                            <!-- /Datos -->
                            <div class="ln_solid"></div>
                            <!-- Pie de pagina -->
                            <div class="row">
                                @if($results->total() > 0)
                                    <div class="col-md-5 col-xs-12 text-left hidden-xs">
                                    <span class="btn btn-sm btn-default">{{ $results->firstItem() }}
                                        - {{ $results->lastItem() }} @lang('general.text_of') {{ $results->total() }}</span>
                                    </div>
                                    <div class="col-md-7 col-xs-12 text-right">
                                        {{ $results->appends(request()->except('page'))->links() }}
                                    </div>
                                @endif
                            </div>
                            <!-- /Pie de pagina -->
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {

            /*Configura datepicker*/
            moment.locale("{{ substr(app()->getLocale(),0,2) }}");
            $("#form input[name='filter_date_from']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false
            }, function (chosen_date) {
                $("#form input[name='filter_date_from']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });
            $("#form input[name='filter_date_to']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false,
            }, function (chosen_date) {
                $("#form input[name='filter_date_to']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });

            /* Configura select2 para buscar cliente*/
            $("#form select[name='filter_sys_customer_id']").select2({
                ajax: {
                    url: "{{route('sys-customers/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                placeholder: "@lang('general.text_all')",
                theme: "bootstrap",
                width: "auto",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 3
            });
        });

    </script>
@endsection
