@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | Logs')
@section('css_specific')

@endsection
@section('css')
    <link href="{{ asset('gentelella/plugins/datatables.net-bs/css/dataTables.bootstrap.min.css') }}" rel="stylesheet"/>
    <link href="{{ asset('gentelella/plugins/datatables.net-buttons-bs/css/buttons.bootstrap.min.css') }}" rel="stylesheet"/>
    <link href="{{ asset('gentelella/plugins/datatables.net-fixedheader-bs/css/fixedHeader.bootstrap.min.css') }}" rel="stylesheet"/>
    <link href="{{ asset('gentelella/plugins/datatables.net-responsive-bs/css/responsive.bootstrap.min.css') }}" rel="stylesheet"/>
    <link href="{{ asset('gentelella/plugins/datatables.net-scroller-bs/css/scroller.bootstrap.min.css') }}" rel="stylesheet"/>
@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>Logs</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('home')}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if (!$errors->isEmpty())
                    <div class="alert alert-danger alert-dismissable alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        {{ __('general.error_form') }}
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>Logs</h2>
                            <div class="clearfix"></div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12">
                                    <div class="list-group div-scroll">
                                        @foreach($folders as $folder)
                                            <div class="list-group-item">
                                                <a href="?f={{ \Illuminate\Support\Facades\Crypt::encrypt($folder) }}">
                                                    <span class="fa fa-folder"></span> {{$folder}}
                                                </a>
                                                @if ($current_folder == $folder)
                                                    <div class="list-group folder">
                                                        @foreach($folder_files as $file)
                                                            <a href="?l={{ \Illuminate\Support\Facades\Crypt::encrypt($file) }}&f={{ \Illuminate\Support\Facades\Crypt::encrypt($folder) }}"
                                                               class="list-group-item @if ($current_file == $file) llv-active @endif">
                                                                {{$file}}
                                                            </a>
                                                        @endforeach
                                                    </div>
                                                @endif
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                                <div class="col-md-12 col-xs-12">
                                    @foreach($files as $file)
                                        <a href="?l={{ \Illuminate\Support\Facades\Crypt::encrypt($file) }}"
                                           class="btn btn-sm btn-default @if ($current_file == $file) btn-success @endif">
                                            {{$file}}
                                        </a>
                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    @endforeach
                                </div>
                            </div>
                        </div>
                        <div class="x_content">
                            <div class=" table-container">
                                <table class="table table-striped table-condensed table-hover" id="table-log"
                                       data-ordering-index="{{ $standardFormat ? 2 : 0 }}" data-plugin-options='{"searchPlaceholder": "Buscar..."}' width="100%">
                                    <thead>
                                    <tr>
                                        @if ($standardFormat)
                                            <th class="text-center" width="8%">Nivel</th>
                                            <th class="text-center" width="8%">Contexto</th>
                                            <th class="text-center" width="10%">Fecha</th>
                                        @else
                                            <th class="text-center"># de línea</th>
                                        @endif
                                        <th class="text-left">Descripción</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @if ($logs === null)
                                        <tr>
                                            <td colspan="5" class="text-center">El archivo es mayor a 50M, tienes que descargarlo</td>
                                        </tr>
                                    @else
                                        @foreach($logs as $key => $log)
                                            <tr data-display="stack{{{$key}}}">
                                                @if ($standardFormat)
                                                    <td class="nowrap text-center text-{{{$log['level_class']}}}">
                                                        <i class="fa fa-{{{$log['level_img']}}}" aria-hidden="true"></i>&nbsp;&nbsp;{{$log['level']}}
                                                    </td>
                                                    <td class="text text-center">{{$log['context']}}</td>
                                                @endif
                                                <td class="date text-center">{{{$log['date']}}}</td>
                                                <td class="text">
                                                    @if ($log['stack'])
                                                        <a type="button" class="pull-right btn btn-info btn-sm mb-2 ml-2" data-display="stack{{{$key}}}">
                                                            <i class="fa fa-search"></i>
                                                        </a>
                                                    @endif
                                                    {{{$log['text']}}}
                                                    @if (isset($log['in_file']))
                                                        <br/>{{{$log['in_file']}}}
                                                    @endif
                                                    @if ($log['stack'])
                                                        <div class="stack" id="stack{{{$key}}}"
                                                             style="display: none; white-space: pre-wrap;">{{{ trim($log['stack']) }}}
                                                        </div>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                    </tbody>
                                </table>
                            </div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12">
                                    @if($current_file)
                                        <a href="?dl={{ \Illuminate\Support\Facades\Crypt::encrypt($current_folder ? $current_folder . "/" . $current_file : $current_file) }}{{ ($current_folder) ? '&f=' . \Illuminate\Support\Facades\Crypt::encrypt($current_folder) : '' }}"
                                           class="btn btn-sm btn-default">
                                            <i class="fa fa-download"></i> Descargar archivo
                                        </a>
                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        <a id="clean-log"
                                           href="?clean={{ \Illuminate\Support\Facades\Crypt::encrypt($current_folder ? $current_folder . "/" . $current_file : $current_file) }}{{ ($current_folder) ? '&f=' . \Illuminate\Support\Facades\Crypt::encrypt($current_folder) : '' }}"
                                           class="btn btn-sm btn-default">
                                            <i class="fa fa-refresh"></i> Limpiar archivo
                                        </a>
                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        <a id="delete-log"
                                           href="?del={{ \Illuminate\Support\Facades\Crypt::encrypt($current_folder ? $current_folder . "/" . $current_file : $current_file) }}{{ ($current_folder) ? '&f=' . \Illuminate\Support\Facades\Crypt::encrypt($current_folder) : '' }}"
                                           class="btn btn-sm btn-default">
                                            <i class="fa fa-trash-o"></i> Eliminar archivo
                                        </a>
                                        @if(count($files) > 1)
                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                            <a id="delete-all-log"
                                               href="?delall=true{{ ($current_folder) ? '&f=' . \Illuminate\Support\Facades\Crypt::encrypt($current_folder) : '' }}"
                                               class="btn btn-sm btn-default">
                                                <i class="fa fa-trash-o"></i> Eliminar todos los archivos
                                            </a>
                                        @endif
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection
@section('scripts_specific')

    <script src="{{ asset('gentelella/plugins/datatables.net/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/datatables.net-bs/js/dataTables.bootstrap.min.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/datatables.net-buttons/js/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/datatables.net-buttons-bs/js/buttons.bootstrap.min.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/datatables.net-buttons/js/buttons.flash.min.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/datatables.net-buttons/js/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/datatables.net-buttons/js/buttons.print.min.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/datatables.net-keytable/js/dataTables.keyTable.min.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/datatables.net-responsive/js/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/datatables.net-responsive-bs/js/responsive.bootstrap.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/datatables.net-scroller/js/dataTables.scroller.min.js') }}"></script>

@endsection
@section('scripts')
    <script>
        $(document).ready(function () {
            $('.table-container tr').on('click', function () {
                $('#' + $(this).data('display')).toggle();
            });
            $('#table-log').DataTable({
                "order": [$('#table-log').data('orderingIndex'), 'desc'],
                "stateSave": true,
                "stateSaveCallback": function (settings, data) {
                    window.localStorage.setItem("datatable", JSON.stringify(data));
                },
                "stateLoadCallback": function (settings) {
                    var data = JSON.parse(window.localStorage.getItem("datatable"));
                    if (data) data.start = 0;
                    return data;
                },
                "language": {
                    "lengthMenu": "Registros por página _MENU_",
                    "info": "_START_ - _END_ de _TOTAL_",
                    "infoEmpty": "No se encontraron registros",
                    "sZeroRecords": "No se encontraron registros",
                    "emptyTable": "No hay información",
                    "infoFiltered": "(Filtrado de _MAX_ total entradas)",
                    "infoPostFix": "",
                    "thousands": ",",
                    "loadingRecords": "Cargando...",
                    "processing": "Procesando...",
                    "search": "Buscar",
                    "paginate": {
                        "first": "Primero",
                        "last": "Último",
                        "next": "Siguiente",
                        "previous": "Anterior"
                    },
                }
            });
            //Fix style
            $(".dataTables_length select").addClass("input-sm");
            $(".dataTables_filter input").addClass("input-sm");
            $(".dataTables_paginate ul").addClass("pagination-sm");
            $("#delete-log, #clean-log, #delete-all-log").click(function () {
                return confirm("¿ Está usted seguro ?");
            });
        });
    </script>

@endsection
