@component('mail::message')
![logo]({{ asset('img/logo/factura-16-logo-horizontal.png') }})

{{-- Greeting --}}
@if (! empty($greeting))
# {{ $greeting }}
@else
@if ($level == 'error')
# @lang('Whoops!')
@else
# @lang('Hello!')
@endif
@endif

{{-- Intro Lines --}}
@foreach ($introLines as $line)
<p style='text-align: justify;'>{{ $line }}</p>

@endforeach

{{-- Action Button --}}
@isset($actionText)
<?php
    switch ($level) {
        case 'success':
            $color = 'green';
            break;
        case 'error':
            $color = 'red';
            break;
        default:
            $color = 'blue';
    }
?>
@component('mail::button', ['url' => $actionUrl, 'color' => $color])
{{ $actionText }}
@endcomponent
@endisset

{{-- Outro Lines --}}
@foreach ($outroLines as $line)
<p style='text-align: justify;'>{{ $line }}</p>

@endforeach

{{-- Subcopy --}}
@isset($actionText)
@component('mail::subcopy')
{{-- Salutation --}}
@if (! empty($salutation))
    {{ $salutation }}
@else
    @lang('Saludos'),<br>{{ config('app.name') }}
@endif

@lang(
    "Si tienes problemas para hacer clic en el \":actionText\" botón, copia y pega esta URL\n".
    'en tu navegador: ',
    [
        'actionText' => $actionText
    ]
)
[{{ $actionUrl }}]({!! $actionUrl !!})
@endcomponent
@endisset
@endcomponent
