<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Auth;

//Auth::routes();

//Remplazo para eliminar la de registro
// Authentication Routes...
$this->get('login', 'Auth\LoginController@showLoginForm')->name('login');
$this->post('login', 'Auth\LoginController@login');
$this->post('logout', 'Auth\LoginController@logout')->name('logout');

//$this->get('login-iframe', 'Auth\LoginController@showLoginFormIframe')->name('login-iframe');
$this->get('login-iframe', function () {
    return view('auth.login_iframe');
})->name('login-iframe');

// Registration Routes...
if(config('app.enabled_register_tenant')){
    $this->get('register', 'Auth\RegisterController@showRegistrationForm')->name('register');
    $this->post('register', 'Auth\RegisterController@register');
}

// Password Reset Routes...
$this->get('password/reset', 'Auth\ForgotPasswordController@showLinkRequestForm')->name('password.request');
$this->post('password/email', 'Auth\ForgotPasswordController@sendResetLinkEmail')->name('password.email');
$this->get('password/reset/{token}', 'Auth\ResetPasswordController@showResetForm')->name('password.reset');
$this->post('password/reset', 'Auth\ResetPasswordController@reset');

Route::get('users/{user}/{token}/confirm', 'Auth\RegisterController@confirm')->name('confirm');

Route::get('/', function () {
    return redirect('/login');
});

Route::group(['middleware' => ['auth']], function () {

    //Logs
    Route::get('logs', '\Rap2hpoutre\LaravelLogViewer\LogViewerController@index')->name('logs');

    //Home
    Route::get('/home', 'HomeController@index')->name('home');
    Route::get('/home/get-data-chart-dashboard', 'HomeController@getDataChartDashboard')->name('home/get-data-chart-dashboard');
    Route::get('/home/get-data-chart-dashboard-sys-sales-orders', 'HomeController@getDataChartDashboardSysSalesOrders')->name('home/get-data-chart-dashboard-sys-sales-orders');
    Route::get('/instruction-migration', 'HomeController@instructionMigration')->name('instruction-migration');

    //Imagenes
    Route::get('/app-images/{path}/{dir}/{attachment}', function ($path, $dir, $attachment) {
        $file = \App\Helpers\Helper::setDirectory($path .'/'.$dir,\App\Helpers\Helper::firstCompany()->id) . '/' . $attachment;
        $file2 = 'images-users/' . $path .'/'.$dir . '/' . $attachment;
        if (\Storage::exists($file)) {
            return \Intervention\Image\Facades\Image::make(\Storage::path($file))->response();
        } else if (\Storage::exists($file2)) {
            return \Intervention\Image\Facades\Image::make(\Storage::path($file2))->response();
        } else {
            return \Intervention\Image\Facades\Image::make('img/no_imagen_175x175.png')->response();
        }
    });

    //Imagenes para empresas
    Route::get('/app-images-company/{company_id}/{path}/{dir}/{attachment}', function ($company_id, $path, $dir, $attachment) {
        $file = \App\Helpers\Helper::setDirectory($path .'/'.$dir,$company_id) . '/' . $attachment;
        if (\Storage::exists($file)) {
            return \Intervention\Image\Facades\Image::make(\Storage::path($file))->response();
        } else {
            return \Intervention\Image\Facades\Image::make('img/no_imagen_175x175.png')->response();
        }
    });

    //Sistema
    Route::prefix('system')->group(function () {
        Route::get('sys-customers/{sys_customer}/send-sys-customer-access-link-email', 'System\SysCustomerController@sendSysCustomerAccessLinkEmail')->name('sys-customers/send-sys-customer-access-link-email');
        Route::get('sys-customers/autocomplete', 'System\SysCustomerController@autocomplete')->name('sys-customers/autocomplete');
        Route::get('sys-customers/modal-search', 'System\SysCustomerController@modalSearch')->name('sys-customers/modal-search');
        Route::get('sys-customers/modal-user-search', 'System\SysCustomerController@modalUserSearch')->name('sys-customers/modal-user-search');
        Route::post('sys-customers/search', 'System\SysCustomerController@search')->name('sys-customers/search');
        Route::resource('sys-customers', 'System\SysCustomerController');
        Route::get('sys-sales-orders/{sys_sales_order}/active-folios', 'System\SysSalesOrderController@activeFolios')->name('sys-sales-orders/active-folios');
        Route::resource('sys-sales-orders', 'System\SysSalesOrderController');
        Route::resource('sys-list-price-distributors', 'System\SysListPriceDistributorController');
    });

    //Base
    Route::prefix('base')->group(function () {
        Route::resource('announcements', 'Base\AnnouncementController');
        Route::get('companies/modal-user-search', 'Base\CompanyController@modalUserSearch')->name('companies/modal-user-search');
        Route::post('companies/search', 'Base\CompanyController@search')->name('companies/search');
        Route::resource('companies', 'Base\CompanyController');
        Route::get('branch-offices/get-branch-office', 'Base\BranchOfficeController@getBranchOffice')->name('branch-offices/get-branch-office');
        Route::resource('branch-offices', 'Base\BranchOfficeController');
        Route::get('document-types/modal-create-per-branch-office', 'Base\DocumentTypeController@modalCreatePerBranchOffice')->name('document-types/modal-create-per-branch-office');
        Route::post('document-types/create-per-branch-office', 'Base\DocumentTypeController@createPerBranchOffice')->name('document-types/create-per-branch-office');
        Route::resource('document-types', 'Base\DocumentTypeController');
        Route::get('folios/{folio}/active-folios', 'Base\FolioController@activeFolios')->name('folios/active-folios');
        Route::resource('folios', 'Base\FolioController');
        Route::resource('pacs', 'Base\PacController');
        Route::get('installation/step-1', 'Base\InstallationController@formStep1')->name('installation/step-1');
        Route::put('installation/step-1/{company}', 'Base\InstallationController@step1')->name('installation/step-1');
        Route::get('installation/step-2', 'Base\InstallationController@formStep2')->name('installation/step-2');
        Route::get('installation/skip-step-2', 'Base\InstallationController@skipStep2')->name('installation/skip-step-2');
        Route::put('installation/step-2/{company}', 'Base\InstallationController@step2')->name('installation/step-2');
        Route::get('installation/step-3', 'Base\InstallationController@formStep3')->name('installation/step-3');
        Route::put('installation/step-3/{branch_office}', 'Base\InstallationController@step3')->name('installation/step-3');
        Route::get('installation/step-4', 'Base\InstallationController@formStep4')->name('installation/step-4');
        Route::post('installation/step-4', 'Base\InstallationController@step4')->name('installation/step-4');
        Route::get('settings', 'Base\SettingController@edit')->name('settings');
        Route::put('settings', 'Base\SettingController@update')->name('settings');
        Route::get('employees/get-employee', 'Base\EmployeeController@getEmployee')->name('employees/get-employee');
        Route::get('employees/autocomplete', 'Base\EmployeeController@autocomplete')->name('employees/autocomplete');
        Route::get('employees/modal-search', 'Base\EmployeeController@modalSearch')->name('employees/modal-search');
        Route::post('employees/search', 'Base\EmployeeController@search')->name('employees/search');
        Route::get('employees/export-to-excel', 'Base\EmployeeController@exportToExcel')->name('employees/export-to-excel');
        Route::get('employees/import', 'Base\EmployeeController@createImport')->name('employees/import');
        Route::post('employees/download-template-import', 'Base\EmployeeController@downloadTemplateImport')->name('employees/download-template-import');
        Route::post('employees/before', 'Base\EmployeeController@beforeImport')->name('employees/before-import');
        Route::post('employees/import', 'Base\EmployeeController@storeImport')->name('employees/import');
        Route::resource('employees', 'Base\EmployeeController');
        Route::get('employee-payrolls/{employee_payroll}/mark-sent', 'Base\EmployeePayrollController@markSent')->name('employee-payrolls/mark-sent');
        Route::get('employee-payrolls/{employee_payroll}/print', 'Base\EmployeePayrollController@print')->name('employee-payrolls/print');
        Route::get('employee-payrolls/{employee_payroll}/download-xml', 'Base\EmployeePayrollController@downloadXml')->name('employee-payrolls/download-xml');
        Route::get('employee-payrolls/{employee_payroll}/download-pdf', 'Base\EmployeePayrollController@downloadPdf')->name('employee-payrolls/download-pdf');
        Route::get('employee-payrolls/{employee_payroll}/modal-send-mail', 'Base\EmployeePayrollController@modalSendMail')->name('employee-payrolls/modal-send-mail');
        Route::post('employee-payrolls/{employee_payroll}/send-mail', 'Base\EmployeePayrollController@sendMail')->name('employee-payrolls/send-mail');
        Route::match(['put', 'post'],'employee-payrolls/total-lines', 'Base\EmployeePayrollController@totalLines')->name('employee-payrolls/total-lines');
        Route::get('employee-payrolls/get-employee-payroll', 'Base\EmployeePayrollController@getEmployeePayroll')->name('employee-payrolls/get-employee-payroll');
        Route::get('employee-payrolls/autocomplete-cfdi', 'Base\EmployeePayrollController@autocompleteCfdi')->name('employee-payrolls/autocomplete-cfdi');
        Route::get('employee-payrolls/{employee_payroll}/modal-cancel', 'Base\EmployeePayrollController@modalCancel')->name('employee-payrolls/modal-cancel');
        Route::get('employee-payrolls/export-to-excel', 'Base\EmployeePayrollController@exportToExcel')->name('employee-payrolls/export-to-excel');
        Route::get('employee-payrolls/{employee_payroll}/stamp', 'Base\EmployeePayrollController@stamp')->name('employee-payrolls/stamp');
        Route::get('employee-payrolls/{employee_payroll}/modal-status-sat', 'Base\EmployeePayrollController@modalStatusSat')->name('employee-payrolls/modal-status-sat');
        Route::get('employee-payrolls/import', 'Base\EmployeePayrollController@createImport')->name('employee-payrolls/import');
        Route::post('employee-payrolls/download-template-import', 'Base\EmployeePayrollController@downloadTemplateImport')->name('employee-payrolls/download-template-import');
        Route::post('employee-payrolls/before', 'Base\EmployeePayrollController@beforeImport')->name('employee-payrolls/before-import');
        Route::post('employee-payrolls/import', 'Base\EmployeePayrollController@storeImport')->name('employee-payrolls/import');
        Route::post('employee-payrolls/get-payment-days', 'Base\EmployeePayrollController@getPaymentDays')->name('employee-payrolls/get-payment-days');
        Route::resource('employee-payrolls', 'Base\EmployeePayrollController');
        Route::resource('employee-categories', 'Base\EmployeeCategoryController');
        Route::get('payrolls/{payroll}/download-xml-pdf', 'Base\PayrollController@downloadXmlPdf')->name('payrolls/download-xml-pdf');
        Route::get('payrolls/{payroll}/modal-cancel', 'Base\PayrollController@modalCancel')->name('payrolls/modal-cancel');
        Route::get('payrolls/{payroll}/stamp', 'Base\PayrollController@stamp')->name('payrolls/stamp');
        Route::get('payrolls/import-assimilated', 'Base\PayrollController@createImportAssimilated')->name('payrolls/import-assimilated');
        Route::post('payrolls/download-template-import-assimilated', 'Base\PayrollController@downloadTemplateImportAssimilated')->name('payrolls/download-template-import-assimilated');
        Route::post('payrolls/before-assimilated', 'Base\PayrollController@beforeImportAssimilated')->name('payrolls/before-import-assimilated');
        Route::post('payrolls/import-assimilated', 'Base\PayrollController@storeImportAssimilated')->name('payrolls/import-assimilated');
        Route::post('payrolls/get-payment-days', 'Base\EmployeePayrollController@getPaymentDays')->name('payrolls/get-payment-days');
        Route::get('payrolls/import-payrolls', 'Base\PayrollController@createImportPayrolls')->name('payrolls/import-payrolls');
        Route::post('payrolls/download-template-import-payrolls', 'Base\PayrollController@downloadTemplateImportPayrolls')->name('payrolls/download-template-import-payrolls');
        Route::post('payrolls/before-payrolls', 'Base\PayrollController@beforeImportPayrolls')->name('payrolls/before-import-payrolls');
        Route::post('payrolls/import-payrolls', 'Base\PayrollController@storeImportPayrolls')->name('payrolls/import-payrolls');

        Route::resource('payrolls', 'Base\PayrollController');
        Route::get('tax-mailbox/accept-reject/{uuid}/{type}', 'Base\TaxMailboxController@acceptReject')->name('tax-mailbox/accept-reject');
        Route::get('tax-mailbox', 'Base\TaxMailboxController@index')->name('tax-mailbox');
        Route::post('cfdi-downloads/delete-selected', 'Base\CfdiDownloadController@deleteSelected')->name('cfdi-downloads/delete-selected');
        Route::get('cfdi-downloads/reset-sat-login', 'Base\CfdiDownloadController@resetSatLogin')->name('cfdi-downloads/reset-sat-login');
        Route::get('cfdi-downloads/create-sat-login', 'Base\CfdiDownloadController@createSatLogin')->name('cfdi-downloads/create-sat-login');
        Route::post('cfdi-downloads/sat-login', 'Base\CfdiDownloadController@satLogin')->name('cfdi-downloads/sat-login');
        Route::get('cfdi-downloads/create-cfdi-download', 'Base\CfdiDownloadController@createCfdiDownload')->name('cfdi-downloads/create-cfdi-download');
        Route::post('cfdi-downloads/cfdi-download-request', 'Base\CfdiDownloadController@cfdiDownloadRequest')->name('cfdi-downloads/cfdi-download-request');
        Route::post('cfdi-downloads/cfdi-download', 'Base\CfdiDownloadController@cfdiDownload')->name('cfdi-downloads/cfdi-download');
        Route::get('cfdi-downloads/create-cfdi-download-fiel', 'Base\CfdiDownloadController@createCfdiDownloadFiel')->name('cfdi-downloads/create-cfdi-download-fiel');
        Route::post('cfdi-downloads/cfdi-download-fiel', 'Base\CfdiDownloadController@cfdiDownloadFiel')->name('cfdi-downloads/cfdi-download-fiel');
        Route::get('cfdi-downloads/{cfdi_download_request}/request-verify', 'Base\CfdiDownloadController@requestVerify')->name('cfdi-downloads/request-verify');
        Route::get('cfdi-downloads/{cfdi_download_request}/request-download', 'Base\CfdiDownloadController@requestDownload')->name('cfdi-downloads/request-download');
        Route::get('cfdi-downloads/{cfdi_download}/download-xml', 'Base\CfdiDownloadController@downloadXml')->name('cfdi-downloads/download-xml');
        Route::get('cfdi-downloads/{cfdi_download}/download-pdf', 'Base\CfdiDownloadController@downloadPdf')->name('cfdi-downloads/download-pdf');
        Route::get('cfdi-downloads/{cfdi_download}/download-acuse', 'Base\CfdiDownloadController@downloadAcuse')->name('cfdi-downloads/download-acuse');
        Route::get('cfdi-downloads/export-to-excel', 'Base\CfdiDownloadController@exportToExcel')->name('cfdi-downloads/export-to-excel');
        Route::get('cfdi-downloads/{cfdi_download}/modal-edit', 'Base\CfdiDownloadController@modalEdit')->name('cfdi-downloads/modal-edit');
        Route::post('cfdi-downloads/store-expense', 'Base\CfdiDownloadController@storeExpense')->name('cfdi-downloads/store-expense');
        Route::get('cfdi-downloads/modal-create-expense', 'Base\CfdiDownloadController@modalCreateExpense')->name('cfdi-downloads/modal-create-expense');
        Route::post('cfdi-downloads/store-deposit', 'Base\CfdiDownloadController@storeDeposit')->name('cfdi-downloads/store-deposit');
        Route::get('cfdi-downloads/modal-create-deposit', 'Base\CfdiDownloadController@modalCreateDeposit')->name('cfdi-downloads/modal-create-deposit');
        Route::put('cfdi-downloads/store-payment', 'Base\CfdiDownloadController@storePayment')->name('cfdi-downloads/store-payment');
        Route::get('cfdi-downloads/{cfdi_download}/modal-payments', 'Base\CfdiDownloadController@modalPayments')->name('cfdi-downloads/modal-payments');
        Route::get('cfdi-downloads/payments', 'Base\CfdiDownloadController@payments')->name('cfdi-downloads/payments');
        Route::get('cfdi-downloads/bank-reconciliations', 'Base\CfdiDownloadController@bankReconciliations')->name('cfdi-downloads/bank-reconciliations');
        Route::get('cfdi-downloads/destroy-payment', 'Base\CfdiDownloadController@destroyPayment')->name('cfdi-downloads/destroy-payment');
        Route::get('cfdi-downloads/modal-edit-selected', 'Base\CfdiDownloadController@modalEditSelected')->name('cfdi-downloads/modal-edit-selected');
        Route::put('cfdi-downloads/update-selected', 'Base\CfdiDownloadController@updateSelected')->name('cfdi-downloads/update-selected');
        Route::get('cfdi-downloads/per-reconciliation', 'Base\CfdiDownloadController@perReconcilation')->name('cfdi-downloads/per-reconciliation');
        Route::resource('cfdi-downloads', 'Base\CfdiDownloadController');
        Route::get('diots/data-cfdi-downloads', 'Base\DiotController@dataCfdiDownload')->name('diots/data-cfdi-downloads');
        Route::get('diots/add-cfdi-downloads', 'Base\DiotController@addCfdiDownload')->name('diots/add-cfdi-downloads');
        Route::get('diots/{diot}/download-txt', 'Base\DiotController@downloadTxt')->name('diots/download-txt');
        Route::get('diots/{diot}/print', 'Base\DiotController@print')->name('diots/print');
        Route::resource('diots', 'Base\DiotController');
        Route::get('bank-reconciliations/download-template', 'Base\BankReconciliationController@downloadTemplate')->name('bank-reconciliations/download-template');
        Route::post('bank-reconciliations/bank-move-temp-template-import', 'Base\BankReconciliationController@bankMoveTempTemplateImport')->name('bank-reconciliations/bank-move-temp-template-import');
        Route::post('bank-reconciliations/bank-move-temp-manual-reconciled', 'Base\BankReconciliationController@bankMoveTempManualReconciled')->name('bank-reconciliations/bank-move-temp-manual-reconciled');
        Route::post('bank-reconciliations/bank-move-temp-manual-unreconciled', 'Base\BankReconciliationController@bankMoveTempManualUnreconciled')->name('bank-reconciliations/bank-move-temp-manual-unreconciled');
        Route::post('bank-reconciliations/bank-move-temp-auto-reconciled', 'Base\BankReconciliationController@bankMoveTempAutoReconciled')->name('bank-reconciliations/bank-move-temp-auto-reconciled');
        Route::get('bank-reconciliations/{bank_reconciliation}/print', 'Base\BankReconciliationController@print')->name('bank-reconciliations/print');
        Route::get('bank-reconciliations/export-to-excel', 'Base\BankReconciliationController@exportToExcel')->name('bank-reconciliations/export-to-excel');
        Route::resource('bank-reconciliations', 'Base\BankReconciliationController');
        Route::resource('black-list-sats', 'Base\BlackListSatController');
    });

    //Catalogos
    Route::prefix('catalogs')->group(function () {
        Route::get('products/get-product', 'Catalogs\ProductController@getProduct')->name('products/get-product');
        Route::get('products/autocomplete', 'Catalogs\ProductController@autocomplete')->name('products/autocomplete');
        Route::get('products/modal-search', 'Catalogs\ProductController@modalSearch')->name('products/modal-search');
        Route::post('products/search', 'Catalogs\ProductController@search')->name('products/search');
        Route::get('products/export-to-excel', 'Catalogs\ProductController@exportToExcel')->name('products/export-to-excel');
        Route::get('products/import', 'Catalogs\ProductController@createImport')->name('products/import');
        Route::post('products/download-template-import', 'Catalogs\ProductController@downloadTemplateImport')->name('products/download-template-import');
        Route::post('products/before', 'Catalogs\ProductController@beforeImport')->name('products/before-import');
        Route::post('products/import', 'Catalogs\ProductController@storeImport')->name('products/import');
        Route::resource('products', 'Catalogs\ProductController');
        Route::get('unit-measures/autocomplete', 'Catalogs\UnitMeasureController@autocomplete')->name('unit-measures/autocomplete');
        Route::get('unit-measures/modal-search', 'Catalogs\UnitMeasureController@modalSearch')->name('unit-measures/modal-search');
        Route::post('unit-measures/search', 'Catalogs\UnitMeasureController@search')->name('unit-measures/search');
        Route::resource('unit-measures', 'Catalogs\UnitMeasureController');
        Route::get('countries/get-states', 'Catalogs\CountryController@getStates')->name('countries/get-states');
        Route::resource('countries', 'Catalogs\CountryController');
        Route::get('states/get-cities', 'Catalogs\StateController@getCities')->name('states/get-cities');
        Route::resource('states', 'Catalogs\StateController');
        Route::resource('cities', 'Catalogs\CityController');
        Route::get('currencies/get-currency', 'Catalogs\CurrencyController@getCurrency')->name('currencies/get-currency');
        Route::resource('currencies', 'Catalogs\CurrencyController');
        Route::resource('payment-terms', 'Catalogs\PaymentTermController');
        Route::resource('taxes', 'Catalogs\TaxController');
        Route::resource('banks', 'Catalogs\BankController');
        Route::resource('cfdi-relations', 'Catalogs\CfdiRelationController');
        Route::resource('cfdi-types', 'Catalogs\CfdiTypeController');
        Route::get('sat-products/autocomplete', 'Catalogs\SatProductController@autocomplete')->name('sat-products/autocomplete');
        Route::get('sat-products/modal-search', 'Catalogs\SatProductController@modalSearch')->name('sat-products/modal-search');
        Route::post('sat-products/search', 'Catalogs\SatProductController@search')->name('sat-products/search');
        Route::resource('sat-products', 'Catalogs\SatProductController');
        Route::resource('payment-ways', 'Catalogs\PaymentWayController');
        Route::resource('payment-methods', 'Catalogs\PaymentMethodController');
        Route::resource('tax-regimens', 'Catalogs\TaxRegimenController');
        //Route::resource('cfdi-uses', 'Catalogs\CfdiUseController');
        Route::get('cfdi-uses', 'Catalogs\CfdiUseController@index')->name('cfdi-uses.index');
        Route::get('cfdi-uses/create', 'Catalogs\CfdiUseController@create')->name('cfdi-uses.create');
        Route::post('cfdi-uses', 'Catalogs\CfdiUseController@store')->name('cfdi-uses.store');
        Route::get('cfdi-uses/{cfdi_use}', 'Catalogs\CfdiUseController@show')->name('cfdi-uses.show');
        Route::get('cfdi-uses/{cfdi_use}/edit', 'Catalogs\CfdiUseController@edit')->name('cfdi-uses.edit');
        Route::put('cfdi-uses/{cfdi_use}', 'Catalogs\CfdiUseController@update')->name('cfdi-uses.update');
        Route::delete('cfdi-uses/{cfdi_use}', 'Catalogs\CfdiUseController@destroy')->name('cfdi-uses.destroy');
        Route::resource('iedu-nivel-educativos', 'Catalogs\IeduNivelEducativoController');
        Route::resource('pediments', 'Catalogs\PedimentController');
        Route::get('tariff-fractions/autocomplete', 'Catalogs\TariffFractionController@autocomplete')->name('tariff-fractions/autocomplete');
        Route::get('tariff-fractions/modal-search', 'Catalogs\TariffFractionController@modalSearch')->name('tariff-fractions/modal-search');
        Route::post('tariff-fractions/search', 'Catalogs\TariffFractionController@search')->name('tariff-fractions/search');
        Route::resource('tariff-fractions', 'Catalogs\TariffFractionController');
        Route::resource('incoterms', 'Catalogs\IncotermController');
        Route::resource('transfer-reasons', 'Catalogs\TransferReasonController');
        Route::resource('operation-types', 'Catalogs\OperationTypeController');
        Route::get('uom-customs/autocomplete', 'Catalogs\UomCustomController@autocomplete')->name('uom-customs/autocomplete');
        Route::get('uom-customs/modal-search', 'Catalogs\UomCustomController@modalSearch')->name('uom-customs/modal-search');
        Route::post('uom-customs/search', 'Catalogs\UomCustomController@search')->name('uom-customs/search');
        Route::resource('uom-customs', 'Catalogs\UomCustomController');
        Route::resource('postcodes', 'Catalogs\PostcodeController');
        Route::resource('source-resources', 'Catalogs\SourceResourceController');
        Route::resource('frequency-payments', 'Catalogs\FrequencyPaymentController');
        Route::resource('contract-types', 'Catalogs\ContractTypeController');
        Route::get('deductions/get-deduction', 'Catalogs\DeductionController@getDeduction')->name('deductions/get-deduction');
        Route::get('deductions/autocomplete', 'Catalogs\DeductionController@autocomplete')->name('deductions/autocomplete');
        Route::get('deductions/modal-search', 'Catalogs\DeductionController@modalSearch')->name('deductions/modal-search');
        Route::post('deductions/search', 'Catalogs\DeductionController@search')->name('deductions/search');
        Route::resource('deductions', 'Catalogs\DeductionController');
        Route::resource('overtimes-types', 'Catalogs\OvertimesTypeController');
        Route::get('disability-types/get-disability-type', 'Catalogs\DisabilityTypeController@getDisabilityType')->name('disability-types/get-disability-type');
        Route::get('disability-types/autocomplete', 'Catalogs\DisabilityTypeController@autocomplete')->name('disability-types/autocomplete');
        Route::get('disability-types/modal-search', 'Catalogs\DisabilityTypeController@modalSearch')->name('disability-types/modal-search');
        Route::post('disability-types/search', 'Catalogs\DisabilityTypeController@search')->name('disability-types/search');
        Route::resource('disability-types', 'Catalogs\DisabilityTypeController');
        Route::resource('workday-types', 'Catalogs\WorkdayTypeController');
        Route::resource('payroll-types', 'Catalogs\PayrollTypeController');
        Route::get('other-payment-types/get-other-payment-type', 'Catalogs\OtherPaymentTypeController@getOtherPaymentType')->name('other-payment-types/get-other-payment-type');
        Route::get('other-payment-types/autocomplete', 'Catalogs\OtherPaymentTypeController@autocomplete')->name('other-payment-types/autocomplete');
        Route::get('other-payment-types/modal-search', 'Catalogs\OtherPaymentTypeController@modalSearch')->name('other-payment-types/modal-search');
        Route::post('other-payment-types/search', 'Catalogs\OtherPaymentTypeController@search')->name('other-payment-types/search');
        Route::resource('other-payment-types', 'Catalogs\OtherPaymentTypeController');
        Route::get('perceptions/get-perception', 'Catalogs\PerceptionController@getPerception')->name('perceptions/get-perception');
        Route::get('perceptions/autocomplete', 'Catalogs\PerceptionController@autocomplete')->name('perceptions/autocomplete');
        Route::get('perceptions/modal-search', 'Catalogs\PerceptionController@modalSearch')->name('perceptions/modal-search');
        Route::post('perceptions/search', 'Catalogs\PerceptionController@search')->name('perceptions/search');
        Route::resource('perceptions', 'Catalogs\PerceptionController');
        Route::resource('recruitment-regimes', 'Catalogs\RecruitmentRegimeController');
        Route::resource('job-risk-classes', 'Catalogs\JobRiskClasseController')->parameters([
            'job-risk-classes' => 'job-risk-classe'
        ]);
        Route::resource('expense-types', 'Catalogs\ExpenseTypeController');
        Route::resource('projects', 'Catalogs\ProjectController');
        Route::resource('operational-types', 'Catalogs\OperationalTypeController');

        Route::resource('transport-types', 'Catalogs\TransportTypeController');
        Route::resource('station-types', 'Catalogs\StationTypeController');
        Route::get('stations/autocomplete', 'Catalogs\StationController@autocomplete')->name('stations/autocomplete');
        Route::resource('stations', 'Catalogs\StationController');
        Route::get('measure-packagings/autocomplete', 'Catalogs\MeasurePackagingController@autocomplete')->name('measure-packagings/autocomplete');
        Route::resource('measure-packagings', 'Catalogs\MeasurePackagingController');
        Route::get('dangerous-products/autocomplete', 'Catalogs\DangerousProductController@autocomplete')->name('dangerous-products/autocomplete');
        Route::resource('dangerous-products', 'Catalogs\DangerousProductController');
        Route::resource('packaging-types', 'Catalogs\PackagingTypeController');
        Route::resource('permit-types', 'Catalogs\PermitTypeController');
        Route::resource('setting-transports', 'Catalogs\SettingTransportController');
        Route::resource('trailer-types', 'Catalogs\TrailerTypeController');
        Route::resource('setting-maritimes', 'Catalogs\SettingMaritimeController');
        Route::resource('load-types', 'Catalogs\LoadTypeController');
        Route::resource('container-maritimes', 'Catalogs\ContainerMaritimeController');
        Route::resource('authorization-agents', 'Catalogs\AuthorizationAgentController');
        Route::resource('transport-aerials', 'Catalogs\TransportAerialController');
        Route::get('sat-product-stccs/autocomplete', 'Catalogs\SatProductStccController@autocomplete')->name('sat-product-stccs/autocomplete');
        Route::resource('sat-product-stccs', 'Catalogs\SatProductStccController');
        Route::resource('service-types', 'Catalogs\ServiceTypeController');
        Route::resource('rights-ways', 'Catalogs\RightsWayController');
        Route::resource('car-types', 'Catalogs\CarTypeController');
        Route::resource('container-types', 'Catalogs\ContainerTypeController');
        Route::resource('transport-parts', 'Catalogs\TransportPartController');
        Route::resource('transport-figures', 'Catalogs\TransportFigureController');
        Route::resource('traffic-types', 'Catalogs\TrafficTypeController');
    });

    //Ventas
    Route::prefix('shop')->group(function () {
        Route::get('shop', 'Shop\ShopController@index')->name('shop');
        Route::get('cart/checkout', 'Shop\CartController@checkout')->name('cart/checkout');
        Route::post('cart/process', 'Shop\CartController@process')->name('cart/process');
        Route::get('cart/{folio}/success', 'Shop\CartController@success')->name('cart/success');
        Route::get('cart/{folio}/print', 'Shop\CartController@print')->name('cart/print');
        Route::resource('cart', 'Shop\CartController');
        Route::get('shop-products/get-shop-product', 'Shop\ShopProductController@getShopProduct')->name('shop-products/get-shop-product');
        Route::resource('shop-products', 'Shop\ShopProductController');
    });

    //Ventas
    Route::prefix('sales')->group(function () {
        Route::resource('salespersons', 'Sales\SalespersonController');
        Route::get('customers/get-customer-bank-accounts', 'Sales\CustomerController@getCustomerBankAccounts')->name('customers/get-customer-bank-accounts');
        Route::get('customers/get-customer', 'Sales\CustomerController@getCustomer')->name('customers/get-customer');
        Route::get('customers/autocomplete', 'Sales\CustomerController@autocomplete')->name('customers/autocomplete');
        Route::get('customers/modal-search', 'Sales\CustomerController@modalSearch')->name('customers/modal-search');
        Route::post('customers/search', 'Sales\CustomerController@search')->name('customers/search');
        Route::get('customers/modal-create', 'Sales\CustomerController@modalCreate')->name('customers/modal-create');
        Route::get('customers/export-to-excel', 'Sales\CustomerController@exportToExcel')->name('customers/export-to-excel');
        Route::get('customers/import', 'Sales\CustomerController@createImport')->name('customers/import');
        Route::post('customers/download-template-import', 'Sales\CustomerController@downloadTemplateImport')->name('customers/download-template-import');
        Route::post('customers/before', 'Sales\CustomerController@beforeImport')->name('customers/before-import');
        Route::post('customers/import', 'Sales\CustomerController@storeImport')->name('customers/import');
        Route::resource('customers', 'Sales\CustomerController');

        Route::get('customer-quotations/{customer_quotation}/mark-open', 'Sales\CustomerQuotationController@markOpen')->name('customer-quotations/mark-open');
        Route::get('customer-quotations/{customer_quotation}/mark-sent', 'Sales\CustomerQuotationController@markSent')->name('customer-quotations/mark-sent');
        Route::get('customer-quotations/{customer_quotation}/mark-billed', 'Sales\CustomerQuotationController@markBilled')->name('customer-quotations/mark-billed');
        Route::get('customer-quotations/{customer_quotation}/print', 'Sales\CustomerQuotationController@print')->name('customer-quotations/print');
        Route::get('customer-quotations/{customer_quotation}/download-pdf', 'Sales\CustomerQuotationController@downloadPdf')->name('customer-quotations/download-pdf');
        Route::get('customer-quotations/{customer_quotation}/modal-send-mail', 'Sales\CustomerQuotationController@modalSendMail')->name('customer-quotations/modal-send-mail');
        Route::post('customer-quotations/{customer_quotation}/send-mail', 'Sales\CustomerQuotationController@sendMail')->name('customer-quotations/send-mail');
        Route::match(['put', 'post'],'customer-quotations/total-lines', 'Sales\CustomerQuotationController@totalLines')->name('customer-quotations/total-lines');
        Route::get('customer-quotations/get-customer-quotation', 'Sales\CustomerQuotationController@getCustomerQuotation')->name('customer-quotations/get-customer-quotation');
        Route::get('customer-quotations/{customer_quotation}/modal-cancel', 'Sales\CustomerQuotationController@modalCancel')->name('customer-quotations/modal-cancel');
        Route::get('customer-quotations/export-to-excel', 'Sales\CustomerQuotationController@exportToExcel')->name('customer-quotations/export-to-excel');
        Route::resource('customer-quotations', 'Sales\CustomerQuotationController');

        Route::get('customer-remissions/{customer_remission}/mark-open', 'Sales\CustomerRemissionController@markOpen')->name('customer-remissions/mark-open');
        Route::get('customer-remissions/{customer_remission}/mark-sent', 'Sales\CustomerRemissionController@markSent')->name('customer-remissions/mark-sent');
        Route::get('customer-remissions/{customer_remission}/mark-billed', 'Sales\CustomerRemissionController@markBilled')->name('customer-remissions/mark-billed');
        Route::get('customer-remissions/{customer_remission}/print', 'Sales\CustomerRemissionController@print')->name('customer-remissions/print');
        Route::get('customer-remissions/{customer_remission}/download-pdf', 'Sales\CustomerRemissionController@downloadPdf')->name('customer-remissions/download-pdf');
        Route::get('customer-remissions/{customer_remission}/modal-send-mail', 'Sales\CustomerRemissionController@modalSendMail')->name('customer-remissions/modal-send-mail');
        Route::post('customer-remissions/{customer_remission}/send-mail', 'Sales\CustomerRemissionController@sendMail')->name('customer-remissions/send-mail');
        Route::match(['put', 'post'],'customer-remissions/total-lines', 'Sales\CustomerRemissionController@totalLines')->name('customer-remissions/total-lines');
        Route::get('customer-remissions/get-customer-remission', 'Sales\CustomerRemissionController@getCustomerRemission')->name('customer-remissions/get-customer-remission');
        Route::get('customer-remissions/{customer_remission}/modal-cancel', 'Sales\CustomerRemissionController@modalCancel')->name('customer-remissions/modal-cancel');
        Route::get('customer-remissions/export-to-excel', 'Sales\CustomerRemissionController@exportToExcel')->name('customer-remissions/export-to-excel');
        Route::resource('customer-remissions', 'Sales\CustomerRemissionController');

        Route::post('customer-invoices/{customer_invoice}/addenda', 'Sales\CustomerInvoiceController@addenda')->name('customer-invoices/addenda');
        Route::get('customer-invoices/{customer_invoice}/modal-addenda', 'Sales\CustomerInvoiceController@modalAddenda')->name('customer-invoices/modal-addenda');
        Route::get('customer-invoices/{customer_invoice}/mark-open', 'Sales\CustomerInvoiceController@markOpen')->name('customer-invoices/mark-open');
        Route::get('customer-invoices/{customer_invoice}/mark-sent', 'Sales\CustomerInvoiceController@markSent')->name('customer-invoices/mark-sent');
        Route::get('customer-invoices/{customer_invoice}/mark-paid', 'Sales\CustomerInvoiceController@markPaid')->name('customer-invoices/mark-paid');
        Route::get('customer-invoices/{customer_invoice}/mark-to-pay', 'Sales\CustomerInvoiceController@markToPay')->name('customer-invoices/mark-to-pay');
        Route::get('customer-invoices/{customer_invoice}/print', 'Sales\CustomerInvoiceController@print')->name('customer-invoices/print');
        Route::get('customer-invoices/{customer_invoice}/download-xml-pdf', 'Sales\CustomerInvoiceController@downloadXmlPdf')->name('customer-invoices/download-xml-pdf');
        Route::get('customer-invoices/{customer_invoice}/download-xml', 'Sales\CustomerInvoiceController@downloadXml')->name('customer-invoices/download-xml');
        Route::get('customer-invoices/{customer_invoice}/download-pdf', 'Sales\CustomerInvoiceController@downloadPdf')->name('customer-invoices/download-pdf');
        Route::get('customer-invoices/{customer_invoice}/modal-send-mail', 'Sales\CustomerInvoiceController@modalSendMail')->name('customer-invoices/modal-send-mail');
        Route::post('customer-invoices/{customer_invoice}/send-mail', 'Sales\CustomerInvoiceController@sendMail')->name('customer-invoices/send-mail');
        Route::match(['put', 'post'],'customer-invoices/total-lines', 'Sales\CustomerInvoiceController@totalLines')->name('customer-invoices/total-lines');
        Route::get('customer-invoices/get-customer-invoice', 'Sales\CustomerInvoiceController@getCustomerInvoice')->name('customer-invoices/get-customer-invoice');
        Route::get('customer-invoices/autocomplete-cfdi', 'Sales\CustomerInvoiceController@autocompleteCfdi')->name('customer-invoices/autocomplete-cfdi');
        Route::get('customer-invoices/balances', 'Sales\CustomerInvoiceController@balances')->name('customer-invoices/balances');
        Route::get('customer-invoices/{customer_invoice}/modal-cancel', 'Sales\CustomerInvoiceController@modalCancel')->name('customer-invoices/modal-cancel');
        Route::get('customer-invoices/export-to-excel', 'Sales\CustomerInvoiceController@exportToExcel')->name('customer-invoices/export-to-excel');
        Route::get('customer-invoices/{customer_invoice}/modal-payment-history', 'Sales\CustomerInvoiceController@modalPaymentHistory')->name('customer-invoices/modal-payment-history');
        Route::get('customer-invoices/{customer_invoice}/stamp', 'Sales\CustomerInvoiceController@stamp')->name('customer-invoices/stamp');
        Route::get('customer-invoices/{customer_invoice}/cancel-authorized', 'Sales\CustomerInvoiceController@cancelAuthorized')->name('customer-invoices/cancel-authorized');
        Route::get('customer-invoices/{customer_invoice}/cancel-rejected', 'Sales\CustomerInvoiceController@cancelRejected')->name('customer-invoices/cancel-rejected');
        Route::get('customer-invoices/{customer_invoice}/modal-status-sat', 'Sales\CustomerInvoiceController@modalStatusSat')->name('customer-invoices/modal-status-sat');
        Route::get('customer-invoices/import', 'Sales\CustomerInvoiceController@createImport')->name('customer-invoices/import');
        Route::post('customer-invoices/download-template-import', 'Sales\CustomerInvoiceController@downloadTemplateImport')->name('customer-invoices/download-template-import');
        Route::post('customer-invoices/before', 'Sales\CustomerInvoiceController@beforeImport')->name('customer-invoices/before-import');
        Route::post('customer-invoices/import', 'Sales\CustomerInvoiceController@storeImport')->name('customer-invoices/import');
        Route::get('customer-invoices/send-mails-import', 'Sales\CustomerInvoiceController@sendMailsImport')->name('customer-invoices/send-mails-import');
        Route::resource('customer-invoices', 'Sales\CustomerInvoiceController');

        Route::get('recurring-customer-invoices/{recurring_customer_invoice}/print', 'Sales\RecurringCustomerInvoiceController@print')->name('recurring-customer-invoices/print');
        Route::match(['put', 'post'],'recurring-customer-invoices/total-lines', 'Sales\RecurringCustomerInvoiceController@totalLines')->name('recurring-customer-invoices/total-lines');
        Route::resource('recurring-customer-invoices', 'Sales\RecurringCustomerInvoiceController');

        Route::get('customer-credit-notes/{customer_credit_note}/mark-open', 'Sales\CustomerCreditNoteController@markOpen')->name('customer-credit-notes/mark-open');
        Route::get('customer-credit-notes/{customer_credit_note}/mark-sent', 'Sales\CustomerCreditNoteController@markSent')->name('customer-credit-notes/mark-sent');
        Route::get('customer-credit-notes/{customer_credit_note}/mark-per-reconciled', 'Sales\CustomerCreditNoteController@markPerReconciled')->name('customer-credit-notes/mark-per-reconciled');
        Route::get('customer-credit-notes/{customer_credit_note}/mark-reconciled', 'Sales\CustomerCreditNoteController@markReconciled')->name('customer-credit-notes/mark-reconciled');
        Route::get('customer-credit-notes/{customer_credit_note}/print', 'Sales\CustomerCreditNoteController@print')->name('customer-credit-notes/print');
        Route::get('customer-credit-notes/{customer_credit_note}/download-xml', 'Sales\CustomerCreditNoteController@downloadXml')->name('customer-credit-notes/download-xml');
        Route::get('customer-credit-notes/{customer_credit_note}/download-pdf', 'Sales\CustomerCreditNoteController@downloadPdf')->name('customer-credit-notes/download-pdf');
        Route::get('customer-credit-notes/{customer_credit_note}/modal-send-mail', 'Sales\CustomerCreditNoteController@modalSendMail')->name('customer-credit-notes/modal-send-mail');
        Route::post('customer-credit-notes/{customer_credit_note}/send-mail', 'Sales\CustomerCreditNoteController@sendMail')->name('customer-credit-notes/send-mail');
        Route::match(['put', 'post'],'customer-credit-notes/total-lines', 'Sales\CustomerCreditNoteController@totalLines')->name('customer-credit-notes/total-lines');
        Route::match(['put', 'post'],'customer-credit-notes/total-reconciled-lines', 'Sales\CustomerCreditNoteController@totalReconciledLines')->name('customer-credit-notes/total-reconciled-lines');
        Route::get('customer-credit-notes/get-customer-credit-note', 'Sales\CustomerCreditNoteController@getCustomerCreditNote')->name('customer-credit-notes/get-customer-credit-note');
        Route::get('customer-credit-notes/autocomplete-cfdi', 'Sales\CustomerCreditNoteController@autocompleteCfdi')->name('customer-credit-notes/autocomplete-cfdi');
        Route::get('customer-credit-notes/{customer_credit_note}/modal-cancel', 'Sales\CustomerCreditNoteController@modalCancel')->name('customer-credit-notes/modal-cancel');
        Route::get('customer-credit-notes/export-to-excel', 'Sales\CustomerCreditNoteController@exportToExcel')->name('customer-credit-notes/export-to-excel');
        Route::get('customer-credit-notes/{customer_credit_note}/stamp', 'Sales\CustomerCreditNoteController@stamp')->name('customer-credit-notes/stamp');
        Route::get('customer-credit-notes/{customer_credit_note}/modal-status-sat', 'Sales\CustomerCreditNoteController@modalStatusSat')->name('customer-credit-notes/modal-status-sat');
        Route::get('customer-credit-notes/import', 'Sales\CustomerCreditNoteController@createImport')->name('customer-credit-notes/import');
        Route::post('customer-credit-notes/download-template-import', 'Sales\CustomerCreditNoteController@downloadTemplateImport')->name('customer-credit-notes/download-template-import');
        Route::post('customer-credit-notes/before', 'Sales\CustomerCreditNoteController@beforeImport')->name('customer-credit-notes/before-import');
        Route::post('customer-credit-notes/import', 'Sales\CustomerCreditNoteController@storeImport')->name('customer-credit-notes/import');
        Route::get('customer-credit-notes/send-mails-import', 'Sales\CustomerCreditNoteController@sendMailsImport')->name('customer-credit-notes/send-mails-import');
        Route::resource('customer-credit-notes', 'Sales\CustomerCreditNoteController');

        Route::get('customer-payments/add-manual-uuid', 'Sales\CustomerPaymentController@addManualUuid')->name('customer-payments/add-manual-uuid');
        Route::post('customer-payments/add-manual-xml', 'Sales\CustomerPaymentController@addManualXml')->name('customer-payments/add-manual-xml');
        Route::get('customer-payments/{customer_payment}/mark-open', 'Sales\CustomerPaymentController@markOpen')->name('customer-payments/mark-open');
        Route::get('customer-payments/{customer_payment}/mark-sent', 'Sales\CustomerPaymentController@markSent')->name('customer-payments/mark-sent');
        Route::get('customer-payments/{customer_payment}/mark-per-reconciled', 'Sales\CustomerPaymentController@markPerReconciled')->name('customer-payments/mark-per-reconciled');
        Route::get('customer-payments/{customer_payment}/mark-reconciled', 'Sales\CustomerPaymentController@markReconciled')->name('customer-payments/mark-reconciled');
        Route::get('customer-payments/{customer_payment}/print', 'Sales\CustomerPaymentController@print')->name('customer-payments/print');
        Route::get('customer-payments/{customer_payment}/download-xml', 'Sales\CustomerPaymentController@downloadXml')->name('customer-payments/download-xml');
        Route::get('customer-payments/{customer_payment}/download-pdf', 'Sales\CustomerPaymentController@downloadPdf')->name('customer-payments/download-pdf');
        Route::get('customer-payments/{customer_payment}/modal-send-mail', 'Sales\CustomerPaymentController@modalSendMail')->name('customer-payments/modal-send-mail');
        Route::post('customer-payments/{customer_payment}/send-mail', 'Sales\CustomerPaymentController@sendMail')->name('customer-payments/send-mail');
        Route::match(['put', 'post'],'customer-payments/total-item-manual-reconciled', 'Sales\CustomerPaymentController@totalItemManualReconciled')->name('customer-payments/total-item-manual-reconciled');
        Route::match(['put', 'post'],'customer-payments/total-reconciled-lines', 'Sales\CustomerPaymentController@totalReconciledLines')->name('customer-payments/total-reconciled-lines');
        Route::get('customer-payments/get-customer-payment', 'Sales\CustomerPaymentController@getCustomerPayment')->name('customer-payments/get-customer-payment');
        Route::get('customer-payments/autocomplete-cfdi', 'Sales\CustomerPaymentController@autocompleteCfdi')->name('customer-payments/autocomplete-cfdi');
        Route::get('customer-payments/{customer_payment}/modal-reconciled', 'Sales\CustomerPaymentController@modalReconciled')->name('customer-payments/modal-reconciled');
        Route::post('customer-payments/{customer_payment}/reconciled', 'Sales\CustomerPaymentController@reconciled')->name('customer-payments/reconciled');
        Route::get('customer-payments/{customer_payment}/modal-cancel', 'Sales\CustomerPaymentController@modalCancel')->name('customer-payments/modal-cancel');
        Route::get('customer-payments/{customer_payment}/stamp', 'Sales\CustomerPaymentController@stamp')->name('customer-payments/stamp');
        Route::get('customer-payments/export-to-excel', 'Sales\CustomerPaymentController@exportToExcel')->name('customer-payments/export-to-excel');
        Route::get('customer-payments/{customer_payment}/modal-status-sat', 'Sales\CustomerPaymentController@modalStatusSat')->name('customer-payments/modal-status-sat');
        Route::get('customer-payments/import', 'Sales\CustomerPaymentController@createImport')->name('customer-payments/import');
        Route::post('customer-payments/download-template-import', 'Sales\CustomerPaymentController@downloadTemplateImport')->name('customer-payments/download-template-import');
        Route::post('customer-payments/before', 'Sales\CustomerPaymentController@beforeImport')->name('customer-payments/before-import');
        Route::post('customer-payments/import', 'Sales\CustomerPaymentController@storeImport')->name('customer-payments/import');
        Route::get('customer-payments/send-mails-import', 'Sales\CustomerPaymentController@sendMailsImport')->name('customer-payments/send-mails-import');
        Route::resource('customer-payments', 'Sales\CustomerPaymentController');

        Route::get('customer-transfers/{customer_transfer}/mark-open', 'Sales\CustomerTransferController@markOpen')->name('customer-transfers/mark-open');
        Route::get('customer-transfers/{customer_transfer}/mark-sent', 'Sales\CustomerTransferController@markSent')->name('customer-transfers/mark-sent');
        Route::get('customer-transfers/{customer_transfer}/mark-to-pay', 'Sales\CustomerTransferController@markToPay')->name('customer-transfers/mark-to-pay');
        Route::get('customer-transfers/{customer_transfer}/mark-paid', 'Sales\CustomerTransferController@markPaid')->name('customer-transfers/mark-paid');
        Route::get('customer-transfers/{customer_transfer}/print', 'Sales\CustomerTransferController@print')->name('customer-transfers/print');
        Route::get('customer-transfers/{customer_transfer}/download-xml', 'Sales\CustomerTransferController@downloadXml')->name('customer-transfers/download-xml');
        Route::get('customer-transfers/{customer_transfer}/download-pdf', 'Sales\CustomerTransferController@downloadPdf')->name('customer-transfers/download-pdf');
        Route::get('customer-transfers/{customer_transfer}/modal-send-mail', 'Sales\CustomerTransferController@modalSendMail')->name('customer-transfers/modal-send-mail');
        Route::post('customer-transfers/{customer_transfer}/send-mail', 'Sales\CustomerTransferController@sendMail')->name('customer-transfers/send-mail');
        Route::match(['put', 'post'],'customer-transfers/total-lines', 'Sales\CustomerTransferController@totalLines')->name('customer-transfers/total-lines');
        Route::get('customer-transfers/get-customer-transfer', 'Sales\CustomerTransferController@getCustomerTransfer')->name('customer-transfers/get-customer-transfer');
        Route::get('customer-transfers/autocomplete-cfdi', 'Sales\CustomerTransferController@autocompleteCfdi')->name('customer-transfers/autocomplete-cfdi');
        Route::get('customer-transfers/{customer_transfer}/modal-cancel', 'Sales\CustomerTransferController@modalCancel')->name('customer-transfers/modal-cancel');
        Route::get('customer-transfers/export-to-excel', 'Sales\CustomerTransferController@exportToExcel')->name('customer-transfers/export-to-excel');
        Route::get('customer-transfers/{customer_invoice}/modal-payment-history', 'Sales\CustomerInvoiceController@modalPaymentHistory')->name('customer-transfers/modal-payment-history');
        Route::get('customer-transfers/{customer_transfer}/stamp', 'Sales\CustomerTransferController@stamp')->name('customer-transfers/stamp');
        Route::get('customer-transfers/{customer_transfer}/cancel-authorized', 'Sales\CustomerTransferController@cancelAuthorized')->name('customer-transfers/cancel-authorized');
        Route::get('customer-transfers/{customer_transfer}/cancel-rejected', 'Sales\CustomerTransferController@cancelRejected')->name('customer-transfers/cancel-rejected');
        Route::get('customer-transfers/{customer_transfer}/modal-status-sat', 'Sales\CustomerTransferController@modalStatusSat')->name('customer-transfers/modal-status-sat');
        Route::get('customer-transfers/download-template-transfer-import', 'Sales\CustomerTransferController@downloadTemplateTransferImport')->name('customer-transfers/download-template-transfer-import');
        Route::post('customer-transfers/transfer-import', 'Sales\CustomerTransferController@transferImport')->name('customer-transfers/transfer-import');
        Route::resource('customer-transfers', 'Sales\CustomerTransferController');

        Route::get('customer-leases/{customer_lease}/mark-open', 'Sales\CustomerLeaseController@markOpen')->name('customer-leases/mark-open');
        Route::get('customer-leases/{customer_lease}/mark-sent', 'Sales\CustomerLeaseController@markSent')->name('customer-leases/mark-sent');
        Route::get('customer-leases/{customer_lease}/mark-to-pay', 'Sales\CustomerLeaseController@markToPay')->name('customer-leases/mark-to-pay');
        Route::get('customer-leases/{customer_lease}/mark-paid', 'Sales\CustomerLeaseController@markPaid')->name('customer-leases/mark-paid');
        Route::get('customer-leases/{customer_lease}/print', 'Sales\CustomerLeaseController@print')->name('customer-leases/print');
        Route::get('customer-leases/{customer_lease}/download-xml', 'Sales\CustomerLeaseController@downloadXml')->name('customer-leases/download-xml');
        Route::get('customer-leases/{customer_lease}/download-pdf', 'Sales\CustomerLeaseController@downloadPdf')->name('customer-leases/download-pdf');
        Route::get('customer-leases/{customer_lease}/modal-send-mail', 'Sales\CustomerLeaseController@modalSendMail')->name('customer-leases/modal-send-mail');
        Route::post('customer-leases/{customer_lease}/send-mail', 'Sales\CustomerLeaseController@sendMail')->name('customer-leases/send-mail');
        Route::match(['put', 'post'],'customer-leases/total-lines', 'Sales\CustomerLeaseController@totalLines')->name('customer-leases/total-lines');
        Route::get('customer-leases/get-customer-lease', 'Sales\CustomerLeaseController@getCustomerLease')->name('customer-leases/get-customer-lease');
        Route::get('customer-leases/autocomplete-cfdi', 'Sales\CustomerLeaseController@autocompleteCfdi')->name('customer-leases/autocomplete-cfdi');
        Route::get('customer-leases/balances', 'Sales\CustomerLeaseController@balances')->name('customer-leases/balances');
        Route::get('customer-leases/{customer_lease}/modal-cancel', 'Sales\CustomerLeaseController@modalCancel')->name('customer-leases/modal-cancel');
        Route::get('customer-leases/export-to-excel', 'Sales\CustomerLeaseController@exportToExcel')->name('customer-leases/export-to-excel');
        Route::get('customer-leases/{customer_lease}/modal-payment-history', 'Sales\CustomerLeaseController@modalPaymentHistory')->name('customer-leases/modal-payment-history');
        Route::get('customer-leases/{customer_lease}/stamp', 'Sales\CustomerLeaseController@stamp')->name('customer-leases/stamp');
        Route::get('customer-leases/{customer_lease}/cancel-authorized', 'Sales\CustomerLeaseController@cancelAuthorized')->name('customer-leases/cancel-authorized');
        Route::get('customer-leases/{customer_lease}/cancel-rejected', 'Sales\CustomerLeaseController@cancelRejected')->name('customer-leases/cancel-rejected');
        Route::get('customer-leases/{customer_lease}/modal-status-sat', 'Sales\CustomerLeaseController@modalStatusSat')->name('customer-leases/modal-status-sat');
        Route::resource('customer-leases', 'Sales\CustomerLeaseController');

        Route::get('customer-fees/{customer_fee}/mark-open', 'Sales\CustomerFeeController@markOpen')->name('customer-fees/mark-open');
        Route::get('customer-fees/{customer_fee}/mark-sent', 'Sales\CustomerFeeController@markSent')->name('customer-fees/mark-sent');
        Route::get('customer-fees/{customer_fee}/mark-to-pay', 'Sales\CustomerFeeController@markToPay')->name('customer-fees/mark-to-pay');
        Route::get('customer-fees/{customer_fee}/mark-paid', 'Sales\CustomerFeeController@markPaid')->name('customer-fees/mark-paid');
        Route::get('customer-fees/{customer_fee}/print', 'Sales\CustomerFeeController@print')->name('customer-fees/print');
        Route::get('customer-fees/{customer_fee}/download-xml', 'Sales\CustomerFeeController@downloadXml')->name('customer-fees/download-xml');
        Route::get('customer-fees/{customer_fee}/download-pdf', 'Sales\CustomerFeeController@downloadPdf')->name('customer-fees/download-pdf');
        Route::get('customer-fees/{customer_fee}/modal-send-mail', 'Sales\CustomerFeeController@modalSendMail')->name('customer-fees/modal-send-mail');
        Route::post('customer-fees/{customer_fee}/send-mail', 'Sales\CustomerFeeController@sendMail')->name('customer-fees/send-mail');
        Route::match(['put', 'post'],'customer-fees/total-lines', 'Sales\CustomerFeeController@totalLines')->name('customer-fees/total-lines');
        Route::get('customer-fees/get-customer-fee', 'Sales\CustomerFeeController@getCustomerFee')->name('customer-fees/get-customer-fee');
        Route::get('customer-fees/autocomplete-cfdi', 'Sales\CustomerFeeController@autocompleteCfdi')->name('customer-fees/autocomplete-cfdi');
        Route::get('customer-fees/balances', 'Sales\CustomerFeeController@balances')->name('customer-fees/balances');
        Route::get('customer-fees/{customer_fee}/modal-cancel', 'Sales\CustomerFeeController@modalCancel')->name('customer-fees/modal-cancel');
        Route::get('customer-fees/export-to-excel', 'Sales\CustomerFeeController@exportToExcel')->name('customer-fees/export-to-excel');
        Route::get('customer-fees/{customer_fee}/modal-payment-history', 'Sales\CustomerFeeController@modalPaymentHistory')->name('customer-fees/modal-payment-history');
        Route::get('customer-fees/{customer_fee}/stamp', 'Sales\CustomerFeeController@stamp')->name('customer-fees/stamp');
        Route::get('customer-fees/{customer_fee}/cancel-authorized', 'Sales\CustomerFeeController@cancelAuthorized')->name('customer-fees/cancel-authorized');
        Route::get('customer-fees/{customer_fee}/cancel-rejected', 'Sales\CustomerFeeController@cancelRejected')->name('customer-fees/cancel-rejected');
        Route::get('customer-fees/{customer_fee}/modal-status-sat', 'Sales\CustomerFeeController@modalStatusSat')->name('customer-fees/modal-status-sat');
        Route::resource('customer-fees', 'Sales\CustomerFeeController');

        Route::get('customer-foreign-trades/{customer_foreign_trade}/mark-open', 'Sales\CustomerForeignTradeController@markOpen')->name('customer-foreign-trades/mark-open');
        Route::get('customer-foreign-trades/{customer_foreign_trade}/mark-sent', 'Sales\CustomerForeignTradeController@markSent')->name('customer-foreign-trades/mark-sent');
        Route::get('customer-foreign-trades/{customer_foreign_trade}/mark-paid', 'Sales\CustomerForeignTradeController@markPaid')->name('customer-foreign-trades/mark-paid');
        Route::get('customer-foreign-trades/{customer_foreign_trade}/mark-to-pay', 'Sales\CustomerForeignTradeController@markToPay')->name('customer-foreign-trades/mark-to-pay');
        Route::get('customer-foreign-trades/{customer_foreign_trade}/print', 'Sales\CustomerForeignTradeController@print')->name('customer-foreign-trades/print');
        Route::get('customer-foreign-trades/{customer_foreign_trade}/download-xml', 'Sales\CustomerForeignTradeController@downloadXml')->name('customer-foreign-trades/download-xml');
        Route::get('customer-foreign-trades/{customer_foreign_trade}/download-pdf', 'Sales\CustomerForeignTradeController@downloadPdf')->name('customer-foreign-trades/download-pdf');
        Route::get('customer-foreign-trades/{customer_foreign_trade}/modal-send-mail', 'Sales\CustomerForeignTradeController@modalSendMail')->name('customer-foreign-trades/modal-send-mail');
        Route::post('customer-foreign-trades/{customer_foreign_trade}/send-mail', 'Sales\CustomerForeignTradeController@sendMail')->name('customer-foreign-trades/send-mail');
        Route::match(['put', 'post'],'customer-foreign-trades/total-lines', 'Sales\CustomerForeignTradeController@totalLines')->name('customer-foreign-trades/total-lines');
        Route::get('customer-foreign-trades/get-customer-foreign-trade', 'Sales\CustomerForeignTradeController@getCustomerForeignTrade')->name('customer-foreign-trades/get-customer-foreign-trade');
        Route::get('customer-foreign-trades/autocomplete-cfdi', 'Sales\CustomerForeignTradeController@autocompleteCfdi')->name('customer-foreign-trades/autocomplete-cfdi');
        Route::get('customer-foreign-trades/{customer_foreign_trade}/modal-cancel', 'Sales\CustomerForeignTradeController@modalCancel')->name('customer-foreign-trades/modal-cancel');
        Route::get('customer-foreign-trades/export-to-excel', 'Sales\CustomerForeignTradeController@exportToExcel')->name('customer-foreign-trades/export-to-excel');
        Route::get('customer-foreign-trades/{customer_foreign_trade}/modal-payment-history', 'Sales\CustomerInvoiceController@modalPaymentHistory')->name('customer-foreign-trades/modal-payment-history');
        Route::get('customer-foreign-trades/{customer_foreign_trade}/stamp', 'Sales\CustomerForeignTradeController@stamp')->name('customer-foreign-trades/stamp');
        Route::get('customer-foreign-trades/{customer_foreign_trade}/cancel-authorized', 'Sales\CustomerForeignTradeController@cancelAuthorized')->name('customer-foreign-trades/cancel-authorized');
        Route::get('customer-foreign-trades/{customer_foreign_trade}/cancel-rejected', 'Sales\CustomerForeignTradeController@cancelRejected')->name('customer-foreign-trades/cancel-rejected');
        Route::get('customer-foreign-trades/{customer_foreign_trade}/modal-status-sat', 'Sales\CustomerForeignTradeController@modalStatusSat')->name('customer-foreign-trades/modal-status-sat');
        Route::resource('customer-foreign-trades', 'Sales\CustomerForeignTradeController');
    });

    //Reportes
    Route::prefix('reports')->group(function () {
        Route::get('income-expenses/export-to-excel', 'Reports\IncomeExpensesController@exportToExcel')->name('income-expenses/export-to-excel');
        Route::get('income-expenses', 'Reports\IncomeExpensesController@index')->name('income-expenses.index');
    });

    Route::get('users/{user}/edit-profile', 'Auth\UserController@editProfile')->name('users/edit-profile');
    Route::put('users/{user}/update-profile', 'Auth\UserController@updateProfile')->name('users/update-profile');
    Route::get('users/{user}/reset-link-email', 'Auth\UserController@sendResetLinkEmail')->name('users/reset-link-email');
    Route::post('users/{user}/update-sys-customer', 'Auth\UserController@updateSysCustomer')->name('users/update-sys-customer');
    Route::post('users/{user}/update-company', 'Auth\UserController@updateCompany')->name('users/update-company');
    Route::resource('users', 'Auth\UserController');


});
