/*
Navicat MySQL Data Transfer

Source Server         : MySQL 5.7.27
Source Server Version : 50728
Source Database       : 6df5305e40a8471c98ab46b5eeb8113f

Target Server Type    : MYSQL
Target Server Version : 50728
File Encoding         : 65001

Date: 2019-12-25 21:24:38
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for fcf_banks
-- ----------------------------
DROP TABLE IF EXISTS `fcf_banks`;
CREATE TABLE `fcf_banks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `taxid` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_banks
-- ----------------------------
INSERT INTO `fcf_banks` VALUES ('1', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BANAMEX', '002', '', '0', '1', 'Banco Nacional de México, S.A., Institución de Banca Múltiple, Grupo Financiero Banamex');
INSERT INTO `fcf_banks` VALUES ('2', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BANCOMEXT', '006', '', '0', '1', 'Banco Nacional de Comercio Exterior, Sociedad Nacional de Crédito, Institución de Banca de Desarrollo');
INSERT INTO `fcf_banks` VALUES ('3', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BANOBRAS', '009', '', '0', '1', 'Banco Nacional de Obras y Servicios Públicos, Sociedad Nacional de Crédito, Institución de Banca de Desarrollo');
INSERT INTO `fcf_banks` VALUES ('4', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BBVA BANCOMER', '012', '', '0', '1', 'BBVA Bancomer, S.A., Institución de Banca Múltiple, Grupo Financiero BBVA Bancomer');
INSERT INTO `fcf_banks` VALUES ('5', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'SANTANDER', '014', '', '0', '1', 'Banco Santander (México), S.A., Institución de Banca Múltiple, Grupo Financiero Santander');
INSERT INTO `fcf_banks` VALUES ('6', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BANJERCITO', '019', '', '0', '1', 'Banco Nacional del Ejército, Fuerza Aérea y Armada, Sociedad Nacional de Crédito, Institución de Banca de Desarrollo');
INSERT INTO `fcf_banks` VALUES ('7', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'HSBC', '021', '', '0', '1', 'HSBC México, S.A., institución De Banca Múltiple, Grupo Financiero HSBC');
INSERT INTO `fcf_banks` VALUES ('8', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BAJIO', '030', '', '0', '1', 'Banco del Bajío, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('9', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'IXE', '032', '', '0', '1', 'IXE Banco, S.A., Institución de Banca Múltiple, IXE Grupo Financiero');
INSERT INTO `fcf_banks` VALUES ('10', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'INBURSA', '036', '', '0', '1', 'Banco Inbursa, S.A., Institución de Banca Múltiple, Grupo Financiero Inbursa');
INSERT INTO `fcf_banks` VALUES ('11', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'INTERACCIONES', '037', '', '0', '1', 'Banco Interacciones, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('12', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'MIFEL', '042', '', '0', '1', 'Banca Mifel, S.A., Institución de Banca Múltiple, Grupo Financiero Mifel');
INSERT INTO `fcf_banks` VALUES ('13', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'SCOTIABANK', '044', '', '0', '1', 'Scotiabank Inverlat, S.A.');
INSERT INTO `fcf_banks` VALUES ('14', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BANREGIO', '058', '', '0', '1', 'Banco Regional de Monterrey, S.A., Institución de Banca Múltiple, Banregio Grupo Financiero');
INSERT INTO `fcf_banks` VALUES ('15', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'INVEX', '059', '', '0', '1', 'Banco Invex, S.A., Institución de Banca Múltiple, Invex Grupo Financiero');
INSERT INTO `fcf_banks` VALUES ('16', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BANSI', '060', '', '0', '1', 'Bansi, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('17', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'AFIRME', '062', '', '0', '1', 'Banca Afirme, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('18', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BANORTE/IXE', '072', '', '0', '1', 'Banco Mercantil del Norte, S.A., Institución de Banca Múltiple, Grupo Financiero Banorte');
INSERT INTO `fcf_banks` VALUES ('19', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'THE ROYAL BANK', '102', '', '0', '1', 'The Royal Bank of Scotland México, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('20', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'AMERICAN EXPRESS', '103', '', '0', '1', 'American Express Bank (México), S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('21', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BAMSA', '106', '', '0', '1', 'Bank of America México, S.A., Institución de Banca Múltiple, Grupo Financiero Bank of America');
INSERT INTO `fcf_banks` VALUES ('22', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'TOKYO', '108', '', '0', '1', 'Bank of Tokyo-Mitsubishi UFJ (México), S.A.');
INSERT INTO `fcf_banks` VALUES ('23', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'JP MORGAN', '110', '', '0', '1', 'Banco J.P. Morgan, S.A., Institución de Banca Múltiple, J.P. Morgan Grupo Financiero');
INSERT INTO `fcf_banks` VALUES ('24', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BMONEX', '112', '', '0', '1', 'Banco Monex, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('25', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'VE POR MAS', '113', '', '0', '1', 'Banco Ve Por Mas, S.A. Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('26', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'ING', '116', '', '0', '1', 'ING Bank (México), S.A., Institución de Banca Múltiple, ING Grupo Financiero');
INSERT INTO `fcf_banks` VALUES ('27', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'DEUTSCHE', '124', '', '0', '1', 'Deutsche Bank México, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('28', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'CREDIT SUISSE', '126', '', '0', '1', 'Banco Credit Suisse (México), S.A. Institución de Banca Múltiple, Grupo Financiero Credit Suisse (México)');
INSERT INTO `fcf_banks` VALUES ('29', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'AZTECA', '127', '', '0', '1', 'Banco Azteca, S.A. Institución de Banca Múltiple.');
INSERT INTO `fcf_banks` VALUES ('30', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'AUTOFIN', '128', '', '0', '1', 'Banco Autofin México, S.A. Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('31', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BARCLAYS', '129', '', '0', '1', 'Barclays Bank México, S.A., Institución de Banca Múltiple, Grupo Financiero Barclays México');
INSERT INTO `fcf_banks` VALUES ('32', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'COMPARTAMOS', '130', '', '0', '1', 'Banco Compartamos, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('33', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BANCO FAMSA', '131', '', '0', '1', 'Banco Ahorro Famsa, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('34', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BMULTIVA', '132', '', '0', '1', 'Banco Multiva, S.A., Institución de Banca Múltiple, Multivalores Grupo Financiero');
INSERT INTO `fcf_banks` VALUES ('35', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'ACTINVER', '133', '', '0', '1', 'Banco Actinver, S.A. Institución de Banca Múltiple, Grupo Financiero Actinver');
INSERT INTO `fcf_banks` VALUES ('36', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'WAL-MART', '134', '', '0', '1', 'Banco Wal-Mart de México Adelante, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('37', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'NAFIN', '135', '', '0', '1', 'Nacional Financiera, Sociedad Nacional de Crédito, Institución de Banca de Desarrollo');
INSERT INTO `fcf_banks` VALUES ('38', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'INTERCAM BANCO', '136', '', '0', '1', 'Intercam Banco, S.A., Institución de Banca Múltiple, Intercam Grupo Financiero');
INSERT INTO `fcf_banks` VALUES ('39', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BANCOPPEL', '137', '', '0', '1', 'BanCoppel, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('40', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'ABC CAPITAL', '138', '', '0', '1', 'ABC Capital, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('41', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'UBS BANK', '139', '', '0', '1', 'UBS Bank México, S.A., Institución de Banca Múltiple, UBS Grupo Financiero');
INSERT INTO `fcf_banks` VALUES ('42', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'CONSUBANCO', '140', '', '0', '1', 'Consubanco, S.A. Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('43', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'VOLKSWAGEN', '141', '', '0', '1', 'Volkswagen Bank, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('44', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'CIBANCO', '143', '', '0', '1', 'CIBanco, S.A.');
INSERT INTO `fcf_banks` VALUES ('45', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BBASE', '145', '', '0', '1', 'Banco Base, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('46', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BANKAOOL', '147', '', '0', '1', 'Bankaool, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('47', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'PAGATODO', '148', '', '0', '1', 'Banco PagaTodo, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('48', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'FORJADORES', '149', '', '0', '1', 'Banco Forjadores, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('49', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'INMOBILIARIO', '150', '', '0', '1', 'Banco Inmobiliario Mexicano, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('50', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'DONDÉ', '151', '', '0', '1', 'Fundación Dondé Banco, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('51', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BANCREA', '152', '', '0', '1', 'Banco Bancrea, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('52', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'PROGRESO', '153', '', '0', '1', 'Banco Progreso Chihuahua, S.A.');
INSERT INTO `fcf_banks` VALUES ('53', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BANCO FINTERRA', '154', '', '0', '1', 'Banco Finterra, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('54', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'ICBC', '155', '', '0', '1', 'Industrial and Commercial Bank of China México, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('55', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'SABADELL', '156', '', '0', '1', 'Banco Sabadell, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('56', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'SHINHAN', '157', '', '0', '1', 'Banco Shinhan de México, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('57', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'MIZUHO BANK', '158', '', '0', '1', 'Mizuho Bank México, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('58', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BANK OF CHINA', '159', '', '0', '1', 'Bank of China México, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('59', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BANCO S3', '160', '', '0', '1', 'Banco S3 México, S.A., Institución de Banca Múltiple');
INSERT INTO `fcf_banks` VALUES ('60', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BANSEFI', '166', '', '0', '1', 'Banco del Ahorro Nacional y Servicios Financieros, Sociedad Nacional de Crédito, Institución de Banca de Desarrollo');
INSERT INTO `fcf_banks` VALUES ('61', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'HIPOTECARIA FEDERAL', '168', '', '0', '1', 'Sociedad Hipotecaria Federal, Sociedad Nacional de Crédito, Institución de Banca de Desarrollo');
INSERT INTO `fcf_banks` VALUES ('62', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'MONEXCB', '600', '', '0', '1', 'Monex Casa de Bolsa, S.A. de C.V. Monex Grupo Financiero');
INSERT INTO `fcf_banks` VALUES ('63', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'GBM', '601', '', '0', '1', 'GBM Grupo Bursátil Mexicano, S.A. de C.V. Casa de Bolsa');
INSERT INTO `fcf_banks` VALUES ('64', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'MASARI', '602', '', '0', '1', 'Masari Casa de Bolsa, S.A.');
INSERT INTO `fcf_banks` VALUES ('65', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'VALUE', '605', '', '0', '1', 'Value, S.A. de C.V. Casa de Bolsa');
INSERT INTO `fcf_banks` VALUES ('66', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'ESTRUCTURADORES', '606', '', '0', '1', 'Estructuradores del Mercado de Valores Casa de Bolsa, S.A. de C.V.');
INSERT INTO `fcf_banks` VALUES ('67', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'TIBER', '607', '', '0', '1', 'Casa de Cambio Tiber, S.A. de C.V.');
INSERT INTO `fcf_banks` VALUES ('68', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'VECTOR', '608', '', '0', '1', 'Vector Casa de Bolsa, S.A. de C.V.');
INSERT INTO `fcf_banks` VALUES ('69', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'B&B', '610', '', '0', '1', 'B y B, Casa de Cambio, S.A. de C.V.');
INSERT INTO `fcf_banks` VALUES ('70', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'ACCIVAL', '614', '', '0', '1', 'Acciones y Valores Banamex, S.A. de C.V., Casa de Bolsa');
INSERT INTO `fcf_banks` VALUES ('71', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'MERRILL LYNCH', '615', '', '0', '1', 'Merrill Lynch México, S.A. de C.V. Casa de Bolsa');
INSERT INTO `fcf_banks` VALUES ('72', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'FINAMEX', '616', '', '0', '1', 'Casa de Bolsa Finamex, S.A. de C.V.');
INSERT INTO `fcf_banks` VALUES ('73', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'VALMEX', '617', '', '0', '1', 'Valores Mexicanos Casa de Bolsa, S.A. de C.V.');
INSERT INTO `fcf_banks` VALUES ('74', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'UNICA', '618', '', '0', '1', 'Unica Casa de Cambio, S.A. de C.V.');
INSERT INTO `fcf_banks` VALUES ('75', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'MAPFRE', '619', '', '0', '1', 'MAPFRE Tepeyac, S.A.');
INSERT INTO `fcf_banks` VALUES ('76', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'PROFUTURO', '620', '', '0', '1', 'Profuturo G.N.P., S.A. de C.V., Afore');
INSERT INTO `fcf_banks` VALUES ('77', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'CB ACTINVER', '621', '', '0', '1', 'Actinver Casa de Bolsa, S.A. de C.V.');
INSERT INTO `fcf_banks` VALUES ('78', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'OACTIN', '622', '', '0', '1', 'OPERADORA ACTINVER, S.A. DE C.V.');
INSERT INTO `fcf_banks` VALUES ('79', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'SKANDIA', '623', '', '0', '1', 'Skandia Vida, S.A. de C.V.');
INSERT INTO `fcf_banks` VALUES ('80', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'CBDEUTSCHE', '626', '', '0', '1', 'Deutsche Securities, S.A. de C.V. CASA DE BOLSA');
INSERT INTO `fcf_banks` VALUES ('81', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'ZURICH', '627', '', '0', '1', 'Zurich Compañía de Seguros, S.A.');
INSERT INTO `fcf_banks` VALUES ('82', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'ZURICHVI', '628', '', '0', '1', 'Zurich Vida, Compañía de Seguros, S.A.');
INSERT INTO `fcf_banks` VALUES ('83', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'SU CASITA', '629', '', '0', '1', 'Hipotecaria Su Casita, S.A. de C.V. SOFOM ENR');
INSERT INTO `fcf_banks` VALUES ('84', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'CB INTERCAM', '630', '', '0', '1', 'Intercam Casa de Bolsa, S.A. de C.V.');
INSERT INTO `fcf_banks` VALUES ('85', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'CI BOLSA', '631', '', '0', '1', 'CI Casa de Bolsa, S.A. de C.V.');
INSERT INTO `fcf_banks` VALUES ('86', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'BULLTICK CB', '632', '', '0', '1', 'Bulltick Casa de Bolsa, S.A., de C.V.');
INSERT INTO `fcf_banks` VALUES ('87', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'STERLING', '633', '', '0', '1', 'Sterling Casa de Cambio, S.A. de C.V.');
INSERT INTO `fcf_banks` VALUES ('88', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'FINCOMUN', '634', '', '0', '1', 'Fincomún, Servicios Financieros Comunitarios, S.A. de C.V.');
INSERT INTO `fcf_banks` VALUES ('89', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'HDI SEGUROS', '636', '', '0', '1', 'HDI Seguros, S.A. de C.V.');
INSERT INTO `fcf_banks` VALUES ('90', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'ORDER', '637', '', '0', '1', 'Order Express Casa de Cambio, S.A. de C.V');
INSERT INTO `fcf_banks` VALUES ('91', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'AKALA', '638', '', '0', '1', 'Akala, S.A. de C.V., Sociedad Financiera Popular');
INSERT INTO `fcf_banks` VALUES ('92', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'CB JPMORGAN', '640', '', '0', '1', 'J.P. Morgan Casa de Bolsa, S.A. de C.V. J.P. Morgan Grupo Financiero');
INSERT INTO `fcf_banks` VALUES ('93', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'REFORMA', '642', '', '0', '1', 'Operadora de Recursos Reforma, S.A. de C.V., S.F.P.');
INSERT INTO `fcf_banks` VALUES ('94', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'STP', '646', '', '0', '1', 'Sistema de Transferencias y Pagos STP, S.A. de C.V.SOFOM ENR');
INSERT INTO `fcf_banks` VALUES ('95', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'TELECOMM', '647', '', '0', '1', 'Telecomunicaciones de México');
INSERT INTO `fcf_banks` VALUES ('96', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'EVERCORE', '648', '', '0', '1', 'Evercore Casa de Bolsa, S.A. de C.V.');
INSERT INTO `fcf_banks` VALUES ('97', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'SKANDIA', '649', '', '0', '1', 'Skandia Operadora de Fondos, S.A. de C.V.');
INSERT INTO `fcf_banks` VALUES ('98', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'SEGMTY', '651', '', '0', '1', 'Seguros Monterrey New York Life, S.A de C.V');
INSERT INTO `fcf_banks` VALUES ('99', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'ASEA', '652', '', '0', '1', 'Solución Asea, S.A. de C.V., Sociedad Financiera Popular');
INSERT INTO `fcf_banks` VALUES ('100', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'KUSPIT', '653', '', '0', '1', 'Kuspit Casa de Bolsa, S.A. de C.V.');
INSERT INTO `fcf_banks` VALUES ('101', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'SOFIEXPRESS', '655', '', '0', '1', 'J.P. SOFIEXPRESS, S.A. de C.V., S.F.P.');
INSERT INTO `fcf_banks` VALUES ('102', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'UNAGRA', '656', '', '0', '1', 'UNAGRA, S.A. de C.V., S.F.P.');
INSERT INTO `fcf_banks` VALUES ('103', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'OPCIONES EMPRESARIALES DEL NOROESTE', '659', '', '0', '1', 'OPCIONES EMPRESARIALES DEL NORESTE, S.A. DE C.V., S.F.P.');
INSERT INTO `fcf_banks` VALUES ('104', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'LIBERTAD', '670', '', '0', '1', 'Libertad Servicios Financieros, S.A. De C.V.');
INSERT INTO `fcf_banks` VALUES ('105', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'CLS', '901', '', '0', '1', 'Cls Bank International');
INSERT INTO `fcf_banks` VALUES ('106', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'INDEVAL', '902', '', '0', '1', 'SD. Indeval, S.A. de C.V.');

-- ----------------------------
-- Table structure for fcf_branch_offices
-- ----------------------------
DROP TABLE IF EXISTS `fcf_branch_offices`;
CREATE TABLE `fcf_branch_offices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_mobile` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_1` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_2` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_3` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_4` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_5` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_6` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city_id` int(10) unsigned DEFAULT NULL,
  `state_id` int(10) unsigned DEFAULT NULL,
  `country_id` int(10) unsigned NOT NULL,
  `postcode` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `company_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `branch_offices_city_id_foreign` (`city_id`),
  KEY `branch_offices_state_id_foreign` (`state_id`),
  KEY `branch_offices_country_id_foreign` (`country_id`),
  KEY `branch_offices_company_id_foreign` (`company_id`),
  CONSTRAINT `branch_offices_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `fcf_cities` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `branch_offices_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `fcf_companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `branch_offices_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `fcf_countries` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `branch_offices_state_id_foreign` FOREIGN KEY (`state_id`) REFERENCES `fcf_states` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_branch_offices
-- ----------------------------
INSERT INTO `fcf_branch_offices` VALUES ('1', '2019-12-25 21:15:57', '2019-12-25 21:15:57', '42', '9', 'MATRIZ', '', '', null, '', '', null, '', null, null, null, null, '1', '', null, '0', '1', '1');

-- ----------------------------
-- Table structure for fcf_cfdi_relations
-- ----------------------------
DROP TABLE IF EXISTS `fcf_cfdi_relations`;
CREATE TABLE `fcf_cfdi_relations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_cfdi_relations
-- ----------------------------
INSERT INTO `fcf_cfdi_relations` VALUES ('1', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '2', '2', 'Nota de crédito de los documentos relacionados', '01', '1', '1');
INSERT INTO `fcf_cfdi_relations` VALUES ('2', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '9', '9', 'Nota de débito de los documentos relacionados', '02', '2', '1');
INSERT INTO `fcf_cfdi_relations` VALUES ('3', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '2', '1', 'Devolución de mercancía sobre facturas o traslados previos', '03', '3', '1');
INSERT INTO `fcf_cfdi_relations` VALUES ('4', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '40', '1', 'Sustitución de los CFDI previos', '04', '4', '1');
INSERT INTO `fcf_cfdi_relations` VALUES ('5', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '9', '9', 'Traslados de mercancias facturados previamente', '05', '5', '0');
INSERT INTO `fcf_cfdi_relations` VALUES ('6', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '1', '2', 'Factura generada por los traslados previos', '06', '6', '0');
INSERT INTO `fcf_cfdi_relations` VALUES ('7', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '2', '39', 'CFDI por aplicación de anticipo', '07', '7', '1');
INSERT INTO `fcf_cfdi_relations` VALUES ('8', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '8', '39', 'Factura generada por pagos en parcialidades', '08', '8', '1');
INSERT INTO `fcf_cfdi_relations` VALUES ('9', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '40', '8', 'Factura generada por pagos diferidos', '09', '9', '1');

-- ----------------------------
-- Table structure for fcf_cfdi_types
-- ----------------------------
DROP TABLE IF EXISTS `fcf_cfdi_types`;
CREATE TABLE `fcf_cfdi_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_cfdi_types
-- ----------------------------
INSERT INTO `fcf_cfdi_types` VALUES ('1', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '2', '40', 'Ingreso', 'I', '1', '1');
INSERT INTO `fcf_cfdi_types` VALUES ('2', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '42', '40', 'Egreso', 'E', '2', '1');
INSERT INTO `fcf_cfdi_types` VALUES ('3', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '9', '39', 'Pago', 'P', '3', '1');
INSERT INTO `fcf_cfdi_types` VALUES ('4', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '1', '1', 'Traslado', 'T', '4', '1');
INSERT INTO `fcf_cfdi_types` VALUES ('5', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '2', '40', 'Nómina', 'N', '5', '1');

-- ----------------------------
-- Table structure for fcf_cfdi_uses
-- ----------------------------
DROP TABLE IF EXISTS `fcf_cfdi_uses`;
CREATE TABLE `fcf_cfdi_uses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_cfdi_uses
-- ----------------------------
INSERT INTO `fcf_cfdi_uses` VALUES ('1', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '9', '40', 'Adquisición de mercancias', 'G01', '1', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('2', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '8', '39', 'Devoluciones, descuentos o bonificaciones', 'G02', '2', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('3', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '42', '9', 'Gastos en general', 'G03', '3', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('4', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '2', '42', 'Construcciones', 'I01', '4', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('5', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '40', '9', 'Mobilario y equipo de oficina por inversiones', 'I02', '5', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('6', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '2', '39', 'Equipo de transporte', 'I03', '6', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('7', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '39', '9', 'Equipo de computo y accesorios', 'I04', '7', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('8', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '39', '2', 'Dados, troqueles, moldes, matrices y herramental', 'I05', '8', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('9', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '39', '1', 'Comunicaciones telefónicas', 'I06', '9', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('10', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '9', '2', 'Comunicaciones satelitales', 'I07', '10', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('11', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '40', '40', 'Otra maquinaria y equipo', 'I08', '11', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('12', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '39', '9', 'Honorarios médicos, dentales y gastos hospitalarios.', 'D01', '12', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('13', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '39', '42', 'Gastos médicos por incapacidad o discapacidad', 'D02', '13', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('14', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '42', '1', 'Gastos funerales', 'D03', '14', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('15', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '39', '9', 'Donativos', 'D04', '15', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('16', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '42', '1', 'Intereses reales efectivamente pagados por créditos hipotecarios (casa habitación)', 'D05', '16', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('17', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '42', '2', 'Aportaciones voluntarias al SAR', 'D06', '17', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('18', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '40', '2', 'Primas por seguros de gastos médicos', 'D07', '18', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('19', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '42', '39', 'Gastos de transportación escolar obligatoria', 'D08', '19', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('20', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '40', '42', 'Depósitos en cuentas para el ahorro, primas que tengan como base planes de pensiones', 'D09', '20', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('21', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '2', '9', 'Pagos por servicios educativos (colegiaturas)', 'D10', '21', '1');
INSERT INTO `fcf_cfdi_uses` VALUES ('22', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '39', '2', 'Por definir', 'P01', '22', '1');

-- ----------------------------
-- Table structure for fcf_cities
-- ----------------------------
DROP TABLE IF EXISTS `fcf_cities`;
CREATE TABLE `fcf_cities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state_id` int(10) unsigned DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `code` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `cities_state_id_foreign` (`state_id`),
  CONSTRAINT `cities_state_id_foreign` FOREIGN KEY (`state_id`) REFERENCES `fcf_states` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2459 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_cities
-- ----------------------------
INSERT INTO `fcf_cities` VALUES ('1', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Aguascalientes', '1', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('2', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ensenada', '2', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('3', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Comondú', '3', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('4', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Calkiní', '4', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('5', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Abasolo', '7', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('6', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Armería', '8', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('7', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ahumada', '6', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('8', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acacoyagua', '5', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('9', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Canatlán', '10', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('10', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acapulco de Juárez', '12', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('11', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Abasolo', '11', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('12', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acatlán', '13', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('13', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acatic', '14', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('14', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acambay de Ruíz Castañeda', '15', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('15', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acuitzio', '16', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('16', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Amacuzac', '17', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('17', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acaponeta', '18', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('18', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Abasolo', '19', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('19', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Abejones', '20', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('20', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acajete', '21', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('21', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Amealco de Bonfil', '22', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('22', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cozumel', '23', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('23', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ahome', '25', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('24', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ahualulco', '24', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('25', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Aconchi', '26', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('26', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Balancán', '27', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('27', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Abasolo', '28', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('28', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Amaxac de Guerrero', '29', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('29', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acajete', '30', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('30', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Abalá', '31', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('31', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Apozol', '32', '0', '1', '001');
INSERT INTO `fcf_cities` VALUES ('32', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Asientos', '1', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('33', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mexicali', '2', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('34', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mulegé', '3', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('35', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Campeche', '4', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('36', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acuña', '7', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('37', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Colima', '8', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('38', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Aldama', '6', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('39', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acala', '5', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('40', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Azcapotzalco', '9', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('41', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Canelas', '10', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('42', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ahuacuotzingo', '12', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('43', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acámbaro', '11', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('44', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acaxochitlán', '13', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('45', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acatlán de Juárez', '14', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('46', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acolman', '15', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('47', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Aguililla', '16', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('48', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atlatlahucan', '17', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('49', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ahuacatlán', '18', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('50', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Agualeguas', '19', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('51', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acatlán de Pérez Figueroa', '20', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('52', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acateno', '21', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('53', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pinal de Amoles', '22', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('54', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Felipe Carrillo Puerto', '23', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('55', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Angostura', '25', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('56', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Alaquines', '24', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('57', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Agua Prieta', '26', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('58', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cárdenas', '27', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('59', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Aldama', '28', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('60', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Apetatitlán de Antonio Carvajal', '29', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('61', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acatlán', '30', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('62', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acanceh', '31', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('63', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Apulco', '32', '0', '1', '002');
INSERT INTO `fcf_cities` VALUES ('64', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Calvillo', '1', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('65', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tecate', '2', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('66', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Paz', '3', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('67', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Carmen', '4', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('68', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Allende', '7', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('69', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Comala', '8', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('70', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Allende', '6', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('71', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acapetahua', '5', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('72', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coyoacán', '9', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('73', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coneto de Comonfort', '10', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('74', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ajuchitlán del Progreso', '12', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('75', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel de Allende', '11', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('76', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Actopan', '13', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('77', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ahualulco de Mercado', '14', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('78', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Aculco', '15', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('79', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Álvaro Obregón', '16', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('80', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Axochiapan', '17', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('81', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Amatlán de Cañas', '18', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('82', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Los Aldamas', '19', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('83', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Asunción Cacalotepec', '20', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('84', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acatlán', '21', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('85', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Arroyo Seco', '22', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('86', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Isla Mujeres', '23', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('87', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Badiraguato', '25', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('88', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Aquismón', '24', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('89', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Alamos', '26', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('90', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Centla', '27', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('91', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Altamira', '28', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('92', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atlangatepec', '29', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('93', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acayucan', '30', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('94', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Akil', '31', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('95', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atolinga', '32', '0', '1', '003');
INSERT INTO `fcf_cities` VALUES ('96', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cosío', '1', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('97', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tijuana', '2', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('98', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Champotón', '4', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('99', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Arteaga', '7', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('100', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coquimatlán', '8', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('101', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Aquiles Serdán', '6', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('102', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Altamirano', '5', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('103', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuajimalpa de Morelos', '9', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('104', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuencamé', '10', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('105', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Alcozauca de Guerrero', '12', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('106', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Apaseo el Alto', '11', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('107', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Agua Blanca de Iturbide', '13', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('108', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Amacueca', '14', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('109', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Almoloya de Alquisiras', '15', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('110', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Angamacutiro', '16', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('111', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ayala', '17', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('112', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Compostela', '18', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('113', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Allende', '19', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('114', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Asunción Cuyotepeji', '20', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('115', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acatzingo', '21', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('116', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cadereyta de Montes', '22', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('117', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Othón P. Blanco', '23', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('118', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Concordia', '25', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('119', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Armadillo de los Infante', '24', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('120', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Altar', '26', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('121', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Centro', '27', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('122', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Antiguo Morelos', '28', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('123', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atltzayanca', '29', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('124', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Actopan', '30', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('125', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Baca', '31', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('126', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Benito Juárez', '32', '0', '1', '004');
INSERT INTO `fcf_cities` VALUES ('127', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jesús María', '1', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('128', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Playas de Rosarito', '2', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('129', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hecelchakán', '4', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('130', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Candela', '7', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('131', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuauhtémoc', '8', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('132', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ascensión', '6', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('133', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Amatán', '5', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('134', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Gustavo A. Madero', '9', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('135', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Durango', '10', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('136', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Alpoyeca', '12', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('137', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Apaseo el Grande', '11', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('138', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ajacuba', '13', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('139', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Amatitán', '14', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('140', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Almoloya de Juárez', '15', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('141', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Angangueo', '16', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('142', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coatlán del Río', '17', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('143', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huajicori', '18', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('144', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Anáhuac', '19', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('145', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Asunción Ixtaltepec', '20', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('146', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acteopan', '21', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('147', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Colón', '22', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('148', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Benito Juárez', '23', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('149', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cosalá', '25', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('150', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cárdenas', '24', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('151', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Arivechi', '26', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('152', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Comalcalco', '27', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('153', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Burgos', '28', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('154', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Apizaco', '29', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('155', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acula', '30', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('156', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Bokobá', '31', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('157', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Calera', '32', '0', '1', '005');
INSERT INTO `fcf_cities` VALUES ('158', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pabellón de Arteaga', '1', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('159', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hopelchén', '4', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('160', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Castaños', '7', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('161', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixtlahuacán', '8', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('162', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Bachíniva', '6', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('163', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Amatenango de la Frontera', '5', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('164', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Iztacalco', '9', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('165', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'General Simón Bolívar', '10', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('166', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Apaxtla', '12', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('167', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atarjea', '11', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('168', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Alfajayucan', '13', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('169', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ameca', '14', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('170', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Almoloya del Río', '15', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('171', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Apatzingán', '16', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('172', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuautla', '17', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('173', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixtlán del Río', '18', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('174', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Apodaca', '19', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('175', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Asunción Nochixtlán', '20', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('176', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ahuacatlán', '21', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('177', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Corregidora', '22', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('178', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'José María Morelos', '23', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('179', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Culiacán', '25', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('180', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Catorce', '24', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('181', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Arizpe', '26', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('182', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cunduacán', '27', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('183', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Bustamante', '28', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('184', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Calpulalpan', '29', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('185', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acultzingo', '30', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('186', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Buctzotz', '31', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('187', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cañitas de Felipe Pescador', '32', '0', '1', '006');
INSERT INTO `fcf_cities` VALUES ('188', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Rincón de Romos', '1', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('189', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Palizada', '4', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('190', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuatro Ciénegas', '7', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('191', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Manzanillo', '8', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('192', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Balleza', '6', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('193', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Amatenango del Valle', '5', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('194', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Iztapalapa', '9', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('195', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Gómez Palacio', '10', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('196', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Arcelia', '12', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('197', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Celaya', '11', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('198', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Almoloya', '13', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('199', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juanito de Escobedo', '14', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('200', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Amanalco', '15', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('201', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Aporo', '16', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('202', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuernavaca', '17', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('203', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jala', '18', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('204', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Aramberri', '19', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('205', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Asunción Ocotlán', '20', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('206', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ahuatlán', '21', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('207', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ezequiel Montes', '22', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('208', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Lázaro Cárdenas', '23', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('209', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Choix', '25', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('210', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cedral', '24', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('211', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atil', '26', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('212', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Emiliano Zapata', '27', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('213', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Camargo', '28', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('214', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Carmen Tequexquitla', '29', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('215', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Camarón de Tejeda', '30', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('216', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cacalchén', '31', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('217', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Concepción del Oro', '32', '0', '1', '007');
INSERT INTO `fcf_cities` VALUES ('218', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San José de Gracia', '1', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('219', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Los Cabos', '3', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('220', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tenabo', '4', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('221', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Escobedo', '7', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('222', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Minatitlán', '8', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('223', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Batopilas', '6', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('224', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Angel Albino Corzo', '5', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('225', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Magdalena Contreras', '9', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('226', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guadalupe Victoria', '10', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('227', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atenango del Río', '12', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('228', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Manuel Doblado', '11', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('229', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Apan', '13', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('230', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Arandas', '14', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('231', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Amatepec', '15', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('232', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Aquila', '16', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('233', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Emiliano Zapata', '17', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('234', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xalisco', '18', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('235', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Bustamante', '19', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('236', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Asunción Tlacolulita', '20', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('237', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ahuazotepec', '21', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('238', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huimilpan', '22', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('239', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Solidaridad', '23', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('240', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Elota', '25', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('241', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cerritos', '24', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('242', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Bacadéhuachi', '26', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('243', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huimanguillo', '27', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('244', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Casas', '28', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('245', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuapiaxtla', '29', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('246', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Alpatláhuac', '30', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('247', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Calotmul', '31', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('248', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuauhtémoc', '32', '0', '1', '008');
INSERT INTO `fcf_cities` VALUES ('249', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepezalá', '1', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('250', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Loreto', '3', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('251', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Escárcega', '4', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('252', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Francisco I. Madero', '7', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('253', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tecomán', '8', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('254', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Bocoyna', '6', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('255', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Arriaga', '5', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('256', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Milpa Alta', '9', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('257', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guanaceví', '10', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('258', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atlamajalcingo del Monte', '12', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('259', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Comonfort', '11', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('260', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Arenal', '13', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('261', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Arenal', '14', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('262', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Amecameca', '15', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('263', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ario', '16', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('264', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huitzilac', '17', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('265', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Del Nayar', '18', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('266', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cadereyta Jiménez', '19', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('267', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ayotzintepec', '20', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('268', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ahuehuetitla', '21', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('269', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jalpan de Serra', '22', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('270', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tulum', '23', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('271', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Escuinapa', '25', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('272', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cerro de San Pedro', '24', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('273', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Bacanora', '26', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('274', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jalapa', '27', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('275', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ciudad Madero', '28', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('276', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuaxomulco', '29', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('277', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Alto Lucero de Gutiérrez Barrios', '30', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('278', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cansahcab', '31', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('279', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chalchihuites', '32', '0', '1', '009');
INSERT INTO `fcf_cities` VALUES ('280', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Llano', '1', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('281', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Calakmul', '4', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('282', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Frontera', '7', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('283', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa de Álvarez', '8', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('284', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Buenaventura', '6', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('285', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Bejucal de Ocampo', '5', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('286', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Álvaro Obregón', '9', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('287', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hidalgo', '10', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('288', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atlixtac', '12', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('289', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coroneo', '11', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('290', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atitalaquia', '13', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('291', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atemajac de Brizuela', '14', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('292', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Apaxco', '15', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('293', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Arteaga', '16', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('294', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jantetelco', '17', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('295', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Rosamorada', '18', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('296', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Carmen', '19', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('297', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Barrio de la Soledad', '20', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('298', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ajalpan', '21', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('299', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Landa de Matamoros', '22', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('300', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Bacalar', '23', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('301', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Fuerte', '25', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('302', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ciudad del Maíz', '24', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('303', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Bacerac', '26', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('304', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jalpa de Méndez', '27', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('305', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cruillas', '28', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('306', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chiautempan', '29', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('307', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Altotonga', '30', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('308', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cantamayec', '31', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('309', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Fresnillo', '32', '0', '1', '010');
INSERT INTO `fcf_cities` VALUES ('310', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco de los Romo', '1', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('311', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Candelaria', '4', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('312', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'General Cepeda', '7', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('313', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Camargo', '6', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('314', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Bella Vista', '5', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('315', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tláhuac', '9', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('316', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Indé', '10', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('317', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atoyac de Álvarez', '12', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('318', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cortazar', '11', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('319', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atlapexco', '13', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('320', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atengo', '14', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('321', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atenco', '15', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('322', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Briseñas', '16', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('323', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jiutepec', '17', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('324', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ruíz', '18', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('325', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cerralvo', '19', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('326', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Calihualá', '20', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('327', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Albino Zertuche', '21', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('328', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Marqués', '22', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('329', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Puerto Morelos', '23', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('330', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guasave', '25', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('331', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ciudad Fernández', '24', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('332', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Bacoachi', '26', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('333', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jonuta', '27', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('334', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Gómez Farías', '28', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('335', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Muñoz de Domingo Arenas', '29', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('336', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Alvarado', '30', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('337', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Celestún', '31', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('338', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Trinidad García de la Cadena', '32', '0', '1', '011');
INSERT INTO `fcf_cities` VALUES ('339', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guerrero', '7', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('340', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Carichí', '6', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('341', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Berriozábal', '5', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('342', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlalpan', '9', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('343', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Lerdo', '10', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('344', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ayutla de los Libres', '12', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('345', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuerámaro', '11', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('346', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atotonilco el Grande', '13', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('347', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atenguillo', '14', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('348', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atizapán', '15', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('349', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Buenavista', '16', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('350', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jojutla', '17', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('351', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Blas', '18', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('352', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ciénega de Flores', '19', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('353', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Candelaria Loxicha', '20', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('354', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Aljojuca', '21', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('355', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pedro Escobedo', '22', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('356', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mazatlán', '25', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('357', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tancanhuitz', '24', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('358', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Bácum', '26', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('359', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Macuspana', '27', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('360', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'González', '28', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('361', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Españita', '29', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('362', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Amatitlán', '30', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('363', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cenotillo', '31', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('364', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Genaro Codina', '32', '0', '1', '012');
INSERT INTO `fcf_cities` VALUES ('365', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hidalgo', '7', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('366', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Casas Grandes', '6', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('367', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Bochil', '5', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('368', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xochimilco', '9', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('369', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mapimí', '10', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('370', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Azoyú', '12', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('371', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Doctor Mora', '11', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('372', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atotonilco de Tula', '13', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('373', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atotonilco el Alto', '14', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('374', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atizapán de Zaragoza', '15', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('375', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Carácuaro', '16', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('376', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jonacatepec', '17', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('377', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Lagunillas', '18', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('378', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'China', '19', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('379', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ciénega de Zimatlán', '20', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('380', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Altepexi', '21', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('381', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Peñamiller', '22', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('382', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mocorito', '25', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('383', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ciudad Valles', '24', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('384', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Banámichi', '26', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('385', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nacajuca', '27', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('386', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Güémez', '28', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('387', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huamantla', '29', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('388', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Naranjos Amatlán', '30', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('389', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Conkal', '31', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('390', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'General Enrique Estrada', '32', '0', '1', '013');
INSERT INTO `fcf_cities` VALUES ('391', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jiménez', '7', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('392', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coronado', '6', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('393', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Bosque', '5', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('394', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Benito Juárez', '9', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('395', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mezquital', '10', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('396', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Benito Juárez', '12', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('397', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Dolores Hidalgo Cuna de la Independencia Nacional', '11', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('398', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Calnali', '13', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('399', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atoyac', '14', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('400', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atlacomulco', '15', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('401', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coahuayana', '16', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('402', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mazatepec', '17', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('403', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María del Oro', '18', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('404', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Doctor Arroyo', '19', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('405', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ciudad Ixtepec', '20', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('406', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Amixtlán', '21', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('407', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Querétaro', '22', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('408', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Rosario', '25', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('409', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coxcatlán', '24', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('410', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Baviácora', '26', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('411', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Paraíso', '27', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('412', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guerrero', '28', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('413', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hueyotlipan', '29', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('414', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Amatlán de los Reyes', '30', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('415', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuncunul', '31', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('416', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'General Francisco R. Murguía', '32', '0', '1', '014');
INSERT INTO `fcf_cities` VALUES ('417', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Juárez', '7', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('418', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coyame del Sotol', '6', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('419', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cacahoatán', '5', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('420', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuauhtémoc', '9', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('421', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nazas', '10', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('422', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Buenavista de Cuéllar', '12', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('423', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guanajuato', '11', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('424', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cardonal', '13', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('425', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Autlán de Navarro', '14', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('426', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atlautla', '15', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('427', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coalcomán de Vázquez Pallares', '16', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('428', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Miacatlán', '17', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('429', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Ixcuintla', '18', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('430', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Doctor Coss', '19', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('431', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coatecas Altas', '20', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('432', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Amozoc', '21', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('433', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Joaquín', '22', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('434', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Salvador Alvarado', '25', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('435', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Charcas', '24', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('436', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Bavispe', '26', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('437', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tacotalpa', '27', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('438', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Gustavo Díaz Ordaz', '28', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('439', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixtacuixtla de Mariano Matamoros', '29', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('440', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Angel R. Cabada', '30', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('441', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuzamá', '31', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('442', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Plateado de Joaquín Amaro', '32', '0', '1', '015');
INSERT INTO `fcf_cities` VALUES ('443', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Lamadrid', '7', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('444', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Cruz', '6', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('445', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Catazajá', '5', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('446', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Miguel Hidalgo', '9', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('447', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nombre de Dios', '10', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('448', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coahuayutla de José María Izazaga', '12', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('449', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huanímaro', '11', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('450', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuautepec de Hinojosa', '13', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('451', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ayotlán', '14', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('452', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Axapusco', '15', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('453', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coeneo', '16', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('454', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ocuituco', '17', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('455', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tecuala', '18', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('456', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Doctor González', '19', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('457', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coicoyán de las Flores', '20', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('458', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Aquixtla', '21', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('459', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan del Río', '22', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('460', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Ignacio', '25', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('461', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ebano', '24', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('462', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Benjamín Hill', '26', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('463', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teapa', '27', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('464', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hidalgo', '28', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('465', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixtenco', '29', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('466', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Antigua', '30', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('467', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chacsinkín', '31', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('468', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'General Pánfilo Natera', '32', '0', '1', '016');
INSERT INTO `fcf_cities` VALUES ('469', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Matamoros', '7', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('470', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuauhtémoc', '6', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('471', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cintalapa', '5', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('472', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Venustiano Carranza', '9', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('473', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ocampo', '10', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('474', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cocula', '12', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('475', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Irapuato', '11', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('476', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chapantongo', '13', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('477', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ayutla', '14', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('478', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ayapango', '15', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('479', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Contepec', '16', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('480', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Puente de Ixtla', '17', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('481', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepic', '18', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('482', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Galeana', '19', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('483', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Compañía', '20', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('484', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atempan', '21', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('485', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tequisquiapan', '22', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('486', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sinaloa', '25', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('487', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guadalcázar', '24', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('488', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Caborca', '26', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('489', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tenosique', '27', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('490', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jaumave', '28', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('491', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mazatecochco de José María Morelos', '29', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('492', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Apazapan', '30', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('493', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chankom', '31', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('494', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guadalupe', '32', '0', '1', '017');
INSERT INTO `fcf_cities` VALUES ('495', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Monclova', '7', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('496', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cusihuiriachi', '6', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('497', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coapilla', '5', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('498', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Oro', '10', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('499', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Copala', '12', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('500', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jaral del Progreso', '11', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('501', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chapulhuacán', '13', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('502', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Barca', '14', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('503', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Calimaya', '15', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('504', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Copándaro', '16', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('505', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Temixco', '17', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('506', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tuxpan', '18', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('507', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'García', '19', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('508', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Concepción Buenavista', '20', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('509', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atexcal', '21', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('510', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tolimán', '22', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('511', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Navolato', '25', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('512', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huehuetlán', '24', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('513', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cajeme', '26', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('514', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jiménez', '28', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('515', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Contla de Juan Cuamatzi', '29', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('516', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Aquila', '30', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('517', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chapab', '31', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('518', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huanusco', '32', '0', '1', '018');
INSERT INTO `fcf_cities` VALUES ('519', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Morelos', '7', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('520', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chihuahua', '6', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('521', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Comitán de Domínguez', '5', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('522', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Otáez', '10', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('523', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Copalillo', '12', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('524', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jerécuaro', '11', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('525', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chilcuautla', '13', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('526', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Bolaños', '14', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('527', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Capulhuac', '15', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('528', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cotija', '16', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('529', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepalcingo', '17', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('530', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Yesca', '18', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('531', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Garza García', '19', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('532', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Concepción Pápalo', '20', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('533', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atlixco', '21', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('534', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Lagunillas', '24', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('535', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cananea', '26', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('536', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Llera', '28', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('537', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepetitla de Lardizábal', '29', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('538', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Astacinga', '30', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('539', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chemax', '31', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('540', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jalpa', '32', '0', '1', '019');
INSERT INTO `fcf_cities` VALUES ('541', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Múzquiz', '7', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('542', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chínipas', '6', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('543', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Concordia', '5', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('544', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pánuco de Coronado', '10', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('545', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Copanatoyac', '12', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('546', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'León', '11', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('547', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Eloxochitlán', '13', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('548', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cabo Corrientes', '14', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('549', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coacalco de Berriozábal', '15', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('550', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuitzeo', '16', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('551', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepoztlán', '17', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('552', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Bahía de Banderas', '18', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('553', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'General Bravo', '19', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('554', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Constancia del Rosario', '20', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('555', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atoyatempan', '21', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('556', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Matehuala', '24', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('557', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Carbó', '26', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('558', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mainero', '28', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('559', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sanctórum de Lázaro Cárdenas', '29', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('560', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atlahuilco', '30', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('561', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chicxulub Pueblo', '31', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('562', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jerez', '32', '0', '1', '020');
INSERT INTO `fcf_cities` VALUES ('563', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nadadores', '7', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('564', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Delicias', '6', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('565', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Copainalá', '5', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('566', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Peñón Blanco', '10', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('567', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coyuca de Benítez', '12', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('568', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Moroleón', '11', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('569', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Emiliano Zapata', '13', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('570', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Casimiro Castillo', '14', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('571', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coatepec Harinas', '15', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('572', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Charapan', '16', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('573', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tetecala', '17', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('574', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'General Escobedo', '19', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('575', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cosolapa', '20', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('576', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atzala', '21', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('577', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mexquitic de Carmona', '24', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('578', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Colorada', '26', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('579', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Mante', '28', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('580', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nanacamilpa de Mariano Arista', '29', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('581', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atoyac', '30', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('582', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chichimilá', '31', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('583', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jiménez del Teul', '32', '0', '1', '021');
INSERT INTO `fcf_cities` VALUES ('584', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nava', '7', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('585', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Dr. Belisario Domínguez', '6', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('586', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chalchihuitán', '5', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('587', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Poanas', '10', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('588', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coyuca de Catalán', '12', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('589', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ocampo', '11', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('590', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Epazoyucan', '13', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('591', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cihuatlán', '14', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('592', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cocotitlán', '15', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('593', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Charo', '16', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('594', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tetela del Volcán', '17', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('595', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'General Terán', '19', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('596', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cosoltepec', '20', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('597', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atzitzihuacán', '21', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('598', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Moctezuma', '24', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('599', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cucurpe', '26', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('600', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Matamoros', '28', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('601', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acuamanala de Miguel Hidalgo', '29', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('602', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atzacan', '30', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('603', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chikindzonot', '31', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('604', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Juan Aldama', '32', '0', '1', '022');
INSERT INTO `fcf_cities` VALUES ('605', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ocampo', '7', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('606', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Galeana', '6', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('607', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chamula', '5', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('608', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pueblo Nuevo', '10', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('609', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuajinicuilapa', '12', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('610', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pénjamo', '11', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('611', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Francisco I. Madero', '13', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('612', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zapotlán el Grande', '14', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('613', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coyotepec', '15', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('614', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chavinda', '16', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('615', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlalnepantla', '17', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('616', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'General Treviño', '19', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('617', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuilápam de Guerrero', '20', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('618', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atzitzintla', '21', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('619', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Rayón', '24', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('620', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cumpas', '26', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('621', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Méndez', '28', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('622', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Natívitas', '29', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('623', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atzalan', '30', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('624', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chocholá', '31', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('625', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Juchipila', '32', '0', '1', '023');
INSERT INTO `fcf_cities` VALUES ('626', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Parras', '7', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('627', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Isabel', '6', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('628', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chanal', '5', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('629', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Rodeo', '10', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('630', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cualác', '12', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('631', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pueblo Nuevo', '11', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('632', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huasca de Ocampo', '13', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('633', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cocula', '14', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('634', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuautitlán', '15', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('635', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cherán', '16', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('636', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlaltizapán de Zapata', '17', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('637', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'General Zaragoza', '19', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('638', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuyamecalco Villa de Zaragoza', '20', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('639', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Axutla', '21', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('640', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Rioverde', '24', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('641', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Divisaderos', '26', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('642', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mier', '28', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('643', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Panotla', '29', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('644', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlaltetela', '30', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('645', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chumayel', '31', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('646', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Loreto', '32', '0', '1', '024');
INSERT INTO `fcf_cities` VALUES ('647', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Piedras Negras', '7', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('648', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Gómez Farías', '6', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('649', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chapultenango', '5', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('650', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Bernardo', '10', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('651', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuautepec', '12', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('652', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Purísima del Rincón', '11', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('653', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huautla', '13', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('654', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Colotlán', '14', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('655', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chalco', '15', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('656', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chilchota', '16', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('657', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlaquiltenango', '17', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('658', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'General Zuazua', '19', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('659', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chahuites', '20', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('660', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ayotoxco de Guerrero', '21', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('661', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Salinas', '24', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('662', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Empalme', '26', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('663', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Miguel Alemán', '28', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('664', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pablo del Monte', '29', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('665', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ayahualulco', '30', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('666', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Dzán', '31', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('667', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Luis Moya', '32', '0', '1', '025');
INSERT INTO `fcf_cities` VALUES ('668', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Progreso', '7', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('669', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Gran Morelos', '6', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('670', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chenalhó', '5', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('671', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Dimas', '10', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('672', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuetzala del Progreso', '12', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('673', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Romita', '11', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('674', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huazalingo', '13', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('675', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Concepción de Buenos Aires', '14', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('676', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chapa de Mota', '15', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('677', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chinicuila', '16', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('678', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlayacapan', '17', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('679', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guadalupe', '19', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('680', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chalcatongo de Hidalgo', '20', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('681', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Calpan', '21', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('682', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Antonio', '24', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('683', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Etchojoa', '26', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('684', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Miquihuana', '28', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('685', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Cruz Tlaxcala', '29', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('686', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Banderilla', '30', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('687', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Dzemul', '31', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('688', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mazapil', '32', '0', '1', '026');
INSERT INTO `fcf_cities` VALUES ('689', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ramos Arizpe', '7', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('690', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guachochi', '6', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('691', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chiapa de Corzo', '5', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('692', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan de Guadalupe', '10', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('693', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cutzamala de Pinzón', '12', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('694', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Salamanca', '11', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('695', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huehuetla', '13', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('696', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuautitlán de García Barragán', '14', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('697', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chapultepec', '15', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('698', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chucándiro', '16', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('699', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Totolapan', '17', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('700', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Los Herreras', '19', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('701', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chiquihuitlán de Benito Juárez', '20', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('702', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Caltepec', '21', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('703', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Ciro de Acosta', '24', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('704', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Fronteras', '26', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('705', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nuevo Laredo', '28', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('706', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tenancingo', '29', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('707', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Benito Juárez', '30', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('708', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Dzidzantún', '31', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('709', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Melchor Ocampo', '32', '0', '1', '027');
INSERT INTO `fcf_cities` VALUES ('710', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sabinas', '7', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('711', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guadalupe', '6', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('712', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chiapilla', '5', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('713', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan del Río', '10', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('714', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chilapa de Álvarez', '12', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('715', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Salvatierra', '11', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('716', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huejutla de Reyes', '13', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('717', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuautla', '14', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('718', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chiautla', '15', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('719', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Churintzio', '16', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('720', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xochitepec', '17', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('721', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Higueras', '19', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('722', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Heroica Ciudad de Ejutla de Crespo', '20', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('723', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Camocuautla', '21', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('724', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Luis Potosí', '24', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('725', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Granados', '26', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('726', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nuevo Morelos', '28', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('727', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teolocholco', '29', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('728', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Boca del Río', '30', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('729', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Dzilam de Bravo', '31', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('730', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mezquital del Oro', '32', '0', '1', '028');
INSERT INTO `fcf_cities` VALUES ('731', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sacramento', '7', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('732', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guadalupe y Calvo', '6', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('733', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chicoasén', '5', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('734', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Luis del Cordero', '10', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('735', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chilpancingo de los Bravo', '12', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('736', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Diego de la Unión', '11', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('737', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huichapan', '13', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('738', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuquío', '14', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('739', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chicoloapan', '15', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('740', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Churumuco', '16', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('741', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yautepec', '17', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('742', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hualahuises', '19', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('743', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Eloxochitlán de Flores Magón', '20', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('744', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Caxhuacan', '21', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('745', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Martín Chalchicuautla', '24', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('746', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guaymas', '26', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('747', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ocampo', '28', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('748', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepeyanco', '29', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('749', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Calcahualco', '30', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('750', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Dzilam González', '31', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('751', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Miguel Auza', '32', '0', '1', '029');
INSERT INTO `fcf_cities` VALUES ('752', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Saltillo', '7', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('753', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guazapares', '6', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('754', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chicomuselo', '5', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('755', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro del Gallo', '10', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('756', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Florencio Villarreal', '12', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('757', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Felipe', '11', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('758', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixmiquilpan', '13', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('759', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chapala', '14', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('760', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chiconcuac', '15', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('761', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ecuandureo', '16', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('762', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yecapixtla', '17', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('763', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Iturbide', '19', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('764', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Espinal', '20', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('765', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coatepec', '21', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('766', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Nicolás Tolentino', '24', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('767', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hermosillo', '26', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('768', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Padilla', '28', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('769', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Terrenate', '29', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('770', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Camerino Z. Mendoza', '30', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('771', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Dzitás', '31', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('772', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Momax', '32', '0', '1', '030');
INSERT INTO `fcf_cities` VALUES ('773', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Buenaventura', '7', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('774', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guerrero', '6', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('775', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chilón', '5', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('776', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Clara', '10', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('777', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'General Canuto A. Neri', '12', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('778', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco del Rincón', '11', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('779', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jacala de Ledezma', '13', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('780', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chimaltitán', '14', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('781', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chimalhuacán', '15', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('782', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Epitacio Huerta', '16', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('783', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zacatepec', '17', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('784', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Juárez', '19', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('785', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tamazulápam del Espíritu Santo', '20', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('786', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coatzingo', '21', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('787', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catarina', '24', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('788', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huachinera', '26', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('789', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Palmillas', '28', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('790', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tetla de la Solidaridad', '29', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('791', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Carrillo Puerto', '30', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('792', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Dzoncauich', '31', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('793', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Monte Escobedo', '32', '0', '1', '031');
INSERT INTO `fcf_cities` VALUES ('794', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan de Sabinas', '7', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('795', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hidalgo del Parral', '6', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('796', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Escuintla', '5', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('797', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Papasquiaro', '10', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('798', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'General Heliodoro Castillo', '12', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('799', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San José Iturbide', '11', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('800', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jaltocán', '13', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('801', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chiquilistlán', '14', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('802', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Donato Guerra', '15', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('803', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Erongarícuaro', '16', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('804', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zacualpan', '17', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('805', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Lampazos de Naranjo', '19', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('806', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Fresnillo de Trujano', '20', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('807', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cohetzala', '21', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('808', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María del Río', '24', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('809', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huásabas', '26', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('810', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Reynosa', '28', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('811', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tetlatlahuca', '29', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('812', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Catemaco', '30', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('813', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Espita', '31', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('814', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Morelos', '32', '0', '1', '032');
INSERT INTO `fcf_cities` VALUES ('815', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro', '7', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('816', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huejotitán', '6', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('817', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Francisco León', '5', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('818', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Súchil', '10', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('819', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huamuxtitlán', '12', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('820', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Luis de la Paz', '11', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('821', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Juárez Hidalgo', '13', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('822', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Degollado', '14', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('823', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ecatepec de Morelos', '15', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('824', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Gabriel Zamora', '16', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('825', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Temoac', '17', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('826', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Linares', '19', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('827', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guadalupe Etla', '20', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('828', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cohuecan', '21', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('829', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo', '24', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('830', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huatabampo', '26', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('831', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Río Bravo', '28', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('832', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlaxcala', '29', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('833', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cazones de Herrera', '30', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('834', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Halachó', '31', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('835', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Moyahua de Estrada', '32', '0', '1', '033');
INSERT INTO `fcf_cities` VALUES ('836', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sierra Mojada', '7', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('837', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ignacio Zaragoza', '6', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('838', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Frontera Comalapa', '5', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('839', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tamazula', '10', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('840', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huitzuco de los Figueroa', '12', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('841', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catarina', '11', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('842', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Lolotla', '13', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('843', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ejutla', '14', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('844', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ecatzingo', '15', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('845', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hidalgo', '16', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('846', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Marín', '19', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('847', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guadalupe de Ramírez', '20', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('848', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coronango', '21', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('849', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Vicente Tancuayalab', '24', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('850', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huépac', '26', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('851', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Carlos', '28', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('852', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlaxco', '29', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('853', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cerro Azul', '30', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('854', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hocabá', '31', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('855', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nochistlán de Mejía', '32', '0', '1', '034');
INSERT INTO `fcf_cities` VALUES ('856', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Torreón', '7', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('857', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Janos', '6', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('858', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Frontera Hidalgo', '5', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('859', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepehuanes', '10', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('860', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Iguala de la Independencia', '12', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('861', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Cruz de Juventino Rosas', '11', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('862', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Metepec', '13', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('863', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Encarnación de Díaz', '14', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('864', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huehuetoca', '15', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('865', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Huacana', '16', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('866', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Melchor Ocampo', '19', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('867', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guelatao de Juárez', '20', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('868', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coxcatlán', '21', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('869', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Soledad de Graciano Sánchez', '24', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('870', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Imuris', '26', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('871', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Fernando', '28', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('872', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tocatlán', '29', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('873', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Citlaltépetl', '30', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('874', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hoctún', '31', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('875', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Noria de Ángeles', '32', '0', '1', '035');
INSERT INTO `fcf_cities` VALUES ('876', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Viesca', '7', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('877', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jiménez', '6', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('878', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Grandeza', '5', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('879', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlahualilo', '10', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('880', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Igualapa', '12', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('881', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Maravatío', '11', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('882', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Agustín Metzquititlán', '13', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('883', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Etzatlán', '14', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('884', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hueypoxtla', '15', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('885', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huandacareo', '16', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('886', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mier y Noriega', '19', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('887', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guevea de Humboldt', '20', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('888', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coyomeapan', '21', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('889', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tamasopo', '24', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('890', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Magdalena', '26', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('891', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Nicolás', '28', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('892', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Totolac', '29', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('893', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coacoatzintla', '30', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('894', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Homún', '31', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('895', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ojocaliente', '32', '0', '1', '036');
INSERT INTO `fcf_cities` VALUES ('896', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Unión', '7', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('897', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Juárez', '6', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('898', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huehuetán', '5', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('899', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Topia', '10', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('900', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixcateopan de Cuauhtémoc', '12', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('901', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Silao de la Victoria', '11', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('902', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Metztitlán', '13', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('903', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Grullo', '14', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('904', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huixquilucan', '15', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('905', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huaniqueo', '16', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('906', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mina', '19', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('907', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mesones Hidalgo', '20', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('908', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coyotepec', '21', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('909', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tamazunchale', '24', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('910', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mazatán', '26', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('911', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Soto la Marina', '28', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('912', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ziltlaltépec de Trinidad Sánchez Santos', '29', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('913', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coahuitlán', '30', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('914', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huhí', '31', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('915', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pánuco', '32', '0', '1', '037');
INSERT INTO `fcf_cities` VALUES ('916', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zaragoza', '7', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('917', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Julimes', '6', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('918', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huixtán', '5', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('919', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Vicente Guerrero', '10', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('920', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zihuatanejo de Azueta', '12', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('921', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tarandacuao', '11', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('922', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mineral del Chico', '13', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('923', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guachinango', '14', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('924', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Isidro Fabela', '15', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('925', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huetamo', '16', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('926', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Montemorelos', '19', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('927', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Hidalgo', '20', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('928', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuapiaxtla de Madero', '21', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('929', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tampacán', '24', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('930', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Moctezuma', '26', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('931', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tampico', '28', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('932', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tzompantepec', '29', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('933', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coatepec', '30', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('934', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hunucmá', '31', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('935', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pinos', '32', '0', '1', '038');
INSERT INTO `fcf_cities` VALUES ('936', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'López', '6', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('937', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huitiupán', '5', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('938', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nuevo Ideal', '10', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('939', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Juan R. Escudero', '12', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('940', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tarimoro', '11', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('941', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mineral del Monte', '13', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('942', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guadalajara', '14', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('943', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixtapaluca', '15', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('944', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huiramba', '16', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('945', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Monterrey', '19', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('946', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Heroica Ciudad de Huajuapan de León', '20', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('947', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuautempan', '21', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('948', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tampamolón Corona', '24', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('949', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Naco', '26', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('950', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tula', '28', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('951', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xaloztoc', '29', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('952', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coatzacoalcos', '30', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('953', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixil', '31', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('954', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Río Grande', '32', '0', '1', '039');
INSERT INTO `fcf_cities` VALUES ('955', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Madera', '6', '0', '1', '040');
INSERT INTO `fcf_cities` VALUES ('956', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huixtla', '5', '0', '1', '040');
INSERT INTO `fcf_cities` VALUES ('957', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Leonardo Bravo', '12', '0', '1', '040');
INSERT INTO `fcf_cities` VALUES ('958', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tierra Blanca', '11', '0', '1', '040');
INSERT INTO `fcf_cities` VALUES ('959', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Misión', '13', '0', '1', '040');
INSERT INTO `fcf_cities` VALUES ('960', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hostotipaquillo', '14', '0', '1', '040');
INSERT INTO `fcf_cities` VALUES ('961', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixtapan de la Sal', '15', '0', '1', '040');
INSERT INTO `fcf_cities` VALUES ('962', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Indaparapeo', '16', '0', '1', '040');
INSERT INTO `fcf_cities` VALUES ('963', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Parás', '19', '0', '1', '040');
INSERT INTO `fcf_cities` VALUES ('964', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huautepec', '20', '0', '1', '040');
INSERT INTO `fcf_cities` VALUES ('965', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuautinchán', '21', '0', '1', '040');
INSERT INTO `fcf_cities` VALUES ('966', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tamuín', '24', '0', '1', '040');
INSERT INTO `fcf_cities` VALUES ('967', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nácori Chico', '26', '0', '1', '040');
INSERT INTO `fcf_cities` VALUES ('968', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Valle Hermoso', '28', '0', '1', '040');
INSERT INTO `fcf_cities` VALUES ('969', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xaltocan', '29', '0', '1', '040');
INSERT INTO `fcf_cities` VALUES ('970', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coatzintla', '30', '0', '1', '040');
INSERT INTO `fcf_cities` VALUES ('971', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Izamal', '31', '0', '1', '040');
INSERT INTO `fcf_cities` VALUES ('972', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sain Alto', '32', '0', '1', '040');
INSERT INTO `fcf_cities` VALUES ('973', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Maguarichi', '6', '0', '1', '041');
INSERT INTO `fcf_cities` VALUES ('974', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Independencia', '5', '0', '1', '041');
INSERT INTO `fcf_cities` VALUES ('975', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Malinaltepec', '12', '0', '1', '041');
INSERT INTO `fcf_cities` VALUES ('976', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Uriangato', '11', '0', '1', '041');
INSERT INTO `fcf_cities` VALUES ('977', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mixquiahuala de Juárez', '13', '0', '1', '041');
INSERT INTO `fcf_cities` VALUES ('978', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huejúcar', '14', '0', '1', '041');
INSERT INTO `fcf_cities` VALUES ('979', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixtapan del Oro', '15', '0', '1', '041');
INSERT INTO `fcf_cities` VALUES ('980', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Irimbo', '16', '0', '1', '041');
INSERT INTO `fcf_cities` VALUES ('981', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pesquería', '19', '0', '1', '041');
INSERT INTO `fcf_cities` VALUES ('982', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huautla de Jiménez', '20', '0', '1', '041');
INSERT INTO `fcf_cities` VALUES ('983', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuautlancingo', '21', '0', '1', '041');
INSERT INTO `fcf_cities` VALUES ('984', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tanlajás', '24', '0', '1', '041');
INSERT INTO `fcf_cities` VALUES ('985', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nacozari de García', '26', '0', '1', '041');
INSERT INTO `fcf_cities` VALUES ('986', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Victoria', '28', '0', '1', '041');
INSERT INTO `fcf_cities` VALUES ('987', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Papalotla de Xicohténcatl', '29', '0', '1', '041');
INSERT INTO `fcf_cities` VALUES ('988', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coetzala', '30', '0', '1', '041');
INSERT INTO `fcf_cities` VALUES ('989', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Kanasín', '31', '0', '1', '041');
INSERT INTO `fcf_cities` VALUES ('990', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Salvador', '32', '0', '1', '041');
INSERT INTO `fcf_cities` VALUES ('991', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Manuel Benavides', '6', '0', '1', '042');
INSERT INTO `fcf_cities` VALUES ('992', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixhuatán', '5', '0', '1', '042');
INSERT INTO `fcf_cities` VALUES ('993', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mártir de Cuilapan', '12', '0', '1', '042');
INSERT INTO `fcf_cities` VALUES ('994', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Valle de Santiago', '11', '0', '1', '042');
INSERT INTO `fcf_cities` VALUES ('995', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Molango de Escamilla', '13', '0', '1', '042');
INSERT INTO `fcf_cities` VALUES ('996', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huejuquilla el Alto', '14', '0', '1', '042');
INSERT INTO `fcf_cities` VALUES ('997', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixtlahuaca', '15', '0', '1', '042');
INSERT INTO `fcf_cities` VALUES ('998', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixtlán', '16', '0', '1', '042');
INSERT INTO `fcf_cities` VALUES ('999', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Los Ramones', '19', '0', '1', '042');
INSERT INTO `fcf_cities` VALUES ('1000', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixtlán de Juárez', '20', '0', '1', '042');
INSERT INTO `fcf_cities` VALUES ('1001', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuayuca de Andrade', '21', '0', '1', '042');
INSERT INTO `fcf_cities` VALUES ('1002', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tanquián de Escobedo', '24', '0', '1', '042');
INSERT INTO `fcf_cities` VALUES ('1003', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Navojoa', '26', '0', '1', '042');
INSERT INTO `fcf_cities` VALUES ('1004', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villagrán', '28', '0', '1', '042');
INSERT INTO `fcf_cities` VALUES ('1005', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xicohtzinco', '29', '0', '1', '042');
INSERT INTO `fcf_cities` VALUES ('1006', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Colipa', '30', '0', '1', '042');
INSERT INTO `fcf_cities` VALUES ('1007', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Kantunil', '31', '0', '1', '042');
INSERT INTO `fcf_cities` VALUES ('1008', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sombrerete', '32', '0', '1', '042');
INSERT INTO `fcf_cities` VALUES ('1009', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Matachí', '6', '0', '1', '043');
INSERT INTO `fcf_cities` VALUES ('1010', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixtacomitán', '5', '0', '1', '043');
INSERT INTO `fcf_cities` VALUES ('1011', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Metlatónoc', '12', '0', '1', '043');
INSERT INTO `fcf_cities` VALUES ('1012', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Victoria', '11', '0', '1', '043');
INSERT INTO `fcf_cities` VALUES ('1013', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nicolás Flores', '13', '0', '1', '043');
INSERT INTO `fcf_cities` VALUES ('1014', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Huerta', '14', '0', '1', '043');
INSERT INTO `fcf_cities` VALUES ('1015', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xalatlaco', '15', '0', '1', '043');
INSERT INTO `fcf_cities` VALUES ('1016', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jacona', '16', '0', '1', '043');
INSERT INTO `fcf_cities` VALUES ('1017', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Rayones', '19', '0', '1', '043');
INSERT INTO `fcf_cities` VALUES ('1018', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Heroica Ciudad de Juchitán de Zaragoza', '20', '0', '1', '043');
INSERT INTO `fcf_cities` VALUES ('1019', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuetzalan del Progreso', '21', '0', '1', '043');
INSERT INTO `fcf_cities` VALUES ('1020', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tierra Nueva', '24', '0', '1', '043');
INSERT INTO `fcf_cities` VALUES ('1021', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nogales', '26', '0', '1', '043');
INSERT INTO `fcf_cities` VALUES ('1022', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xicoténcatl', '28', '0', '1', '043');
INSERT INTO `fcf_cities` VALUES ('1023', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yauhquemehcan', '29', '0', '1', '043');
INSERT INTO `fcf_cities` VALUES ('1024', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Comapa', '30', '0', '1', '043');
INSERT INTO `fcf_cities` VALUES ('1025', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Kaua', '31', '0', '1', '043');
INSERT INTO `fcf_cities` VALUES ('1026', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Susticacán', '32', '0', '1', '043');
INSERT INTO `fcf_cities` VALUES ('1027', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Matamoros', '6', '0', '1', '044');
INSERT INTO `fcf_cities` VALUES ('1028', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixtapa', '5', '0', '1', '044');
INSERT INTO `fcf_cities` VALUES ('1029', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mochitlán', '12', '0', '1', '044');
INSERT INTO `fcf_cities` VALUES ('1030', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villagrán', '11', '0', '1', '044');
INSERT INTO `fcf_cities` VALUES ('1031', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nopala de Villagrán', '13', '0', '1', '044');
INSERT INTO `fcf_cities` VALUES ('1032', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixtlahuacán de los Membrillos', '14', '0', '1', '044');
INSERT INTO `fcf_cities` VALUES ('1033', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jaltenco', '15', '0', '1', '044');
INSERT INTO `fcf_cities` VALUES ('1034', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jiménez', '16', '0', '1', '044');
INSERT INTO `fcf_cities` VALUES ('1035', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sabinas Hidalgo', '19', '0', '1', '044');
INSERT INTO `fcf_cities` VALUES ('1036', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Loma Bonita', '20', '0', '1', '044');
INSERT INTO `fcf_cities` VALUES ('1037', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuyoaco', '21', '0', '1', '044');
INSERT INTO `fcf_cities` VALUES ('1038', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Vanegas', '24', '0', '1', '044');
INSERT INTO `fcf_cities` VALUES ('1039', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Onavas', '26', '0', '1', '044');
INSERT INTO `fcf_cities` VALUES ('1040', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zacatelco', '29', '0', '1', '044');
INSERT INTO `fcf_cities` VALUES ('1041', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Córdoba', '30', '0', '1', '044');
INSERT INTO `fcf_cities` VALUES ('1042', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Kinchil', '31', '0', '1', '044');
INSERT INTO `fcf_cities` VALUES ('1043', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tabasco', '32', '0', '1', '044');
INSERT INTO `fcf_cities` VALUES ('1044', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Meoqui', '6', '0', '1', '045');
INSERT INTO `fcf_cities` VALUES ('1045', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixtapangajoya', '5', '0', '1', '045');
INSERT INTO `fcf_cities` VALUES ('1046', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Olinalá', '12', '0', '1', '045');
INSERT INTO `fcf_cities` VALUES ('1047', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xichú', '11', '0', '1', '045');
INSERT INTO `fcf_cities` VALUES ('1048', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Omitlán de Juárez', '13', '0', '1', '045');
INSERT INTO `fcf_cities` VALUES ('1049', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixtlahuacán del Río', '14', '0', '1', '045');
INSERT INTO `fcf_cities` VALUES ('1050', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jilotepec', '15', '0', '1', '045');
INSERT INTO `fcf_cities` VALUES ('1051', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jiquilpan', '16', '0', '1', '045');
INSERT INTO `fcf_cities` VALUES ('1052', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Salinas Victoria', '19', '0', '1', '045');
INSERT INTO `fcf_cities` VALUES ('1053', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Magdalena Apasco', '20', '0', '1', '045');
INSERT INTO `fcf_cities` VALUES ('1054', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chalchicomula de Sesma', '21', '0', '1', '045');
INSERT INTO `fcf_cities` VALUES ('1055', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Venado', '24', '0', '1', '045');
INSERT INTO `fcf_cities` VALUES ('1056', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Opodepe', '26', '0', '1', '045');
INSERT INTO `fcf_cities` VALUES ('1057', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Benito Juárez', '29', '0', '1', '045');
INSERT INTO `fcf_cities` VALUES ('1058', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cosamaloapan de Carpio', '30', '0', '1', '045');
INSERT INTO `fcf_cities` VALUES ('1059', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Kopomá', '31', '0', '1', '045');
INSERT INTO `fcf_cities` VALUES ('1060', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepechitlán', '32', '0', '1', '045');
INSERT INTO `fcf_cities` VALUES ('1061', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Morelos', '6', '0', '1', '046');
INSERT INTO `fcf_cities` VALUES ('1062', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jiquipilas', '5', '0', '1', '046');
INSERT INTO `fcf_cities` VALUES ('1063', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ometepec', '12', '0', '1', '046');
INSERT INTO `fcf_cities` VALUES ('1064', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yuriria', '11', '0', '1', '046');
INSERT INTO `fcf_cities` VALUES ('1065', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Felipe Orizatlán', '13', '0', '1', '046');
INSERT INTO `fcf_cities` VALUES ('1066', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jalostotitlán', '14', '0', '1', '046');
INSERT INTO `fcf_cities` VALUES ('1067', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jilotzingo', '15', '0', '1', '046');
INSERT INTO `fcf_cities` VALUES ('1068', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Juárez', '16', '0', '1', '046');
INSERT INTO `fcf_cities` VALUES ('1069', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Nicolás de los Garza', '19', '0', '1', '046');
INSERT INTO `fcf_cities` VALUES ('1070', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Magdalena Jaltepec', '20', '0', '1', '046');
INSERT INTO `fcf_cities` VALUES ('1071', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chapulco', '21', '0', '1', '046');
INSERT INTO `fcf_cities` VALUES ('1072', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa de Arriaga', '24', '0', '1', '046');
INSERT INTO `fcf_cities` VALUES ('1073', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Oquitoa', '26', '0', '1', '046');
INSERT INTO `fcf_cities` VALUES ('1074', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Emiliano Zapata', '29', '0', '1', '046');
INSERT INTO `fcf_cities` VALUES ('1075', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cosautlán de Carvajal', '30', '0', '1', '046');
INSERT INTO `fcf_cities` VALUES ('1076', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mama', '31', '0', '1', '046');
INSERT INTO `fcf_cities` VALUES ('1077', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepetongo', '32', '0', '1', '046');
INSERT INTO `fcf_cities` VALUES ('1078', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Moris', '6', '0', '1', '047');
INSERT INTO `fcf_cities` VALUES ('1079', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jitotol', '5', '0', '1', '047');
INSERT INTO `fcf_cities` VALUES ('1080', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pedro Ascencio Alquisiras', '12', '0', '1', '047');
INSERT INTO `fcf_cities` VALUES ('1081', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pacula', '13', '0', '1', '047');
INSERT INTO `fcf_cities` VALUES ('1082', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jamay', '14', '0', '1', '047');
INSERT INTO `fcf_cities` VALUES ('1083', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jiquipilco', '15', '0', '1', '047');
INSERT INTO `fcf_cities` VALUES ('1084', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jungapeo', '16', '0', '1', '047');
INSERT INTO `fcf_cities` VALUES ('1085', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hidalgo', '19', '0', '1', '047');
INSERT INTO `fcf_cities` VALUES ('1086', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Magdalena Jicotlán', '20', '0', '1', '047');
INSERT INTO `fcf_cities` VALUES ('1087', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chiautla', '21', '0', '1', '047');
INSERT INTO `fcf_cities` VALUES ('1088', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa de Guadalupe', '24', '0', '1', '047');
INSERT INTO `fcf_cities` VALUES ('1089', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pitiquito', '26', '0', '1', '047');
INSERT INTO `fcf_cities` VALUES ('1090', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Lázaro Cárdenas', '29', '0', '1', '047');
INSERT INTO `fcf_cities` VALUES ('1091', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coscomatepec', '30', '0', '1', '047');
INSERT INTO `fcf_cities` VALUES ('1092', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Maní', '31', '0', '1', '047');
INSERT INTO `fcf_cities` VALUES ('1093', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teúl de González Ortega', '32', '0', '1', '047');
INSERT INTO `fcf_cities` VALUES ('1094', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Namiquipa', '6', '0', '1', '048');
INSERT INTO `fcf_cities` VALUES ('1095', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Juárez', '5', '0', '1', '048');
INSERT INTO `fcf_cities` VALUES ('1096', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Petatlán', '12', '0', '1', '048');
INSERT INTO `fcf_cities` VALUES ('1097', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pachuca de Soto', '13', '0', '1', '048');
INSERT INTO `fcf_cities` VALUES ('1098', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jesús María', '14', '0', '1', '048');
INSERT INTO `fcf_cities` VALUES ('1099', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jocotitlán', '15', '0', '1', '048');
INSERT INTO `fcf_cities` VALUES ('1100', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Lagunillas', '16', '0', '1', '048');
INSERT INTO `fcf_cities` VALUES ('1101', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catarina', '19', '0', '1', '048');
INSERT INTO `fcf_cities` VALUES ('1102', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Magdalena Mixtepec', '20', '0', '1', '048');
INSERT INTO `fcf_cities` VALUES ('1103', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chiautzingo', '21', '0', '1', '048');
INSERT INTO `fcf_cities` VALUES ('1104', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa de la Paz', '24', '0', '1', '048');
INSERT INTO `fcf_cities` VALUES ('1105', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Puerto Peñasco', '26', '0', '1', '048');
INSERT INTO `fcf_cities` VALUES ('1106', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Magdalena Tlaltelulco', '29', '0', '1', '048');
INSERT INTO `fcf_cities` VALUES ('1107', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cosoleacaque', '30', '0', '1', '048');
INSERT INTO `fcf_cities` VALUES ('1108', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Maxcanú', '31', '0', '1', '048');
INSERT INTO `fcf_cities` VALUES ('1109', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlaltenango de Sánchez Román', '32', '0', '1', '048');
INSERT INTO `fcf_cities` VALUES ('1110', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nonoava', '6', '0', '1', '049');
INSERT INTO `fcf_cities` VALUES ('1111', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Larráinzar', '5', '0', '1', '049');
INSERT INTO `fcf_cities` VALUES ('1112', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pilcaya', '12', '0', '1', '049');
INSERT INTO `fcf_cities` VALUES ('1113', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pisaflores', '13', '0', '1', '049');
INSERT INTO `fcf_cities` VALUES ('1114', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jilotlán de los Dolores', '14', '0', '1', '049');
INSERT INTO `fcf_cities` VALUES ('1115', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Joquicingo', '15', '0', '1', '049');
INSERT INTO `fcf_cities` VALUES ('1116', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Madero', '16', '0', '1', '049');
INSERT INTO `fcf_cities` VALUES ('1117', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago', '19', '0', '1', '049');
INSERT INTO `fcf_cities` VALUES ('1118', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Magdalena Ocotlán', '20', '0', '1', '049');
INSERT INTO `fcf_cities` VALUES ('1119', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chiconcuautla', '21', '0', '1', '049');
INSERT INTO `fcf_cities` VALUES ('1120', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa de Ramos', '24', '0', '1', '049');
INSERT INTO `fcf_cities` VALUES ('1121', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Quiriego', '26', '0', '1', '049');
INSERT INTO `fcf_cities` VALUES ('1122', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Damián Texóloc', '29', '0', '1', '049');
INSERT INTO `fcf_cities` VALUES ('1123', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cotaxtla', '30', '0', '1', '049');
INSERT INTO `fcf_cities` VALUES ('1124', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mayapán', '31', '0', '1', '049');
INSERT INTO `fcf_cities` VALUES ('1125', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Valparaíso', '32', '0', '1', '049');
INSERT INTO `fcf_cities` VALUES ('1126', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nuevo Casas Grandes', '6', '0', '1', '050');
INSERT INTO `fcf_cities` VALUES ('1127', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Libertad', '5', '0', '1', '050');
INSERT INTO `fcf_cities` VALUES ('1128', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pungarabato', '12', '0', '1', '050');
INSERT INTO `fcf_cities` VALUES ('1129', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Progreso de Obregón', '13', '0', '1', '050');
INSERT INTO `fcf_cities` VALUES ('1130', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jocotepec', '14', '0', '1', '050');
INSERT INTO `fcf_cities` VALUES ('1131', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Juchitepec', '15', '0', '1', '050');
INSERT INTO `fcf_cities` VALUES ('1132', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Maravatío', '16', '0', '1', '050');
INSERT INTO `fcf_cities` VALUES ('1133', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Vallecillo', '19', '0', '1', '050');
INSERT INTO `fcf_cities` VALUES ('1134', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Magdalena Peñasco', '20', '0', '1', '050');
INSERT INTO `fcf_cities` VALUES ('1135', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chichiquila', '21', '0', '1', '050');
INSERT INTO `fcf_cities` VALUES ('1136', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa de Reyes', '24', '0', '1', '050');
INSERT INTO `fcf_cities` VALUES ('1137', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Rayón', '26', '0', '1', '050');
INSERT INTO `fcf_cities` VALUES ('1138', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco Tetlanohcan', '29', '0', '1', '050');
INSERT INTO `fcf_cities` VALUES ('1139', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coxquihui', '30', '0', '1', '050');
INSERT INTO `fcf_cities` VALUES ('1140', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mérida', '31', '0', '1', '050');
INSERT INTO `fcf_cities` VALUES ('1141', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Vetagrande', '32', '0', '1', '050');
INSERT INTO `fcf_cities` VALUES ('1142', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ocampo', '6', '0', '1', '051');
INSERT INTO `fcf_cities` VALUES ('1143', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mapastepec', '5', '0', '1', '051');
INSERT INTO `fcf_cities` VALUES ('1144', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Quechultenango', '12', '0', '1', '051');
INSERT INTO `fcf_cities` VALUES ('1145', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mineral de la Reforma', '13', '0', '1', '051');
INSERT INTO `fcf_cities` VALUES ('1146', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Juanacatlán', '14', '0', '1', '051');
INSERT INTO `fcf_cities` VALUES ('1147', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Lerma', '15', '0', '1', '051');
INSERT INTO `fcf_cities` VALUES ('1148', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Marcos Castellanos', '16', '0', '1', '051');
INSERT INTO `fcf_cities` VALUES ('1149', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villaldama', '19', '0', '1', '051');
INSERT INTO `fcf_cities` VALUES ('1150', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Magdalena Teitipac', '20', '0', '1', '051');
INSERT INTO `fcf_cities` VALUES ('1151', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chietla', '21', '0', '1', '051');
INSERT INTO `fcf_cities` VALUES ('1152', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Hidalgo', '24', '0', '1', '051');
INSERT INTO `fcf_cities` VALUES ('1153', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Rosario', '26', '0', '1', '051');
INSERT INTO `fcf_cities` VALUES ('1154', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Jerónimo Zacualpan', '29', '0', '1', '051');
INSERT INTO `fcf_cities` VALUES ('1155', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Coyutla', '30', '0', '1', '051');
INSERT INTO `fcf_cities` VALUES ('1156', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mocochá', '31', '0', '1', '051');
INSERT INTO `fcf_cities` VALUES ('1157', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa de Cos', '32', '0', '1', '051');
INSERT INTO `fcf_cities` VALUES ('1158', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ojinaga', '6', '0', '1', '052');
INSERT INTO `fcf_cities` VALUES ('1159', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Las Margaritas', '5', '0', '1', '052');
INSERT INTO `fcf_cities` VALUES ('1160', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Luis Acatlán', '12', '0', '1', '052');
INSERT INTO `fcf_cities` VALUES ('1161', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Agustín Tlaxiaca', '13', '0', '1', '052');
INSERT INTO `fcf_cities` VALUES ('1162', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Juchitlán', '14', '0', '1', '052');
INSERT INTO `fcf_cities` VALUES ('1163', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Malinalco', '15', '0', '1', '052');
INSERT INTO `fcf_cities` VALUES ('1164', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Lázaro Cárdenas', '16', '0', '1', '052');
INSERT INTO `fcf_cities` VALUES ('1165', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Magdalena Tequisistlán', '20', '0', '1', '052');
INSERT INTO `fcf_cities` VALUES ('1166', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chigmecatitlán', '21', '0', '1', '052');
INSERT INTO `fcf_cities` VALUES ('1167', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Juárez', '24', '0', '1', '052');
INSERT INTO `fcf_cities` VALUES ('1168', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sahuaripa', '26', '0', '1', '052');
INSERT INTO `fcf_cities` VALUES ('1169', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San José Teacalco', '29', '0', '1', '052');
INSERT INTO `fcf_cities` VALUES ('1170', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuichapa', '30', '0', '1', '052');
INSERT INTO `fcf_cities` VALUES ('1171', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Motul', '31', '0', '1', '052');
INSERT INTO `fcf_cities` VALUES ('1172', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa García', '32', '0', '1', '052');
INSERT INTO `fcf_cities` VALUES ('1173', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Praxedis G. Guerrero', '6', '0', '1', '053');
INSERT INTO `fcf_cities` VALUES ('1174', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mazapa de Madero', '5', '0', '1', '053');
INSERT INTO `fcf_cities` VALUES ('1175', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Marcos', '12', '0', '1', '053');
INSERT INTO `fcf_cities` VALUES ('1176', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Bartolo Tutotepec', '13', '0', '1', '053');
INSERT INTO `fcf_cities` VALUES ('1177', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Lagos de Moreno', '14', '0', '1', '053');
INSERT INTO `fcf_cities` VALUES ('1178', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Melchor Ocampo', '15', '0', '1', '053');
INSERT INTO `fcf_cities` VALUES ('1179', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Morelia', '16', '0', '1', '053');
INSERT INTO `fcf_cities` VALUES ('1180', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Magdalena Tlacotepec', '20', '0', '1', '053');
INSERT INTO `fcf_cities` VALUES ('1181', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chignahuapan', '21', '0', '1', '053');
INSERT INTO `fcf_cities` VALUES ('1182', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Axtla de Terrazas', '24', '0', '1', '053');
INSERT INTO `fcf_cities` VALUES ('1183', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Felipe de Jesús', '26', '0', '1', '053');
INSERT INTO `fcf_cities` VALUES ('1184', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Huactzinco', '29', '0', '1', '053');
INSERT INTO `fcf_cities` VALUES ('1185', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuitláhuac', '30', '0', '1', '053');
INSERT INTO `fcf_cities` VALUES ('1186', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Muna', '31', '0', '1', '053');
INSERT INTO `fcf_cities` VALUES ('1187', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa González Ortega', '32', '0', '1', '053');
INSERT INTO `fcf_cities` VALUES ('1188', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Riva Palacio', '6', '0', '1', '054');
INSERT INTO `fcf_cities` VALUES ('1189', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mazatán', '5', '0', '1', '054');
INSERT INTO `fcf_cities` VALUES ('1190', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Totolapan', '12', '0', '1', '054');
INSERT INTO `fcf_cities` VALUES ('1191', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Salvador', '13', '0', '1', '054');
INSERT INTO `fcf_cities` VALUES ('1192', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Limón', '14', '0', '1', '054');
INSERT INTO `fcf_cities` VALUES ('1193', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Metepec', '15', '0', '1', '054');
INSERT INTO `fcf_cities` VALUES ('1194', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Morelos', '16', '0', '1', '054');
INSERT INTO `fcf_cities` VALUES ('1195', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Magdalena Zahuatlán', '20', '0', '1', '054');
INSERT INTO `fcf_cities` VALUES ('1196', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chignautla', '21', '0', '1', '054');
INSERT INTO `fcf_cities` VALUES ('1197', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xilitla', '24', '0', '1', '054');
INSERT INTO `fcf_cities` VALUES ('1198', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Javier', '26', '0', '1', '054');
INSERT INTO `fcf_cities` VALUES ('1199', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Lorenzo Axocomanitla', '29', '0', '1', '054');
INSERT INTO `fcf_cities` VALUES ('1200', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chacaltianguis', '30', '0', '1', '054');
INSERT INTO `fcf_cities` VALUES ('1201', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Muxupip', '31', '0', '1', '054');
INSERT INTO `fcf_cities` VALUES ('1202', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Hidalgo', '32', '0', '1', '054');
INSERT INTO `fcf_cities` VALUES ('1203', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Rosales', '6', '0', '1', '055');
INSERT INTO `fcf_cities` VALUES ('1204', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Metapa', '5', '0', '1', '055');
INSERT INTO `fcf_cities` VALUES ('1205', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Taxco de Alarcón', '12', '0', '1', '055');
INSERT INTO `fcf_cities` VALUES ('1206', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago de Anaya', '13', '0', '1', '055');
INSERT INTO `fcf_cities` VALUES ('1207', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Magdalena', '14', '0', '1', '055');
INSERT INTO `fcf_cities` VALUES ('1208', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mexicaltzingo', '15', '0', '1', '055');
INSERT INTO `fcf_cities` VALUES ('1209', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Múgica', '16', '0', '1', '055');
INSERT INTO `fcf_cities` VALUES ('1210', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mariscala de Juárez', '20', '0', '1', '055');
INSERT INTO `fcf_cities` VALUES ('1211', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chila', '21', '0', '1', '055');
INSERT INTO `fcf_cities` VALUES ('1212', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zaragoza', '24', '0', '1', '055');
INSERT INTO `fcf_cities` VALUES ('1213', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Luis Río Colorado', '26', '0', '1', '055');
INSERT INTO `fcf_cities` VALUES ('1214', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Lucas Tecopilco', '29', '0', '1', '055');
INSERT INTO `fcf_cities` VALUES ('1215', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chalma', '30', '0', '1', '055');
INSERT INTO `fcf_cities` VALUES ('1216', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Opichén', '31', '0', '1', '055');
INSERT INTO `fcf_cities` VALUES ('1217', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villanueva', '32', '0', '1', '055');
INSERT INTO `fcf_cities` VALUES ('1218', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Rosario', '6', '0', '1', '056');
INSERT INTO `fcf_cities` VALUES ('1219', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mitontic', '5', '0', '1', '056');
INSERT INTO `fcf_cities` VALUES ('1220', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tecoanapa', '12', '0', '1', '056');
INSERT INTO `fcf_cities` VALUES ('1221', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Tulantepec de Lugo Guerrero', '13', '0', '1', '056');
INSERT INTO `fcf_cities` VALUES ('1222', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María del Oro', '14', '0', '1', '056');
INSERT INTO `fcf_cities` VALUES ('1223', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Morelos', '15', '0', '1', '056');
INSERT INTO `fcf_cities` VALUES ('1224', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nahuatzen', '16', '0', '1', '056');
INSERT INTO `fcf_cities` VALUES ('1225', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mártires de Tacubaya', '20', '0', '1', '056');
INSERT INTO `fcf_cities` VALUES ('1226', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chila de la Sal', '21', '0', '1', '056');
INSERT INTO `fcf_cities` VALUES ('1227', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa de Arista', '24', '0', '1', '056');
INSERT INTO `fcf_cities` VALUES ('1228', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel de Horcasitas', '26', '0', '1', '056');
INSERT INTO `fcf_cities` VALUES ('1229', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Ana Nopalucan', '29', '0', '1', '056');
INSERT INTO `fcf_cities` VALUES ('1230', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chiconamel', '30', '0', '1', '056');
INSERT INTO `fcf_cities` VALUES ('1231', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Oxkutzcab', '31', '0', '1', '056');
INSERT INTO `fcf_cities` VALUES ('1232', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zacatecas', '32', '0', '1', '056');
INSERT INTO `fcf_cities` VALUES ('1233', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco de Borja', '6', '0', '1', '057');
INSERT INTO `fcf_cities` VALUES ('1234', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Motozintla', '5', '0', '1', '057');
INSERT INTO `fcf_cities` VALUES ('1235', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Técpan de Galeana', '12', '0', '1', '057');
INSERT INTO `fcf_cities` VALUES ('1236', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Singuilucan', '13', '0', '1', '057');
INSERT INTO `fcf_cities` VALUES ('1237', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Manzanilla de la Paz', '14', '0', '1', '057');
INSERT INTO `fcf_cities` VALUES ('1238', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Naucalpan de Juárez', '15', '0', '1', '057');
INSERT INTO `fcf_cities` VALUES ('1239', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nocupétaro', '16', '0', '1', '057');
INSERT INTO `fcf_cities` VALUES ('1240', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Matías Romero Avendaño', '20', '0', '1', '057');
INSERT INTO `fcf_cities` VALUES ('1241', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Honey', '21', '0', '1', '057');
INSERT INTO `fcf_cities` VALUES ('1242', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Matlapa', '24', '0', '1', '057');
INSERT INTO `fcf_cities` VALUES ('1243', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro de la Cueva', '26', '0', '1', '057');
INSERT INTO `fcf_cities` VALUES ('1244', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Apolonia Teacalco', '29', '0', '1', '057');
INSERT INTO `fcf_cities` VALUES ('1245', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chiconquiaco', '30', '0', '1', '057');
INSERT INTO `fcf_cities` VALUES ('1246', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Panabá', '31', '0', '1', '057');
INSERT INTO `fcf_cities` VALUES ('1247', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Trancoso', '32', '0', '1', '057');
INSERT INTO `fcf_cities` VALUES ('1248', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco de Conchos', '6', '0', '1', '058');
INSERT INTO `fcf_cities` VALUES ('1249', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nicolás Ruíz', '5', '0', '1', '058');
INSERT INTO `fcf_cities` VALUES ('1250', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teloloapan', '12', '0', '1', '058');
INSERT INTO `fcf_cities` VALUES ('1251', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tasquillo', '13', '0', '1', '058');
INSERT INTO `fcf_cities` VALUES ('1252', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mascota', '14', '0', '1', '058');
INSERT INTO `fcf_cities` VALUES ('1253', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nezahualcóyotl', '15', '0', '1', '058');
INSERT INTO `fcf_cities` VALUES ('1254', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nuevo Parangaricutiro', '16', '0', '1', '058');
INSERT INTO `fcf_cities` VALUES ('1255', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mazatlán Villa de Flores', '20', '0', '1', '058');
INSERT INTO `fcf_cities` VALUES ('1256', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chilchotla', '21', '0', '1', '058');
INSERT INTO `fcf_cities` VALUES ('1257', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Naranjo', '24', '0', '1', '058');
INSERT INTO `fcf_cities` VALUES ('1258', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Ana', '26', '0', '1', '058');
INSERT INTO `fcf_cities` VALUES ('1259', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catarina Ayometla', '29', '0', '1', '058');
INSERT INTO `fcf_cities` VALUES ('1260', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chicontepec', '30', '0', '1', '058');
INSERT INTO `fcf_cities` VALUES ('1261', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Peto', '31', '0', '1', '058');
INSERT INTO `fcf_cities` VALUES ('1262', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María de la Paz', '32', '0', '1', '058');
INSERT INTO `fcf_cities` VALUES ('1263', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco del Oro', '6', '0', '1', '059');
INSERT INTO `fcf_cities` VALUES ('1264', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ocosingo', '5', '0', '1', '059');
INSERT INTO `fcf_cities` VALUES ('1265', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepecoacuilco de Trujano', '12', '0', '1', '059');
INSERT INTO `fcf_cities` VALUES ('1266', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tecozautla', '13', '0', '1', '059');
INSERT INTO `fcf_cities` VALUES ('1267', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mazamitla', '14', '0', '1', '059');
INSERT INTO `fcf_cities` VALUES ('1268', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nextlalpan', '15', '0', '1', '059');
INSERT INTO `fcf_cities` VALUES ('1269', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nuevo Urecho', '16', '0', '1', '059');
INSERT INTO `fcf_cities` VALUES ('1270', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Miahuatlán de Porfirio Díaz', '20', '0', '1', '059');
INSERT INTO `fcf_cities` VALUES ('1271', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chinantla', '21', '0', '1', '059');
INSERT INTO `fcf_cities` VALUES ('1272', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Cruz', '26', '0', '1', '059');
INSERT INTO `fcf_cities` VALUES ('1273', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Cruz Quilehtla', '29', '0', '1', '059');
INSERT INTO `fcf_cities` VALUES ('1274', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chinameca', '30', '0', '1', '059');
INSERT INTO `fcf_cities` VALUES ('1275', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Progreso', '31', '0', '1', '059');
INSERT INTO `fcf_cities` VALUES ('1276', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Bárbara', '6', '0', '1', '060');
INSERT INTO `fcf_cities` VALUES ('1277', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ocotepec', '5', '0', '1', '060');
INSERT INTO `fcf_cities` VALUES ('1278', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tetipac', '12', '0', '1', '060');
INSERT INTO `fcf_cities` VALUES ('1279', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tenango de Doria', '13', '0', '1', '060');
INSERT INTO `fcf_cities` VALUES ('1280', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mexticacán', '14', '0', '1', '060');
INSERT INTO `fcf_cities` VALUES ('1281', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nicolás Romero', '15', '0', '1', '060');
INSERT INTO `fcf_cities` VALUES ('1282', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Numarán', '16', '0', '1', '060');
INSERT INTO `fcf_cities` VALUES ('1283', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mixistlán de la Reforma', '20', '0', '1', '060');
INSERT INTO `fcf_cities` VALUES ('1284', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Domingo Arenas', '21', '0', '1', '060');
INSERT INTO `fcf_cities` VALUES ('1285', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sáric', '26', '0', '1', '060');
INSERT INTO `fcf_cities` VALUES ('1286', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Isabel Xiloxoxtla', '29', '0', '1', '060');
INSERT INTO `fcf_cities` VALUES ('1287', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chinampa de Gorostiza', '30', '0', '1', '060');
INSERT INTO `fcf_cities` VALUES ('1288', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Quintana Roo', '31', '0', '1', '060');
INSERT INTO `fcf_cities` VALUES ('1289', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Satevó', '6', '0', '1', '061');
INSERT INTO `fcf_cities` VALUES ('1290', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ocozocoautla de Espinosa', '5', '0', '1', '061');
INSERT INTO `fcf_cities` VALUES ('1291', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tixtla de Guerrero', '12', '0', '1', '061');
INSERT INTO `fcf_cities` VALUES ('1292', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepeapulco', '13', '0', '1', '061');
INSERT INTO `fcf_cities` VALUES ('1293', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mezquitic', '14', '0', '1', '061');
INSERT INTO `fcf_cities` VALUES ('1294', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nopaltepec', '15', '0', '1', '061');
INSERT INTO `fcf_cities` VALUES ('1295', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ocampo', '16', '0', '1', '061');
INSERT INTO `fcf_cities` VALUES ('1296', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Monjas', '20', '0', '1', '061');
INSERT INTO `fcf_cities` VALUES ('1297', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Eloxochitlán', '21', '0', '1', '061');
INSERT INTO `fcf_cities` VALUES ('1298', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Soyopa', '26', '0', '1', '061');
INSERT INTO `fcf_cities` VALUES ('1299', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Las Choapas', '30', '0', '1', '061');
INSERT INTO `fcf_cities` VALUES ('1300', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Río Lagartos', '31', '0', '1', '061');
INSERT INTO `fcf_cities` VALUES ('1301', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Saucillo', '6', '0', '1', '062');
INSERT INTO `fcf_cities` VALUES ('1302', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ostuacán', '5', '0', '1', '062');
INSERT INTO `fcf_cities` VALUES ('1303', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlacoachistlahuaca', '12', '0', '1', '062');
INSERT INTO `fcf_cities` VALUES ('1304', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepehuacán de Guerrero', '13', '0', '1', '062');
INSERT INTO `fcf_cities` VALUES ('1305', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mixtlán', '14', '0', '1', '062');
INSERT INTO `fcf_cities` VALUES ('1306', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ocoyoacac', '15', '0', '1', '062');
INSERT INTO `fcf_cities` VALUES ('1307', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pajacuarán', '16', '0', '1', '062');
INSERT INTO `fcf_cities` VALUES ('1308', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Natividad', '20', '0', '1', '062');
INSERT INTO `fcf_cities` VALUES ('1309', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Epatlán', '21', '0', '1', '062');
INSERT INTO `fcf_cities` VALUES ('1310', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Suaqui Grande', '26', '0', '1', '062');
INSERT INTO `fcf_cities` VALUES ('1311', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chocamán', '30', '0', '1', '062');
INSERT INTO `fcf_cities` VALUES ('1312', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sacalum', '31', '0', '1', '062');
INSERT INTO `fcf_cities` VALUES ('1313', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Temósachic', '6', '0', '1', '063');
INSERT INTO `fcf_cities` VALUES ('1314', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Osumacinta', '5', '0', '1', '063');
INSERT INTO `fcf_cities` VALUES ('1315', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlacoapa', '12', '0', '1', '063');
INSERT INTO `fcf_cities` VALUES ('1316', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepeji del Río de Ocampo', '13', '0', '1', '063');
INSERT INTO `fcf_cities` VALUES ('1317', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ocotlán', '14', '0', '1', '063');
INSERT INTO `fcf_cities` VALUES ('1318', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ocuilan', '15', '0', '1', '063');
INSERT INTO `fcf_cities` VALUES ('1319', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Panindícuaro', '16', '0', '1', '063');
INSERT INTO `fcf_cities` VALUES ('1320', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nazareno Etla', '20', '0', '1', '063');
INSERT INTO `fcf_cities` VALUES ('1321', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Esperanza', '21', '0', '1', '063');
INSERT INTO `fcf_cities` VALUES ('1322', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepache', '26', '0', '1', '063');
INSERT INTO `fcf_cities` VALUES ('1323', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chontla', '30', '0', '1', '063');
INSERT INTO `fcf_cities` VALUES ('1324', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Samahil', '31', '0', '1', '063');
INSERT INTO `fcf_cities` VALUES ('1325', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Tule', '6', '0', '1', '064');
INSERT INTO `fcf_cities` VALUES ('1326', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Oxchuc', '5', '0', '1', '064');
INSERT INTO `fcf_cities` VALUES ('1327', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlalchapa', '12', '0', '1', '064');
INSERT INTO `fcf_cities` VALUES ('1328', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepetitlán', '13', '0', '1', '064');
INSERT INTO `fcf_cities` VALUES ('1329', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ojuelos de Jalisco', '14', '0', '1', '064');
INSERT INTO `fcf_cities` VALUES ('1330', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Oro', '15', '0', '1', '064');
INSERT INTO `fcf_cities` VALUES ('1331', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Parácuaro', '16', '0', '1', '064');
INSERT INTO `fcf_cities` VALUES ('1332', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nejapa de Madero', '20', '0', '1', '064');
INSERT INTO `fcf_cities` VALUES ('1333', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Francisco Z. Mena', '21', '0', '1', '064');
INSERT INTO `fcf_cities` VALUES ('1334', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Trincheras', '26', '0', '1', '064');
INSERT INTO `fcf_cities` VALUES ('1335', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Chumatlán', '30', '0', '1', '064');
INSERT INTO `fcf_cities` VALUES ('1336', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sanahcat', '31', '0', '1', '064');
INSERT INTO `fcf_cities` VALUES ('1337', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Urique', '6', '0', '1', '065');
INSERT INTO `fcf_cities` VALUES ('1338', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Palenque', '5', '0', '1', '065');
INSERT INTO `fcf_cities` VALUES ('1339', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlalixtaquilla de Maldonado', '12', '0', '1', '065');
INSERT INTO `fcf_cities` VALUES ('1340', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tetepango', '13', '0', '1', '065');
INSERT INTO `fcf_cities` VALUES ('1341', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pihuamo', '14', '0', '1', '065');
INSERT INTO `fcf_cities` VALUES ('1342', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Otumba', '15', '0', '1', '065');
INSERT INTO `fcf_cities` VALUES ('1343', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Paracho', '16', '0', '1', '065');
INSERT INTO `fcf_cities` VALUES ('1344', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixpantepec Nieves', '20', '0', '1', '065');
INSERT INTO `fcf_cities` VALUES ('1345', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'General Felipe Ángeles', '21', '0', '1', '065');
INSERT INTO `fcf_cities` VALUES ('1346', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tubutama', '26', '0', '1', '065');
INSERT INTO `fcf_cities` VALUES ('1347', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Emiliano Zapata', '30', '0', '1', '065');
INSERT INTO `fcf_cities` VALUES ('1348', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Felipe', '31', '0', '1', '065');
INSERT INTO `fcf_cities` VALUES ('1349', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Uruachi', '6', '0', '1', '066');
INSERT INTO `fcf_cities` VALUES ('1350', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pantelhó', '5', '0', '1', '066');
INSERT INTO `fcf_cities` VALUES ('1351', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlapa de Comonfort', '12', '0', '1', '066');
INSERT INTO `fcf_cities` VALUES ('1352', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa de Tezontepec', '13', '0', '1', '066');
INSERT INTO `fcf_cities` VALUES ('1353', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Poncitlán', '14', '0', '1', '066');
INSERT INTO `fcf_cities` VALUES ('1354', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Otzoloapan', '15', '0', '1', '066');
INSERT INTO `fcf_cities` VALUES ('1355', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pátzcuaro', '16', '0', '1', '066');
INSERT INTO `fcf_cities` VALUES ('1356', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Niltepec', '20', '0', '1', '066');
INSERT INTO `fcf_cities` VALUES ('1357', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guadalupe', '21', '0', '1', '066');
INSERT INTO `fcf_cities` VALUES ('1358', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ures', '26', '0', '1', '066');
INSERT INTO `fcf_cities` VALUES ('1359', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Espinal', '30', '0', '1', '066');
INSERT INTO `fcf_cities` VALUES ('1360', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Elena', '31', '0', '1', '066');
INSERT INTO `fcf_cities` VALUES ('1361', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Valle de Zaragoza', '6', '0', '1', '067');
INSERT INTO `fcf_cities` VALUES ('1362', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pantepec', '5', '0', '1', '067');
INSERT INTO `fcf_cities` VALUES ('1363', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlapehuala', '12', '0', '1', '067');
INSERT INTO `fcf_cities` VALUES ('1364', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tezontepec de Aldama', '13', '0', '1', '067');
INSERT INTO `fcf_cities` VALUES ('1365', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Puerto Vallarta', '14', '0', '1', '067');
INSERT INTO `fcf_cities` VALUES ('1366', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Otzolotepec', '15', '0', '1', '067');
INSERT INTO `fcf_cities` VALUES ('1367', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Penjamillo', '16', '0', '1', '067');
INSERT INTO `fcf_cities` VALUES ('1368', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Oaxaca de Juárez', '20', '0', '1', '067');
INSERT INTO `fcf_cities` VALUES ('1369', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Guadalupe Victoria', '21', '0', '1', '067');
INSERT INTO `fcf_cities` VALUES ('1370', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Hidalgo', '26', '0', '1', '067');
INSERT INTO `fcf_cities` VALUES ('1371', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Filomeno Mata', '30', '0', '1', '067');
INSERT INTO `fcf_cities` VALUES ('1372', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Seyé', '31', '0', '1', '067');
INSERT INTO `fcf_cities` VALUES ('1373', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pichucalco', '5', '0', '1', '068');
INSERT INTO `fcf_cities` VALUES ('1374', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Unión de Isidoro Montes de Oca', '12', '0', '1', '068');
INSERT INTO `fcf_cities` VALUES ('1375', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tianguistengo', '13', '0', '1', '068');
INSERT INTO `fcf_cities` VALUES ('1376', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Purificación', '14', '0', '1', '068');
INSERT INTO `fcf_cities` VALUES ('1377', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ozumba', '15', '0', '1', '068');
INSERT INTO `fcf_cities` VALUES ('1378', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Peribán', '16', '0', '1', '068');
INSERT INTO `fcf_cities` VALUES ('1379', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ocotlán de Morelos', '20', '0', '1', '068');
INSERT INTO `fcf_cities` VALUES ('1380', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hermenegildo Galeana', '21', '0', '1', '068');
INSERT INTO `fcf_cities` VALUES ('1381', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Pesqueira', '26', '0', '1', '068');
INSERT INTO `fcf_cities` VALUES ('1382', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Fortín', '30', '0', '1', '068');
INSERT INTO `fcf_cities` VALUES ('1383', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sinanché', '31', '0', '1', '068');
INSERT INTO `fcf_cities` VALUES ('1384', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pijijiapan', '5', '0', '1', '069');
INSERT INTO `fcf_cities` VALUES ('1385', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xalpatláhuac', '12', '0', '1', '069');
INSERT INTO `fcf_cities` VALUES ('1386', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tizayuca', '13', '0', '1', '069');
INSERT INTO `fcf_cities` VALUES ('1387', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Quitupan', '14', '0', '1', '069');
INSERT INTO `fcf_cities` VALUES ('1388', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Papalotla', '15', '0', '1', '069');
INSERT INTO `fcf_cities` VALUES ('1389', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Piedad', '16', '0', '1', '069');
INSERT INTO `fcf_cities` VALUES ('1390', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Pe', '20', '0', '1', '069');
INSERT INTO `fcf_cities` VALUES ('1391', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huaquechula', '21', '0', '1', '069');
INSERT INTO `fcf_cities` VALUES ('1392', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yécora', '26', '0', '1', '069');
INSERT INTO `fcf_cities` VALUES ('1393', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Gutiérrez Zamora', '30', '0', '1', '069');
INSERT INTO `fcf_cities` VALUES ('1394', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sotuta', '31', '0', '1', '069');
INSERT INTO `fcf_cities` VALUES ('1395', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Porvenir', '5', '0', '1', '070');
INSERT INTO `fcf_cities` VALUES ('1396', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xochihuehuetlán', '12', '0', '1', '070');
INSERT INTO `fcf_cities` VALUES ('1397', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlahuelilpan', '13', '0', '1', '070');
INSERT INTO `fcf_cities` VALUES ('1398', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Salto', '14', '0', '1', '070');
INSERT INTO `fcf_cities` VALUES ('1399', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Paz', '15', '0', '1', '070');
INSERT INTO `fcf_cities` VALUES ('1400', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Purépero', '16', '0', '1', '070');
INSERT INTO `fcf_cities` VALUES ('1401', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pinotepa de Don Luis', '20', '0', '1', '070');
INSERT INTO `fcf_cities` VALUES ('1402', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huatlatlauca', '21', '0', '1', '070');
INSERT INTO `fcf_cities` VALUES ('1403', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'General Plutarco Elías Calles', '26', '0', '1', '070');
INSERT INTO `fcf_cities` VALUES ('1404', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hidalgotitlán', '30', '0', '1', '070');
INSERT INTO `fcf_cities` VALUES ('1405', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sucilá', '31', '0', '1', '070');
INSERT INTO `fcf_cities` VALUES ('1406', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Comaltitlán', '5', '0', '1', '071');
INSERT INTO `fcf_cities` VALUES ('1407', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xochistlahuaca', '12', '0', '1', '071');
INSERT INTO `fcf_cities` VALUES ('1408', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlahuiltepa', '13', '0', '1', '071');
INSERT INTO `fcf_cities` VALUES ('1409', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Cristóbal de la Barranca', '14', '0', '1', '071');
INSERT INTO `fcf_cities` VALUES ('1410', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Polotitlán', '15', '0', '1', '071');
INSERT INTO `fcf_cities` VALUES ('1411', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Puruándiro', '16', '0', '1', '071');
INSERT INTO `fcf_cities` VALUES ('1412', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pluma Hidalgo', '20', '0', '1', '071');
INSERT INTO `fcf_cities` VALUES ('1413', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huauchinango', '21', '0', '1', '071');
INSERT INTO `fcf_cities` VALUES ('1414', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Benito Juárez', '26', '0', '1', '071');
INSERT INTO `fcf_cities` VALUES ('1415', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huatusco', '30', '0', '1', '071');
INSERT INTO `fcf_cities` VALUES ('1416', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sudzal', '31', '0', '1', '071');
INSERT INTO `fcf_cities` VALUES ('1417', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pueblo Nuevo Solistahuacán', '5', '0', '1', '072');
INSERT INTO `fcf_cities` VALUES ('1418', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zapotitlán Tablas', '12', '0', '1', '072');
INSERT INTO `fcf_cities` VALUES ('1419', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlanalapa', '13', '0', '1', '072');
INSERT INTO `fcf_cities` VALUES ('1420', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Diego de Alejandría', '14', '0', '1', '072');
INSERT INTO `fcf_cities` VALUES ('1421', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Rayón', '15', '0', '1', '072');
INSERT INTO `fcf_cities` VALUES ('1422', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Queréndaro', '16', '0', '1', '072');
INSERT INTO `fcf_cities` VALUES ('1423', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San José del Progreso', '20', '0', '1', '072');
INSERT INTO `fcf_cities` VALUES ('1424', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huehuetla', '21', '0', '1', '072');
INSERT INTO `fcf_cities` VALUES ('1425', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Ignacio Río Muerto', '26', '0', '1', '072');
INSERT INTO `fcf_cities` VALUES ('1426', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huayacocotla', '30', '0', '1', '072');
INSERT INTO `fcf_cities` VALUES ('1427', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Suma', '31', '0', '1', '072');
INSERT INTO `fcf_cities` VALUES ('1428', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Rayón', '5', '0', '1', '073');
INSERT INTO `fcf_cities` VALUES ('1429', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zirándaro', '12', '0', '1', '073');
INSERT INTO `fcf_cities` VALUES ('1430', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlanchinol', '13', '0', '1', '073');
INSERT INTO `fcf_cities` VALUES ('1431', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan de los Lagos', '14', '0', '1', '073');
INSERT INTO `fcf_cities` VALUES ('1432', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Antonio la Isla', '15', '0', '1', '073');
INSERT INTO `fcf_cities` VALUES ('1433', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Quiroga', '16', '0', '1', '073');
INSERT INTO `fcf_cities` VALUES ('1434', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Putla Villa de Guerrero', '20', '0', '1', '073');
INSERT INTO `fcf_cities` VALUES ('1435', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huehuetlán el Chico', '21', '0', '1', '073');
INSERT INTO `fcf_cities` VALUES ('1436', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hueyapan de Ocampo', '30', '0', '1', '073');
INSERT INTO `fcf_cities` VALUES ('1437', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tahdziú', '31', '0', '1', '073');
INSERT INTO `fcf_cities` VALUES ('1438', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Reforma', '5', '0', '1', '074');
INSERT INTO `fcf_cities` VALUES ('1439', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zitlala', '12', '0', '1', '074');
INSERT INTO `fcf_cities` VALUES ('1440', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlaxcoapan', '13', '0', '1', '074');
INSERT INTO `fcf_cities` VALUES ('1441', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Julián', '14', '0', '1', '074');
INSERT INTO `fcf_cities` VALUES ('1442', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Felipe del Progreso', '15', '0', '1', '074');
INSERT INTO `fcf_cities` VALUES ('1443', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cojumatlán de Régules', '16', '0', '1', '074');
INSERT INTO `fcf_cities` VALUES ('1444', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catarina Quioquitani', '20', '0', '1', '074');
INSERT INTO `fcf_cities` VALUES ('1445', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huejotzingo', '21', '0', '1', '074');
INSERT INTO `fcf_cities` VALUES ('1446', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huiloapan de Cuauhtémoc', '30', '0', '1', '074');
INSERT INTO `fcf_cities` VALUES ('1447', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tahmek', '31', '0', '1', '074');
INSERT INTO `fcf_cities` VALUES ('1448', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Las Rosas', '5', '0', '1', '075');
INSERT INTO `fcf_cities` VALUES ('1449', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Eduardo Neri', '12', '0', '1', '075');
INSERT INTO `fcf_cities` VALUES ('1450', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tolcayuca', '13', '0', '1', '075');
INSERT INTO `fcf_cities` VALUES ('1451', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Marcos', '14', '0', '1', '075');
INSERT INTO `fcf_cities` VALUES ('1452', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Martín de las Pirámides', '15', '0', '1', '075');
INSERT INTO `fcf_cities` VALUES ('1453', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Los Reyes', '16', '0', '1', '075');
INSERT INTO `fcf_cities` VALUES ('1454', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Reforma de Pineda', '20', '0', '1', '075');
INSERT INTO `fcf_cities` VALUES ('1455', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hueyapan', '21', '0', '1', '075');
INSERT INTO `fcf_cities` VALUES ('1456', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ignacio de la Llave', '30', '0', '1', '075');
INSERT INTO `fcf_cities` VALUES ('1457', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teabo', '31', '0', '1', '075');
INSERT INTO `fcf_cities` VALUES ('1458', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sabanilla', '5', '0', '1', '076');
INSERT INTO `fcf_cities` VALUES ('1459', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Acatepec', '12', '0', '1', '076');
INSERT INTO `fcf_cities` VALUES ('1460', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tula de Allende', '13', '0', '1', '076');
INSERT INTO `fcf_cities` VALUES ('1461', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Martín de Bolaños', '14', '0', '1', '076');
INSERT INTO `fcf_cities` VALUES ('1462', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Mateo Atenco', '15', '0', '1', '076');
INSERT INTO `fcf_cities` VALUES ('1463', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sahuayo', '16', '0', '1', '076');
INSERT INTO `fcf_cities` VALUES ('1464', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Reforma', '20', '0', '1', '076');
INSERT INTO `fcf_cities` VALUES ('1465', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hueytamalco', '21', '0', '1', '076');
INSERT INTO `fcf_cities` VALUES ('1466', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ilamatlán', '30', '0', '1', '076');
INSERT INTO `fcf_cities` VALUES ('1467', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tecoh', '31', '0', '1', '076');
INSERT INTO `fcf_cities` VALUES ('1468', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Salto de Agua', '5', '0', '1', '077');
INSERT INTO `fcf_cities` VALUES ('1469', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Marquelia', '12', '0', '1', '077');
INSERT INTO `fcf_cities` VALUES ('1470', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tulancingo de Bravo', '13', '0', '1', '077');
INSERT INTO `fcf_cities` VALUES ('1471', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Martín Hidalgo', '14', '0', '1', '077');
INSERT INTO `fcf_cities` VALUES ('1472', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Simón de Guerrero', '15', '0', '1', '077');
INSERT INTO `fcf_cities` VALUES ('1473', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Lucas', '16', '0', '1', '077');
INSERT INTO `fcf_cities` VALUES ('1474', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Reyes Etla', '20', '0', '1', '077');
INSERT INTO `fcf_cities` VALUES ('1475', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Hueytlalpan', '21', '0', '1', '077');
INSERT INTO `fcf_cities` VALUES ('1476', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Isla', '30', '0', '1', '077');
INSERT INTO `fcf_cities` VALUES ('1477', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tekal de Venegas', '31', '0', '1', '077');
INSERT INTO `fcf_cities` VALUES ('1478', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Cristóbal de las Casas', '5', '0', '1', '078');
INSERT INTO `fcf_cities` VALUES ('1479', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cochoapa el Grande', '12', '0', '1', '078');
INSERT INTO `fcf_cities` VALUES ('1480', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xochiatipan', '13', '0', '1', '078');
INSERT INTO `fcf_cities` VALUES ('1481', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel el Alto', '14', '0', '1', '078');
INSERT INTO `fcf_cities` VALUES ('1482', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Tomás', '15', '0', '1', '078');
INSERT INTO `fcf_cities` VALUES ('1483', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Ana Maya', '16', '0', '1', '078');
INSERT INTO `fcf_cities` VALUES ('1484', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Rojas de Cuauhtémoc', '20', '0', '1', '078');
INSERT INTO `fcf_cities` VALUES ('1485', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huitzilan de Serdán', '21', '0', '1', '078');
INSERT INTO `fcf_cities` VALUES ('1486', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixcatepec', '30', '0', '1', '078');
INSERT INTO `fcf_cities` VALUES ('1487', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tekantó', '31', '0', '1', '078');
INSERT INTO `fcf_cities` VALUES ('1488', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Fernando', '5', '0', '1', '079');
INSERT INTO `fcf_cities` VALUES ('1489', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'José Joaquín de Herrera', '12', '0', '1', '079');
INSERT INTO `fcf_cities` VALUES ('1490', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xochicoatlán', '13', '0', '1', '079');
INSERT INTO `fcf_cities` VALUES ('1491', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Gómez Farías', '14', '0', '1', '079');
INSERT INTO `fcf_cities` VALUES ('1492', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Soyaniquilpan de Juárez', '15', '0', '1', '079');
INSERT INTO `fcf_cities` VALUES ('1493', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Salvador Escalante', '16', '0', '1', '079');
INSERT INTO `fcf_cities` VALUES ('1494', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Salina Cruz', '20', '0', '1', '079');
INSERT INTO `fcf_cities` VALUES ('1495', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huitziltepec', '21', '0', '1', '079');
INSERT INTO `fcf_cities` VALUES ('1496', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixhuacán de los Reyes', '30', '0', '1', '079');
INSERT INTO `fcf_cities` VALUES ('1497', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tekax', '31', '0', '1', '079');
INSERT INTO `fcf_cities` VALUES ('1498', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Siltepec', '5', '0', '1', '080');
INSERT INTO `fcf_cities` VALUES ('1499', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Juchitán', '12', '0', '1', '080');
INSERT INTO `fcf_cities` VALUES ('1500', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yahualica', '13', '0', '1', '080');
INSERT INTO `fcf_cities` VALUES ('1501', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Sebastián del Oeste', '14', '0', '1', '080');
INSERT INTO `fcf_cities` VALUES ('1502', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sultepec', '15', '0', '1', '080');
INSERT INTO `fcf_cities` VALUES ('1503', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Senguio', '16', '0', '1', '080');
INSERT INTO `fcf_cities` VALUES ('1504', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Agustín Amatengo', '20', '0', '1', '080');
INSERT INTO `fcf_cities` VALUES ('1505', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Atlequizayan', '21', '0', '1', '080');
INSERT INTO `fcf_cities` VALUES ('1506', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixhuatlán del Café', '30', '0', '1', '080');
INSERT INTO `fcf_cities` VALUES ('1507', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tekit', '31', '0', '1', '080');
INSERT INTO `fcf_cities` VALUES ('1508', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Simojovel', '5', '0', '1', '081');
INSERT INTO `fcf_cities` VALUES ('1509', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Iliatenco', '12', '0', '1', '081');
INSERT INTO `fcf_cities` VALUES ('1510', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zacualtipán de Ángeles', '13', '0', '1', '081');
INSERT INTO `fcf_cities` VALUES ('1511', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María de los Ángeles', '14', '0', '1', '081');
INSERT INTO `fcf_cities` VALUES ('1512', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tecámac', '15', '0', '1', '081');
INSERT INTO `fcf_cities` VALUES ('1513', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Susupuato', '16', '0', '1', '081');
INSERT INTO `fcf_cities` VALUES ('1514', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Agustín Atenango', '20', '0', '1', '081');
INSERT INTO `fcf_cities` VALUES ('1515', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixcamilpa de Guerrero', '21', '0', '1', '081');
INSERT INTO `fcf_cities` VALUES ('1516', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixhuatlancillo', '30', '0', '1', '081');
INSERT INTO `fcf_cities` VALUES ('1517', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tekom', '31', '0', '1', '081');
INSERT INTO `fcf_cities` VALUES ('1518', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sitalá', '5', '0', '1', '082');
INSERT INTO `fcf_cities` VALUES ('1519', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zapotlán de Juárez', '13', '0', '1', '082');
INSERT INTO `fcf_cities` VALUES ('1520', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sayula', '14', '0', '1', '082');
INSERT INTO `fcf_cities` VALUES ('1521', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tejupilco', '15', '0', '1', '082');
INSERT INTO `fcf_cities` VALUES ('1522', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tacámbaro', '16', '0', '1', '082');
INSERT INTO `fcf_cities` VALUES ('1523', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Agustín Chayuco', '20', '0', '1', '082');
INSERT INTO `fcf_cities` VALUES ('1524', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixcaquixtla', '21', '0', '1', '082');
INSERT INTO `fcf_cities` VALUES ('1525', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixhuatlán del Sureste', '30', '0', '1', '082');
INSERT INTO `fcf_cities` VALUES ('1526', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Telchac Pueblo', '31', '0', '1', '082');
INSERT INTO `fcf_cities` VALUES ('1527', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Socoltenango', '5', '0', '1', '083');
INSERT INTO `fcf_cities` VALUES ('1528', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zempoala', '13', '0', '1', '083');
INSERT INTO `fcf_cities` VALUES ('1529', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tala', '14', '0', '1', '083');
INSERT INTO `fcf_cities` VALUES ('1530', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Temamatla', '15', '0', '1', '083');
INSERT INTO `fcf_cities` VALUES ('1531', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tancítaro', '16', '0', '1', '083');
INSERT INTO `fcf_cities` VALUES ('1532', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Agustín de las Juntas', '20', '0', '1', '083');
INSERT INTO `fcf_cities` VALUES ('1533', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixtacamaxtitlán', '21', '0', '1', '083');
INSERT INTO `fcf_cities` VALUES ('1534', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixhuatlán de Madero', '30', '0', '1', '083');
INSERT INTO `fcf_cities` VALUES ('1535', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Telchac Puerto', '31', '0', '1', '083');
INSERT INTO `fcf_cities` VALUES ('1536', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Solosuchiapa', '5', '0', '1', '084');
INSERT INTO `fcf_cities` VALUES ('1537', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zimapán', '13', '0', '1', '084');
INSERT INTO `fcf_cities` VALUES ('1538', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Talpa de Allende', '14', '0', '1', '084');
INSERT INTO `fcf_cities` VALUES ('1539', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Temascalapa', '15', '0', '1', '084');
INSERT INTO `fcf_cities` VALUES ('1540', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tangamandapio', '16', '0', '1', '084');
INSERT INTO `fcf_cities` VALUES ('1541', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Agustín Etla', '20', '0', '1', '084');
INSERT INTO `fcf_cities` VALUES ('1542', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixtepec', '21', '0', '1', '084');
INSERT INTO `fcf_cities` VALUES ('1543', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixmatlahuacan', '30', '0', '1', '084');
INSERT INTO `fcf_cities` VALUES ('1544', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Temax', '31', '0', '1', '084');
INSERT INTO `fcf_cities` VALUES ('1545', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Soyaló', '5', '0', '1', '085');
INSERT INTO `fcf_cities` VALUES ('1546', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tamazula de Gordiano', '14', '0', '1', '085');
INSERT INTO `fcf_cities` VALUES ('1547', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Temascalcingo', '15', '0', '1', '085');
INSERT INTO `fcf_cities` VALUES ('1548', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tangancícuaro', '16', '0', '1', '085');
INSERT INTO `fcf_cities` VALUES ('1549', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Agustín Loxicha', '20', '0', '1', '085');
INSERT INTO `fcf_cities` VALUES ('1550', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Izúcar de Matamoros', '21', '0', '1', '085');
INSERT INTO `fcf_cities` VALUES ('1551', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ixtaczoquitlán', '30', '0', '1', '085');
INSERT INTO `fcf_cities` VALUES ('1552', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Temozón', '31', '0', '1', '085');
INSERT INTO `fcf_cities` VALUES ('1553', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Suchiapa', '5', '0', '1', '086');
INSERT INTO `fcf_cities` VALUES ('1554', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tapalpa', '14', '0', '1', '086');
INSERT INTO `fcf_cities` VALUES ('1555', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Temascaltepec', '15', '0', '1', '086');
INSERT INTO `fcf_cities` VALUES ('1556', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tanhuato', '16', '0', '1', '086');
INSERT INTO `fcf_cities` VALUES ('1557', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Agustín Tlacotepec', '20', '0', '1', '086');
INSERT INTO `fcf_cities` VALUES ('1558', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jalpan', '21', '0', '1', '086');
INSERT INTO `fcf_cities` VALUES ('1559', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jalacingo', '30', '0', '1', '086');
INSERT INTO `fcf_cities` VALUES ('1560', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepakán', '31', '0', '1', '086');
INSERT INTO `fcf_cities` VALUES ('1561', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Suchiate', '5', '0', '1', '087');
INSERT INTO `fcf_cities` VALUES ('1562', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tecalitlán', '14', '0', '1', '087');
INSERT INTO `fcf_cities` VALUES ('1563', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Temoaya', '15', '0', '1', '087');
INSERT INTO `fcf_cities` VALUES ('1564', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Taretan', '16', '0', '1', '087');
INSERT INTO `fcf_cities` VALUES ('1565', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Agustín Yatareni', '20', '0', '1', '087');
INSERT INTO `fcf_cities` VALUES ('1566', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jolalpan', '21', '0', '1', '087');
INSERT INTO `fcf_cities` VALUES ('1567', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xalapa', '30', '0', '1', '087');
INSERT INTO `fcf_cities` VALUES ('1568', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tetiz', '31', '0', '1', '087');
INSERT INTO `fcf_cities` VALUES ('1569', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sunuapa', '5', '0', '1', '088');
INSERT INTO `fcf_cities` VALUES ('1570', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tecolotlán', '14', '0', '1', '088');
INSERT INTO `fcf_cities` VALUES ('1571', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tenancingo', '15', '0', '1', '088');
INSERT INTO `fcf_cities` VALUES ('1572', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tarímbaro', '16', '0', '1', '088');
INSERT INTO `fcf_cities` VALUES ('1573', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Cabecera Nueva', '20', '0', '1', '088');
INSERT INTO `fcf_cities` VALUES ('1574', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jonotla', '21', '0', '1', '088');
INSERT INTO `fcf_cities` VALUES ('1575', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jalcomulco', '30', '0', '1', '088');
INSERT INTO `fcf_cities` VALUES ('1576', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teya', '31', '0', '1', '088');
INSERT INTO `fcf_cities` VALUES ('1577', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tapachula', '5', '0', '1', '089');
INSERT INTO `fcf_cities` VALUES ('1578', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Techaluta de Montenegro', '14', '0', '1', '089');
INSERT INTO `fcf_cities` VALUES ('1579', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tenango del Aire', '15', '0', '1', '089');
INSERT INTO `fcf_cities` VALUES ('1580', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepalcatepec', '16', '0', '1', '089');
INSERT INTO `fcf_cities` VALUES ('1581', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Dinicuiti', '20', '0', '1', '089');
INSERT INTO `fcf_cities` VALUES ('1582', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jopala', '21', '0', '1', '089');
INSERT INTO `fcf_cities` VALUES ('1583', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jáltipan', '30', '0', '1', '089');
INSERT INTO `fcf_cities` VALUES ('1584', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ticul', '31', '0', '1', '089');
INSERT INTO `fcf_cities` VALUES ('1585', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tapalapa', '5', '0', '1', '090');
INSERT INTO `fcf_cities` VALUES ('1586', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tenamaxtlán', '14', '0', '1', '090');
INSERT INTO `fcf_cities` VALUES ('1587', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tenango del Valle', '15', '0', '1', '090');
INSERT INTO `fcf_cities` VALUES ('1588', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tingambato', '16', '0', '1', '090');
INSERT INTO `fcf_cities` VALUES ('1589', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Huaxpaltepec', '20', '0', '1', '090');
INSERT INTO `fcf_cities` VALUES ('1590', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Juan C. Bonilla', '21', '0', '1', '090');
INSERT INTO `fcf_cities` VALUES ('1591', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jamapa', '30', '0', '1', '090');
INSERT INTO `fcf_cities` VALUES ('1592', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Timucuy', '31', '0', '1', '090');
INSERT INTO `fcf_cities` VALUES ('1593', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tapilula', '5', '0', '1', '091');
INSERT INTO `fcf_cities` VALUES ('1594', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teocaltiche', '14', '0', '1', '091');
INSERT INTO `fcf_cities` VALUES ('1595', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teoloyucan', '15', '0', '1', '091');
INSERT INTO `fcf_cities` VALUES ('1596', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tingüindín', '16', '0', '1', '091');
INSERT INTO `fcf_cities` VALUES ('1597', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Huayápam', '20', '0', '1', '091');
INSERT INTO `fcf_cities` VALUES ('1598', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Juan Galindo', '21', '0', '1', '091');
INSERT INTO `fcf_cities` VALUES ('1599', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jesús Carranza', '30', '0', '1', '091');
INSERT INTO `fcf_cities` VALUES ('1600', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tinum', '31', '0', '1', '091');
INSERT INTO `fcf_cities` VALUES ('1601', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tecpatán', '5', '0', '1', '092');
INSERT INTO `fcf_cities` VALUES ('1602', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teocuitatlán de Corona', '14', '0', '1', '092');
INSERT INTO `fcf_cities` VALUES ('1603', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teotihuacán', '15', '0', '1', '092');
INSERT INTO `fcf_cities` VALUES ('1604', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tiquicheo de Nicolás Romero', '16', '0', '1', '092');
INSERT INTO `fcf_cities` VALUES ('1605', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Ixtlahuaca', '20', '0', '1', '092');
INSERT INTO `fcf_cities` VALUES ('1606', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Juan N. Méndez', '21', '0', '1', '092');
INSERT INTO `fcf_cities` VALUES ('1607', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xico', '30', '0', '1', '092');
INSERT INTO `fcf_cities` VALUES ('1608', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tixcacalcupul', '31', '0', '1', '092');
INSERT INTO `fcf_cities` VALUES ('1609', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tenejapa', '5', '0', '1', '093');
INSERT INTO `fcf_cities` VALUES ('1610', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepatitlán de Morelos', '14', '0', '1', '093');
INSERT INTO `fcf_cities` VALUES ('1611', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepetlaoxtoc', '15', '0', '1', '093');
INSERT INTO `fcf_cities` VALUES ('1612', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlalpujahua', '16', '0', '1', '093');
INSERT INTO `fcf_cities` VALUES ('1613', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Lagunas', '20', '0', '1', '093');
INSERT INTO `fcf_cities` VALUES ('1614', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Lafragua', '21', '0', '1', '093');
INSERT INTO `fcf_cities` VALUES ('1615', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Jilotepec', '30', '0', '1', '093');
INSERT INTO `fcf_cities` VALUES ('1616', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tixkokob', '31', '0', '1', '093');
INSERT INTO `fcf_cities` VALUES ('1617', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teopisca', '5', '0', '1', '094');
INSERT INTO `fcf_cities` VALUES ('1618', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tequila', '14', '0', '1', '094');
INSERT INTO `fcf_cities` VALUES ('1619', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepetlixpa', '15', '0', '1', '094');
INSERT INTO `fcf_cities` VALUES ('1620', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlazazalca', '16', '0', '1', '094');
INSERT INTO `fcf_cities` VALUES ('1621', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Nuxiño', '20', '0', '1', '094');
INSERT INTO `fcf_cities` VALUES ('1622', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Libres', '21', '0', '1', '094');
INSERT INTO `fcf_cities` VALUES ('1623', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Juan Rodríguez Clara', '30', '0', '1', '094');
INSERT INTO `fcf_cities` VALUES ('1624', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tixmehuac', '31', '0', '1', '094');
INSERT INTO `fcf_cities` VALUES ('1625', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teuchitlán', '14', '0', '1', '095');
INSERT INTO `fcf_cities` VALUES ('1626', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepotzotlán', '15', '0', '1', '095');
INSERT INTO `fcf_cities` VALUES ('1627', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tocumbo', '16', '0', '1', '095');
INSERT INTO `fcf_cities` VALUES ('1628', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Paxtlán', '20', '0', '1', '095');
INSERT INTO `fcf_cities` VALUES ('1629', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Magdalena Tlatlauquitepec', '21', '0', '1', '095');
INSERT INTO `fcf_cities` VALUES ('1630', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Juchique de Ferrer', '30', '0', '1', '095');
INSERT INTO `fcf_cities` VALUES ('1631', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tixpéhual', '31', '0', '1', '095');
INSERT INTO `fcf_cities` VALUES ('1632', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tila', '5', '0', '1', '096');
INSERT INTO `fcf_cities` VALUES ('1633', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tizapán el Alto', '14', '0', '1', '096');
INSERT INTO `fcf_cities` VALUES ('1634', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tequixquiac', '15', '0', '1', '096');
INSERT INTO `fcf_cities` VALUES ('1635', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tumbiscatío', '16', '0', '1', '096');
INSERT INTO `fcf_cities` VALUES ('1636', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Sinaxtla', '20', '0', '1', '096');
INSERT INTO `fcf_cities` VALUES ('1637', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mazapiltepec de Juárez', '21', '0', '1', '096');
INSERT INTO `fcf_cities` VALUES ('1638', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Landero y Coss', '30', '0', '1', '096');
INSERT INTO `fcf_cities` VALUES ('1639', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tizimín', '31', '0', '1', '096');
INSERT INTO `fcf_cities` VALUES ('1640', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tonalá', '5', '0', '1', '097');
INSERT INTO `fcf_cities` VALUES ('1641', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlajomulco de Zúñiga', '14', '0', '1', '097');
INSERT INTO `fcf_cities` VALUES ('1642', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Texcaltitlán', '15', '0', '1', '097');
INSERT INTO `fcf_cities` VALUES ('1643', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Turicato', '16', '0', '1', '097');
INSERT INTO `fcf_cities` VALUES ('1644', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Solaga', '20', '0', '1', '097');
INSERT INTO `fcf_cities` VALUES ('1645', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mixtla', '21', '0', '1', '097');
INSERT INTO `fcf_cities` VALUES ('1646', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Lerdo de Tejada', '30', '0', '1', '097');
INSERT INTO `fcf_cities` VALUES ('1647', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tunkás', '31', '0', '1', '097');
INSERT INTO `fcf_cities` VALUES ('1648', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Totolapa', '5', '0', '1', '098');
INSERT INTO `fcf_cities` VALUES ('1649', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Tlaquepaque', '14', '0', '1', '098');
INSERT INTO `fcf_cities` VALUES ('1650', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Texcalyacac', '15', '0', '1', '098');
INSERT INTO `fcf_cities` VALUES ('1651', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tuxpan', '16', '0', '1', '098');
INSERT INTO `fcf_cities` VALUES ('1652', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Teotilálpam', '20', '0', '1', '098');
INSERT INTO `fcf_cities` VALUES ('1653', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Molcaxac', '21', '0', '1', '098');
INSERT INTO `fcf_cities` VALUES ('1654', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Magdalena', '30', '0', '1', '098');
INSERT INTO `fcf_cities` VALUES ('1655', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tzucacab', '31', '0', '1', '098');
INSERT INTO `fcf_cities` VALUES ('1656', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Trinitaria', '5', '0', '1', '099');
INSERT INTO `fcf_cities` VALUES ('1657', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tolimán', '14', '0', '1', '099');
INSERT INTO `fcf_cities` VALUES ('1658', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Texcoco', '15', '0', '1', '099');
INSERT INTO `fcf_cities` VALUES ('1659', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tuzantla', '16', '0', '1', '099');
INSERT INTO `fcf_cities` VALUES ('1660', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Tepetlapa', '20', '0', '1', '099');
INSERT INTO `fcf_cities` VALUES ('1661', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cañada Morelos', '21', '0', '1', '099');
INSERT INTO `fcf_cities` VALUES ('1662', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Maltrata', '30', '0', '1', '099');
INSERT INTO `fcf_cities` VALUES ('1663', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Uayma', '31', '0', '1', '099');
INSERT INTO `fcf_cities` VALUES ('1664', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tumbalá', '5', '0', '1', '100');
INSERT INTO `fcf_cities` VALUES ('1665', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tomatlán', '14', '0', '1', '100');
INSERT INTO `fcf_cities` VALUES ('1666', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tezoyuca', '15', '0', '1', '100');
INSERT INTO `fcf_cities` VALUES ('1667', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tzintzuntzan', '16', '0', '1', '100');
INSERT INTO `fcf_cities` VALUES ('1668', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Yaá', '20', '0', '1', '100');
INSERT INTO `fcf_cities` VALUES ('1669', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Naupan', '21', '0', '1', '100');
INSERT INTO `fcf_cities` VALUES ('1670', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Manlio Fabio Altamirano', '30', '0', '1', '100');
INSERT INTO `fcf_cities` VALUES ('1671', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ucú', '31', '0', '1', '100');
INSERT INTO `fcf_cities` VALUES ('1672', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tuxtla Gutiérrez', '5', '0', '1', '101');
INSERT INTO `fcf_cities` VALUES ('1673', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tonalá', '14', '0', '1', '101');
INSERT INTO `fcf_cities` VALUES ('1674', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tianguistenco', '15', '0', '1', '101');
INSERT INTO `fcf_cities` VALUES ('1675', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tzitzio', '16', '0', '1', '101');
INSERT INTO `fcf_cities` VALUES ('1676', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Zabache', '20', '0', '1', '101');
INSERT INTO `fcf_cities` VALUES ('1677', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nauzontla', '21', '0', '1', '101');
INSERT INTO `fcf_cities` VALUES ('1678', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mariano Escobedo', '30', '0', '1', '101');
INSERT INTO `fcf_cities` VALUES ('1679', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Umán', '31', '0', '1', '101');
INSERT INTO `fcf_cities` VALUES ('1680', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tuxtla Chico', '5', '0', '1', '102');
INSERT INTO `fcf_cities` VALUES ('1681', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tonaya', '14', '0', '1', '102');
INSERT INTO `fcf_cities` VALUES ('1682', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Timilpan', '15', '0', '1', '102');
INSERT INTO `fcf_cities` VALUES ('1683', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Uruapan', '16', '0', '1', '102');
INSERT INTO `fcf_cities` VALUES ('1684', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Zautla', '20', '0', '1', '102');
INSERT INTO `fcf_cities` VALUES ('1685', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nealtican', '21', '0', '1', '102');
INSERT INTO `fcf_cities` VALUES ('1686', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Martínez de la Torre', '30', '0', '1', '102');
INSERT INTO `fcf_cities` VALUES ('1687', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Valladolid', '31', '0', '1', '102');
INSERT INTO `fcf_cities` VALUES ('1688', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tuzantán', '5', '0', '1', '103');
INSERT INTO `fcf_cities` VALUES ('1689', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tonila', '14', '0', '1', '103');
INSERT INTO `fcf_cities` VALUES ('1690', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlalmanalco', '15', '0', '1', '103');
INSERT INTO `fcf_cities` VALUES ('1691', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Venustiano Carranza', '16', '0', '1', '103');
INSERT INTO `fcf_cities` VALUES ('1692', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Antonino Castillo Velasco', '20', '0', '1', '103');
INSERT INTO `fcf_cities` VALUES ('1693', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nicolás Bravo', '21', '0', '1', '103');
INSERT INTO `fcf_cities` VALUES ('1694', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mecatlán', '30', '0', '1', '103');
INSERT INTO `fcf_cities` VALUES ('1695', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xocchel', '31', '0', '1', '103');
INSERT INTO `fcf_cities` VALUES ('1696', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tzimol', '5', '0', '1', '104');
INSERT INTO `fcf_cities` VALUES ('1697', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Totatiche', '14', '0', '1', '104');
INSERT INTO `fcf_cities` VALUES ('1698', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlalnepantla de Baz', '15', '0', '1', '104');
INSERT INTO `fcf_cities` VALUES ('1699', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villamar', '16', '0', '1', '104');
INSERT INTO `fcf_cities` VALUES ('1700', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Antonino el Alto', '20', '0', '1', '104');
INSERT INTO `fcf_cities` VALUES ('1701', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nopalucan', '21', '0', '1', '104');
INSERT INTO `fcf_cities` VALUES ('1702', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mecayapan', '30', '0', '1', '104');
INSERT INTO `fcf_cities` VALUES ('1703', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yaxcabá', '31', '0', '1', '104');
INSERT INTO `fcf_cities` VALUES ('1704', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Unión Juárez', '5', '0', '1', '105');
INSERT INTO `fcf_cities` VALUES ('1705', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tototlán', '14', '0', '1', '105');
INSERT INTO `fcf_cities` VALUES ('1706', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlatlaya', '15', '0', '1', '105');
INSERT INTO `fcf_cities` VALUES ('1707', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Vista Hermosa', '16', '0', '1', '105');
INSERT INTO `fcf_cities` VALUES ('1708', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Antonino Monte Verde', '20', '0', '1', '105');
INSERT INTO `fcf_cities` VALUES ('1709', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ocotepec', '21', '0', '1', '105');
INSERT INTO `fcf_cities` VALUES ('1710', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Medellín', '30', '0', '1', '105');
INSERT INTO `fcf_cities` VALUES ('1711', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yaxkukul', '31', '0', '1', '105');
INSERT INTO `fcf_cities` VALUES ('1712', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Venustiano Carranza', '5', '0', '1', '106');
INSERT INTO `fcf_cities` VALUES ('1713', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tuxcacuesco', '14', '0', '1', '106');
INSERT INTO `fcf_cities` VALUES ('1714', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Toluca', '15', '0', '1', '106');
INSERT INTO `fcf_cities` VALUES ('1715', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yurécuaro', '16', '0', '1', '106');
INSERT INTO `fcf_cities` VALUES ('1716', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Antonio Acutla', '20', '0', '1', '106');
INSERT INTO `fcf_cities` VALUES ('1717', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ocoyucan', '21', '0', '1', '106');
INSERT INTO `fcf_cities` VALUES ('1718', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Miahuatlán', '30', '0', '1', '106');
INSERT INTO `fcf_cities` VALUES ('1719', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yobaín', '31', '0', '1', '106');
INSERT INTO `fcf_cities` VALUES ('1720', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Corzo', '5', '0', '1', '107');
INSERT INTO `fcf_cities` VALUES ('1721', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tuxcueca', '14', '0', '1', '107');
INSERT INTO `fcf_cities` VALUES ('1722', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tonatico', '15', '0', '1', '107');
INSERT INTO `fcf_cities` VALUES ('1723', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zacapu', '16', '0', '1', '107');
INSERT INTO `fcf_cities` VALUES ('1724', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Antonio de la Cal', '20', '0', '1', '107');
INSERT INTO `fcf_cities` VALUES ('1725', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Olintla', '21', '0', '1', '107');
INSERT INTO `fcf_cities` VALUES ('1726', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Las Minas', '30', '0', '1', '107');
INSERT INTO `fcf_cities` VALUES ('1727', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villaflores', '5', '0', '1', '108');
INSERT INTO `fcf_cities` VALUES ('1728', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tuxpan', '14', '0', '1', '108');
INSERT INTO `fcf_cities` VALUES ('1729', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tultepec', '15', '0', '1', '108');
INSERT INTO `fcf_cities` VALUES ('1730', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zamora', '16', '0', '1', '108');
INSERT INTO `fcf_cities` VALUES ('1731', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Antonio Huitepec', '20', '0', '1', '108');
INSERT INTO `fcf_cities` VALUES ('1732', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Oriental', '21', '0', '1', '108');
INSERT INTO `fcf_cities` VALUES ('1733', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Minatitlán', '30', '0', '1', '108');
INSERT INTO `fcf_cities` VALUES ('1734', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yajalón', '5', '0', '1', '109');
INSERT INTO `fcf_cities` VALUES ('1735', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Unión de San Antonio', '14', '0', '1', '109');
INSERT INTO `fcf_cities` VALUES ('1736', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tultitlán', '15', '0', '1', '109');
INSERT INTO `fcf_cities` VALUES ('1737', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zináparo', '16', '0', '1', '109');
INSERT INTO `fcf_cities` VALUES ('1738', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Antonio Nanahuatípam', '20', '0', '1', '109');
INSERT INTO `fcf_cities` VALUES ('1739', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pahuatlán', '21', '0', '1', '109');
INSERT INTO `fcf_cities` VALUES ('1740', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Misantla', '30', '0', '1', '109');
INSERT INTO `fcf_cities` VALUES ('1741', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Lucas', '5', '0', '1', '110');
INSERT INTO `fcf_cities` VALUES ('1742', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Unión de Tula', '14', '0', '1', '110');
INSERT INTO `fcf_cities` VALUES ('1743', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Valle de Bravo', '15', '0', '1', '110');
INSERT INTO `fcf_cities` VALUES ('1744', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zinapécuaro', '16', '0', '1', '110');
INSERT INTO `fcf_cities` VALUES ('1745', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Antonio Sinicahua', '20', '0', '1', '110');
INSERT INTO `fcf_cities` VALUES ('1746', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Palmar de Bravo', '21', '0', '1', '110');
INSERT INTO `fcf_cities` VALUES ('1747', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Mixtla de Altamirano', '30', '0', '1', '110');
INSERT INTO `fcf_cities` VALUES ('1748', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zinacantán', '5', '0', '1', '111');
INSERT INTO `fcf_cities` VALUES ('1749', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Valle de Guadalupe', '14', '0', '1', '111');
INSERT INTO `fcf_cities` VALUES ('1750', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa de Allende', '15', '0', '1', '111');
INSERT INTO `fcf_cities` VALUES ('1751', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ziracuaretiro', '16', '0', '1', '111');
INSERT INTO `fcf_cities` VALUES ('1752', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Antonio Tepetlapa', '20', '0', '1', '111');
INSERT INTO `fcf_cities` VALUES ('1753', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pantepec', '21', '0', '1', '111');
INSERT INTO `fcf_cities` VALUES ('1754', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Moloacán', '30', '0', '1', '111');
INSERT INTO `fcf_cities` VALUES ('1755', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Cancuc', '5', '0', '1', '112');
INSERT INTO `fcf_cities` VALUES ('1756', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Valle de Juárez', '14', '0', '1', '112');
INSERT INTO `fcf_cities` VALUES ('1757', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa del Carbón', '15', '0', '1', '112');
INSERT INTO `fcf_cities` VALUES ('1758', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zitácuaro', '16', '0', '1', '112');
INSERT INTO `fcf_cities` VALUES ('1759', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Baltazar Chichicápam', '20', '0', '1', '112');
INSERT INTO `fcf_cities` VALUES ('1760', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Petlalcingo', '21', '0', '1', '112');
INSERT INTO `fcf_cities` VALUES ('1761', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Naolinco', '30', '0', '1', '112');
INSERT INTO `fcf_cities` VALUES ('1762', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Aldama', '5', '0', '1', '113');
INSERT INTO `fcf_cities` VALUES ('1763', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Gabriel', '14', '0', '1', '113');
INSERT INTO `fcf_cities` VALUES ('1764', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Guerrero', '15', '0', '1', '113');
INSERT INTO `fcf_cities` VALUES ('1765', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'José Sixto Verduzco', '16', '0', '1', '113');
INSERT INTO `fcf_cities` VALUES ('1766', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Baltazar Loxicha', '20', '0', '1', '113');
INSERT INTO `fcf_cities` VALUES ('1767', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Piaxtla', '21', '0', '1', '113');
INSERT INTO `fcf_cities` VALUES ('1768', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Naranjal', '30', '0', '1', '113');
INSERT INTO `fcf_cities` VALUES ('1769', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Benemérito de las Américas', '5', '0', '1', '114');
INSERT INTO `fcf_cities` VALUES ('1770', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Corona', '14', '0', '1', '114');
INSERT INTO `fcf_cities` VALUES ('1771', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Victoria', '15', '0', '1', '114');
INSERT INTO `fcf_cities` VALUES ('1772', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Baltazar Yatzachi el Bajo', '20', '0', '1', '114');
INSERT INTO `fcf_cities` VALUES ('1773', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Puebla', '21', '0', '1', '114');
INSERT INTO `fcf_cities` VALUES ('1774', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nautla', '30', '0', '1', '114');
INSERT INTO `fcf_cities` VALUES ('1775', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Maravilla Tenejapa', '5', '0', '1', '115');
INSERT INTO `fcf_cities` VALUES ('1776', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Guerrero', '14', '0', '1', '115');
INSERT INTO `fcf_cities` VALUES ('1777', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xonacatlán', '15', '0', '1', '115');
INSERT INTO `fcf_cities` VALUES ('1778', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Bartolo Coyotepec', '20', '0', '1', '115');
INSERT INTO `fcf_cities` VALUES ('1779', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Quecholac', '21', '0', '1', '115');
INSERT INTO `fcf_cities` VALUES ('1780', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nogales', '30', '0', '1', '115');
INSERT INTO `fcf_cities` VALUES ('1781', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Marqués de Comillas', '5', '0', '1', '116');
INSERT INTO `fcf_cities` VALUES ('1782', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Hidalgo', '14', '0', '1', '116');
INSERT INTO `fcf_cities` VALUES ('1783', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zacazonapan', '15', '0', '1', '116');
INSERT INTO `fcf_cities` VALUES ('1784', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Bartolomé Ayautla', '20', '0', '1', '116');
INSERT INTO `fcf_cities` VALUES ('1785', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Quimixtlán', '21', '0', '1', '116');
INSERT INTO `fcf_cities` VALUES ('1786', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Oluta', '30', '0', '1', '116');
INSERT INTO `fcf_cities` VALUES ('1787', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Montecristo de Guerrero', '5', '0', '1', '117');
INSERT INTO `fcf_cities` VALUES ('1788', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cañadas de Obregón', '14', '0', '1', '117');
INSERT INTO `fcf_cities` VALUES ('1789', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zacualpan', '15', '0', '1', '117');
INSERT INTO `fcf_cities` VALUES ('1790', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Bartolomé Loxicha', '20', '0', '1', '117');
INSERT INTO `fcf_cities` VALUES ('1791', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Rafael Lara Grajales', '21', '0', '1', '117');
INSERT INTO `fcf_cities` VALUES ('1792', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Omealca', '30', '0', '1', '117');
INSERT INTO `fcf_cities` VALUES ('1793', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Duraznal', '5', '0', '1', '118');
INSERT INTO `fcf_cities` VALUES ('1794', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yahualica de González Gallo', '14', '0', '1', '118');
INSERT INTO `fcf_cities` VALUES ('1795', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zinacantepec', '15', '0', '1', '118');
INSERT INTO `fcf_cities` VALUES ('1796', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Bartolomé Quialana', '20', '0', '1', '118');
INSERT INTO `fcf_cities` VALUES ('1797', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Los Reyes de Juárez', '21', '0', '1', '118');
INSERT INTO `fcf_cities` VALUES ('1798', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Orizaba', '30', '0', '1', '118');
INSERT INTO `fcf_cities` VALUES ('1799', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago el Pinar', '5', '0', '1', '119');
INSERT INTO `fcf_cities` VALUES ('1800', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zacoalco de Torres', '14', '0', '1', '119');
INSERT INTO `fcf_cities` VALUES ('1801', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zumpahuacán', '15', '0', '1', '119');
INSERT INTO `fcf_cities` VALUES ('1802', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Bartolomé Yucuañe', '20', '0', '1', '119');
INSERT INTO `fcf_cities` VALUES ('1803', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Cholula', '21', '0', '1', '119');
INSERT INTO `fcf_cities` VALUES ('1804', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Otatitlán', '30', '0', '1', '119');
INSERT INTO `fcf_cities` VALUES ('1805', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zapopan', '14', '0', '1', '120');
INSERT INTO `fcf_cities` VALUES ('1806', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zumpango', '15', '0', '1', '120');
INSERT INTO `fcf_cities` VALUES ('1807', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Bartolomé Zoogocho', '20', '0', '1', '120');
INSERT INTO `fcf_cities` VALUES ('1808', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Antonio Cañada', '21', '0', '1', '120');
INSERT INTO `fcf_cities` VALUES ('1809', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Oteapan', '30', '0', '1', '120');
INSERT INTO `fcf_cities` VALUES ('1810', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zapotiltic', '14', '0', '1', '121');
INSERT INTO `fcf_cities` VALUES ('1811', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Cuautitlán Izcalli', '15', '0', '1', '121');
INSERT INTO `fcf_cities` VALUES ('1812', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Bartolo Soyaltepec', '20', '0', '1', '121');
INSERT INTO `fcf_cities` VALUES ('1813', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Diego la Mesa Tochimiltzingo', '21', '0', '1', '121');
INSERT INTO `fcf_cities` VALUES ('1814', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ozuluama de Mascareñas', '30', '0', '1', '121');
INSERT INTO `fcf_cities` VALUES ('1815', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zapotitlán de Vadillo', '14', '0', '1', '122');
INSERT INTO `fcf_cities` VALUES ('1816', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Valle de Chalco Solidaridad', '15', '0', '1', '122');
INSERT INTO `fcf_cities` VALUES ('1817', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Bartolo Yautepec', '20', '0', '1', '122');
INSERT INTO `fcf_cities` VALUES ('1818', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Felipe Teotlalcingo', '21', '0', '1', '122');
INSERT INTO `fcf_cities` VALUES ('1819', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pajapan', '30', '0', '1', '122');
INSERT INTO `fcf_cities` VALUES ('1820', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zapotlán del Rey', '14', '0', '1', '123');
INSERT INTO `fcf_cities` VALUES ('1821', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Luvianos', '15', '0', '1', '123');
INSERT INTO `fcf_cities` VALUES ('1822', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Bernardo Mixtepec', '20', '0', '1', '123');
INSERT INTO `fcf_cities` VALUES ('1823', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Felipe Tepatlán', '21', '0', '1', '123');
INSERT INTO `fcf_cities` VALUES ('1824', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pánuco', '30', '0', '1', '123');
INSERT INTO `fcf_cities` VALUES ('1825', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zapotlanejo', '14', '0', '1', '124');
INSERT INTO `fcf_cities` VALUES ('1826', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San José del Rincón', '15', '0', '1', '124');
INSERT INTO `fcf_cities` VALUES ('1827', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Blas Atempa', '20', '0', '1', '124');
INSERT INTO `fcf_cities` VALUES ('1828', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Gabriel Chilac', '21', '0', '1', '124');
INSERT INTO `fcf_cities` VALUES ('1829', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Papantla', '30', '0', '1', '124');
INSERT INTO `fcf_cities` VALUES ('1830', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Ignacio Cerro Gordo', '14', '0', '1', '125');
INSERT INTO `fcf_cities` VALUES ('1831', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tonanitla', '15', '0', '1', '125');
INSERT INTO `fcf_cities` VALUES ('1832', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Carlos Yautepec', '20', '0', '1', '125');
INSERT INTO `fcf_cities` VALUES ('1833', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Gregorio Atzompa', '21', '0', '1', '125');
INSERT INTO `fcf_cities` VALUES ('1834', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Paso del Macho', '30', '0', '1', '125');
INSERT INTO `fcf_cities` VALUES ('1835', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Cristóbal Amatlán', '20', '0', '1', '126');
INSERT INTO `fcf_cities` VALUES ('1836', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Jerónimo Tecuanipan', '21', '0', '1', '126');
INSERT INTO `fcf_cities` VALUES ('1837', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Paso de Ovejas', '30', '0', '1', '126');
INSERT INTO `fcf_cities` VALUES ('1838', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Cristóbal Amoltepec', '20', '0', '1', '127');
INSERT INTO `fcf_cities` VALUES ('1839', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Jerónimo Xayacatlán', '21', '0', '1', '127');
INSERT INTO `fcf_cities` VALUES ('1840', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Perla', '30', '0', '1', '127');
INSERT INTO `fcf_cities` VALUES ('1841', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Cristóbal Lachirioag', '20', '0', '1', '128');
INSERT INTO `fcf_cities` VALUES ('1842', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San José Chiapa', '21', '0', '1', '128');
INSERT INTO `fcf_cities` VALUES ('1843', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Perote', '30', '0', '1', '128');
INSERT INTO `fcf_cities` VALUES ('1844', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Cristóbal Suchixtlahuaca', '20', '0', '1', '129');
INSERT INTO `fcf_cities` VALUES ('1845', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San José Miahuatlán', '21', '0', '1', '129');
INSERT INTO `fcf_cities` VALUES ('1846', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Platón Sánchez', '30', '0', '1', '129');
INSERT INTO `fcf_cities` VALUES ('1847', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Dionisio del Mar', '20', '0', '1', '130');
INSERT INTO `fcf_cities` VALUES ('1848', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Atenco', '21', '0', '1', '130');
INSERT INTO `fcf_cities` VALUES ('1849', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Playa Vicente', '30', '0', '1', '130');
INSERT INTO `fcf_cities` VALUES ('1850', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Dionisio Ocotepec', '20', '0', '1', '131');
INSERT INTO `fcf_cities` VALUES ('1851', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Atzompa', '21', '0', '1', '131');
INSERT INTO `fcf_cities` VALUES ('1852', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Poza Rica de Hidalgo', '30', '0', '1', '131');
INSERT INTO `fcf_cities` VALUES ('1853', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Dionisio Ocotlán', '20', '0', '1', '132');
INSERT INTO `fcf_cities` VALUES ('1854', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Martín Texmelucan', '21', '0', '1', '132');
INSERT INTO `fcf_cities` VALUES ('1855', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Las Vigas de Ramírez', '30', '0', '1', '132');
INSERT INTO `fcf_cities` VALUES ('1856', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Esteban Atatlahuca', '20', '0', '1', '133');
INSERT INTO `fcf_cities` VALUES ('1857', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Martín Totoltepec', '21', '0', '1', '133');
INSERT INTO `fcf_cities` VALUES ('1858', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Pueblo Viejo', '30', '0', '1', '133');
INSERT INTO `fcf_cities` VALUES ('1859', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Felipe Jalapa de Díaz', '20', '0', '1', '134');
INSERT INTO `fcf_cities` VALUES ('1860', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Matías Tlalancaleca', '21', '0', '1', '134');
INSERT INTO `fcf_cities` VALUES ('1861', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Puente Nacional', '30', '0', '1', '134');
INSERT INTO `fcf_cities` VALUES ('1862', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Felipe Tejalápam', '20', '0', '1', '135');
INSERT INTO `fcf_cities` VALUES ('1863', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Ixitlán', '21', '0', '1', '135');
INSERT INTO `fcf_cities` VALUES ('1864', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Rafael Delgado', '30', '0', '1', '135');
INSERT INTO `fcf_cities` VALUES ('1865', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Felipe Usila', '20', '0', '1', '136');
INSERT INTO `fcf_cities` VALUES ('1866', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Xoxtla', '21', '0', '1', '136');
INSERT INTO `fcf_cities` VALUES ('1867', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Rafael Lucio', '30', '0', '1', '136');
INSERT INTO `fcf_cities` VALUES ('1868', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco Cahuacuá', '20', '0', '1', '137');
INSERT INTO `fcf_cities` VALUES ('1869', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Nicolás Buenos Aires', '21', '0', '1', '137');
INSERT INTO `fcf_cities` VALUES ('1870', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Los Reyes', '30', '0', '1', '137');
INSERT INTO `fcf_cities` VALUES ('1871', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco Cajonos', '20', '0', '1', '138');
INSERT INTO `fcf_cities` VALUES ('1872', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Nicolás de los Ranchos', '21', '0', '1', '138');
INSERT INTO `fcf_cities` VALUES ('1873', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Río Blanco', '30', '0', '1', '138');
INSERT INTO `fcf_cities` VALUES ('1874', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco Chapulapa', '20', '0', '1', '139');
INSERT INTO `fcf_cities` VALUES ('1875', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pablo Anicano', '21', '0', '1', '139');
INSERT INTO `fcf_cities` VALUES ('1876', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Saltabarranca', '30', '0', '1', '139');
INSERT INTO `fcf_cities` VALUES ('1877', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco Chindúa', '20', '0', '1', '140');
INSERT INTO `fcf_cities` VALUES ('1878', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Cholula', '21', '0', '1', '140');
INSERT INTO `fcf_cities` VALUES ('1879', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Tenejapan', '30', '0', '1', '140');
INSERT INTO `fcf_cities` VALUES ('1880', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco del Mar', '20', '0', '1', '141');
INSERT INTO `fcf_cities` VALUES ('1881', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Yeloixtlahuaca', '21', '0', '1', '141');
INSERT INTO `fcf_cities` VALUES ('1882', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Andrés Tuxtla', '30', '0', '1', '141');
INSERT INTO `fcf_cities` VALUES ('1883', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco Huehuetlán', '20', '0', '1', '142');
INSERT INTO `fcf_cities` VALUES ('1884', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Salvador el Seco', '21', '0', '1', '142');
INSERT INTO `fcf_cities` VALUES ('1885', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Evangelista', '30', '0', '1', '142');
INSERT INTO `fcf_cities` VALUES ('1886', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco Ixhuatán', '20', '0', '1', '143');
INSERT INTO `fcf_cities` VALUES ('1887', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Salvador el Verde', '21', '0', '1', '143');
INSERT INTO `fcf_cities` VALUES ('1888', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Tuxtla', '30', '0', '1', '143');
INSERT INTO `fcf_cities` VALUES ('1889', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco Jaltepetongo', '20', '0', '1', '144');
INSERT INTO `fcf_cities` VALUES ('1890', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Salvador Huixcolotla', '21', '0', '1', '144');
INSERT INTO `fcf_cities` VALUES ('1891', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sayula de Alemán', '30', '0', '1', '144');
INSERT INTO `fcf_cities` VALUES ('1892', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco Lachigoló', '20', '0', '1', '145');
INSERT INTO `fcf_cities` VALUES ('1893', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Sebastián Tlacotepec', '21', '0', '1', '145');
INSERT INTO `fcf_cities` VALUES ('1894', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Soconusco', '30', '0', '1', '145');
INSERT INTO `fcf_cities` VALUES ('1895', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco Logueche', '20', '0', '1', '146');
INSERT INTO `fcf_cities` VALUES ('1896', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catarina Tlaltempan', '21', '0', '1', '146');
INSERT INTO `fcf_cities` VALUES ('1897', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sochiapa', '30', '0', '1', '146');
INSERT INTO `fcf_cities` VALUES ('1898', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco Nuxaño', '20', '0', '1', '147');
INSERT INTO `fcf_cities` VALUES ('1899', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Inés Ahuatempan', '21', '0', '1', '147');
INSERT INTO `fcf_cities` VALUES ('1900', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Soledad Atzompa', '30', '0', '1', '147');
INSERT INTO `fcf_cities` VALUES ('1901', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco Ozolotepec', '20', '0', '1', '148');
INSERT INTO `fcf_cities` VALUES ('1902', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Isabel Cholula', '21', '0', '1', '148');
INSERT INTO `fcf_cities` VALUES ('1903', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Soledad de Doblado', '30', '0', '1', '148');
INSERT INTO `fcf_cities` VALUES ('1904', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco Sola', '20', '0', '1', '149');
INSERT INTO `fcf_cities` VALUES ('1905', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Miahuatlán', '21', '0', '1', '149');
INSERT INTO `fcf_cities` VALUES ('1906', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Soteapan', '30', '0', '1', '149');
INSERT INTO `fcf_cities` VALUES ('1907', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco Telixtlahuaca', '20', '0', '1', '150');
INSERT INTO `fcf_cities` VALUES ('1908', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Huehuetlán el Grande', '21', '0', '1', '150');
INSERT INTO `fcf_cities` VALUES ('1909', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tamalín', '30', '0', '1', '150');
INSERT INTO `fcf_cities` VALUES ('1910', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco Teopan', '20', '0', '1', '151');
INSERT INTO `fcf_cities` VALUES ('1911', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Tomás Hueyotlipan', '21', '0', '1', '151');
INSERT INTO `fcf_cities` VALUES ('1912', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tamiahua', '30', '0', '1', '151');
INSERT INTO `fcf_cities` VALUES ('1913', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Francisco Tlapancingo', '20', '0', '1', '152');
INSERT INTO `fcf_cities` VALUES ('1914', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Soltepec', '21', '0', '1', '152');
INSERT INTO `fcf_cities` VALUES ('1915', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tampico Alto', '30', '0', '1', '152');
INSERT INTO `fcf_cities` VALUES ('1916', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Gabriel Mixtepec', '20', '0', '1', '153');
INSERT INTO `fcf_cities` VALUES ('1917', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tecali de Herrera', '21', '0', '1', '153');
INSERT INTO `fcf_cities` VALUES ('1918', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tancoco', '30', '0', '1', '153');
INSERT INTO `fcf_cities` VALUES ('1919', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Ildefonso Amatlán', '20', '0', '1', '154');
INSERT INTO `fcf_cities` VALUES ('1920', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tecamachalco', '21', '0', '1', '154');
INSERT INTO `fcf_cities` VALUES ('1921', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tantima', '30', '0', '1', '154');
INSERT INTO `fcf_cities` VALUES ('1922', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Ildefonso Sola', '20', '0', '1', '155');
INSERT INTO `fcf_cities` VALUES ('1923', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tecomatlán', '21', '0', '1', '155');
INSERT INTO `fcf_cities` VALUES ('1924', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tantoyuca', '30', '0', '1', '155');
INSERT INTO `fcf_cities` VALUES ('1925', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Ildefonso Villa Alta', '20', '0', '1', '156');
INSERT INTO `fcf_cities` VALUES ('1926', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tehuacán', '21', '0', '1', '156');
INSERT INTO `fcf_cities` VALUES ('1927', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tatatila', '30', '0', '1', '156');
INSERT INTO `fcf_cities` VALUES ('1928', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Jacinto Amilpas', '20', '0', '1', '157');
INSERT INTO `fcf_cities` VALUES ('1929', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tehuitzingo', '21', '0', '1', '157');
INSERT INTO `fcf_cities` VALUES ('1930', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Castillo de Teayo', '30', '0', '1', '157');
INSERT INTO `fcf_cities` VALUES ('1931', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Jacinto Tlacotepec', '20', '0', '1', '158');
INSERT INTO `fcf_cities` VALUES ('1932', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tenampulco', '21', '0', '1', '158');
INSERT INTO `fcf_cities` VALUES ('1933', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tecolutla', '30', '0', '1', '158');
INSERT INTO `fcf_cities` VALUES ('1934', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Jerónimo Coatlán', '20', '0', '1', '159');
INSERT INTO `fcf_cities` VALUES ('1935', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teopantlán', '21', '0', '1', '159');
INSERT INTO `fcf_cities` VALUES ('1936', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tehuipango', '30', '0', '1', '159');
INSERT INTO `fcf_cities` VALUES ('1937', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Jerónimo Silacayoapilla', '20', '0', '1', '160');
INSERT INTO `fcf_cities` VALUES ('1938', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teotlalco', '21', '0', '1', '160');
INSERT INTO `fcf_cities` VALUES ('1939', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Álamo Temapache', '30', '0', '1', '160');
INSERT INTO `fcf_cities` VALUES ('1940', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Jerónimo Sosola', '20', '0', '1', '161');
INSERT INTO `fcf_cities` VALUES ('1941', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepanco de López', '21', '0', '1', '161');
INSERT INTO `fcf_cities` VALUES ('1942', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tempoal', '30', '0', '1', '161');
INSERT INTO `fcf_cities` VALUES ('1943', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Jerónimo Taviche', '20', '0', '1', '162');
INSERT INTO `fcf_cities` VALUES ('1944', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepango de Rodríguez', '21', '0', '1', '162');
INSERT INTO `fcf_cities` VALUES ('1945', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tenampa', '30', '0', '1', '162');
INSERT INTO `fcf_cities` VALUES ('1946', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Jerónimo Tecóatl', '20', '0', '1', '163');
INSERT INTO `fcf_cities` VALUES ('1947', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepatlaxco de Hidalgo', '21', '0', '1', '163');
INSERT INTO `fcf_cities` VALUES ('1948', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tenochtitlán', '30', '0', '1', '163');
INSERT INTO `fcf_cities` VALUES ('1949', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Jorge Nuchita', '20', '0', '1', '164');
INSERT INTO `fcf_cities` VALUES ('1950', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepeaca', '21', '0', '1', '164');
INSERT INTO `fcf_cities` VALUES ('1951', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teocelo', '30', '0', '1', '164');
INSERT INTO `fcf_cities` VALUES ('1952', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San José Ayuquila', '20', '0', '1', '165');
INSERT INTO `fcf_cities` VALUES ('1953', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepemaxalco', '21', '0', '1', '165');
INSERT INTO `fcf_cities` VALUES ('1954', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepatlaxco', '30', '0', '1', '165');
INSERT INTO `fcf_cities` VALUES ('1955', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San José Chiltepec', '20', '0', '1', '166');
INSERT INTO `fcf_cities` VALUES ('1956', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepeojuma', '21', '0', '1', '166');
INSERT INTO `fcf_cities` VALUES ('1957', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepetlán', '30', '0', '1', '166');
INSERT INTO `fcf_cities` VALUES ('1958', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San José del Peñasco', '20', '0', '1', '167');
INSERT INTO `fcf_cities` VALUES ('1959', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepetzintla', '21', '0', '1', '167');
INSERT INTO `fcf_cities` VALUES ('1960', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepetzintla', '30', '0', '1', '167');
INSERT INTO `fcf_cities` VALUES ('1961', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San José Estancia Grande', '20', '0', '1', '168');
INSERT INTO `fcf_cities` VALUES ('1962', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepexco', '21', '0', '1', '168');
INSERT INTO `fcf_cities` VALUES ('1963', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tequila', '30', '0', '1', '168');
INSERT INTO `fcf_cities` VALUES ('1964', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San José Independencia', '20', '0', '1', '169');
INSERT INTO `fcf_cities` VALUES ('1965', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepexi de Rodríguez', '21', '0', '1', '169');
INSERT INTO `fcf_cities` VALUES ('1966', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'José Azueta', '30', '0', '1', '169');
INSERT INTO `fcf_cities` VALUES ('1967', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San José Lachiguiri', '20', '0', '1', '170');
INSERT INTO `fcf_cities` VALUES ('1968', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepeyahualco', '21', '0', '1', '170');
INSERT INTO `fcf_cities` VALUES ('1969', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Texcatepec', '30', '0', '1', '170');
INSERT INTO `fcf_cities` VALUES ('1970', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San José Tenango', '20', '0', '1', '171');
INSERT INTO `fcf_cities` VALUES ('1971', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepeyahualco de Cuauhtémoc', '21', '0', '1', '171');
INSERT INTO `fcf_cities` VALUES ('1972', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Texhuacán', '30', '0', '1', '171');
INSERT INTO `fcf_cities` VALUES ('1973', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Achiutla', '20', '0', '1', '172');
INSERT INTO `fcf_cities` VALUES ('1974', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tetela de Ocampo', '21', '0', '1', '172');
INSERT INTO `fcf_cities` VALUES ('1975', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Texistepec', '30', '0', '1', '172');
INSERT INTO `fcf_cities` VALUES ('1976', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Atepec', '20', '0', '1', '173');
INSERT INTO `fcf_cities` VALUES ('1977', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teteles de Avila Castillo', '21', '0', '1', '173');
INSERT INTO `fcf_cities` VALUES ('1978', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tezonapa', '30', '0', '1', '173');
INSERT INTO `fcf_cities` VALUES ('1979', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ánimas Trujano', '20', '0', '1', '174');
INSERT INTO `fcf_cities` VALUES ('1980', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teziutlán', '21', '0', '1', '174');
INSERT INTO `fcf_cities` VALUES ('1981', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tierra Blanca', '30', '0', '1', '174');
INSERT INTO `fcf_cities` VALUES ('1982', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Bautista Atatlahuca', '20', '0', '1', '175');
INSERT INTO `fcf_cities` VALUES ('1983', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tianguismanalco', '21', '0', '1', '175');
INSERT INTO `fcf_cities` VALUES ('1984', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tihuatlán', '30', '0', '1', '175');
INSERT INTO `fcf_cities` VALUES ('1985', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Bautista Coixtlahuaca', '20', '0', '1', '176');
INSERT INTO `fcf_cities` VALUES ('1986', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tilapa', '21', '0', '1', '176');
INSERT INTO `fcf_cities` VALUES ('1987', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlacojalpan', '30', '0', '1', '176');
INSERT INTO `fcf_cities` VALUES ('1988', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Bautista Cuicatlán', '20', '0', '1', '177');
INSERT INTO `fcf_cities` VALUES ('1989', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlacotepec de Benito Juárez', '21', '0', '1', '177');
INSERT INTO `fcf_cities` VALUES ('1990', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlacolulan', '30', '0', '1', '177');
INSERT INTO `fcf_cities` VALUES ('1991', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Bautista Guelache', '20', '0', '1', '178');
INSERT INTO `fcf_cities` VALUES ('1992', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlacuilotepec', '21', '0', '1', '178');
INSERT INTO `fcf_cities` VALUES ('1993', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlacotalpan', '30', '0', '1', '178');
INSERT INTO `fcf_cities` VALUES ('1994', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Bautista Jayacatlán', '20', '0', '1', '179');
INSERT INTO `fcf_cities` VALUES ('1995', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlachichuca', '21', '0', '1', '179');
INSERT INTO `fcf_cities` VALUES ('1996', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlacotepec de Mejía', '30', '0', '1', '179');
INSERT INTO `fcf_cities` VALUES ('1997', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Bautista Lo de Soto', '20', '0', '1', '180');
INSERT INTO `fcf_cities` VALUES ('1998', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlahuapan', '21', '0', '1', '180');
INSERT INTO `fcf_cities` VALUES ('1999', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlachichilco', '30', '0', '1', '180');
INSERT INTO `fcf_cities` VALUES ('2000', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Bautista Suchitepec', '20', '0', '1', '181');
INSERT INTO `fcf_cities` VALUES ('2001', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlaltenango', '21', '0', '1', '181');
INSERT INTO `fcf_cities` VALUES ('2002', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlalixcoyan', '30', '0', '1', '181');
INSERT INTO `fcf_cities` VALUES ('2003', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Bautista Tlacoatzintepec', '20', '0', '1', '182');
INSERT INTO `fcf_cities` VALUES ('2004', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlanepantla', '21', '0', '1', '182');
INSERT INTO `fcf_cities` VALUES ('2005', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlalnelhuayocan', '30', '0', '1', '182');
INSERT INTO `fcf_cities` VALUES ('2006', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Bautista Tlachichilco', '20', '0', '1', '183');
INSERT INTO `fcf_cities` VALUES ('2007', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlaola', '21', '0', '1', '183');
INSERT INTO `fcf_cities` VALUES ('2008', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlapacoyan', '30', '0', '1', '183');
INSERT INTO `fcf_cities` VALUES ('2009', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Bautista Tuxtepec', '20', '0', '1', '184');
INSERT INTO `fcf_cities` VALUES ('2010', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlapacoya', '21', '0', '1', '184');
INSERT INTO `fcf_cities` VALUES ('2011', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlaquilpa', '30', '0', '1', '184');
INSERT INTO `fcf_cities` VALUES ('2012', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Cacahuatepec', '20', '0', '1', '185');
INSERT INTO `fcf_cities` VALUES ('2013', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlapanalá', '21', '0', '1', '185');
INSERT INTO `fcf_cities` VALUES ('2014', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlilapan', '30', '0', '1', '185');
INSERT INTO `fcf_cities` VALUES ('2015', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Cieneguilla', '20', '0', '1', '186');
INSERT INTO `fcf_cities` VALUES ('2016', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlatlauquitepec', '21', '0', '1', '186');
INSERT INTO `fcf_cities` VALUES ('2017', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tomatlán', '30', '0', '1', '186');
INSERT INTO `fcf_cities` VALUES ('2018', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Coatzóspam', '20', '0', '1', '187');
INSERT INTO `fcf_cities` VALUES ('2019', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlaxco', '21', '0', '1', '187');
INSERT INTO `fcf_cities` VALUES ('2020', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tonayán', '30', '0', '1', '187');
INSERT INTO `fcf_cities` VALUES ('2021', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Colorado', '20', '0', '1', '188');
INSERT INTO `fcf_cities` VALUES ('2022', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tochimilco', '21', '0', '1', '188');
INSERT INTO `fcf_cities` VALUES ('2023', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Totutla', '30', '0', '1', '188');
INSERT INTO `fcf_cities` VALUES ('2024', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Comaltepec', '20', '0', '1', '189');
INSERT INTO `fcf_cities` VALUES ('2025', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tochtepec', '21', '0', '1', '189');
INSERT INTO `fcf_cities` VALUES ('2026', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tuxpan', '30', '0', '1', '189');
INSERT INTO `fcf_cities` VALUES ('2027', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Cotzocón', '20', '0', '1', '190');
INSERT INTO `fcf_cities` VALUES ('2028', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Totoltepec de Guerrero', '21', '0', '1', '190');
INSERT INTO `fcf_cities` VALUES ('2029', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tuxtilla', '30', '0', '1', '190');
INSERT INTO `fcf_cities` VALUES ('2030', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Chicomezúchil', '20', '0', '1', '191');
INSERT INTO `fcf_cities` VALUES ('2031', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tulcingo', '21', '0', '1', '191');
INSERT INTO `fcf_cities` VALUES ('2032', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ursulo Galván', '30', '0', '1', '191');
INSERT INTO `fcf_cities` VALUES ('2033', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Chilateca', '20', '0', '1', '192');
INSERT INTO `fcf_cities` VALUES ('2034', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tuzamapan de Galeana', '21', '0', '1', '192');
INSERT INTO `fcf_cities` VALUES ('2035', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Vega de Alatorre', '30', '0', '1', '192');
INSERT INTO `fcf_cities` VALUES ('2036', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan del Estado', '20', '0', '1', '193');
INSERT INTO `fcf_cities` VALUES ('2037', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tzicatlacoyan', '21', '0', '1', '193');
INSERT INTO `fcf_cities` VALUES ('2038', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Veracruz', '30', '0', '1', '193');
INSERT INTO `fcf_cities` VALUES ('2039', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan del Río', '20', '0', '1', '194');
INSERT INTO `fcf_cities` VALUES ('2040', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Venustiano Carranza', '21', '0', '1', '194');
INSERT INTO `fcf_cities` VALUES ('2041', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Aldama', '30', '0', '1', '194');
INSERT INTO `fcf_cities` VALUES ('2042', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Diuxi', '20', '0', '1', '195');
INSERT INTO `fcf_cities` VALUES ('2043', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Vicente Guerrero', '21', '0', '1', '195');
INSERT INTO `fcf_cities` VALUES ('2044', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xoxocotla', '30', '0', '1', '195');
INSERT INTO `fcf_cities` VALUES ('2045', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Evangelista Analco', '20', '0', '1', '196');
INSERT INTO `fcf_cities` VALUES ('2046', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xayacatlán de Bravo', '21', '0', '1', '196');
INSERT INTO `fcf_cities` VALUES ('2047', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yanga', '30', '0', '1', '196');
INSERT INTO `fcf_cities` VALUES ('2048', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Guelavía', '20', '0', '1', '197');
INSERT INTO `fcf_cities` VALUES ('2049', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xicotepec', '21', '0', '1', '197');
INSERT INTO `fcf_cities` VALUES ('2050', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yecuatla', '30', '0', '1', '197');
INSERT INTO `fcf_cities` VALUES ('2051', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Guichicovi', '20', '0', '1', '198');
INSERT INTO `fcf_cities` VALUES ('2052', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xicotlán', '21', '0', '1', '198');
INSERT INTO `fcf_cities` VALUES ('2053', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zacualpan', '30', '0', '1', '198');
INSERT INTO `fcf_cities` VALUES ('2054', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Ihualtepec', '20', '0', '1', '199');
INSERT INTO `fcf_cities` VALUES ('2055', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xiutetelco', '21', '0', '1', '199');
INSERT INTO `fcf_cities` VALUES ('2056', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zaragoza', '30', '0', '1', '199');
INSERT INTO `fcf_cities` VALUES ('2057', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Juquila Mixes', '20', '0', '1', '200');
INSERT INTO `fcf_cities` VALUES ('2058', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xochiapulco', '21', '0', '1', '200');
INSERT INTO `fcf_cities` VALUES ('2059', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zentla', '30', '0', '1', '200');
INSERT INTO `fcf_cities` VALUES ('2060', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Juquila Vijanos', '20', '0', '1', '201');
INSERT INTO `fcf_cities` VALUES ('2061', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xochiltepec', '21', '0', '1', '201');
INSERT INTO `fcf_cities` VALUES ('2062', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zongolica', '30', '0', '1', '201');
INSERT INTO `fcf_cities` VALUES ('2063', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Lachao', '20', '0', '1', '202');
INSERT INTO `fcf_cities` VALUES ('2064', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xochitlán de Vicente Suárez', '21', '0', '1', '202');
INSERT INTO `fcf_cities` VALUES ('2065', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zontecomatlán de López y Fuentes', '30', '0', '1', '202');
INSERT INTO `fcf_cities` VALUES ('2066', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Lachigalla', '20', '0', '1', '203');
INSERT INTO `fcf_cities` VALUES ('2067', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Xochitlán Todos Santos', '21', '0', '1', '203');
INSERT INTO `fcf_cities` VALUES ('2068', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zozocolco de Hidalgo', '30', '0', '1', '203');
INSERT INTO `fcf_cities` VALUES ('2069', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Lajarcia', '20', '0', '1', '204');
INSERT INTO `fcf_cities` VALUES ('2070', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yaonáhuac', '21', '0', '1', '204');
INSERT INTO `fcf_cities` VALUES ('2071', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Agua Dulce', '30', '0', '1', '204');
INSERT INTO `fcf_cities` VALUES ('2072', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Lalana', '20', '0', '1', '205');
INSERT INTO `fcf_cities` VALUES ('2073', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yehualtepec', '21', '0', '1', '205');
INSERT INTO `fcf_cities` VALUES ('2074', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'El Higo', '30', '0', '1', '205');
INSERT INTO `fcf_cities` VALUES ('2075', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan de los Cués', '20', '0', '1', '206');
INSERT INTO `fcf_cities` VALUES ('2076', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zacapala', '21', '0', '1', '206');
INSERT INTO `fcf_cities` VALUES ('2077', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nanchital de Lázaro Cárdenas del Río', '30', '0', '1', '206');
INSERT INTO `fcf_cities` VALUES ('2078', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Mazatlán', '20', '0', '1', '207');
INSERT INTO `fcf_cities` VALUES ('2079', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zacapoaxtla', '21', '0', '1', '207');
INSERT INTO `fcf_cities` VALUES ('2080', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tres Valles', '30', '0', '1', '207');
INSERT INTO `fcf_cities` VALUES ('2081', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Mixtepec -Dto. 08 -', '20', '0', '1', '208');
INSERT INTO `fcf_cities` VALUES ('2082', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zacatlán', '21', '0', '1', '208');
INSERT INTO `fcf_cities` VALUES ('2083', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Carlos A. Carrillo', '30', '0', '1', '208');
INSERT INTO `fcf_cities` VALUES ('2084', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Mixtepec -Dto. 26 -', '20', '0', '1', '209');
INSERT INTO `fcf_cities` VALUES ('2085', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zapotitlán', '21', '0', '1', '209');
INSERT INTO `fcf_cities` VALUES ('2086', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tatahuicapan de Juárez', '30', '0', '1', '209');
INSERT INTO `fcf_cities` VALUES ('2087', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Ñumí', '20', '0', '1', '210');
INSERT INTO `fcf_cities` VALUES ('2088', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zapotitlán de Méndez', '21', '0', '1', '210');
INSERT INTO `fcf_cities` VALUES ('2089', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Uxpanapa', '30', '0', '1', '210');
INSERT INTO `fcf_cities` VALUES ('2090', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Ozolotepec', '20', '0', '1', '211');
INSERT INTO `fcf_cities` VALUES ('2091', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zaragoza', '21', '0', '1', '211');
INSERT INTO `fcf_cities` VALUES ('2092', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Rafael', '30', '0', '1', '211');
INSERT INTO `fcf_cities` VALUES ('2093', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Petlapa', '20', '0', '1', '212');
INSERT INTO `fcf_cities` VALUES ('2094', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zautla', '21', '0', '1', '212');
INSERT INTO `fcf_cities` VALUES ('2095', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Sochiapan', '30', '0', '1', '212');
INSERT INTO `fcf_cities` VALUES ('2096', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Quiahije', '20', '0', '1', '213');
INSERT INTO `fcf_cities` VALUES ('2097', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zihuateutla', '21', '0', '1', '213');
INSERT INTO `fcf_cities` VALUES ('2098', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Quiotepec', '20', '0', '1', '214');
INSERT INTO `fcf_cities` VALUES ('2099', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zinacatepec', '21', '0', '1', '214');
INSERT INTO `fcf_cities` VALUES ('2100', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Sayultepec', '20', '0', '1', '215');
INSERT INTO `fcf_cities` VALUES ('2101', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zongozotla', '21', '0', '1', '215');
INSERT INTO `fcf_cities` VALUES ('2102', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Tabaá', '20', '0', '1', '216');
INSERT INTO `fcf_cities` VALUES ('2103', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zoquiapan', '21', '0', '1', '216');
INSERT INTO `fcf_cities` VALUES ('2104', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Tamazola', '20', '0', '1', '217');
INSERT INTO `fcf_cities` VALUES ('2105', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zoquitlán', '21', '0', '1', '217');
INSERT INTO `fcf_cities` VALUES ('2106', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Teita', '20', '0', '1', '218');
INSERT INTO `fcf_cities` VALUES ('2107', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Teitipac', '20', '0', '1', '219');
INSERT INTO `fcf_cities` VALUES ('2108', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Tepeuxila', '20', '0', '1', '220');
INSERT INTO `fcf_cities` VALUES ('2109', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Teposcolula', '20', '0', '1', '221');
INSERT INTO `fcf_cities` VALUES ('2110', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Yaeé', '20', '0', '1', '222');
INSERT INTO `fcf_cities` VALUES ('2111', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Yatzona', '20', '0', '1', '223');
INSERT INTO `fcf_cities` VALUES ('2112', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Yucuita', '20', '0', '1', '224');
INSERT INTO `fcf_cities` VALUES ('2113', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Lorenzo', '20', '0', '1', '225');
INSERT INTO `fcf_cities` VALUES ('2114', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Lorenzo Albarradas', '20', '0', '1', '226');
INSERT INTO `fcf_cities` VALUES ('2115', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Lorenzo Cacaotepec', '20', '0', '1', '227');
INSERT INTO `fcf_cities` VALUES ('2116', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Lorenzo Cuaunecuiltitla', '20', '0', '1', '228');
INSERT INTO `fcf_cities` VALUES ('2117', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Lorenzo Texmelúcan', '20', '0', '1', '229');
INSERT INTO `fcf_cities` VALUES ('2118', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Lorenzo Victoria', '20', '0', '1', '230');
INSERT INTO `fcf_cities` VALUES ('2119', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Lucas Camotlán', '20', '0', '1', '231');
INSERT INTO `fcf_cities` VALUES ('2120', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Lucas Ojitlán', '20', '0', '1', '232');
INSERT INTO `fcf_cities` VALUES ('2121', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Lucas Quiaviní', '20', '0', '1', '233');
INSERT INTO `fcf_cities` VALUES ('2122', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Lucas Zoquiápam', '20', '0', '1', '234');
INSERT INTO `fcf_cities` VALUES ('2123', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Luis Amatlán', '20', '0', '1', '235');
INSERT INTO `fcf_cities` VALUES ('2124', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Marcial Ozolotepec', '20', '0', '1', '236');
INSERT INTO `fcf_cities` VALUES ('2125', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Marcos Arteaga', '20', '0', '1', '237');
INSERT INTO `fcf_cities` VALUES ('2126', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Martín de los Cansecos', '20', '0', '1', '238');
INSERT INTO `fcf_cities` VALUES ('2127', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Martín Huamelúlpam', '20', '0', '1', '239');
INSERT INTO `fcf_cities` VALUES ('2128', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Martín Itunyoso', '20', '0', '1', '240');
INSERT INTO `fcf_cities` VALUES ('2129', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Martín Lachilá', '20', '0', '1', '241');
INSERT INTO `fcf_cities` VALUES ('2130', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Martín Peras', '20', '0', '1', '242');
INSERT INTO `fcf_cities` VALUES ('2131', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Martín Tilcajete', '20', '0', '1', '243');
INSERT INTO `fcf_cities` VALUES ('2132', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Martín Toxpalan', '20', '0', '1', '244');
INSERT INTO `fcf_cities` VALUES ('2133', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Martín Zacatepec', '20', '0', '1', '245');
INSERT INTO `fcf_cities` VALUES ('2134', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Mateo Cajonos', '20', '0', '1', '246');
INSERT INTO `fcf_cities` VALUES ('2135', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Capulálpam de Méndez', '20', '0', '1', '247');
INSERT INTO `fcf_cities` VALUES ('2136', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Mateo del Mar', '20', '0', '1', '248');
INSERT INTO `fcf_cities` VALUES ('2137', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Mateo Yoloxochitlán', '20', '0', '1', '249');
INSERT INTO `fcf_cities` VALUES ('2138', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Mateo Etlatongo', '20', '0', '1', '250');
INSERT INTO `fcf_cities` VALUES ('2139', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Mateo Nejápam', '20', '0', '1', '251');
INSERT INTO `fcf_cities` VALUES ('2140', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Mateo Peñasco', '20', '0', '1', '252');
INSERT INTO `fcf_cities` VALUES ('2141', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Mateo Piñas', '20', '0', '1', '253');
INSERT INTO `fcf_cities` VALUES ('2142', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Mateo Río Hondo', '20', '0', '1', '254');
INSERT INTO `fcf_cities` VALUES ('2143', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Mateo Sindihui', '20', '0', '1', '255');
INSERT INTO `fcf_cities` VALUES ('2144', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Mateo Tlapiltepec', '20', '0', '1', '256');
INSERT INTO `fcf_cities` VALUES ('2145', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Melchor Betaza', '20', '0', '1', '257');
INSERT INTO `fcf_cities` VALUES ('2146', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Achiutla', '20', '0', '1', '258');
INSERT INTO `fcf_cities` VALUES ('2147', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Ahuehuetitlán', '20', '0', '1', '259');
INSERT INTO `fcf_cities` VALUES ('2148', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Aloápam', '20', '0', '1', '260');
INSERT INTO `fcf_cities` VALUES ('2149', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Amatitlán', '20', '0', '1', '261');
INSERT INTO `fcf_cities` VALUES ('2150', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Amatlán', '20', '0', '1', '262');
INSERT INTO `fcf_cities` VALUES ('2151', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Coatlán', '20', '0', '1', '263');
INSERT INTO `fcf_cities` VALUES ('2152', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Chicahua', '20', '0', '1', '264');
INSERT INTO `fcf_cities` VALUES ('2153', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Chimalapa', '20', '0', '1', '265');
INSERT INTO `fcf_cities` VALUES ('2154', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel del Puerto', '20', '0', '1', '266');
INSERT INTO `fcf_cities` VALUES ('2155', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel del Río', '20', '0', '1', '267');
INSERT INTO `fcf_cities` VALUES ('2156', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Ejutla', '20', '0', '1', '268');
INSERT INTO `fcf_cities` VALUES ('2157', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel el Grande', '20', '0', '1', '269');
INSERT INTO `fcf_cities` VALUES ('2158', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Huautla', '20', '0', '1', '270');
INSERT INTO `fcf_cities` VALUES ('2159', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Mixtepec', '20', '0', '1', '271');
INSERT INTO `fcf_cities` VALUES ('2160', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Panixtlahuaca', '20', '0', '1', '272');
INSERT INTO `fcf_cities` VALUES ('2161', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Peras', '20', '0', '1', '273');
INSERT INTO `fcf_cities` VALUES ('2162', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Piedras', '20', '0', '1', '274');
INSERT INTO `fcf_cities` VALUES ('2163', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Quetzaltepec', '20', '0', '1', '275');
INSERT INTO `fcf_cities` VALUES ('2164', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Santa Flor', '20', '0', '1', '276');
INSERT INTO `fcf_cities` VALUES ('2165', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Sola de Vega', '20', '0', '1', '277');
INSERT INTO `fcf_cities` VALUES ('2166', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Soyaltepec', '20', '0', '1', '278');
INSERT INTO `fcf_cities` VALUES ('2167', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Suchixtepec', '20', '0', '1', '279');
INSERT INTO `fcf_cities` VALUES ('2168', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Talea de Castro', '20', '0', '1', '280');
INSERT INTO `fcf_cities` VALUES ('2169', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Tecomatlán', '20', '0', '1', '281');
INSERT INTO `fcf_cities` VALUES ('2170', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Tenango', '20', '0', '1', '282');
INSERT INTO `fcf_cities` VALUES ('2171', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Tequixtepec', '20', '0', '1', '283');
INSERT INTO `fcf_cities` VALUES ('2172', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Tilquiápam', '20', '0', '1', '284');
INSERT INTO `fcf_cities` VALUES ('2173', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Tlacamama', '20', '0', '1', '285');
INSERT INTO `fcf_cities` VALUES ('2174', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Tlacotepec', '20', '0', '1', '286');
INSERT INTO `fcf_cities` VALUES ('2175', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Tulancingo', '20', '0', '1', '287');
INSERT INTO `fcf_cities` VALUES ('2176', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Miguel Yotao', '20', '0', '1', '288');
INSERT INTO `fcf_cities` VALUES ('2177', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Nicolás', '20', '0', '1', '289');
INSERT INTO `fcf_cities` VALUES ('2178', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Nicolás Hidalgo', '20', '0', '1', '290');
INSERT INTO `fcf_cities` VALUES ('2179', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pablo Coatlán', '20', '0', '1', '291');
INSERT INTO `fcf_cities` VALUES ('2180', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pablo Cuatro Venados', '20', '0', '1', '292');
INSERT INTO `fcf_cities` VALUES ('2181', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pablo Etla', '20', '0', '1', '293');
INSERT INTO `fcf_cities` VALUES ('2182', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pablo Huitzo', '20', '0', '1', '294');
INSERT INTO `fcf_cities` VALUES ('2183', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pablo Huixtepec', '20', '0', '1', '295');
INSERT INTO `fcf_cities` VALUES ('2184', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pablo Macuiltianguis', '20', '0', '1', '296');
INSERT INTO `fcf_cities` VALUES ('2185', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pablo Tijaltepec', '20', '0', '1', '297');
INSERT INTO `fcf_cities` VALUES ('2186', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pablo Villa de Mitla', '20', '0', '1', '298');
INSERT INTO `fcf_cities` VALUES ('2187', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pablo Yaganiza', '20', '0', '1', '299');
INSERT INTO `fcf_cities` VALUES ('2188', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Amuzgos', '20', '0', '1', '300');
INSERT INTO `fcf_cities` VALUES ('2189', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Apóstol', '20', '0', '1', '301');
INSERT INTO `fcf_cities` VALUES ('2190', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Atoyac', '20', '0', '1', '302');
INSERT INTO `fcf_cities` VALUES ('2191', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Cajonos', '20', '0', '1', '303');
INSERT INTO `fcf_cities` VALUES ('2192', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Coxcaltepec Cántaros', '20', '0', '1', '304');
INSERT INTO `fcf_cities` VALUES ('2193', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Comitancillo', '20', '0', '1', '305');
INSERT INTO `fcf_cities` VALUES ('2194', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro el Alto', '20', '0', '1', '306');
INSERT INTO `fcf_cities` VALUES ('2195', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Huamelula', '20', '0', '1', '307');
INSERT INTO `fcf_cities` VALUES ('2196', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Huilotepec', '20', '0', '1', '308');
INSERT INTO `fcf_cities` VALUES ('2197', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Ixcatlán', '20', '0', '1', '309');
INSERT INTO `fcf_cities` VALUES ('2198', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Ixtlahuaca', '20', '0', '1', '310');
INSERT INTO `fcf_cities` VALUES ('2199', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Jaltepetongo', '20', '0', '1', '311');
INSERT INTO `fcf_cities` VALUES ('2200', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Jicayán', '20', '0', '1', '312');
INSERT INTO `fcf_cities` VALUES ('2201', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Jocotipac', '20', '0', '1', '313');
INSERT INTO `fcf_cities` VALUES ('2202', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Juchatengo', '20', '0', '1', '314');
INSERT INTO `fcf_cities` VALUES ('2203', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Mártir', '20', '0', '1', '315');
INSERT INTO `fcf_cities` VALUES ('2204', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Mártir Quiechapa', '20', '0', '1', '316');
INSERT INTO `fcf_cities` VALUES ('2205', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Mártir Yucuxaco', '20', '0', '1', '317');
INSERT INTO `fcf_cities` VALUES ('2206', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Mixtepec -Dto. 22 -', '20', '0', '1', '318');
INSERT INTO `fcf_cities` VALUES ('2207', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Mixtepec -Dto. 26 -', '20', '0', '1', '319');
INSERT INTO `fcf_cities` VALUES ('2208', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Molinos', '20', '0', '1', '320');
INSERT INTO `fcf_cities` VALUES ('2209', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Nopala', '20', '0', '1', '321');
INSERT INTO `fcf_cities` VALUES ('2210', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Ocopetatillo', '20', '0', '1', '322');
INSERT INTO `fcf_cities` VALUES ('2211', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Ocotepec', '20', '0', '1', '323');
INSERT INTO `fcf_cities` VALUES ('2212', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Pochutla', '20', '0', '1', '324');
INSERT INTO `fcf_cities` VALUES ('2213', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Quiatoni', '20', '0', '1', '325');
INSERT INTO `fcf_cities` VALUES ('2214', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Sochiápam', '20', '0', '1', '326');
INSERT INTO `fcf_cities` VALUES ('2215', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Tapanatepec', '20', '0', '1', '327');
INSERT INTO `fcf_cities` VALUES ('2216', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Taviche', '20', '0', '1', '328');
INSERT INTO `fcf_cities` VALUES ('2217', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Teozacoalco', '20', '0', '1', '329');
INSERT INTO `fcf_cities` VALUES ('2218', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Teutila', '20', '0', '1', '330');
INSERT INTO `fcf_cities` VALUES ('2219', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Tidaá', '20', '0', '1', '331');
INSERT INTO `fcf_cities` VALUES ('2220', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Topiltepec', '20', '0', '1', '332');
INSERT INTO `fcf_cities` VALUES ('2221', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Totolápam', '20', '0', '1', '333');
INSERT INTO `fcf_cities` VALUES ('2222', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa de Tututepec de Melchor Ocampo', '20', '0', '1', '334');
INSERT INTO `fcf_cities` VALUES ('2223', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Yaneri', '20', '0', '1', '335');
INSERT INTO `fcf_cities` VALUES ('2224', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Yólox', '20', '0', '1', '336');
INSERT INTO `fcf_cities` VALUES ('2225', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro y San Pablo Ayutla', '20', '0', '1', '337');
INSERT INTO `fcf_cities` VALUES ('2226', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa de Etla', '20', '0', '1', '338');
INSERT INTO `fcf_cities` VALUES ('2227', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro y San Pablo Teposcolula', '20', '0', '1', '339');
INSERT INTO `fcf_cities` VALUES ('2228', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro y San Pablo Tequixtepec', '20', '0', '1', '340');
INSERT INTO `fcf_cities` VALUES ('2229', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Pedro Yucunama', '20', '0', '1', '341');
INSERT INTO `fcf_cities` VALUES ('2230', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Raymundo Jalpan', '20', '0', '1', '342');
INSERT INTO `fcf_cities` VALUES ('2231', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Sebastián Abasolo', '20', '0', '1', '343');
INSERT INTO `fcf_cities` VALUES ('2232', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Sebastián Coatlán', '20', '0', '1', '344');
INSERT INTO `fcf_cities` VALUES ('2233', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Sebastián Ixcapa', '20', '0', '1', '345');
INSERT INTO `fcf_cities` VALUES ('2234', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Sebastián Nicananduta', '20', '0', '1', '346');
INSERT INTO `fcf_cities` VALUES ('2235', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Sebastián Río Hondo', '20', '0', '1', '347');
INSERT INTO `fcf_cities` VALUES ('2236', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Sebastián Tecomaxtlahuaca', '20', '0', '1', '348');
INSERT INTO `fcf_cities` VALUES ('2237', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Sebastián Teitipac', '20', '0', '1', '349');
INSERT INTO `fcf_cities` VALUES ('2238', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Sebastián Tutla', '20', '0', '1', '350');
INSERT INTO `fcf_cities` VALUES ('2239', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Simón Almolongas', '20', '0', '1', '351');
INSERT INTO `fcf_cities` VALUES ('2240', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Simón Zahuatlán', '20', '0', '1', '352');
INSERT INTO `fcf_cities` VALUES ('2241', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Ana', '20', '0', '1', '353');
INSERT INTO `fcf_cities` VALUES ('2242', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Ana Ateixtlahuaca', '20', '0', '1', '354');
INSERT INTO `fcf_cities` VALUES ('2243', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Ana Cuauhtémoc', '20', '0', '1', '355');
INSERT INTO `fcf_cities` VALUES ('2244', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Ana del Valle', '20', '0', '1', '356');
INSERT INTO `fcf_cities` VALUES ('2245', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Ana Tavela', '20', '0', '1', '357');
INSERT INTO `fcf_cities` VALUES ('2246', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Ana Tlapacoyan', '20', '0', '1', '358');
INSERT INTO `fcf_cities` VALUES ('2247', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Ana Yareni', '20', '0', '1', '359');
INSERT INTO `fcf_cities` VALUES ('2248', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Ana Zegache', '20', '0', '1', '360');
INSERT INTO `fcf_cities` VALUES ('2249', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catalina Quierí', '20', '0', '1', '361');
INSERT INTO `fcf_cities` VALUES ('2250', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catarina Cuixtla', '20', '0', '1', '362');
INSERT INTO `fcf_cities` VALUES ('2251', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catarina Ixtepeji', '20', '0', '1', '363');
INSERT INTO `fcf_cities` VALUES ('2252', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catarina Juquila', '20', '0', '1', '364');
INSERT INTO `fcf_cities` VALUES ('2253', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catarina Lachatao', '20', '0', '1', '365');
INSERT INTO `fcf_cities` VALUES ('2254', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catarina Loxicha', '20', '0', '1', '366');
INSERT INTO `fcf_cities` VALUES ('2255', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catarina Mechoacán', '20', '0', '1', '367');
INSERT INTO `fcf_cities` VALUES ('2256', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catarina Minas', '20', '0', '1', '368');
INSERT INTO `fcf_cities` VALUES ('2257', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catarina Quiané', '20', '0', '1', '369');
INSERT INTO `fcf_cities` VALUES ('2258', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catarina Tayata', '20', '0', '1', '370');
INSERT INTO `fcf_cities` VALUES ('2259', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catarina Ticuá', '20', '0', '1', '371');
INSERT INTO `fcf_cities` VALUES ('2260', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catarina Yosonotú', '20', '0', '1', '372');
INSERT INTO `fcf_cities` VALUES ('2261', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Catarina Zapoquila', '20', '0', '1', '373');
INSERT INTO `fcf_cities` VALUES ('2262', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Cruz Acatepec', '20', '0', '1', '374');
INSERT INTO `fcf_cities` VALUES ('2263', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Cruz Amilpas', '20', '0', '1', '375');
INSERT INTO `fcf_cities` VALUES ('2264', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Cruz de Bravo', '20', '0', '1', '376');
INSERT INTO `fcf_cities` VALUES ('2265', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Cruz Itundujia', '20', '0', '1', '377');
INSERT INTO `fcf_cities` VALUES ('2266', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Cruz Mixtepec', '20', '0', '1', '378');
INSERT INTO `fcf_cities` VALUES ('2267', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Cruz Nundaco', '20', '0', '1', '379');
INSERT INTO `fcf_cities` VALUES ('2268', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Cruz Papalutla', '20', '0', '1', '380');
INSERT INTO `fcf_cities` VALUES ('2269', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Cruz Tacache de Mina', '20', '0', '1', '381');
INSERT INTO `fcf_cities` VALUES ('2270', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Cruz Tacahua', '20', '0', '1', '382');
INSERT INTO `fcf_cities` VALUES ('2271', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Cruz Tayata', '20', '0', '1', '383');
INSERT INTO `fcf_cities` VALUES ('2272', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Cruz Xitla', '20', '0', '1', '384');
INSERT INTO `fcf_cities` VALUES ('2273', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Cruz Xoxocotlán', '20', '0', '1', '385');
INSERT INTO `fcf_cities` VALUES ('2274', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Cruz Zenzontepec', '20', '0', '1', '386');
INSERT INTO `fcf_cities` VALUES ('2275', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Gertrudis', '20', '0', '1', '387');
INSERT INTO `fcf_cities` VALUES ('2276', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Inés del Monte', '20', '0', '1', '388');
INSERT INTO `fcf_cities` VALUES ('2277', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Inés Yatzeche', '20', '0', '1', '389');
INSERT INTO `fcf_cities` VALUES ('2278', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Lucía del Camino', '20', '0', '1', '390');
INSERT INTO `fcf_cities` VALUES ('2279', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Lucía Miahuatlán', '20', '0', '1', '391');
INSERT INTO `fcf_cities` VALUES ('2280', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Lucía Monteverde', '20', '0', '1', '392');
INSERT INTO `fcf_cities` VALUES ('2281', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Lucía Ocotlán', '20', '0', '1', '393');
INSERT INTO `fcf_cities` VALUES ('2282', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Alotepec', '20', '0', '1', '394');
INSERT INTO `fcf_cities` VALUES ('2283', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Apazco', '20', '0', '1', '395');
INSERT INTO `fcf_cities` VALUES ('2284', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María la Asunción', '20', '0', '1', '396');
INSERT INTO `fcf_cities` VALUES ('2285', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Heroica Ciudad de Tlaxiaco', '20', '0', '1', '397');
INSERT INTO `fcf_cities` VALUES ('2286', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Ayoquezco de Aldama', '20', '0', '1', '398');
INSERT INTO `fcf_cities` VALUES ('2287', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Atzompa', '20', '0', '1', '399');
INSERT INTO `fcf_cities` VALUES ('2288', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Camotlán', '20', '0', '1', '400');
INSERT INTO `fcf_cities` VALUES ('2289', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Colotepec', '20', '0', '1', '401');
INSERT INTO `fcf_cities` VALUES ('2290', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Cortijo', '20', '0', '1', '402');
INSERT INTO `fcf_cities` VALUES ('2291', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Coyotepec', '20', '0', '1', '403');
INSERT INTO `fcf_cities` VALUES ('2292', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Chachoápam', '20', '0', '1', '404');
INSERT INTO `fcf_cities` VALUES ('2293', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa de Chilapa de Díaz', '20', '0', '1', '405');
INSERT INTO `fcf_cities` VALUES ('2294', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Chilchotla', '20', '0', '1', '406');
INSERT INTO `fcf_cities` VALUES ('2295', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Chimalapa', '20', '0', '1', '407');
INSERT INTO `fcf_cities` VALUES ('2296', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María del Rosario', '20', '0', '1', '408');
INSERT INTO `fcf_cities` VALUES ('2297', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María del Tule', '20', '0', '1', '409');
INSERT INTO `fcf_cities` VALUES ('2298', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Ecatepec', '20', '0', '1', '410');
INSERT INTO `fcf_cities` VALUES ('2299', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Guelacé', '20', '0', '1', '411');
INSERT INTO `fcf_cities` VALUES ('2300', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Guienagati', '20', '0', '1', '412');
INSERT INTO `fcf_cities` VALUES ('2301', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Huatulco', '20', '0', '1', '413');
INSERT INTO `fcf_cities` VALUES ('2302', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Huazolotitlán', '20', '0', '1', '414');
INSERT INTO `fcf_cities` VALUES ('2303', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Ipalapa', '20', '0', '1', '415');
INSERT INTO `fcf_cities` VALUES ('2304', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Ixcatlán', '20', '0', '1', '416');
INSERT INTO `fcf_cities` VALUES ('2305', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Jacatepec', '20', '0', '1', '417');
INSERT INTO `fcf_cities` VALUES ('2306', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Jalapa del Marqués', '20', '0', '1', '418');
INSERT INTO `fcf_cities` VALUES ('2307', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Jaltianguis', '20', '0', '1', '419');
INSERT INTO `fcf_cities` VALUES ('2308', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Lachixío', '20', '0', '1', '420');
INSERT INTO `fcf_cities` VALUES ('2309', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Mixtequilla', '20', '0', '1', '421');
INSERT INTO `fcf_cities` VALUES ('2310', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Nativitas', '20', '0', '1', '422');
INSERT INTO `fcf_cities` VALUES ('2311', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Nduayaco', '20', '0', '1', '423');
INSERT INTO `fcf_cities` VALUES ('2312', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Ozolotepec', '20', '0', '1', '424');
INSERT INTO `fcf_cities` VALUES ('2313', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Pápalo', '20', '0', '1', '425');
INSERT INTO `fcf_cities` VALUES ('2314', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Peñoles', '20', '0', '1', '426');
INSERT INTO `fcf_cities` VALUES ('2315', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Petapa', '20', '0', '1', '427');
INSERT INTO `fcf_cities` VALUES ('2316', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Quiegolani', '20', '0', '1', '428');
INSERT INTO `fcf_cities` VALUES ('2317', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Sola', '20', '0', '1', '429');
INSERT INTO `fcf_cities` VALUES ('2318', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Tataltepec', '20', '0', '1', '430');
INSERT INTO `fcf_cities` VALUES ('2319', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Tecomavaca', '20', '0', '1', '431');
INSERT INTO `fcf_cities` VALUES ('2320', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Temaxcalapa', '20', '0', '1', '432');
INSERT INTO `fcf_cities` VALUES ('2321', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Temaxcaltepec', '20', '0', '1', '433');
INSERT INTO `fcf_cities` VALUES ('2322', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Teopoxco', '20', '0', '1', '434');
INSERT INTO `fcf_cities` VALUES ('2323', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Tepantlali', '20', '0', '1', '435');
INSERT INTO `fcf_cities` VALUES ('2324', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Texcatitlán', '20', '0', '1', '436');
INSERT INTO `fcf_cities` VALUES ('2325', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Tlahuitoltepec', '20', '0', '1', '437');
INSERT INTO `fcf_cities` VALUES ('2326', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Tlalixtac', '20', '0', '1', '438');
INSERT INTO `fcf_cities` VALUES ('2327', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Tonameca', '20', '0', '1', '439');
INSERT INTO `fcf_cities` VALUES ('2328', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Totolapilla', '20', '0', '1', '440');
INSERT INTO `fcf_cities` VALUES ('2329', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Xadani', '20', '0', '1', '441');
INSERT INTO `fcf_cities` VALUES ('2330', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Yalina', '20', '0', '1', '442');
INSERT INTO `fcf_cities` VALUES ('2331', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Yavesía', '20', '0', '1', '443');
INSERT INTO `fcf_cities` VALUES ('2332', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Yolotepec', '20', '0', '1', '444');
INSERT INTO `fcf_cities` VALUES ('2333', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Yosoyúa', '20', '0', '1', '445');
INSERT INTO `fcf_cities` VALUES ('2334', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Yucuhiti', '20', '0', '1', '446');
INSERT INTO `fcf_cities` VALUES ('2335', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Zacatepec', '20', '0', '1', '447');
INSERT INTO `fcf_cities` VALUES ('2336', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Zaniza', '20', '0', '1', '448');
INSERT INTO `fcf_cities` VALUES ('2337', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa María Zoquitlán', '20', '0', '1', '449');
INSERT INTO `fcf_cities` VALUES ('2338', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Amoltepec', '20', '0', '1', '450');
INSERT INTO `fcf_cities` VALUES ('2339', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Apoala', '20', '0', '1', '451');
INSERT INTO `fcf_cities` VALUES ('2340', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Apóstol', '20', '0', '1', '452');
INSERT INTO `fcf_cities` VALUES ('2341', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Astata', '20', '0', '1', '453');
INSERT INTO `fcf_cities` VALUES ('2342', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Atitlán', '20', '0', '1', '454');
INSERT INTO `fcf_cities` VALUES ('2343', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Ayuquililla', '20', '0', '1', '455');
INSERT INTO `fcf_cities` VALUES ('2344', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Cacaloxtepec', '20', '0', '1', '456');
INSERT INTO `fcf_cities` VALUES ('2345', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Camotlán', '20', '0', '1', '457');
INSERT INTO `fcf_cities` VALUES ('2346', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Comaltepec', '20', '0', '1', '458');
INSERT INTO `fcf_cities` VALUES ('2347', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Chazumba', '20', '0', '1', '459');
INSERT INTO `fcf_cities` VALUES ('2348', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Choápam', '20', '0', '1', '460');
INSERT INTO `fcf_cities` VALUES ('2349', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago del Río', '20', '0', '1', '461');
INSERT INTO `fcf_cities` VALUES ('2350', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Huajolotitlán', '20', '0', '1', '462');
INSERT INTO `fcf_cities` VALUES ('2351', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Huauclilla', '20', '0', '1', '463');
INSERT INTO `fcf_cities` VALUES ('2352', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Ihuitlán Plumas', '20', '0', '1', '464');
INSERT INTO `fcf_cities` VALUES ('2353', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Ixcuintepec', '20', '0', '1', '465');
INSERT INTO `fcf_cities` VALUES ('2354', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Ixtayutla', '20', '0', '1', '466');
INSERT INTO `fcf_cities` VALUES ('2355', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Jamiltepec', '20', '0', '1', '467');
INSERT INTO `fcf_cities` VALUES ('2356', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Jocotepec', '20', '0', '1', '468');
INSERT INTO `fcf_cities` VALUES ('2357', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Juxtlahuaca', '20', '0', '1', '469');
INSERT INTO `fcf_cities` VALUES ('2358', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Lachiguiri', '20', '0', '1', '470');
INSERT INTO `fcf_cities` VALUES ('2359', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Lalopa', '20', '0', '1', '471');
INSERT INTO `fcf_cities` VALUES ('2360', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Laollaga', '20', '0', '1', '472');
INSERT INTO `fcf_cities` VALUES ('2361', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Laxopa', '20', '0', '1', '473');
INSERT INTO `fcf_cities` VALUES ('2362', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Llano Grande', '20', '0', '1', '474');
INSERT INTO `fcf_cities` VALUES ('2363', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Matatlán', '20', '0', '1', '475');
INSERT INTO `fcf_cities` VALUES ('2364', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Miltepec', '20', '0', '1', '476');
INSERT INTO `fcf_cities` VALUES ('2365', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Minas', '20', '0', '1', '477');
INSERT INTO `fcf_cities` VALUES ('2366', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Nacaltepec', '20', '0', '1', '478');
INSERT INTO `fcf_cities` VALUES ('2367', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Nejapilla', '20', '0', '1', '479');
INSERT INTO `fcf_cities` VALUES ('2368', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Nundiche', '20', '0', '1', '480');
INSERT INTO `fcf_cities` VALUES ('2369', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Nuyoó', '20', '0', '1', '481');
INSERT INTO `fcf_cities` VALUES ('2370', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Pinotepa Nacional', '20', '0', '1', '482');
INSERT INTO `fcf_cities` VALUES ('2371', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Suchilquitongo', '20', '0', '1', '483');
INSERT INTO `fcf_cities` VALUES ('2372', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Tamazola', '20', '0', '1', '484');
INSERT INTO `fcf_cities` VALUES ('2373', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Tapextla', '20', '0', '1', '485');
INSERT INTO `fcf_cities` VALUES ('2374', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Tejúpam de la Unión', '20', '0', '1', '486');
INSERT INTO `fcf_cities` VALUES ('2375', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Tenango', '20', '0', '1', '487');
INSERT INTO `fcf_cities` VALUES ('2376', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Tepetlapa', '20', '0', '1', '488');
INSERT INTO `fcf_cities` VALUES ('2377', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Tetepec', '20', '0', '1', '489');
INSERT INTO `fcf_cities` VALUES ('2378', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Texcalcingo', '20', '0', '1', '490');
INSERT INTO `fcf_cities` VALUES ('2379', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Textitlán', '20', '0', '1', '491');
INSERT INTO `fcf_cities` VALUES ('2380', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Tilantongo', '20', '0', '1', '492');
INSERT INTO `fcf_cities` VALUES ('2381', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Tillo', '20', '0', '1', '493');
INSERT INTO `fcf_cities` VALUES ('2382', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Tlazoyaltepec', '20', '0', '1', '494');
INSERT INTO `fcf_cities` VALUES ('2383', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Xanica', '20', '0', '1', '495');
INSERT INTO `fcf_cities` VALUES ('2384', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Xiacuí', '20', '0', '1', '496');
INSERT INTO `fcf_cities` VALUES ('2385', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Yaitepec', '20', '0', '1', '497');
INSERT INTO `fcf_cities` VALUES ('2386', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Yaveo', '20', '0', '1', '498');
INSERT INTO `fcf_cities` VALUES ('2387', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Yolomécatl', '20', '0', '1', '499');
INSERT INTO `fcf_cities` VALUES ('2388', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Yosondúa', '20', '0', '1', '500');
INSERT INTO `fcf_cities` VALUES ('2389', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Yucuyachi', '20', '0', '1', '501');
INSERT INTO `fcf_cities` VALUES ('2390', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Zacatepec', '20', '0', '1', '502');
INSERT INTO `fcf_cities` VALUES ('2391', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santiago Zoochila', '20', '0', '1', '503');
INSERT INTO `fcf_cities` VALUES ('2392', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Nuevo Zoquiápam', '20', '0', '1', '504');
INSERT INTO `fcf_cities` VALUES ('2393', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Ingenio', '20', '0', '1', '505');
INSERT INTO `fcf_cities` VALUES ('2394', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Albarradas', '20', '0', '1', '506');
INSERT INTO `fcf_cities` VALUES ('2395', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Armenta', '20', '0', '1', '507');
INSERT INTO `fcf_cities` VALUES ('2396', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Chihuitán', '20', '0', '1', '508');
INSERT INTO `fcf_cities` VALUES ('2397', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo de Morelos', '20', '0', '1', '509');
INSERT INTO `fcf_cities` VALUES ('2398', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Ixcatlán', '20', '0', '1', '510');
INSERT INTO `fcf_cities` VALUES ('2399', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Nuxaá', '20', '0', '1', '511');
INSERT INTO `fcf_cities` VALUES ('2400', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Ozolotepec', '20', '0', '1', '512');
INSERT INTO `fcf_cities` VALUES ('2401', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Petapa', '20', '0', '1', '513');
INSERT INTO `fcf_cities` VALUES ('2402', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Roayaga', '20', '0', '1', '514');
INSERT INTO `fcf_cities` VALUES ('2403', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Tehuantepec', '20', '0', '1', '515');
INSERT INTO `fcf_cities` VALUES ('2404', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Teojomulco', '20', '0', '1', '516');
INSERT INTO `fcf_cities` VALUES ('2405', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Tepuxtepec', '20', '0', '1', '517');
INSERT INTO `fcf_cities` VALUES ('2406', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Tlatayápam', '20', '0', '1', '518');
INSERT INTO `fcf_cities` VALUES ('2407', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Tomaltepec', '20', '0', '1', '519');
INSERT INTO `fcf_cities` VALUES ('2408', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Tonalá', '20', '0', '1', '520');
INSERT INTO `fcf_cities` VALUES ('2409', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Tonaltepec', '20', '0', '1', '521');
INSERT INTO `fcf_cities` VALUES ('2410', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Xagacía', '20', '0', '1', '522');
INSERT INTO `fcf_cities` VALUES ('2411', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Yanhuitlán', '20', '0', '1', '523');
INSERT INTO `fcf_cities` VALUES ('2412', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Yodohino', '20', '0', '1', '524');
INSERT INTO `fcf_cities` VALUES ('2413', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Domingo Zanatepec', '20', '0', '1', '525');
INSERT INTO `fcf_cities` VALUES ('2414', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santos Reyes Nopala', '20', '0', '1', '526');
INSERT INTO `fcf_cities` VALUES ('2415', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santos Reyes Pápalo', '20', '0', '1', '527');
INSERT INTO `fcf_cities` VALUES ('2416', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santos Reyes Tepejillo', '20', '0', '1', '528');
INSERT INTO `fcf_cities` VALUES ('2417', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santos Reyes Yucuná', '20', '0', '1', '529');
INSERT INTO `fcf_cities` VALUES ('2418', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Tomás Jalieza', '20', '0', '1', '530');
INSERT INTO `fcf_cities` VALUES ('2419', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Tomás Mazaltepec', '20', '0', '1', '531');
INSERT INTO `fcf_cities` VALUES ('2420', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Tomás Ocotepec', '20', '0', '1', '532');
INSERT INTO `fcf_cities` VALUES ('2421', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santo Tomás Tamazulapan', '20', '0', '1', '533');
INSERT INTO `fcf_cities` VALUES ('2422', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Vicente Coatlán', '20', '0', '1', '534');
INSERT INTO `fcf_cities` VALUES ('2423', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Vicente Lachixío', '20', '0', '1', '535');
INSERT INTO `fcf_cities` VALUES ('2424', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Vicente Nuñú', '20', '0', '1', '536');
INSERT INTO `fcf_cities` VALUES ('2425', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Silacayoápam', '20', '0', '1', '537');
INSERT INTO `fcf_cities` VALUES ('2426', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Sitio de Xitlapehua', '20', '0', '1', '538');
INSERT INTO `fcf_cities` VALUES ('2427', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Soledad Etla', '20', '0', '1', '539');
INSERT INTO `fcf_cities` VALUES ('2428', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa de Tamazulápam del Progreso', '20', '0', '1', '540');
INSERT INTO `fcf_cities` VALUES ('2429', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tanetze de Zaragoza', '20', '0', '1', '541');
INSERT INTO `fcf_cities` VALUES ('2430', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Taniche', '20', '0', '1', '542');
INSERT INTO `fcf_cities` VALUES ('2431', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tataltepec de Valdés', '20', '0', '1', '543');
INSERT INTO `fcf_cities` VALUES ('2432', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teococuilco de Marcos Pérez', '20', '0', '1', '544');
INSERT INTO `fcf_cities` VALUES ('2433', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teotitlán de Flores Magón', '20', '0', '1', '545');
INSERT INTO `fcf_cities` VALUES ('2434', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teotitlán del Valle', '20', '0', '1', '546');
INSERT INTO `fcf_cities` VALUES ('2435', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Teotongo', '20', '0', '1', '547');
INSERT INTO `fcf_cities` VALUES ('2436', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tepelmeme Villa de Morelos', '20', '0', '1', '548');
INSERT INTO `fcf_cities` VALUES ('2437', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tezoatlán de Segura y Luna', '20', '0', '1', '549');
INSERT INTO `fcf_cities` VALUES ('2438', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Jerónimo Tlacochahuaya', '20', '0', '1', '550');
INSERT INTO `fcf_cities` VALUES ('2439', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlacolula de Matamoros', '20', '0', '1', '551');
INSERT INTO `fcf_cities` VALUES ('2440', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlacotepec Plumas', '20', '0', '1', '552');
INSERT INTO `fcf_cities` VALUES ('2441', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Tlalixtac de Cabrera', '20', '0', '1', '553');
INSERT INTO `fcf_cities` VALUES ('2442', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Totontepec Villa de Morelos', '20', '0', '1', '554');
INSERT INTO `fcf_cities` VALUES ('2443', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Trinidad Zaachila', '20', '0', '1', '555');
INSERT INTO `fcf_cities` VALUES ('2444', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'La Trinidad Vista Hermosa', '20', '0', '1', '556');
INSERT INTO `fcf_cities` VALUES ('2445', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Unión Hidalgo', '20', '0', '1', '557');
INSERT INTO `fcf_cities` VALUES ('2446', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Valerio Trujano', '20', '0', '1', '558');
INSERT INTO `fcf_cities` VALUES ('2447', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Juan Bautista Valle Nacional', '20', '0', '1', '559');
INSERT INTO `fcf_cities` VALUES ('2448', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa Díaz Ordaz', '20', '0', '1', '560');
INSERT INTO `fcf_cities` VALUES ('2449', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yaxe', '20', '0', '1', '561');
INSERT INTO `fcf_cities` VALUES ('2450', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Magdalena Yodocono de Porfirio Díaz', '20', '0', '1', '562');
INSERT INTO `fcf_cities` VALUES ('2451', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yogana', '20', '0', '1', '563');
INSERT INTO `fcf_cities` VALUES ('2452', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Yutanduchi de Guerrero', '20', '0', '1', '564');
INSERT INTO `fcf_cities` VALUES ('2453', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Villa de Zaachila', '20', '0', '1', '565');
INSERT INTO `fcf_cities` VALUES ('2454', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'San Mateo Yucutindoo', '20', '0', '1', '566');
INSERT INTO `fcf_cities` VALUES ('2455', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zapotitlán Lagunas', '20', '0', '1', '567');
INSERT INTO `fcf_cities` VALUES ('2456', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zapotitlán Palmas', '20', '0', '1', '568');
INSERT INTO `fcf_cities` VALUES ('2457', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Santa Inés de Zaragoza', '20', '0', '1', '569');
INSERT INTO `fcf_cities` VALUES ('2458', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Zimatlán de Álvarez', '20', '0', '1', '570');

-- ----------------------------
-- Table structure for fcf_companies
-- ----------------------------
DROP TABLE IF EXISTS `fcf_companies`;
CREATE TABLE `fcf_companies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `taxid` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_regimen_id` int(10) unsigned DEFAULT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_mobile` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_1` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_2` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_3` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_4` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_5` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_6` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city_id` int(10) unsigned DEFAULT NULL,
  `state_id` int(10) unsigned DEFAULT NULL,
  `country_id` int(10) unsigned NOT NULL,
  `postcode` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_cer` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password_key` text COLLATE utf8mb4_unicode_ci,
  `file_pfx` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `certificate_number` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `color_primary` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_price_decimal_place` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pdf_template` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `complemento_cfdi_iedu` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `curp` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `complemento_cfdi_foreign_trade` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `employer_register` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `module_customer_quotations` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modulecq_terms_of_sale` text COLLATE utf8mb4_unicode_ci,
  `module_payroll` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modulepayr_legend` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `companies_tax_regimen_id_foreign` (`tax_regimen_id`),
  KEY `companies_city_id_foreign` (`city_id`),
  KEY `companies_state_id_foreign` (`state_id`),
  KEY `companies_country_id_foreign` (`country_id`),
  CONSTRAINT `companies_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `fcf_cities` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `companies_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `fcf_countries` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `companies_state_id_foreign` FOREIGN KEY (`state_id`) REFERENCES `fcf_states` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `companies_tax_regimen_id_foreign` FOREIGN KEY (`tax_regimen_id`) REFERENCES `fcf_tax_regimens` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_companies
-- ----------------------------
INSERT INTO `fcf_companies` VALUES ('1', '2019-12-25 21:15:57', '2019-12-25 21:16:00', '1', '40', 'VOZ ORDA CARA SA DE CV', '', 'VOC990129I26', null, 'margarita@gmail.com', '4421096112', null, '', '', null, '', null, null, null, null, '1', '', null, null, null, null, null, null, null, null, '0', '1', null, null, null, null, null, null, null, null, null, '1', null);

-- ----------------------------
-- Table structure for fcf_company_bank_accounts
-- ----------------------------
DROP TABLE IF EXISTS `fcf_company_bank_accounts`;
CREATE TABLE `fcf_company_bank_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `company_id` int(10) unsigned NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bank_id` int(10) unsigned NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `company_bank_accounts_company_id_foreign` (`company_id`),
  KEY `company_bank_accounts_bank_id_foreign` (`bank_id`),
  KEY `company_bank_accounts_currency_id_foreign` (`currency_id`),
  CONSTRAINT `company_bank_accounts_bank_id_foreign` FOREIGN KEY (`bank_id`) REFERENCES `fcf_banks` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `company_bank_accounts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `fcf_companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `company_bank_accounts_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `fcf_currencies` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_company_bank_accounts
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_contract_types
-- ----------------------------
DROP TABLE IF EXISTS `fcf_contract_types`;
CREATE TABLE `fcf_contract_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_contract_types
-- ----------------------------
INSERT INTO `fcf_contract_types` VALUES ('1', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Contrato de trabajo por tiempo indeterminado', '01', '1', '1');
INSERT INTO `fcf_contract_types` VALUES ('2', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Contrato de trabajo para obra determinada', '02', '2', '1');
INSERT INTO `fcf_contract_types` VALUES ('3', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Contrato de trabajo por tiempo determinado', '03', '3', '1');
INSERT INTO `fcf_contract_types` VALUES ('4', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Contrato de trabajo por temporada', '04', '4', '1');
INSERT INTO `fcf_contract_types` VALUES ('5', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Contrato de trabajo sujeto a prueba', '05', '5', '1');
INSERT INTO `fcf_contract_types` VALUES ('6', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Contrato de trabajo con capacitación inicial', '06', '6', '1');
INSERT INTO `fcf_contract_types` VALUES ('7', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Modalidad de contratación por pago de hora laborada', '07', '7', '1');
INSERT INTO `fcf_contract_types` VALUES ('8', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Modalidad de trabajo por comisión laboral', '08', '8', '1');
INSERT INTO `fcf_contract_types` VALUES ('9', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Modalidades de contratación donde no existe relación de trabajo', '09', '9', '1');
INSERT INTO `fcf_contract_types` VALUES ('10', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Jubilación, pensión, retiro.', '10', '10', '1');
INSERT INTO `fcf_contract_types` VALUES ('11', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Otro contrato', '99', '11', '1');

-- ----------------------------
-- Table structure for fcf_countries
-- ----------------------------
DROP TABLE IF EXISTS `fcf_countries`;
CREATE TABLE `fcf_countries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_countries
-- ----------------------------
INSERT INTO `fcf_countries` VALUES ('1', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'México', 'MEX', '1', '1');
INSERT INTO `fcf_countries` VALUES ('2', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Estados Unidos', 'USA', '2', '1');
INSERT INTO `fcf_countries` VALUES ('3', '2019-12-25 21:15:56', '2019-12-25 21:15:56', null, null, 'Canadá', 'CAN', '3', '1');

-- ----------------------------
-- Table structure for fcf_currencies
-- ----------------------------
DROP TABLE IF EXISTS `fcf_currencies`;
CREATE TABLE `fcf_currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate` decimal(15,8) NOT NULL DEFAULT '0.00000000',
  `decimal_place` int(10) unsigned NOT NULL DEFAULT '2',
  `symbol` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `symbol_position` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'L',
  `decimal_mark` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '.',
  `thousands_separator` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ',',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_currencies
-- ----------------------------
INSERT INTO `fcf_currencies` VALUES ('1', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '2', '2', 'Peso mexicano', 'MXN', '1.00000000', '2', '$', 'L', '.', ',', '1', '1');
INSERT INTO `fcf_currencies` VALUES ('2', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '9', '2', 'Dolar americano', 'USD', '20.13290000', '2', '$', 'L', '.', ',', '2', '1');
INSERT INTO `fcf_currencies` VALUES ('3', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '1', '9', 'Euro', 'EUR', '22.94240000', '2', '€', 'L', ',', '.', '3', '1');

-- ----------------------------
-- Table structure for fcf_customer_bank_accounts
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_bank_accounts`;
CREATE TABLE `fcf_customer_bank_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `customer_id` int(10) unsigned NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bank_id` int(10) unsigned NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `customer_bank_accounts_customer_id_foreign` (`customer_id`),
  KEY `customer_bank_accounts_bank_id_foreign` (`bank_id`),
  KEY `customer_bank_accounts_currency_id_foreign` (`currency_id`),
  CONSTRAINT `customer_bank_accounts_bank_id_foreign` FOREIGN KEY (`bank_id`) REFERENCES `fcf_banks` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_bank_accounts_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `fcf_currencies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_bank_accounts_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `fcf_customers` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_bank_accounts
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customer_iedus
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_iedus`;
CREATE TABLE `fcf_customer_iedus` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nombre_alumno` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `curp` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `iedu_nivel_educativo_id` int(10) unsigned DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `customer_iedus_customer_id_foreign` (`customer_id`),
  KEY `customer_iedus_iedu_nivel_educativo_id_foreign` (`iedu_nivel_educativo_id`),
  CONSTRAINT `customer_iedus_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `fcf_customers` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_iedus_iedu_nivel_educativo_id_foreign` FOREIGN KEY (`iedu_nivel_educativo_id`) REFERENCES `fcf_iedu_nivel_educativos` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_iedus
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customer_invoice_cfdis
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_invoice_cfdis`;
CREATE TABLE `fcf_customer_invoice_cfdis` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `customer_invoice_id` int(10) unsigned NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pac_id` int(10) unsigned DEFAULT NULL,
  `cfdi_version` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `file_xml` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_xml_pac` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cancel_date` datetime DEFAULT NULL,
  `cancel_response` text COLLATE utf8mb4_unicode_ci,
  `cancel_state` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `customer_invoice_cfdis_customer_invoice_id_foreign` (`customer_invoice_id`),
  KEY `customer_invoice_cfdis_pac_id_foreign` (`pac_id`),
  CONSTRAINT `customer_invoice_cfdis_customer_invoice_id_foreign` FOREIGN KEY (`customer_invoice_id`) REFERENCES `fcf_customer_invoices` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoice_cfdis_pac_id_foreign` FOREIGN KEY (`pac_id`) REFERENCES `fcf_pacs` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_invoice_cfdis
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customer_invoice_line_complements
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_invoice_line_complements`;
CREATE TABLE `fcf_customer_invoice_line_complements` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `customer_invoice_line_id` int(10) unsigned DEFAULT NULL,
  `name` text COLLATE utf8mb4_unicode_ci,
  `customer_iedu_id` int(10) unsigned DEFAULT NULL,
  `iedu_nombre_alumno` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `iedu_curp` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `iedu_nivel_educativo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `iedu_aut_rvoe` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `iedu_rfc_pago` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `numero_predial` text COLLATE utf8mb4_unicode_ci,
  `tariff_fraction_id` int(10) unsigned DEFAULT NULL,
  `customs_quantity` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `uom_custom_id` int(10) unsigned DEFAULT NULL,
  `price_unit_usd` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_usd` decimal(15,5) NOT NULL DEFAULT '0.00000',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `cin_line_complements_customer_invoice_line_id_fk` (`customer_invoice_line_id`),
  KEY `cin_line_complements_customer_iedu_id_fk` (`customer_iedu_id`),
  KEY `customer_invoice_line_complements_tariff_fraction_id_foreign` (`tariff_fraction_id`),
  KEY `customer_invoice_line_complements_uom_custom_id_foreign` (`uom_custom_id`),
  CONSTRAINT `cin_line_complements_customer_iedu_id_fk` FOREIGN KEY (`customer_iedu_id`) REFERENCES `fcf_customer_iedus` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `cin_line_complements_customer_invoice_line_id_fk` FOREIGN KEY (`customer_invoice_line_id`) REFERENCES `fcf_customer_invoice_lines` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoice_line_complements_tariff_fraction_id_foreign` FOREIGN KEY (`tariff_fraction_id`) REFERENCES `fcf_tariff_fractions` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoice_line_complements_uom_custom_id_foreign` FOREIGN KEY (`uom_custom_id`) REFERENCES `fcf_uom_customs` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_invoice_line_complements
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customer_invoice_line_taxes
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_invoice_line_taxes`;
CREATE TABLE `fcf_customer_invoice_line_taxes` (
  `customer_invoice_line_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`customer_invoice_line_id`,`tax_id`),
  KEY `customer_invoice_line_id` (`customer_invoice_line_id`) USING BTREE,
  KEY `tax_id` (`tax_id`) USING BTREE,
  CONSTRAINT `customer_invoice_line_taxes_customer_invoice_line_id_foreign` FOREIGN KEY (`customer_invoice_line_id`) REFERENCES `fcf_customer_invoice_lines` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoice_line_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `fcf_taxes` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_invoice_line_taxes
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customer_invoice_line_transfers
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_invoice_line_transfers`;
CREATE TABLE `fcf_customer_invoice_line_transfers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `customer_invoice_id` int(10) unsigned NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `weight` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `m3` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `liters` decimal(15,3) NOT NULL DEFAULT '0.000',
  `packaging` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `customer_invoice_line_transfers_customer_invoice_id_foreign` (`customer_invoice_id`),
  KEY `customer_invoice_line_transfers_product_id_foreign` (`product_id`),
  CONSTRAINT `customer_invoice_line_transfers_customer_invoice_id_foreign` FOREIGN KEY (`customer_invoice_id`) REFERENCES `fcf_customer_invoices` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoice_line_transfers_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `fcf_products` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_invoice_line_transfers
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customer_invoice_lines
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_invoice_lines`;
CREATE TABLE `fcf_customer_invoice_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `customer_invoice_id` int(10) unsigned NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `sat_product_id` int(10) unsigned DEFAULT NULL,
  `unit_measure_id` int(10) unsigned DEFAULT NULL,
  `quantity` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `price_unit` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `discount` decimal(15,3) NOT NULL DEFAULT '0.000',
  `price_reduce` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_discount` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_untaxed` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_tax` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_tax_ret` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_total` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `customer_invoice_lines_customer_invoice_id_foreign` (`customer_invoice_id`),
  KEY `customer_invoice_lines_product_id_foreign` (`product_id`),
  KEY `customer_invoice_lines_sat_product_id_foreign` (`sat_product_id`),
  KEY `customer_invoice_lines_unit_measure_id_foreign` (`unit_measure_id`),
  CONSTRAINT `customer_invoice_lines_customer_invoice_id_foreign` FOREIGN KEY (`customer_invoice_id`) REFERENCES `fcf_customer_invoices` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoice_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `fcf_products` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoice_lines_sat_product_id_foreign` FOREIGN KEY (`sat_product_id`) REFERENCES `fcf_sat_products` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoice_lines_unit_measure_id_foreign` FOREIGN KEY (`unit_measure_id`) REFERENCES `fcf_unit_measures` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_invoice_lines
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customer_invoice_reconcileds
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_invoice_reconcileds`;
CREATE TABLE `fcf_customer_invoice_reconcileds` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `customer_invoice_id` int(10) unsigned NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `reconciled_id` int(10) unsigned DEFAULT NULL,
  `currency_value` decimal(15,8) DEFAULT '0.00000000',
  `amount_reconciled` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `last_balance` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `number_of_payment` int(11) NOT NULL DEFAULT '1',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `customer_invoice_reconcileds_customer_invoice_id_foreign` (`customer_invoice_id`),
  KEY `customer_invoice_reconcileds_reconciled_id_foreign` (`reconciled_id`),
  CONSTRAINT `customer_invoice_reconcileds_customer_invoice_id_foreign` FOREIGN KEY (`customer_invoice_id`) REFERENCES `fcf_customer_invoices` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoice_reconcileds_reconciled_id_foreign` FOREIGN KEY (`reconciled_id`) REFERENCES `fcf_customer_invoices` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_invoice_reconcileds
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customer_invoice_relations
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_invoice_relations`;
CREATE TABLE `fcf_customer_invoice_relations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `customer_invoice_id` int(10) unsigned NOT NULL,
  `relation_id` int(10) unsigned DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `uuid_related` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `customer_invoice_relations_customer_invoice_id_foreign` (`customer_invoice_id`),
  KEY `customer_invoice_relations_relation_id_foreign` (`relation_id`),
  CONSTRAINT `customer_invoice_relations_customer_invoice_id_foreign` FOREIGN KEY (`customer_invoice_id`) REFERENCES `fcf_customer_invoices` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoice_relations_relation_id_foreign` FOREIGN KEY (`relation_id`) REFERENCES `fcf_customer_invoices` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_invoice_relations
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customer_invoice_taxes
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_invoice_taxes`;
CREATE TABLE `fcf_customer_invoice_taxes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `customer_invoice_id` int(10) unsigned NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  `amount_base` decimal(15,5) DEFAULT '0.00000',
  `amount_tax` decimal(15,5) DEFAULT '0.00000',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `customer_invoice_taxes_customer_invoice_id_foreign` (`customer_invoice_id`),
  KEY `customer_invoice_taxes_tax_id_foreign` (`tax_id`),
  CONSTRAINT `customer_invoice_taxes_customer_invoice_id_foreign` FOREIGN KEY (`customer_invoice_id`) REFERENCES `fcf_customer_invoices` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoice_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `fcf_taxes` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_invoice_taxes
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customer_invoices
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_invoices`;
CREATE TABLE `fcf_customer_invoices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `serie` varchar(34) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folio` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `date_due` date DEFAULT NULL,
  `reference` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `branch_office_id` int(10) unsigned DEFAULT NULL,
  `payment_term_id` int(10) unsigned DEFAULT NULL,
  `payment_way_id` int(10) unsigned DEFAULT NULL,
  `payment_method_id` int(10) unsigned DEFAULT NULL,
  `cfdi_use_id` int(10) unsigned DEFAULT NULL,
  `salesperson_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `currency_value` decimal(15,8) NOT NULL DEFAULT '0.00000000',
  `amount_discount` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_untaxed` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_tax` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_tax_ret` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_total` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `balance` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `document_type_id` int(10) unsigned DEFAULT NULL,
  `cfdi_relation_id` int(10) unsigned DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  `mail_sent` tinyint(1) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '2',
  `confirmacion` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_delivery` date DEFAULT NULL,
  `source` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source_name` text COLLATE utf8mb4_unicode_ci,
  `source_taxid` text COLLATE utf8mb4_unicode_ci,
  `source_address` text COLLATE utf8mb4_unicode_ci,
  `source_delivery_on` text COLLATE utf8mb4_unicode_ci,
  `destination` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `destination_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `destination_taxid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `destination_address` text COLLATE utf8mb4_unicode_ci,
  `destination_delivery_on` text COLLATE utf8mb4_unicode_ci,
  `valid_amount` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `dangerous_material` tinyint(1) NOT NULL DEFAULT '0',
  `compensation` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `retainer_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `retainer_taxid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `driver` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vehicle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vehicle_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vehicle_counter` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cfdi_type2` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `document_type2` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` int(10) unsigned DEFAULT NULL,
  `draft` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transfer_reason_id` int(10) unsigned DEFAULT NULL,
  `operation_type_id` int(10) unsigned DEFAULT NULL,
  `pediment_id` int(10) unsigned DEFAULT NULL,
  `origin_certificate` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `number_origin_certificate` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reliable_exporter_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `incoterm_id` int(10) unsigned DEFAULT NULL,
  `subdivision` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment_foreign_trade` text COLLATE utf8mb4_unicode_ci,
  `exchange_rate_usd` decimal(15,8) NOT NULL DEFAULT '0.00000000',
  `amount_total_usd` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `origin` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_quotation_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `customer_invoices_customer_id_foreign` (`customer_id`),
  KEY `customer_invoices_branch_office_id_foreign` (`branch_office_id`),
  KEY `customer_invoices_payment_term_id_foreign` (`payment_term_id`),
  KEY `customer_invoices_payment_way_id_foreign` (`payment_way_id`),
  KEY `customer_invoices_payment_method_id_foreign` (`payment_method_id`),
  KEY `customer_invoices_cfdi_use_id_foreign` (`cfdi_use_id`),
  KEY `customer_invoices_salesperson_id_foreign` (`salesperson_id`),
  KEY `customer_invoices_currency_id_foreign` (`currency_id`),
  KEY `customer_invoices_document_type_id_foreign` (`document_type_id`),
  KEY `customer_invoices_cfdi_relation_id_foreign` (`cfdi_relation_id`),
  KEY `customer_invoices_company_id_foreign` (`company_id`),
  KEY `customer_invoices_transfer_reason_id_foreign` (`transfer_reason_id`),
  KEY `customer_invoices_operation_type_id_foreign` (`operation_type_id`),
  KEY `customer_invoices_pediment_id_foreign` (`pediment_id`),
  KEY `customer_invoices_incoterm_id_foreign` (`incoterm_id`),
  CONSTRAINT `customer_invoices_branch_office_id_foreign` FOREIGN KEY (`branch_office_id`) REFERENCES `fcf_branch_offices` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoices_cfdi_relation_id_foreign` FOREIGN KEY (`cfdi_relation_id`) REFERENCES `fcf_cfdi_relations` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoices_cfdi_use_id_foreign` FOREIGN KEY (`cfdi_use_id`) REFERENCES `fcf_cfdi_uses` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoices_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `fcf_companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoices_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `fcf_currencies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoices_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `fcf_customers` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoices_document_type_id_foreign` FOREIGN KEY (`document_type_id`) REFERENCES `fcf_document_types` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoices_incoterm_id_foreign` FOREIGN KEY (`incoterm_id`) REFERENCES `fcf_incoterms` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoices_operation_type_id_foreign` FOREIGN KEY (`operation_type_id`) REFERENCES `fcf_operation_types` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoices_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `fcf_payment_methods` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoices_payment_term_id_foreign` FOREIGN KEY (`payment_term_id`) REFERENCES `fcf_payment_terms` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoices_payment_way_id_foreign` FOREIGN KEY (`payment_way_id`) REFERENCES `fcf_payment_ways` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoices_pediment_id_foreign` FOREIGN KEY (`pediment_id`) REFERENCES `fcf_pediments` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoices_salesperson_id_foreign` FOREIGN KEY (`salesperson_id`) REFERENCES `fcf_salespersons` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_invoices_transfer_reason_id_foreign` FOREIGN KEY (`transfer_reason_id`) REFERENCES `fcf_transfer_reasons` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_invoices
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customer_payment_cfdis
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_payment_cfdis`;
CREATE TABLE `fcf_customer_payment_cfdis` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `customer_payment_id` int(10) unsigned NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pac_id` int(10) unsigned DEFAULT NULL,
  `cfdi_version` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `file_xml` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_xml_pac` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cancel_date` datetime DEFAULT NULL,
  `cancel_response` text COLLATE utf8mb4_unicode_ci,
  `cancel_state` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `customer_payment_cfdis_customer_payment_id_foreign` (`customer_payment_id`),
  KEY `customer_payment_cfdis_pac_id_foreign` (`pac_id`),
  CONSTRAINT `customer_payment_cfdis_customer_payment_id_foreign` FOREIGN KEY (`customer_payment_id`) REFERENCES `fcf_customer_payments` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_payment_cfdis_pac_id_foreign` FOREIGN KEY (`pac_id`) REFERENCES `fcf_pacs` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_payment_cfdis
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customer_payment_reconcileds
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_payment_reconcileds`;
CREATE TABLE `fcf_customer_payment_reconcileds` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `customer_payment_id` int(10) unsigned NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `reconciled_id` int(10) unsigned DEFAULT NULL,
  `currency_value` decimal(15,8) DEFAULT '0.00000000',
  `amount_reconciled` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `last_balance` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `number_of_payment` int(11) NOT NULL DEFAULT '1',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `uuid_related` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `serie_related` varchar(34) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folio_related` int(11) DEFAULT NULL,
  `currency_code_related` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_method_code_related` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `current_balance` decimal(15,5) NOT NULL DEFAULT '0.00000',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `customer_payment_reconcileds_customer_payment_id_foreign` (`customer_payment_id`),
  KEY `customer_payment_reconcileds_reconciled_id_foreign` (`reconciled_id`),
  CONSTRAINT `customer_payment_reconcileds_customer_payment_id_foreign` FOREIGN KEY (`customer_payment_id`) REFERENCES `fcf_customer_payments` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_payment_reconcileds_reconciled_id_foreign` FOREIGN KEY (`reconciled_id`) REFERENCES `fcf_customer_invoices` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_payment_reconcileds
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customer_payment_relations
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_payment_relations`;
CREATE TABLE `fcf_customer_payment_relations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `customer_payment_id` int(10) unsigned NOT NULL,
  `relation_id` int(10) unsigned DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `uuid_related` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `customer_payment_relations_customer_payment_id_foreign` (`customer_payment_id`),
  KEY `customer_payment_relations_relation_id_foreign` (`relation_id`),
  CONSTRAINT `customer_payment_relations_customer_payment_id_foreign` FOREIGN KEY (`customer_payment_id`) REFERENCES `fcf_customer_payments` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_payment_relations_relation_id_foreign` FOREIGN KEY (`relation_id`) REFERENCES `fcf_customer_payments` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_payment_relations
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customer_payments
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_payments`;
CREATE TABLE `fcf_customer_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `serie` varchar(34) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folio` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `date_payment` datetime DEFAULT NULL,
  `reference` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_bank_account_id` int(10) unsigned DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `customer_bank_account_id` int(10) unsigned DEFAULT NULL,
  `branch_office_id` int(10) unsigned DEFAULT NULL,
  `payment_way_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `currency_value` decimal(15,8) NOT NULL DEFAULT '0.00000000',
  `amount` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `balance` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `document_type_id` int(10) unsigned DEFAULT NULL,
  `cfdi_relation_id` int(10) unsigned DEFAULT NULL,
  `cfdi` tinyint(1) NOT NULL DEFAULT '0',
  `comment` text COLLATE utf8mb4_unicode_ci,
  `mail_sent` tinyint(1) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '2',
  `confirmacion` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tipo_cadena_pago` text COLLATE utf8mb4_unicode_ci,
  `certificado_pago` text COLLATE utf8mb4_unicode_ci,
  `cadena_pago` text COLLATE utf8mb4_unicode_ci,
  `sello_pago` text COLLATE utf8mb4_unicode_ci,
  `company_id` int(10) unsigned DEFAULT NULL,
  `draft` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `customer_payments_company_bank_account_id_foreign` (`company_bank_account_id`),
  KEY `customer_payments_customer_id_foreign` (`customer_id`),
  KEY `customer_payments_customer_bank_account_id_foreign` (`customer_bank_account_id`),
  KEY `customer_payments_branch_office_id_foreign` (`branch_office_id`),
  KEY `customer_payments_payment_way_id_foreign` (`payment_way_id`),
  KEY `customer_payments_currency_id_foreign` (`currency_id`),
  KEY `customer_payments_cfdi_relation_id_foreign` (`cfdi_relation_id`),
  KEY `customer_payments_company_id_foreign` (`company_id`),
  CONSTRAINT `customer_payments_branch_office_id_foreign` FOREIGN KEY (`branch_office_id`) REFERENCES `fcf_branch_offices` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_payments_cfdi_relation_id_foreign` FOREIGN KEY (`cfdi_relation_id`) REFERENCES `fcf_cfdi_relations` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_payments_company_bank_account_id_foreign` FOREIGN KEY (`company_bank_account_id`) REFERENCES `fcf_company_bank_accounts` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_payments_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `fcf_companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_payments_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `fcf_currencies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_payments_customer_bank_account_id_foreign` FOREIGN KEY (`customer_bank_account_id`) REFERENCES `fcf_customer_bank_accounts` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_payments_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `fcf_customers` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_payments_payment_way_id_foreign` FOREIGN KEY (`payment_way_id`) REFERENCES `fcf_payment_ways` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_payments
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customer_quotation_line_taxes
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_quotation_line_taxes`;
CREATE TABLE `fcf_customer_quotation_line_taxes` (
  `customer_quotation_line_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`customer_quotation_line_id`,`tax_id`),
  KEY `customer_quotation_line_id` (`customer_quotation_line_id`) USING BTREE,
  KEY `tax_id` (`tax_id`) USING BTREE,
  CONSTRAINT `customer_quotation_line_taxes_customer_quotation_line_id_foreign` FOREIGN KEY (`customer_quotation_line_id`) REFERENCES `fcf_customer_quotation_lines` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_quotation_line_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `fcf_taxes` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_quotation_line_taxes
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customer_quotation_lines
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_quotation_lines`;
CREATE TABLE `fcf_customer_quotation_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `customer_quotation_id` int(10) unsigned NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `sat_product_id` int(10) unsigned DEFAULT NULL,
  `unit_measure_id` int(10) unsigned DEFAULT NULL,
  `quantity` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `price_unit` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `discount` decimal(15,3) NOT NULL DEFAULT '0.000',
  `price_reduce` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_discount` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_untaxed` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_tax` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_tax_ret` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_total` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `customer_quotation_lines_customer_quotation_id_foreign` (`customer_quotation_id`),
  KEY `customer_quotation_lines_product_id_foreign` (`product_id`),
  KEY `customer_quotation_lines_sat_product_id_foreign` (`sat_product_id`),
  KEY `customer_quotation_lines_unit_measure_id_foreign` (`unit_measure_id`),
  CONSTRAINT `customer_quotation_lines_customer_quotation_id_foreign` FOREIGN KEY (`customer_quotation_id`) REFERENCES `fcf_customer_quotations` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_quotation_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `fcf_products` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_quotation_lines_sat_product_id_foreign` FOREIGN KEY (`sat_product_id`) REFERENCES `fcf_sat_products` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_quotation_lines_unit_measure_id_foreign` FOREIGN KEY (`unit_measure_id`) REFERENCES `fcf_unit_measures` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_quotation_lines
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customer_quotation_taxes
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_quotation_taxes`;
CREATE TABLE `fcf_customer_quotation_taxes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `customer_quotation_id` int(10) unsigned NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  `amount_base` decimal(15,5) DEFAULT '0.00000',
  `amount_tax` decimal(15,5) DEFAULT '0.00000',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `customer_quotation_taxes_customer_quotation_id_foreign` (`customer_quotation_id`),
  KEY `customer_quotation_taxes_tax_id_foreign` (`tax_id`),
  CONSTRAINT `customer_quotation_taxes_customer_quotation_id_foreign` FOREIGN KEY (`customer_quotation_id`) REFERENCES `fcf_customer_quotations` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_quotation_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `fcf_taxes` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_quotation_taxes
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customer_quotations
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customer_quotations`;
CREATE TABLE `fcf_customer_quotations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `serie` varchar(34) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folio` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `date_due` date DEFAULT NULL,
  `expiration_date` date DEFAULT NULL,
  `reference` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `branch_office_id` int(10) unsigned DEFAULT NULL,
  `payment_term_id` int(10) unsigned DEFAULT NULL,
  `payment_way_id` int(10) unsigned DEFAULT NULL,
  `payment_method_id` int(10) unsigned DEFAULT NULL,
  `cfdi_use_id` int(10) unsigned DEFAULT NULL,
  `salesperson_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `currency_value` decimal(15,8) NOT NULL DEFAULT '0.00000000',
  `amount_discount` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_untaxed` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_tax` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_tax_ret` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_total` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `balance` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `document_type_id` int(10) unsigned DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  `terms_of_sale` text COLLATE utf8mb4_unicode_ci,
  `mail_sent` tinyint(1) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `company_id` int(10) unsigned DEFAULT NULL,
  `invoice` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `customer_quotations_customer_id_foreign` (`customer_id`),
  KEY `customer_quotations_branch_office_id_foreign` (`branch_office_id`),
  KEY `customer_quotations_payment_term_id_foreign` (`payment_term_id`),
  KEY `customer_quotations_payment_way_id_foreign` (`payment_way_id`),
  KEY `customer_quotations_payment_method_id_foreign` (`payment_method_id`),
  KEY `customer_quotations_cfdi_use_id_foreign` (`cfdi_use_id`),
  KEY `customer_quotations_salesperson_id_foreign` (`salesperson_id`),
  KEY `customer_quotations_currency_id_foreign` (`currency_id`),
  KEY `customer_quotations_document_type_id_foreign` (`document_type_id`),
  KEY `customer_quotations_company_id_foreign` (`company_id`),
  CONSTRAINT `customer_quotations_branch_office_id_foreign` FOREIGN KEY (`branch_office_id`) REFERENCES `fcf_branch_offices` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_quotations_cfdi_use_id_foreign` FOREIGN KEY (`cfdi_use_id`) REFERENCES `fcf_cfdi_uses` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_quotations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `fcf_companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_quotations_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `fcf_currencies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_quotations_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `fcf_customers` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_quotations_document_type_id_foreign` FOREIGN KEY (`document_type_id`) REFERENCES `fcf_document_types` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_quotations_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `fcf_payment_methods` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_quotations_payment_term_id_foreign` FOREIGN KEY (`payment_term_id`) REFERENCES `fcf_payment_terms` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_quotations_payment_way_id_foreign` FOREIGN KEY (`payment_way_id`) REFERENCES `fcf_payment_ways` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customer_quotations_salesperson_id_foreign` FOREIGN KEY (`salesperson_id`) REFERENCES `fcf_salespersons` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customer_quotations
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_customers
-- ----------------------------
DROP TABLE IF EXISTS `fcf_customers`;
CREATE TABLE `fcf_customers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `taxid` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numid` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_mobile` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_term_id` int(10) unsigned DEFAULT NULL,
  `payment_way_id` int(10) unsigned DEFAULT NULL,
  `payment_method_id` int(10) unsigned DEFAULT NULL,
  `cfdi_use_id` int(10) unsigned DEFAULT NULL,
  `salesperson_id` int(10) unsigned DEFAULT NULL,
  `address_1` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_2` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_3` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_4` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_5` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_6` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city_id` int(10) unsigned DEFAULT NULL,
  `state_id` int(10) unsigned DEFAULT NULL,
  `country_id` int(10) unsigned NOT NULL,
  `postcode` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `company_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `customers_payment_term_id_foreign` (`payment_term_id`),
  KEY `customers_payment_way_id_foreign` (`payment_way_id`),
  KEY `customers_payment_method_id_foreign` (`payment_method_id`),
  KEY `customers_cfdi_use_id_foreign` (`cfdi_use_id`),
  KEY `customers_salesperson_id_foreign` (`salesperson_id`),
  KEY `customers_city_id_foreign` (`city_id`),
  KEY `customers_state_id_foreign` (`state_id`),
  KEY `customers_country_id_foreign` (`country_id`),
  KEY `customers_company_id_foreign` (`company_id`),
  CONSTRAINT `customers_cfdi_use_id_foreign` FOREIGN KEY (`cfdi_use_id`) REFERENCES `fcf_cfdi_uses` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customers_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `fcf_cities` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customers_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `fcf_companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customers_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `fcf_countries` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customers_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `fcf_payment_methods` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customers_payment_term_id_foreign` FOREIGN KEY (`payment_term_id`) REFERENCES `fcf_payment_terms` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customers_payment_way_id_foreign` FOREIGN KEY (`payment_way_id`) REFERENCES `fcf_payment_ways` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customers_salesperson_id_foreign` FOREIGN KEY (`salesperson_id`) REFERENCES `fcf_salespersons` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `customers_state_id_foreign` FOREIGN KEY (`state_id`) REFERENCES `fcf_states` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_customers
-- ----------------------------
INSERT INTO `fcf_customers` VALUES ('1', '2019-12-25 21:15:57', '2019-12-25 21:15:57', '42', '8', 'Público en general', 'XAXX010101000', null, '', '', null, '1', '1', '1', '1', null, '', null, null, null, null, null, null, null, '1', '', null, '0', '1', '1');

-- ----------------------------
-- Table structure for fcf_deductions
-- ----------------------------
DROP TABLE IF EXISTS `fcf_deductions`;
CREATE TABLE `fcf_deductions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `code2` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_deductions
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_disability_types
-- ----------------------------
DROP TABLE IF EXISTS `fcf_disability_types`;
CREATE TABLE `fcf_disability_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_disability_types
-- ----------------------------
INSERT INTO `fcf_disability_types` VALUES ('1', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Riesgo de trabajo.', '01', '1', '1');
INSERT INTO `fcf_disability_types` VALUES ('2', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Enfermedad en general.', '02', '2', '1');
INSERT INTO `fcf_disability_types` VALUES ('3', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Maternidad.', '03', '3', '1');

-- ----------------------------
-- Table structure for fcf_document_types
-- ----------------------------
DROP TABLE IF EXISTS `fcf_document_types`;
CREATE TABLE `fcf_document_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(34) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `current_number` int(11) NOT NULL DEFAULT '0',
  `increment_number` int(11) NOT NULL DEFAULT '1',
  `nature` tinyint(4) NOT NULL DEFAULT '1',
  `cfdi_type_id` int(10) unsigned DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `company_id` int(10) unsigned DEFAULT NULL,
  `draft_prefix` varchar(34) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `draft_current_number` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `document_types_cfdi_type_id_foreign` (`cfdi_type_id`),
  KEY `document_types_company_id_foreign` (`company_id`),
  CONSTRAINT `document_types_cfdi_type_id_foreign` FOREIGN KEY (`cfdi_type_id`) REFERENCES `fcf_cfdi_types` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `document_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `fcf_companies` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_document_types
-- ----------------------------
INSERT INTO `fcf_document_types` VALUES ('1', '2019-12-25 21:15:56', '2019-12-25 21:15:57', '9', '2', 'Factura', 'customer.invoice', 'FAC', '0', '1', '2', '1', '1', '1', '1', null, '0');
INSERT INTO `fcf_document_types` VALUES ('2', '2019-12-25 21:15:56', '2019-12-25 21:15:57', '39', '1', 'Nota de crédito', 'customer.credit_note', 'NCR', '0', '1', '3', '2', '2', '1', '1', null, '0');
INSERT INTO `fcf_document_types` VALUES ('3', '2019-12-25 21:15:56', '2019-12-25 21:15:57', '40', '2', 'Recibo de Pago', 'customer.payment', 'PAG', '0', '1', '3', '3', '3', '1', '1', null, '0');
INSERT INTO `fcf_document_types` VALUES ('4', '2019-12-25 21:15:56', '2019-12-25 21:15:57', '39', '2', 'Recibo de arrendamiento', 'customer.lease', 'ARR', '0', '1', '2', '1', '4', '1', '1', null, '0');
INSERT INTO `fcf_document_types` VALUES ('5', '2019-12-25 21:15:56', '2019-12-25 21:15:57', '9', '9', 'Recibo de honorarios', 'customer.fee', 'HON', '0', '1', '2', '1', '5', '1', '1', null, '0');
INSERT INTO `fcf_document_types` VALUES ('6', '2019-12-25 21:15:56', '2019-12-25 21:15:57', '42', '1', 'Carta porte', 'customer.transfer', 'TRA', '0', '1', '1', '4', '6', '1', '1', null, '0');
INSERT INTO `fcf_document_types` VALUES ('7', '2019-12-25 21:15:56', '2019-12-25 21:15:57', '9', '9', 'Cotización', 'customer.quotation', 'CTZ', '0', '1', '1', null, '7', '1', '1', null, '0');
INSERT INTO `fcf_document_types` VALUES ('8', '2019-12-25 21:15:56', '2019-12-25 21:15:57', '8', '1', 'Recibo de nómina', 'employee.payroll', 'NOM', '0', '1', '1', '5', '8', '1', '1', null, '0');

-- ----------------------------
-- Table structure for fcf_employee_categories
-- ----------------------------
DROP TABLE IF EXISTS `fcf_employee_categories`;
CREATE TABLE `fcf_employee_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_employee_categories
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_employee_payroll_cfdis
-- ----------------------------
DROP TABLE IF EXISTS `fcf_employee_payroll_cfdis`;
CREATE TABLE `fcf_employee_payroll_cfdis` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `employee_payroll_id` int(10) unsigned NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pac_id` int(10) unsigned DEFAULT NULL,
  `cfdi_version` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `file_xml` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_xml_pac` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cancel_date` datetime DEFAULT NULL,
  `cancel_response` text COLLATE utf8mb4_unicode_ci,
  `cancel_state` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `employee_payroll_cfdis_employee_payroll_id_foreign` (`employee_payroll_id`),
  KEY `employee_payroll_cfdis_pac_id_foreign` (`pac_id`),
  CONSTRAINT `employee_payroll_cfdis_employee_payroll_id_foreign` FOREIGN KEY (`employee_payroll_id`) REFERENCES `fcf_employee_payrolls` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employee_payroll_cfdis_pac_id_foreign` FOREIGN KEY (`pac_id`) REFERENCES `fcf_pacs` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_employee_payroll_cfdis
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_employee_payroll_lines
-- ----------------------------
DROP TABLE IF EXISTS `fcf_employee_payroll_lines`;
CREATE TABLE `fcf_employee_payroll_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `employee_payroll_id` int(10) unsigned NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `perception_id` int(10) unsigned DEFAULT NULL,
  `deduction_id` int(10) unsigned DEFAULT NULL,
  `other_payment_type_id` int(10) unsigned DEFAULT NULL,
  `amount_taxed` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_exempt` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_total` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_caused` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `employee_payroll_lines_employee_payroll_id_foreign` (`employee_payroll_id`),
  KEY `employee_payroll_lines_perception_id_foreign` (`perception_id`),
  KEY `employee_payroll_lines_deduction_id_foreign` (`deduction_id`),
  KEY `employee_payroll_lines_other_payment_type_id_foreign` (`other_payment_type_id`),
  CONSTRAINT `employee_payroll_lines_deduction_id_foreign` FOREIGN KEY (`deduction_id`) REFERENCES `fcf_deductions` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employee_payroll_lines_employee_payroll_id_foreign` FOREIGN KEY (`employee_payroll_id`) REFERENCES `fcf_employee_payrolls` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employee_payroll_lines_other_payment_type_id_foreign` FOREIGN KEY (`other_payment_type_id`) REFERENCES `fcf_other_payment_types` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employee_payroll_lines_perception_id_foreign` FOREIGN KEY (`perception_id`) REFERENCES `fcf_perceptions` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_employee_payroll_lines
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_employee_payroll_relations
-- ----------------------------
DROP TABLE IF EXISTS `fcf_employee_payroll_relations`;
CREATE TABLE `fcf_employee_payroll_relations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `employee_payroll_id` int(10) unsigned NOT NULL,
  `relation_id` int(10) unsigned DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `uuid_related` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `employee_payroll_relations_employee_payroll_id_foreign` (`employee_payroll_id`),
  KEY `employee_payroll_relations_relation_id_foreign` (`relation_id`),
  CONSTRAINT `employee_payroll_relations_employee_payroll_id_foreign` FOREIGN KEY (`employee_payroll_id`) REFERENCES `fcf_employee_payrolls` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employee_payroll_relations_relation_id_foreign` FOREIGN KEY (`relation_id`) REFERENCES `fcf_employee_payrolls` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_employee_payroll_relations
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_employee_payrolls
-- ----------------------------
DROP TABLE IF EXISTS `fcf_employee_payrolls`;
CREATE TABLE `fcf_employee_payrolls` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `serie` varchar(34) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folio` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `date_payment` date DEFAULT NULL,
  `date_start_payment` date DEFAULT NULL,
  `date_end_payment` date DEFAULT NULL,
  `reference` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `employee_id` int(10) unsigned DEFAULT NULL,
  `payroll_type_id` int(10) unsigned DEFAULT NULL,
  `branch_office_id` int(10) unsigned DEFAULT NULL,
  `payment_way_id` int(10) unsigned DEFAULT NULL,
  `payment_method_id` int(10) unsigned DEFAULT NULL,
  `cfdi_use_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `currency_value` decimal(15,8) NOT NULL DEFAULT '0.00000000',
  `base_salary` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `sdi` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_discount` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_untaxed` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_isr` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_tax` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_tax_ret` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_total` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_perceptions` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_deductions` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_other_payment_types` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `document_type_id` int(10) unsigned DEFAULT NULL,
  `cfdi_relation_id` int(10) unsigned DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  `mail_sent` tinyint(1) NOT NULL DEFAULT '0',
  `draft` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` int(10) unsigned DEFAULT NULL,
  `payment_days` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '2',
  `payroll_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `employee_payrolls_employee_id_foreign` (`employee_id`),
  KEY `employee_payrolls_payroll_type_id_foreign` (`payroll_type_id`),
  KEY `employee_payrolls_branch_office_id_foreign` (`branch_office_id`),
  KEY `employee_payrolls_payment_way_id_foreign` (`payment_way_id`),
  KEY `employee_payrolls_payment_method_id_foreign` (`payment_method_id`),
  KEY `employee_payrolls_cfdi_use_id_foreign` (`cfdi_use_id`),
  KEY `employee_payrolls_currency_id_foreign` (`currency_id`),
  KEY `employee_payrolls_document_type_id_foreign` (`document_type_id`),
  KEY `employee_payrolls_cfdi_relation_id_foreign` (`cfdi_relation_id`),
  KEY `employee_payrolls_company_id_foreign` (`company_id`),
  KEY `employee_payrolls_payroll_id_foreign` (`payroll_id`),
  CONSTRAINT `employee_payrolls_branch_office_id_foreign` FOREIGN KEY (`branch_office_id`) REFERENCES `fcf_branch_offices` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employee_payrolls_cfdi_relation_id_foreign` FOREIGN KEY (`cfdi_relation_id`) REFERENCES `fcf_cfdi_relations` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employee_payrolls_cfdi_use_id_foreign` FOREIGN KEY (`cfdi_use_id`) REFERENCES `fcf_cfdi_uses` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employee_payrolls_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `fcf_companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employee_payrolls_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `fcf_currencies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employee_payrolls_document_type_id_foreign` FOREIGN KEY (`document_type_id`) REFERENCES `fcf_document_types` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employee_payrolls_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `fcf_employees` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employee_payrolls_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `fcf_payment_methods` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employee_payrolls_payment_way_id_foreign` FOREIGN KEY (`payment_way_id`) REFERENCES `fcf_payment_ways` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employee_payrolls_payroll_id_foreign` FOREIGN KEY (`payroll_id`) REFERENCES `fcf_payrolls` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employee_payrolls_payroll_type_id_foreign` FOREIGN KEY (`payroll_type_id`) REFERENCES `fcf_payroll_types` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_employee_payrolls
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_employees
-- ----------------------------
DROP TABLE IF EXISTS `fcf_employees`;
CREATE TABLE `fcf_employees` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `taxid` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `curp` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_mobile` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recruitment_regime_id` int(10) unsigned DEFAULT NULL,
  `date_start_work` date DEFAULT NULL,
  `nss` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unionized` tinyint(1) NOT NULL DEFAULT '0',
  `workday_type_id` int(10) unsigned DEFAULT NULL,
  `contract_type_id` int(10) unsigned DEFAULT NULL,
  `department` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `job` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `job_risk_classe_id` int(10) unsigned DEFAULT NULL,
  `frequency_payment_id` int(10) unsigned DEFAULT NULL,
  `bank_id` int(10) unsigned DEFAULT NULL,
  `bank_account` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `base_salary` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `sdi` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `country_id` int(10) unsigned DEFAULT NULL,
  `state_id` int(10) unsigned DEFAULT NULL,
  `company_id` int(10) unsigned DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `firstname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lastname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lastname2` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `employee_category_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `employees_recruitment_regime_id_foreign` (`recruitment_regime_id`),
  KEY `employees_workday_type_id_foreign` (`workday_type_id`),
  KEY `employees_contract_type_id_foreign` (`contract_type_id`),
  KEY `employees_job_risk_classe_id_foreign` (`job_risk_classe_id`),
  KEY `employees_frequency_payment_id_foreign` (`frequency_payment_id`),
  KEY `employees_bank_id_foreign` (`bank_id`),
  KEY `employees_country_id_foreign` (`country_id`),
  KEY `employees_state_id_foreign` (`state_id`),
  KEY `employees_company_id_foreign` (`company_id`),
  KEY `employees_employee_category_id_foreign` (`employee_category_id`),
  CONSTRAINT `employees_bank_id_foreign` FOREIGN KEY (`bank_id`) REFERENCES `fcf_banks` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employees_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `fcf_companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employees_contract_type_id_foreign` FOREIGN KEY (`contract_type_id`) REFERENCES `fcf_contract_types` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employees_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `fcf_countries` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employees_employee_category_id_foreign` FOREIGN KEY (`employee_category_id`) REFERENCES `fcf_employee_categories` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employees_frequency_payment_id_foreign` FOREIGN KEY (`frequency_payment_id`) REFERENCES `fcf_frequency_payments` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employees_job_risk_classe_id_foreign` FOREIGN KEY (`job_risk_classe_id`) REFERENCES `fcf_job_risk_classes` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employees_recruitment_regime_id_foreign` FOREIGN KEY (`recruitment_regime_id`) REFERENCES `fcf_recruitment_regimes` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employees_state_id_foreign` FOREIGN KEY (`state_id`) REFERENCES `fcf_states` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `employees_workday_type_id_foreign` FOREIGN KEY (`workday_type_id`) REFERENCES `fcf_workday_types` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_employees
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_folios
-- ----------------------------
DROP TABLE IF EXISTS `fcf_folios`;
CREATE TABLE `fcf_folios` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `taxid` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_code` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quantity` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `price_unit` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `discount` decimal(15,3) NOT NULL DEFAULT '0.000',
  `price_reduce` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `payment_way_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `currency_value` decimal(15,8) NOT NULL DEFAULT '0.00000000',
  `amount_discount` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_untaxed` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_tax` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_tax_ret` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_total` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `expiry_date` date DEFAULT NULL,
  `activation_date` datetime DEFAULT NULL,
  `activation_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quantity_folio` int(11) NOT NULL DEFAULT '1',
  `available_folio` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `folios_payment_way_id_foreign` (`payment_way_id`),
  KEY `folios_currency_id_foreign` (`currency_id`),
  CONSTRAINT `folios_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `fcf_currencies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `folios_payment_way_id_foreign` FOREIGN KEY (`payment_way_id`) REFERENCES `fcf_payment_ways` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_folios
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_frequency_payments
-- ----------------------------
DROP TABLE IF EXISTS `fcf_frequency_payments`;
CREATE TABLE `fcf_frequency_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_frequency_payments
-- ----------------------------
INSERT INTO `fcf_frequency_payments` VALUES ('1', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Diario', '01', '1', '1');
INSERT INTO `fcf_frequency_payments` VALUES ('2', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Semanal', '02', '2', '1');
INSERT INTO `fcf_frequency_payments` VALUES ('3', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Catorcenal', '03', '3', '1');
INSERT INTO `fcf_frequency_payments` VALUES ('4', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Quincenal', '04', '4', '1');
INSERT INTO `fcf_frequency_payments` VALUES ('5', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Mensual', '05', '5', '1');
INSERT INTO `fcf_frequency_payments` VALUES ('6', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Bimestral', '06', '6', '1');
INSERT INTO `fcf_frequency_payments` VALUES ('7', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Unidad obra', '07', '7', '1');
INSERT INTO `fcf_frequency_payments` VALUES ('8', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Comisión', '08', '8', '1');
INSERT INTO `fcf_frequency_payments` VALUES ('9', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Precio alzado', '09', '9', '1');
INSERT INTO `fcf_frequency_payments` VALUES ('10', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Decenal', '10', '10', '1');
INSERT INTO `fcf_frequency_payments` VALUES ('11', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Otra Periodicidad', '99', '11', '1');

-- ----------------------------
-- Table structure for fcf_iedu_nivel_educativos
-- ----------------------------
DROP TABLE IF EXISTS `fcf_iedu_nivel_educativos`;
CREATE TABLE `fcf_iedu_nivel_educativos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `aut_rvoe` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_iedu_nivel_educativos
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_incoterms
-- ----------------------------
DROP TABLE IF EXISTS `fcf_incoterms`;
CREATE TABLE `fcf_incoterms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_incoterms
-- ----------------------------
INSERT INTO `fcf_incoterms` VALUES ('1', '2019-12-25 21:15:57', '2019-12-25 21:15:57', null, null, 'COSTE Y FLETE (PUERTO DE DESTINO CONVENIDO).', 'CFR', '1', '1');
INSERT INTO `fcf_incoterms` VALUES ('2', '2019-12-25 21:15:57', '2019-12-25 21:15:57', null, null, 'COSTE, SEGURO Y FLETE (PUERTO DE DESTINO CONVENIDO).', 'CIF', '2', '1');
INSERT INTO `fcf_incoterms` VALUES ('3', '2019-12-25 21:15:57', '2019-12-25 21:15:57', null, null, 'TRANSPORTE PAGADO HASTA (EL LUGAR DE DESTINO CONVENIDO).', 'CPT', '3', '1');
INSERT INTO `fcf_incoterms` VALUES ('4', '2019-12-25 21:15:57', '2019-12-25 21:15:57', null, null, 'TRANSPORTE Y SEGURO PAGADOS HASTA (LUGAR DE DESTINO CONVENIDO).', 'CIP', '4', '1');
INSERT INTO `fcf_incoterms` VALUES ('5', '2019-12-25 21:15:57', '2019-12-25 21:15:57', null, null, 'ENTREGADA EN FRONTERA (LUGAR CONVENIDO).', 'DAF', '5', '1');
INSERT INTO `fcf_incoterms` VALUES ('6', '2019-12-25 21:15:57', '2019-12-25 21:15:57', null, null, 'ENTREGADA EN LUGAR.', 'DAP', '6', '1');
INSERT INTO `fcf_incoterms` VALUES ('7', '2019-12-25 21:15:57', '2019-12-25 21:15:57', null, null, 'ENTREGADA EN TERMINAL.', 'DAT', '7', '1');
INSERT INTO `fcf_incoterms` VALUES ('8', '2019-12-25 21:15:57', '2019-12-25 21:15:57', null, null, 'ENTREGADA SOBRE BUQUE (PUERTO DE DESTINO CONVENIDO).', 'DES', '8', '1');
INSERT INTO `fcf_incoterms` VALUES ('9', '2019-12-25 21:15:57', '2019-12-25 21:15:57', null, null, 'ENTREGADA EN MUELLE (PUERTO DE DESTINO CONVENIDO).', 'DEQ', '9', '1');
INSERT INTO `fcf_incoterms` VALUES ('10', '2019-12-25 21:15:57', '2019-12-25 21:15:57', null, null, 'ENTREGADA DERECHOS NO PAGADOS (LUGAR DE DESTINO CONVENIDO).', 'DDU', '10', '1');
INSERT INTO `fcf_incoterms` VALUES ('11', '2019-12-25 21:15:57', '2019-12-25 21:15:57', null, null, 'ENTREGADA DERECHOS PAGADOS (LUGAR DE DESTINO CONVENIDO).', 'DDP', '11', '1');
INSERT INTO `fcf_incoterms` VALUES ('12', '2019-12-25 21:15:57', '2019-12-25 21:15:57', null, null, 'EN FABRICA (LUGAR CONVENIDO).', 'EXW', '12', '1');
INSERT INTO `fcf_incoterms` VALUES ('13', '2019-12-25 21:15:57', '2019-12-25 21:15:57', null, null, 'FRANCO TRANSPORTISTA (LUGAR DESIGNADO).', 'FCA', '13', '1');
INSERT INTO `fcf_incoterms` VALUES ('14', '2019-12-25 21:15:57', '2019-12-25 21:15:57', null, null, 'FRANCO AL COSTADO DEL BUQUE (PUERTO DE CARGA CONVENIDO).', 'FAS', '14', '1');
INSERT INTO `fcf_incoterms` VALUES ('15', '2019-12-25 21:15:57', '2019-12-25 21:15:57', null, null, 'FRANCO A BORDO (PUERTO DE CARGA CONVENIDO).', 'FOB', '15', '1');

-- ----------------------------
-- Table structure for fcf_job_risk_classes
-- ----------------------------
DROP TABLE IF EXISTS `fcf_job_risk_classes`;
CREATE TABLE `fcf_job_risk_classes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_job_risk_classes
-- ----------------------------
INSERT INTO `fcf_job_risk_classes` VALUES ('1', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Clase I', '1', '1', '1');
INSERT INTO `fcf_job_risk_classes` VALUES ('2', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Clase II', '2', '2', '1');
INSERT INTO `fcf_job_risk_classes` VALUES ('3', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Clase III', '3', '3', '1');
INSERT INTO `fcf_job_risk_classes` VALUES ('4', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Clase IV', '4', '4', '1');
INSERT INTO `fcf_job_risk_classes` VALUES ('5', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Clase V', '5', '5', '1');
INSERT INTO `fcf_job_risk_classes` VALUES ('6', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'No aplica', '99', '6', '1');

-- ----------------------------
-- Table structure for fcf_migrations
-- ----------------------------
DROP TABLE IF EXISTS `fcf_migrations`;
CREATE TABLE `fcf_migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=117 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_migrations
-- ----------------------------
INSERT INTO `fcf_migrations` VALUES ('1', '2014_10_12_000000_create_users_table', '1');
INSERT INTO `fcf_migrations` VALUES ('2', '2014_10_12_100000_create_password_resets_table', '1');
INSERT INTO `fcf_migrations` VALUES ('3', '2015_12_10_104856_create_settings_table', '1');
INSERT INTO `fcf_migrations` VALUES ('4', '2018_11_03_142350_create_unit_measures_table', '1');
INSERT INTO `fcf_migrations` VALUES ('5', '2018_11_03_175222_create_sat_products_table', '1');
INSERT INTO `fcf_migrations` VALUES ('6', '2018_11_03_181535_create_payment_ways_table', '1');
INSERT INTO `fcf_migrations` VALUES ('7', '2018_11_03_182935_create_payment_methods_table', '1');
INSERT INTO `fcf_migrations` VALUES ('8', '2018_11_03_183819_create_tax_regimens_table', '1');
INSERT INTO `fcf_migrations` VALUES ('9', '2018_11_03_184611_create_cfdi_types_table', '1');
INSERT INTO `fcf_migrations` VALUES ('10', '2018_11_03_185238_create_cfdi_relations_table', '1');
INSERT INTO `fcf_migrations` VALUES ('11', '2018_11_03_185845_create_cfdi_uses_table', '1');
INSERT INTO `fcf_migrations` VALUES ('12', '2018_11_03_190743_create_currencies_table', '1');
INSERT INTO `fcf_migrations` VALUES ('13', '2018_11_03_191040_create_taxes_table', '1');
INSERT INTO `fcf_migrations` VALUES ('14', '2018_11_03_193221_create_countries_table', '1');
INSERT INTO `fcf_migrations` VALUES ('15', '2018_11_03_194315_create_states_table', '1');
INSERT INTO `fcf_migrations` VALUES ('16', '2018_11_03_194332_create_cities_table', '1');
INSERT INTO `fcf_migrations` VALUES ('17', '2018_11_06_082120_create_banks_table', '1');
INSERT INTO `fcf_migrations` VALUES ('18', '2018_12_17_104338_create_companies_table', '1');
INSERT INTO `fcf_migrations` VALUES ('19', '2018_12_17_115952_create_company_bank_accounts_table', '1');
INSERT INTO `fcf_migrations` VALUES ('20', '2018_12_17_123820_create_branch_offices_table', '1');
INSERT INTO `fcf_migrations` VALUES ('21', '2018_12_17_153449_create_document_types_table', '1');
INSERT INTO `fcf_migrations` VALUES ('22', '2018_12_19_121348_create_salespersons_table', '1');
INSERT INTO `fcf_migrations` VALUES ('23', '2018_12_19_125340_create_payment_terms_table', '1');
INSERT INTO `fcf_migrations` VALUES ('24', '2018_12_19_125425_create_customers_table', '1');
INSERT INTO `fcf_migrations` VALUES ('25', '2018_12_20_090016_create_customer_bank_accounts_table', '1');
INSERT INTO `fcf_migrations` VALUES ('26', '2019_01_15_103514_create_products_table', '1');
INSERT INTO `fcf_migrations` VALUES ('27', '2019_01_17_162917_create_pacs_table', '1');
INSERT INTO `fcf_migrations` VALUES ('28', '2019_01_18_203115_create_product_taxes_table', '1');
INSERT INTO `fcf_migrations` VALUES ('29', '2019_01_20_200926_create_customer_invoices_table', '1');
INSERT INTO `fcf_migrations` VALUES ('30', '2019_01_20_201257_create_customer_invoice_lines_table', '1');
INSERT INTO `fcf_migrations` VALUES ('31', '2019_01_20_201314_create_customer_invoice_line_taxes_table', '1');
INSERT INTO `fcf_migrations` VALUES ('32', '2019_01_20_201346_create_customer_invoice_taxes_table', '1');
INSERT INTO `fcf_migrations` VALUES ('33', '2019_01_20_201451_create_customer_invoice_relations_table', '1');
INSERT INTO `fcf_migrations` VALUES ('34', '2019_01_29_220656_create_customer_invoice_cfdis_table', '1');
INSERT INTO `fcf_migrations` VALUES ('35', '2019_01_30_213516_create_customer_invoice_reconcileds_table', '1');
INSERT INTO `fcf_migrations` VALUES ('36', '2019_02_07_215115_create_customer_payments_table', '1');
INSERT INTO `fcf_migrations` VALUES ('37', '2019_02_07_223214_create_customer_payment_cfdis_table', '1');
INSERT INTO `fcf_migrations` VALUES ('38', '2019_02_07_223232_create_customer_payment_relations_table', '1');
INSERT INTO `fcf_migrations` VALUES ('39', '2019_02_07_223451_create_customer_payment_reconcileds_table', '1');
INSERT INTO `fcf_migrations` VALUES ('40', '2019_02_26_102513_create_iedu_nivel_educativos_table', '1');
INSERT INTO `fcf_migrations` VALUES ('41', '2019_02_27_181003_create_customer_iedus_table', '1');
INSERT INTO `fcf_migrations` VALUES ('42', '2019_03_01_091857_create_customer_invoice_line_complements_table', '1');
INSERT INTO `fcf_migrations` VALUES ('43', '2019_03_03_091820_create_folios_table', '1');
INSERT INTO `fcf_migrations` VALUES ('44', '2019_03_05_081601_create_shop_products_table', '1');
INSERT INTO `fcf_migrations` VALUES ('45', '2019_03_05_082333_create_shop_product_taxes_table', '1');
INSERT INTO `fcf_migrations` VALUES ('46', '2019_03_14_213827_add_confirmacion_to_customer_invoices_table', '1');
INSERT INTO `fcf_migrations` VALUES ('47', '2019_03_14_214119_add_confirmacion_to_customer_payments_table', '1');
INSERT INTO `fcf_migrations` VALUES ('48', '2019_03_14_221203_add_spei_to_customer_payments_table', '1');
INSERT INTO `fcf_migrations` VALUES ('49', '2019_03_17_112207_add_account_pattern_to_payment_ways_table', '1');
INSERT INTO `fcf_migrations` VALUES ('50', '2019_06_11_232851_add_transfer_to_customer_invoices_table', '1');
INSERT INTO `fcf_migrations` VALUES ('51', '2019_06_14_095512_create_customer_invoice_line_transfers_table', '1');
INSERT INTO `fcf_migrations` VALUES ('52', '2019_07_19_160805_add_predial_to_ci_line_complements', '1');
INSERT INTO `fcf_migrations` VALUES ('53', '2019_08_11_210018_add_company_id_to_branch_offices_table', '1');
INSERT INTO `fcf_migrations` VALUES ('54', '2019_08_11_210052_add_company_id_to_customer_invoices_table', '1');
INSERT INTO `fcf_migrations` VALUES ('55', '2019_08_11_210118_add_company_id_to_customer_payments_table', '1');
INSERT INTO `fcf_migrations` VALUES ('56', '2019_08_11_210200_add_company_id_to_document_types_table', '1');
INSERT INTO `fcf_migrations` VALUES ('57', '2019_08_11_210741_add_settings_to_companies_table', '1');
INSERT INTO `fcf_migrations` VALUES ('58', '2019_08_12_183915_remove_code_unique_to_document_types', '1');
INSERT INTO `fcf_migrations` VALUES ('59', '2019_08_12_190510_remove_name_unique_to_customer_invoices', '1');
INSERT INTO `fcf_migrations` VALUES ('60', '2019_08_12_190525_remove_name_unique_to_customer_payments', '1');
INSERT INTO `fcf_migrations` VALUES ('61', '2019_08_14_085802_add_company_id_to_products', '1');
INSERT INTO `fcf_migrations` VALUES ('62', '2019_08_14_085839_add_company_id_to_customers', '1');
INSERT INTO `fcf_migrations` VALUES ('63', '2019_08_14_093915_remove_code_unique_to_products', '1');
INSERT INTO `fcf_migrations` VALUES ('64', '2019_08_24_231857_add_uuid_related_to_customer_invoice_relations', '1');
INSERT INTO `fcf_migrations` VALUES ('65', '2019_08_24_234122_add_uuid_related_to_customer_payment_relations', '1');
INSERT INTO `fcf_migrations` VALUES ('66', '2019_08_25_110834_add_uuid_related_to_customer_payment_reconcileds', '1');
INSERT INTO `fcf_migrations` VALUES ('67', '2019_08_29_074621_add_draft_to_document_types', '1');
INSERT INTO `fcf_migrations` VALUES ('68', '2019_08_29_074703_add_draft_to_customer_invoices', '1');
INSERT INTO `fcf_migrations` VALUES ('69', '2019_08_29_074727_add_draft_to_customer_payments', '1');
INSERT INTO `fcf_migrations` VALUES ('70', '2019_10_02_095508_add_curp_to_companies', '1');
INSERT INTO `fcf_migrations` VALUES ('71', '2019_10_02_105307_add_complemento_foreign_trade_to_companies', '1');
INSERT INTO `fcf_migrations` VALUES ('72', '2019_10_03_082544_create_pediments_table', '1');
INSERT INTO `fcf_migrations` VALUES ('73', '2019_10_03_083947_create_tariff_fractions_table', '1');
INSERT INTO `fcf_migrations` VALUES ('74', '2019_10_03_084245_create_incoterms_table', '1');
INSERT INTO `fcf_migrations` VALUES ('75', '2019_10_03_084424_create_transfer_reasons_table', '1');
INSERT INTO `fcf_migrations` VALUES ('76', '2019_10_03_084634_create_operation_types_table', '1');
INSERT INTO `fcf_migrations` VALUES ('77', '2019_10_03_085011_create_uom_customs_table', '1');
INSERT INTO `fcf_migrations` VALUES ('78', '2019_10_04_204512_add_foreign_trade_to_customer_invoices', '1');
INSERT INTO `fcf_migrations` VALUES ('79', '2019_10_05_151347_add_foreign_trade_to_ci_line_complements', '1');
INSERT INTO `fcf_migrations` VALUES ('80', '2019_10_06_102116_add_code_to_states', '1');
INSERT INTO `fcf_migrations` VALUES ('81', '2019_10_06_230720_add_code_to_cities', '1');
INSERT INTO `fcf_migrations` VALUES ('82', '2019_10_07_012448_add_foreign_trade_to_products', '1');
INSERT INTO `fcf_migrations` VALUES ('83', '2019_10_15_082522_create_customer_quotations_table', '1');
INSERT INTO `fcf_migrations` VALUES ('84', '2019_10_15_082544_create_customer_quotation_lines_table', '1');
INSERT INTO `fcf_migrations` VALUES ('85', '2019_10_15_083359_create_customer_quotation_taxes_table', '1');
INSERT INTO `fcf_migrations` VALUES ('86', '2019_10_15_083747_create_customer_quotation_line_taxes_table', '1');
INSERT INTO `fcf_migrations` VALUES ('87', '2019_10_15_084752_add_origin_to_customer_invoices_table', '1');
INSERT INTO `fcf_migrations` VALUES ('88', '2019_10_22_093543_create_postcodes_table', '1');
INSERT INTO `fcf_migrations` VALUES ('89', '2019_10_22_151736_add_description_to_banks_table', '1');
INSERT INTO `fcf_migrations` VALUES ('90', '2019_10_23_095642_create_source_resources_table', '1');
INSERT INTO `fcf_migrations` VALUES ('91', '2019_10_23_101602_create_frequency_payments_table', '1');
INSERT INTO `fcf_migrations` VALUES ('92', '2019_10_23_103007_create_contract_types_table', '1');
INSERT INTO `fcf_migrations` VALUES ('93', '2019_10_23_103851_create_deductions_table', '1');
INSERT INTO `fcf_migrations` VALUES ('94', '2019_10_23_105601_create_overtimes_types_table', '1');
INSERT INTO `fcf_migrations` VALUES ('95', '2019_10_23_113228_create_disability_types_table', '1');
INSERT INTO `fcf_migrations` VALUES ('96', '2019_10_23_113958_create_workday_types_table', '1');
INSERT INTO `fcf_migrations` VALUES ('97', '2019_10_23_115004_create_payroll_types_table', '1');
INSERT INTO `fcf_migrations` VALUES ('98', '2019_10_23_115827_create_other_payment_types_table', '1');
INSERT INTO `fcf_migrations` VALUES ('99', '2019_10_23_120608_create_perceptions_table', '1');
INSERT INTO `fcf_migrations` VALUES ('100', '2019_10_23_132613_create_recruitment_regimes_table', '1');
INSERT INTO `fcf_migrations` VALUES ('101', '2019_10_23_144724_create_job_risk_classes_table', '1');
INSERT INTO `fcf_migrations` VALUES ('102', '2019_10_24_102351_add_employer_register_to_companies_table', '1');
INSERT INTO `fcf_migrations` VALUES ('103', '2019_10_24_124103_add_quotation_payroll_to_companies_table', '1');
INSERT INTO `fcf_migrations` VALUES ('104', '2019_10_24_151035_create_employees_table', '1');
INSERT INTO `fcf_migrations` VALUES ('105', '2019_10_30_221440_create_employee_payrolls_table', '1');
INSERT INTO `fcf_migrations` VALUES ('106', '2019_10_30_221725_create_employee_payroll_lines_table', '1');
INSERT INTO `fcf_migrations` VALUES ('107', '2019_10_30_225714_create_employee_payroll_cfdis_table', '1');
INSERT INTO `fcf_migrations` VALUES ('108', '2019_10_30_230217_create_employee_payroll_relations_table', '1');
INSERT INTO `fcf_migrations` VALUES ('109', '2019_11_07_202936_add_names_to_employees_table', '1');
INSERT INTO `fcf_migrations` VALUES ('110', '2019_11_14_130204_create_payrolls_table', '1');
INSERT INTO `fcf_migrations` VALUES ('111', '2019_11_14_130340_add_payroll_id_to_employee_payrolls_table', '1');
INSERT INTO `fcf_migrations` VALUES ('112', '2019_11_20_172822_add_code2_to_deductions_table', '1');
INSERT INTO `fcf_migrations` VALUES ('113', '2019_11_20_172937_add_code2_to_other_payment_types_table', '1');
INSERT INTO `fcf_migrations` VALUES ('114', '2019_11_20_173014_add_code2_to_perceptions_table', '1');
INSERT INTO `fcf_migrations` VALUES ('115', '2019_11_21_104257_create_employee_categories_table', '1');
INSERT INTO `fcf_migrations` VALUES ('116', '2019_11_21_121931_add_employee_category_id_to_employees_table', '1');

-- ----------------------------
-- Table structure for fcf_operation_types
-- ----------------------------
DROP TABLE IF EXISTS `fcf_operation_types`;
CREATE TABLE `fcf_operation_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_operation_types
-- ----------------------------
INSERT INTO `fcf_operation_types` VALUES ('1', '2019-12-25 21:15:57', '2019-12-25 21:15:57', null, null, 'Exportación', '2', '0', '1');

-- ----------------------------
-- Table structure for fcf_other_payment_types
-- ----------------------------
DROP TABLE IF EXISTS `fcf_other_payment_types`;
CREATE TABLE `fcf_other_payment_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `code2` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_other_payment_types
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_overtimes_types
-- ----------------------------
DROP TABLE IF EXISTS `fcf_overtimes_types`;
CREATE TABLE `fcf_overtimes_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_overtimes_types
-- ----------------------------
INSERT INTO `fcf_overtimes_types` VALUES ('1', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Dobles', '01', '1', '1');
INSERT INTO `fcf_overtimes_types` VALUES ('2', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Triples', '02', '2', '1');
INSERT INTO `fcf_overtimes_types` VALUES ('3', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Simples', '03', '3', '1');

-- ----------------------------
-- Table structure for fcf_pacs
-- ----------------------------
DROP TABLE IF EXISTS `fcf_pacs`;
CREATE TABLE `fcf_pacs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ws_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ws_url_cancel` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test` tinyint(1) NOT NULL DEFAULT '0',
  `comment` text COLLATE utf8mb4_unicode_ci,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_pacs
-- ----------------------------
INSERT INTO `fcf_pacs` VALUES ('1', '2019-12-25 21:15:53', '2019-12-25 21:15:53', '8', '40', 'PAC Pruebas', 'pacTest', 'http://www.schroeder.com/et-eum-laboriosam-animi-et.html', 'http://casper.com/odit-consectetur-et-doloremque-fugiat-et-in-magni', 'XAXX010101000', null, '1', null, '0', '1');
INSERT INTO `fcf_pacs` VALUES ('2', '2019-12-25 21:15:53', '2019-12-25 21:15:53', '2', '2', 'EDICM Pruebas', 'edicomTest', 'https://cfdiws.sedeb2b.com/EdiwinWS/services/CFDi?wsdl', 'https://cfdiws.sedeb2b.com/EdiwinWS/services/CFDi?wsdl', 'XAXX010101000', null, '1', null, '0', '1');
INSERT INTO `fcf_pacs` VALUES ('3', '2019-12-25 21:15:53', '2019-12-25 21:16:00', '39', '2', 'FNKO Pruebas', 'finkokTest', 'http://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl', 'http://demo-facturacion.finkok.com/servicios/soap/cancel.wsdl', 'lic.angelhc@gmail.com', 'eyJpdiI6Ik85eWFaR0xONndXdWRCSVh0ekZIVmc9PSIsInZhbHVlIjoiZ1pSQWpiZCtzSHhoVjZlak5lMVRpQT09IiwibWFjIjoiZjdjM2QxMGZlODAzYTA0YjMzMTc4MGFlNTdmNGIwNzMyNzgyMWExNmM0ZDFmYmZiOWJkNjRjMTk3MGYyYWJiZCJ9', '1', null, '0', '1');
INSERT INTO `fcf_pacs` VALUES ('4', '2019-12-25 21:15:53', '2019-12-25 21:15:53', '40', '9', 'EDICM Producción', 'edicom', 'https://cfdiws.sedeb2b.com/EdiwinWS/services/CFDi?wsdl', 'https://cfdiws.sedeb2b.com/EdiwinWS/services/CFDi?wsdl', 'XAXX010101000', null, '0', null, '0', '0');
INSERT INTO `fcf_pacs` VALUES ('5', '2019-12-25 21:15:53', '2019-12-25 21:15:53', '39', '40', 'FNKO Producción', 'finkok', 'https://facturacion.finkok.com/servicios/soap/stamp.wsdl', 'https://facturacion.finkok.com/servicios/soap/cancel.wsdl', 'XAXX010101000', null, '0', null, '0', '0');
INSERT INTO `fcf_pacs` VALUES ('6', '2019-12-25 21:15:53', '2019-12-25 21:15:53', '8', '8', 'TIMBOX Pruebas', 'timboxTest', 'https://staging.ws.timbox.com.mx/timbrado_cfdi33/wsdl', 'https://staging.ws.timbox.com.mx/cancelacion/wsdl', 'XAXX010101000', null, '1', null, '0', '1');
INSERT INTO `fcf_pacs` VALUES ('7', '2019-12-25 21:15:53', '2019-12-25 21:15:53', '39', '9', 'TIMBOX Producción', 'timbox', 'https://sistema.timbox.com.mx/timbrado_cfdi33/wsdl', 'https://sistema.timbox.com.mx/cancelacion/wsdl', 'XAXX010101000', null, '0', null, '0', '0');
INSERT INTO `fcf_pacs` VALUES ('8', '2019-12-25 21:15:53', '2019-12-25 21:15:53', '9', '8', 'Comercio Digital Pruebas', 'comdigTest', 'https://pruebas.comercio-digital.mx/timbre/timbrarV5.aspx', 'https://pruebas.comercio-digital.mx/cancela4/cancelarUuid', 'XAXX010101000', null, '1', null, '0', '1');
INSERT INTO `fcf_pacs` VALUES ('9', '2019-12-25 21:15:53', '2019-12-25 21:15:53', '9', '42', 'Comercio Digital Producción', 'comdig', 'https://ws.comercio-digital.mx/timbre/timbrarV5.aspx', 'https://cancela.comercio-digital.mx/cancela3/cancelarUuid', 'XAXX010101000', null, '0', null, '0', '0');
INSERT INTO `fcf_pacs` VALUES ('10', '2019-12-25 21:15:53', '2019-12-25 21:15:53', '1', '9', 'Multifacturas Pruebas', 'multifacturasTest', 'http://pac1.multifacturas.com/pac/?wsdl', 'http://pac1.facturacionmexico.com.mx/cancelacion2018/?wsdl', 'XAXX010101000', null, '1', null, '0', '1');
INSERT INTO `fcf_pacs` VALUES ('11', '2019-12-25 21:15:54', '2019-12-25 21:15:54', '1', '40', 'Multifacturas Producción', 'multifacturas', 'http://pac1.multifacturas.com/pac/?wsdl', 'http://pac1.facturacionmexico.com.mx/cancelacion2018/?wsdl', 'XAXX010101000', null, '0', null, '0', '0');

-- ----------------------------
-- Table structure for fcf_password_resets
-- ----------------------------
DROP TABLE IF EXISTS `fcf_password_resets`;
CREATE TABLE `fcf_password_resets` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_password_resets
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_payment_methods
-- ----------------------------
DROP TABLE IF EXISTS `fcf_payment_methods`;
CREATE TABLE `fcf_payment_methods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_payment_methods
-- ----------------------------
INSERT INTO `fcf_payment_methods` VALUES ('1', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '42', '8', 'Pago en una sola exhibición', 'PUE', '1', '1');
INSERT INTO `fcf_payment_methods` VALUES ('2', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '40', '8', 'Pago en parcialidades o diferido', 'PPD', '2', '1');

-- ----------------------------
-- Table structure for fcf_payment_terms
-- ----------------------------
DROP TABLE IF EXISTS `fcf_payment_terms`;
CREATE TABLE `fcf_payment_terms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `days` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_payment_terms
-- ----------------------------
INSERT INTO `fcf_payment_terms` VALUES ('1', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '2', '39', 'Contado', '0', '1', '1');
INSERT INTO `fcf_payment_terms` VALUES ('2', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '42', '40', '15 Días de crédito', '15', '2', '1');
INSERT INTO `fcf_payment_terms` VALUES ('3', '2019-12-25 21:15:56', '2019-12-25 21:15:56', '8', '1', '30 Días de crédito', '30', '3', '1');

-- ----------------------------
-- Table structure for fcf_payment_ways
-- ----------------------------
DROP TABLE IF EXISTS `fcf_payment_ways`;
CREATE TABLE `fcf_payment_ways` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `patron_cuenta_ordenante` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `patron_cuenta_beneficiaria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_payment_ways
-- ----------------------------
INSERT INTO `fcf_payment_ways` VALUES ('1', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '2', '42', 'Efectivo', '01', '1', '1', null, null);
INSERT INTO `fcf_payment_ways` VALUES ('2', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '40', '9', 'Cheque nominativo', '02', '2', '1', '[0-9]{11}|[0-9]{18}', '[0-9]{10,11}|[0-9]{15,16}|[0-9]{18}|[A-Z0-9_]{10,50}');
INSERT INTO `fcf_payment_ways` VALUES ('3', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '42', '2', 'Transferencia electrónica de fondos', '03', '3', '1', '[0-9]{10}|[0-9]{16}|[0-9]{18}', '[0-9]{10}|[0-9]{18}');
INSERT INTO `fcf_payment_ways` VALUES ('4', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '39', '39', 'Tarjeta de crédito', '04', '4', '1', '[0-9]{16}', '[0-9]{10,11}|[0-9]{15,16}|[0-9]{18}|[A-Z0-9_]{10,50}');
INSERT INTO `fcf_payment_ways` VALUES ('5', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '1', '2', 'Monedero electrónico', '05', '5', '1', '[0-9]{10,11}|[0-9]{15,16}|[0-9]{18}|[A-Z0-9_]{10,50}', '[0-9]{10,11}|[0-9]{15,16}|[0-9]{18}|[A-Z0-9_]{10,50}');
INSERT INTO `fcf_payment_ways` VALUES ('6', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '42', '1', 'Dinero electrónico', '06', '6', '1', null, null);
INSERT INTO `fcf_payment_ways` VALUES ('7', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '8', '8', 'Vales de despensa', '08', '7', '1', null, null);
INSERT INTO `fcf_payment_ways` VALUES ('8', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '40', '40', 'Dación en pago', '12', '8', '0', null, null);
INSERT INTO `fcf_payment_ways` VALUES ('9', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '42', '8', 'Pago por subrogación', '13', '9', '0', null, null);
INSERT INTO `fcf_payment_ways` VALUES ('10', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '2', '42', 'Pago por consignación', '14', '10', '0', null, null);
INSERT INTO `fcf_payment_ways` VALUES ('11', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '42', '2', 'Condonación', '15', '11', '0', null, null);
INSERT INTO `fcf_payment_ways` VALUES ('12', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '42', '40', 'Compensación', '17', '12', '0', null, null);
INSERT INTO `fcf_payment_ways` VALUES ('13', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '9', '39', 'Novación', '23', '13', '0', null, null);
INSERT INTO `fcf_payment_ways` VALUES ('14', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '9', '2', 'Confusión', '24', '14', '0', null, null);
INSERT INTO `fcf_payment_ways` VALUES ('15', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '8', '42', 'Remisión de deuda', '25', '15', '0', null, null);
INSERT INTO `fcf_payment_ways` VALUES ('16', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '39', '42', 'Prescripción o caducidad', '26', '16', '0', null, null);
INSERT INTO `fcf_payment_ways` VALUES ('17', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '39', '8', 'A satisfacción del acreedor', '27', '17', '0', null, null);
INSERT INTO `fcf_payment_ways` VALUES ('18', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '42', '40', 'Tarjeta de débito', '28', '18', '1', '[0-9]{16}', '[0-9]{10,11}|[0-9]{15,16}|[0-9]{18}|[A-Z0-9_]{10,50}');
INSERT INTO `fcf_payment_ways` VALUES ('19', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '2', '39', 'Tarjeta de servicios', '29', '19', '0', '[0-9]{15,16}', '[0-9]{10,11}|[0-9]{15,16}|[0-9]{18}|[A-Z0-9_]{10,50}');
INSERT INTO `fcf_payment_ways` VALUES ('20', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '8', '9', 'Aplicación de anticipos', '30', '20', '0', null, null);
INSERT INTO `fcf_payment_ways` VALUES ('21', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '42', '8', 'Intermediario pagos', '31', '21', '0', null, null);
INSERT INTO `fcf_payment_ways` VALUES ('22', '2019-12-25 21:15:55', '2019-12-25 21:15:55', '39', '9', 'Por definir', '99', '22', '1', null, null);

-- ----------------------------
-- Table structure for fcf_payroll_types
-- ----------------------------
DROP TABLE IF EXISTS `fcf_payroll_types`;
CREATE TABLE `fcf_payroll_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_payroll_types
-- ----------------------------
INSERT INTO `fcf_payroll_types` VALUES ('1', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Nómina ordinaria', 'O', '1', '1');
INSERT INTO `fcf_payroll_types` VALUES ('2', '2019-12-25 21:16:00', '2019-12-25 21:16:00', null, null, 'Nómina extraordinaria', 'E', '2', '1');

-- ----------------------------
-- Table structure for fcf_payrolls
-- ----------------------------
DROP TABLE IF EXISTS `fcf_payrolls`;
CREATE TABLE `fcf_payrolls` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `generated_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payroll_type_id` int(10) unsigned DEFAULT NULL,
  `branch_office_id` int(10) unsigned DEFAULT NULL,
  `date_payment` date DEFAULT NULL,
  `date_start_payment` date DEFAULT NULL,
  `date_end_payment` date DEFAULT NULL,
  `payment_days` int(11) NOT NULL DEFAULT '0',
  `currency_id` int(10) unsigned DEFAULT NULL,
  `currency_value` decimal(15,8) NOT NULL DEFAULT '0.00000000',
  `amount_discount` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_untaxed` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_isr` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_tax` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_tax_ret` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_total` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_perceptions` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_deductions` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `amount_other_payment_types` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `comment` text COLLATE utf8mb4_unicode_ci,
  `mail_sent` tinyint(1) NOT NULL DEFAULT '0',
  `company_id` int(10) unsigned DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '2',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE,
  KEY `payrolls_payroll_type_id_foreign` (`payroll_type_id`),
  KEY `payrolls_branch_office_id_foreign` (`branch_office_id`),
  KEY `payrolls_currency_id_foreign` (`currency_id`),
  KEY `payrolls_company_id_foreign` (`company_id`),
  CONSTRAINT `payrolls_branch_office_id_foreign` FOREIGN KEY (`branch_office_id`) REFERENCES `fcf_branch_offices` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `payrolls_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `fcf_companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `payrolls_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `fcf_currencies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `payrolls_payroll_type_id_foreign` FOREIGN KEY (`payroll_type_id`) REFERENCES `fcf_payroll_types` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_payrolls
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_pediments
-- ----------------------------
DROP TABLE IF EXISTS `fcf_pediments`;
CREATE TABLE `fcf_pediments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_pediments
-- ----------------------------
INSERT INTO `fcf_pediments` VALUES ('1', '2019-12-25 21:15:57', '2019-12-25 21:15:57', null, null, 'IMPORTACION O EXPORTACION DEFINITIVA', 'A1', '1', '1');

-- ----------------------------
-- Table structure for fcf_perceptions
-- ----------------------------
DROP TABLE IF EXISTS `fcf_perceptions`;
CREATE TABLE `fcf_perceptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `code2` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_perceptions
-- ----------------------------

-- ----------------------------
-- Table structure for fcf_postcodes
-- ----------------------------
DROP TABLE IF EXISTS `fcf_postcodes`;
CREATE TABLE `fcf_postcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_uid` int(10) unsigned DEFAULT NULL,
  `updated_uid` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code_state` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_city` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_location` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `diff1` int(11) NOT NULL DEFAULT '0',
  `diff2` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=95778 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of fcf_postcodes
-- ----------------------------
INSERT INTO `fcf_postcodes`
VALUES
  (null, now(), now(), null, null, '00000', 'AGU', '000', '00', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20000', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20001', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20002', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20003', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20004', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20005', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20006', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20007', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20008', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20009', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20010', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20011', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20012', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20013', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20014', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20015', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20016', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20017', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20018', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20019', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20020', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20021', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20022', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20023', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20024', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20025', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20026', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20027', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20028', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20029', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20030', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20031', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20032', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20033', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20034', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20035', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20036', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20037', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20038', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20039', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20040', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20041', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20042', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20043', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20044', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20045', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20046', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20047', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20048', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20049', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20050', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20051', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20052', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20053', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20054', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20055', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20056', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20057', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20058', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20059', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20060', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20061', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20062', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20063', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20064', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20065', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20066', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20067', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20068', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20069', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20070', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20071', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20072', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20073', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20074', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20075', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20076', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20077', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20078', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20079', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20080', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20081', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20082', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20083', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20084', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20085', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20086', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20087', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20088', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20089', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20090', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20091', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20092', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20093', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20094', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20095', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20096', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20097', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20098', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20099', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20100', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20101', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20102', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20103', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20104', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20105', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20106', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20107', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20108', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20109', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20110', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20111', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20112', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20113', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20114', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20115', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20116', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20117', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20118', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20119', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20120', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20121', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20122', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20123', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20124', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20125', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20126', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20127', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20128', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20129', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20130', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20131', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20132', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20133', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20134', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20135', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20136', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20137', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20138', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20139', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20140', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20141', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20142', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20143', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20144', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20145', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20146', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20147', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20148', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20149', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20150', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20151', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20152', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20153', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20154', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20155', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20156', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20157', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20158', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20159', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20160', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20161', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20162', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20163', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20164', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20165', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20166', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20167', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20168', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20169', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20170', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20171', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20172', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20173', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20174', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20175', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20176', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20177', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20178', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20179', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20180', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20181', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20182', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20183', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20184', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20185', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20186', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20187', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20188', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20189', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20190', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20191', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20192', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20193', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20194', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20195', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20196', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20197', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20198', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20199', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20200', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20201', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20202', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20203', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20204', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20205', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20206', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20207', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20208', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20209', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20210', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20211', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20212', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20213', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20214', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20215', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20216', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20217', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20218', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20219', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20220', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20221', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20222', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20223', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20224', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20225', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20226', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20227', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20228', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20229', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20230', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20231', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20232', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20233', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20234', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20235', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20236', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20237', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20238', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20239', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20240', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20241', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20242', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20243', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20244', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20245', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20246', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20247', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20248', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20249', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20250', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20251', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20252', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20253', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20254', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20255', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20256', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20257', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20258', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20259', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20260', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20261', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20262', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20263', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20264', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20265', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20266', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20267', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20268', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20269', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20270', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20271', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20272', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20273', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20274', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20275', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20276', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20277', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20278', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20279', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20280', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20281', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20282', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20283', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20284', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20285', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20286', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20287', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20288', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20289', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20290', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20291', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20292', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20293', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20294', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20295', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20296', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20297', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20298', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20299', 'AGU', '001', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20300', 'AGU', '011', '03', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20301', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20302', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20303', 'AGU', '011', '03', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20304', 'AGU', '011', '03', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20305', 'AGU', '011', '03', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20306', 'AGU', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20307', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20308', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20309', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20310', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20311', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20312', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20313', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20314', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20315', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20316', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20317', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20318', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20319', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20320', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20321', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20322', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20323', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20324', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20325', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20326', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20327', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20328', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20329', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20330', 'AGU', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20331', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20332', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20333', 'AGU', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20334', 'AGU', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20335', 'AGU', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20336', 'AGU', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20337', 'AGU', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20338', 'AGU', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20339', 'AGU', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20340', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20341', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20342', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20343', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20344', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20345', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20346', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20347', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20348', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20349', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20350', 'AGU', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20351', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20352', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20353', 'AGU', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20354', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20355', 'AGU', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20356', 'AGU', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20357', 'AGU', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20358', 'AGU', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20359', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20360', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20361', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20362', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20363', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20364', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20365', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20366', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20367', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20368', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20369', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20370', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20371', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20372', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20373', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20374', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20375', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20376', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20377', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20378', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20379', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20380', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20381', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20382', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20383', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20384', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20385', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20386', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20387', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20388', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20389', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20390', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20391', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20392', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20393', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20394', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20395', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20396', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20397', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20398', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20399', 'AGU', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20400', 'AGU', '007', '06', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20401', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20402', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20403', 'AGU', '007', '06', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20404', 'AGU', '007', '06', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20405', 'AGU', '007', '06', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20406', 'AGU', '007', '06', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20407', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20408', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20409', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20410', 'AGU', '007', '06', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20411', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20412', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20413', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20414', 'AGU', '007', '06', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20415', 'AGU', '007', '06', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20416', 'AGU', '007', '06', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20417', 'AGU', '007', '06', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20418', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20419', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20420', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20421', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20422', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20423', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20424', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20425', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20426', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20427', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20428', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20429', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20430', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20431', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20432', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20433', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20434', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20435', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20436', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20437', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20438', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20439', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20440', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20441', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20442', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20443', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20444', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20445', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20446', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20447', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20448', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20449', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20450', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20451', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20452', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20453', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20454', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20455', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20456', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20457', 'AGU', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20458', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20459', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20460', 'AGU', '004', '09', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20461', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20462', 'AGU', '004', '09', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20463', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20464', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20465', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20466', 'AGU', '004', '09', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20467', 'AGU', '004', '09', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20468', 'AGU', '004', '09', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20469', 'AGU', '004', '09', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20470', 'AGU', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20471', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20472', 'AGU', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20473', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20474', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20475', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20476', 'AGU', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20477', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20478', 'AGU', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20479', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20480', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20481', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20482', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20483', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20484', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20485', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20486', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20487', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20488', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20489', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20490', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20491', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20492', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20493', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20494', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20495', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20496', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20497', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20498', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20499', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20500', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20501', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20502', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20503', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20504', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20505', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20506', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20507', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20508', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20509', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20510', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20511', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20512', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20513', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20514', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20515', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20516', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20517', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20518', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20519', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20520', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20521', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20522', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20523', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20524', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20525', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20526', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20527', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20528', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20529', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20530', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20531', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20532', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20533', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20534', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20535', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20536', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20537', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20538', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20539', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20540', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20541', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20542', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20543', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20544', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20545', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20546', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20547', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20548', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20549', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20550', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20551', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20552', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20553', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20554', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20555', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20556', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20557', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20558', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20559', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20560', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20561', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20562', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20563', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20564', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20565', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20566', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20567', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20568', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20569', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20570', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20571', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20572', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20573', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20574', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20575', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20576', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20577', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20578', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20579', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20580', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20581', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20582', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20583', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20584', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20585', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20586', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20587', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20588', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20589', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20590', 'AGU', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20591', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20592', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20593', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20594', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20595', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20596', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20597', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20598', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20599', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20600', 'AGU', '009', '08', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20601', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20602', 'AGU', '009', '08', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20603', 'AGU', '009', '08', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20604', 'AGU', '009', '08', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20605', 'AGU', '009', '08', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20606', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20607', 'AGU', '009', '08', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20608', 'AGU', '009', '08', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20609', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20610', 'AGU', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20611', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20612', 'AGU', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20613', 'AGU', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20614', 'AGU', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20615', 'AGU', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20616', 'AGU', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20617', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20618', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20619', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20620', 'AGU', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20621', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20622', 'AGU', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20623', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20624', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20625', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20626', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20627', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20628', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20629', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20630', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20631', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20632', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20633', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20634', 'AGU', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20635', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20636', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20637', 'AGU', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20638', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20639', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20641', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20642', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20643', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20644', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20645', 'AGU', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20646', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20647', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20648', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20649', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20650', 'AGU', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20651', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20652', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20653', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20654', 'AGU', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20655', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20656', 'AGU', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20657', 'AGU', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20658', 'AGU', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20659', 'AGU', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20660', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20661', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20662', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20663', 'AGU', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20664', 'AGU', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20665', 'AGU', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20666', 'AGU', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20667', 'AGU', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20668', 'AGU', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20669', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20670', 'AGU', '006', '05', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20671', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20672', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20673', 'AGU', '006', '05', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20674', 'AGU', '006', '05', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20675', 'AGU', '006', '05', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20676', 'AGU', '006', '05', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20677', 'AGU', '006', '05', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20678', 'AGU', '006', '05', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20679', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20680', 'AGU', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20681', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20682', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20683', 'AGU', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20684', 'AGU', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20685', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20686', 'AGU', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20687', 'AGU', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20688', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20689', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20690', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20691', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20692', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20693', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20694', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20695', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20696', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20697', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20698', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20699', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20700', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20701', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20702', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20703', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20704', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20705', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20706', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20707', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20708', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20709', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20710', 'AGU', '002', '07', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20711', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20712', 'AGU', '002', '07', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20713', 'AGU', '002', '07', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20714', 'AGU', '002', '07', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20715', 'AGU', '002', '07', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20716', 'AGU', '002', '07', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20717', 'AGU', '002', '07', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20718', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20719', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20720', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20721', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20722', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20723', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20724', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20725', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20726', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20727', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20728', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20729', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20730', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20731', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20732', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20733', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20734', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20735', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20736', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20737', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20738', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20739', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20740', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20741', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20742', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20743', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20744', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20745', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20746', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20747', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20748', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20749', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20750', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20751', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20752', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20753', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20754', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20755', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20756', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20757', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20758', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20759', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20760', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20761', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20762', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20763', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20764', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20765', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20766', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20767', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20768', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20769', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20770', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20771', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20772', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20773', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20774', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20775', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20776', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20777', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20778', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20779', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20780', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20781', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20782', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20783', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20784', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20785', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20786', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20787', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20788', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20789', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20790', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20791', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20792', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20793', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20794', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20795', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20796', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20797', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20798', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20799', 'AGU', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20800', 'AGU', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20801', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20802', 'AGU', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20803', 'AGU', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20804', 'AGU', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20805', 'AGU', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20806', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20807', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20808', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20809', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20810', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20811', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20812', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20813', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20814', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20815', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20816', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20817', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20818', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20819', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20820', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20821', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20822', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20823', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20824', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20825', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20826', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20827', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20828', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20829', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20830', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20831', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20832', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20833', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20834', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20835', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20836', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20837', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20838', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20839', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20840', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20841', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20842', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20843', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20844', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20845', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20846', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20847', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20848', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20849', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20850', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20851', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20852', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20853', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20854', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20855', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20856', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20857', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20858', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20859', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20860', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20861', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20862', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20863', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20864', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20865', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20866', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20867', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20868', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20869', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20870', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20871', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20872', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20873', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20874', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20875', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20876', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20877', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20878', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20879', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20880', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20881', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20882', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20883', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20884', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20885', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20886', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20887', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20888', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20889', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20890', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20891', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20892', 'AGU', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20893', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20894', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20895', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20896', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20897', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20898', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20899', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20900', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20901', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20902', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20903', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20904', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20905', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20906', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20907', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20908', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20909', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20910', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20911', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20912', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20913', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20914', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20915', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20916', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20917', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20918', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20919', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20920', 'AGU', '005', '04', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20921', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20922', 'AGU', '005', '04', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20923', 'AGU', '005', '04', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20924', 'AGU', '005', '04', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20925', 'AGU', '005', '04', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20926', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20927', 'AGU', '005', '04', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20928', 'AGU', '005', '04', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20929', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20930', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20931', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20932', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20933', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20934', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20935', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20936', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20937', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20938', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20939', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20940', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20941', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20942', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20943', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20944', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20945', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20946', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20947', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20948', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20949', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20950', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20951', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20952', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20953', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20954', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20955', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20956', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20957', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20958', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20959', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20960', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20961', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20962', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20963', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20964', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20965', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20966', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20967', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20968', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20969', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20970', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20971', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20972', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20973', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20974', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20975', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20976', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20977', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20978', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20979', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20980', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20981', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20982', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20983', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20984', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20985', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20986', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20987', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20988', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20989', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20990', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20991', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20992', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20993', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20994', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20995', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20996', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20997', 'AGU', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20998', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '20999', 'AGU', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '00000', 'BCN', '000', '00', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21000', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21001', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21002', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21003', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21004', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21005', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21006', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21007', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21008', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21009', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21010', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21011', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21012', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21013', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21014', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21015', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21016', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21017', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21018', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21019', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21020', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21021', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21022', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21023', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21024', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21025', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21026', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21027', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21028', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21029', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21030', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21031', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21032', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21033', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21034', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21035', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21036', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21037', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21038', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21039', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21040', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21041', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21042', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21043', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21044', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21045', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21046', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21047', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21048', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21049', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21050', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21051', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21052', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21053', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21054', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21055', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21056', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21057', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21058', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21059', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21060', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21061', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21062', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21063', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21064', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21065', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21066', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21067', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21068', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21069', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21070', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21071', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21072', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21073', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21074', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21075', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21076', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21077', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21078', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21079', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21080', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21081', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21082', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21083', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21084', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21085', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21086', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21087', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21088', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21089', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21090', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21091', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21092', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21093', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21094', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21095', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21096', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21097', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21098', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21099', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21100', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21101', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21102', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21103', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21104', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21105', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21106', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21107', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21108', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21109', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21110', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21111', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21112', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21113', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21114', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21115', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21116', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21117', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21118', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21119', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21120', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21121', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21122', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21123', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21124', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21125', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21126', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21127', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21128', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21129', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21130', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21131', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21132', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21133', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21134', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21135', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21136', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21137', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21138', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21139', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21140', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21141', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21142', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21143', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21144', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21145', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21146', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21147', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21148', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21149', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21150', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21151', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21152', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21153', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21154', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21155', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21156', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21157', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21158', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21159', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21160', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21161', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21162', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21163', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21164', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21165', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21166', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21167', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21168', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21169', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21170', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21171', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21172', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21173', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21174', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21175', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21176', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21177', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21178', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21179', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21180', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21181', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21182', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21183', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21184', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21185', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21186', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21187', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21188', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21189', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21190', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21191', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21192', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21193', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21194', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21195', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21196', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21197', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21198', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21199', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21200', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21201', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21202', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21203', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21204', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21205', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21206', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21207', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21208', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21209', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21210', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21211', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21212', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21213', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21214', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21215', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21216', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21217', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21218', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21219', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21220', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21221', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21222', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21223', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21224', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21225', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21226', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21227', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21228', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21229', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21230', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21231', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21232', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21233', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21234', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21235', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21236', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21237', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21238', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21239', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21240', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21241', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21242', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21243', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21244', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21245', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21246', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21247', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21248', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21249', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21250', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21251', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21252', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21253', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21254', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21255', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21256', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21257', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21258', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21259', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21260', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21261', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21262', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21263', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21264', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21265', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21266', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21267', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21268', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21269', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21270', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21271', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21272', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21273', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21274', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21275', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21276', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21277', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21278', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21279', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21280', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21281', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21282', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21283', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21284', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21285', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21286', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21287', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21288', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21289', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21290', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21291', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21292', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21293', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21294', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21295', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21296', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21297', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21298', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21299', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21300', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21301', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21302', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21303', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21304', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21305', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21306', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21307', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21308', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21309', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21310', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21311', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21312', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21313', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21314', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21315', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21316', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21317', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21318', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21319', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21320', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21321', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21322', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21323', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21324', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21325', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21326', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21327', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21328', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21329', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21330', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21331', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21332', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21333', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21334', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21335', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21336', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21337', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21338', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21339', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21340', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21341', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21342', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21343', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21344', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21345', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21346', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21347', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21348', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21349', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21350', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21351', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21352', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21353', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21354', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21355', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21356', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21357', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21358', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21359', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21360', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21361', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21362', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21363', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21364', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21365', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21366', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21367', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21368', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21369', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21370', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21371', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21372', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21373', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21374', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21375', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21376', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21377', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21378', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21379', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21380', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21381', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21382', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21383', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21384', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21385', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21386', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21387', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21388', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21389', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21390', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21391', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21392', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21393', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21394', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21395', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21396', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21397', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21398', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21399', 'BCN', '002', '02', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21400', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21401', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21402', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21403', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21404', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21405', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21406', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21407', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21408', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21409', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21410', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21411', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21412', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21413', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21414', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21415', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21416', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21417', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21418', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21419', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21420', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21421', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21422', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21423', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21424', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21425', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21426', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21427', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21428', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21429', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21430', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21431', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21432', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21433', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21434', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21435', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21436', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21437', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21438', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21439', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21440', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21441', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21442', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21443', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21444', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21445', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21446', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21447', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21448', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21449', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21450', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21451', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21452', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21453', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21454', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21455', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21456', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21457', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21458', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21459', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21460', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21461', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21462', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21463', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21464', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21465', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21466', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21467', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21468', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21469', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21470', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21471', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21472', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21473', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21474', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21475', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21476', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21477', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21478', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21479', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21480', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21481', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21482', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21483', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21484', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21485', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21486', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21487', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21488', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21489', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21490', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21491', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21492', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21493', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21494', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21495', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21496', 'BCN', '003', '03', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21497', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21498', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21499', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21500', 'BCN', '003', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21501', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21502', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21503', 'BCN', '003', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21504', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21505', 'BCN', '003', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21506', 'BCN', '003', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21507', 'BCN', '003', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21508', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21509', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21510', 'BCN', '003', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21511', 'BCN', '003', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21512', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21513', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21514', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21515', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21516', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21517', 'BCN', '003', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21518', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21519', 'BCN', '003', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21520', 'BCN', '003', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21521', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21522', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21523', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21524', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21525', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21526', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21527', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21528', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21529', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21530', 'BCN', '003', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21531', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21532', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21533', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21534', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21535', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21536', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21537', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21538', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21539', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21540', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21541', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21542', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21543', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21544', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21545', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21546', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21547', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21548', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21549', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21550', 'BCN', '003', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21551', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21552', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21553', 'BCN', '003', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21554', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21555', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21556', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21557', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21558', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21559', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21560', 'BCN', '003', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21561', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21562', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21563', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21564', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21565', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21566', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21567', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21568', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21569', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21570', 'BCN', '003', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21571', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21572', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21573', 'BCN', '003', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21574', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21575', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21576', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21577', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21578', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21579', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21580', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21581', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21582', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21583', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21584', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21585', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21586', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21587', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21588', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21589', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21590', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21591', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21592', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21593', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21594', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21595', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21596', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21597', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21598', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21599', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21600', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21601', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21602', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21603', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21604', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21605', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21606', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21607', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21608', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21609', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21610', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21611', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21612', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21613', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21614', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21615', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21616', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21617', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21618', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21619', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21620', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21621', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21622', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21623', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21624', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21625', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21626', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21627', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21628', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21629', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21630', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21631', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21632', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21633', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21634', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21635', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21636', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21637', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21638', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21639', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21640', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21641', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21642', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21643', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21644', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21645', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21646', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21647', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21648', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21649', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21650', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21651', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21652', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21653', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21654', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21655', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21656', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21657', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21658', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21659', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21660', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21661', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21662', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21663', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21664', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21665', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21666', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21667', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21668', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21669', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21670', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21671', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21672', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21673', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21674', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21675', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21676', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21677', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21678', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21679', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21680', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21681', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21682', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21683', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21684', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21685', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21686', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21687', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21688', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21689', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21690', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21691', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21692', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21693', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21694', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21695', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21696', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21697', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21698', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21699', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21700', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21701', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21702', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21703', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21704', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21705', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21706', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21707', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21708', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21709', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21710', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21711', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21712', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21713', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21714', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21715', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21716', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21717', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21718', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21719', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21720', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21721', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21722', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21723', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21724', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21725', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21726', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21727', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21728', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21729', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21730', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21731', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21732', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21733', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21734', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21735', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21736', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21737', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21738', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21739', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21740', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21741', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21742', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21743', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21744', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21745', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21746', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21747', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21748', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21749', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21750', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21751', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21752', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21753', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21754', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21755', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21756', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21757', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21758', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21759', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21760', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21761', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21762', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21763', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21764', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21765', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21766', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21767', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21768', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21769', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21770', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21771', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21772', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21773', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21774', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21775', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21776', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21777', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21778', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21779', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21780', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21781', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21782', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21783', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21784', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21785', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21786', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21787', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21788', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21789', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21790', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21791', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21792', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21793', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21794', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21795', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21796', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21797', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21798', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21799', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21800', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21801', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21802', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21803', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21804', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21805', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21806', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21807', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21808', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21809', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21810', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21811', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21812', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21813', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21814', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21815', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21816', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21817', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21818', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21819', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21820', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21821', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21822', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21823', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21824', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21825', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21826', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21827', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21828', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21829', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21830', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21831', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21832', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21833', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21834', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21835', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21836', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21837', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21838', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21839', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21840', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21841', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21842', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21843', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21844', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21845', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21846', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21847', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21848', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21849', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21850', 'BCN', '002', '07', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21851', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21852', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21853', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21854', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21855', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21856', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21857', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21858', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21859', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21860', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21861', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21862', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21863', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21864', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21865', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21866', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21867', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21868', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21869', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21870', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21871', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21872', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21873', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21874', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21875', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21876', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21877', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21878', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21879', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21880', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21881', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21882', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21883', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21884', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21885', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21886', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21887', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21888', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21889', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21890', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21891', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21892', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21893', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21894', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21895', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21896', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21897', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21898', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21899', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21900', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21901', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21902', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21903', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21904', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21905', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21906', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21907', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21908', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21909', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21910', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21911', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21912', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21913', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21914', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21915', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21916', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21917', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21918', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21919', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21920', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21921', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21922', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21923', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21924', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21925', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21926', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21927', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21928', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21929', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21930', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21931', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21932', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21933', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21934', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21935', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21936', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21937', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21938', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21939', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21940', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21941', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21942', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21943', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21944', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21945', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21946', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21947', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21948', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21949', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21950', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21951', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21952', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21953', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21954', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21955', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21956', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21957', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21958', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21959', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21960', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21961', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21962', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21963', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21964', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21965', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21966', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21967', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21968', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21969', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21970', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21971', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21972', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21973', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21974', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21975', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21976', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21977', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21978', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21979', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21980', 'BCN', '002', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21981', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21982', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21983', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21984', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21985', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21986', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21987', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21988', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21989', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21990', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21991', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21992', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21993', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21994', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21995', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21996', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21997', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21998', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '21999', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22000', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22001', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22002', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22003', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22004', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22005', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22006', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22007', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22008', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22009', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22010', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22011', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22012', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22013', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22014', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22015', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22016', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22017', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22018', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22019', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22020', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22021', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22022', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22023', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22024', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22025', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22026', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22027', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22028', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22029', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22030', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22031', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22032', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22033', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22034', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22035', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22036', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22037', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22038', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22039', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22040', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22041', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22042', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22043', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22044', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22045', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22046', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22047', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22048', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22049', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22050', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22051', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22052', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22053', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22054', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22055', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22056', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22057', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22058', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22059', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22060', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22061', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22062', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22063', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22064', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22065', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22066', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22067', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22068', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22069', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22070', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22071', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22072', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22073', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22074', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22075', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22076', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22077', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22078', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22079', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22080', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22081', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22082', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22083', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22084', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22085', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22086', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22087', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22088', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22089', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22090', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22091', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22092', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22093', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22094', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22095', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22096', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22097', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22098', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22099', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22100', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22101', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22102', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22103', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22104', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22105', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22106', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22107', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22108', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22109', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22110', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22111', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22112', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22113', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22114', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22115', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22116', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22117', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22118', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22119', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22120', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22121', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22122', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22123', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22124', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22125', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22126', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22127', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22128', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22129', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22130', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22131', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22132', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22133', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22134', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22135', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22136', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22137', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22138', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22139', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22140', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22141', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22142', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22143', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22144', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22145', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22146', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22147', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22148', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22149', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22150', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22151', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22152', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22153', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22154', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22155', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22156', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22157', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22158', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22159', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22160', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22161', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22162', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22163', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22164', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22165', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22166', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22167', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22168', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22169', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22170', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22171', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22172', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22173', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22174', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22175', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22176', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22177', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22178', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22179', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22180', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22181', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22182', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22183', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22184', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22185', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22186', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22187', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22188', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22189', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22190', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22191', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22192', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22193', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22194', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22195', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22196', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22197', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22198', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22199', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22200', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22201', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22202', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22203', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22204', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22205', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22206', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22207', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22208', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22209', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22210', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22211', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22212', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22213', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22214', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22215', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22216', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22217', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22218', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22219', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22220', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22221', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22222', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22223', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22224', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22225', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22226', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22227', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22228', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22229', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22230', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22231', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22232', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22233', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22234', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22235', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22236', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22237', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22238', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22239', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22240', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22241', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22242', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22243', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22244', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22245', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22246', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22247', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22248', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22249', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22250', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22251', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22252', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22253', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22254', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22255', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22256', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22257', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22258', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22259', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22260', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22261', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22262', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22263', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22264', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22265', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22266', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22267', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22268', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22269', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22270', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22271', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22272', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22273', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22274', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22275', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22276', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22277', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22278', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22279', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22280', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22281', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22282', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22283', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22284', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22285', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22286', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22287', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22288', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22289', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22290', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22291', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22292', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22293', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22294', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22295', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22296', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22297', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22298', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22299', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22300', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22301', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22302', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22303', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22304', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22305', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22306', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22307', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22308', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22309', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22310', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22311', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22312', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22313', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22314', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22315', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22316', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22317', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22318', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22319', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22320', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22321', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22322', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22323', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22324', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22325', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22326', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22327', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22328', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22329', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22330', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22331', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22332', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22333', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22334', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22335', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22336', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22337', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22338', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22339', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22340', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22341', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22342', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22343', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22344', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22345', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22346', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22347', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22348', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22349', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22350', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22351', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22352', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22353', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22354', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22355', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22356', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22357', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22358', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22359', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22360', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22361', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22362', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22363', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22364', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22365', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22366', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22367', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22368', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22369', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22370', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22371', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22372', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22373', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22374', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22375', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22376', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22377', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22378', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22379', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22380', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22381', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22382', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22383', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22384', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22385', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22386', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22387', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22388', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22389', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22390', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22391', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22392', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22393', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22394', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22395', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22396', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22397', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22398', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22399', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22400', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22401', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22402', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22403', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22404', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22405', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22406', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22407', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22408', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22409', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22410', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22411', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22412', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22413', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22414', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22415', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22416', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22417', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22418', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22419', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22420', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22421', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22422', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22423', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22424', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22425', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22426', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22427', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22428', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22429', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22430', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22431', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22432', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22433', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22434', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22435', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22436', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22437', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22438', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22439', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22440', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22441', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22442', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22443', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22444', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22445', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22446', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22447', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22448', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22449', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22450', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22451', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22452', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22453', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22454', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22455', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22456', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22457', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22458', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22459', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22460', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22461', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22462', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22463', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22464', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22465', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22466', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22467', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22468', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22469', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22470', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22471', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22472', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22473', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22474', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22475', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22476', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22477', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22478', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22479', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22480', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22481', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22482', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22483', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22484', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22485', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22486', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22487', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22488', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22489', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22490', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22491', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22492', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22493', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22494', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22495', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22496', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22497', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22498', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22499', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22500', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22501', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22502', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22503', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22504', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22505', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22506', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22507', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22508', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22509', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22510', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22511', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22512', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22513', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22514', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22515', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22516', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22517', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22518', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22519', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22520', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22521', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22522', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22523', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22524', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22525', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22526', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22527', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22528', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22529', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22530', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22531', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22532', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22533', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22534', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22535', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22536', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22537', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22538', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22539', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22540', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22541', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22542', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22543', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22544', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22545', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22546', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22547', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22548', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22549', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22550', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22551', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22552', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22553', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22554', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22555', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22556', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22557', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22558', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22559', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22560', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22561', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22562', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22563', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22564', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22565', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22566', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22567', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22568', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22569', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22570', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22571', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22572', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22573', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22574', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22575', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22576', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22577', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22578', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22579', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22580', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22581', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22582', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22583', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22584', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22585', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22586', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22587', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22588', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22589', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22590', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22591', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22592', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22593', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22594', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22595', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22596', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22597', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22598', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22599', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22600', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22601', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22602', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22603', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22604', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22605', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22606', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22607', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22608', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22609', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22610', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22611', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22612', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22613', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22614', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22615', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22616', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22617', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22618', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22619', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22620', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22621', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22622', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22623', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22624', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22625', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22626', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22627', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22628', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22629', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22630', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22631', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22632', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22633', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22634', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22635', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22636', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22637', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22638', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22639', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22640', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22641', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22642', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22643', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22644', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22645', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22646', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22647', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22648', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22649', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22650', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22651', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22652', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22653', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22654', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22655', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22656', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22657', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22658', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22659', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22660', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22661', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22662', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22663', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22664', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22665', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22666', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22667', 'BCN', '004', '04', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22668', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22669', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22670', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22671', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22672', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22673', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22674', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22675', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22676', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22677', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22678', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22679', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22680', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22681', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22682', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22683', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22684', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22685', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22686', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22687', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22688', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22689', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22690', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22691', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22692', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22693', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22694', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22695', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22696', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22697', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22698', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22699', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22700', 'BCN', '005', '05', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22701', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22702', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22703', 'BCN', '005', '05', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22704', 'BCN', '005', '05', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22705', 'BCN', '005', '05', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22706', 'BCN', '005', '05', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22707', 'BCN', '005', '05', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22708', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22709', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22710', 'BCN', '005', '05', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22711', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22712', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22713', 'BCN', '005', '05', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22714', 'BCN', '005', '05', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22715', 'BCN', '005', '05', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22716', 'BCN', '005', '05', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22717', 'BCN', '005', '05', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22718', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22719', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22720', 'BCN', '004', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22721', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22722', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22723', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22724', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22725', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22726', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22727', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22728', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22729', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22730', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22731', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22732', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22733', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22734', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22735', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22736', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22737', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22738', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22739', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22740', 'BCN', '005', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22741', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22742', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22743', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22744', 'BCN', '005', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22745', 'BCN', '005', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22746', 'BCN', '005', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22747', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22748', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22749', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22750', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22751', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22752', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22753', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22754', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22755', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22756', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22757', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22758', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22759', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22760', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22761', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22762', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22763', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22764', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22765', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22766', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22767', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22768', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22769', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22770', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22771', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22772', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22773', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22774', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22775', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22776', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22777', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22778', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22779', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22780', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22781', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22782', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22783', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22784', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22785', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22786', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22787', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22788', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22789', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22790', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22791', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22792', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22793', 'BCN', '001', '06', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22794', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22795', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22796', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22797', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22798', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22799', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22800', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22801', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22802', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22803', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22804', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22805', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22806', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22807', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22808', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22809', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22810', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22811', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22812', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22813', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22814', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22815', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22816', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22817', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22818', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22819', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22820', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22821', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22822', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22823', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22824', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22825', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22826', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22827', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22828', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22829', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22830', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22831', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22832', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22833', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22834', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22835', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22836', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22837', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22838', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22839', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22840', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22841', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22842', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22843', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22844', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22845', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22846', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22847', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22848', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22849', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22850', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22851', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22852', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22853', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22854', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22855', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22856', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22857', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22858', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22859', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22860', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22861', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22862', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22863', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22864', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22865', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22866', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22867', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22868', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22869', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22870', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22871', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22872', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22873', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22874', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22875', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22876', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22877', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22878', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22879', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22880', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22881', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22882', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22883', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22884', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22885', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22886', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22887', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22888', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22889', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22890', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22891', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22892', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22893', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22894', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22895', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22896', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22897', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22898', 'BCN', '001', '01', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22899', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22900', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22901', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22902', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22903', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22904', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22905', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22906', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22907', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22908', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22909', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22910', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22911', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22912', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22913', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22914', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22915', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22916', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22917', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22918', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22919', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22920', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22921', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22922', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22923', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22924', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22925', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22926', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22927', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22928', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22929', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22930', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22931', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22932', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22933', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22934', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22935', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22936', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22937', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22938', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22939', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22940', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22941', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22942', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22943', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22944', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22945', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22946', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22947', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22948', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22949', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22950', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22951', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22952', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22953', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22954', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22955', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22956', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22957', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22958', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22959', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22960', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22961', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22962', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22963', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22964', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22965', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22966', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22967', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22968', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22969', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22970', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22971', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22972', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22973', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22974', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22975', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22976', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22977', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22978', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22979', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22980', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22981', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22982', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22983', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22984', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22985', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22986', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22987', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22988', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22989', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22990', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22991', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22992', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22993', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22994', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22995', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22996', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22997', 'BCN', '001', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22998', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '22999', 'BCN', '', '', '-7', '-8','0', '1'),
(null, now(), now(), null, null, '00000', 'BCS', '000', '00', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23000', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23001', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23002', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23003', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23004', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23005', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23006', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23007', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23008', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23009', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23010', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23011', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23012', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23013', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23014', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23015', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23016', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23017', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23018', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23019', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23020', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23021', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23022', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23023', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23024', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23025', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23026', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23027', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23028', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23029', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23030', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23031', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23032', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23033', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23034', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23035', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23036', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23037', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23038', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23039', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23040', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23041', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23042', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23043', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23044', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23045', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23046', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23047', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23048', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23049', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23050', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23051', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23052', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23053', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23054', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23055', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23056', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23057', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23058', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23059', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23060', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23061', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23062', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23063', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23064', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23065', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23066', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23067', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23068', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23069', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23070', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23071', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23072', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23073', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23074', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23075', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23076', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23077', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23078', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23079', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23080', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23081', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23082', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23083', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23084', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23085', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23086', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23087', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23088', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23089', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23090', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23091', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23092', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23093', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23094', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23095', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23096', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23097', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23098', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23099', 'BCS', '003', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23100', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23101', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23102', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23103', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23104', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23105', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23106', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23107', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23108', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23109', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23110', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23111', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23112', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23113', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23114', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23115', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23116', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23117', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23118', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23119', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23120', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23121', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23122', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23123', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23124', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23125', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23126', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23127', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23128', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23129', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23130', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23131', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23132', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23133', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23134', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23135', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23136', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23137', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23138', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23139', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23140', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23141', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23142', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23143', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23144', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23145', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23146', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23147', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23148', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23149', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23150', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23151', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23152', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23153', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23154', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23155', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23156', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23157', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23158', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23159', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23160', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23161', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23162', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23163', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23164', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23165', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23166', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23167', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23168', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23169', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23170', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23171', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23172', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23173', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23174', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23175', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23176', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23177', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23178', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23179', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23180', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23181', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23182', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23183', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23184', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23185', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23186', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23187', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23188', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23189', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23190', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23191', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23192', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23193', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23194', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23195', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23196', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23197', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23198', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23199', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23200', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23201', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23202', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23203', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23204', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23205', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23206', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23207', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23208', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23209', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23210', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23211', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23212', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23213', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23214', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23215', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23216', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23217', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23218', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23219', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23220', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23221', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23222', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23223', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23224', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23225', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23226', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23227', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23228', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23229', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23230', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23231', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23232', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23233', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23234', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23235', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23236', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23237', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23238', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23239', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23240', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23241', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23242', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23243', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23244', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23245', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23246', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23247', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23248', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23249', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23250', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23251', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23252', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23253', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23254', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23255', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23256', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23257', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23258', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23259', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23260', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23261', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23262', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23263', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23264', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23265', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23266', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23267', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23268', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23269', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23270', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23271', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23272', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23273', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23274', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23275', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23276', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23277', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23278', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23279', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23280', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23281', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23282', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23283', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23284', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23285', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23286', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23287', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23288', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23289', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23290', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23291', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23292', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23293', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23294', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23295', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23296', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23297', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23298', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23299', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23300', 'BCS', '003', '07', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23301', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23302', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23303', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23304', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23305', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23306', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23307', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23308', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23309', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23310', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23311', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23312', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23313', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23314', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23315', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23316', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23317', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23318', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23319', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23320', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23321', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23322', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23323', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23324', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23325', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23326', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23327', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23328', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23329', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23330', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23331', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23332', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23333', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23334', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23335', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23336', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23337', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23338', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23339', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23340', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23341', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23342', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23343', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23344', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23345', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23346', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23347', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23348', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23349', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23350', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23351', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23352', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23353', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23354', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23355', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23356', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23357', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23358', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23359', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23360', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23361', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23362', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23363', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23364', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23365', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23366', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23367', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23368', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23369', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23370', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23371', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23372', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23373', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23374', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23375', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23376', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23377', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23378', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23379', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23380', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23381', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23382', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23383', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23384', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23385', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23386', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23387', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23388', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23389', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23390', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23391', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23392', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23393', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23394', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23395', 'BCS', '003', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23396', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23397', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23398', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23399', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23400', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23401', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23402', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23403', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23404', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23405', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23406', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23407', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23408', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23409', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23410', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23411', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23412', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23413', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23414', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23415', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23416', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23417', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23418', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23419', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23420', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23421', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23422', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23423', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23424', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23425', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23426', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23427', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23428', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23429', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23430', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23431', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23432', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23433', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23434', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23435', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23436', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23437', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23438', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23439', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23440', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23441', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23442', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23443', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23444', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23445', 'BCS', '008', '04', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23446', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23447', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23448', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23449', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23450', 'BCS', '008', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23451', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23452', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23453', 'BCS', '008', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23454', 'BCS', '008', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23455', 'BCS', '008', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23456', 'BCS', '008', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23457', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23458', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23459', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23460', 'BCS', '008', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23461', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23462', 'BCS', '008', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23463', 'BCS', '008', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23464', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23465', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23466', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23467', 'BCS', '008', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23468', 'BCS', '008', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23469', 'BCS', '008', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23470', 'BCS', '008', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23471', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23472', 'BCS', '008', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23473', 'BCS', '008', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23474', 'BCS', '008', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23475', 'BCS', '008', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23476', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23477', 'BCS', '008', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23478', 'BCS', '008', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23479', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23480', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23481', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23482', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23483', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23484', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23485', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23486', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23487', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23488', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23489', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23490', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23491', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23492', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23493', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23494', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23495', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23496', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23497', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23498', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23499', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23500', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23501', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23502', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23503', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23504', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23505', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23506', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23507', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23508', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23509', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23510', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23511', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23512', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23513', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23514', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23515', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23516', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23517', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23518', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23519', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23520', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23521', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23522', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23523', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23524', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23525', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23526', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23527', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23528', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23529', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23530', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23531', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23532', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23533', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23534', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23535', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23536', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23537', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23538', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23539', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23540', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23541', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23542', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23543', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23544', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23545', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23546', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23547', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23548', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23549', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23550', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23551', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23552', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23553', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23554', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23555', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23556', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23557', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23558', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23559', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23560', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23561', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23562', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23563', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23564', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23565', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23566', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23567', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23568', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23569', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23570', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23571', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23572', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23573', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23574', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23575', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23576', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23577', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23578', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23579', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23580', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23581', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23582', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23583', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23584', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23585', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23586', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23587', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23588', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23589', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23590', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23591', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23592', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23593', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23594', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23595', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23596', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23597', 'BCS', '008', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23598', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23599', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23600', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23601', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23602', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23603', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23604', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23605', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23606', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23607', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23608', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23609', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23610', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23611', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23612', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23613', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23614', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23615', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23616', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23617', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23618', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23619', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23620', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23621', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23622', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23623', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23624', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23625', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23626', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23627', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23628', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23629', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23630', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23631', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23632', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23633', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23634', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23635', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23636', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23637', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23638', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23639', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23640', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23641', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23642', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23643', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23644', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23645', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23646', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23647', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23648', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23649', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23650', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23651', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23652', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23653', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23654', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23655', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23656', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23657', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23658', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23659', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23660', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23661', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23662', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23663', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23664', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23665', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23666', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23667', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23668', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23669', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23670', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23671', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23672', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23673', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23674', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23675', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23676', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23677', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23678', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23679', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23680', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23681', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23682', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23683', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23684', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23685', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23686', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23687', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23688', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23689', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23690', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23691', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23692', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23693', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23694', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23695', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23696', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23697', 'BCS', '001', '01', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23698', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23699', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23700', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23701', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23702', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23703', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23704', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23705', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23706', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23707', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23708', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23709', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23710', 'BCS', '001', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23711', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23712', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23713', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23714', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23715', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23716', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23717', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23718', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23719', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23720', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23721', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23722', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23723', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23724', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23725', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23726', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23727', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23728', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23729', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23730', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23731', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23732', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23733', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23734', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23735', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23736', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23737', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23738', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23739', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23740', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23741', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23742', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23743', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23744', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23745', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23746', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23747', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23748', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23749', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23750', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23751', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23752', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23753', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23754', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23755', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23756', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23757', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23758', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23759', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23760', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23761', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23762', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23763', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23764', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23765', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23766', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23767', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23768', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23769', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23770', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23771', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23772', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23773', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23774', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23775', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23776', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23777', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23778', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23779', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23780', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23781', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23782', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23783', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23784', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23785', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23786', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23787', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23788', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23789', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23790', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23791', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23792', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23793', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23794', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23795', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23796', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23797', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23798', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23799', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23800', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23801', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23802', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23803', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23804', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23805', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23806', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23807', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23808', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23809', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23810', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23811', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23812', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23813', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23814', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23815', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23816', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23817', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23818', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23819', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23820', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23821', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23822', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23823', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23824', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23825', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23826', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23827', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23828', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23829', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23830', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23831', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23832', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23833', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23834', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23835', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23836', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23837', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23838', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23839', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23840', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23841', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23842', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23843', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23844', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23845', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23846', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23847', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23848', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23849', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23850', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23851', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23852', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23853', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23854', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23855', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23856', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23857', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23858', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23859', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23860', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23861', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23862', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23863', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23864', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23865', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23866', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23867', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23868', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23869', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23870', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23871', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23872', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23873', 'BCS', '001', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23874', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23875', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23876', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23877', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23878', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23879', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23880', 'BCS', '009', '05', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23881', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23882', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23883', 'BCS', '009', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23884', 'BCS', '009', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23885', 'BCS', '009', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23886', 'BCS', '009', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23887', 'BCS', '009', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23888', 'BCS', '009', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23889', 'BCS', '009', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23890', 'BCS', '009', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23891', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23892', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23893', 'BCS', '009', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23894', 'BCS', '009', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23895', 'BCS', '009', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23896', 'BCS', '009', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23897', 'BCS', '009', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23898', 'BCS', '009', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23899', 'BCS', '009', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23900', 'BCS', '002', '08', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23901', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23902', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23903', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23904', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23905', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23906', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23907', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23908', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23909', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23910', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23911', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23912', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23913', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23914', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23915', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23916', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23917', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23918', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23919', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23920', 'BCS', '002', '12', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23921', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23922', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23923', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23924', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23925', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23926', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23927', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23928', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23929', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23930', 'BCS', '002', '10', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23931', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23932', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23933', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23934', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23935', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23936', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23937', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23938', 'BCS', '002', '09', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23939', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23940', 'BCS', '002', '11', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23941', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23942', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23943', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23944', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23945', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23946', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23947', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23948', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23949', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23950', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23951', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23952', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23953', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23954', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23955', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23956', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23957', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23958', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23959', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23960', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23961', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23962', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23963', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23964', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23965', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23966', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23967', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23968', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23969', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23970', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23971', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23972', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23973', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23974', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23975', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23976', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23977', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23978', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23979', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23980', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23981', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23982', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23983', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23984', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23985', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23986', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23987', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23988', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23989', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23990', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23991', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23992', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23993', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23994', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23995', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23996', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23997', 'BCS', '002', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23998', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '23999', 'BCS', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '00000', 'CAM', '000', '00', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24000', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24001', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24002', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24003', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24004', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24005', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24006', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24007', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24008', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24009', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24010', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24011', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24012', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24013', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24014', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24015', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24016', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24017', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24018', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24019', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24020', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24021', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24022', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24023', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24024', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24025', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24026', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24027', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24028', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24029', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24030', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24031', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24032', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24033', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24034', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24035', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24036', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24037', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24038', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24039', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24040', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24041', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24042', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24043', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24044', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24045', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24046', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24047', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24048', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24049', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24050', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24051', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24052', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24053', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24054', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24055', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24056', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24057', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24058', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24059', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24060', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24061', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24062', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24063', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24064', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24065', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24066', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24067', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24068', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24069', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24070', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24071', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24072', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24073', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24074', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24075', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24076', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24077', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24078', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24079', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24080', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24081', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24082', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24083', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24084', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24085', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24086', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24087', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24088', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24089', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24090', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24091', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24092', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24093', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24094', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24095', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24096', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24097', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24098', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24099', 'CAM', '002', '01', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24100', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24101', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24102', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24103', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24104', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24105', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24106', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24107', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24108', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24109', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24110', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24111', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24112', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24113', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24114', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24115', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24116', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24117', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24118', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24119', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24120', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24121', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24122', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24123', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24124', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24125', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24126', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24127', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24128', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24129', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24130', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24131', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24132', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24133', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24134', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24135', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24136', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24137', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24138', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24139', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24140', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24141', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24142', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24143', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24144', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24145', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24146', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24147', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24148', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24149', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24150', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24151', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24152', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24153', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24154', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24155', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24156', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24157', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24158', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24159', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24160', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24161', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24162', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24163', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24164', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24165', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24166', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24167', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24168', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24169', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24170', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24171', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24172', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24173', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24174', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24175', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24176', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24177', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24178', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24179', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24180', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24181', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24182', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24183', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24184', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24185', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24186', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24187', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24188', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24189', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24190', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24191', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24192', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24193', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24194', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24195', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24196', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24197', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24198', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24199', 'CAM', '003', '02', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24200', 'CAM', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24201', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24202', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24203', 'CAM', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24204', 'CAM', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24205', 'CAM', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24206', 'CAM', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24207', 'CAM', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24208', 'CAM', '007', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24209', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24210', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24211', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24212', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24213', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24214', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24215', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24216', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24217', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24218', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24219', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24220', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24221', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24222', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24223', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24224', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24225', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24226', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24227', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24228', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24229', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24230', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24231', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24232', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24233', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24234', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24235', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24236', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24237', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24238', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24239', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24240', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24241', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24242', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24243', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24244', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24245', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24246', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24247', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24248', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24249', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24250', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24251', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24252', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24253', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24254', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24255', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24256', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24257', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24258', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24259', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24260', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24261', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24262', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24263', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24264', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24265', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24266', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24267', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24268', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24269', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24270', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24271', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24272', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24273', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24274', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24275', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24276', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24277', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24278', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24279', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24280', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24281', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24282', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24283', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24284', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24285', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24286', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24287', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24288', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24289', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24290', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24291', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24292', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24293', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24294', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24295', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24296', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24297', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24298', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24299', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24300', 'CAM', '003', '06', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24301', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24302', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24303', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24304', 'CAM', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24305', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24306', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24307', 'CAM', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24308', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24309', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24310', 'CAM', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24311', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24312', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24313', 'CAM', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24314', 'CAM', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24315', 'CAM', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24316', 'CAM', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24317', 'CAM', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24318', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24319', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24320', 'CAM', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24321', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24322', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24323', 'CAM', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24324', 'CAM', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24325', 'CAM', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24326', 'CAM', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24327', 'CAM', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24328', 'CAM', '003', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24329', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24330', 'CAM', '011', '04', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24331', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24332', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24333', 'CAM', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24334', 'CAM', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24335', 'CAM', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24336', 'CAM', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24337', 'CAM', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24338', 'CAM', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24339', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24340', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24341', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24342', 'CAM', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24343', 'CAM', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24344', 'CAM', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24345', 'CAM', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24346', 'CAM', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24347', 'CAM', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24348', 'CAM', '011', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24349', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24350', 'CAM', '009', '05', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24351', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24352', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24353', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24354', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24355', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24356', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24357', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24358', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24359', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24360', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24361', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24362', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24363', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24364', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24365', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24366', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24367', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24368', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24369', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24370', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24371', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24372', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24373', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24374', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24375', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24376', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24377', 'CAM', '009', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24378', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24379', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24380', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24381', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24382', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24383', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24384', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24385', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24386', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24387', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24388', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24389', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24390', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24391', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24392', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24393', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24394', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24395', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24396', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24397', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24398', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24399', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24400', 'CAM', '004', '08', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24401', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24402', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24403', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24404', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24405', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24406', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24407', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24408', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24409', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24410', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24411', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24412', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24413', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24414', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24415', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24416', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24417', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24418', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24419', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24420', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24421', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24422', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24423', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24424', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24425', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24426', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24427', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24428', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24429', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24430', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24431', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24432', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24433', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24434', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24435', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24436', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24437', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24438', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24439', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24440', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24441', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24442', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24443', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24444', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24445', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24446', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24447', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24448', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24449', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24450', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24451', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24452', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24453', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24454', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24455', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24456', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24457', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24458', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24459', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24460', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24461', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24462', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24463', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24464', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24465', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24466', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24467', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24468', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24469', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24470', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24471', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24472', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24473', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24474', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24475', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24476', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24477', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24478', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24479', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24480', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24481', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24482', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24483', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24484', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24485', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24486', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24487', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24488', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24489', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24490', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24491', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24492', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24493', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24494', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24495', 'CAM', '004', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24496', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24497', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24498', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24499', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24500', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24501', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24502', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24503', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24504', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24505', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24506', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24507', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24508', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24509', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24510', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24511', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24512', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24513', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24514', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24515', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24516', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24517', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24518', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24519', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24520', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24521', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24522', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24523', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24524', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24525', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24526', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24527', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24528', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24529', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24530', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24531', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24532', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24533', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24534', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24535', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24536', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24537', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24538', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24539', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24540', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24541', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24542', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24543', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24544', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24545', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24546', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24547', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24548', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24549', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24550', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24551', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24552', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24553', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24554', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24555', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24556', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24557', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24558', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24559', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24560', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24561', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24562', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24563', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24564', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24565', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24566', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24567', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24568', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24569', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24570', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24571', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24572', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24573', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24574', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24575', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24576', 'CAM', '002', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24577', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24578', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24579', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24580', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24581', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24582', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24583', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24584', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24585', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24586', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24587', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24588', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24589', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24590', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24591', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24592', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24593', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24594', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24595', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24596', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24597', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24598', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24599', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24600', 'CAM', '006', '07', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24601', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24602', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24603', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24604', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24605', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24606', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24607', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24608', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24609', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24610', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24611', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24612', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24613', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24614', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24615', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24616', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24617', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24618', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24619', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24620', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24621', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24622', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24623', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24624', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24625', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24626', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24627', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24628', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24629', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24630', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24631', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24632', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24633', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24634', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24635', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24636', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24637', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24638', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24639', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24640', 'CAM', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24641', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24642', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24643', 'CAM', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24644', 'CAM', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24645', 'CAM', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24646', 'CAM', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24647', 'CAM', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24648', 'CAM', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24649', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24650', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24651', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24652', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24653', 'CAM', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24654', 'CAM', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24655', 'CAM', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24656', 'CAM', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24657', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24658', 'CAM', '010', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24659', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24660', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24661', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24662', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24663', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24664', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24665', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24666', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24667', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24668', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24669', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24670', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24671', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24672', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24673', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24674', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24675', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24676', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24677', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24678', 'CAM', '006', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24679', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24680', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24681', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24682', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24683', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24684', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24685', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24686', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24687', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24688', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24689', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24690', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24691', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24692', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24693', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24694', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24695', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24696', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24697', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24698', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24699', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24700', 'CAM', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24701', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24702', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24703', 'CAM', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24704', 'CAM', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24705', 'CAM', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24706', 'CAM', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24707', 'CAM', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24708', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24709', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24710', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24711', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24712', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24713', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24714', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24715', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24716', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24717', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24718', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24719', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24720', 'CAM', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24721', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24722', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24723', 'CAM', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24724', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24725', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24726', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24727', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24728', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24729', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24730', 'CAM', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24731', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24732', 'CAM', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24733', 'CAM', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24734', 'CAM', '008', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24735', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24736', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24737', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24738', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24739', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24740', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24741', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24742', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24743', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24744', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24745', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24746', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24747', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24748', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24749', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24750', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24751', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24752', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24753', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24754', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24755', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24756', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24757', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24758', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24759', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24760', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24761', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24762', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24763', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24764', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24765', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24766', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24767', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24768', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24769', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24770', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24771', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24772', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24773', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24774', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24775', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24776', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24777', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24778', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24779', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24780', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24781', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24782', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24783', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24784', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24785', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24786', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24787', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24788', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24789', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24790', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24791', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24792', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24793', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24794', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24795', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24796', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24797', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24798', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24799', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24800', 'CAM', '005', '09', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24801', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24802', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24803', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24804', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24805', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24806', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24807', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24808', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24809', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24810', 'CAM', '005', '11', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24811', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24812', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24813', 'CAM', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24814', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24815', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24816', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24817', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24818', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24819', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24820', 'CAM', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24821', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24822', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24823', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24824', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24825', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24826', 'CAM', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24827', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24828', 'CAM', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24829', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24830', 'CAM', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24831', 'CAM', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24832', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24833', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24834', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24835', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24836', 'CAM', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24837', 'CAM', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24838', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24839', 'CAM', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24840', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24841', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24842', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24843', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24844', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24845', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24846', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24847', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24848', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24849', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24850', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24851', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24852', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24853', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24854', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24855', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24856', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24857', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24858', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24859', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24860', 'CAM', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24861', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24862', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24863', 'CAM', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24864', 'CAM', '005', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24865', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24866', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24867', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24868', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24869', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24870', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24871', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24872', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24873', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24874', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24875', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24876', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24877', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24878', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24879', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24880', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24881', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24882', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24883', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24884', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24885', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24886', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24887', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24888', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24889', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24890', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24891', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24892', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24893', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24894', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24895', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24896', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24897', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24898', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24899', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24900', 'CAM', '001', '03', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24901', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24902', 'CAM', '001', '03', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24903', 'CAM', '001', '03', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24904', 'CAM', '001', '03', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24905', 'CAM', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24906', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24907', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24908', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24909', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24910', 'CAM', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24911', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24912', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24913', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24914', 'CAM', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24915', 'CAM', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24916', 'CAM', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24917', 'CAM', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24918', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24919', 'CAM', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24920', 'CAM', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24921', 'CAM', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24922', 'CAM', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24923', 'CAM', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24924', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24925', 'CAM', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24926', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24927', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24928', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24929', 'CAM', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24930', 'CAM', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24931', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24932', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24933', 'CAM', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24934', 'CAM', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24935', 'CAM', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24936', 'CAM', '001', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24937', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24938', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24939', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24940', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24941', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24942', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24943', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24944', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24945', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24946', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24947', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24948', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24949', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24950', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24951', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24952', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24953', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24954', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24955', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24956', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24957', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24958', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24959', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24960', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24961', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24962', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24963', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24964', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24965', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24966', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24967', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24968', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24969', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24970', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24971', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24972', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24973', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24974', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24975', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24976', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24977', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24978', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24979', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24980', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24981', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24982', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24983', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24984', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24985', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24986', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24987', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24988', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24989', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24990', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24991', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24992', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24993', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24994', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24995', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24996', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24997', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24998', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '24999', 'CAM', '', '', '-5', '-6','0', '1'),
(null, now(), now(), null, null, '00000', 'CHH', '000', '00', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31000', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31001', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31002', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31003', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31004', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31005', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31006', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31007', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31008', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31009', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31010', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31011', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31012', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31013', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31014', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31015', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31016', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31017', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31018', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31019', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31020', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31021', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31022', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31023', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31024', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31025', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31026', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31027', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31028', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31029', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31030', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31031', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31032', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31033', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31034', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31035', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31036', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31037', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31038', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31039', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31040', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31041', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31042', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31043', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31044', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31045', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31046', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31047', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31048', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31049', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31050', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31051', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31052', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31053', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31054', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31055', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31056', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31057', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31058', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31059', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31060', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31061', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31062', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31063', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31064', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31065', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31066', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31067', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31068', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31069', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31070', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31071', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31072', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31073', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31074', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31075', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31076', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31077', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31078', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31079', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31080', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31081', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31082', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31083', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31084', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31085', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31086', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31087', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31088', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31089', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31090', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31091', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31092', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31093', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31094', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31095', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31096', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31097', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31098', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31099', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31100', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31101', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31102', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31103', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31104', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31105', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31106', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31107', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31108', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31109', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31110', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31111', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31112', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31113', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31114', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31115', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31116', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31117', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31118', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31119', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31120', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31121', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31122', 'CHH', '019', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31123', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31124', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31125', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31126', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31127', 'CHH', '019', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31128', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31129', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31130', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31131', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31132', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31133', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31134', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31135', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31136', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31137', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31138', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31139', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31140', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31141', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31142', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31143', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31144', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31145', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31146', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31147', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31148', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31149', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31150', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31151', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31152', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31153', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31154', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31155', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31156', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31157', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31158', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31159', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31160', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31161', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31162', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31163', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31164', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31165', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31166', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31167', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31168', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31169', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31170', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31171', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31172', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31173', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31174', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31175', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31176', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31177', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31178', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31179', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31180', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31181', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31182', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31183', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31184', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31185', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31186', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31187', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31188', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31189', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31190', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31191', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31192', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31193', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31194', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31195', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31196', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31197', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31198', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31199', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31200', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31201', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31202', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31203', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31204', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31205', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31206', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31207', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31208', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31209', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31210', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31211', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31212', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31213', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31214', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31215', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31216', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31217', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31218', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31219', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31220', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31221', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31222', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31223', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31224', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31225', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31226', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31227', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31228', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31229', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31230', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31231', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31232', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31233', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31234', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31235', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31236', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31237', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31238', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31239', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31240', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31241', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31242', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31243', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31244', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31245', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31246', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31247', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31248', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31249', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31250', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31251', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31252', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31253', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31254', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31255', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31256', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31257', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31258', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31259', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31260', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31261', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31262', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31263', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31264', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31265', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31266', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31267', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31268', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31269', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31270', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31271', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31272', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31273', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31274', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31275', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31276', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31277', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31278', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31279', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31280', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31281', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31282', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31283', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31284', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31285', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31286', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31287', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31288', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31289', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31290', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31291', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31292', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31293', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31294', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31295', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31296', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31297', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31298', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31299', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31300', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31301', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31302', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31303', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31304', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31305', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31306', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31307', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31308', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31309', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31310', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31311', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31312', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31313', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31314', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31315', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31316', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31317', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31318', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31319', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31320', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31321', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31322', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31323', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31324', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31325', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31326', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31327', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31328', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31329', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31330', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31331', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31332', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31333', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31334', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31335', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31336', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31337', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31338', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31339', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31340', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31341', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31342', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31343', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31344', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31345', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31346', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31347', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31348', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31349', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31350', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31351', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31352', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31353', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31354', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31355', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31356', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31357', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31358', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31359', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31360', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31361', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31362', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31363', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31364', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31365', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31366', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31367', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31368', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31369', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31370', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31371', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31372', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31373', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31374', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31375', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31376', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31377', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31378', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31379', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31380', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31381', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31382', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31383', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31384', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31385', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31386', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31387', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31388', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31389', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31390', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31391', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31392', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31393', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31394', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31395', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31396', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31397', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31398', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31399', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31400', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31401', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31402', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31403', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31404', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31405', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31406', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31407', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31408', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31409', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31410', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31411', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31412', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31413', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31414', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31415', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31416', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31417', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31418', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31419', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31420', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31421', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31422', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31423', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31424', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31425', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31426', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31427', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31428', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31429', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31430', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31431', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31432', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31433', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31434', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31435', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31436', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31437', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31438', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31439', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31440', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31441', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31442', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31443', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31444', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31445', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31446', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31447', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31448', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31449', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31450', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31451', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31452', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31453', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31454', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31455', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31456', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31457', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31458', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31459', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31460', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31461', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31462', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31463', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31464', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31465', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31466', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31467', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31468', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31469', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31470', 'CHH', '019', '02', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31471', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31472', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31473', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31474', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31475', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31476', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31477', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31478', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31479', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31480', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31481', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31482', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31483', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31484', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31485', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31486', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31487', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31488', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31489', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31490', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31491', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31492', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31493', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31494', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31495', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31496', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31497', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31498', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31499', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31500', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31501', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31502', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31503', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31504', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31505', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31506', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31507', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31508', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31509', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31510', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31511', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31512', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31513', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31514', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31515', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31516', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31517', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31518', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31519', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31520', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31521', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31522', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31523', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31524', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31525', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31526', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31527', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31528', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31529', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31530', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31531', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31532', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31533', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31534', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31535', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31536', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31537', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31538', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31539', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31540', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31541', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31542', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31543', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31544', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31545', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31546', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31547', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31548', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31549', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31550', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31551', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31552', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31553', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31554', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31555', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31556', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31557', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31558', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31559', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31560', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31561', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31562', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31563', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31564', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31565', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31566', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31567', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31568', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31569', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31570', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31571', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31572', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31573', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31574', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31575', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31576', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31577', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31578', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31579', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31580', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31581', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31582', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31583', 'CHH', '017', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31584', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31585', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31586', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31587', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31588', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31589', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31590', 'CHH', '017', '03', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31591', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31592', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31593', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31594', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31595', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31596', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31597', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31598', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31599', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31600', 'CHH', '017', '10', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31601', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31602', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31603', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31604', 'CHH', '017', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31605', 'CHH', '017', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31606', 'CHH', '017', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31607', 'CHH', '017', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31608', 'CHH', '017', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31609', 'CHH', '017', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31610', 'CHH', '017', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31611', 'CHH', '017', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31612', 'CHH', '017', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31613', 'CHH', '017', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31614', 'CHH', '017', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31615', 'CHH', '017', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31616', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31617', 'CHH', '017', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31618', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31619', 'CHH', '017', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31620', 'CHH', '019', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31621', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31622', 'CHH', '019', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31623', 'CHH', '019', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31624', 'CHH', '019', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31625', 'CHH', '019', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31626', 'CHH', '019', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31627', 'CHH', '019', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31628', 'CHH', '019', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31629', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31630', 'CHH', '019', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31631', 'CHH', '019', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31632', 'CHH', '019', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31633', 'CHH', '019', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31634', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31635', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31636', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31637', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31638', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31639', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31640', 'CHH', '054', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31641', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31642', 'CHH', '054', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31643', 'CHH', '054', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31644', 'CHH', '054', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31645', 'CHH', '054', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31646', 'CHH', '054', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31647', 'CHH', '054', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31648', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31649', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31650', 'CHH', '004', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31651', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31652', 'CHH', '004', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31653', 'CHH', '004', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31654', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31655', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31656', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31657', 'CHH', '004', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31658', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31659', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31660', 'CHH', '006', '14', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31661', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31662', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31663', 'CHH', '006', '14', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31664', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31665', 'CHH', '006', '14', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31666', 'CHH', '006', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31667', 'CHH', '006', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31668', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31669', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31670', 'CHH', '006', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31671', 'CHH', '006', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31672', 'CHH', '006', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31673', 'CHH', '006', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31674', 'CHH', '006', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31675', 'CHH', '006', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31676', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31677', 'CHH', '006', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31678', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31679', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31680', 'CHH', '031', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31681', 'CHH', '031', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31682', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31683', 'CHH', '031', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31684', 'CHH', '031', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31685', 'CHH', '031', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31686', 'CHH', '031', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31687', 'CHH', '031', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31688', 'CHH', '031', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31689', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31690', 'CHH', '031', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31691', 'CHH', '031', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31692', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31693', 'CHH', '031', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31694', 'CHH', '031', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31695', 'CHH', '031', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31696', 'CHH', '031', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31697', 'CHH', '031', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31698', 'CHH', '031', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31699', 'CHH', '031', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31700', 'CHH', '050', '07', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31701', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31702', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31703', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31704', 'CHH', '050', '07', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31705', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31706', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31707', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31708', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31709', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31710', 'CHH', '050', '07', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31711', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31712', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31713', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31714', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31715', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31716', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31717', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31718', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31719', 'CHH', '050', '07', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31720', 'CHH', '050', '07', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31721', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31722', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31723', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31724', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31725', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31726', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31727', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31728', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31729', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31730', 'CHH', '050', '07', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31731', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31732', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31733', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31734', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31735', 'CHH', '050', '07', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31736', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31737', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31738', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31739', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31740', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31741', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31742', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31743', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31744', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31745', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31746', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31747', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31748', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31749', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31750', 'CHH', '050', '07', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31751', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31752', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31753', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31754', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31755', 'CHH', '050', '07', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31756', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31757', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31758', 'CHH', '050', '07', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31759', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31760', 'CHH', '050', '07', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31761', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31762', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31763', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31764', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31765', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31766', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31767', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31768', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31769', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31770', 'CHH', '050', '07', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31771', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31772', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31773', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31774', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31775', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31776', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31777', 'CHH', '050', '07', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31778', 'CHH', '050', '07', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31779', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31780', 'CHH', '050', '07', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31781', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31782', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31783', 'CHH', '050', '07', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31784', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31785', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31786', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31787', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31788', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31789', 'CHH', '050', '07', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31790', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31791', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31792', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31793', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31794', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31795', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31796', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31797', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31798', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31799', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31800', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31801', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31802', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31803', 'CHH', '050', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31804', 'CHH', '050', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31805', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31806', 'CHH', '050', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31807', 'CHH', '050', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31808', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31809', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31810', 'CHH', '050', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31811', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31812', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31813', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31814', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31815', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31816', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31817', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31818', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31819', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31820', 'CHH', '005', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31821', 'CHH', '005', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31822', 'CHH', '005', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31823', 'CHH', '005', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31824', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31825', 'CHH', '005', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31826', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31827', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31828', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31829', 'CHH', '005', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31830', 'CHH', '005', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31831', 'CHH', '005', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31832', 'CHH', '005', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31833', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31834', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31835', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31836', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31837', 'CHH', '005', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31838', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31839', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31840', 'CHH', '035', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31841', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31842', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31843', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31844', 'CHH', '035', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31845', 'CHH', '035', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31846', 'CHH', '035', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31847', 'CHH', '035', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31848', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31849', 'CHH', '035', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31850', 'CHH', '013', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31851', 'CHH', '013', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31852', 'CHH', '013', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31853', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31854', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31855', 'CHH', '013', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31856', 'CHH', '013', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31857', 'CHH', '013', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31858', 'CHH', '013', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31859', 'CHH', '013', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31860', 'CHH', '013', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31861', 'CHH', '013', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31862', 'CHH', '013', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31863', 'CHH', '013', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31864', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31865', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31866', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31867', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31868', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31869', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31870', 'CHH', '023', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31871', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31872', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31873', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31874', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31875', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31876', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31877', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31878', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31879', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31880', 'CHH', '010', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31881', 'CHH', '010', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31882', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31883', 'CHH', '010', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31884', 'CHH', '010', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31885', 'CHH', '010', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31886', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31887', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31888', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31889', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31890', 'CHH', '010', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31891', 'CHH', '010', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31892', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31893', 'CHH', '010', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31894', 'CHH', '010', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31895', 'CHH', '010', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31896', 'CHH', '010', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31897', 'CHH', '010', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31898', 'CHH', '010', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31899', 'CHH', '010', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31900', 'CHH', '025', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31901', 'CHH', '025', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31902', 'CHH', '025', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31903', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31904', 'CHH', '025', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31905', 'CHH', '025', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31906', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31907', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31908', 'CHH', '025', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31909', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31910', 'CHH', '025', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31911', 'CHH', '025', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31912', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31913', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31914', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31915', 'CHH', '025', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31916', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31917', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31918', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31919', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31920', 'CHH', '034', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31921', 'CHH', '034', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31922', 'CHH', '034', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31923', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31924', 'CHH', '034', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31925', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31926', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31927', 'CHH', '034', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31928', 'CHH', '034', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31929', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31930', 'CHH', '034', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31931', 'CHH', '034', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31932', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31933', 'CHH', '034', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31934', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31935', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31936', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31937', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31938', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31939', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31940', 'CHH', '040', '09', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31941', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31942', 'CHH', '040', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31943', 'CHH', '040', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31944', 'CHH', '040', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31945', 'CHH', '040', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31946', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31947', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31948', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31949', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31950', 'CHH', '040', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31951', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31952', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31953', 'CHH', '040', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31954', 'CHH', '040', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31955', 'CHH', '040', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31956', 'CHH', '040', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31957', 'CHH', '040', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31958', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31959', 'CHH', '040', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31960', 'CHH', '048', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31961', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31962', 'CHH', '048', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31963', 'CHH', '048', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31964', 'CHH', '048', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31965', 'CHH', '048', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31966', 'CHH', '048', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31967', 'CHH', '048', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31968', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31969', 'CHH', '048', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31970', 'CHH', '048', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31971', 'CHH', '048', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31972', 'CHH', '048', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31973', 'CHH', '048', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31974', 'CHH', '048', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31975', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31976', 'CHH', '048', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31977', 'CHH', '048', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31978', 'CHH', '048', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31979', 'CHH', '048', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31980', 'CHH', '063', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31981', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31982', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31983', 'CHH', '063', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31984', 'CHH', '063', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31985', 'CHH', '063', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31986', 'CHH', '063', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31987', 'CHH', '063', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31988', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31989', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31990', 'CHH', '043', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31991', 'CHH', '043', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31992', 'CHH', '043', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31993', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31994', 'CHH', '043', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31995', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31996', 'CHH', '043', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31997', 'CHH', '043', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31998', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '31999', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32000', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32001', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32002', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32003', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32004', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32005', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32006', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32007', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32008', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32009', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32010', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32011', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32012', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32013', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32014', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32015', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32016', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32017', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32018', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32019', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32020', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32021', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32022', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32023', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32024', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32025', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32026', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32027', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32028', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32029', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32030', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32031', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32032', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32033', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32034', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32035', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32036', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32037', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32038', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32039', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32040', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32041', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32042', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32043', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32044', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32045', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32046', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32047', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32048', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32049', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32050', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32051', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32052', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32053', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32054', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32055', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32056', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32057', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32058', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32059', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32060', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32061', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32062', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32063', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32064', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32065', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32066', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32067', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32068', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32069', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32070', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32071', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32072', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32073', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32074', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32075', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32076', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32077', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32078', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32079', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32080', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32081', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32082', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32083', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32084', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32085', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32086', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32087', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32088', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32089', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32090', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32091', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32092', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32093', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32094', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32095', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32096', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32097', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32098', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32099', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32100', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32101', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32102', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32103', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32104', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32105', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32106', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32107', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32108', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32109', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32110', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32111', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32112', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32113', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32114', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32115', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32116', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32117', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32118', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32119', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32120', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32121', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32122', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32123', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32124', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32125', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32126', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32127', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32128', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32129', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32130', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32131', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32132', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32133', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32134', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32135', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32136', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32137', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32138', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32139', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32140', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32141', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32142', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32143', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32144', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32145', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32146', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32147', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32148', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32149', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32150', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32151', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32152', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32153', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32154', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32155', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32156', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32157', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32158', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32159', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32160', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32161', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32162', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32163', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32164', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32165', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32166', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32167', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32168', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32169', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32170', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32171', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32172', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32173', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32174', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32175', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32176', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32177', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32178', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32179', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32180', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32181', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32182', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32183', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32184', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32185', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32186', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32187', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32188', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32189', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32190', 'CHH', '037', '06', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32191', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32192', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32193', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32194', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32195', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32196', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32197', 'CHH', '', '', '-6', '-7','0', '1'),
(null, now(), now(), null, null, '32